from __future__ import annotations
from win32more.winrt.prelude import *
import win32more.Windows.ApplicationModel
import win32more.Windows.Foundation
import win32more.Windows.Foundation.Collections
import win32more.Windows.Management.Deployment
class AddPackageByAppInstallerOptions(Enum, UInt32):
    None_ = 0
    InstallAllResources = 32
    ForceTargetAppShutdown = 64
    RequiredContentGroupOnly = 256
    LimitToExistingPackages = 512
class AddPackageOptions(ComPtr):
    extends: IInspectable
    default_interface: win32more.Windows.Management.Deployment.IAddPackageOptions
    _classid_ = 'Windows.Management.Deployment.AddPackageOptions'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 0:
            super().__init__(move=win32more.Windows.Management.Deployment.AddPackageOptions.CreateInstance(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_activatemethod
    def CreateInstance(cls) -> win32more.Windows.Management.Deployment.AddPackageOptions: ...
    @winrt_mixinmethod
    def get_DependencyPackageUris(self: win32more.Windows.Management.Deployment.IAddPackageOptions) -> win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Foundation.Uri]: ...
    @winrt_mixinmethod
    def get_TargetVolume(self: win32more.Windows.Management.Deployment.IAddPackageOptions) -> win32more.Windows.Management.Deployment.PackageVolume: ...
    @winrt_mixinmethod
    def put_TargetVolume(self: win32more.Windows.Management.Deployment.IAddPackageOptions, value: win32more.Windows.Management.Deployment.PackageVolume) -> Void: ...
    @winrt_mixinmethod
    def get_OptionalPackageFamilyNames(self: win32more.Windows.Management.Deployment.IAddPackageOptions) -> win32more.Windows.Foundation.Collections.IVector[WinRT_String]: ...
    @winrt_mixinmethod
    def get_OptionalPackageUris(self: win32more.Windows.Management.Deployment.IAddPackageOptions) -> win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Foundation.Uri]: ...
    @winrt_mixinmethod
    def get_RelatedPackageUris(self: win32more.Windows.Management.Deployment.IAddPackageOptions) -> win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Foundation.Uri]: ...
    @winrt_mixinmethod
    def get_ExternalLocationUri(self: win32more.Windows.Management.Deployment.IAddPackageOptions) -> win32more.Windows.Foundation.Uri: ...
    @winrt_mixinmethod
    def put_ExternalLocationUri(self: win32more.Windows.Management.Deployment.IAddPackageOptions, value: win32more.Windows.Foundation.Uri) -> Void: ...
    @winrt_mixinmethod
    def get_StubPackageOption(self: win32more.Windows.Management.Deployment.IAddPackageOptions) -> win32more.Windows.Management.Deployment.StubPackageOption: ...
    @winrt_mixinmethod
    def put_StubPackageOption(self: win32more.Windows.Management.Deployment.IAddPackageOptions, value: win32more.Windows.Management.Deployment.StubPackageOption) -> Void: ...
    @winrt_mixinmethod
    def get_DeveloperMode(self: win32more.Windows.Management.Deployment.IAddPackageOptions) -> Boolean: ...
    @winrt_mixinmethod
    def put_DeveloperMode(self: win32more.Windows.Management.Deployment.IAddPackageOptions, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_ForceAppShutdown(self: win32more.Windows.Management.Deployment.IAddPackageOptions) -> Boolean: ...
    @winrt_mixinmethod
    def put_ForceAppShutdown(self: win32more.Windows.Management.Deployment.IAddPackageOptions, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_ForceTargetAppShutdown(self: win32more.Windows.Management.Deployment.IAddPackageOptions) -> Boolean: ...
    @winrt_mixinmethod
    def put_ForceTargetAppShutdown(self: win32more.Windows.Management.Deployment.IAddPackageOptions, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_ForceUpdateFromAnyVersion(self: win32more.Windows.Management.Deployment.IAddPackageOptions) -> Boolean: ...
    @winrt_mixinmethod
    def put_ForceUpdateFromAnyVersion(self: win32more.Windows.Management.Deployment.IAddPackageOptions, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_InstallAllResources(self: win32more.Windows.Management.Deployment.IAddPackageOptions) -> Boolean: ...
    @winrt_mixinmethod
    def put_InstallAllResources(self: win32more.Windows.Management.Deployment.IAddPackageOptions, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_RequiredContentGroupOnly(self: win32more.Windows.Management.Deployment.IAddPackageOptions) -> Boolean: ...
    @winrt_mixinmethod
    def put_RequiredContentGroupOnly(self: win32more.Windows.Management.Deployment.IAddPackageOptions, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_RetainFilesOnFailure(self: win32more.Windows.Management.Deployment.IAddPackageOptions) -> Boolean: ...
    @winrt_mixinmethod
    def put_RetainFilesOnFailure(self: win32more.Windows.Management.Deployment.IAddPackageOptions, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_StageInPlace(self: win32more.Windows.Management.Deployment.IAddPackageOptions) -> Boolean: ...
    @winrt_mixinmethod
    def put_StageInPlace(self: win32more.Windows.Management.Deployment.IAddPackageOptions, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_AllowUnsigned(self: win32more.Windows.Management.Deployment.IAddPackageOptions) -> Boolean: ...
    @winrt_mixinmethod
    def put_AllowUnsigned(self: win32more.Windows.Management.Deployment.IAddPackageOptions, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_DeferRegistrationWhenPackagesAreInUse(self: win32more.Windows.Management.Deployment.IAddPackageOptions) -> Boolean: ...
    @winrt_mixinmethod
    def put_DeferRegistrationWhenPackagesAreInUse(self: win32more.Windows.Management.Deployment.IAddPackageOptions, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_ExpectedDigests(self: win32more.Windows.Management.Deployment.IAddPackageOptions2) -> win32more.Windows.Foundation.Collections.IMap[win32more.Windows.Foundation.Uri, WinRT_String]: ...
    @winrt_mixinmethod
    def get_LimitToExistingPackages(self: win32more.Windows.Management.Deployment.IAddPackageOptions2) -> Boolean: ...
    @winrt_mixinmethod
    def put_LimitToExistingPackages(self: win32more.Windows.Management.Deployment.IAddPackageOptions2, value: Boolean) -> Void: ...
    AllowUnsigned = property(get_AllowUnsigned, put_AllowUnsigned)
    DeferRegistrationWhenPackagesAreInUse = property(get_DeferRegistrationWhenPackagesAreInUse, put_DeferRegistrationWhenPackagesAreInUse)
    DependencyPackageUris = property(get_DependencyPackageUris, None)
    DeveloperMode = property(get_DeveloperMode, put_DeveloperMode)
    ExpectedDigests = property(get_ExpectedDigests, None)
    ExternalLocationUri = property(get_ExternalLocationUri, put_ExternalLocationUri)
    ForceAppShutdown = property(get_ForceAppShutdown, put_ForceAppShutdown)
    ForceTargetAppShutdown = property(get_ForceTargetAppShutdown, put_ForceTargetAppShutdown)
    ForceUpdateFromAnyVersion = property(get_ForceUpdateFromAnyVersion, put_ForceUpdateFromAnyVersion)
    InstallAllResources = property(get_InstallAllResources, put_InstallAllResources)
    LimitToExistingPackages = property(get_LimitToExistingPackages, put_LimitToExistingPackages)
    OptionalPackageFamilyNames = property(get_OptionalPackageFamilyNames, None)
    OptionalPackageUris = property(get_OptionalPackageUris, None)
    RelatedPackageUris = property(get_RelatedPackageUris, None)
    RequiredContentGroupOnly = property(get_RequiredContentGroupOnly, put_RequiredContentGroupOnly)
    RetainFilesOnFailure = property(get_RetainFilesOnFailure, put_RetainFilesOnFailure)
    StageInPlace = property(get_StageInPlace, put_StageInPlace)
    StubPackageOption = property(get_StubPackageOption, put_StubPackageOption)
    TargetVolume = property(get_TargetVolume, put_TargetVolume)
class AppInstallerManager(ComPtr):
    extends: IInspectable
    default_interface: win32more.Windows.Management.Deployment.IAppInstallerManager
    _classid_ = 'Windows.Management.Deployment.AppInstallerManager'
    @winrt_mixinmethod
    def SetAutoUpdateSettings(self: win32more.Windows.Management.Deployment.IAppInstallerManager, packageFamilyName: WinRT_String, appInstallerInfo: win32more.Windows.Management.Deployment.AutoUpdateSettingsOptions) -> Void: ...
    @winrt_mixinmethod
    def ClearAutoUpdateSettings(self: win32more.Windows.Management.Deployment.IAppInstallerManager, packageFamilyName: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def PauseAutoUpdatesUntil(self: win32more.Windows.Management.Deployment.IAppInstallerManager, packageFamilyName: WinRT_String, dateTime: win32more.Windows.Foundation.DateTime) -> Void: ...
    @winrt_classmethod
    def GetDefault(cls: win32more.Windows.Management.Deployment.IAppInstallerManagerStatics) -> win32more.Windows.Management.Deployment.AppInstallerManager: ...
    @winrt_classmethod
    def GetForSystem(cls: win32more.Windows.Management.Deployment.IAppInstallerManagerStatics) -> win32more.Windows.Management.Deployment.AppInstallerManager: ...
class AutoUpdateSettingsOptions(ComPtr):
    extends: IInspectable
    default_interface: win32more.Windows.Management.Deployment.IAutoUpdateSettingsOptions
    _classid_ = 'Windows.Management.Deployment.AutoUpdateSettingsOptions'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 0:
            super().__init__(move=win32more.Windows.Management.Deployment.AutoUpdateSettingsOptions.CreateInstance(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_activatemethod
    def CreateInstance(cls) -> win32more.Windows.Management.Deployment.AutoUpdateSettingsOptions: ...
    @winrt_mixinmethod
    def get_Version(self: win32more.Windows.Management.Deployment.IAutoUpdateSettingsOptions) -> win32more.Windows.ApplicationModel.PackageVersion: ...
    @winrt_mixinmethod
    def put_Version(self: win32more.Windows.Management.Deployment.IAutoUpdateSettingsOptions, value: win32more.Windows.ApplicationModel.PackageVersion) -> Void: ...
    @winrt_mixinmethod
    def get_AppInstallerUri(self: win32more.Windows.Management.Deployment.IAutoUpdateSettingsOptions) -> win32more.Windows.Foundation.Uri: ...
    @winrt_mixinmethod
    def put_AppInstallerUri(self: win32more.Windows.Management.Deployment.IAutoUpdateSettingsOptions, value: win32more.Windows.Foundation.Uri) -> Void: ...
    @winrt_mixinmethod
    def get_OnLaunch(self: win32more.Windows.Management.Deployment.IAutoUpdateSettingsOptions) -> Boolean: ...
    @winrt_mixinmethod
    def put_OnLaunch(self: win32more.Windows.Management.Deployment.IAutoUpdateSettingsOptions, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_HoursBetweenUpdateChecks(self: win32more.Windows.Management.Deployment.IAutoUpdateSettingsOptions) -> UInt32: ...
    @winrt_mixinmethod
    def put_HoursBetweenUpdateChecks(self: win32more.Windows.Management.Deployment.IAutoUpdateSettingsOptions, value: UInt32) -> Void: ...
    @winrt_mixinmethod
    def get_ShowPrompt(self: win32more.Windows.Management.Deployment.IAutoUpdateSettingsOptions) -> Boolean: ...
    @winrt_mixinmethod
    def put_ShowPrompt(self: win32more.Windows.Management.Deployment.IAutoUpdateSettingsOptions, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_UpdateBlocksActivation(self: win32more.Windows.Management.Deployment.IAutoUpdateSettingsOptions) -> Boolean: ...
    @winrt_mixinmethod
    def put_UpdateBlocksActivation(self: win32more.Windows.Management.Deployment.IAutoUpdateSettingsOptions, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_AutomaticBackgroundTask(self: win32more.Windows.Management.Deployment.IAutoUpdateSettingsOptions) -> Boolean: ...
    @winrt_mixinmethod
    def put_AutomaticBackgroundTask(self: win32more.Windows.Management.Deployment.IAutoUpdateSettingsOptions, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_ForceUpdateFromAnyVersion(self: win32more.Windows.Management.Deployment.IAutoUpdateSettingsOptions) -> Boolean: ...
    @winrt_mixinmethod
    def put_ForceUpdateFromAnyVersion(self: win32more.Windows.Management.Deployment.IAutoUpdateSettingsOptions, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_IsAutoRepairEnabled(self: win32more.Windows.Management.Deployment.IAutoUpdateSettingsOptions) -> Boolean: ...
    @winrt_mixinmethod
    def put_IsAutoRepairEnabled(self: win32more.Windows.Management.Deployment.IAutoUpdateSettingsOptions, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_UpdateUris(self: win32more.Windows.Management.Deployment.IAutoUpdateSettingsOptions) -> win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Foundation.Uri]: ...
    @winrt_mixinmethod
    def get_RepairUris(self: win32more.Windows.Management.Deployment.IAutoUpdateSettingsOptions) -> win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Foundation.Uri]: ...
    @winrt_mixinmethod
    def get_DependencyPackageUris(self: win32more.Windows.Management.Deployment.IAutoUpdateSettingsOptions) -> win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Foundation.Uri]: ...
    @winrt_mixinmethod
    def get_OptionalPackageUris(self: win32more.Windows.Management.Deployment.IAutoUpdateSettingsOptions) -> win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Foundation.Uri]: ...
    @winrt_classmethod
    def CreateFromAppInstallerInfo(cls: win32more.Windows.Management.Deployment.IAutoUpdateSettingsOptionsStatics, appInstallerInfo: win32more.Windows.ApplicationModel.AppInstallerInfo) -> win32more.Windows.Management.Deployment.AutoUpdateSettingsOptions: ...
    AppInstallerUri = property(get_AppInstallerUri, put_AppInstallerUri)
    AutomaticBackgroundTask = property(get_AutomaticBackgroundTask, put_AutomaticBackgroundTask)
    DependencyPackageUris = property(get_DependencyPackageUris, None)
    ForceUpdateFromAnyVersion = property(get_ForceUpdateFromAnyVersion, put_ForceUpdateFromAnyVersion)
    HoursBetweenUpdateChecks = property(get_HoursBetweenUpdateChecks, put_HoursBetweenUpdateChecks)
    IsAutoRepairEnabled = property(get_IsAutoRepairEnabled, put_IsAutoRepairEnabled)
    OnLaunch = property(get_OnLaunch, put_OnLaunch)
    OptionalPackageUris = property(get_OptionalPackageUris, None)
    RepairUris = property(get_RepairUris, None)
    ShowPrompt = property(get_ShowPrompt, put_ShowPrompt)
    UpdateBlocksActivation = property(get_UpdateBlocksActivation, put_UpdateBlocksActivation)
    UpdateUris = property(get_UpdateUris, None)
    Version = property(get_Version, put_Version)
class CreateSharedPackageContainerOptions(ComPtr):
    extends: IInspectable
    default_interface: win32more.Windows.Management.Deployment.ICreateSharedPackageContainerOptions
    _classid_ = 'Windows.Management.Deployment.CreateSharedPackageContainerOptions'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 0:
            super().__init__(move=win32more.Windows.Management.Deployment.CreateSharedPackageContainerOptions.CreateInstance(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_activatemethod
    def CreateInstance(cls) -> win32more.Windows.Management.Deployment.CreateSharedPackageContainerOptions: ...
    @winrt_mixinmethod
    def get_Members(self: win32more.Windows.Management.Deployment.ICreateSharedPackageContainerOptions) -> win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Management.Deployment.SharedPackageContainerMember]: ...
    @winrt_mixinmethod
    def get_ForceAppShutdown(self: win32more.Windows.Management.Deployment.ICreateSharedPackageContainerOptions) -> Boolean: ...
    @winrt_mixinmethod
    def put_ForceAppShutdown(self: win32more.Windows.Management.Deployment.ICreateSharedPackageContainerOptions, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_CreateCollisionOption(self: win32more.Windows.Management.Deployment.ICreateSharedPackageContainerOptions) -> win32more.Windows.Management.Deployment.SharedPackageContainerCreationCollisionOptions: ...
    @winrt_mixinmethod
    def put_CreateCollisionOption(self: win32more.Windows.Management.Deployment.ICreateSharedPackageContainerOptions, value: win32more.Windows.Management.Deployment.SharedPackageContainerCreationCollisionOptions) -> Void: ...
    CreateCollisionOption = property(get_CreateCollisionOption, put_CreateCollisionOption)
    ForceAppShutdown = property(get_ForceAppShutdown, put_ForceAppShutdown)
    Members = property(get_Members, None)
class CreateSharedPackageContainerResult(ComPtr):
    extends: IInspectable
    default_interface: win32more.Windows.Management.Deployment.ICreateSharedPackageContainerResult
    _classid_ = 'Windows.Management.Deployment.CreateSharedPackageContainerResult'
    @winrt_mixinmethod
    def get_Container(self: win32more.Windows.Management.Deployment.ICreateSharedPackageContainerResult) -> win32more.Windows.Management.Deployment.SharedPackageContainer: ...
    @winrt_mixinmethod
    def get_Status(self: win32more.Windows.Management.Deployment.ICreateSharedPackageContainerResult) -> win32more.Windows.Management.Deployment.SharedPackageContainerOperationStatus: ...
    @winrt_mixinmethod
    def get_ExtendedError(self: win32more.Windows.Management.Deployment.ICreateSharedPackageContainerResult) -> win32more.Windows.Foundation.HResult: ...
    Container = property(get_Container, None)
    ExtendedError = property(get_ExtendedError, None)
    Status = property(get_Status, None)
class DeleteSharedPackageContainerOptions(ComPtr):
    extends: IInspectable
    default_interface: win32more.Windows.Management.Deployment.IDeleteSharedPackageContainerOptions
    _classid_ = 'Windows.Management.Deployment.DeleteSharedPackageContainerOptions'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 0:
            super().__init__(move=win32more.Windows.Management.Deployment.DeleteSharedPackageContainerOptions.CreateInstance(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_activatemethod
    def CreateInstance(cls) -> win32more.Windows.Management.Deployment.DeleteSharedPackageContainerOptions: ...
    @winrt_mixinmethod
    def get_ForceAppShutdown(self: win32more.Windows.Management.Deployment.IDeleteSharedPackageContainerOptions) -> Boolean: ...
    @winrt_mixinmethod
    def put_ForceAppShutdown(self: win32more.Windows.Management.Deployment.IDeleteSharedPackageContainerOptions, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_AllUsers(self: win32more.Windows.Management.Deployment.IDeleteSharedPackageContainerOptions) -> Boolean: ...
    @winrt_mixinmethod
    def put_AllUsers(self: win32more.Windows.Management.Deployment.IDeleteSharedPackageContainerOptions, value: Boolean) -> Void: ...
    AllUsers = property(get_AllUsers, put_AllUsers)
    ForceAppShutdown = property(get_ForceAppShutdown, put_ForceAppShutdown)
class DeleteSharedPackageContainerResult(ComPtr):
    extends: IInspectable
    default_interface: win32more.Windows.Management.Deployment.IDeleteSharedPackageContainerResult
    _classid_ = 'Windows.Management.Deployment.DeleteSharedPackageContainerResult'
    @winrt_mixinmethod
    def get_Status(self: win32more.Windows.Management.Deployment.IDeleteSharedPackageContainerResult) -> win32more.Windows.Management.Deployment.SharedPackageContainerOperationStatus: ...
    @winrt_mixinmethod
    def get_ExtendedError(self: win32more.Windows.Management.Deployment.IDeleteSharedPackageContainerResult) -> win32more.Windows.Foundation.HResult: ...
    ExtendedError = property(get_ExtendedError, None)
    Status = property(get_Status, None)
class DeploymentOptions(Enum, UInt32):
    None_ = 0
    ForceApplicationShutdown = 1
    DevelopmentMode = 2
    InstallAllResources = 32
    ForceTargetApplicationShutdown = 64
    RequiredContentGroupOnly = 256
    ForceUpdateFromAnyVersion = 262144
    RetainFilesOnFailure = 2097152
    StageInPlace = 4194304
class DeploymentProgress(Structure):
    state: win32more.Windows.Management.Deployment.DeploymentProgressState
    percentage: UInt32
class DeploymentProgressState(Enum, Int32):
    Queued = 0
    Processing = 1
class DeploymentResult(ComPtr):
    extends: IInspectable
    default_interface: win32more.Windows.Management.Deployment.IDeploymentResult
    _classid_ = 'Windows.Management.Deployment.DeploymentResult'
    @winrt_mixinmethod
    def get_ErrorText(self: win32more.Windows.Management.Deployment.IDeploymentResult) -> WinRT_String: ...
    @winrt_mixinmethod
    def get_ActivityId(self: win32more.Windows.Management.Deployment.IDeploymentResult) -> Guid: ...
    @winrt_mixinmethod
    def get_ExtendedErrorCode(self: win32more.Windows.Management.Deployment.IDeploymentResult) -> win32more.Windows.Foundation.HResult: ...
    @winrt_mixinmethod
    def get_IsRegistered(self: win32more.Windows.Management.Deployment.IDeploymentResult2) -> Boolean: ...
    ActivityId = property(get_ActivityId, None)
    ErrorText = property(get_ErrorText, None)
    ExtendedErrorCode = property(get_ExtendedErrorCode, None)
    IsRegistered = property(get_IsRegistered, None)
class FindSharedPackageContainerOptions(ComPtr):
    extends: IInspectable
    default_interface: win32more.Windows.Management.Deployment.IFindSharedPackageContainerOptions
    _classid_ = 'Windows.Management.Deployment.FindSharedPackageContainerOptions'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 0:
            super().__init__(move=win32more.Windows.Management.Deployment.FindSharedPackageContainerOptions.CreateInstance(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_activatemethod
    def CreateInstance(cls) -> win32more.Windows.Management.Deployment.FindSharedPackageContainerOptions: ...
    @winrt_mixinmethod
    def get_Name(self: win32more.Windows.Management.Deployment.IFindSharedPackageContainerOptions) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_Name(self: win32more.Windows.Management.Deployment.IFindSharedPackageContainerOptions, value: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def get_PackageFamilyName(self: win32more.Windows.Management.Deployment.IFindSharedPackageContainerOptions) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_PackageFamilyName(self: win32more.Windows.Management.Deployment.IFindSharedPackageContainerOptions, value: WinRT_String) -> Void: ...
    Name = property(get_Name, put_Name)
    PackageFamilyName = property(get_PackageFamilyName, put_PackageFamilyName)
class IAddPackageOptions(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Management.Deployment.IAddPackageOptions'
    _iid_ = Guid('{05cee018-f68f-422b-95a4-66679ec77fc0}')
    @winrt_commethod(6)
    def get_DependencyPackageUris(self) -> win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Foundation.Uri]: ...
    @winrt_commethod(7)
    def get_TargetVolume(self) -> win32more.Windows.Management.Deployment.PackageVolume: ...
    @winrt_commethod(8)
    def put_TargetVolume(self, value: win32more.Windows.Management.Deployment.PackageVolume) -> Void: ...
    @winrt_commethod(9)
    def get_OptionalPackageFamilyNames(self) -> win32more.Windows.Foundation.Collections.IVector[WinRT_String]: ...
    @winrt_commethod(10)
    def get_OptionalPackageUris(self) -> win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Foundation.Uri]: ...
    @winrt_commethod(11)
    def get_RelatedPackageUris(self) -> win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Foundation.Uri]: ...
    @winrt_commethod(12)
    def get_ExternalLocationUri(self) -> win32more.Windows.Foundation.Uri: ...
    @winrt_commethod(13)
    def put_ExternalLocationUri(self, value: win32more.Windows.Foundation.Uri) -> Void: ...
    @winrt_commethod(14)
    def get_StubPackageOption(self) -> win32more.Windows.Management.Deployment.StubPackageOption: ...
    @winrt_commethod(15)
    def put_StubPackageOption(self, value: win32more.Windows.Management.Deployment.StubPackageOption) -> Void: ...
    @winrt_commethod(16)
    def get_DeveloperMode(self) -> Boolean: ...
    @winrt_commethod(17)
    def put_DeveloperMode(self, value: Boolean) -> Void: ...
    @winrt_commethod(18)
    def get_ForceAppShutdown(self) -> Boolean: ...
    @winrt_commethod(19)
    def put_ForceAppShutdown(self, value: Boolean) -> Void: ...
    @winrt_commethod(20)
    def get_ForceTargetAppShutdown(self) -> Boolean: ...
    @winrt_commethod(21)
    def put_ForceTargetAppShutdown(self, value: Boolean) -> Void: ...
    @winrt_commethod(22)
    def get_ForceUpdateFromAnyVersion(self) -> Boolean: ...
    @winrt_commethod(23)
    def put_ForceUpdateFromAnyVersion(self, value: Boolean) -> Void: ...
    @winrt_commethod(24)
    def get_InstallAllResources(self) -> Boolean: ...
    @winrt_commethod(25)
    def put_InstallAllResources(self, value: Boolean) -> Void: ...
    @winrt_commethod(26)
    def get_RequiredContentGroupOnly(self) -> Boolean: ...
    @winrt_commethod(27)
    def put_RequiredContentGroupOnly(self, value: Boolean) -> Void: ...
    @winrt_commethod(28)
    def get_RetainFilesOnFailure(self) -> Boolean: ...
    @winrt_commethod(29)
    def put_RetainFilesOnFailure(self, value: Boolean) -> Void: ...
    @winrt_commethod(30)
    def get_StageInPlace(self) -> Boolean: ...
    @winrt_commethod(31)
    def put_StageInPlace(self, value: Boolean) -> Void: ...
    @winrt_commethod(32)
    def get_AllowUnsigned(self) -> Boolean: ...
    @winrt_commethod(33)
    def put_AllowUnsigned(self, value: Boolean) -> Void: ...
    @winrt_commethod(34)
    def get_DeferRegistrationWhenPackagesAreInUse(self) -> Boolean: ...
    @winrt_commethod(35)
    def put_DeferRegistrationWhenPackagesAreInUse(self, value: Boolean) -> Void: ...
    AllowUnsigned = property(get_AllowUnsigned, put_AllowUnsigned)
    DeferRegistrationWhenPackagesAreInUse = property(get_DeferRegistrationWhenPackagesAreInUse, put_DeferRegistrationWhenPackagesAreInUse)
    DependencyPackageUris = property(get_DependencyPackageUris, None)
    DeveloperMode = property(get_DeveloperMode, put_DeveloperMode)
    ExternalLocationUri = property(get_ExternalLocationUri, put_ExternalLocationUri)
    ForceAppShutdown = property(get_ForceAppShutdown, put_ForceAppShutdown)
    ForceTargetAppShutdown = property(get_ForceTargetAppShutdown, put_ForceTargetAppShutdown)
    ForceUpdateFromAnyVersion = property(get_ForceUpdateFromAnyVersion, put_ForceUpdateFromAnyVersion)
    InstallAllResources = property(get_InstallAllResources, put_InstallAllResources)
    OptionalPackageFamilyNames = property(get_OptionalPackageFamilyNames, None)
    OptionalPackageUris = property(get_OptionalPackageUris, None)
    RelatedPackageUris = property(get_RelatedPackageUris, None)
    RequiredContentGroupOnly = property(get_RequiredContentGroupOnly, put_RequiredContentGroupOnly)
    RetainFilesOnFailure = property(get_RetainFilesOnFailure, put_RetainFilesOnFailure)
    StageInPlace = property(get_StageInPlace, put_StageInPlace)
    StubPackageOption = property(get_StubPackageOption, put_StubPackageOption)
    TargetVolume = property(get_TargetVolume, put_TargetVolume)
class IAddPackageOptions2(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Management.Deployment.IAddPackageOptions2'
    _iid_ = Guid('{ee515828-bf33-40f7-84af-1b6fad2919d7}')
    @winrt_commethod(6)
    def get_ExpectedDigests(self) -> win32more.Windows.Foundation.Collections.IMap[win32more.Windows.Foundation.Uri, WinRT_String]: ...
    @winrt_commethod(7)
    def get_LimitToExistingPackages(self) -> Boolean: ...
    @winrt_commethod(8)
    def put_LimitToExistingPackages(self, value: Boolean) -> Void: ...
    ExpectedDigests = property(get_ExpectedDigests, None)
    LimitToExistingPackages = property(get_LimitToExistingPackages, put_LimitToExistingPackages)
class IAppInstallerManager(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Management.Deployment.IAppInstallerManager'
    _iid_ = Guid('{e7ee21c3-2103-53ee-9b18-68afeab0033d}')
    @winrt_commethod(6)
    def SetAutoUpdateSettings(self, packageFamilyName: WinRT_String, appInstallerInfo: win32more.Windows.Management.Deployment.AutoUpdateSettingsOptions) -> Void: ...
    @winrt_commethod(7)
    def ClearAutoUpdateSettings(self, packageFamilyName: WinRT_String) -> Void: ...
    @winrt_commethod(8)
    def PauseAutoUpdatesUntil(self, packageFamilyName: WinRT_String, dateTime: win32more.Windows.Foundation.DateTime) -> Void: ...
class IAppInstallerManagerStatics(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Management.Deployment.IAppInstallerManagerStatics'
    _iid_ = Guid('{c95a6ed5-fc59-5336-9b2e-2b07c5e61434}')
    @winrt_commethod(6)
    def GetDefault(self) -> win32more.Windows.Management.Deployment.AppInstallerManager: ...
    @winrt_commethod(7)
    def GetForSystem(self) -> win32more.Windows.Management.Deployment.AppInstallerManager: ...
class IAutoUpdateSettingsOptions(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Management.Deployment.IAutoUpdateSettingsOptions'
    _iid_ = Guid('{67491d87-35e1-512a-8968-1ae88d1be6d3}')
    @winrt_commethod(6)
    def get_Version(self) -> win32more.Windows.ApplicationModel.PackageVersion: ...
    @winrt_commethod(7)
    def put_Version(self, value: win32more.Windows.ApplicationModel.PackageVersion) -> Void: ...
    @winrt_commethod(8)
    def get_AppInstallerUri(self) -> win32more.Windows.Foundation.Uri: ...
    @winrt_commethod(9)
    def put_AppInstallerUri(self, value: win32more.Windows.Foundation.Uri) -> Void: ...
    @winrt_commethod(10)
    def get_OnLaunch(self) -> Boolean: ...
    @winrt_commethod(11)
    def put_OnLaunch(self, value: Boolean) -> Void: ...
    @winrt_commethod(12)
    def get_HoursBetweenUpdateChecks(self) -> UInt32: ...
    @winrt_commethod(13)
    def put_HoursBetweenUpdateChecks(self, value: UInt32) -> Void: ...
    @winrt_commethod(14)
    def get_ShowPrompt(self) -> Boolean: ...
    @winrt_commethod(15)
    def put_ShowPrompt(self, value: Boolean) -> Void: ...
    @winrt_commethod(16)
    def get_UpdateBlocksActivation(self) -> Boolean: ...
    @winrt_commethod(17)
    def put_UpdateBlocksActivation(self, value: Boolean) -> Void: ...
    @winrt_commethod(18)
    def get_AutomaticBackgroundTask(self) -> Boolean: ...
    @winrt_commethod(19)
    def put_AutomaticBackgroundTask(self, value: Boolean) -> Void: ...
    @winrt_commethod(20)
    def get_ForceUpdateFromAnyVersion(self) -> Boolean: ...
    @winrt_commethod(21)
    def put_ForceUpdateFromAnyVersion(self, value: Boolean) -> Void: ...
    @winrt_commethod(22)
    def get_IsAutoRepairEnabled(self) -> Boolean: ...
    @winrt_commethod(23)
    def put_IsAutoRepairEnabled(self, value: Boolean) -> Void: ...
    @winrt_commethod(24)
    def get_UpdateUris(self) -> win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Foundation.Uri]: ...
    @winrt_commethod(25)
    def get_RepairUris(self) -> win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Foundation.Uri]: ...
    @winrt_commethod(26)
    def get_DependencyPackageUris(self) -> win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Foundation.Uri]: ...
    @winrt_commethod(27)
    def get_OptionalPackageUris(self) -> win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Foundation.Uri]: ...
    AppInstallerUri = property(get_AppInstallerUri, put_AppInstallerUri)
    AutomaticBackgroundTask = property(get_AutomaticBackgroundTask, put_AutomaticBackgroundTask)
    DependencyPackageUris = property(get_DependencyPackageUris, None)
    ForceUpdateFromAnyVersion = property(get_ForceUpdateFromAnyVersion, put_ForceUpdateFromAnyVersion)
    HoursBetweenUpdateChecks = property(get_HoursBetweenUpdateChecks, put_HoursBetweenUpdateChecks)
    IsAutoRepairEnabled = property(get_IsAutoRepairEnabled, put_IsAutoRepairEnabled)
    OnLaunch = property(get_OnLaunch, put_OnLaunch)
    OptionalPackageUris = property(get_OptionalPackageUris, None)
    RepairUris = property(get_RepairUris, None)
    ShowPrompt = property(get_ShowPrompt, put_ShowPrompt)
    UpdateBlocksActivation = property(get_UpdateBlocksActivation, put_UpdateBlocksActivation)
    UpdateUris = property(get_UpdateUris, None)
    Version = property(get_Version, put_Version)
class IAutoUpdateSettingsOptionsStatics(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Management.Deployment.IAutoUpdateSettingsOptionsStatics'
    _iid_ = Guid('{887b337d-0c05-54d0-bd49-3bb7a2c084cb}')
    @winrt_commethod(6)
    def CreateFromAppInstallerInfo(self, appInstallerInfo: win32more.Windows.ApplicationModel.AppInstallerInfo) -> win32more.Windows.Management.Deployment.AutoUpdateSettingsOptions: ...
class ICreateSharedPackageContainerOptions(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Management.Deployment.ICreateSharedPackageContainerOptions'
    _iid_ = Guid('{c2ab6ece-f664-5c8e-a4b3-2a33276d3dde}')
    @winrt_commethod(6)
    def get_Members(self) -> win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Management.Deployment.SharedPackageContainerMember]: ...
    @winrt_commethod(7)
    def get_ForceAppShutdown(self) -> Boolean: ...
    @winrt_commethod(8)
    def put_ForceAppShutdown(self, value: Boolean) -> Void: ...
    @winrt_commethod(9)
    def get_CreateCollisionOption(self) -> win32more.Windows.Management.Deployment.SharedPackageContainerCreationCollisionOptions: ...
    @winrt_commethod(10)
    def put_CreateCollisionOption(self, value: win32more.Windows.Management.Deployment.SharedPackageContainerCreationCollisionOptions) -> Void: ...
    CreateCollisionOption = property(get_CreateCollisionOption, put_CreateCollisionOption)
    ForceAppShutdown = property(get_ForceAppShutdown, put_ForceAppShutdown)
    Members = property(get_Members, None)
class ICreateSharedPackageContainerResult(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Management.Deployment.ICreateSharedPackageContainerResult'
    _iid_ = Guid('{ce8810bf-151c-5707-b936-497e564afc7a}')
    @winrt_commethod(6)
    def get_Container(self) -> win32more.Windows.Management.Deployment.SharedPackageContainer: ...
    @winrt_commethod(7)
    def get_Status(self) -> win32more.Windows.Management.Deployment.SharedPackageContainerOperationStatus: ...
    @winrt_commethod(8)
    def get_ExtendedError(self) -> win32more.Windows.Foundation.HResult: ...
    Container = property(get_Container, None)
    ExtendedError = property(get_ExtendedError, None)
    Status = property(get_Status, None)
class IDeleteSharedPackageContainerOptions(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Management.Deployment.IDeleteSharedPackageContainerOptions'
    _iid_ = Guid('{9d81865f-986e-5138-8b5d-384d8e66ed6c}')
    @winrt_commethod(6)
    def get_ForceAppShutdown(self) -> Boolean: ...
    @winrt_commethod(7)
    def put_ForceAppShutdown(self, value: Boolean) -> Void: ...
    @winrt_commethod(8)
    def get_AllUsers(self) -> Boolean: ...
    @winrt_commethod(9)
    def put_AllUsers(self, value: Boolean) -> Void: ...
    AllUsers = property(get_AllUsers, put_AllUsers)
    ForceAppShutdown = property(get_ForceAppShutdown, put_ForceAppShutdown)
class IDeleteSharedPackageContainerResult(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Management.Deployment.IDeleteSharedPackageContainerResult'
    _iid_ = Guid('{35398884-5736-517b-85bc-e598c81ab284}')
    @winrt_commethod(6)
    def get_Status(self) -> win32more.Windows.Management.Deployment.SharedPackageContainerOperationStatus: ...
    @winrt_commethod(7)
    def get_ExtendedError(self) -> win32more.Windows.Foundation.HResult: ...
    ExtendedError = property(get_ExtendedError, None)
    Status = property(get_Status, None)
class IDeploymentResult(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Management.Deployment.IDeploymentResult'
    _iid_ = Guid('{2563b9ae-b77d-4c1f-8a7b-20e6ad515ef3}')
    @winrt_commethod(6)
    def get_ErrorText(self) -> WinRT_String: ...
    @winrt_commethod(7)
    def get_ActivityId(self) -> Guid: ...
    @winrt_commethod(8)
    def get_ExtendedErrorCode(self) -> win32more.Windows.Foundation.HResult: ...
    ActivityId = property(get_ActivityId, None)
    ErrorText = property(get_ErrorText, None)
    ExtendedErrorCode = property(get_ExtendedErrorCode, None)
class IDeploymentResult2(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Management.Deployment.IDeploymentResult2'
    _iid_ = Guid('{fc0e715c-5a01-4bd7-bcf1-381c8c82e04a}')
    @winrt_commethod(6)
    def get_IsRegistered(self) -> Boolean: ...
    IsRegistered = property(get_IsRegistered, None)
class IFindSharedPackageContainerOptions(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Management.Deployment.IFindSharedPackageContainerOptions'
    _iid_ = Guid('{b40fc8fe-8384-54cc-817d-ae09d3b6a606}')
    @winrt_commethod(6)
    def get_Name(self) -> WinRT_String: ...
    @winrt_commethod(7)
    def put_Name(self, value: WinRT_String) -> Void: ...
    @winrt_commethod(8)
    def get_PackageFamilyName(self) -> WinRT_String: ...
    @winrt_commethod(9)
    def put_PackageFamilyName(self, value: WinRT_String) -> Void: ...
    Name = property(get_Name, put_Name)
    PackageFamilyName = property(get_PackageFamilyName, put_PackageFamilyName)
class IPackageAllUserProvisioningOptions(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Management.Deployment.IPackageAllUserProvisioningOptions'
    _iid_ = Guid('{da35aa22-1de0-5d3e-99ff-d24f3118bf5e}')
    @winrt_commethod(6)
    def get_OptionalPackageFamilyNames(self) -> win32more.Windows.Foundation.Collections.IVector[WinRT_String]: ...
    @winrt_commethod(7)
    def get_ProjectionOrderPackageFamilyNames(self) -> win32more.Windows.Foundation.Collections.IVector[WinRT_String]: ...
    OptionalPackageFamilyNames = property(get_OptionalPackageFamilyNames, None)
    ProjectionOrderPackageFamilyNames = property(get_ProjectionOrderPackageFamilyNames, None)
class IPackageAllUserProvisioningOptions2(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Management.Deployment.IPackageAllUserProvisioningOptions2'
    _iid_ = Guid('{b9e3cab5-2d97-579f-9368-d10bb4d4542b}')
    @winrt_commethod(6)
    def get_DeferAutomaticRegistration(self) -> Boolean: ...
    @winrt_commethod(7)
    def put_DeferAutomaticRegistration(self, value: Boolean) -> Void: ...
    DeferAutomaticRegistration = property(get_DeferAutomaticRegistration, put_DeferAutomaticRegistration)
class IPackageManager(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Management.Deployment.IPackageManager'
    _iid_ = Guid('{9a7d4b65-5e8f-4fc7-a2e5-7f6925cb8b53}')
    @winrt_commethod(6)
    def AddPackageAsync(self, packageUri: win32more.Windows.Foundation.Uri, dependencyPackageUris: win32more.Windows.Foundation.Collections.IIterable[win32more.Windows.Foundation.Uri], deploymentOptions: win32more.Windows.Management.Deployment.DeploymentOptions) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[win32more.Windows.Management.Deployment.DeploymentResult, win32more.Windows.Management.Deployment.DeploymentProgress]: ...
    @winrt_commethod(7)
    def UpdatePackageAsync(self, packageUri: win32more.Windows.Foundation.Uri, dependencyPackageUris: win32more.Windows.Foundation.Collections.IIterable[win32more.Windows.Foundation.Uri], deploymentOptions: win32more.Windows.Management.Deployment.DeploymentOptions) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[win32more.Windows.Management.Deployment.DeploymentResult, win32more.Windows.Management.Deployment.DeploymentProgress]: ...
    @winrt_commethod(8)
    def RemovePackageAsync(self, packageFullName: WinRT_String) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[win32more.Windows.Management.Deployment.DeploymentResult, win32more.Windows.Management.Deployment.DeploymentProgress]: ...
    @winrt_commethod(9)
    def StagePackageAsync(self, packageUri: win32more.Windows.Foundation.Uri, dependencyPackageUris: win32more.Windows.Foundation.Collections.IIterable[win32more.Windows.Foundation.Uri]) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[win32more.Windows.Management.Deployment.DeploymentResult, win32more.Windows.Management.Deployment.DeploymentProgress]: ...
    @winrt_commethod(10)
    def RegisterPackageAsync(self, manifestUri: win32more.Windows.Foundation.Uri, dependencyPackageUris: win32more.Windows.Foundation.Collections.IIterable[win32more.Windows.Foundation.Uri], deploymentOptions: win32more.Windows.Management.Deployment.DeploymentOptions) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[win32more.Windows.Management.Deployment.DeploymentResult, win32more.Windows.Management.Deployment.DeploymentProgress]: ...
    @winrt_commethod(11)
    def FindPackages(self) -> win32more.Windows.Foundation.Collections.IIterable[win32more.Windows.ApplicationModel.Package]: ...
    @winrt_commethod(12)
    def FindPackagesByUserSecurityId(self, userSecurityId: WinRT_String) -> win32more.Windows.Foundation.Collections.IIterable[win32more.Windows.ApplicationModel.Package]: ...
    @winrt_commethod(13)
    def FindPackagesByNamePublisher(self, packageName: WinRT_String, packagePublisher: WinRT_String) -> win32more.Windows.Foundation.Collections.IIterable[win32more.Windows.ApplicationModel.Package]: ...
    @winrt_commethod(14)
    def FindPackagesByUserSecurityIdNamePublisher(self, userSecurityId: WinRT_String, packageName: WinRT_String, packagePublisher: WinRT_String) -> win32more.Windows.Foundation.Collections.IIterable[win32more.Windows.ApplicationModel.Package]: ...
    @winrt_commethod(15)
    def FindUsers(self, packageFullName: WinRT_String) -> win32more.Windows.Foundation.Collections.IIterable[win32more.Windows.Management.Deployment.PackageUserInformation]: ...
    @winrt_commethod(16)
    def SetPackageState(self, packageFullName: WinRT_String, packageState: win32more.Windows.Management.Deployment.PackageState) -> Void: ...
    @winrt_commethod(17)
    def FindPackageByPackageFullName(self, packageFullName: WinRT_String) -> win32more.Windows.ApplicationModel.Package: ...
    @winrt_commethod(18)
    def CleanupPackageForUserAsync(self, packageName: WinRT_String, userSecurityId: WinRT_String) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[win32more.Windows.Management.Deployment.DeploymentResult, win32more.Windows.Management.Deployment.DeploymentProgress]: ...
    @winrt_commethod(19)
    def FindPackagesByPackageFamilyName(self, packageFamilyName: WinRT_String) -> win32more.Windows.Foundation.Collections.IIterable[win32more.Windows.ApplicationModel.Package]: ...
    @winrt_commethod(20)
    def FindPackagesByUserSecurityIdPackageFamilyName(self, userSecurityId: WinRT_String, packageFamilyName: WinRT_String) -> win32more.Windows.Foundation.Collections.IIterable[win32more.Windows.ApplicationModel.Package]: ...
    @winrt_commethod(21)
    def FindPackageByUserSecurityIdPackageFullName(self, userSecurityId: WinRT_String, packageFullName: WinRT_String) -> win32more.Windows.ApplicationModel.Package: ...
class IPackageManager10(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Management.Deployment.IPackageManager10'
    _iid_ = Guid('{a7d7d07e-2e66-4093-aed5-e093ed87b3bb}')
    @winrt_commethod(6)
    def ProvisionPackageForAllUsersWithOptionsAsync(self, mainPackageFamilyName: WinRT_String, options: win32more.Windows.Management.Deployment.PackageAllUserProvisioningOptions) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[win32more.Windows.Management.Deployment.DeploymentResult, win32more.Windows.Management.Deployment.DeploymentProgress]: ...
class IPackageManager11(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Management.Deployment.IPackageManager11'
    _iid_ = Guid('{12950b24-c77e-4ea7-8859-325318074e15}')
    @winrt_commethod(6)
    def RemovePackageByUriAsync(self, packageUri: win32more.Windows.Foundation.Uri, options: win32more.Windows.Management.Deployment.RemovePackageOptions) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[win32more.Windows.Management.Deployment.DeploymentResult, win32more.Windows.Management.Deployment.DeploymentProgress]: ...
class IPackageManager12(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Management.Deployment.IPackageManager12'
    _iid_ = Guid('{5d233adf-f9e3-4d96-b40d-96788e39539f}')
    @winrt_commethod(6)
    def IsPackageRemovalPending(self, packageFullName: WinRT_String) -> Boolean: ...
    @winrt_commethod(7)
    def IsPackageRemovalPendingForUser(self, packageFullName: WinRT_String, userSecurityId: WinRT_String) -> Boolean: ...
    @winrt_commethod(8)
    def IsPackageRemovalPendingByUri(self, packageUri: win32more.Windows.Foundation.Uri) -> Boolean: ...
    @winrt_commethod(9)
    def IsPackageRemovalPendingByUriForUser(self, packageUri: win32more.Windows.Foundation.Uri, userSecurityId: WinRT_String) -> Boolean: ...
class IPackageManager2(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Management.Deployment.IPackageManager2'
    _iid_ = Guid('{f7aad08d-0840-46f2-b5d8-cad47693a095}')
    @winrt_commethod(6)
    def RemovePackageWithOptionsAsync(self, packageFullName: WinRT_String, removalOptions: win32more.Windows.Management.Deployment.RemovalOptions) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[win32more.Windows.Management.Deployment.DeploymentResult, win32more.Windows.Management.Deployment.DeploymentProgress]: ...
    @winrt_commethod(7)
    def StagePackageWithOptionsAsync(self, packageUri: win32more.Windows.Foundation.Uri, dependencyPackageUris: win32more.Windows.Foundation.Collections.IIterable[win32more.Windows.Foundation.Uri], deploymentOptions: win32more.Windows.Management.Deployment.DeploymentOptions) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[win32more.Windows.Management.Deployment.DeploymentResult, win32more.Windows.Management.Deployment.DeploymentProgress]: ...
    @winrt_commethod(8)
    def RegisterPackageByFullNameAsync(self, mainPackageFullName: WinRT_String, dependencyPackageFullNames: win32more.Windows.Foundation.Collections.IIterable[WinRT_String], deploymentOptions: win32more.Windows.Management.Deployment.DeploymentOptions) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[win32more.Windows.Management.Deployment.DeploymentResult, win32more.Windows.Management.Deployment.DeploymentProgress]: ...
    @winrt_commethod(9)
    def FindPackagesWithPackageTypes(self, packageTypes: win32more.Windows.Management.Deployment.PackageTypes) -> win32more.Windows.Foundation.Collections.IIterable[win32more.Windows.ApplicationModel.Package]: ...
    @winrt_commethod(10)
    def FindPackagesByUserSecurityIdWithPackageTypes(self, userSecurityId: WinRT_String, packageTypes: win32more.Windows.Management.Deployment.PackageTypes) -> win32more.Windows.Foundation.Collections.IIterable[win32more.Windows.ApplicationModel.Package]: ...
    @winrt_commethod(11)
    def FindPackagesByNamePublisherWithPackageTypes(self, packageName: WinRT_String, packagePublisher: WinRT_String, packageTypes: win32more.Windows.Management.Deployment.PackageTypes) -> win32more.Windows.Foundation.Collections.IIterable[win32more.Windows.ApplicationModel.Package]: ...
    @winrt_commethod(12)
    def FindPackagesByUserSecurityIdNamePublisherWithPackageTypes(self, userSecurityId: WinRT_String, packageName: WinRT_String, packagePublisher: WinRT_String, packageTypes: win32more.Windows.Management.Deployment.PackageTypes) -> win32more.Windows.Foundation.Collections.IIterable[win32more.Windows.ApplicationModel.Package]: ...
    @winrt_commethod(13)
    def FindPackagesByPackageFamilyNameWithPackageTypes(self, packageFamilyName: WinRT_String, packageTypes: win32more.Windows.Management.Deployment.PackageTypes) -> win32more.Windows.Foundation.Collections.IIterable[win32more.Windows.ApplicationModel.Package]: ...
    @winrt_commethod(14)
    def FindPackagesByUserSecurityIdPackageFamilyNameWithPackageTypes(self, userSecurityId: WinRT_String, packageFamilyName: WinRT_String, packageTypes: win32more.Windows.Management.Deployment.PackageTypes) -> win32more.Windows.Foundation.Collections.IIterable[win32more.Windows.ApplicationModel.Package]: ...
    @winrt_commethod(15)
    def StageUserDataAsync(self, packageFullName: WinRT_String) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[win32more.Windows.Management.Deployment.DeploymentResult, win32more.Windows.Management.Deployment.DeploymentProgress]: ...
class IPackageManager3(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Management.Deployment.IPackageManager3'
    _iid_ = Guid('{daad9948-36f1-41a7-9188-bc263e0dcb72}')
    @winrt_commethod(6)
    def AddPackageVolumeAsync(self, packageStorePath: WinRT_String) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Windows.Management.Deployment.PackageVolume]: ...
    @winrt_commethod(7)
    def AddPackageToVolumeAsync(self, packageUri: win32more.Windows.Foundation.Uri, dependencyPackageUris: win32more.Windows.Foundation.Collections.IIterable[win32more.Windows.Foundation.Uri], deploymentOptions: win32more.Windows.Management.Deployment.DeploymentOptions, targetVolume: win32more.Windows.Management.Deployment.PackageVolume) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[win32more.Windows.Management.Deployment.DeploymentResult, win32more.Windows.Management.Deployment.DeploymentProgress]: ...
    @winrt_commethod(8)
    def ClearPackageStatus(self, packageFullName: WinRT_String, status: win32more.Windows.Management.Deployment.PackageStatus) -> Void: ...
    @winrt_commethod(9)
    def RegisterPackageWithAppDataVolumeAsync(self, manifestUri: win32more.Windows.Foundation.Uri, dependencyPackageUris: win32more.Windows.Foundation.Collections.IIterable[win32more.Windows.Foundation.Uri], deploymentOptions: win32more.Windows.Management.Deployment.DeploymentOptions, appDataVolume: win32more.Windows.Management.Deployment.PackageVolume) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[win32more.Windows.Management.Deployment.DeploymentResult, win32more.Windows.Management.Deployment.DeploymentProgress]: ...
    @winrt_commethod(10)
    def FindPackageVolumeByName(self, volumeName: WinRT_String) -> win32more.Windows.Management.Deployment.PackageVolume: ...
    @winrt_commethod(11)
    def FindPackageVolumes(self) -> win32more.Windows.Foundation.Collections.IIterable[win32more.Windows.Management.Deployment.PackageVolume]: ...
    @winrt_commethod(12)
    def GetDefaultPackageVolume(self) -> win32more.Windows.Management.Deployment.PackageVolume: ...
    @winrt_commethod(13)
    def MovePackageToVolumeAsync(self, packageFullName: WinRT_String, deploymentOptions: win32more.Windows.Management.Deployment.DeploymentOptions, targetVolume: win32more.Windows.Management.Deployment.PackageVolume) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[win32more.Windows.Management.Deployment.DeploymentResult, win32more.Windows.Management.Deployment.DeploymentProgress]: ...
    @winrt_commethod(14)
    def RemovePackageVolumeAsync(self, volume: win32more.Windows.Management.Deployment.PackageVolume) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[win32more.Windows.Management.Deployment.DeploymentResult, win32more.Windows.Management.Deployment.DeploymentProgress]: ...
    @winrt_commethod(15)
    def SetDefaultPackageVolume(self, volume: win32more.Windows.Management.Deployment.PackageVolume) -> Void: ...
    @winrt_commethod(16)
    def SetPackageStatus(self, packageFullName: WinRT_String, status: win32more.Windows.Management.Deployment.PackageStatus) -> Void: ...
    @winrt_commethod(17)
    def SetPackageVolumeOfflineAsync(self, packageVolume: win32more.Windows.Management.Deployment.PackageVolume) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[win32more.Windows.Management.Deployment.DeploymentResult, win32more.Windows.Management.Deployment.DeploymentProgress]: ...
    @winrt_commethod(18)
    def SetPackageVolumeOnlineAsync(self, packageVolume: win32more.Windows.Management.Deployment.PackageVolume) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[win32more.Windows.Management.Deployment.DeploymentResult, win32more.Windows.Management.Deployment.DeploymentProgress]: ...
    @winrt_commethod(19)
    def StagePackageToVolumeAsync(self, packageUri: win32more.Windows.Foundation.Uri, dependencyPackageUris: win32more.Windows.Foundation.Collections.IIterable[win32more.Windows.Foundation.Uri], deploymentOptions: win32more.Windows.Management.Deployment.DeploymentOptions, targetVolume: win32more.Windows.Management.Deployment.PackageVolume) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[win32more.Windows.Management.Deployment.DeploymentResult, win32more.Windows.Management.Deployment.DeploymentProgress]: ...
    @winrt_commethod(20)
    def StageUserDataWithOptionsAsync(self, packageFullName: WinRT_String, deploymentOptions: win32more.Windows.Management.Deployment.DeploymentOptions) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[win32more.Windows.Management.Deployment.DeploymentResult, win32more.Windows.Management.Deployment.DeploymentProgress]: ...
class IPackageManager4(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Management.Deployment.IPackageManager4'
    _iid_ = Guid('{3c719963-bab6-46bf-8ff7-da4719230ae6}')
    @winrt_commethod(6)
    def GetPackageVolumesAsync(self) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Windows.Foundation.Collections.IVectorView[win32more.Windows.Management.Deployment.PackageVolume]]: ...
class IPackageManager5(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Management.Deployment.IPackageManager5'
    _iid_ = Guid('{711f3117-1afd-4313-978c-9bb6e1b864a7}')
    @winrt_commethod(6)
    def AddPackageToVolumeAndOptionalPackagesAsync(self, packageUri: win32more.Windows.Foundation.Uri, dependencyPackageUris: win32more.Windows.Foundation.Collections.IIterable[win32more.Windows.Foundation.Uri], deploymentOptions: win32more.Windows.Management.Deployment.DeploymentOptions, targetVolume: win32more.Windows.Management.Deployment.PackageVolume, optionalPackageFamilyNames: win32more.Windows.Foundation.Collections.IIterable[WinRT_String], externalPackageUris: win32more.Windows.Foundation.Collections.IIterable[win32more.Windows.Foundation.Uri]) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[win32more.Windows.Management.Deployment.DeploymentResult, win32more.Windows.Management.Deployment.DeploymentProgress]: ...
    @winrt_commethod(7)
    def StagePackageToVolumeAndOptionalPackagesAsync(self, packageUri: win32more.Windows.Foundation.Uri, dependencyPackageUris: win32more.Windows.Foundation.Collections.IIterable[win32more.Windows.Foundation.Uri], deploymentOptions: win32more.Windows.Management.Deployment.DeploymentOptions, targetVolume: win32more.Windows.Management.Deployment.PackageVolume, optionalPackageFamilyNames: win32more.Windows.Foundation.Collections.IIterable[WinRT_String], externalPackageUris: win32more.Windows.Foundation.Collections.IIterable[win32more.Windows.Foundation.Uri]) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[win32more.Windows.Management.Deployment.DeploymentResult, win32more.Windows.Management.Deployment.DeploymentProgress]: ...
    @winrt_commethod(8)
    def RegisterPackageByFamilyNameAndOptionalPackagesAsync(self, mainPackageFamilyName: WinRT_String, dependencyPackageFamilyNames: win32more.Windows.Foundation.Collections.IIterable[WinRT_String], deploymentOptions: win32more.Windows.Management.Deployment.DeploymentOptions, appDataVolume: win32more.Windows.Management.Deployment.PackageVolume, optionalPackageFamilyNames: win32more.Windows.Foundation.Collections.IIterable[WinRT_String]) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[win32more.Windows.Management.Deployment.DeploymentResult, win32more.Windows.Management.Deployment.DeploymentProgress]: ...
    @winrt_commethod(9)
    def get_DebugSettings(self) -> win32more.Windows.Management.Deployment.PackageManagerDebugSettings: ...
    DebugSettings = property(get_DebugSettings, None)
class IPackageManager6(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Management.Deployment.IPackageManager6'
    _iid_ = Guid('{0847e909-53cd-4e4f-832e-57d180f6e447}')
    @winrt_commethod(6)
    def ProvisionPackageForAllUsersAsync(self, packageFamilyName: WinRT_String) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[win32more.Windows.Management.Deployment.DeploymentResult, win32more.Windows.Management.Deployment.DeploymentProgress]: ...
    @winrt_commethod(7)
    def AddPackageByAppInstallerFileAsync(self, appInstallerFileUri: win32more.Windows.Foundation.Uri, options: win32more.Windows.Management.Deployment.AddPackageByAppInstallerOptions, targetVolume: win32more.Windows.Management.Deployment.PackageVolume) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[win32more.Windows.Management.Deployment.DeploymentResult, win32more.Windows.Management.Deployment.DeploymentProgress]: ...
    @winrt_commethod(8)
    def RequestAddPackageByAppInstallerFileAsync(self, appInstallerFileUri: win32more.Windows.Foundation.Uri, options: win32more.Windows.Management.Deployment.AddPackageByAppInstallerOptions, targetVolume: win32more.Windows.Management.Deployment.PackageVolume) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[win32more.Windows.Management.Deployment.DeploymentResult, win32more.Windows.Management.Deployment.DeploymentProgress]: ...
    @winrt_commethod(9)
    def AddPackageToVolumeAndRelatedSetAsync(self, packageUri: win32more.Windows.Foundation.Uri, dependencyPackageUris: win32more.Windows.Foundation.Collections.IIterable[win32more.Windows.Foundation.Uri], options: win32more.Windows.Management.Deployment.DeploymentOptions, targetVolume: win32more.Windows.Management.Deployment.PackageVolume, optionalPackageFamilyNames: win32more.Windows.Foundation.Collections.IIterable[WinRT_String], packageUrisToInstall: win32more.Windows.Foundation.Collections.IIterable[win32more.Windows.Foundation.Uri], relatedPackageUris: win32more.Windows.Foundation.Collections.IIterable[win32more.Windows.Foundation.Uri]) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[win32more.Windows.Management.Deployment.DeploymentResult, win32more.Windows.Management.Deployment.DeploymentProgress]: ...
    @winrt_commethod(10)
    def StagePackageToVolumeAndRelatedSetAsync(self, packageUri: win32more.Windows.Foundation.Uri, dependencyPackageUris: win32more.Windows.Foundation.Collections.IIterable[win32more.Windows.Foundation.Uri], options: win32more.Windows.Management.Deployment.DeploymentOptions, targetVolume: win32more.Windows.Management.Deployment.PackageVolume, optionalPackageFamilyNames: win32more.Windows.Foundation.Collections.IIterable[WinRT_String], packageUrisToInstall: win32more.Windows.Foundation.Collections.IIterable[win32more.Windows.Foundation.Uri], relatedPackageUris: win32more.Windows.Foundation.Collections.IIterable[win32more.Windows.Foundation.Uri]) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[win32more.Windows.Management.Deployment.DeploymentResult, win32more.Windows.Management.Deployment.DeploymentProgress]: ...
    @winrt_commethod(11)
    def RequestAddPackageAsync(self, packageUri: win32more.Windows.Foundation.Uri, dependencyPackageUris: win32more.Windows.Foundation.Collections.IIterable[win32more.Windows.Foundation.Uri], deploymentOptions: win32more.Windows.Management.Deployment.DeploymentOptions, targetVolume: win32more.Windows.Management.Deployment.PackageVolume, optionalPackageFamilyNames: win32more.Windows.Foundation.Collections.IIterable[WinRT_String], relatedPackageUris: win32more.Windows.Foundation.Collections.IIterable[win32more.Windows.Foundation.Uri]) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[win32more.Windows.Management.Deployment.DeploymentResult, win32more.Windows.Management.Deployment.DeploymentProgress]: ...
class IPackageManager7(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Management.Deployment.IPackageManager7'
    _iid_ = Guid('{f28654f4-2ba7-4b80-88d6-be15f9a23fba}')
    @winrt_commethod(6)
    def RequestAddPackageAndRelatedSetAsync(self, packageUri: win32more.Windows.Foundation.Uri, dependencyPackageUris: win32more.Windows.Foundation.Collections.IIterable[win32more.Windows.Foundation.Uri], deploymentOptions: win32more.Windows.Management.Deployment.DeploymentOptions, targetVolume: win32more.Windows.Management.Deployment.PackageVolume, optionalPackageFamilyNames: win32more.Windows.Foundation.Collections.IIterable[WinRT_String], relatedPackageUris: win32more.Windows.Foundation.Collections.IIterable[win32more.Windows.Foundation.Uri], packageUrisToInstall: win32more.Windows.Foundation.Collections.IIterable[win32more.Windows.Foundation.Uri]) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[win32more.Windows.Management.Deployment.DeploymentResult, win32more.Windows.Management.Deployment.DeploymentProgress]: ...
class IPackageManager8(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Management.Deployment.IPackageManager8'
    _iid_ = Guid('{b8575330-1298-4ee2-80ee-7f659c5d2782}')
    @winrt_commethod(6)
    def DeprovisionPackageForAllUsersAsync(self, packageFamilyName: WinRT_String) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[win32more.Windows.Management.Deployment.DeploymentResult, win32more.Windows.Management.Deployment.DeploymentProgress]: ...
class IPackageManager9(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Management.Deployment.IPackageManager9'
    _iid_ = Guid('{1aa79035-cc71-4b2e-80a6-c7041d8579a7}')
    @winrt_commethod(6)
    def FindProvisionedPackages(self) -> win32more.Windows.Foundation.Collections.IVector[win32more.Windows.ApplicationModel.Package]: ...
    @winrt_commethod(7)
    def AddPackageByUriAsync(self, packageUri: win32more.Windows.Foundation.Uri, options: win32more.Windows.Management.Deployment.AddPackageOptions) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[win32more.Windows.Management.Deployment.DeploymentResult, win32more.Windows.Management.Deployment.DeploymentProgress]: ...
    @winrt_commethod(8)
    def StagePackageByUriAsync(self, packageUri: win32more.Windows.Foundation.Uri, options: win32more.Windows.Management.Deployment.StagePackageOptions) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[win32more.Windows.Management.Deployment.DeploymentResult, win32more.Windows.Management.Deployment.DeploymentProgress]: ...
    @winrt_commethod(9)
    def RegisterPackageByUriAsync(self, manifestUri: win32more.Windows.Foundation.Uri, options: win32more.Windows.Management.Deployment.RegisterPackageOptions) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[win32more.Windows.Management.Deployment.DeploymentResult, win32more.Windows.Management.Deployment.DeploymentProgress]: ...
    @winrt_commethod(10)
    def RegisterPackagesByFullNameAsync(self, packageFullNames: win32more.Windows.Foundation.Collections.IIterable[WinRT_String], options: win32more.Windows.Management.Deployment.RegisterPackageOptions) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[win32more.Windows.Management.Deployment.DeploymentResult, win32more.Windows.Management.Deployment.DeploymentProgress]: ...
    @winrt_commethod(11)
    def SetPackageStubPreference(self, packageFamilyName: WinRT_String, useStub: win32more.Windows.Management.Deployment.PackageStubPreference) -> Void: ...
    @winrt_commethod(12)
    def GetPackageStubPreference(self, packageFamilyName: WinRT_String) -> win32more.Windows.Management.Deployment.PackageStubPreference: ...
class IPackageManagerDebugSettings(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Management.Deployment.IPackageManagerDebugSettings'
    _iid_ = Guid('{1a611683-a988-4fcf-8f0f-ce175898e8eb}')
    @winrt_commethod(6)
    def SetContentGroupStateAsync(self, package: win32more.Windows.ApplicationModel.Package, contentGroupName: WinRT_String, state: win32more.Windows.ApplicationModel.PackageContentGroupState) -> win32more.Windows.Foundation.IAsyncAction: ...
    @winrt_commethod(7)
    def SetContentGroupStateWithPercentageAsync(self, package: win32more.Windows.ApplicationModel.Package, contentGroupName: WinRT_String, state: win32more.Windows.ApplicationModel.PackageContentGroupState, completionPercentage: Double) -> win32more.Windows.Foundation.IAsyncAction: ...
class IPackageUserInformation(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Management.Deployment.IPackageUserInformation'
    _iid_ = Guid('{f6383423-fa09-4cbc-9055-15ca275e2e7e}')
    @winrt_commethod(6)
    def get_UserSecurityId(self) -> WinRT_String: ...
    @winrt_commethod(7)
    def get_InstallState(self) -> win32more.Windows.Management.Deployment.PackageInstallState: ...
    InstallState = property(get_InstallState, None)
    UserSecurityId = property(get_UserSecurityId, None)
class IPackageVolume(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Management.Deployment.IPackageVolume'
    _iid_ = Guid('{cf2672c3-1a40-4450-9739-2ace2e898853}')
    @winrt_commethod(6)
    def get_IsOffline(self) -> Boolean: ...
    @winrt_commethod(7)
    def get_IsSystemVolume(self) -> Boolean: ...
    @winrt_commethod(8)
    def get_MountPoint(self) -> WinRT_String: ...
    @winrt_commethod(9)
    def get_Name(self) -> WinRT_String: ...
    @winrt_commethod(10)
    def get_PackageStorePath(self) -> WinRT_String: ...
    @winrt_commethod(11)
    def get_SupportsHardLinks(self) -> Boolean: ...
    @winrt_commethod(12)
    def FindPackages(self) -> win32more.Windows.Foundation.Collections.IVector[win32more.Windows.ApplicationModel.Package]: ...
    @winrt_commethod(13)
    def FindPackagesByNamePublisher(self, packageName: WinRT_String, packagePublisher: WinRT_String) -> win32more.Windows.Foundation.Collections.IVector[win32more.Windows.ApplicationModel.Package]: ...
    @winrt_commethod(14)
    def FindPackagesByPackageFamilyName(self, packageFamilyName: WinRT_String) -> win32more.Windows.Foundation.Collections.IVector[win32more.Windows.ApplicationModel.Package]: ...
    @winrt_commethod(15)
    def FindPackagesWithPackageTypes(self, packageTypes: win32more.Windows.Management.Deployment.PackageTypes) -> win32more.Windows.Foundation.Collections.IVector[win32more.Windows.ApplicationModel.Package]: ...
    @winrt_commethod(16)
    def FindPackagesByNamePublisherWithPackagesTypes(self, packageTypes: win32more.Windows.Management.Deployment.PackageTypes, packageName: WinRT_String, packagePublisher: WinRT_String) -> win32more.Windows.Foundation.Collections.IVector[win32more.Windows.ApplicationModel.Package]: ...
    @winrt_commethod(17)
    def FindPackagesByPackageFamilyNameWithPackageTypes(self, packageTypes: win32more.Windows.Management.Deployment.PackageTypes, packageFamilyName: WinRT_String) -> win32more.Windows.Foundation.Collections.IVector[win32more.Windows.ApplicationModel.Package]: ...
    @winrt_commethod(18)
    def FindPackageByPackageFullName(self, packageFullName: WinRT_String) -> win32more.Windows.Foundation.Collections.IVector[win32more.Windows.ApplicationModel.Package]: ...
    @winrt_commethod(19)
    def FindPackagesByUserSecurityId(self, userSecurityId: WinRT_String) -> win32more.Windows.Foundation.Collections.IVector[win32more.Windows.ApplicationModel.Package]: ...
    @winrt_commethod(20)
    def FindPackagesByUserSecurityIdNamePublisher(self, userSecurityId: WinRT_String, packageName: WinRT_String, packagePublisher: WinRT_String) -> win32more.Windows.Foundation.Collections.IVector[win32more.Windows.ApplicationModel.Package]: ...
    @winrt_commethod(21)
    def FindPackagesByUserSecurityIdPackageFamilyName(self, userSecurityId: WinRT_String, packageFamilyName: WinRT_String) -> win32more.Windows.Foundation.Collections.IVector[win32more.Windows.ApplicationModel.Package]: ...
    @winrt_commethod(22)
    def FindPackagesByUserSecurityIdWithPackageTypes(self, userSecurityId: WinRT_String, packageTypes: win32more.Windows.Management.Deployment.PackageTypes) -> win32more.Windows.Foundation.Collections.IVector[win32more.Windows.ApplicationModel.Package]: ...
    @winrt_commethod(23)
    def FindPackagesByUserSecurityIdNamePublisherWithPackageTypes(self, userSecurityId: WinRT_String, packageTypes: win32more.Windows.Management.Deployment.PackageTypes, packageName: WinRT_String, packagePublisher: WinRT_String) -> win32more.Windows.Foundation.Collections.IVector[win32more.Windows.ApplicationModel.Package]: ...
    @winrt_commethod(24)
    def FindPackagesByUserSecurityIdPackageFamilyNameWithPackagesTypes(self, userSecurityId: WinRT_String, packageTypes: win32more.Windows.Management.Deployment.PackageTypes, packageFamilyName: WinRT_String) -> win32more.Windows.Foundation.Collections.IVector[win32more.Windows.ApplicationModel.Package]: ...
    @winrt_commethod(25)
    def FindPackageByUserSecurityIdPackageFullName(self, userSecurityId: WinRT_String, packageFullName: WinRT_String) -> win32more.Windows.Foundation.Collections.IVector[win32more.Windows.ApplicationModel.Package]: ...
    IsOffline = property(get_IsOffline, None)
    IsSystemVolume = property(get_IsSystemVolume, None)
    MountPoint = property(get_MountPoint, None)
    Name = property(get_Name, None)
    PackageStorePath = property(get_PackageStorePath, None)
    SupportsHardLinks = property(get_SupportsHardLinks, None)
class IPackageVolume2(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Management.Deployment.IPackageVolume2'
    _iid_ = Guid('{46abcf2e-9dd4-47a2-ab8c-c6408349bcd8}')
    @winrt_commethod(6)
    def get_IsFullTrustPackageSupported(self) -> Boolean: ...
    @winrt_commethod(7)
    def get_IsAppxInstallSupported(self) -> Boolean: ...
    @winrt_commethod(8)
    def GetAvailableSpaceAsync(self) -> win32more.Windows.Foundation.IAsyncOperation[UInt64]: ...
    IsAppxInstallSupported = property(get_IsAppxInstallSupported, None)
    IsFullTrustPackageSupported = property(get_IsFullTrustPackageSupported, None)
class IRegisterPackageOptions(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Management.Deployment.IRegisterPackageOptions'
    _iid_ = Guid('{677112a7-50d4-496c-8415-0602b4c6d3bf}')
    @winrt_commethod(6)
    def get_DependencyPackageUris(self) -> win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Foundation.Uri]: ...
    @winrt_commethod(7)
    def get_AppDataVolume(self) -> win32more.Windows.Management.Deployment.PackageVolume: ...
    @winrt_commethod(8)
    def put_AppDataVolume(self, value: win32more.Windows.Management.Deployment.PackageVolume) -> Void: ...
    @winrt_commethod(9)
    def get_OptionalPackageFamilyNames(self) -> win32more.Windows.Foundation.Collections.IVector[WinRT_String]: ...
    @winrt_commethod(10)
    def get_ExternalLocationUri(self) -> win32more.Windows.Foundation.Uri: ...
    @winrt_commethod(11)
    def put_ExternalLocationUri(self, value: win32more.Windows.Foundation.Uri) -> Void: ...
    @winrt_commethod(12)
    def get_DeveloperMode(self) -> Boolean: ...
    @winrt_commethod(13)
    def put_DeveloperMode(self, value: Boolean) -> Void: ...
    @winrt_commethod(14)
    def get_ForceAppShutdown(self) -> Boolean: ...
    @winrt_commethod(15)
    def put_ForceAppShutdown(self, value: Boolean) -> Void: ...
    @winrt_commethod(16)
    def get_ForceTargetAppShutdown(self) -> Boolean: ...
    @winrt_commethod(17)
    def put_ForceTargetAppShutdown(self, value: Boolean) -> Void: ...
    @winrt_commethod(18)
    def get_ForceUpdateFromAnyVersion(self) -> Boolean: ...
    @winrt_commethod(19)
    def put_ForceUpdateFromAnyVersion(self, value: Boolean) -> Void: ...
    @winrt_commethod(20)
    def get_InstallAllResources(self) -> Boolean: ...
    @winrt_commethod(21)
    def put_InstallAllResources(self, value: Boolean) -> Void: ...
    @winrt_commethod(22)
    def get_StageInPlace(self) -> Boolean: ...
    @winrt_commethod(23)
    def put_StageInPlace(self, value: Boolean) -> Void: ...
    @winrt_commethod(24)
    def get_AllowUnsigned(self) -> Boolean: ...
    @winrt_commethod(25)
    def put_AllowUnsigned(self, value: Boolean) -> Void: ...
    @winrt_commethod(26)
    def get_DeferRegistrationWhenPackagesAreInUse(self) -> Boolean: ...
    @winrt_commethod(27)
    def put_DeferRegistrationWhenPackagesAreInUse(self, value: Boolean) -> Void: ...
    AllowUnsigned = property(get_AllowUnsigned, put_AllowUnsigned)
    AppDataVolume = property(get_AppDataVolume, put_AppDataVolume)
    DeferRegistrationWhenPackagesAreInUse = property(get_DeferRegistrationWhenPackagesAreInUse, put_DeferRegistrationWhenPackagesAreInUse)
    DependencyPackageUris = property(get_DependencyPackageUris, None)
    DeveloperMode = property(get_DeveloperMode, put_DeveloperMode)
    ExternalLocationUri = property(get_ExternalLocationUri, put_ExternalLocationUri)
    ForceAppShutdown = property(get_ForceAppShutdown, put_ForceAppShutdown)
    ForceTargetAppShutdown = property(get_ForceTargetAppShutdown, put_ForceTargetAppShutdown)
    ForceUpdateFromAnyVersion = property(get_ForceUpdateFromAnyVersion, put_ForceUpdateFromAnyVersion)
    InstallAllResources = property(get_InstallAllResources, put_InstallAllResources)
    OptionalPackageFamilyNames = property(get_OptionalPackageFamilyNames, None)
    StageInPlace = property(get_StageInPlace, put_StageInPlace)
class IRegisterPackageOptions2(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Management.Deployment.IRegisterPackageOptions2'
    _iid_ = Guid('{3dfa9743-86ff-4a11-bc93-434eb6be3a0b}')
    @winrt_commethod(6)
    def get_ExpectedDigests(self) -> win32more.Windows.Foundation.Collections.IMap[win32more.Windows.Foundation.Uri, WinRT_String]: ...
    ExpectedDigests = property(get_ExpectedDigests, None)
class IRemovePackageOptions(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Management.Deployment.IRemovePackageOptions'
    _iid_ = Guid('{13cf01f3-c450-4f7c-a5a3-5e3c631b7462}')
    @winrt_commethod(6)
    def get_PreserveApplicationData(self) -> Boolean: ...
    @winrt_commethod(7)
    def put_PreserveApplicationData(self, value: Boolean) -> Void: ...
    @winrt_commethod(8)
    def get_PreserveRoamableApplicationData(self) -> Boolean: ...
    @winrt_commethod(9)
    def put_PreserveRoamableApplicationData(self, value: Boolean) -> Void: ...
    @winrt_commethod(10)
    def get_RemoveForAllUsers(self) -> Boolean: ...
    @winrt_commethod(11)
    def put_RemoveForAllUsers(self, value: Boolean) -> Void: ...
    PreserveApplicationData = property(get_PreserveApplicationData, put_PreserveApplicationData)
    PreserveRoamableApplicationData = property(get_PreserveRoamableApplicationData, put_PreserveRoamableApplicationData)
    RemoveForAllUsers = property(get_RemoveForAllUsers, put_RemoveForAllUsers)
class IRemovePackageOptions2(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Management.Deployment.IRemovePackageOptions2'
    _iid_ = Guid('{3fcc61e5-22c5-423b-b4b4-cf10bb50830c}')
    @winrt_commethod(6)
    def get_DeferRemovalWhenPackagesAreInUse(self) -> Boolean: ...
    @winrt_commethod(7)
    def put_DeferRemovalWhenPackagesAreInUse(self, value: Boolean) -> Void: ...
    DeferRemovalWhenPackagesAreInUse = property(get_DeferRemovalWhenPackagesAreInUse, put_DeferRemovalWhenPackagesAreInUse)
class ISharedPackageContainer(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Management.Deployment.ISharedPackageContainer'
    _iid_ = Guid('{177f1aa9-151e-5ef7-b1d9-2fba0b4b0d17}')
    @winrt_commethod(6)
    def get_Name(self) -> WinRT_String: ...
    @winrt_commethod(7)
    def get_Id(self) -> WinRT_String: ...
    @winrt_commethod(8)
    def GetMembers(self) -> win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Management.Deployment.SharedPackageContainerMember]: ...
    @winrt_commethod(9)
    def RemovePackageFamily(self, packageFamilyName: WinRT_String, options: win32more.Windows.Management.Deployment.UpdateSharedPackageContainerOptions) -> win32more.Windows.Management.Deployment.UpdateSharedPackageContainerResult: ...
    @winrt_commethod(10)
    def ResetData(self) -> win32more.Windows.Management.Deployment.UpdateSharedPackageContainerResult: ...
    Id = property(get_Id, None)
    Name = property(get_Name, None)
class ISharedPackageContainerManager(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Management.Deployment.ISharedPackageContainerManager'
    _iid_ = Guid('{be353068-1ef7-5ac8-ab3f-0b9f612f0274}')
    @winrt_commethod(6)
    def CreateContainer(self, name: WinRT_String, options: win32more.Windows.Management.Deployment.CreateSharedPackageContainerOptions) -> win32more.Windows.Management.Deployment.CreateSharedPackageContainerResult: ...
    @winrt_commethod(7)
    def DeleteContainer(self, id: WinRT_String, options: win32more.Windows.Management.Deployment.DeleteSharedPackageContainerOptions) -> win32more.Windows.Management.Deployment.DeleteSharedPackageContainerResult: ...
    @winrt_commethod(8)
    def GetContainer(self, id: WinRT_String) -> win32more.Windows.Management.Deployment.SharedPackageContainer: ...
    @winrt_commethod(9)
    def FindContainers(self) -> win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Management.Deployment.SharedPackageContainer]: ...
    @winrt_commethod(10)
    def FindContainersWithOptions(self, options: win32more.Windows.Management.Deployment.FindSharedPackageContainerOptions) -> win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Management.Deployment.SharedPackageContainer]: ...
class ISharedPackageContainerManagerStatics(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Management.Deployment.ISharedPackageContainerManagerStatics'
    _iid_ = Guid('{2ef56348-838a-5f55-a89e-1198a2c627e6}')
    @winrt_commethod(6)
    def GetDefault(self) -> win32more.Windows.Management.Deployment.SharedPackageContainerManager: ...
    @winrt_commethod(7)
    def GetForUser(self, userSid: WinRT_String) -> win32more.Windows.Management.Deployment.SharedPackageContainerManager: ...
    @winrt_commethod(8)
    def GetForProvisioning(self) -> win32more.Windows.Management.Deployment.SharedPackageContainerManager: ...
class ISharedPackageContainerMember(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Management.Deployment.ISharedPackageContainerMember'
    _iid_ = Guid('{fe0d0438-43c9-5426-b89c-f79bf85ddff4}')
    @winrt_commethod(6)
    def get_PackageFamilyName(self) -> WinRT_String: ...
    PackageFamilyName = property(get_PackageFamilyName, None)
class ISharedPackageContainerMemberFactory(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Management.Deployment.ISharedPackageContainerMemberFactory'
    _iid_ = Guid('{49b0ceeb-498f-5a62-b738-b3ca0d436704}')
    @winrt_commethod(6)
    def CreateInstance(self, packageFamilyName: WinRT_String) -> win32more.Windows.Management.Deployment.SharedPackageContainerMember: ...
class IStagePackageOptions(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Management.Deployment.IStagePackageOptions'
    _iid_ = Guid('{0b110c9c-b95d-4c56-bd36-6d656800d06b}')
    @winrt_commethod(6)
    def get_DependencyPackageUris(self) -> win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Foundation.Uri]: ...
    @winrt_commethod(7)
    def get_TargetVolume(self) -> win32more.Windows.Management.Deployment.PackageVolume: ...
    @winrt_commethod(8)
    def put_TargetVolume(self, value: win32more.Windows.Management.Deployment.PackageVolume) -> Void: ...
    @winrt_commethod(9)
    def get_OptionalPackageFamilyNames(self) -> win32more.Windows.Foundation.Collections.IVector[WinRT_String]: ...
    @winrt_commethod(10)
    def get_OptionalPackageUris(self) -> win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Foundation.Uri]: ...
    @winrt_commethod(11)
    def get_RelatedPackageUris(self) -> win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Foundation.Uri]: ...
    @winrt_commethod(12)
    def get_ExternalLocationUri(self) -> win32more.Windows.Foundation.Uri: ...
    @winrt_commethod(13)
    def put_ExternalLocationUri(self, value: win32more.Windows.Foundation.Uri) -> Void: ...
    @winrt_commethod(14)
    def get_StubPackageOption(self) -> win32more.Windows.Management.Deployment.StubPackageOption: ...
    @winrt_commethod(15)
    def put_StubPackageOption(self, value: win32more.Windows.Management.Deployment.StubPackageOption) -> Void: ...
    @winrt_commethod(16)
    def get_DeveloperMode(self) -> Boolean: ...
    @winrt_commethod(17)
    def put_DeveloperMode(self, value: Boolean) -> Void: ...
    @winrt_commethod(18)
    def get_ForceUpdateFromAnyVersion(self) -> Boolean: ...
    @winrt_commethod(19)
    def put_ForceUpdateFromAnyVersion(self, value: Boolean) -> Void: ...
    @winrt_commethod(20)
    def get_InstallAllResources(self) -> Boolean: ...
    @winrt_commethod(21)
    def put_InstallAllResources(self, value: Boolean) -> Void: ...
    @winrt_commethod(22)
    def get_RequiredContentGroupOnly(self) -> Boolean: ...
    @winrt_commethod(23)
    def put_RequiredContentGroupOnly(self, value: Boolean) -> Void: ...
    @winrt_commethod(24)
    def get_StageInPlace(self) -> Boolean: ...
    @winrt_commethod(25)
    def put_StageInPlace(self, value: Boolean) -> Void: ...
    @winrt_commethod(26)
    def get_AllowUnsigned(self) -> Boolean: ...
    @winrt_commethod(27)
    def put_AllowUnsigned(self, value: Boolean) -> Void: ...
    AllowUnsigned = property(get_AllowUnsigned, put_AllowUnsigned)
    DependencyPackageUris = property(get_DependencyPackageUris, None)
    DeveloperMode = property(get_DeveloperMode, put_DeveloperMode)
    ExternalLocationUri = property(get_ExternalLocationUri, put_ExternalLocationUri)
    ForceUpdateFromAnyVersion = property(get_ForceUpdateFromAnyVersion, put_ForceUpdateFromAnyVersion)
    InstallAllResources = property(get_InstallAllResources, put_InstallAllResources)
    OptionalPackageFamilyNames = property(get_OptionalPackageFamilyNames, None)
    OptionalPackageUris = property(get_OptionalPackageUris, None)
    RelatedPackageUris = property(get_RelatedPackageUris, None)
    RequiredContentGroupOnly = property(get_RequiredContentGroupOnly, put_RequiredContentGroupOnly)
    StageInPlace = property(get_StageInPlace, put_StageInPlace)
    StubPackageOption = property(get_StubPackageOption, put_StubPackageOption)
    TargetVolume = property(get_TargetVolume, put_TargetVolume)
class IStagePackageOptions2(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Management.Deployment.IStagePackageOptions2'
    _iid_ = Guid('{990c4ccc-6226-4192-ba92-79875fce0d9c}')
    @winrt_commethod(6)
    def get_ExpectedDigests(self) -> win32more.Windows.Foundation.Collections.IMap[win32more.Windows.Foundation.Uri, WinRT_String]: ...
    ExpectedDigests = property(get_ExpectedDigests, None)
class IUpdateSharedPackageContainerOptions(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Management.Deployment.IUpdateSharedPackageContainerOptions'
    _iid_ = Guid('{80672e83-7194-59f9-b5b9-daa5375f130a}')
    @winrt_commethod(6)
    def get_ForceAppShutdown(self) -> Boolean: ...
    @winrt_commethod(7)
    def put_ForceAppShutdown(self, value: Boolean) -> Void: ...
    @winrt_commethod(8)
    def get_RequirePackagesPresent(self) -> Boolean: ...
    @winrt_commethod(9)
    def put_RequirePackagesPresent(self, value: Boolean) -> Void: ...
    ForceAppShutdown = property(get_ForceAppShutdown, put_ForceAppShutdown)
    RequirePackagesPresent = property(get_RequirePackagesPresent, put_RequirePackagesPresent)
class IUpdateSharedPackageContainerResult(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Management.Deployment.IUpdateSharedPackageContainerResult'
    _iid_ = Guid('{aa407df7-c72d-5458-aea3-4645b6a8ee99}')
    @winrt_commethod(6)
    def get_Status(self) -> win32more.Windows.Management.Deployment.SharedPackageContainerOperationStatus: ...
    @winrt_commethod(7)
    def get_ExtendedError(self) -> win32more.Windows.Foundation.HResult: ...
    ExtendedError = property(get_ExtendedError, None)
    Status = property(get_Status, None)
class PackageAllUserProvisioningOptions(ComPtr):
    extends: IInspectable
    default_interface: win32more.Windows.Management.Deployment.IPackageAllUserProvisioningOptions
    _classid_ = 'Windows.Management.Deployment.PackageAllUserProvisioningOptions'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 0:
            super().__init__(move=win32more.Windows.Management.Deployment.PackageAllUserProvisioningOptions.CreateInstance(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_activatemethod
    def CreateInstance(cls) -> win32more.Windows.Management.Deployment.PackageAllUserProvisioningOptions: ...
    @winrt_mixinmethod
    def get_OptionalPackageFamilyNames(self: win32more.Windows.Management.Deployment.IPackageAllUserProvisioningOptions) -> win32more.Windows.Foundation.Collections.IVector[WinRT_String]: ...
    @winrt_mixinmethod
    def get_ProjectionOrderPackageFamilyNames(self: win32more.Windows.Management.Deployment.IPackageAllUserProvisioningOptions) -> win32more.Windows.Foundation.Collections.IVector[WinRT_String]: ...
    @winrt_mixinmethod
    def get_DeferAutomaticRegistration(self: win32more.Windows.Management.Deployment.IPackageAllUserProvisioningOptions2) -> Boolean: ...
    @winrt_mixinmethod
    def put_DeferAutomaticRegistration(self: win32more.Windows.Management.Deployment.IPackageAllUserProvisioningOptions2, value: Boolean) -> Void: ...
    DeferAutomaticRegistration = property(get_DeferAutomaticRegistration, put_DeferAutomaticRegistration)
    OptionalPackageFamilyNames = property(get_OptionalPackageFamilyNames, None)
    ProjectionOrderPackageFamilyNames = property(get_ProjectionOrderPackageFamilyNames, None)
class PackageInstallState(Enum, Int32):
    NotInstalled = 0
    Staged = 1
    Installed = 2
    Paused = 6
class PackageManager(ComPtr):
    extends: IInspectable
    default_interface: win32more.Windows.Management.Deployment.IPackageManager
    _classid_ = 'Windows.Management.Deployment.PackageManager'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 0:
            super().__init__(move=win32more.Windows.Management.Deployment.PackageManager.CreateInstance(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_activatemethod
    def CreateInstance(cls) -> win32more.Windows.Management.Deployment.PackageManager: ...
    @winrt_mixinmethod
    def AddPackageAsync(self: win32more.Windows.Management.Deployment.IPackageManager, packageUri: win32more.Windows.Foundation.Uri, dependencyPackageUris: win32more.Windows.Foundation.Collections.IIterable[win32more.Windows.Foundation.Uri], deploymentOptions: win32more.Windows.Management.Deployment.DeploymentOptions) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[win32more.Windows.Management.Deployment.DeploymentResult, win32more.Windows.Management.Deployment.DeploymentProgress]: ...
    @winrt_mixinmethod
    def UpdatePackageAsync(self: win32more.Windows.Management.Deployment.IPackageManager, packageUri: win32more.Windows.Foundation.Uri, dependencyPackageUris: win32more.Windows.Foundation.Collections.IIterable[win32more.Windows.Foundation.Uri], deploymentOptions: win32more.Windows.Management.Deployment.DeploymentOptions) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[win32more.Windows.Management.Deployment.DeploymentResult, win32more.Windows.Management.Deployment.DeploymentProgress]: ...
    @winrt_mixinmethod
    def RemovePackageAsync(self: win32more.Windows.Management.Deployment.IPackageManager, packageFullName: WinRT_String) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[win32more.Windows.Management.Deployment.DeploymentResult, win32more.Windows.Management.Deployment.DeploymentProgress]: ...
    @winrt_mixinmethod
    def StagePackageAsync(self: win32more.Windows.Management.Deployment.IPackageManager, packageUri: win32more.Windows.Foundation.Uri, dependencyPackageUris: win32more.Windows.Foundation.Collections.IIterable[win32more.Windows.Foundation.Uri]) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[win32more.Windows.Management.Deployment.DeploymentResult, win32more.Windows.Management.Deployment.DeploymentProgress]: ...
    @winrt_mixinmethod
    def RegisterPackageAsync(self: win32more.Windows.Management.Deployment.IPackageManager, manifestUri: win32more.Windows.Foundation.Uri, dependencyPackageUris: win32more.Windows.Foundation.Collections.IIterable[win32more.Windows.Foundation.Uri], deploymentOptions: win32more.Windows.Management.Deployment.DeploymentOptions) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[win32more.Windows.Management.Deployment.DeploymentResult, win32more.Windows.Management.Deployment.DeploymentProgress]: ...
    @winrt_mixinmethod
    def FindPackages(self: win32more.Windows.Management.Deployment.IPackageManager) -> win32more.Windows.Foundation.Collections.IIterable[win32more.Windows.ApplicationModel.Package]: ...
    @winrt_mixinmethod
    def FindPackagesByUserSecurityId(self: win32more.Windows.Management.Deployment.IPackageManager, userSecurityId: WinRT_String) -> win32more.Windows.Foundation.Collections.IIterable[win32more.Windows.ApplicationModel.Package]: ...
    @winrt_mixinmethod
    def FindPackagesByNamePublisher(self: win32more.Windows.Management.Deployment.IPackageManager, packageName: WinRT_String, packagePublisher: WinRT_String) -> win32more.Windows.Foundation.Collections.IIterable[win32more.Windows.ApplicationModel.Package]: ...
    @winrt_mixinmethod
    def FindPackagesByUserSecurityIdNamePublisher(self: win32more.Windows.Management.Deployment.IPackageManager, userSecurityId: WinRT_String, packageName: WinRT_String, packagePublisher: WinRT_String) -> win32more.Windows.Foundation.Collections.IIterable[win32more.Windows.ApplicationModel.Package]: ...
    @winrt_mixinmethod
    def FindUsers(self: win32more.Windows.Management.Deployment.IPackageManager, packageFullName: WinRT_String) -> win32more.Windows.Foundation.Collections.IIterable[win32more.Windows.Management.Deployment.PackageUserInformation]: ...
    @winrt_mixinmethod
    def SetPackageState(self: win32more.Windows.Management.Deployment.IPackageManager, packageFullName: WinRT_String, packageState: win32more.Windows.Management.Deployment.PackageState) -> Void: ...
    @winrt_mixinmethod
    def FindPackageByPackageFullName(self: win32more.Windows.Management.Deployment.IPackageManager, packageFullName: WinRT_String) -> win32more.Windows.ApplicationModel.Package: ...
    @winrt_mixinmethod
    def CleanupPackageForUserAsync(self: win32more.Windows.Management.Deployment.IPackageManager, packageName: WinRT_String, userSecurityId: WinRT_String) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[win32more.Windows.Management.Deployment.DeploymentResult, win32more.Windows.Management.Deployment.DeploymentProgress]: ...
    @winrt_mixinmethod
    def FindPackagesByPackageFamilyName(self: win32more.Windows.Management.Deployment.IPackageManager, packageFamilyName: WinRT_String) -> win32more.Windows.Foundation.Collections.IIterable[win32more.Windows.ApplicationModel.Package]: ...
    @winrt_mixinmethod
    def FindPackagesByUserSecurityIdPackageFamilyName(self: win32more.Windows.Management.Deployment.IPackageManager, userSecurityId: WinRT_String, packageFamilyName: WinRT_String) -> win32more.Windows.Foundation.Collections.IIterable[win32more.Windows.ApplicationModel.Package]: ...
    @winrt_mixinmethod
    def FindPackageByUserSecurityIdPackageFullName(self: win32more.Windows.Management.Deployment.IPackageManager, userSecurityId: WinRT_String, packageFullName: WinRT_String) -> win32more.Windows.ApplicationModel.Package: ...
    @winrt_mixinmethod
    def RemovePackageWithOptionsAsync(self: win32more.Windows.Management.Deployment.IPackageManager2, packageFullName: WinRT_String, removalOptions: win32more.Windows.Management.Deployment.RemovalOptions) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[win32more.Windows.Management.Deployment.DeploymentResult, win32more.Windows.Management.Deployment.DeploymentProgress]: ...
    @winrt_mixinmethod
    def StagePackageWithOptionsAsync(self: win32more.Windows.Management.Deployment.IPackageManager2, packageUri: win32more.Windows.Foundation.Uri, dependencyPackageUris: win32more.Windows.Foundation.Collections.IIterable[win32more.Windows.Foundation.Uri], deploymentOptions: win32more.Windows.Management.Deployment.DeploymentOptions) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[win32more.Windows.Management.Deployment.DeploymentResult, win32more.Windows.Management.Deployment.DeploymentProgress]: ...
    @winrt_mixinmethod
    def RegisterPackageByFullNameAsync(self: win32more.Windows.Management.Deployment.IPackageManager2, mainPackageFullName: WinRT_String, dependencyPackageFullNames: win32more.Windows.Foundation.Collections.IIterable[WinRT_String], deploymentOptions: win32more.Windows.Management.Deployment.DeploymentOptions) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[win32more.Windows.Management.Deployment.DeploymentResult, win32more.Windows.Management.Deployment.DeploymentProgress]: ...
    @winrt_mixinmethod
    def FindPackagesWithPackageTypes(self: win32more.Windows.Management.Deployment.IPackageManager2, packageTypes: win32more.Windows.Management.Deployment.PackageTypes) -> win32more.Windows.Foundation.Collections.IIterable[win32more.Windows.ApplicationModel.Package]: ...
    @winrt_mixinmethod
    def FindPackagesByUserSecurityIdWithPackageTypes(self: win32more.Windows.Management.Deployment.IPackageManager2, userSecurityId: WinRT_String, packageTypes: win32more.Windows.Management.Deployment.PackageTypes) -> win32more.Windows.Foundation.Collections.IIterable[win32more.Windows.ApplicationModel.Package]: ...
    @winrt_mixinmethod
    def FindPackagesByNamePublisherWithPackageTypes(self: win32more.Windows.Management.Deployment.IPackageManager2, packageName: WinRT_String, packagePublisher: WinRT_String, packageTypes: win32more.Windows.Management.Deployment.PackageTypes) -> win32more.Windows.Foundation.Collections.IIterable[win32more.Windows.ApplicationModel.Package]: ...
    @winrt_mixinmethod
    def FindPackagesByUserSecurityIdNamePublisherWithPackageTypes(self: win32more.Windows.Management.Deployment.IPackageManager2, userSecurityId: WinRT_String, packageName: WinRT_String, packagePublisher: WinRT_String, packageTypes: win32more.Windows.Management.Deployment.PackageTypes) -> win32more.Windows.Foundation.Collections.IIterable[win32more.Windows.ApplicationModel.Package]: ...
    @winrt_mixinmethod
    def FindPackagesByPackageFamilyNameWithPackageTypes(self: win32more.Windows.Management.Deployment.IPackageManager2, packageFamilyName: WinRT_String, packageTypes: win32more.Windows.Management.Deployment.PackageTypes) -> win32more.Windows.Foundation.Collections.IIterable[win32more.Windows.ApplicationModel.Package]: ...
    @winrt_mixinmethod
    def FindPackagesByUserSecurityIdPackageFamilyNameWithPackageTypes(self: win32more.Windows.Management.Deployment.IPackageManager2, userSecurityId: WinRT_String, packageFamilyName: WinRT_String, packageTypes: win32more.Windows.Management.Deployment.PackageTypes) -> win32more.Windows.Foundation.Collections.IIterable[win32more.Windows.ApplicationModel.Package]: ...
    @winrt_mixinmethod
    def StageUserDataAsync(self: win32more.Windows.Management.Deployment.IPackageManager2, packageFullName: WinRT_String) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[win32more.Windows.Management.Deployment.DeploymentResult, win32more.Windows.Management.Deployment.DeploymentProgress]: ...
    @winrt_mixinmethod
    def AddPackageVolumeAsync(self: win32more.Windows.Management.Deployment.IPackageManager3, packageStorePath: WinRT_String) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Windows.Management.Deployment.PackageVolume]: ...
    @winrt_mixinmethod
    def AddPackageToVolumeAsync(self: win32more.Windows.Management.Deployment.IPackageManager3, packageUri: win32more.Windows.Foundation.Uri, dependencyPackageUris: win32more.Windows.Foundation.Collections.IIterable[win32more.Windows.Foundation.Uri], deploymentOptions: win32more.Windows.Management.Deployment.DeploymentOptions, targetVolume: win32more.Windows.Management.Deployment.PackageVolume) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[win32more.Windows.Management.Deployment.DeploymentResult, win32more.Windows.Management.Deployment.DeploymentProgress]: ...
    @winrt_mixinmethod
    def ClearPackageStatus(self: win32more.Windows.Management.Deployment.IPackageManager3, packageFullName: WinRT_String, status: win32more.Windows.Management.Deployment.PackageStatus) -> Void: ...
    @winrt_mixinmethod
    def RegisterPackageWithAppDataVolumeAsync(self: win32more.Windows.Management.Deployment.IPackageManager3, manifestUri: win32more.Windows.Foundation.Uri, dependencyPackageUris: win32more.Windows.Foundation.Collections.IIterable[win32more.Windows.Foundation.Uri], deploymentOptions: win32more.Windows.Management.Deployment.DeploymentOptions, appDataVolume: win32more.Windows.Management.Deployment.PackageVolume) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[win32more.Windows.Management.Deployment.DeploymentResult, win32more.Windows.Management.Deployment.DeploymentProgress]: ...
    @winrt_mixinmethod
    def FindPackageVolumeByName(self: win32more.Windows.Management.Deployment.IPackageManager3, volumeName: WinRT_String) -> win32more.Windows.Management.Deployment.PackageVolume: ...
    @winrt_mixinmethod
    def FindPackageVolumes(self: win32more.Windows.Management.Deployment.IPackageManager3) -> win32more.Windows.Foundation.Collections.IIterable[win32more.Windows.Management.Deployment.PackageVolume]: ...
    @winrt_mixinmethod
    def GetDefaultPackageVolume(self: win32more.Windows.Management.Deployment.IPackageManager3) -> win32more.Windows.Management.Deployment.PackageVolume: ...
    @winrt_mixinmethod
    def MovePackageToVolumeAsync(self: win32more.Windows.Management.Deployment.IPackageManager3, packageFullName: WinRT_String, deploymentOptions: win32more.Windows.Management.Deployment.DeploymentOptions, targetVolume: win32more.Windows.Management.Deployment.PackageVolume) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[win32more.Windows.Management.Deployment.DeploymentResult, win32more.Windows.Management.Deployment.DeploymentProgress]: ...
    @winrt_mixinmethod
    def RemovePackageVolumeAsync(self: win32more.Windows.Management.Deployment.IPackageManager3, volume: win32more.Windows.Management.Deployment.PackageVolume) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[win32more.Windows.Management.Deployment.DeploymentResult, win32more.Windows.Management.Deployment.DeploymentProgress]: ...
    @winrt_mixinmethod
    def SetDefaultPackageVolume(self: win32more.Windows.Management.Deployment.IPackageManager3, volume: win32more.Windows.Management.Deployment.PackageVolume) -> Void: ...
    @winrt_mixinmethod
    def SetPackageStatus(self: win32more.Windows.Management.Deployment.IPackageManager3, packageFullName: WinRT_String, status: win32more.Windows.Management.Deployment.PackageStatus) -> Void: ...
    @winrt_mixinmethod
    def SetPackageVolumeOfflineAsync(self: win32more.Windows.Management.Deployment.IPackageManager3, packageVolume: win32more.Windows.Management.Deployment.PackageVolume) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[win32more.Windows.Management.Deployment.DeploymentResult, win32more.Windows.Management.Deployment.DeploymentProgress]: ...
    @winrt_mixinmethod
    def SetPackageVolumeOnlineAsync(self: win32more.Windows.Management.Deployment.IPackageManager3, packageVolume: win32more.Windows.Management.Deployment.PackageVolume) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[win32more.Windows.Management.Deployment.DeploymentResult, win32more.Windows.Management.Deployment.DeploymentProgress]: ...
    @winrt_mixinmethod
    def StagePackageToVolumeAsync(self: win32more.Windows.Management.Deployment.IPackageManager3, packageUri: win32more.Windows.Foundation.Uri, dependencyPackageUris: win32more.Windows.Foundation.Collections.IIterable[win32more.Windows.Foundation.Uri], deploymentOptions: win32more.Windows.Management.Deployment.DeploymentOptions, targetVolume: win32more.Windows.Management.Deployment.PackageVolume) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[win32more.Windows.Management.Deployment.DeploymentResult, win32more.Windows.Management.Deployment.DeploymentProgress]: ...
    @winrt_mixinmethod
    def StageUserDataWithOptionsAsync(self: win32more.Windows.Management.Deployment.IPackageManager3, packageFullName: WinRT_String, deploymentOptions: win32more.Windows.Management.Deployment.DeploymentOptions) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[win32more.Windows.Management.Deployment.DeploymentResult, win32more.Windows.Management.Deployment.DeploymentProgress]: ...
    @winrt_mixinmethod
    def GetPackageVolumesAsync(self: win32more.Windows.Management.Deployment.IPackageManager4) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Windows.Foundation.Collections.IVectorView[win32more.Windows.Management.Deployment.PackageVolume]]: ...
    @winrt_mixinmethod
    def AddPackageToVolumeAndOptionalPackagesAsync(self: win32more.Windows.Management.Deployment.IPackageManager5, packageUri: win32more.Windows.Foundation.Uri, dependencyPackageUris: win32more.Windows.Foundation.Collections.IIterable[win32more.Windows.Foundation.Uri], deploymentOptions: win32more.Windows.Management.Deployment.DeploymentOptions, targetVolume: win32more.Windows.Management.Deployment.PackageVolume, optionalPackageFamilyNames: win32more.Windows.Foundation.Collections.IIterable[WinRT_String], externalPackageUris: win32more.Windows.Foundation.Collections.IIterable[win32more.Windows.Foundation.Uri]) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[win32more.Windows.Management.Deployment.DeploymentResult, win32more.Windows.Management.Deployment.DeploymentProgress]: ...
    @winrt_mixinmethod
    def StagePackageToVolumeAndOptionalPackagesAsync(self: win32more.Windows.Management.Deployment.IPackageManager5, packageUri: win32more.Windows.Foundation.Uri, dependencyPackageUris: win32more.Windows.Foundation.Collections.IIterable[win32more.Windows.Foundation.Uri], deploymentOptions: win32more.Windows.Management.Deployment.DeploymentOptions, targetVolume: win32more.Windows.Management.Deployment.PackageVolume, optionalPackageFamilyNames: win32more.Windows.Foundation.Collections.IIterable[WinRT_String], externalPackageUris: win32more.Windows.Foundation.Collections.IIterable[win32more.Windows.Foundation.Uri]) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[win32more.Windows.Management.Deployment.DeploymentResult, win32more.Windows.Management.Deployment.DeploymentProgress]: ...
    @winrt_mixinmethod
    def RegisterPackageByFamilyNameAndOptionalPackagesAsync(self: win32more.Windows.Management.Deployment.IPackageManager5, mainPackageFamilyName: WinRT_String, dependencyPackageFamilyNames: win32more.Windows.Foundation.Collections.IIterable[WinRT_String], deploymentOptions: win32more.Windows.Management.Deployment.DeploymentOptions, appDataVolume: win32more.Windows.Management.Deployment.PackageVolume, optionalPackageFamilyNames: win32more.Windows.Foundation.Collections.IIterable[WinRT_String]) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[win32more.Windows.Management.Deployment.DeploymentResult, win32more.Windows.Management.Deployment.DeploymentProgress]: ...
    @winrt_mixinmethod
    def get_DebugSettings(self: win32more.Windows.Management.Deployment.IPackageManager5) -> win32more.Windows.Management.Deployment.PackageManagerDebugSettings: ...
    @winrt_mixinmethod
    def ProvisionPackageForAllUsersAsync(self: win32more.Windows.Management.Deployment.IPackageManager6, packageFamilyName: WinRT_String) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[win32more.Windows.Management.Deployment.DeploymentResult, win32more.Windows.Management.Deployment.DeploymentProgress]: ...
    @winrt_mixinmethod
    def AddPackageByAppInstallerFileAsync(self: win32more.Windows.Management.Deployment.IPackageManager6, appInstallerFileUri: win32more.Windows.Foundation.Uri, options: win32more.Windows.Management.Deployment.AddPackageByAppInstallerOptions, targetVolume: win32more.Windows.Management.Deployment.PackageVolume) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[win32more.Windows.Management.Deployment.DeploymentResult, win32more.Windows.Management.Deployment.DeploymentProgress]: ...
    @winrt_mixinmethod
    def RequestAddPackageByAppInstallerFileAsync(self: win32more.Windows.Management.Deployment.IPackageManager6, appInstallerFileUri: win32more.Windows.Foundation.Uri, options: win32more.Windows.Management.Deployment.AddPackageByAppInstallerOptions, targetVolume: win32more.Windows.Management.Deployment.PackageVolume) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[win32more.Windows.Management.Deployment.DeploymentResult, win32more.Windows.Management.Deployment.DeploymentProgress]: ...
    @winrt_mixinmethod
    def AddPackageToVolumeAndRelatedSetAsync(self: win32more.Windows.Management.Deployment.IPackageManager6, packageUri: win32more.Windows.Foundation.Uri, dependencyPackageUris: win32more.Windows.Foundation.Collections.IIterable[win32more.Windows.Foundation.Uri], options: win32more.Windows.Management.Deployment.DeploymentOptions, targetVolume: win32more.Windows.Management.Deployment.PackageVolume, optionalPackageFamilyNames: win32more.Windows.Foundation.Collections.IIterable[WinRT_String], packageUrisToInstall: win32more.Windows.Foundation.Collections.IIterable[win32more.Windows.Foundation.Uri], relatedPackageUris: win32more.Windows.Foundation.Collections.IIterable[win32more.Windows.Foundation.Uri]) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[win32more.Windows.Management.Deployment.DeploymentResult, win32more.Windows.Management.Deployment.DeploymentProgress]: ...
    @winrt_mixinmethod
    def StagePackageToVolumeAndRelatedSetAsync(self: win32more.Windows.Management.Deployment.IPackageManager6, packageUri: win32more.Windows.Foundation.Uri, dependencyPackageUris: win32more.Windows.Foundation.Collections.IIterable[win32more.Windows.Foundation.Uri], options: win32more.Windows.Management.Deployment.DeploymentOptions, targetVolume: win32more.Windows.Management.Deployment.PackageVolume, optionalPackageFamilyNames: win32more.Windows.Foundation.Collections.IIterable[WinRT_String], packageUrisToInstall: win32more.Windows.Foundation.Collections.IIterable[win32more.Windows.Foundation.Uri], relatedPackageUris: win32more.Windows.Foundation.Collections.IIterable[win32more.Windows.Foundation.Uri]) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[win32more.Windows.Management.Deployment.DeploymentResult, win32more.Windows.Management.Deployment.DeploymentProgress]: ...
    @winrt_mixinmethod
    def RequestAddPackageAsync(self: win32more.Windows.Management.Deployment.IPackageManager6, packageUri: win32more.Windows.Foundation.Uri, dependencyPackageUris: win32more.Windows.Foundation.Collections.IIterable[win32more.Windows.Foundation.Uri], deploymentOptions: win32more.Windows.Management.Deployment.DeploymentOptions, targetVolume: win32more.Windows.Management.Deployment.PackageVolume, optionalPackageFamilyNames: win32more.Windows.Foundation.Collections.IIterable[WinRT_String], relatedPackageUris: win32more.Windows.Foundation.Collections.IIterable[win32more.Windows.Foundation.Uri]) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[win32more.Windows.Management.Deployment.DeploymentResult, win32more.Windows.Management.Deployment.DeploymentProgress]: ...
    @winrt_mixinmethod
    def RequestAddPackageAndRelatedSetAsync(self: win32more.Windows.Management.Deployment.IPackageManager7, packageUri: win32more.Windows.Foundation.Uri, dependencyPackageUris: win32more.Windows.Foundation.Collections.IIterable[win32more.Windows.Foundation.Uri], deploymentOptions: win32more.Windows.Management.Deployment.DeploymentOptions, targetVolume: win32more.Windows.Management.Deployment.PackageVolume, optionalPackageFamilyNames: win32more.Windows.Foundation.Collections.IIterable[WinRT_String], relatedPackageUris: win32more.Windows.Foundation.Collections.IIterable[win32more.Windows.Foundation.Uri], packageUrisToInstall: win32more.Windows.Foundation.Collections.IIterable[win32more.Windows.Foundation.Uri]) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[win32more.Windows.Management.Deployment.DeploymentResult, win32more.Windows.Management.Deployment.DeploymentProgress]: ...
    @winrt_mixinmethod
    def DeprovisionPackageForAllUsersAsync(self: win32more.Windows.Management.Deployment.IPackageManager8, packageFamilyName: WinRT_String) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[win32more.Windows.Management.Deployment.DeploymentResult, win32more.Windows.Management.Deployment.DeploymentProgress]: ...
    @winrt_mixinmethod
    def FindProvisionedPackages(self: win32more.Windows.Management.Deployment.IPackageManager9) -> win32more.Windows.Foundation.Collections.IVector[win32more.Windows.ApplicationModel.Package]: ...
    @winrt_mixinmethod
    def AddPackageByUriAsync(self: win32more.Windows.Management.Deployment.IPackageManager9, packageUri: win32more.Windows.Foundation.Uri, options: win32more.Windows.Management.Deployment.AddPackageOptions) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[win32more.Windows.Management.Deployment.DeploymentResult, win32more.Windows.Management.Deployment.DeploymentProgress]: ...
    @winrt_mixinmethod
    def StagePackageByUriAsync(self: win32more.Windows.Management.Deployment.IPackageManager9, packageUri: win32more.Windows.Foundation.Uri, options: win32more.Windows.Management.Deployment.StagePackageOptions) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[win32more.Windows.Management.Deployment.DeploymentResult, win32more.Windows.Management.Deployment.DeploymentProgress]: ...
    @winrt_mixinmethod
    def RegisterPackageByUriAsync(self: win32more.Windows.Management.Deployment.IPackageManager9, manifestUri: win32more.Windows.Foundation.Uri, options: win32more.Windows.Management.Deployment.RegisterPackageOptions) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[win32more.Windows.Management.Deployment.DeploymentResult, win32more.Windows.Management.Deployment.DeploymentProgress]: ...
    @winrt_mixinmethod
    def RegisterPackagesByFullNameAsync(self: win32more.Windows.Management.Deployment.IPackageManager9, packageFullNames: win32more.Windows.Foundation.Collections.IIterable[WinRT_String], options: win32more.Windows.Management.Deployment.RegisterPackageOptions) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[win32more.Windows.Management.Deployment.DeploymentResult, win32more.Windows.Management.Deployment.DeploymentProgress]: ...
    @winrt_mixinmethod
    def SetPackageStubPreference(self: win32more.Windows.Management.Deployment.IPackageManager9, packageFamilyName: WinRT_String, useStub: win32more.Windows.Management.Deployment.PackageStubPreference) -> Void: ...
    @winrt_mixinmethod
    def GetPackageStubPreference(self: win32more.Windows.Management.Deployment.IPackageManager9, packageFamilyName: WinRT_String) -> win32more.Windows.Management.Deployment.PackageStubPreference: ...
    @winrt_mixinmethod
    def ProvisionPackageForAllUsersWithOptionsAsync(self: win32more.Windows.Management.Deployment.IPackageManager10, mainPackageFamilyName: WinRT_String, options: win32more.Windows.Management.Deployment.PackageAllUserProvisioningOptions) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[win32more.Windows.Management.Deployment.DeploymentResult, win32more.Windows.Management.Deployment.DeploymentProgress]: ...
    @winrt_mixinmethod
    def RemovePackageByUriAsync(self: win32more.Windows.Management.Deployment.IPackageManager11, packageUri: win32more.Windows.Foundation.Uri, options: win32more.Windows.Management.Deployment.RemovePackageOptions) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[win32more.Windows.Management.Deployment.DeploymentResult, win32more.Windows.Management.Deployment.DeploymentProgress]: ...
    @winrt_mixinmethod
    def IsPackageRemovalPending(self: win32more.Windows.Management.Deployment.IPackageManager12, packageFullName: WinRT_String) -> Boolean: ...
    @winrt_mixinmethod
    def IsPackageRemovalPendingForUser(self: win32more.Windows.Management.Deployment.IPackageManager12, packageFullName: WinRT_String, userSecurityId: WinRT_String) -> Boolean: ...
    @winrt_mixinmethod
    def IsPackageRemovalPendingByUri(self: win32more.Windows.Management.Deployment.IPackageManager12, packageUri: win32more.Windows.Foundation.Uri) -> Boolean: ...
    @winrt_mixinmethod
    def IsPackageRemovalPendingByUriForUser(self: win32more.Windows.Management.Deployment.IPackageManager12, packageUri: win32more.Windows.Foundation.Uri, userSecurityId: WinRT_String) -> Boolean: ...
    DebugSettings = property(get_DebugSettings, None)
class PackageManagerDebugSettings(ComPtr):
    extends: IInspectable
    default_interface: win32more.Windows.Management.Deployment.IPackageManagerDebugSettings
    _classid_ = 'Windows.Management.Deployment.PackageManagerDebugSettings'
    @winrt_mixinmethod
    def SetContentGroupStateAsync(self: win32more.Windows.Management.Deployment.IPackageManagerDebugSettings, package: win32more.Windows.ApplicationModel.Package, contentGroupName: WinRT_String, state: win32more.Windows.ApplicationModel.PackageContentGroupState) -> win32more.Windows.Foundation.IAsyncAction: ...
    @winrt_mixinmethod
    def SetContentGroupStateWithPercentageAsync(self: win32more.Windows.Management.Deployment.IPackageManagerDebugSettings, package: win32more.Windows.ApplicationModel.Package, contentGroupName: WinRT_String, state: win32more.Windows.ApplicationModel.PackageContentGroupState, completionPercentage: Double) -> win32more.Windows.Foundation.IAsyncAction: ...
class PackageState(Enum, Int32):
    Normal = 0
    LicenseInvalid = 1
    Modified = 2
    Tampered = 3
class PackageStatus(Enum, UInt32):
    OK = 0
    LicenseIssue = 1
    Modified = 2
    Tampered = 4
    Disabled = 8
class PackageStubPreference(Enum, Int32):
    Full = 0
    Stub = 1
class PackageTypes(Enum, UInt32):
    None_ = 0
    Main = 1
    Framework = 2
    Resource = 4
    Bundle = 8
    Xap = 16
    Optional = 32
    All = 4294967295
class PackageUserInformation(ComPtr):
    extends: IInspectable
    default_interface: win32more.Windows.Management.Deployment.IPackageUserInformation
    _classid_ = 'Windows.Management.Deployment.PackageUserInformation'
    @winrt_mixinmethod
    def get_UserSecurityId(self: win32more.Windows.Management.Deployment.IPackageUserInformation) -> WinRT_String: ...
    @winrt_mixinmethod
    def get_InstallState(self: win32more.Windows.Management.Deployment.IPackageUserInformation) -> win32more.Windows.Management.Deployment.PackageInstallState: ...
    InstallState = property(get_InstallState, None)
    UserSecurityId = property(get_UserSecurityId, None)
class PackageVolume(ComPtr):
    extends: IInspectable
    default_interface: win32more.Windows.Management.Deployment.IPackageVolume
    _classid_ = 'Windows.Management.Deployment.PackageVolume'
    @winrt_mixinmethod
    def get_IsOffline(self: win32more.Windows.Management.Deployment.IPackageVolume) -> Boolean: ...
    @winrt_mixinmethod
    def get_IsSystemVolume(self: win32more.Windows.Management.Deployment.IPackageVolume) -> Boolean: ...
    @winrt_mixinmethod
    def get_MountPoint(self: win32more.Windows.Management.Deployment.IPackageVolume) -> WinRT_String: ...
    @winrt_mixinmethod
    def get_Name(self: win32more.Windows.Management.Deployment.IPackageVolume) -> WinRT_String: ...
    @winrt_mixinmethod
    def get_PackageStorePath(self: win32more.Windows.Management.Deployment.IPackageVolume) -> WinRT_String: ...
    @winrt_mixinmethod
    def get_SupportsHardLinks(self: win32more.Windows.Management.Deployment.IPackageVolume) -> Boolean: ...
    @winrt_mixinmethod
    def FindPackages(self: win32more.Windows.Management.Deployment.IPackageVolume) -> win32more.Windows.Foundation.Collections.IVector[win32more.Windows.ApplicationModel.Package]: ...
    @winrt_mixinmethod
    def FindPackagesByNamePublisher(self: win32more.Windows.Management.Deployment.IPackageVolume, packageName: WinRT_String, packagePublisher: WinRT_String) -> win32more.Windows.Foundation.Collections.IVector[win32more.Windows.ApplicationModel.Package]: ...
    @winrt_mixinmethod
    def FindPackagesByPackageFamilyName(self: win32more.Windows.Management.Deployment.IPackageVolume, packageFamilyName: WinRT_String) -> win32more.Windows.Foundation.Collections.IVector[win32more.Windows.ApplicationModel.Package]: ...
    @winrt_mixinmethod
    def FindPackagesWithPackageTypes(self: win32more.Windows.Management.Deployment.IPackageVolume, packageTypes: win32more.Windows.Management.Deployment.PackageTypes) -> win32more.Windows.Foundation.Collections.IVector[win32more.Windows.ApplicationModel.Package]: ...
    @winrt_mixinmethod
    def FindPackagesByNamePublisherWithPackagesTypes(self: win32more.Windows.Management.Deployment.IPackageVolume, packageTypes: win32more.Windows.Management.Deployment.PackageTypes, packageName: WinRT_String, packagePublisher: WinRT_String) -> win32more.Windows.Foundation.Collections.IVector[win32more.Windows.ApplicationModel.Package]: ...
    @winrt_mixinmethod
    def FindPackagesByPackageFamilyNameWithPackageTypes(self: win32more.Windows.Management.Deployment.IPackageVolume, packageTypes: win32more.Windows.Management.Deployment.PackageTypes, packageFamilyName: WinRT_String) -> win32more.Windows.Foundation.Collections.IVector[win32more.Windows.ApplicationModel.Package]: ...
    @winrt_mixinmethod
    def FindPackageByPackageFullName(self: win32more.Windows.Management.Deployment.IPackageVolume, packageFullName: WinRT_String) -> win32more.Windows.Foundation.Collections.IVector[win32more.Windows.ApplicationModel.Package]: ...
    @winrt_mixinmethod
    def FindPackagesByUserSecurityId(self: win32more.Windows.Management.Deployment.IPackageVolume, userSecurityId: WinRT_String) -> win32more.Windows.Foundation.Collections.IVector[win32more.Windows.ApplicationModel.Package]: ...
    @winrt_mixinmethod
    def FindPackagesByUserSecurityIdNamePublisher(self: win32more.Windows.Management.Deployment.IPackageVolume, userSecurityId: WinRT_String, packageName: WinRT_String, packagePublisher: WinRT_String) -> win32more.Windows.Foundation.Collections.IVector[win32more.Windows.ApplicationModel.Package]: ...
    @winrt_mixinmethod
    def FindPackagesByUserSecurityIdPackageFamilyName(self: win32more.Windows.Management.Deployment.IPackageVolume, userSecurityId: WinRT_String, packageFamilyName: WinRT_String) -> win32more.Windows.Foundation.Collections.IVector[win32more.Windows.ApplicationModel.Package]: ...
    @winrt_mixinmethod
    def FindPackagesByUserSecurityIdWithPackageTypes(self: win32more.Windows.Management.Deployment.IPackageVolume, userSecurityId: WinRT_String, packageTypes: win32more.Windows.Management.Deployment.PackageTypes) -> win32more.Windows.Foundation.Collections.IVector[win32more.Windows.ApplicationModel.Package]: ...
    @winrt_mixinmethod
    def FindPackagesByUserSecurityIdNamePublisherWithPackageTypes(self: win32more.Windows.Management.Deployment.IPackageVolume, userSecurityId: WinRT_String, packageTypes: win32more.Windows.Management.Deployment.PackageTypes, packageName: WinRT_String, packagePublisher: WinRT_String) -> win32more.Windows.Foundation.Collections.IVector[win32more.Windows.ApplicationModel.Package]: ...
    @winrt_mixinmethod
    def FindPackagesByUserSecurityIdPackageFamilyNameWithPackagesTypes(self: win32more.Windows.Management.Deployment.IPackageVolume, userSecurityId: WinRT_String, packageTypes: win32more.Windows.Management.Deployment.PackageTypes, packageFamilyName: WinRT_String) -> win32more.Windows.Foundation.Collections.IVector[win32more.Windows.ApplicationModel.Package]: ...
    @winrt_mixinmethod
    def FindPackageByUserSecurityIdPackageFullName(self: win32more.Windows.Management.Deployment.IPackageVolume, userSecurityId: WinRT_String, packageFullName: WinRT_String) -> win32more.Windows.Foundation.Collections.IVector[win32more.Windows.ApplicationModel.Package]: ...
    @winrt_mixinmethod
    def get_IsFullTrustPackageSupported(self: win32more.Windows.Management.Deployment.IPackageVolume2) -> Boolean: ...
    @winrt_mixinmethod
    def get_IsAppxInstallSupported(self: win32more.Windows.Management.Deployment.IPackageVolume2) -> Boolean: ...
    @winrt_mixinmethod
    def GetAvailableSpaceAsync(self: win32more.Windows.Management.Deployment.IPackageVolume2) -> win32more.Windows.Foundation.IAsyncOperation[UInt64]: ...
    IsAppxInstallSupported = property(get_IsAppxInstallSupported, None)
    IsFullTrustPackageSupported = property(get_IsFullTrustPackageSupported, None)
    IsOffline = property(get_IsOffline, None)
    IsSystemVolume = property(get_IsSystemVolume, None)
    MountPoint = property(get_MountPoint, None)
    Name = property(get_Name, None)
    PackageStorePath = property(get_PackageStorePath, None)
    SupportsHardLinks = property(get_SupportsHardLinks, None)
class RegisterPackageOptions(ComPtr):
    extends: IInspectable
    default_interface: win32more.Windows.Management.Deployment.IRegisterPackageOptions
    _classid_ = 'Windows.Management.Deployment.RegisterPackageOptions'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 0:
            super().__init__(move=win32more.Windows.Management.Deployment.RegisterPackageOptions.CreateInstance(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_activatemethod
    def CreateInstance(cls) -> win32more.Windows.Management.Deployment.RegisterPackageOptions: ...
    @winrt_mixinmethod
    def get_DependencyPackageUris(self: win32more.Windows.Management.Deployment.IRegisterPackageOptions) -> win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Foundation.Uri]: ...
    @winrt_mixinmethod
    def get_AppDataVolume(self: win32more.Windows.Management.Deployment.IRegisterPackageOptions) -> win32more.Windows.Management.Deployment.PackageVolume: ...
    @winrt_mixinmethod
    def put_AppDataVolume(self: win32more.Windows.Management.Deployment.IRegisterPackageOptions, value: win32more.Windows.Management.Deployment.PackageVolume) -> Void: ...
    @winrt_mixinmethod
    def get_OptionalPackageFamilyNames(self: win32more.Windows.Management.Deployment.IRegisterPackageOptions) -> win32more.Windows.Foundation.Collections.IVector[WinRT_String]: ...
    @winrt_mixinmethod
    def get_ExternalLocationUri(self: win32more.Windows.Management.Deployment.IRegisterPackageOptions) -> win32more.Windows.Foundation.Uri: ...
    @winrt_mixinmethod
    def put_ExternalLocationUri(self: win32more.Windows.Management.Deployment.IRegisterPackageOptions, value: win32more.Windows.Foundation.Uri) -> Void: ...
    @winrt_mixinmethod
    def get_DeveloperMode(self: win32more.Windows.Management.Deployment.IRegisterPackageOptions) -> Boolean: ...
    @winrt_mixinmethod
    def put_DeveloperMode(self: win32more.Windows.Management.Deployment.IRegisterPackageOptions, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_ForceAppShutdown(self: win32more.Windows.Management.Deployment.IRegisterPackageOptions) -> Boolean: ...
    @winrt_mixinmethod
    def put_ForceAppShutdown(self: win32more.Windows.Management.Deployment.IRegisterPackageOptions, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_ForceTargetAppShutdown(self: win32more.Windows.Management.Deployment.IRegisterPackageOptions) -> Boolean: ...
    @winrt_mixinmethod
    def put_ForceTargetAppShutdown(self: win32more.Windows.Management.Deployment.IRegisterPackageOptions, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_ForceUpdateFromAnyVersion(self: win32more.Windows.Management.Deployment.IRegisterPackageOptions) -> Boolean: ...
    @winrt_mixinmethod
    def put_ForceUpdateFromAnyVersion(self: win32more.Windows.Management.Deployment.IRegisterPackageOptions, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_InstallAllResources(self: win32more.Windows.Management.Deployment.IRegisterPackageOptions) -> Boolean: ...
    @winrt_mixinmethod
    def put_InstallAllResources(self: win32more.Windows.Management.Deployment.IRegisterPackageOptions, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_StageInPlace(self: win32more.Windows.Management.Deployment.IRegisterPackageOptions) -> Boolean: ...
    @winrt_mixinmethod
    def put_StageInPlace(self: win32more.Windows.Management.Deployment.IRegisterPackageOptions, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_AllowUnsigned(self: win32more.Windows.Management.Deployment.IRegisterPackageOptions) -> Boolean: ...
    @winrt_mixinmethod
    def put_AllowUnsigned(self: win32more.Windows.Management.Deployment.IRegisterPackageOptions, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_DeferRegistrationWhenPackagesAreInUse(self: win32more.Windows.Management.Deployment.IRegisterPackageOptions) -> Boolean: ...
    @winrt_mixinmethod
    def put_DeferRegistrationWhenPackagesAreInUse(self: win32more.Windows.Management.Deployment.IRegisterPackageOptions, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_ExpectedDigests(self: win32more.Windows.Management.Deployment.IRegisterPackageOptions2) -> win32more.Windows.Foundation.Collections.IMap[win32more.Windows.Foundation.Uri, WinRT_String]: ...
    AllowUnsigned = property(get_AllowUnsigned, put_AllowUnsigned)
    AppDataVolume = property(get_AppDataVolume, put_AppDataVolume)
    DeferRegistrationWhenPackagesAreInUse = property(get_DeferRegistrationWhenPackagesAreInUse, put_DeferRegistrationWhenPackagesAreInUse)
    DependencyPackageUris = property(get_DependencyPackageUris, None)
    DeveloperMode = property(get_DeveloperMode, put_DeveloperMode)
    ExpectedDigests = property(get_ExpectedDigests, None)
    ExternalLocationUri = property(get_ExternalLocationUri, put_ExternalLocationUri)
    ForceAppShutdown = property(get_ForceAppShutdown, put_ForceAppShutdown)
    ForceTargetAppShutdown = property(get_ForceTargetAppShutdown, put_ForceTargetAppShutdown)
    ForceUpdateFromAnyVersion = property(get_ForceUpdateFromAnyVersion, put_ForceUpdateFromAnyVersion)
    InstallAllResources = property(get_InstallAllResources, put_InstallAllResources)
    OptionalPackageFamilyNames = property(get_OptionalPackageFamilyNames, None)
    StageInPlace = property(get_StageInPlace, put_StageInPlace)
class RemovalOptions(Enum, UInt32):
    None_ = 0
    PreserveApplicationData = 4096
    PreserveRoamableApplicationData = 128
    DeferRemovalWhenPackagesAreInUse = 8192
    RemoveForAllUsers = 524288
class RemovePackageOptions(ComPtr):
    extends: IInspectable
    default_interface: win32more.Windows.Management.Deployment.IRemovePackageOptions
    _classid_ = 'Windows.Management.Deployment.RemovePackageOptions'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 0:
            super().__init__(move=win32more.Windows.Management.Deployment.RemovePackageOptions.CreateInstance(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_activatemethod
    def CreateInstance(cls) -> win32more.Windows.Management.Deployment.RemovePackageOptions: ...
    @winrt_mixinmethod
    def get_PreserveApplicationData(self: win32more.Windows.Management.Deployment.IRemovePackageOptions) -> Boolean: ...
    @winrt_mixinmethod
    def put_PreserveApplicationData(self: win32more.Windows.Management.Deployment.IRemovePackageOptions, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_PreserveRoamableApplicationData(self: win32more.Windows.Management.Deployment.IRemovePackageOptions) -> Boolean: ...
    @winrt_mixinmethod
    def put_PreserveRoamableApplicationData(self: win32more.Windows.Management.Deployment.IRemovePackageOptions, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_RemoveForAllUsers(self: win32more.Windows.Management.Deployment.IRemovePackageOptions) -> Boolean: ...
    @winrt_mixinmethod
    def put_RemoveForAllUsers(self: win32more.Windows.Management.Deployment.IRemovePackageOptions, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_DeferRemovalWhenPackagesAreInUse(self: win32more.Windows.Management.Deployment.IRemovePackageOptions2) -> Boolean: ...
    @winrt_mixinmethod
    def put_DeferRemovalWhenPackagesAreInUse(self: win32more.Windows.Management.Deployment.IRemovePackageOptions2, value: Boolean) -> Void: ...
    DeferRemovalWhenPackagesAreInUse = property(get_DeferRemovalWhenPackagesAreInUse, put_DeferRemovalWhenPackagesAreInUse)
    PreserveApplicationData = property(get_PreserveApplicationData, put_PreserveApplicationData)
    PreserveRoamableApplicationData = property(get_PreserveRoamableApplicationData, put_PreserveRoamableApplicationData)
    RemoveForAllUsers = property(get_RemoveForAllUsers, put_RemoveForAllUsers)
class SharedPackageContainer(ComPtr):
    extends: IInspectable
    default_interface: win32more.Windows.Management.Deployment.ISharedPackageContainer
    _classid_ = 'Windows.Management.Deployment.SharedPackageContainer'
    @winrt_mixinmethod
    def get_Name(self: win32more.Windows.Management.Deployment.ISharedPackageContainer) -> WinRT_String: ...
    @winrt_mixinmethod
    def get_Id(self: win32more.Windows.Management.Deployment.ISharedPackageContainer) -> WinRT_String: ...
    @winrt_mixinmethod
    def GetMembers(self: win32more.Windows.Management.Deployment.ISharedPackageContainer) -> win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Management.Deployment.SharedPackageContainerMember]: ...
    @winrt_mixinmethod
    def RemovePackageFamily(self: win32more.Windows.Management.Deployment.ISharedPackageContainer, packageFamilyName: WinRT_String, options: win32more.Windows.Management.Deployment.UpdateSharedPackageContainerOptions) -> win32more.Windows.Management.Deployment.UpdateSharedPackageContainerResult: ...
    @winrt_mixinmethod
    def ResetData(self: win32more.Windows.Management.Deployment.ISharedPackageContainer) -> win32more.Windows.Management.Deployment.UpdateSharedPackageContainerResult: ...
    Id = property(get_Id, None)
    Name = property(get_Name, None)
SharedPackageContainerContract: UInt32 = 65536
class SharedPackageContainerCreationCollisionOptions(Enum, Int32):
    FailIfExists = 0
    MergeWithExisting = 1
    ReplaceExisting = 2
class SharedPackageContainerManager(ComPtr):
    extends: IInspectable
    default_interface: win32more.Windows.Management.Deployment.ISharedPackageContainerManager
    _classid_ = 'Windows.Management.Deployment.SharedPackageContainerManager'
    @winrt_mixinmethod
    def CreateContainer(self: win32more.Windows.Management.Deployment.ISharedPackageContainerManager, name: WinRT_String, options: win32more.Windows.Management.Deployment.CreateSharedPackageContainerOptions) -> win32more.Windows.Management.Deployment.CreateSharedPackageContainerResult: ...
    @winrt_mixinmethod
    def DeleteContainer(self: win32more.Windows.Management.Deployment.ISharedPackageContainerManager, id: WinRT_String, options: win32more.Windows.Management.Deployment.DeleteSharedPackageContainerOptions) -> win32more.Windows.Management.Deployment.DeleteSharedPackageContainerResult: ...
    @winrt_mixinmethod
    def GetContainer(self: win32more.Windows.Management.Deployment.ISharedPackageContainerManager, id: WinRT_String) -> win32more.Windows.Management.Deployment.SharedPackageContainer: ...
    @winrt_mixinmethod
    def FindContainers(self: win32more.Windows.Management.Deployment.ISharedPackageContainerManager) -> win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Management.Deployment.SharedPackageContainer]: ...
    @winrt_mixinmethod
    def FindContainersWithOptions(self: win32more.Windows.Management.Deployment.ISharedPackageContainerManager, options: win32more.Windows.Management.Deployment.FindSharedPackageContainerOptions) -> win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Management.Deployment.SharedPackageContainer]: ...
    @winrt_classmethod
    def GetDefault(cls: win32more.Windows.Management.Deployment.ISharedPackageContainerManagerStatics) -> win32more.Windows.Management.Deployment.SharedPackageContainerManager: ...
    @winrt_classmethod
    def GetForUser(cls: win32more.Windows.Management.Deployment.ISharedPackageContainerManagerStatics, userSid: WinRT_String) -> win32more.Windows.Management.Deployment.SharedPackageContainerManager: ...
    @winrt_classmethod
    def GetForProvisioning(cls: win32more.Windows.Management.Deployment.ISharedPackageContainerManagerStatics) -> win32more.Windows.Management.Deployment.SharedPackageContainerManager: ...
class SharedPackageContainerMember(ComPtr):
    extends: IInspectable
    default_interface: win32more.Windows.Management.Deployment.ISharedPackageContainerMember
    _classid_ = 'Windows.Management.Deployment.SharedPackageContainerMember'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 1:
            super().__init__(move=win32more.Windows.Management.Deployment.SharedPackageContainerMember.CreateInstance(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_factorymethod
    def CreateInstance(cls: win32more.Windows.Management.Deployment.ISharedPackageContainerMemberFactory, packageFamilyName: WinRT_String) -> win32more.Windows.Management.Deployment.SharedPackageContainerMember: ...
    @winrt_mixinmethod
    def get_PackageFamilyName(self: win32more.Windows.Management.Deployment.ISharedPackageContainerMember) -> WinRT_String: ...
    PackageFamilyName = property(get_PackageFamilyName, None)
class SharedPackageContainerOperationStatus(Enum, Int32):
    Success = 0
    BlockedByPolicy = 1
    AlreadyExists = 2
    PackageFamilyExistsInAnotherContainer = 3
    NotFound = 4
    UnknownFailure = 5
class StagePackageOptions(ComPtr):
    extends: IInspectable
    default_interface: win32more.Windows.Management.Deployment.IStagePackageOptions
    _classid_ = 'Windows.Management.Deployment.StagePackageOptions'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 0:
            super().__init__(move=win32more.Windows.Management.Deployment.StagePackageOptions.CreateInstance(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_activatemethod
    def CreateInstance(cls) -> win32more.Windows.Management.Deployment.StagePackageOptions: ...
    @winrt_mixinmethod
    def get_DependencyPackageUris(self: win32more.Windows.Management.Deployment.IStagePackageOptions) -> win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Foundation.Uri]: ...
    @winrt_mixinmethod
    def get_TargetVolume(self: win32more.Windows.Management.Deployment.IStagePackageOptions) -> win32more.Windows.Management.Deployment.PackageVolume: ...
    @winrt_mixinmethod
    def put_TargetVolume(self: win32more.Windows.Management.Deployment.IStagePackageOptions, value: win32more.Windows.Management.Deployment.PackageVolume) -> Void: ...
    @winrt_mixinmethod
    def get_OptionalPackageFamilyNames(self: win32more.Windows.Management.Deployment.IStagePackageOptions) -> win32more.Windows.Foundation.Collections.IVector[WinRT_String]: ...
    @winrt_mixinmethod
    def get_OptionalPackageUris(self: win32more.Windows.Management.Deployment.IStagePackageOptions) -> win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Foundation.Uri]: ...
    @winrt_mixinmethod
    def get_RelatedPackageUris(self: win32more.Windows.Management.Deployment.IStagePackageOptions) -> win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Foundation.Uri]: ...
    @winrt_mixinmethod
    def get_ExternalLocationUri(self: win32more.Windows.Management.Deployment.IStagePackageOptions) -> win32more.Windows.Foundation.Uri: ...
    @winrt_mixinmethod
    def put_ExternalLocationUri(self: win32more.Windows.Management.Deployment.IStagePackageOptions, value: win32more.Windows.Foundation.Uri) -> Void: ...
    @winrt_mixinmethod
    def get_StubPackageOption(self: win32more.Windows.Management.Deployment.IStagePackageOptions) -> win32more.Windows.Management.Deployment.StubPackageOption: ...
    @winrt_mixinmethod
    def put_StubPackageOption(self: win32more.Windows.Management.Deployment.IStagePackageOptions, value: win32more.Windows.Management.Deployment.StubPackageOption) -> Void: ...
    @winrt_mixinmethod
    def get_DeveloperMode(self: win32more.Windows.Management.Deployment.IStagePackageOptions) -> Boolean: ...
    @winrt_mixinmethod
    def put_DeveloperMode(self: win32more.Windows.Management.Deployment.IStagePackageOptions, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_ForceUpdateFromAnyVersion(self: win32more.Windows.Management.Deployment.IStagePackageOptions) -> Boolean: ...
    @winrt_mixinmethod
    def put_ForceUpdateFromAnyVersion(self: win32more.Windows.Management.Deployment.IStagePackageOptions, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_InstallAllResources(self: win32more.Windows.Management.Deployment.IStagePackageOptions) -> Boolean: ...
    @winrt_mixinmethod
    def put_InstallAllResources(self: win32more.Windows.Management.Deployment.IStagePackageOptions, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_RequiredContentGroupOnly(self: win32more.Windows.Management.Deployment.IStagePackageOptions) -> Boolean: ...
    @winrt_mixinmethod
    def put_RequiredContentGroupOnly(self: win32more.Windows.Management.Deployment.IStagePackageOptions, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_StageInPlace(self: win32more.Windows.Management.Deployment.IStagePackageOptions) -> Boolean: ...
    @winrt_mixinmethod
    def put_StageInPlace(self: win32more.Windows.Management.Deployment.IStagePackageOptions, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_AllowUnsigned(self: win32more.Windows.Management.Deployment.IStagePackageOptions) -> Boolean: ...
    @winrt_mixinmethod
    def put_AllowUnsigned(self: win32more.Windows.Management.Deployment.IStagePackageOptions, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_ExpectedDigests(self: win32more.Windows.Management.Deployment.IStagePackageOptions2) -> win32more.Windows.Foundation.Collections.IMap[win32more.Windows.Foundation.Uri, WinRT_String]: ...
    AllowUnsigned = property(get_AllowUnsigned, put_AllowUnsigned)
    DependencyPackageUris = property(get_DependencyPackageUris, None)
    DeveloperMode = property(get_DeveloperMode, put_DeveloperMode)
    ExpectedDigests = property(get_ExpectedDigests, None)
    ExternalLocationUri = property(get_ExternalLocationUri, put_ExternalLocationUri)
    ForceUpdateFromAnyVersion = property(get_ForceUpdateFromAnyVersion, put_ForceUpdateFromAnyVersion)
    InstallAllResources = property(get_InstallAllResources, put_InstallAllResources)
    OptionalPackageFamilyNames = property(get_OptionalPackageFamilyNames, None)
    OptionalPackageUris = property(get_OptionalPackageUris, None)
    RelatedPackageUris = property(get_RelatedPackageUris, None)
    RequiredContentGroupOnly = property(get_RequiredContentGroupOnly, put_RequiredContentGroupOnly)
    StageInPlace = property(get_StageInPlace, put_StageInPlace)
    StubPackageOption = property(get_StubPackageOption, put_StubPackageOption)
    TargetVolume = property(get_TargetVolume, put_TargetVolume)
class StubPackageOption(Enum, Int32):
    Default = 0
    InstallFull = 1
    InstallStub = 2
    UsePreference = 3
class UpdateSharedPackageContainerOptions(ComPtr):
    extends: IInspectable
    default_interface: win32more.Windows.Management.Deployment.IUpdateSharedPackageContainerOptions
    _classid_ = 'Windows.Management.Deployment.UpdateSharedPackageContainerOptions'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 0:
            super().__init__(move=win32more.Windows.Management.Deployment.UpdateSharedPackageContainerOptions.CreateInstance(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_activatemethod
    def CreateInstance(cls) -> win32more.Windows.Management.Deployment.UpdateSharedPackageContainerOptions: ...
    @winrt_mixinmethod
    def get_ForceAppShutdown(self: win32more.Windows.Management.Deployment.IUpdateSharedPackageContainerOptions) -> Boolean: ...
    @winrt_mixinmethod
    def put_ForceAppShutdown(self: win32more.Windows.Management.Deployment.IUpdateSharedPackageContainerOptions, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_RequirePackagesPresent(self: win32more.Windows.Management.Deployment.IUpdateSharedPackageContainerOptions) -> Boolean: ...
    @winrt_mixinmethod
    def put_RequirePackagesPresent(self: win32more.Windows.Management.Deployment.IUpdateSharedPackageContainerOptions, value: Boolean) -> Void: ...
    ForceAppShutdown = property(get_ForceAppShutdown, put_ForceAppShutdown)
    RequirePackagesPresent = property(get_RequirePackagesPresent, put_RequirePackagesPresent)
class UpdateSharedPackageContainerResult(ComPtr):
    extends: IInspectable
    default_interface: win32more.Windows.Management.Deployment.IUpdateSharedPackageContainerResult
    _classid_ = 'Windows.Management.Deployment.UpdateSharedPackageContainerResult'
    @winrt_mixinmethod
    def get_Status(self: win32more.Windows.Management.Deployment.IUpdateSharedPackageContainerResult) -> win32more.Windows.Management.Deployment.SharedPackageContainerOperationStatus: ...
    @winrt_mixinmethod
    def get_ExtendedError(self: win32more.Windows.Management.Deployment.IUpdateSharedPackageContainerResult) -> win32more.Windows.Foundation.HResult: ...
    ExtendedError = property(get_ExtendedError, None)
    Status = property(get_Status, None)


make_ready(__name__)
