from __future__ import annotations
from win32more.winrt.prelude import *
import win32more.Windows.Foundation
import win32more.Windows.Foundation.Collections
import win32more.Windows.Networking
import win32more.Windows.Networking.Proximity
import win32more.Windows.Networking.Sockets
import win32more.Windows.Storage.Streams
class ConnectionRequestedEventArgs(ComPtr):
    extends: IInspectable
    default_interface: win32more.Windows.Networking.Proximity.IConnectionRequestedEventArgs
    _classid_ = 'Windows.Networking.Proximity.ConnectionRequestedEventArgs'
    @winrt_mixinmethod
    def get_PeerInformation(self: win32more.Windows.Networking.Proximity.IConnectionRequestedEventArgs) -> win32more.Windows.Networking.Proximity.PeerInformation: ...
    PeerInformation = property(get_PeerInformation, None)
class DeviceArrivedEventHandler(MulticastDelegate):
    extends: IUnknown
    _iid_ = Guid('{efa9da69-f6e1-49c9-a49e-8e0fc58fb911}')
    @winrt_commethod(3)
    def Invoke(self, sender: win32more.Windows.Networking.Proximity.ProximityDevice) -> Void: ...
class DeviceDepartedEventHandler(MulticastDelegate):
    extends: IUnknown
    _iid_ = Guid('{efa9da69-f6e2-49c9-a49e-8e0fc58fb911}')
    @winrt_commethod(3)
    def Invoke(self, sender: win32more.Windows.Networking.Proximity.ProximityDevice) -> Void: ...
class IConnectionRequestedEventArgs(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Networking.Proximity.IConnectionRequestedEventArgs'
    _iid_ = Guid('{eb6891ae-4f1e-4c66-bd0d-46924a942e08}')
    @winrt_commethod(6)
    def get_PeerInformation(self) -> win32more.Windows.Networking.Proximity.PeerInformation: ...
    PeerInformation = property(get_PeerInformation, None)
class IPeerFinderStatics(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Networking.Proximity.IPeerFinderStatics'
    _iid_ = Guid('{914b3b61-f6e1-47c4-a14c-148a1903d0c6}')
    @winrt_commethod(6)
    def get_AllowBluetooth(self) -> Boolean: ...
    @winrt_commethod(7)
    def put_AllowBluetooth(self, value: Boolean) -> Void: ...
    @winrt_commethod(8)
    def get_AllowInfrastructure(self) -> Boolean: ...
    @winrt_commethod(9)
    def put_AllowInfrastructure(self, value: Boolean) -> Void: ...
    @winrt_commethod(10)
    def get_AllowWiFiDirect(self) -> Boolean: ...
    @winrt_commethod(11)
    def put_AllowWiFiDirect(self, value: Boolean) -> Void: ...
    @winrt_commethod(12)
    def get_DisplayName(self) -> WinRT_String: ...
    @winrt_commethod(13)
    def put_DisplayName(self, value: WinRT_String) -> Void: ...
    @winrt_commethod(14)
    def get_SupportedDiscoveryTypes(self) -> win32more.Windows.Networking.Proximity.PeerDiscoveryTypes: ...
    @winrt_commethod(15)
    def get_AlternateIdentities(self) -> win32more.Windows.Foundation.Collections.IMap[WinRT_String, WinRT_String]: ...
    @winrt_commethod(16)
    def Start(self) -> Void: ...
    @winrt_commethod(17)
    def StartWithMessage(self, peerMessage: WinRT_String) -> Void: ...
    @winrt_commethod(18)
    def Stop(self) -> Void: ...
    @winrt_commethod(19)
    def add_TriggeredConnectionStateChanged(self, handler: win32more.Windows.Foundation.TypedEventHandler[IInspectable, win32more.Windows.Networking.Proximity.TriggeredConnectionStateChangedEventArgs]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_commethod(20)
    def remove_TriggeredConnectionStateChanged(self, cookie: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_commethod(21)
    def add_ConnectionRequested(self, handler: win32more.Windows.Foundation.TypedEventHandler[IInspectable, win32more.Windows.Networking.Proximity.ConnectionRequestedEventArgs]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_commethod(22)
    def remove_ConnectionRequested(self, cookie: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_commethod(23)
    def FindAllPeersAsync(self) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Windows.Foundation.Collections.IVectorView[win32more.Windows.Networking.Proximity.PeerInformation]]: ...
    @winrt_commethod(24)
    def ConnectAsync(self, peerInformation: win32more.Windows.Networking.Proximity.PeerInformation) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Windows.Networking.Sockets.StreamSocket]: ...
    AllowBluetooth = property(get_AllowBluetooth, put_AllowBluetooth)
    AllowInfrastructure = property(get_AllowInfrastructure, put_AllowInfrastructure)
    AllowWiFiDirect = property(get_AllowWiFiDirect, put_AllowWiFiDirect)
    AlternateIdentities = property(get_AlternateIdentities, None)
    DisplayName = property(get_DisplayName, put_DisplayName)
    SupportedDiscoveryTypes = property(get_SupportedDiscoveryTypes, None)
    TriggeredConnectionStateChanged = event()
    ConnectionRequested = event()
class IPeerFinderStatics2(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Networking.Proximity.IPeerFinderStatics2'
    _iid_ = Guid('{d6e73c65-fdd0-4b0b-9312-866408935d82}')
    @winrt_commethod(6)
    def get_Role(self) -> win32more.Windows.Networking.Proximity.PeerRole: ...
    @winrt_commethod(7)
    def put_Role(self, value: win32more.Windows.Networking.Proximity.PeerRole) -> Void: ...
    @winrt_commethod(8)
    def get_DiscoveryData(self) -> win32more.Windows.Storage.Streams.IBuffer: ...
    @winrt_commethod(9)
    def put_DiscoveryData(self, value: win32more.Windows.Storage.Streams.IBuffer) -> Void: ...
    @winrt_commethod(10)
    def CreateWatcher(self) -> win32more.Windows.Networking.Proximity.PeerWatcher: ...
    DiscoveryData = property(get_DiscoveryData, put_DiscoveryData)
    Role = property(get_Role, put_Role)
class IPeerInformation(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Networking.Proximity.IPeerInformation'
    _iid_ = Guid('{20024f08-9fff-45f4-b6e9-408b2ebef373}')
    @winrt_commethod(6)
    def get_DisplayName(self) -> WinRT_String: ...
    DisplayName = property(get_DisplayName, None)
class IPeerInformation3(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Networking.Proximity.IPeerInformation3'
    _iid_ = Guid('{b20f612a-dbd0-40f8-95bd-2d4209c7836f}')
    @winrt_commethod(6)
    def get_Id(self) -> WinRT_String: ...
    @winrt_commethod(7)
    def get_DiscoveryData(self) -> win32more.Windows.Storage.Streams.IBuffer: ...
    DiscoveryData = property(get_DiscoveryData, None)
    Id = property(get_Id, None)
class IPeerInformationWithHostAndService(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Networking.Proximity.IPeerInformationWithHostAndService'
    _iid_ = Guid('{ecc7ccad-1b70-4e8b-92db-bbe781419308}')
    @winrt_commethod(6)
    def get_HostName(self) -> win32more.Windows.Networking.HostName: ...
    @winrt_commethod(7)
    def get_ServiceName(self) -> WinRT_String: ...
    HostName = property(get_HostName, None)
    ServiceName = property(get_ServiceName, None)
class IPeerWatcher(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Networking.Proximity.IPeerWatcher'
    _iid_ = Guid('{3cee21f8-2fa6-4679-9691-03c94a420f34}')
    @winrt_commethod(6)
    def add_Added(self, handler: win32more.Windows.Foundation.TypedEventHandler[win32more.Windows.Networking.Proximity.PeerWatcher, win32more.Windows.Networking.Proximity.PeerInformation]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_commethod(7)
    def remove_Added(self, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_commethod(8)
    def add_Removed(self, handler: win32more.Windows.Foundation.TypedEventHandler[win32more.Windows.Networking.Proximity.PeerWatcher, win32more.Windows.Networking.Proximity.PeerInformation]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_commethod(9)
    def remove_Removed(self, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_commethod(10)
    def add_Updated(self, handler: win32more.Windows.Foundation.TypedEventHandler[win32more.Windows.Networking.Proximity.PeerWatcher, win32more.Windows.Networking.Proximity.PeerInformation]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_commethod(11)
    def remove_Updated(self, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_commethod(12)
    def add_EnumerationCompleted(self, handler: win32more.Windows.Foundation.TypedEventHandler[win32more.Windows.Networking.Proximity.PeerWatcher, IInspectable]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_commethod(13)
    def remove_EnumerationCompleted(self, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_commethod(14)
    def add_Stopped(self, handler: win32more.Windows.Foundation.TypedEventHandler[win32more.Windows.Networking.Proximity.PeerWatcher, IInspectable]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_commethod(15)
    def remove_Stopped(self, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_commethod(16)
    def get_Status(self) -> win32more.Windows.Networking.Proximity.PeerWatcherStatus: ...
    @winrt_commethod(17)
    def Start(self) -> Void: ...
    @winrt_commethod(18)
    def Stop(self) -> Void: ...
    Status = property(get_Status, None)
    Added = event()
    Removed = event()
    Updated = event()
    EnumerationCompleted = event()
    Stopped = event()
class IProximityDevice(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Networking.Proximity.IProximityDevice'
    _iid_ = Guid('{efa8a552-f6e1-4329-a0fc-ab6b0fd28262}')
    @winrt_commethod(6)
    def SubscribeForMessage(self, messageType: WinRT_String, messageReceivedHandler: win32more.Windows.Networking.Proximity.MessageReceivedHandler) -> Int64: ...
    @winrt_commethod(7)
    def PublishMessage(self, messageType: WinRT_String, message: WinRT_String) -> Int64: ...
    @winrt_commethod(8)
    def PublishMessageWithCallback(self, messageType: WinRT_String, message: WinRT_String, messageTransmittedHandler: win32more.Windows.Networking.Proximity.MessageTransmittedHandler) -> Int64: ...
    @winrt_commethod(9)
    def PublishBinaryMessage(self, messageType: WinRT_String, message: win32more.Windows.Storage.Streams.IBuffer) -> Int64: ...
    @winrt_commethod(10)
    def PublishBinaryMessageWithCallback(self, messageType: WinRT_String, message: win32more.Windows.Storage.Streams.IBuffer, messageTransmittedHandler: win32more.Windows.Networking.Proximity.MessageTransmittedHandler) -> Int64: ...
    @winrt_commethod(11)
    def PublishUriMessage(self, message: win32more.Windows.Foundation.Uri) -> Int64: ...
    @winrt_commethod(12)
    def PublishUriMessageWithCallback(self, message: win32more.Windows.Foundation.Uri, messageTransmittedHandler: win32more.Windows.Networking.Proximity.MessageTransmittedHandler) -> Int64: ...
    @winrt_commethod(13)
    def StopSubscribingForMessage(self, subscriptionId: Int64) -> Void: ...
    @winrt_commethod(14)
    def StopPublishingMessage(self, messageId: Int64) -> Void: ...
    @winrt_commethod(15)
    def add_DeviceArrived(self, arrivedHandler: win32more.Windows.Networking.Proximity.DeviceArrivedEventHandler) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_commethod(16)
    def remove_DeviceArrived(self, cookie: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_commethod(17)
    def add_DeviceDeparted(self, departedHandler: win32more.Windows.Networking.Proximity.DeviceDepartedEventHandler) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_commethod(18)
    def remove_DeviceDeparted(self, cookie: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_commethod(19)
    def get_MaxMessageBytes(self) -> UInt32: ...
    @winrt_commethod(20)
    def get_BitsPerSecond(self) -> UInt64: ...
    @winrt_commethod(21)
    def get_DeviceId(self) -> WinRT_String: ...
    BitsPerSecond = property(get_BitsPerSecond, None)
    DeviceId = property(get_DeviceId, None)
    MaxMessageBytes = property(get_MaxMessageBytes, None)
    DeviceArrived = event()
    DeviceDeparted = event()
class IProximityDeviceStatics(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Networking.Proximity.IProximityDeviceStatics'
    _iid_ = Guid('{914ba01d-f6e1-47c4-a14c-148a1903d0c6}')
    @winrt_commethod(6)
    def GetDeviceSelector(self) -> WinRT_String: ...
    @winrt_commethod(7)
    def GetDefault(self) -> win32more.Windows.Networking.Proximity.ProximityDevice: ...
    @winrt_commethod(8)
    def FromId(self, deviceId: WinRT_String) -> win32more.Windows.Networking.Proximity.ProximityDevice: ...
class IProximityMessage(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Networking.Proximity.IProximityMessage'
    _iid_ = Guid('{efab0782-f6e1-4675-a045-d8e320c24808}')
    @winrt_commethod(6)
    def get_MessageType(self) -> WinRT_String: ...
    @winrt_commethod(7)
    def get_SubscriptionId(self) -> Int64: ...
    @winrt_commethod(8)
    def get_Data(self) -> win32more.Windows.Storage.Streams.IBuffer: ...
    @winrt_commethod(9)
    def get_DataAsString(self) -> WinRT_String: ...
    Data = property(get_Data, None)
    DataAsString = property(get_DataAsString, None)
    MessageType = property(get_MessageType, None)
    SubscriptionId = property(get_SubscriptionId, None)
class ITriggeredConnectionStateChangedEventArgs(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Networking.Proximity.ITriggeredConnectionStateChangedEventArgs'
    _iid_ = Guid('{c6a780ad-f6e1-4d54-96e2-33f620bca88a}')
    @winrt_commethod(6)
    def get_State(self) -> win32more.Windows.Networking.Proximity.TriggeredConnectState: ...
    @winrt_commethod(7)
    def get_Id(self) -> UInt32: ...
    @winrt_commethod(8)
    def get_Socket(self) -> win32more.Windows.Networking.Sockets.StreamSocket: ...
    Id = property(get_Id, None)
    Socket = property(get_Socket, None)
    State = property(get_State, None)
class MessageReceivedHandler(MulticastDelegate):
    extends: IUnknown
    _iid_ = Guid('{efab0782-f6e2-4675-a045-d8e320c24808}')
    @winrt_commethod(3)
    def Invoke(self, sender: win32more.Windows.Networking.Proximity.ProximityDevice, message: win32more.Windows.Networking.Proximity.ProximityMessage) -> Void: ...
class MessageTransmittedHandler(MulticastDelegate):
    extends: IUnknown
    _iid_ = Guid('{efaa0b4a-f6e2-4d7d-856c-78fc8efc021e}')
    @winrt_commethod(3)
    def Invoke(self, sender: win32more.Windows.Networking.Proximity.ProximityDevice, messageId: Int64) -> Void: ...
class PeerDiscoveryTypes(Enum, UInt32):
    None_ = 0
    Browse = 1
    Triggered = 2
class _PeerFinder_Meta_(ComPtr.__class__):
    pass
class PeerFinder(ComPtr, metaclass=_PeerFinder_Meta_):
    extends: IInspectable
    _classid_ = 'Windows.Networking.Proximity.PeerFinder'
    @winrt_classmethod
    def get_Role(cls: win32more.Windows.Networking.Proximity.IPeerFinderStatics2) -> win32more.Windows.Networking.Proximity.PeerRole: ...
    @winrt_classmethod
    def put_Role(cls: win32more.Windows.Networking.Proximity.IPeerFinderStatics2, value: win32more.Windows.Networking.Proximity.PeerRole) -> Void: ...
    @winrt_classmethod
    def get_DiscoveryData(cls: win32more.Windows.Networking.Proximity.IPeerFinderStatics2) -> win32more.Windows.Storage.Streams.IBuffer: ...
    @winrt_classmethod
    def put_DiscoveryData(cls: win32more.Windows.Networking.Proximity.IPeerFinderStatics2, value: win32more.Windows.Storage.Streams.IBuffer) -> Void: ...
    @winrt_classmethod
    def CreateWatcher(cls: win32more.Windows.Networking.Proximity.IPeerFinderStatics2) -> win32more.Windows.Networking.Proximity.PeerWatcher: ...
    @winrt_classmethod
    def get_AllowBluetooth(cls: win32more.Windows.Networking.Proximity.IPeerFinderStatics) -> Boolean: ...
    @winrt_classmethod
    def put_AllowBluetooth(cls: win32more.Windows.Networking.Proximity.IPeerFinderStatics, value: Boolean) -> Void: ...
    @winrt_classmethod
    def get_AllowInfrastructure(cls: win32more.Windows.Networking.Proximity.IPeerFinderStatics) -> Boolean: ...
    @winrt_classmethod
    def put_AllowInfrastructure(cls: win32more.Windows.Networking.Proximity.IPeerFinderStatics, value: Boolean) -> Void: ...
    @winrt_classmethod
    def get_AllowWiFiDirect(cls: win32more.Windows.Networking.Proximity.IPeerFinderStatics) -> Boolean: ...
    @winrt_classmethod
    def put_AllowWiFiDirect(cls: win32more.Windows.Networking.Proximity.IPeerFinderStatics, value: Boolean) -> Void: ...
    @winrt_classmethod
    def get_DisplayName(cls: win32more.Windows.Networking.Proximity.IPeerFinderStatics) -> WinRT_String: ...
    @winrt_classmethod
    def put_DisplayName(cls: win32more.Windows.Networking.Proximity.IPeerFinderStatics, value: WinRT_String) -> Void: ...
    @winrt_classmethod
    def get_SupportedDiscoveryTypes(cls: win32more.Windows.Networking.Proximity.IPeerFinderStatics) -> win32more.Windows.Networking.Proximity.PeerDiscoveryTypes: ...
    @winrt_classmethod
    def get_AlternateIdentities(cls: win32more.Windows.Networking.Proximity.IPeerFinderStatics) -> win32more.Windows.Foundation.Collections.IMap[WinRT_String, WinRT_String]: ...
    @winrt_classmethod
    def Start(cls: win32more.Windows.Networking.Proximity.IPeerFinderStatics) -> Void: ...
    @winrt_classmethod
    def StartWithMessage(cls: win32more.Windows.Networking.Proximity.IPeerFinderStatics, peerMessage: WinRT_String) -> Void: ...
    @winrt_classmethod
    def Stop(cls: win32more.Windows.Networking.Proximity.IPeerFinderStatics) -> Void: ...
    @winrt_classmethod
    def add_TriggeredConnectionStateChanged(cls: win32more.Windows.Networking.Proximity.IPeerFinderStatics, handler: win32more.Windows.Foundation.TypedEventHandler[IInspectable, win32more.Windows.Networking.Proximity.TriggeredConnectionStateChangedEventArgs]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_classmethod
    def remove_TriggeredConnectionStateChanged(cls: win32more.Windows.Networking.Proximity.IPeerFinderStatics, cookie: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_classmethod
    def add_ConnectionRequested(cls: win32more.Windows.Networking.Proximity.IPeerFinderStatics, handler: win32more.Windows.Foundation.TypedEventHandler[IInspectable, win32more.Windows.Networking.Proximity.ConnectionRequestedEventArgs]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_classmethod
    def remove_ConnectionRequested(cls: win32more.Windows.Networking.Proximity.IPeerFinderStatics, cookie: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_classmethod
    def FindAllPeersAsync(cls: win32more.Windows.Networking.Proximity.IPeerFinderStatics) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Windows.Foundation.Collections.IVectorView[win32more.Windows.Networking.Proximity.PeerInformation]]: ...
    @winrt_classmethod
    def ConnectAsync(cls: win32more.Windows.Networking.Proximity.IPeerFinderStatics, peerInformation: win32more.Windows.Networking.Proximity.PeerInformation) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Windows.Networking.Sockets.StreamSocket]: ...
    _PeerFinder_Meta_.AllowBluetooth = property(get_AllowBluetooth, put_AllowBluetooth)
    _PeerFinder_Meta_.AllowInfrastructure = property(get_AllowInfrastructure, put_AllowInfrastructure)
    _PeerFinder_Meta_.AllowWiFiDirect = property(get_AllowWiFiDirect, put_AllowWiFiDirect)
    _PeerFinder_Meta_.AlternateIdentities = property(get_AlternateIdentities, None)
    _PeerFinder_Meta_.DiscoveryData = property(get_DiscoveryData, put_DiscoveryData)
    _PeerFinder_Meta_.DisplayName = property(get_DisplayName, put_DisplayName)
    _PeerFinder_Meta_.Role = property(get_Role, put_Role)
    _PeerFinder_Meta_.SupportedDiscoveryTypes = property(get_SupportedDiscoveryTypes, None)
class PeerInformation(ComPtr):
    extends: IInspectable
    default_interface: win32more.Windows.Networking.Proximity.IPeerInformation
    _classid_ = 'Windows.Networking.Proximity.PeerInformation'
    @winrt_mixinmethod
    def get_DisplayName(self: win32more.Windows.Networking.Proximity.IPeerInformation) -> WinRT_String: ...
    @winrt_mixinmethod
    def get_Id(self: win32more.Windows.Networking.Proximity.IPeerInformation3) -> WinRT_String: ...
    @winrt_mixinmethod
    def get_DiscoveryData(self: win32more.Windows.Networking.Proximity.IPeerInformation3) -> win32more.Windows.Storage.Streams.IBuffer: ...
    @winrt_mixinmethod
    def get_HostName(self: win32more.Windows.Networking.Proximity.IPeerInformationWithHostAndService) -> win32more.Windows.Networking.HostName: ...
    @winrt_mixinmethod
    def get_ServiceName(self: win32more.Windows.Networking.Proximity.IPeerInformationWithHostAndService) -> WinRT_String: ...
    DiscoveryData = property(get_DiscoveryData, None)
    DisplayName = property(get_DisplayName, None)
    HostName = property(get_HostName, None)
    Id = property(get_Id, None)
    ServiceName = property(get_ServiceName, None)
class PeerRole(Enum, Int32):
    Peer = 0
    Host = 1
    Client = 2
class PeerWatcher(ComPtr):
    extends: IInspectable
    default_interface: win32more.Windows.Networking.Proximity.IPeerWatcher
    _classid_ = 'Windows.Networking.Proximity.PeerWatcher'
    @winrt_mixinmethod
    def add_Added(self: win32more.Windows.Networking.Proximity.IPeerWatcher, handler: win32more.Windows.Foundation.TypedEventHandler[win32more.Windows.Networking.Proximity.PeerWatcher, win32more.Windows.Networking.Proximity.PeerInformation]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_mixinmethod
    def remove_Added(self: win32more.Windows.Networking.Proximity.IPeerWatcher, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_mixinmethod
    def add_Removed(self: win32more.Windows.Networking.Proximity.IPeerWatcher, handler: win32more.Windows.Foundation.TypedEventHandler[win32more.Windows.Networking.Proximity.PeerWatcher, win32more.Windows.Networking.Proximity.PeerInformation]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_mixinmethod
    def remove_Removed(self: win32more.Windows.Networking.Proximity.IPeerWatcher, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_mixinmethod
    def add_Updated(self: win32more.Windows.Networking.Proximity.IPeerWatcher, handler: win32more.Windows.Foundation.TypedEventHandler[win32more.Windows.Networking.Proximity.PeerWatcher, win32more.Windows.Networking.Proximity.PeerInformation]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_mixinmethod
    def remove_Updated(self: win32more.Windows.Networking.Proximity.IPeerWatcher, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_mixinmethod
    def add_EnumerationCompleted(self: win32more.Windows.Networking.Proximity.IPeerWatcher, handler: win32more.Windows.Foundation.TypedEventHandler[win32more.Windows.Networking.Proximity.PeerWatcher, IInspectable]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_mixinmethod
    def remove_EnumerationCompleted(self: win32more.Windows.Networking.Proximity.IPeerWatcher, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_mixinmethod
    def add_Stopped(self: win32more.Windows.Networking.Proximity.IPeerWatcher, handler: win32more.Windows.Foundation.TypedEventHandler[win32more.Windows.Networking.Proximity.PeerWatcher, IInspectable]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_mixinmethod
    def remove_Stopped(self: win32more.Windows.Networking.Proximity.IPeerWatcher, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_mixinmethod
    def get_Status(self: win32more.Windows.Networking.Proximity.IPeerWatcher) -> win32more.Windows.Networking.Proximity.PeerWatcherStatus: ...
    @winrt_mixinmethod
    def Start(self: win32more.Windows.Networking.Proximity.IPeerWatcher) -> Void: ...
    @winrt_mixinmethod
    def Stop(self: win32more.Windows.Networking.Proximity.IPeerWatcher) -> Void: ...
    Status = property(get_Status, None)
    Added = event()
    Removed = event()
    Updated = event()
    EnumerationCompleted = event()
    Stopped = event()
class PeerWatcherStatus(Enum, Int32):
    Created = 0
    Started = 1
    EnumerationCompleted = 2
    Stopping = 3
    Stopped = 4
    Aborted = 5
class ProximityDevice(ComPtr):
    extends: IInspectable
    default_interface: win32more.Windows.Networking.Proximity.IProximityDevice
    _classid_ = 'Windows.Networking.Proximity.ProximityDevice'
    @winrt_mixinmethod
    def SubscribeForMessage(self: win32more.Windows.Networking.Proximity.IProximityDevice, messageType: WinRT_String, messageReceivedHandler: win32more.Windows.Networking.Proximity.MessageReceivedHandler) -> Int64: ...
    @winrt_mixinmethod
    def PublishMessage(self: win32more.Windows.Networking.Proximity.IProximityDevice, messageType: WinRT_String, message: WinRT_String) -> Int64: ...
    @winrt_mixinmethod
    def PublishMessageWithCallback(self: win32more.Windows.Networking.Proximity.IProximityDevice, messageType: WinRT_String, message: WinRT_String, messageTransmittedHandler: win32more.Windows.Networking.Proximity.MessageTransmittedHandler) -> Int64: ...
    @winrt_mixinmethod
    def PublishBinaryMessage(self: win32more.Windows.Networking.Proximity.IProximityDevice, messageType: WinRT_String, message: win32more.Windows.Storage.Streams.IBuffer) -> Int64: ...
    @winrt_mixinmethod
    def PublishBinaryMessageWithCallback(self: win32more.Windows.Networking.Proximity.IProximityDevice, messageType: WinRT_String, message: win32more.Windows.Storage.Streams.IBuffer, messageTransmittedHandler: win32more.Windows.Networking.Proximity.MessageTransmittedHandler) -> Int64: ...
    @winrt_mixinmethod
    def PublishUriMessage(self: win32more.Windows.Networking.Proximity.IProximityDevice, message: win32more.Windows.Foundation.Uri) -> Int64: ...
    @winrt_mixinmethod
    def PublishUriMessageWithCallback(self: win32more.Windows.Networking.Proximity.IProximityDevice, message: win32more.Windows.Foundation.Uri, messageTransmittedHandler: win32more.Windows.Networking.Proximity.MessageTransmittedHandler) -> Int64: ...
    @winrt_mixinmethod
    def StopSubscribingForMessage(self: win32more.Windows.Networking.Proximity.IProximityDevice, subscriptionId: Int64) -> Void: ...
    @winrt_mixinmethod
    def StopPublishingMessage(self: win32more.Windows.Networking.Proximity.IProximityDevice, messageId: Int64) -> Void: ...
    @winrt_mixinmethod
    def add_DeviceArrived(self: win32more.Windows.Networking.Proximity.IProximityDevice, arrivedHandler: win32more.Windows.Networking.Proximity.DeviceArrivedEventHandler) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_mixinmethod
    def remove_DeviceArrived(self: win32more.Windows.Networking.Proximity.IProximityDevice, cookie: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_mixinmethod
    def add_DeviceDeparted(self: win32more.Windows.Networking.Proximity.IProximityDevice, departedHandler: win32more.Windows.Networking.Proximity.DeviceDepartedEventHandler) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_mixinmethod
    def remove_DeviceDeparted(self: win32more.Windows.Networking.Proximity.IProximityDevice, cookie: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_mixinmethod
    def get_MaxMessageBytes(self: win32more.Windows.Networking.Proximity.IProximityDevice) -> UInt32: ...
    @winrt_mixinmethod
    def get_BitsPerSecond(self: win32more.Windows.Networking.Proximity.IProximityDevice) -> UInt64: ...
    @winrt_mixinmethod
    def get_DeviceId(self: win32more.Windows.Networking.Proximity.IProximityDevice) -> WinRT_String: ...
    @winrt_classmethod
    def GetDeviceSelector(cls: win32more.Windows.Networking.Proximity.IProximityDeviceStatics) -> WinRT_String: ...
    @winrt_classmethod
    def GetDefault(cls: win32more.Windows.Networking.Proximity.IProximityDeviceStatics) -> win32more.Windows.Networking.Proximity.ProximityDevice: ...
    @winrt_classmethod
    def FromId(cls: win32more.Windows.Networking.Proximity.IProximityDeviceStatics, deviceId: WinRT_String) -> win32more.Windows.Networking.Proximity.ProximityDevice: ...
    BitsPerSecond = property(get_BitsPerSecond, None)
    DeviceId = property(get_DeviceId, None)
    MaxMessageBytes = property(get_MaxMessageBytes, None)
    DeviceArrived = event()
    DeviceDeparted = event()
class ProximityMessage(ComPtr):
    extends: IInspectable
    default_interface: win32more.Windows.Networking.Proximity.IProximityMessage
    _classid_ = 'Windows.Networking.Proximity.ProximityMessage'
    @winrt_mixinmethod
    def get_MessageType(self: win32more.Windows.Networking.Proximity.IProximityMessage) -> WinRT_String: ...
    @winrt_mixinmethod
    def get_SubscriptionId(self: win32more.Windows.Networking.Proximity.IProximityMessage) -> Int64: ...
    @winrt_mixinmethod
    def get_Data(self: win32more.Windows.Networking.Proximity.IProximityMessage) -> win32more.Windows.Storage.Streams.IBuffer: ...
    @winrt_mixinmethod
    def get_DataAsString(self: win32more.Windows.Networking.Proximity.IProximityMessage) -> WinRT_String: ...
    Data = property(get_Data, None)
    DataAsString = property(get_DataAsString, None)
    MessageType = property(get_MessageType, None)
    SubscriptionId = property(get_SubscriptionId, None)
class TriggeredConnectState(Enum, Int32):
    PeerFound = 0
    Listening = 1
    Connecting = 2
    Completed = 3
    Canceled = 4
    Failed = 5
class TriggeredConnectionStateChangedEventArgs(ComPtr):
    extends: IInspectable
    default_interface: win32more.Windows.Networking.Proximity.ITriggeredConnectionStateChangedEventArgs
    _classid_ = 'Windows.Networking.Proximity.TriggeredConnectionStateChangedEventArgs'
    @winrt_mixinmethod
    def get_State(self: win32more.Windows.Networking.Proximity.ITriggeredConnectionStateChangedEventArgs) -> win32more.Windows.Networking.Proximity.TriggeredConnectState: ...
    @winrt_mixinmethod
    def get_Id(self: win32more.Windows.Networking.Proximity.ITriggeredConnectionStateChangedEventArgs) -> UInt32: ...
    @winrt_mixinmethod
    def get_Socket(self: win32more.Windows.Networking.Proximity.ITriggeredConnectionStateChangedEventArgs) -> win32more.Windows.Networking.Sockets.StreamSocket: ...
    Id = property(get_Id, None)
    Socket = property(get_Socket, None)
    State = property(get_State, None)


make_ready(__name__)
