from __future__ import annotations
from win32more.winrt.prelude import *
import win32more.Windows.Foundation
import win32more.Windows.Foundation.Collections
import win32more.Windows.Storage
import win32more.Windows.Storage.Streams
import win32more.Windows.System
class Buffer(ComPtr):
    extends: IInspectable
    default_interface: win32more.Windows.Storage.Streams.IBuffer
    _classid_ = 'Windows.Storage.Streams.Buffer'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 1:
            super().__init__(move=win32more.Windows.Storage.Streams.Buffer.Create(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_factorymethod
    def Create(cls: win32more.Windows.Storage.Streams.IBufferFactory, capacity: UInt32) -> win32more.Windows.Storage.Streams.Buffer: ...
    @winrt_mixinmethod
    def get_Capacity(self: win32more.Windows.Storage.Streams.IBuffer) -> UInt32: ...
    @winrt_mixinmethod
    def get_Length(self: win32more.Windows.Storage.Streams.IBuffer) -> UInt32: ...
    @winrt_mixinmethod
    def put_Length(self: win32more.Windows.Storage.Streams.IBuffer, value: UInt32) -> Void: ...
    @winrt_classmethod
    def CreateCopyFromMemoryBuffer(cls: win32more.Windows.Storage.Streams.IBufferStatics, input: win32more.Windows.Foundation.IMemoryBuffer) -> win32more.Windows.Storage.Streams.Buffer: ...
    @winrt_classmethod
    def CreateMemoryBufferOverIBuffer(cls: win32more.Windows.Storage.Streams.IBufferStatics, input: win32more.Windows.Storage.Streams.IBuffer) -> win32more.Windows.Foundation.MemoryBuffer: ...
    Capacity = property(get_Capacity, None)
    Length = property(get_Length, put_Length)
class ByteOrder(Enum, Int32):
    LittleEndian = 0
    BigEndian = 1
class DataReader(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    default_interface: win32more.Windows.Storage.Streams.IDataReader
    _classid_ = 'Windows.Storage.Streams.DataReader'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 1:
            super().__init__(move=win32more.Windows.Storage.Streams.DataReader.CreateDataReader(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_factorymethod
    def CreateDataReader(cls: win32more.Windows.Storage.Streams.IDataReaderFactory, inputStream: win32more.Windows.Storage.Streams.IInputStream) -> win32more.Windows.Storage.Streams.DataReader: ...
    @winrt_mixinmethod
    def get_UnconsumedBufferLength(self: win32more.Windows.Storage.Streams.IDataReader) -> UInt32: ...
    @winrt_mixinmethod
    def get_UnicodeEncoding(self: win32more.Windows.Storage.Streams.IDataReader) -> win32more.Windows.Storage.Streams.UnicodeEncoding: ...
    @winrt_mixinmethod
    def put_UnicodeEncoding(self: win32more.Windows.Storage.Streams.IDataReader, value: win32more.Windows.Storage.Streams.UnicodeEncoding) -> Void: ...
    @winrt_mixinmethod
    def get_ByteOrder(self: win32more.Windows.Storage.Streams.IDataReader) -> win32more.Windows.Storage.Streams.ByteOrder: ...
    @winrt_mixinmethod
    def put_ByteOrder(self: win32more.Windows.Storage.Streams.IDataReader, value: win32more.Windows.Storage.Streams.ByteOrder) -> Void: ...
    @winrt_mixinmethod
    def get_InputStreamOptions(self: win32more.Windows.Storage.Streams.IDataReader) -> win32more.Windows.Storage.Streams.InputStreamOptions: ...
    @winrt_mixinmethod
    def put_InputStreamOptions(self: win32more.Windows.Storage.Streams.IDataReader, value: win32more.Windows.Storage.Streams.InputStreamOptions) -> Void: ...
    @winrt_mixinmethod
    def ReadByte(self: win32more.Windows.Storage.Streams.IDataReader) -> Byte: ...
    @winrt_mixinmethod
    def ReadBytes(self: win32more.Windows.Storage.Streams.IDataReader, value: FillArray[Byte]) -> Void: ...
    @winrt_mixinmethod
    def ReadBuffer(self: win32more.Windows.Storage.Streams.IDataReader, length: UInt32) -> win32more.Windows.Storage.Streams.IBuffer: ...
    @winrt_mixinmethod
    def ReadBoolean(self: win32more.Windows.Storage.Streams.IDataReader) -> Boolean: ...
    @winrt_mixinmethod
    def ReadGuid(self: win32more.Windows.Storage.Streams.IDataReader) -> Guid: ...
    @winrt_mixinmethod
    def ReadInt16(self: win32more.Windows.Storage.Streams.IDataReader) -> Int16: ...
    @winrt_mixinmethod
    def ReadInt32(self: win32more.Windows.Storage.Streams.IDataReader) -> Int32: ...
    @winrt_mixinmethod
    def ReadInt64(self: win32more.Windows.Storage.Streams.IDataReader) -> Int64: ...
    @winrt_mixinmethod
    def ReadUInt16(self: win32more.Windows.Storage.Streams.IDataReader) -> UInt16: ...
    @winrt_mixinmethod
    def ReadUInt32(self: win32more.Windows.Storage.Streams.IDataReader) -> UInt32: ...
    @winrt_mixinmethod
    def ReadUInt64(self: win32more.Windows.Storage.Streams.IDataReader) -> UInt64: ...
    @winrt_mixinmethod
    def ReadSingle(self: win32more.Windows.Storage.Streams.IDataReader) -> Single: ...
    @winrt_mixinmethod
    def ReadDouble(self: win32more.Windows.Storage.Streams.IDataReader) -> Double: ...
    @winrt_mixinmethod
    def ReadString(self: win32more.Windows.Storage.Streams.IDataReader, codeUnitCount: UInt32) -> WinRT_String: ...
    @winrt_mixinmethod
    def ReadDateTime(self: win32more.Windows.Storage.Streams.IDataReader) -> win32more.Windows.Foundation.DateTime: ...
    @winrt_mixinmethod
    def ReadTimeSpan(self: win32more.Windows.Storage.Streams.IDataReader) -> win32more.Windows.Foundation.TimeSpan: ...
    @winrt_mixinmethod
    def LoadAsync(self: win32more.Windows.Storage.Streams.IDataReader, count: UInt32) -> win32more.Windows.Storage.Streams.DataReaderLoadOperation: ...
    @winrt_mixinmethod
    def DetachBuffer(self: win32more.Windows.Storage.Streams.IDataReader) -> win32more.Windows.Storage.Streams.IBuffer: ...
    @winrt_mixinmethod
    def DetachStream(self: win32more.Windows.Storage.Streams.IDataReader) -> win32more.Windows.Storage.Streams.IInputStream: ...
    @winrt_mixinmethod
    def Close(self: win32more.Windows.Foundation.IClosable) -> Void: ...
    @winrt_classmethod
    def FromBuffer(cls: win32more.Windows.Storage.Streams.IDataReaderStatics, buffer: win32more.Windows.Storage.Streams.IBuffer) -> win32more.Windows.Storage.Streams.DataReader: ...
    ByteOrder = property(get_ByteOrder, put_ByteOrder)
    InputStreamOptions = property(get_InputStreamOptions, put_InputStreamOptions)
    UnconsumedBufferLength = property(get_UnconsumedBufferLength, None)
    UnicodeEncoding = property(get_UnicodeEncoding, put_UnicodeEncoding)
class DataReaderLoadOperation(ComPtr):
    extends: IInspectable
    implements: Tuple[AwaitableProtocol]
    default_interface: win32more.Windows.Foundation.IAsyncOperation[UInt32]
    _classid_ = 'Windows.Storage.Streams.DataReaderLoadOperation'
    @winrt_mixinmethod
    def put_Completed(self: win32more.Windows.Foundation.IAsyncOperation[UInt32], handler: win32more.Windows.Foundation.AsyncOperationCompletedHandler[UInt32]) -> Void: ...
    @winrt_mixinmethod
    def get_Completed(self: win32more.Windows.Foundation.IAsyncOperation[UInt32]) -> win32more.Windows.Foundation.AsyncOperationCompletedHandler[UInt32]: ...
    @winrt_mixinmethod
    def GetResults(self: win32more.Windows.Foundation.IAsyncOperation[UInt32]) -> UInt32: ...
    @winrt_mixinmethod
    def get_Id(self: win32more.Windows.Foundation.IAsyncInfo) -> UInt32: ...
    @winrt_mixinmethod
    def get_Status(self: win32more.Windows.Foundation.IAsyncInfo) -> win32more.Windows.Foundation.AsyncStatus: ...
    @winrt_mixinmethod
    def get_ErrorCode(self: win32more.Windows.Foundation.IAsyncInfo) -> win32more.Windows.Foundation.HResult: ...
    @winrt_mixinmethod
    def Cancel(self: win32more.Windows.Foundation.IAsyncInfo) -> Void: ...
    @winrt_mixinmethod
    def Close(self: win32more.Windows.Foundation.IAsyncInfo) -> Void: ...
    Completed = property(get_Completed, put_Completed)
    ErrorCode = property(get_ErrorCode, None)
    Id = property(get_Id, None)
    Status = property(get_Status, None)
class DataWriter(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    default_interface: win32more.Windows.Storage.Streams.IDataWriter
    _classid_ = 'Windows.Storage.Streams.DataWriter'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 0:
            super().__init__(move=win32more.Windows.Storage.Streams.DataWriter.CreateInstance(*args))
        elif len(args) == 1:
            super().__init__(move=win32more.Windows.Storage.Streams.DataWriter.CreateDataWriter(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_activatemethod
    def CreateInstance(cls) -> win32more.Windows.Storage.Streams.DataWriter: ...
    @winrt_factorymethod
    def CreateDataWriter(cls: win32more.Windows.Storage.Streams.IDataWriterFactory, outputStream: win32more.Windows.Storage.Streams.IOutputStream) -> win32more.Windows.Storage.Streams.DataWriter: ...
    @winrt_mixinmethod
    def get_UnstoredBufferLength(self: win32more.Windows.Storage.Streams.IDataWriter) -> UInt32: ...
    @winrt_mixinmethod
    def get_UnicodeEncoding(self: win32more.Windows.Storage.Streams.IDataWriter) -> win32more.Windows.Storage.Streams.UnicodeEncoding: ...
    @winrt_mixinmethod
    def put_UnicodeEncoding(self: win32more.Windows.Storage.Streams.IDataWriter, value: win32more.Windows.Storage.Streams.UnicodeEncoding) -> Void: ...
    @winrt_mixinmethod
    def get_ByteOrder(self: win32more.Windows.Storage.Streams.IDataWriter) -> win32more.Windows.Storage.Streams.ByteOrder: ...
    @winrt_mixinmethod
    def put_ByteOrder(self: win32more.Windows.Storage.Streams.IDataWriter, value: win32more.Windows.Storage.Streams.ByteOrder) -> Void: ...
    @winrt_mixinmethod
    def WriteByte(self: win32more.Windows.Storage.Streams.IDataWriter, value: Byte) -> Void: ...
    @winrt_mixinmethod
    def WriteBytes(self: win32more.Windows.Storage.Streams.IDataWriter, value: PassArray[Byte]) -> Void: ...
    @winrt_mixinmethod
    def WriteBuffer(self: win32more.Windows.Storage.Streams.IDataWriter, buffer: win32more.Windows.Storage.Streams.IBuffer) -> Void: ...
    @winrt_mixinmethod
    def WriteBufferRange(self: win32more.Windows.Storage.Streams.IDataWriter, buffer: win32more.Windows.Storage.Streams.IBuffer, start: UInt32, count: UInt32) -> Void: ...
    @winrt_mixinmethod
    def WriteBoolean(self: win32more.Windows.Storage.Streams.IDataWriter, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def WriteGuid(self: win32more.Windows.Storage.Streams.IDataWriter, value: Guid) -> Void: ...
    @winrt_mixinmethod
    def WriteInt16(self: win32more.Windows.Storage.Streams.IDataWriter, value: Int16) -> Void: ...
    @winrt_mixinmethod
    def WriteInt32(self: win32more.Windows.Storage.Streams.IDataWriter, value: Int32) -> Void: ...
    @winrt_mixinmethod
    def WriteInt64(self: win32more.Windows.Storage.Streams.IDataWriter, value: Int64) -> Void: ...
    @winrt_mixinmethod
    def WriteUInt16(self: win32more.Windows.Storage.Streams.IDataWriter, value: UInt16) -> Void: ...
    @winrt_mixinmethod
    def WriteUInt32(self: win32more.Windows.Storage.Streams.IDataWriter, value: UInt32) -> Void: ...
    @winrt_mixinmethod
    def WriteUInt64(self: win32more.Windows.Storage.Streams.IDataWriter, value: UInt64) -> Void: ...
    @winrt_mixinmethod
    def WriteSingle(self: win32more.Windows.Storage.Streams.IDataWriter, value: Single) -> Void: ...
    @winrt_mixinmethod
    def WriteDouble(self: win32more.Windows.Storage.Streams.IDataWriter, value: Double) -> Void: ...
    @winrt_mixinmethod
    def WriteDateTime(self: win32more.Windows.Storage.Streams.IDataWriter, value: win32more.Windows.Foundation.DateTime) -> Void: ...
    @winrt_mixinmethod
    def WriteTimeSpan(self: win32more.Windows.Storage.Streams.IDataWriter, value: win32more.Windows.Foundation.TimeSpan) -> Void: ...
    @winrt_mixinmethod
    def WriteString(self: win32more.Windows.Storage.Streams.IDataWriter, value: WinRT_String) -> UInt32: ...
    @winrt_mixinmethod
    def MeasureString(self: win32more.Windows.Storage.Streams.IDataWriter, value: WinRT_String) -> UInt32: ...
    @winrt_mixinmethod
    def StoreAsync(self: win32more.Windows.Storage.Streams.IDataWriter) -> win32more.Windows.Storage.Streams.DataWriterStoreOperation: ...
    @winrt_mixinmethod
    def FlushAsync(self: win32more.Windows.Storage.Streams.IDataWriter) -> win32more.Windows.Foundation.IAsyncOperation[Boolean]: ...
    @winrt_mixinmethod
    def DetachBuffer(self: win32more.Windows.Storage.Streams.IDataWriter) -> win32more.Windows.Storage.Streams.IBuffer: ...
    @winrt_mixinmethod
    def DetachStream(self: win32more.Windows.Storage.Streams.IDataWriter) -> win32more.Windows.Storage.Streams.IOutputStream: ...
    @winrt_mixinmethod
    def Close(self: win32more.Windows.Foundation.IClosable) -> Void: ...
    ByteOrder = property(get_ByteOrder, put_ByteOrder)
    UnicodeEncoding = property(get_UnicodeEncoding, put_UnicodeEncoding)
    UnstoredBufferLength = property(get_UnstoredBufferLength, None)
class DataWriterStoreOperation(ComPtr):
    extends: IInspectable
    implements: Tuple[AwaitableProtocol]
    default_interface: win32more.Windows.Foundation.IAsyncOperation[UInt32]
    _classid_ = 'Windows.Storage.Streams.DataWriterStoreOperation'
    @winrt_mixinmethod
    def put_Completed(self: win32more.Windows.Foundation.IAsyncOperation[UInt32], handler: win32more.Windows.Foundation.AsyncOperationCompletedHandler[UInt32]) -> Void: ...
    @winrt_mixinmethod
    def get_Completed(self: win32more.Windows.Foundation.IAsyncOperation[UInt32]) -> win32more.Windows.Foundation.AsyncOperationCompletedHandler[UInt32]: ...
    @winrt_mixinmethod
    def GetResults(self: win32more.Windows.Foundation.IAsyncOperation[UInt32]) -> UInt32: ...
    @winrt_mixinmethod
    def get_Id(self: win32more.Windows.Foundation.IAsyncInfo) -> UInt32: ...
    @winrt_mixinmethod
    def get_Status(self: win32more.Windows.Foundation.IAsyncInfo) -> win32more.Windows.Foundation.AsyncStatus: ...
    @winrt_mixinmethod
    def get_ErrorCode(self: win32more.Windows.Foundation.IAsyncInfo) -> win32more.Windows.Foundation.HResult: ...
    @winrt_mixinmethod
    def Cancel(self: win32more.Windows.Foundation.IAsyncInfo) -> Void: ...
    @winrt_mixinmethod
    def Close(self: win32more.Windows.Foundation.IAsyncInfo) -> Void: ...
    Completed = property(get_Completed, put_Completed)
    ErrorCode = property(get_ErrorCode, None)
    Id = property(get_Id, None)
    Status = property(get_Status, None)
class FileInputStream(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    default_interface: win32more.Windows.Storage.Streams.IInputStream
    _classid_ = 'Windows.Storage.Streams.FileInputStream'
    @winrt_mixinmethod
    def ReadAsync(self: win32more.Windows.Storage.Streams.IInputStream, buffer: win32more.Windows.Storage.Streams.IBuffer, count: UInt32, options: win32more.Windows.Storage.Streams.InputStreamOptions) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[win32more.Windows.Storage.Streams.IBuffer, UInt32]: ...
    @winrt_mixinmethod
    def Close(self: win32more.Windows.Foundation.IClosable) -> Void: ...
class FileOpenDisposition(Enum, Int32):
    OpenExisting = 0
    OpenAlways = 1
    CreateNew = 2
    CreateAlways = 3
    TruncateExisting = 4
class FileOutputStream(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    default_interface: win32more.Windows.Storage.Streams.IOutputStream
    _classid_ = 'Windows.Storage.Streams.FileOutputStream'
    @winrt_mixinmethod
    def WriteAsync(self: win32more.Windows.Storage.Streams.IOutputStream, buffer: win32more.Windows.Storage.Streams.IBuffer) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[UInt32, UInt32]: ...
    @winrt_mixinmethod
    def FlushAsync(self: win32more.Windows.Storage.Streams.IOutputStream) -> win32more.Windows.Foundation.IAsyncOperation[Boolean]: ...
    @winrt_mixinmethod
    def Close(self: win32more.Windows.Foundation.IClosable) -> Void: ...
class FileRandomAccessStream(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    default_interface: win32more.Windows.Storage.Streams.IRandomAccessStream
    _classid_ = 'Windows.Storage.Streams.FileRandomAccessStream'
    @winrt_mixinmethod
    def get_Size(self: win32more.Windows.Storage.Streams.IRandomAccessStream) -> UInt64: ...
    @winrt_mixinmethod
    def put_Size(self: win32more.Windows.Storage.Streams.IRandomAccessStream, value: UInt64) -> Void: ...
    @winrt_mixinmethod
    def GetInputStreamAt(self: win32more.Windows.Storage.Streams.IRandomAccessStream, position: UInt64) -> win32more.Windows.Storage.Streams.IInputStream: ...
    @winrt_mixinmethod
    def GetOutputStreamAt(self: win32more.Windows.Storage.Streams.IRandomAccessStream, position: UInt64) -> win32more.Windows.Storage.Streams.IOutputStream: ...
    @winrt_mixinmethod
    def get_Position(self: win32more.Windows.Storage.Streams.IRandomAccessStream) -> UInt64: ...
    @winrt_mixinmethod
    def Seek(self: win32more.Windows.Storage.Streams.IRandomAccessStream, position: UInt64) -> Void: ...
    @winrt_mixinmethod
    def CloneStream(self: win32more.Windows.Storage.Streams.IRandomAccessStream) -> win32more.Windows.Storage.Streams.IRandomAccessStream: ...
    @winrt_mixinmethod
    def get_CanRead(self: win32more.Windows.Storage.Streams.IRandomAccessStream) -> Boolean: ...
    @winrt_mixinmethod
    def get_CanWrite(self: win32more.Windows.Storage.Streams.IRandomAccessStream) -> Boolean: ...
    @winrt_mixinmethod
    def Close(self: win32more.Windows.Foundation.IClosable) -> Void: ...
    @winrt_mixinmethod
    def ReadAsync(self: win32more.Windows.Storage.Streams.IInputStream, buffer: win32more.Windows.Storage.Streams.IBuffer, count: UInt32, options: win32more.Windows.Storage.Streams.InputStreamOptions) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[win32more.Windows.Storage.Streams.IBuffer, UInt32]: ...
    @winrt_mixinmethod
    def WriteAsync(self: win32more.Windows.Storage.Streams.IOutputStream, buffer: win32more.Windows.Storage.Streams.IBuffer) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[UInt32, UInt32]: ...
    @winrt_mixinmethod
    def FlushAsync(self: win32more.Windows.Storage.Streams.IOutputStream) -> win32more.Windows.Foundation.IAsyncOperation[Boolean]: ...
    @winrt_classmethod
    def OpenAsync(cls: win32more.Windows.Storage.Streams.IFileRandomAccessStreamStatics, filePath: WinRT_String, accessMode: win32more.Windows.Storage.FileAccessMode) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Windows.Storage.Streams.IRandomAccessStream]: ...
    @winrt_classmethod
    def OpenWithOptionsAsync(cls: win32more.Windows.Storage.Streams.IFileRandomAccessStreamStatics, filePath: WinRT_String, accessMode: win32more.Windows.Storage.FileAccessMode, sharingOptions: win32more.Windows.Storage.StorageOpenOptions, openDisposition: win32more.Windows.Storage.Streams.FileOpenDisposition) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Windows.Storage.Streams.IRandomAccessStream]: ...
    @winrt_classmethod
    def OpenTransactedWriteAsync(cls: win32more.Windows.Storage.Streams.IFileRandomAccessStreamStatics, filePath: WinRT_String) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Windows.Storage.StorageStreamTransaction]: ...
    @winrt_classmethod
    def OpenTransactedWriteWithOptionsAsync(cls: win32more.Windows.Storage.Streams.IFileRandomAccessStreamStatics, filePath: WinRT_String, openOptions: win32more.Windows.Storage.StorageOpenOptions, openDisposition: win32more.Windows.Storage.Streams.FileOpenDisposition) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Windows.Storage.StorageStreamTransaction]: ...
    @winrt_classmethod
    def OpenForUserAsync(cls: win32more.Windows.Storage.Streams.IFileRandomAccessStreamStatics, user: win32more.Windows.System.User, filePath: WinRT_String, accessMode: win32more.Windows.Storage.FileAccessMode) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Windows.Storage.Streams.IRandomAccessStream]: ...
    @winrt_classmethod
    def OpenForUserWithOptionsAsync(cls: win32more.Windows.Storage.Streams.IFileRandomAccessStreamStatics, user: win32more.Windows.System.User, filePath: WinRT_String, accessMode: win32more.Windows.Storage.FileAccessMode, sharingOptions: win32more.Windows.Storage.StorageOpenOptions, openDisposition: win32more.Windows.Storage.Streams.FileOpenDisposition) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Windows.Storage.Streams.IRandomAccessStream]: ...
    @winrt_classmethod
    def OpenTransactedWriteForUserAsync(cls: win32more.Windows.Storage.Streams.IFileRandomAccessStreamStatics, user: win32more.Windows.System.User, filePath: WinRT_String) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Windows.Storage.StorageStreamTransaction]: ...
    @winrt_classmethod
    def OpenTransactedWriteForUserWithOptionsAsync(cls: win32more.Windows.Storage.Streams.IFileRandomAccessStreamStatics, user: win32more.Windows.System.User, filePath: WinRT_String, openOptions: win32more.Windows.Storage.StorageOpenOptions, openDisposition: win32more.Windows.Storage.Streams.FileOpenDisposition) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Windows.Storage.StorageStreamTransaction]: ...
    CanRead = property(get_CanRead, None)
    CanWrite = property(get_CanWrite, None)
    Position = property(get_Position, None)
    Size = property(get_Size, put_Size)
class IBuffer(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Storage.Streams.IBuffer'
    _iid_ = Guid('{905a0fe0-bc53-11df-8c49-001e4fc686da}')
    @winrt_commethod(6)
    def get_Capacity(self) -> UInt32: ...
    @winrt_commethod(7)
    def get_Length(self) -> UInt32: ...
    @winrt_commethod(8)
    def put_Length(self, value: UInt32) -> Void: ...
    Capacity = property(get_Capacity, None)
    Length = property(get_Length, put_Length)
class IBufferFactory(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Storage.Streams.IBufferFactory'
    _iid_ = Guid('{71af914d-c10f-484b-bc50-14bc623b3a27}')
    @winrt_commethod(6)
    def Create(self, capacity: UInt32) -> win32more.Windows.Storage.Streams.Buffer: ...
class IBufferStatics(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Storage.Streams.IBufferStatics'
    _iid_ = Guid('{e901e65b-d716-475a-a90a-af7229b1e741}')
    @winrt_commethod(6)
    def CreateCopyFromMemoryBuffer(self, input: win32more.Windows.Foundation.IMemoryBuffer) -> win32more.Windows.Storage.Streams.Buffer: ...
    @winrt_commethod(7)
    def CreateMemoryBufferOverIBuffer(self, input: win32more.Windows.Storage.Streams.IBuffer) -> win32more.Windows.Foundation.MemoryBuffer: ...
class IContentTypeProvider(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Storage.Streams.IContentTypeProvider'
    _iid_ = Guid('{97d098a5-3b99-4de9-88a5-e11d2f50c795}')
    @winrt_commethod(6)
    def get_ContentType(self) -> WinRT_String: ...
    ContentType = property(get_ContentType, None)
class IDataReader(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Storage.Streams.IDataReader'
    _iid_ = Guid('{e2b50029-b4c1-4314-a4b8-fb813a2f275e}')
    @winrt_commethod(6)
    def get_UnconsumedBufferLength(self) -> UInt32: ...
    @winrt_commethod(7)
    def get_UnicodeEncoding(self) -> win32more.Windows.Storage.Streams.UnicodeEncoding: ...
    @winrt_commethod(8)
    def put_UnicodeEncoding(self, value: win32more.Windows.Storage.Streams.UnicodeEncoding) -> Void: ...
    @winrt_commethod(9)
    def get_ByteOrder(self) -> win32more.Windows.Storage.Streams.ByteOrder: ...
    @winrt_commethod(10)
    def put_ByteOrder(self, value: win32more.Windows.Storage.Streams.ByteOrder) -> Void: ...
    @winrt_commethod(11)
    def get_InputStreamOptions(self) -> win32more.Windows.Storage.Streams.InputStreamOptions: ...
    @winrt_commethod(12)
    def put_InputStreamOptions(self, value: win32more.Windows.Storage.Streams.InputStreamOptions) -> Void: ...
    @winrt_commethod(13)
    def ReadByte(self) -> Byte: ...
    @winrt_commethod(14)
    def ReadBytes(self, value: FillArray[Byte]) -> Void: ...
    @winrt_commethod(15)
    def ReadBuffer(self, length: UInt32) -> win32more.Windows.Storage.Streams.IBuffer: ...
    @winrt_commethod(16)
    def ReadBoolean(self) -> Boolean: ...
    @winrt_commethod(17)
    def ReadGuid(self) -> Guid: ...
    @winrt_commethod(18)
    def ReadInt16(self) -> Int16: ...
    @winrt_commethod(19)
    def ReadInt32(self) -> Int32: ...
    @winrt_commethod(20)
    def ReadInt64(self) -> Int64: ...
    @winrt_commethod(21)
    def ReadUInt16(self) -> UInt16: ...
    @winrt_commethod(22)
    def ReadUInt32(self) -> UInt32: ...
    @winrt_commethod(23)
    def ReadUInt64(self) -> UInt64: ...
    @winrt_commethod(24)
    def ReadSingle(self) -> Single: ...
    @winrt_commethod(25)
    def ReadDouble(self) -> Double: ...
    @winrt_commethod(26)
    def ReadString(self, codeUnitCount: UInt32) -> WinRT_String: ...
    @winrt_commethod(27)
    def ReadDateTime(self) -> win32more.Windows.Foundation.DateTime: ...
    @winrt_commethod(28)
    def ReadTimeSpan(self) -> win32more.Windows.Foundation.TimeSpan: ...
    @winrt_commethod(29)
    def LoadAsync(self, count: UInt32) -> win32more.Windows.Storage.Streams.DataReaderLoadOperation: ...
    @winrt_commethod(30)
    def DetachBuffer(self) -> win32more.Windows.Storage.Streams.IBuffer: ...
    @winrt_commethod(31)
    def DetachStream(self) -> win32more.Windows.Storage.Streams.IInputStream: ...
    ByteOrder = property(get_ByteOrder, put_ByteOrder)
    InputStreamOptions = property(get_InputStreamOptions, put_InputStreamOptions)
    UnconsumedBufferLength = property(get_UnconsumedBufferLength, None)
    UnicodeEncoding = property(get_UnicodeEncoding, put_UnicodeEncoding)
class IDataReaderFactory(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Storage.Streams.IDataReaderFactory'
    _iid_ = Guid('{d7527847-57da-4e15-914c-06806699a098}')
    @winrt_commethod(6)
    def CreateDataReader(self, inputStream: win32more.Windows.Storage.Streams.IInputStream) -> win32more.Windows.Storage.Streams.DataReader: ...
class IDataReaderStatics(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Storage.Streams.IDataReaderStatics'
    _iid_ = Guid('{11fcbfc8-f93a-471b-b121-f379e349313c}')
    @winrt_commethod(6)
    def FromBuffer(self, buffer: win32more.Windows.Storage.Streams.IBuffer) -> win32more.Windows.Storage.Streams.DataReader: ...
class IDataWriter(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Storage.Streams.IDataWriter'
    _iid_ = Guid('{64b89265-d341-4922-b38a-dd4af8808c4e}')
    @winrt_commethod(6)
    def get_UnstoredBufferLength(self) -> UInt32: ...
    @winrt_commethod(7)
    def get_UnicodeEncoding(self) -> win32more.Windows.Storage.Streams.UnicodeEncoding: ...
    @winrt_commethod(8)
    def put_UnicodeEncoding(self, value: win32more.Windows.Storage.Streams.UnicodeEncoding) -> Void: ...
    @winrt_commethod(9)
    def get_ByteOrder(self) -> win32more.Windows.Storage.Streams.ByteOrder: ...
    @winrt_commethod(10)
    def put_ByteOrder(self, value: win32more.Windows.Storage.Streams.ByteOrder) -> Void: ...
    @winrt_commethod(11)
    def WriteByte(self, value: Byte) -> Void: ...
    @winrt_commethod(12)
    def WriteBytes(self, value: PassArray[Byte]) -> Void: ...
    @winrt_commethod(13)
    def WriteBuffer(self, buffer: win32more.Windows.Storage.Streams.IBuffer) -> Void: ...
    @winrt_commethod(14)
    def WriteBufferRange(self, buffer: win32more.Windows.Storage.Streams.IBuffer, start: UInt32, count: UInt32) -> Void: ...
    @winrt_commethod(15)
    def WriteBoolean(self, value: Boolean) -> Void: ...
    @winrt_commethod(16)
    def WriteGuid(self, value: Guid) -> Void: ...
    @winrt_commethod(17)
    def WriteInt16(self, value: Int16) -> Void: ...
    @winrt_commethod(18)
    def WriteInt32(self, value: Int32) -> Void: ...
    @winrt_commethod(19)
    def WriteInt64(self, value: Int64) -> Void: ...
    @winrt_commethod(20)
    def WriteUInt16(self, value: UInt16) -> Void: ...
    @winrt_commethod(21)
    def WriteUInt32(self, value: UInt32) -> Void: ...
    @winrt_commethod(22)
    def WriteUInt64(self, value: UInt64) -> Void: ...
    @winrt_commethod(23)
    def WriteSingle(self, value: Single) -> Void: ...
    @winrt_commethod(24)
    def WriteDouble(self, value: Double) -> Void: ...
    @winrt_commethod(25)
    def WriteDateTime(self, value: win32more.Windows.Foundation.DateTime) -> Void: ...
    @winrt_commethod(26)
    def WriteTimeSpan(self, value: win32more.Windows.Foundation.TimeSpan) -> Void: ...
    @winrt_commethod(27)
    def WriteString(self, value: WinRT_String) -> UInt32: ...
    @winrt_commethod(28)
    def MeasureString(self, value: WinRT_String) -> UInt32: ...
    @winrt_commethod(29)
    def StoreAsync(self) -> win32more.Windows.Storage.Streams.DataWriterStoreOperation: ...
    @winrt_commethod(30)
    def FlushAsync(self) -> win32more.Windows.Foundation.IAsyncOperation[Boolean]: ...
    @winrt_commethod(31)
    def DetachBuffer(self) -> win32more.Windows.Storage.Streams.IBuffer: ...
    @winrt_commethod(32)
    def DetachStream(self) -> win32more.Windows.Storage.Streams.IOutputStream: ...
    ByteOrder = property(get_ByteOrder, put_ByteOrder)
    UnicodeEncoding = property(get_UnicodeEncoding, put_UnicodeEncoding)
    UnstoredBufferLength = property(get_UnstoredBufferLength, None)
class IDataWriterFactory(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Storage.Streams.IDataWriterFactory'
    _iid_ = Guid('{338c67c2-8b84-4c2b-9c50-7b8767847a1f}')
    @winrt_commethod(6)
    def CreateDataWriter(self, outputStream: win32more.Windows.Storage.Streams.IOutputStream) -> win32more.Windows.Storage.Streams.DataWriter: ...
class IFileRandomAccessStreamStatics(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Storage.Streams.IFileRandomAccessStreamStatics'
    _iid_ = Guid('{73550107-3b57-4b5d-8345-554d2fc621f0}')
    @winrt_commethod(6)
    def OpenAsync(self, filePath: WinRT_String, accessMode: win32more.Windows.Storage.FileAccessMode) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Windows.Storage.Streams.IRandomAccessStream]: ...
    @winrt_commethod(7)
    def OpenWithOptionsAsync(self, filePath: WinRT_String, accessMode: win32more.Windows.Storage.FileAccessMode, sharingOptions: win32more.Windows.Storage.StorageOpenOptions, openDisposition: win32more.Windows.Storage.Streams.FileOpenDisposition) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Windows.Storage.Streams.IRandomAccessStream]: ...
    @winrt_commethod(8)
    def OpenTransactedWriteAsync(self, filePath: WinRT_String) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Windows.Storage.StorageStreamTransaction]: ...
    @winrt_commethod(9)
    def OpenTransactedWriteWithOptionsAsync(self, filePath: WinRT_String, openOptions: win32more.Windows.Storage.StorageOpenOptions, openDisposition: win32more.Windows.Storage.Streams.FileOpenDisposition) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Windows.Storage.StorageStreamTransaction]: ...
    @winrt_commethod(10)
    def OpenForUserAsync(self, user: win32more.Windows.System.User, filePath: WinRT_String, accessMode: win32more.Windows.Storage.FileAccessMode) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Windows.Storage.Streams.IRandomAccessStream]: ...
    @winrt_commethod(11)
    def OpenForUserWithOptionsAsync(self, user: win32more.Windows.System.User, filePath: WinRT_String, accessMode: win32more.Windows.Storage.FileAccessMode, sharingOptions: win32more.Windows.Storage.StorageOpenOptions, openDisposition: win32more.Windows.Storage.Streams.FileOpenDisposition) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Windows.Storage.Streams.IRandomAccessStream]: ...
    @winrt_commethod(12)
    def OpenTransactedWriteForUserAsync(self, user: win32more.Windows.System.User, filePath: WinRT_String) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Windows.Storage.StorageStreamTransaction]: ...
    @winrt_commethod(13)
    def OpenTransactedWriteForUserWithOptionsAsync(self, user: win32more.Windows.System.User, filePath: WinRT_String, openOptions: win32more.Windows.Storage.StorageOpenOptions, openDisposition: win32more.Windows.Storage.Streams.FileOpenDisposition) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Windows.Storage.StorageStreamTransaction]: ...
class IInputStream(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    _classid_ = 'Windows.Storage.Streams.IInputStream'
    _iid_ = Guid('{905a0fe2-bc53-11df-8c49-001e4fc686da}')
    @winrt_commethod(6)
    def ReadAsync(self, buffer: win32more.Windows.Storage.Streams.IBuffer, count: UInt32, options: win32more.Windows.Storage.Streams.InputStreamOptions) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[win32more.Windows.Storage.Streams.IBuffer, UInt32]: ...
class IInputStreamReference(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Storage.Streams.IInputStreamReference'
    _iid_ = Guid('{43929d18-5ec9-4b5a-919c-4205b0c804b6}')
    @winrt_commethod(6)
    def OpenSequentialReadAsync(self) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Windows.Storage.Streams.IInputStream]: ...
class IOutputStream(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    _classid_ = 'Windows.Storage.Streams.IOutputStream'
    _iid_ = Guid('{905a0fe6-bc53-11df-8c49-001e4fc686da}')
    @winrt_commethod(6)
    def WriteAsync(self, buffer: win32more.Windows.Storage.Streams.IBuffer) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[UInt32, UInt32]: ...
    @winrt_commethod(7)
    def FlushAsync(self) -> win32more.Windows.Foundation.IAsyncOperation[Boolean]: ...
class IPropertySetSerializer(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Storage.Streams.IPropertySetSerializer'
    _iid_ = Guid('{6e8ebf1c-ef3d-4376-b20e-5be638aeac77}')
    @winrt_commethod(6)
    def Serialize(self, propertySet: win32more.Windows.Foundation.Collections.IPropertySet) -> win32more.Windows.Storage.Streams.IBuffer: ...
    @winrt_commethod(7)
    def Deserialize(self, propertySet: win32more.Windows.Foundation.Collections.IPropertySet, buffer: win32more.Windows.Storage.Streams.IBuffer) -> Void: ...
class IRandomAccessStream(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    _classid_ = 'Windows.Storage.Streams.IRandomAccessStream'
    _iid_ = Guid('{905a0fe1-bc53-11df-8c49-001e4fc686da}')
    @winrt_commethod(6)
    def get_Size(self) -> UInt64: ...
    @winrt_commethod(7)
    def put_Size(self, value: UInt64) -> Void: ...
    @winrt_commethod(8)
    def GetInputStreamAt(self, position: UInt64) -> win32more.Windows.Storage.Streams.IInputStream: ...
    @winrt_commethod(9)
    def GetOutputStreamAt(self, position: UInt64) -> win32more.Windows.Storage.Streams.IOutputStream: ...
    @winrt_commethod(10)
    def get_Position(self) -> UInt64: ...
    @winrt_commethod(11)
    def Seek(self, position: UInt64) -> Void: ...
    @winrt_commethod(12)
    def CloneStream(self) -> win32more.Windows.Storage.Streams.IRandomAccessStream: ...
    @winrt_commethod(13)
    def get_CanRead(self) -> Boolean: ...
    @winrt_commethod(14)
    def get_CanWrite(self) -> Boolean: ...
    CanRead = property(get_CanRead, None)
    CanWrite = property(get_CanWrite, None)
    Position = property(get_Position, None)
    Size = property(get_Size, put_Size)
class IRandomAccessStreamReference(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Storage.Streams.IRandomAccessStreamReference'
    _iid_ = Guid('{33ee3134-1dd6-4e3a-8067-d1c162e8642b}')
    @winrt_commethod(6)
    def OpenReadAsync(self) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Windows.Storage.Streams.IRandomAccessStreamWithContentType]: ...
class IRandomAccessStreamReferenceStatics(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Storage.Streams.IRandomAccessStreamReferenceStatics'
    _iid_ = Guid('{857309dc-3fbf-4e7d-986f-ef3b1a07a964}')
    @winrt_commethod(6)
    def CreateFromFile(self, file: win32more.Windows.Storage.IStorageFile) -> win32more.Windows.Storage.Streams.RandomAccessStreamReference: ...
    @winrt_commethod(7)
    def CreateFromUri(self, uri: win32more.Windows.Foundation.Uri) -> win32more.Windows.Storage.Streams.RandomAccessStreamReference: ...
    @winrt_commethod(8)
    def CreateFromStream(self, stream: win32more.Windows.Storage.Streams.IRandomAccessStream) -> win32more.Windows.Storage.Streams.RandomAccessStreamReference: ...
class IRandomAccessStreamStatics(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Storage.Streams.IRandomAccessStreamStatics'
    _iid_ = Guid('{524cedcf-6e29-4ce5-9573-6b753db66c3a}')
    @winrt_commethod(6)
    def CopyAsync(self, source: win32more.Windows.Storage.Streams.IInputStream, destination: win32more.Windows.Storage.Streams.IOutputStream) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[UInt64, UInt64]: ...
    @winrt_commethod(7)
    def CopySizeAsync(self, source: win32more.Windows.Storage.Streams.IInputStream, destination: win32more.Windows.Storage.Streams.IOutputStream, bytesToCopy: UInt64) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[UInt64, UInt64]: ...
    @winrt_commethod(8)
    def CopyAndCloseAsync(self, source: win32more.Windows.Storage.Streams.IInputStream, destination: win32more.Windows.Storage.Streams.IOutputStream) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[UInt64, UInt64]: ...
class IRandomAccessStreamWithContentType(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    _classid_ = 'Windows.Storage.Streams.IRandomAccessStreamWithContentType'
    _iid_ = Guid('{cc254827-4b3d-438f-9232-10c76bc7e038}')
class InMemoryRandomAccessStream(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    default_interface: win32more.Windows.Storage.Streams.IRandomAccessStream
    _classid_ = 'Windows.Storage.Streams.InMemoryRandomAccessStream'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 0:
            super().__init__(move=win32more.Windows.Storage.Streams.InMemoryRandomAccessStream.CreateInstance(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_activatemethod
    def CreateInstance(cls) -> win32more.Windows.Storage.Streams.InMemoryRandomAccessStream: ...
    @winrt_mixinmethod
    def get_Size(self: win32more.Windows.Storage.Streams.IRandomAccessStream) -> UInt64: ...
    @winrt_mixinmethod
    def put_Size(self: win32more.Windows.Storage.Streams.IRandomAccessStream, value: UInt64) -> Void: ...
    @winrt_mixinmethod
    def GetInputStreamAt(self: win32more.Windows.Storage.Streams.IRandomAccessStream, position: UInt64) -> win32more.Windows.Storage.Streams.IInputStream: ...
    @winrt_mixinmethod
    def GetOutputStreamAt(self: win32more.Windows.Storage.Streams.IRandomAccessStream, position: UInt64) -> win32more.Windows.Storage.Streams.IOutputStream: ...
    @winrt_mixinmethod
    def get_Position(self: win32more.Windows.Storage.Streams.IRandomAccessStream) -> UInt64: ...
    @winrt_mixinmethod
    def Seek(self: win32more.Windows.Storage.Streams.IRandomAccessStream, position: UInt64) -> Void: ...
    @winrt_mixinmethod
    def CloneStream(self: win32more.Windows.Storage.Streams.IRandomAccessStream) -> win32more.Windows.Storage.Streams.IRandomAccessStream: ...
    @winrt_mixinmethod
    def get_CanRead(self: win32more.Windows.Storage.Streams.IRandomAccessStream) -> Boolean: ...
    @winrt_mixinmethod
    def get_CanWrite(self: win32more.Windows.Storage.Streams.IRandomAccessStream) -> Boolean: ...
    @winrt_mixinmethod
    def Close(self: win32more.Windows.Foundation.IClosable) -> Void: ...
    @winrt_mixinmethod
    def ReadAsync(self: win32more.Windows.Storage.Streams.IInputStream, buffer: win32more.Windows.Storage.Streams.IBuffer, count: UInt32, options: win32more.Windows.Storage.Streams.InputStreamOptions) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[win32more.Windows.Storage.Streams.IBuffer, UInt32]: ...
    @winrt_mixinmethod
    def WriteAsync(self: win32more.Windows.Storage.Streams.IOutputStream, buffer: win32more.Windows.Storage.Streams.IBuffer) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[UInt32, UInt32]: ...
    @winrt_mixinmethod
    def FlushAsync(self: win32more.Windows.Storage.Streams.IOutputStream) -> win32more.Windows.Foundation.IAsyncOperation[Boolean]: ...
    CanRead = property(get_CanRead, None)
    CanWrite = property(get_CanWrite, None)
    Position = property(get_Position, None)
    Size = property(get_Size, put_Size)
class InputStreamOptions(Enum, UInt32):
    None_ = 0
    Partial = 1
    ReadAhead = 2
class InputStreamOverStream(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    default_interface: win32more.Windows.Storage.Streams.IInputStream
    _classid_ = 'Windows.Storage.Streams.InputStreamOverStream'
    @winrt_mixinmethod
    def ReadAsync(self: win32more.Windows.Storage.Streams.IInputStream, buffer: win32more.Windows.Storage.Streams.IBuffer, count: UInt32, options: win32more.Windows.Storage.Streams.InputStreamOptions) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[win32more.Windows.Storage.Streams.IBuffer, UInt32]: ...
    @winrt_mixinmethod
    def Close(self: win32more.Windows.Foundation.IClosable) -> Void: ...
class OutputStreamOverStream(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    default_interface: win32more.Windows.Storage.Streams.IOutputStream
    _classid_ = 'Windows.Storage.Streams.OutputStreamOverStream'
    @winrt_mixinmethod
    def WriteAsync(self: win32more.Windows.Storage.Streams.IOutputStream, buffer: win32more.Windows.Storage.Streams.IBuffer) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[UInt32, UInt32]: ...
    @winrt_mixinmethod
    def FlushAsync(self: win32more.Windows.Storage.Streams.IOutputStream) -> win32more.Windows.Foundation.IAsyncOperation[Boolean]: ...
    @winrt_mixinmethod
    def Close(self: win32more.Windows.Foundation.IClosable) -> Void: ...
class RandomAccessStream(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Storage.Streams.RandomAccessStream'
    @winrt_classmethod
    def CopyAsync(cls: win32more.Windows.Storage.Streams.IRandomAccessStreamStatics, source: win32more.Windows.Storage.Streams.IInputStream, destination: win32more.Windows.Storage.Streams.IOutputStream) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[UInt64, UInt64]: ...
    @winrt_classmethod
    def CopySizeAsync(cls: win32more.Windows.Storage.Streams.IRandomAccessStreamStatics, source: win32more.Windows.Storage.Streams.IInputStream, destination: win32more.Windows.Storage.Streams.IOutputStream, bytesToCopy: UInt64) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[UInt64, UInt64]: ...
    @winrt_classmethod
    def CopyAndCloseAsync(cls: win32more.Windows.Storage.Streams.IRandomAccessStreamStatics, source: win32more.Windows.Storage.Streams.IInputStream, destination: win32more.Windows.Storage.Streams.IOutputStream) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[UInt64, UInt64]: ...
class RandomAccessStreamOverStream(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    default_interface: win32more.Windows.Storage.Streams.IRandomAccessStream
    _classid_ = 'Windows.Storage.Streams.RandomAccessStreamOverStream'
    @winrt_mixinmethod
    def get_Size(self: win32more.Windows.Storage.Streams.IRandomAccessStream) -> UInt64: ...
    @winrt_mixinmethod
    def put_Size(self: win32more.Windows.Storage.Streams.IRandomAccessStream, value: UInt64) -> Void: ...
    @winrt_mixinmethod
    def GetInputStreamAt(self: win32more.Windows.Storage.Streams.IRandomAccessStream, position: UInt64) -> win32more.Windows.Storage.Streams.IInputStream: ...
    @winrt_mixinmethod
    def GetOutputStreamAt(self: win32more.Windows.Storage.Streams.IRandomAccessStream, position: UInt64) -> win32more.Windows.Storage.Streams.IOutputStream: ...
    @winrt_mixinmethod
    def get_Position(self: win32more.Windows.Storage.Streams.IRandomAccessStream) -> UInt64: ...
    @winrt_mixinmethod
    def Seek(self: win32more.Windows.Storage.Streams.IRandomAccessStream, position: UInt64) -> Void: ...
    @winrt_mixinmethod
    def CloneStream(self: win32more.Windows.Storage.Streams.IRandomAccessStream) -> win32more.Windows.Storage.Streams.IRandomAccessStream: ...
    @winrt_mixinmethod
    def get_CanRead(self: win32more.Windows.Storage.Streams.IRandomAccessStream) -> Boolean: ...
    @winrt_mixinmethod
    def get_CanWrite(self: win32more.Windows.Storage.Streams.IRandomAccessStream) -> Boolean: ...
    @winrt_mixinmethod
    def Close(self: win32more.Windows.Foundation.IClosable) -> Void: ...
    @winrt_mixinmethod
    def ReadAsync(self: win32more.Windows.Storage.Streams.IInputStream, buffer: win32more.Windows.Storage.Streams.IBuffer, count: UInt32, options: win32more.Windows.Storage.Streams.InputStreamOptions) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[win32more.Windows.Storage.Streams.IBuffer, UInt32]: ...
    @winrt_mixinmethod
    def WriteAsync(self: win32more.Windows.Storage.Streams.IOutputStream, buffer: win32more.Windows.Storage.Streams.IBuffer) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[UInt32, UInt32]: ...
    @winrt_mixinmethod
    def FlushAsync(self: win32more.Windows.Storage.Streams.IOutputStream) -> win32more.Windows.Foundation.IAsyncOperation[Boolean]: ...
    CanRead = property(get_CanRead, None)
    CanWrite = property(get_CanWrite, None)
    Position = property(get_Position, None)
    Size = property(get_Size, put_Size)
class RandomAccessStreamReference(ComPtr):
    extends: IInspectable
    default_interface: win32more.Windows.Storage.Streams.IRandomAccessStreamReference
    _classid_ = 'Windows.Storage.Streams.RandomAccessStreamReference'
    @winrt_mixinmethod
    def OpenReadAsync(self: win32more.Windows.Storage.Streams.IRandomAccessStreamReference) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Windows.Storage.Streams.IRandomAccessStreamWithContentType]: ...
    @winrt_classmethod
    def CreateFromFile(cls: win32more.Windows.Storage.Streams.IRandomAccessStreamReferenceStatics, file: win32more.Windows.Storage.IStorageFile) -> win32more.Windows.Storage.Streams.RandomAccessStreamReference: ...
    @winrt_classmethod
    def CreateFromUri(cls: win32more.Windows.Storage.Streams.IRandomAccessStreamReferenceStatics, uri: win32more.Windows.Foundation.Uri) -> win32more.Windows.Storage.Streams.RandomAccessStreamReference: ...
    @winrt_classmethod
    def CreateFromStream(cls: win32more.Windows.Storage.Streams.IRandomAccessStreamReferenceStatics, stream: win32more.Windows.Storage.Streams.IRandomAccessStream) -> win32more.Windows.Storage.Streams.RandomAccessStreamReference: ...
class UnicodeEncoding(Enum, Int32):
    Utf8 = 0
    Utf16LE = 1
    Utf16BE = 2


make_ready(__name__)
