from __future__ import annotations
from win32more.winrt.prelude import *
import win32more.Windows.Foundation
import win32more.Windows.Foundation.Collections
import win32more.Windows.Globalization
import win32more.Windows.Networking
import win32more.Windows.Storage.Streams
import win32more.Windows.Web.Http
import win32more.Windows.Web.Http.Headers
class HttpCacheDirectiveHeaderValueCollection(ComPtr):
    extends: IInspectable
    implements: Tuple[SequenceProtocol[win32more.Windows.Web.Http.Headers.HttpNameValueHeaderValue]]
    default_interface: win32more.Windows.Web.Http.Headers.IHttpCacheDirectiveHeaderValueCollection
    _classid_ = 'Windows.Web.Http.Headers.HttpCacheDirectiveHeaderValueCollection'
    @winrt_mixinmethod
    def get_MaxAge(self: win32more.Windows.Web.Http.Headers.IHttpCacheDirectiveHeaderValueCollection) -> win32more.Windows.Foundation.IReference[win32more.Windows.Foundation.TimeSpan]: ...
    @winrt_mixinmethod
    def put_MaxAge(self: win32more.Windows.Web.Http.Headers.IHttpCacheDirectiveHeaderValueCollection, value: win32more.Windows.Foundation.IReference[win32more.Windows.Foundation.TimeSpan]) -> Void: ...
    @winrt_mixinmethod
    def get_MaxStale(self: win32more.Windows.Web.Http.Headers.IHttpCacheDirectiveHeaderValueCollection) -> win32more.Windows.Foundation.IReference[win32more.Windows.Foundation.TimeSpan]: ...
    @winrt_mixinmethod
    def put_MaxStale(self: win32more.Windows.Web.Http.Headers.IHttpCacheDirectiveHeaderValueCollection, value: win32more.Windows.Foundation.IReference[win32more.Windows.Foundation.TimeSpan]) -> Void: ...
    @winrt_mixinmethod
    def get_MinFresh(self: win32more.Windows.Web.Http.Headers.IHttpCacheDirectiveHeaderValueCollection) -> win32more.Windows.Foundation.IReference[win32more.Windows.Foundation.TimeSpan]: ...
    @winrt_mixinmethod
    def put_MinFresh(self: win32more.Windows.Web.Http.Headers.IHttpCacheDirectiveHeaderValueCollection, value: win32more.Windows.Foundation.IReference[win32more.Windows.Foundation.TimeSpan]) -> Void: ...
    @winrt_mixinmethod
    def get_SharedMaxAge(self: win32more.Windows.Web.Http.Headers.IHttpCacheDirectiveHeaderValueCollection) -> win32more.Windows.Foundation.IReference[win32more.Windows.Foundation.TimeSpan]: ...
    @winrt_mixinmethod
    def put_SharedMaxAge(self: win32more.Windows.Web.Http.Headers.IHttpCacheDirectiveHeaderValueCollection, value: win32more.Windows.Foundation.IReference[win32more.Windows.Foundation.TimeSpan]) -> Void: ...
    @winrt_mixinmethod
    def ParseAdd(self: win32more.Windows.Web.Http.Headers.IHttpCacheDirectiveHeaderValueCollection, input: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def TryParseAdd(self: win32more.Windows.Web.Http.Headers.IHttpCacheDirectiveHeaderValueCollection, input: WinRT_String) -> Boolean: ...
    @winrt_mixinmethod
    def GetAt(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.Headers.HttpNameValueHeaderValue], index: UInt32) -> win32more.Windows.Web.Http.Headers.HttpNameValueHeaderValue: ...
    @winrt_mixinmethod
    def get_Size(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.Headers.HttpNameValueHeaderValue]) -> UInt32: ...
    @winrt_mixinmethod
    def GetView(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.Headers.HttpNameValueHeaderValue]) -> win32more.Windows.Foundation.Collections.IVectorView[win32more.Windows.Web.Http.Headers.HttpNameValueHeaderValue]: ...
    @winrt_mixinmethod
    def IndexOf(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.Headers.HttpNameValueHeaderValue], value: win32more.Windows.Web.Http.Headers.HttpNameValueHeaderValue, index: POINTER(UInt32)) -> Boolean: ...
    @winrt_mixinmethod
    def SetAt(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.Headers.HttpNameValueHeaderValue], index: UInt32, value: win32more.Windows.Web.Http.Headers.HttpNameValueHeaderValue) -> Void: ...
    @winrt_mixinmethod
    def InsertAt(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.Headers.HttpNameValueHeaderValue], index: UInt32, value: win32more.Windows.Web.Http.Headers.HttpNameValueHeaderValue) -> Void: ...
    @winrt_mixinmethod
    def RemoveAt(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.Headers.HttpNameValueHeaderValue], index: UInt32) -> Void: ...
    @winrt_mixinmethod
    def Append(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.Headers.HttpNameValueHeaderValue], value: win32more.Windows.Web.Http.Headers.HttpNameValueHeaderValue) -> Void: ...
    @winrt_mixinmethod
    def RemoveAtEnd(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.Headers.HttpNameValueHeaderValue]) -> Void: ...
    @winrt_mixinmethod
    def Clear(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.Headers.HttpNameValueHeaderValue]) -> Void: ...
    @winrt_mixinmethod
    def GetMany(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.Headers.HttpNameValueHeaderValue], startIndex: UInt32, items: FillArray[win32more.Windows.Web.Http.Headers.HttpNameValueHeaderValue]) -> UInt32: ...
    @winrt_mixinmethod
    def ReplaceAll(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.Headers.HttpNameValueHeaderValue], items: PassArray[win32more.Windows.Web.Http.Headers.HttpNameValueHeaderValue]) -> Void: ...
    @winrt_mixinmethod
    def First(self: win32more.Windows.Foundation.Collections.IIterable[win32more.Windows.Web.Http.Headers.HttpNameValueHeaderValue]) -> win32more.Windows.Foundation.Collections.IIterator[win32more.Windows.Web.Http.Headers.HttpNameValueHeaderValue]: ...
    @winrt_mixinmethod
    def ToString(self: win32more.Windows.Foundation.IStringable) -> WinRT_String: ...
    MaxAge = property(get_MaxAge, put_MaxAge)
    MaxStale = property(get_MaxStale, put_MaxStale)
    MinFresh = property(get_MinFresh, put_MinFresh)
    SharedMaxAge = property(get_SharedMaxAge, put_SharedMaxAge)
    Size = property(get_Size, None)
class HttpChallengeHeaderValue(ComPtr):
    extends: IInspectable
    default_interface: win32more.Windows.Web.Http.Headers.IHttpChallengeHeaderValue
    _classid_ = 'Windows.Web.Http.Headers.HttpChallengeHeaderValue'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 1:
            super().__init__(move=win32more.Windows.Web.Http.Headers.HttpChallengeHeaderValue.CreateFromScheme(*args))
        elif len(args) == 2:
            super().__init__(move=win32more.Windows.Web.Http.Headers.HttpChallengeHeaderValue.CreateFromSchemeWithToken(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_factorymethod
    def CreateFromScheme(cls: win32more.Windows.Web.Http.Headers.IHttpChallengeHeaderValueFactory, scheme: WinRT_String) -> win32more.Windows.Web.Http.Headers.HttpChallengeHeaderValue: ...
    @winrt_factorymethod
    def CreateFromSchemeWithToken(cls: win32more.Windows.Web.Http.Headers.IHttpChallengeHeaderValueFactory, scheme: WinRT_String, token: WinRT_String) -> win32more.Windows.Web.Http.Headers.HttpChallengeHeaderValue: ...
    @winrt_mixinmethod
    def get_Parameters(self: win32more.Windows.Web.Http.Headers.IHttpChallengeHeaderValue) -> win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.Headers.HttpNameValueHeaderValue]: ...
    @winrt_mixinmethod
    def get_Scheme(self: win32more.Windows.Web.Http.Headers.IHttpChallengeHeaderValue) -> WinRT_String: ...
    @winrt_mixinmethod
    def get_Token(self: win32more.Windows.Web.Http.Headers.IHttpChallengeHeaderValue) -> WinRT_String: ...
    @winrt_mixinmethod
    def ToString(self: win32more.Windows.Foundation.IStringable) -> WinRT_String: ...
    @winrt_classmethod
    def Parse(cls: win32more.Windows.Web.Http.Headers.IHttpChallengeHeaderValueStatics, input: WinRT_String) -> win32more.Windows.Web.Http.Headers.HttpChallengeHeaderValue: ...
    @winrt_classmethod
    def TryParse(cls: win32more.Windows.Web.Http.Headers.IHttpChallengeHeaderValueStatics, input: WinRT_String, challengeHeaderValue: POINTER(win32more.Windows.Web.Http.Headers.HttpChallengeHeaderValue)) -> Boolean: ...
    Parameters = property(get_Parameters, None)
    Scheme = property(get_Scheme, None)
    Token = property(get_Token, None)
class HttpChallengeHeaderValueCollection(ComPtr):
    extends: IInspectable
    implements: Tuple[SequenceProtocol[win32more.Windows.Web.Http.Headers.HttpChallengeHeaderValue]]
    default_interface: win32more.Windows.Web.Http.Headers.IHttpChallengeHeaderValueCollection
    _classid_ = 'Windows.Web.Http.Headers.HttpChallengeHeaderValueCollection'
    @winrt_mixinmethod
    def ParseAdd(self: win32more.Windows.Web.Http.Headers.IHttpChallengeHeaderValueCollection, input: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def TryParseAdd(self: win32more.Windows.Web.Http.Headers.IHttpChallengeHeaderValueCollection, input: WinRT_String) -> Boolean: ...
    @winrt_mixinmethod
    def GetAt(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.Headers.HttpChallengeHeaderValue], index: UInt32) -> win32more.Windows.Web.Http.Headers.HttpChallengeHeaderValue: ...
    @winrt_mixinmethod
    def get_Size(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.Headers.HttpChallengeHeaderValue]) -> UInt32: ...
    @winrt_mixinmethod
    def GetView(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.Headers.HttpChallengeHeaderValue]) -> win32more.Windows.Foundation.Collections.IVectorView[win32more.Windows.Web.Http.Headers.HttpChallengeHeaderValue]: ...
    @winrt_mixinmethod
    def IndexOf(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.Headers.HttpChallengeHeaderValue], value: win32more.Windows.Web.Http.Headers.HttpChallengeHeaderValue, index: POINTER(UInt32)) -> Boolean: ...
    @winrt_mixinmethod
    def SetAt(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.Headers.HttpChallengeHeaderValue], index: UInt32, value: win32more.Windows.Web.Http.Headers.HttpChallengeHeaderValue) -> Void: ...
    @winrt_mixinmethod
    def InsertAt(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.Headers.HttpChallengeHeaderValue], index: UInt32, value: win32more.Windows.Web.Http.Headers.HttpChallengeHeaderValue) -> Void: ...
    @winrt_mixinmethod
    def RemoveAt(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.Headers.HttpChallengeHeaderValue], index: UInt32) -> Void: ...
    @winrt_mixinmethod
    def Append(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.Headers.HttpChallengeHeaderValue], value: win32more.Windows.Web.Http.Headers.HttpChallengeHeaderValue) -> Void: ...
    @winrt_mixinmethod
    def RemoveAtEnd(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.Headers.HttpChallengeHeaderValue]) -> Void: ...
    @winrt_mixinmethod
    def Clear(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.Headers.HttpChallengeHeaderValue]) -> Void: ...
    @winrt_mixinmethod
    def GetMany(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.Headers.HttpChallengeHeaderValue], startIndex: UInt32, items: FillArray[win32more.Windows.Web.Http.Headers.HttpChallengeHeaderValue]) -> UInt32: ...
    @winrt_mixinmethod
    def ReplaceAll(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.Headers.HttpChallengeHeaderValue], items: PassArray[win32more.Windows.Web.Http.Headers.HttpChallengeHeaderValue]) -> Void: ...
    @winrt_mixinmethod
    def First(self: win32more.Windows.Foundation.Collections.IIterable[win32more.Windows.Web.Http.Headers.HttpChallengeHeaderValue]) -> win32more.Windows.Foundation.Collections.IIterator[win32more.Windows.Web.Http.Headers.HttpChallengeHeaderValue]: ...
    @winrt_mixinmethod
    def ToString(self: win32more.Windows.Foundation.IStringable) -> WinRT_String: ...
    Size = property(get_Size, None)
class HttpConnectionOptionHeaderValue(ComPtr):
    extends: IInspectable
    default_interface: win32more.Windows.Web.Http.Headers.IHttpConnectionOptionHeaderValue
    _classid_ = 'Windows.Web.Http.Headers.HttpConnectionOptionHeaderValue'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 1:
            super().__init__(move=win32more.Windows.Web.Http.Headers.HttpConnectionOptionHeaderValue.Create(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_factorymethod
    def Create(cls: win32more.Windows.Web.Http.Headers.IHttpConnectionOptionHeaderValueFactory, token: WinRT_String) -> win32more.Windows.Web.Http.Headers.HttpConnectionOptionHeaderValue: ...
    @winrt_mixinmethod
    def get_Token(self: win32more.Windows.Web.Http.Headers.IHttpConnectionOptionHeaderValue) -> WinRT_String: ...
    @winrt_mixinmethod
    def ToString(self: win32more.Windows.Foundation.IStringable) -> WinRT_String: ...
    @winrt_classmethod
    def Parse(cls: win32more.Windows.Web.Http.Headers.IHttpConnectionOptionHeaderValueStatics, input: WinRT_String) -> win32more.Windows.Web.Http.Headers.HttpConnectionOptionHeaderValue: ...
    @winrt_classmethod
    def TryParse(cls: win32more.Windows.Web.Http.Headers.IHttpConnectionOptionHeaderValueStatics, input: WinRT_String, connectionOptionHeaderValue: POINTER(win32more.Windows.Web.Http.Headers.HttpConnectionOptionHeaderValue)) -> Boolean: ...
    Token = property(get_Token, None)
class HttpConnectionOptionHeaderValueCollection(ComPtr):
    extends: IInspectable
    implements: Tuple[SequenceProtocol[win32more.Windows.Web.Http.Headers.HttpConnectionOptionHeaderValue]]
    default_interface: win32more.Windows.Web.Http.Headers.IHttpConnectionOptionHeaderValueCollection
    _classid_ = 'Windows.Web.Http.Headers.HttpConnectionOptionHeaderValueCollection'
    @winrt_mixinmethod
    def ParseAdd(self: win32more.Windows.Web.Http.Headers.IHttpConnectionOptionHeaderValueCollection, input: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def TryParseAdd(self: win32more.Windows.Web.Http.Headers.IHttpConnectionOptionHeaderValueCollection, input: WinRT_String) -> Boolean: ...
    @winrt_mixinmethod
    def GetAt(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.Headers.HttpConnectionOptionHeaderValue], index: UInt32) -> win32more.Windows.Web.Http.Headers.HttpConnectionOptionHeaderValue: ...
    @winrt_mixinmethod
    def get_Size(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.Headers.HttpConnectionOptionHeaderValue]) -> UInt32: ...
    @winrt_mixinmethod
    def GetView(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.Headers.HttpConnectionOptionHeaderValue]) -> win32more.Windows.Foundation.Collections.IVectorView[win32more.Windows.Web.Http.Headers.HttpConnectionOptionHeaderValue]: ...
    @winrt_mixinmethod
    def IndexOf(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.Headers.HttpConnectionOptionHeaderValue], value: win32more.Windows.Web.Http.Headers.HttpConnectionOptionHeaderValue, index: POINTER(UInt32)) -> Boolean: ...
    @winrt_mixinmethod
    def SetAt(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.Headers.HttpConnectionOptionHeaderValue], index: UInt32, value: win32more.Windows.Web.Http.Headers.HttpConnectionOptionHeaderValue) -> Void: ...
    @winrt_mixinmethod
    def InsertAt(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.Headers.HttpConnectionOptionHeaderValue], index: UInt32, value: win32more.Windows.Web.Http.Headers.HttpConnectionOptionHeaderValue) -> Void: ...
    @winrt_mixinmethod
    def RemoveAt(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.Headers.HttpConnectionOptionHeaderValue], index: UInt32) -> Void: ...
    @winrt_mixinmethod
    def Append(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.Headers.HttpConnectionOptionHeaderValue], value: win32more.Windows.Web.Http.Headers.HttpConnectionOptionHeaderValue) -> Void: ...
    @winrt_mixinmethod
    def RemoveAtEnd(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.Headers.HttpConnectionOptionHeaderValue]) -> Void: ...
    @winrt_mixinmethod
    def Clear(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.Headers.HttpConnectionOptionHeaderValue]) -> Void: ...
    @winrt_mixinmethod
    def GetMany(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.Headers.HttpConnectionOptionHeaderValue], startIndex: UInt32, items: FillArray[win32more.Windows.Web.Http.Headers.HttpConnectionOptionHeaderValue]) -> UInt32: ...
    @winrt_mixinmethod
    def ReplaceAll(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.Headers.HttpConnectionOptionHeaderValue], items: PassArray[win32more.Windows.Web.Http.Headers.HttpConnectionOptionHeaderValue]) -> Void: ...
    @winrt_mixinmethod
    def First(self: win32more.Windows.Foundation.Collections.IIterable[win32more.Windows.Web.Http.Headers.HttpConnectionOptionHeaderValue]) -> win32more.Windows.Foundation.Collections.IIterator[win32more.Windows.Web.Http.Headers.HttpConnectionOptionHeaderValue]: ...
    @winrt_mixinmethod
    def ToString(self: win32more.Windows.Foundation.IStringable) -> WinRT_String: ...
    Size = property(get_Size, None)
class HttpContentCodingHeaderValue(ComPtr):
    extends: IInspectable
    default_interface: win32more.Windows.Web.Http.Headers.IHttpContentCodingHeaderValue
    _classid_ = 'Windows.Web.Http.Headers.HttpContentCodingHeaderValue'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 1:
            super().__init__(move=win32more.Windows.Web.Http.Headers.HttpContentCodingHeaderValue.Create(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_factorymethod
    def Create(cls: win32more.Windows.Web.Http.Headers.IHttpContentCodingHeaderValueFactory, contentCoding: WinRT_String) -> win32more.Windows.Web.Http.Headers.HttpContentCodingHeaderValue: ...
    @winrt_mixinmethod
    def get_ContentCoding(self: win32more.Windows.Web.Http.Headers.IHttpContentCodingHeaderValue) -> WinRT_String: ...
    @winrt_mixinmethod
    def ToString(self: win32more.Windows.Foundation.IStringable) -> WinRT_String: ...
    @winrt_classmethod
    def Parse(cls: win32more.Windows.Web.Http.Headers.IHttpContentCodingHeaderValueStatics, input: WinRT_String) -> win32more.Windows.Web.Http.Headers.HttpContentCodingHeaderValue: ...
    @winrt_classmethod
    def TryParse(cls: win32more.Windows.Web.Http.Headers.IHttpContentCodingHeaderValueStatics, input: WinRT_String, contentCodingHeaderValue: POINTER(win32more.Windows.Web.Http.Headers.HttpContentCodingHeaderValue)) -> Boolean: ...
    ContentCoding = property(get_ContentCoding, None)
class HttpContentCodingHeaderValueCollection(ComPtr):
    extends: IInspectable
    implements: Tuple[SequenceProtocol[win32more.Windows.Web.Http.Headers.HttpContentCodingHeaderValue]]
    default_interface: win32more.Windows.Web.Http.Headers.IHttpContentCodingHeaderValueCollection
    _classid_ = 'Windows.Web.Http.Headers.HttpContentCodingHeaderValueCollection'
    @winrt_mixinmethod
    def ParseAdd(self: win32more.Windows.Web.Http.Headers.IHttpContentCodingHeaderValueCollection, input: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def TryParseAdd(self: win32more.Windows.Web.Http.Headers.IHttpContentCodingHeaderValueCollection, input: WinRT_String) -> Boolean: ...
    @winrt_mixinmethod
    def GetAt(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.Headers.HttpContentCodingHeaderValue], index: UInt32) -> win32more.Windows.Web.Http.Headers.HttpContentCodingHeaderValue: ...
    @winrt_mixinmethod
    def get_Size(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.Headers.HttpContentCodingHeaderValue]) -> UInt32: ...
    @winrt_mixinmethod
    def GetView(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.Headers.HttpContentCodingHeaderValue]) -> win32more.Windows.Foundation.Collections.IVectorView[win32more.Windows.Web.Http.Headers.HttpContentCodingHeaderValue]: ...
    @winrt_mixinmethod
    def IndexOf(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.Headers.HttpContentCodingHeaderValue], value: win32more.Windows.Web.Http.Headers.HttpContentCodingHeaderValue, index: POINTER(UInt32)) -> Boolean: ...
    @winrt_mixinmethod
    def SetAt(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.Headers.HttpContentCodingHeaderValue], index: UInt32, value: win32more.Windows.Web.Http.Headers.HttpContentCodingHeaderValue) -> Void: ...
    @winrt_mixinmethod
    def InsertAt(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.Headers.HttpContentCodingHeaderValue], index: UInt32, value: win32more.Windows.Web.Http.Headers.HttpContentCodingHeaderValue) -> Void: ...
    @winrt_mixinmethod
    def RemoveAt(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.Headers.HttpContentCodingHeaderValue], index: UInt32) -> Void: ...
    @winrt_mixinmethod
    def Append(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.Headers.HttpContentCodingHeaderValue], value: win32more.Windows.Web.Http.Headers.HttpContentCodingHeaderValue) -> Void: ...
    @winrt_mixinmethod
    def RemoveAtEnd(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.Headers.HttpContentCodingHeaderValue]) -> Void: ...
    @winrt_mixinmethod
    def Clear(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.Headers.HttpContentCodingHeaderValue]) -> Void: ...
    @winrt_mixinmethod
    def GetMany(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.Headers.HttpContentCodingHeaderValue], startIndex: UInt32, items: FillArray[win32more.Windows.Web.Http.Headers.HttpContentCodingHeaderValue]) -> UInt32: ...
    @winrt_mixinmethod
    def ReplaceAll(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.Headers.HttpContentCodingHeaderValue], items: PassArray[win32more.Windows.Web.Http.Headers.HttpContentCodingHeaderValue]) -> Void: ...
    @winrt_mixinmethod
    def First(self: win32more.Windows.Foundation.Collections.IIterable[win32more.Windows.Web.Http.Headers.HttpContentCodingHeaderValue]) -> win32more.Windows.Foundation.Collections.IIterator[win32more.Windows.Web.Http.Headers.HttpContentCodingHeaderValue]: ...
    @winrt_mixinmethod
    def ToString(self: win32more.Windows.Foundation.IStringable) -> WinRT_String: ...
    Size = property(get_Size, None)
class HttpContentCodingWithQualityHeaderValue(ComPtr):
    extends: IInspectable
    default_interface: win32more.Windows.Web.Http.Headers.IHttpContentCodingWithQualityHeaderValue
    _classid_ = 'Windows.Web.Http.Headers.HttpContentCodingWithQualityHeaderValue'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 1:
            super().__init__(move=win32more.Windows.Web.Http.Headers.HttpContentCodingWithQualityHeaderValue.CreateFromValue(*args))
        elif len(args) == 2:
            super().__init__(move=win32more.Windows.Web.Http.Headers.HttpContentCodingWithQualityHeaderValue.CreateFromValueWithQuality(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_factorymethod
    def CreateFromValue(cls: win32more.Windows.Web.Http.Headers.IHttpContentCodingWithQualityHeaderValueFactory, contentCoding: WinRT_String) -> win32more.Windows.Web.Http.Headers.HttpContentCodingWithQualityHeaderValue: ...
    @winrt_factorymethod
    def CreateFromValueWithQuality(cls: win32more.Windows.Web.Http.Headers.IHttpContentCodingWithQualityHeaderValueFactory, contentCoding: WinRT_String, quality: Double) -> win32more.Windows.Web.Http.Headers.HttpContentCodingWithQualityHeaderValue: ...
    @winrt_mixinmethod
    def get_ContentCoding(self: win32more.Windows.Web.Http.Headers.IHttpContentCodingWithQualityHeaderValue) -> WinRT_String: ...
    @winrt_mixinmethod
    def get_Quality(self: win32more.Windows.Web.Http.Headers.IHttpContentCodingWithQualityHeaderValue) -> win32more.Windows.Foundation.IReference[Double]: ...
    @winrt_mixinmethod
    def ToString(self: win32more.Windows.Foundation.IStringable) -> WinRT_String: ...
    @winrt_classmethod
    def Parse(cls: win32more.Windows.Web.Http.Headers.IHttpContentCodingWithQualityHeaderValueStatics, input: WinRT_String) -> win32more.Windows.Web.Http.Headers.HttpContentCodingWithQualityHeaderValue: ...
    @winrt_classmethod
    def TryParse(cls: win32more.Windows.Web.Http.Headers.IHttpContentCodingWithQualityHeaderValueStatics, input: WinRT_String, contentCodingWithQualityHeaderValue: POINTER(win32more.Windows.Web.Http.Headers.HttpContentCodingWithQualityHeaderValue)) -> Boolean: ...
    ContentCoding = property(get_ContentCoding, None)
    Quality = property(get_Quality, None)
class HttpContentCodingWithQualityHeaderValueCollection(ComPtr):
    extends: IInspectable
    implements: Tuple[SequenceProtocol[win32more.Windows.Web.Http.Headers.HttpContentCodingWithQualityHeaderValue]]
    default_interface: win32more.Windows.Web.Http.Headers.IHttpContentCodingWithQualityHeaderValueCollection
    _classid_ = 'Windows.Web.Http.Headers.HttpContentCodingWithQualityHeaderValueCollection'
    @winrt_mixinmethod
    def ParseAdd(self: win32more.Windows.Web.Http.Headers.IHttpContentCodingWithQualityHeaderValueCollection, input: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def TryParseAdd(self: win32more.Windows.Web.Http.Headers.IHttpContentCodingWithQualityHeaderValueCollection, input: WinRT_String) -> Boolean: ...
    @winrt_mixinmethod
    def GetAt(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.Headers.HttpContentCodingWithQualityHeaderValue], index: UInt32) -> win32more.Windows.Web.Http.Headers.HttpContentCodingWithQualityHeaderValue: ...
    @winrt_mixinmethod
    def get_Size(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.Headers.HttpContentCodingWithQualityHeaderValue]) -> UInt32: ...
    @winrt_mixinmethod
    def GetView(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.Headers.HttpContentCodingWithQualityHeaderValue]) -> win32more.Windows.Foundation.Collections.IVectorView[win32more.Windows.Web.Http.Headers.HttpContentCodingWithQualityHeaderValue]: ...
    @winrt_mixinmethod
    def IndexOf(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.Headers.HttpContentCodingWithQualityHeaderValue], value: win32more.Windows.Web.Http.Headers.HttpContentCodingWithQualityHeaderValue, index: POINTER(UInt32)) -> Boolean: ...
    @winrt_mixinmethod
    def SetAt(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.Headers.HttpContentCodingWithQualityHeaderValue], index: UInt32, value: win32more.Windows.Web.Http.Headers.HttpContentCodingWithQualityHeaderValue) -> Void: ...
    @winrt_mixinmethod
    def InsertAt(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.Headers.HttpContentCodingWithQualityHeaderValue], index: UInt32, value: win32more.Windows.Web.Http.Headers.HttpContentCodingWithQualityHeaderValue) -> Void: ...
    @winrt_mixinmethod
    def RemoveAt(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.Headers.HttpContentCodingWithQualityHeaderValue], index: UInt32) -> Void: ...
    @winrt_mixinmethod
    def Append(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.Headers.HttpContentCodingWithQualityHeaderValue], value: win32more.Windows.Web.Http.Headers.HttpContentCodingWithQualityHeaderValue) -> Void: ...
    @winrt_mixinmethod
    def RemoveAtEnd(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.Headers.HttpContentCodingWithQualityHeaderValue]) -> Void: ...
    @winrt_mixinmethod
    def Clear(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.Headers.HttpContentCodingWithQualityHeaderValue]) -> Void: ...
    @winrt_mixinmethod
    def GetMany(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.Headers.HttpContentCodingWithQualityHeaderValue], startIndex: UInt32, items: FillArray[win32more.Windows.Web.Http.Headers.HttpContentCodingWithQualityHeaderValue]) -> UInt32: ...
    @winrt_mixinmethod
    def ReplaceAll(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.Headers.HttpContentCodingWithQualityHeaderValue], items: PassArray[win32more.Windows.Web.Http.Headers.HttpContentCodingWithQualityHeaderValue]) -> Void: ...
    @winrt_mixinmethod
    def First(self: win32more.Windows.Foundation.Collections.IIterable[win32more.Windows.Web.Http.Headers.HttpContentCodingWithQualityHeaderValue]) -> win32more.Windows.Foundation.Collections.IIterator[win32more.Windows.Web.Http.Headers.HttpContentCodingWithQualityHeaderValue]: ...
    @winrt_mixinmethod
    def ToString(self: win32more.Windows.Foundation.IStringable) -> WinRT_String: ...
    Size = property(get_Size, None)
class HttpContentDispositionHeaderValue(ComPtr):
    extends: IInspectable
    default_interface: win32more.Windows.Web.Http.Headers.IHttpContentDispositionHeaderValue
    _classid_ = 'Windows.Web.Http.Headers.HttpContentDispositionHeaderValue'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 1:
            super().__init__(move=win32more.Windows.Web.Http.Headers.HttpContentDispositionHeaderValue.Create(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_factorymethod
    def Create(cls: win32more.Windows.Web.Http.Headers.IHttpContentDispositionHeaderValueFactory, dispositionType: WinRT_String) -> win32more.Windows.Web.Http.Headers.HttpContentDispositionHeaderValue: ...
    @winrt_mixinmethod
    def get_DispositionType(self: win32more.Windows.Web.Http.Headers.IHttpContentDispositionHeaderValue) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_DispositionType(self: win32more.Windows.Web.Http.Headers.IHttpContentDispositionHeaderValue, value: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def get_FileName(self: win32more.Windows.Web.Http.Headers.IHttpContentDispositionHeaderValue) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_FileName(self: win32more.Windows.Web.Http.Headers.IHttpContentDispositionHeaderValue, value: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def get_FileNameStar(self: win32more.Windows.Web.Http.Headers.IHttpContentDispositionHeaderValue) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_FileNameStar(self: win32more.Windows.Web.Http.Headers.IHttpContentDispositionHeaderValue, value: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def get_Name(self: win32more.Windows.Web.Http.Headers.IHttpContentDispositionHeaderValue) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_Name(self: win32more.Windows.Web.Http.Headers.IHttpContentDispositionHeaderValue, value: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def get_Parameters(self: win32more.Windows.Web.Http.Headers.IHttpContentDispositionHeaderValue) -> win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.Headers.HttpNameValueHeaderValue]: ...
    @winrt_mixinmethod
    def get_Size(self: win32more.Windows.Web.Http.Headers.IHttpContentDispositionHeaderValue) -> win32more.Windows.Foundation.IReference[UInt64]: ...
    @winrt_mixinmethod
    def put_Size(self: win32more.Windows.Web.Http.Headers.IHttpContentDispositionHeaderValue, value: win32more.Windows.Foundation.IReference[UInt64]) -> Void: ...
    @winrt_mixinmethod
    def ToString(self: win32more.Windows.Foundation.IStringable) -> WinRT_String: ...
    @winrt_classmethod
    def Parse(cls: win32more.Windows.Web.Http.Headers.IHttpContentDispositionHeaderValueStatics, input: WinRT_String) -> win32more.Windows.Web.Http.Headers.HttpContentDispositionHeaderValue: ...
    @winrt_classmethod
    def TryParse(cls: win32more.Windows.Web.Http.Headers.IHttpContentDispositionHeaderValueStatics, input: WinRT_String, contentDispositionHeaderValue: POINTER(win32more.Windows.Web.Http.Headers.HttpContentDispositionHeaderValue)) -> Boolean: ...
    DispositionType = property(get_DispositionType, put_DispositionType)
    FileName = property(get_FileName, put_FileName)
    FileNameStar = property(get_FileNameStar, put_FileNameStar)
    Name = property(get_Name, put_Name)
    Parameters = property(get_Parameters, None)
    Size = property(get_Size, put_Size)
class HttpContentHeaderCollection(ComPtr):
    extends: IInspectable
    implements: Tuple[MappingProtocol[WinRT_String, WinRT_String]]
    default_interface: win32more.Windows.Web.Http.Headers.IHttpContentHeaderCollection
    _classid_ = 'Windows.Web.Http.Headers.HttpContentHeaderCollection'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 0:
            super().__init__(move=win32more.Windows.Web.Http.Headers.HttpContentHeaderCollection.CreateInstance(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_activatemethod
    def CreateInstance(cls) -> win32more.Windows.Web.Http.Headers.HttpContentHeaderCollection: ...
    @winrt_mixinmethod
    def get_ContentDisposition(self: win32more.Windows.Web.Http.Headers.IHttpContentHeaderCollection) -> win32more.Windows.Web.Http.Headers.HttpContentDispositionHeaderValue: ...
    @winrt_mixinmethod
    def put_ContentDisposition(self: win32more.Windows.Web.Http.Headers.IHttpContentHeaderCollection, value: win32more.Windows.Web.Http.Headers.HttpContentDispositionHeaderValue) -> Void: ...
    @winrt_mixinmethod
    def get_ContentEncoding(self: win32more.Windows.Web.Http.Headers.IHttpContentHeaderCollection) -> win32more.Windows.Web.Http.Headers.HttpContentCodingHeaderValueCollection: ...
    @winrt_mixinmethod
    def get_ContentLanguage(self: win32more.Windows.Web.Http.Headers.IHttpContentHeaderCollection) -> win32more.Windows.Web.Http.Headers.HttpLanguageHeaderValueCollection: ...
    @winrt_mixinmethod
    def get_ContentLength(self: win32more.Windows.Web.Http.Headers.IHttpContentHeaderCollection) -> win32more.Windows.Foundation.IReference[UInt64]: ...
    @winrt_mixinmethod
    def put_ContentLength(self: win32more.Windows.Web.Http.Headers.IHttpContentHeaderCollection, value: win32more.Windows.Foundation.IReference[UInt64]) -> Void: ...
    @winrt_mixinmethod
    def get_ContentLocation(self: win32more.Windows.Web.Http.Headers.IHttpContentHeaderCollection) -> win32more.Windows.Foundation.Uri: ...
    @winrt_mixinmethod
    def put_ContentLocation(self: win32more.Windows.Web.Http.Headers.IHttpContentHeaderCollection, value: win32more.Windows.Foundation.Uri) -> Void: ...
    @winrt_mixinmethod
    def get_ContentMD5(self: win32more.Windows.Web.Http.Headers.IHttpContentHeaderCollection) -> win32more.Windows.Storage.Streams.IBuffer: ...
    @winrt_mixinmethod
    def put_ContentMD5(self: win32more.Windows.Web.Http.Headers.IHttpContentHeaderCollection, value: win32more.Windows.Storage.Streams.IBuffer) -> Void: ...
    @winrt_mixinmethod
    def get_ContentRange(self: win32more.Windows.Web.Http.Headers.IHttpContentHeaderCollection) -> win32more.Windows.Web.Http.Headers.HttpContentRangeHeaderValue: ...
    @winrt_mixinmethod
    def put_ContentRange(self: win32more.Windows.Web.Http.Headers.IHttpContentHeaderCollection, value: win32more.Windows.Web.Http.Headers.HttpContentRangeHeaderValue) -> Void: ...
    @winrt_mixinmethod
    def get_ContentType(self: win32more.Windows.Web.Http.Headers.IHttpContentHeaderCollection) -> win32more.Windows.Web.Http.Headers.HttpMediaTypeHeaderValue: ...
    @winrt_mixinmethod
    def put_ContentType(self: win32more.Windows.Web.Http.Headers.IHttpContentHeaderCollection, value: win32more.Windows.Web.Http.Headers.HttpMediaTypeHeaderValue) -> Void: ...
    @winrt_mixinmethod
    def get_Expires(self: win32more.Windows.Web.Http.Headers.IHttpContentHeaderCollection) -> win32more.Windows.Foundation.IReference[win32more.Windows.Foundation.DateTime]: ...
    @winrt_mixinmethod
    def put_Expires(self: win32more.Windows.Web.Http.Headers.IHttpContentHeaderCollection, value: win32more.Windows.Foundation.IReference[win32more.Windows.Foundation.DateTime]) -> Void: ...
    @winrt_mixinmethod
    def get_LastModified(self: win32more.Windows.Web.Http.Headers.IHttpContentHeaderCollection) -> win32more.Windows.Foundation.IReference[win32more.Windows.Foundation.DateTime]: ...
    @winrt_mixinmethod
    def put_LastModified(self: win32more.Windows.Web.Http.Headers.IHttpContentHeaderCollection, value: win32more.Windows.Foundation.IReference[win32more.Windows.Foundation.DateTime]) -> Void: ...
    @winrt_mixinmethod
    def Append(self: win32more.Windows.Web.Http.Headers.IHttpContentHeaderCollection, name: WinRT_String, value: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def TryAppendWithoutValidation(self: win32more.Windows.Web.Http.Headers.IHttpContentHeaderCollection, name: WinRT_String, value: WinRT_String) -> Boolean: ...
    @winrt_mixinmethod
    def Lookup(self: win32more.Windows.Foundation.Collections.IMap[WinRT_String, WinRT_String], key: WinRT_String) -> WinRT_String: ...
    @winrt_mixinmethod
    def get_Size(self: win32more.Windows.Foundation.Collections.IMap[WinRT_String, WinRT_String]) -> UInt32: ...
    @winrt_mixinmethod
    def HasKey(self: win32more.Windows.Foundation.Collections.IMap[WinRT_String, WinRT_String], key: WinRT_String) -> Boolean: ...
    @winrt_mixinmethod
    def GetView(self: win32more.Windows.Foundation.Collections.IMap[WinRT_String, WinRT_String]) -> win32more.Windows.Foundation.Collections.IMapView[WinRT_String, WinRT_String]: ...
    @winrt_mixinmethod
    def Insert(self: win32more.Windows.Foundation.Collections.IMap[WinRT_String, WinRT_String], key: WinRT_String, value: WinRT_String) -> Boolean: ...
    @winrt_mixinmethod
    def Remove(self: win32more.Windows.Foundation.Collections.IMap[WinRT_String, WinRT_String], key: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def Clear(self: win32more.Windows.Foundation.Collections.IMap[WinRT_String, WinRT_String]) -> Void: ...
    @winrt_mixinmethod
    def First(self: win32more.Windows.Foundation.Collections.IIterable[win32more.Windows.Foundation.Collections.IKeyValuePair[WinRT_String, WinRT_String]]) -> win32more.Windows.Foundation.Collections.IIterator[win32more.Windows.Foundation.Collections.IKeyValuePair[WinRT_String, WinRT_String]]: ...
    @winrt_mixinmethod
    def ToString(self: win32more.Windows.Foundation.IStringable) -> WinRT_String: ...
    ContentDisposition = property(get_ContentDisposition, put_ContentDisposition)
    ContentEncoding = property(get_ContentEncoding, None)
    ContentLanguage = property(get_ContentLanguage, None)
    ContentLength = property(get_ContentLength, put_ContentLength)
    ContentLocation = property(get_ContentLocation, put_ContentLocation)
    ContentMD5 = property(get_ContentMD5, put_ContentMD5)
    ContentRange = property(get_ContentRange, put_ContentRange)
    ContentType = property(get_ContentType, put_ContentType)
    Expires = property(get_Expires, put_Expires)
    LastModified = property(get_LastModified, put_LastModified)
    Size = property(get_Size, None)
class HttpContentRangeHeaderValue(ComPtr):
    extends: IInspectable
    default_interface: win32more.Windows.Web.Http.Headers.IHttpContentRangeHeaderValue
    _classid_ = 'Windows.Web.Http.Headers.HttpContentRangeHeaderValue'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 1:
            super().__init__(move=win32more.Windows.Web.Http.Headers.HttpContentRangeHeaderValue.CreateFromLength(*args))
        elif len(args) == 2:
            super().__init__(move=win32more.Windows.Web.Http.Headers.HttpContentRangeHeaderValue.CreateFromRange(*args))
        elif len(args) == 3:
            super().__init__(move=win32more.Windows.Web.Http.Headers.HttpContentRangeHeaderValue.CreateFromRangeWithLength(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_factorymethod
    def CreateFromLength(cls: win32more.Windows.Web.Http.Headers.IHttpContentRangeHeaderValueFactory, length: UInt64) -> win32more.Windows.Web.Http.Headers.HttpContentRangeHeaderValue: ...
    @winrt_factorymethod
    def CreateFromRange(cls: win32more.Windows.Web.Http.Headers.IHttpContentRangeHeaderValueFactory, from_: UInt64, to: UInt64) -> win32more.Windows.Web.Http.Headers.HttpContentRangeHeaderValue: ...
    @winrt_factorymethod
    def CreateFromRangeWithLength(cls: win32more.Windows.Web.Http.Headers.IHttpContentRangeHeaderValueFactory, from_: UInt64, to: UInt64, length: UInt64) -> win32more.Windows.Web.Http.Headers.HttpContentRangeHeaderValue: ...
    @winrt_mixinmethod
    def get_FirstBytePosition(self: win32more.Windows.Web.Http.Headers.IHttpContentRangeHeaderValue) -> win32more.Windows.Foundation.IReference[UInt64]: ...
    @winrt_mixinmethod
    def get_LastBytePosition(self: win32more.Windows.Web.Http.Headers.IHttpContentRangeHeaderValue) -> win32more.Windows.Foundation.IReference[UInt64]: ...
    @winrt_mixinmethod
    def get_Length(self: win32more.Windows.Web.Http.Headers.IHttpContentRangeHeaderValue) -> win32more.Windows.Foundation.IReference[UInt64]: ...
    @winrt_mixinmethod
    def get_Unit(self: win32more.Windows.Web.Http.Headers.IHttpContentRangeHeaderValue) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_Unit(self: win32more.Windows.Web.Http.Headers.IHttpContentRangeHeaderValue, value: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def ToString(self: win32more.Windows.Foundation.IStringable) -> WinRT_String: ...
    @winrt_classmethod
    def Parse(cls: win32more.Windows.Web.Http.Headers.IHttpContentRangeHeaderValueStatics, input: WinRT_String) -> win32more.Windows.Web.Http.Headers.HttpContentRangeHeaderValue: ...
    @winrt_classmethod
    def TryParse(cls: win32more.Windows.Web.Http.Headers.IHttpContentRangeHeaderValueStatics, input: WinRT_String, contentRangeHeaderValue: POINTER(win32more.Windows.Web.Http.Headers.HttpContentRangeHeaderValue)) -> Boolean: ...
    FirstBytePosition = property(get_FirstBytePosition, None)
    LastBytePosition = property(get_LastBytePosition, None)
    Length = property(get_Length, None)
    Unit = property(get_Unit, put_Unit)
class HttpCookiePairHeaderValue(ComPtr):
    extends: IInspectable
    default_interface: win32more.Windows.Web.Http.Headers.IHttpCookiePairHeaderValue
    _classid_ = 'Windows.Web.Http.Headers.HttpCookiePairHeaderValue'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 1:
            super().__init__(move=win32more.Windows.Web.Http.Headers.HttpCookiePairHeaderValue.CreateFromName(*args))
        elif len(args) == 2:
            super().__init__(move=win32more.Windows.Web.Http.Headers.HttpCookiePairHeaderValue.CreateFromNameWithValue(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_factorymethod
    def CreateFromName(cls: win32more.Windows.Web.Http.Headers.IHttpCookiePairHeaderValueFactory, name: WinRT_String) -> win32more.Windows.Web.Http.Headers.HttpCookiePairHeaderValue: ...
    @winrt_factorymethod
    def CreateFromNameWithValue(cls: win32more.Windows.Web.Http.Headers.IHttpCookiePairHeaderValueFactory, name: WinRT_String, value: WinRT_String) -> win32more.Windows.Web.Http.Headers.HttpCookiePairHeaderValue: ...
    @winrt_mixinmethod
    def get_Name(self: win32more.Windows.Web.Http.Headers.IHttpCookiePairHeaderValue) -> WinRT_String: ...
    @winrt_mixinmethod
    def get_Value(self: win32more.Windows.Web.Http.Headers.IHttpCookiePairHeaderValue) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_Value(self: win32more.Windows.Web.Http.Headers.IHttpCookiePairHeaderValue, value: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def ToString(self: win32more.Windows.Foundation.IStringable) -> WinRT_String: ...
    @winrt_classmethod
    def Parse(cls: win32more.Windows.Web.Http.Headers.IHttpCookiePairHeaderValueStatics, input: WinRT_String) -> win32more.Windows.Web.Http.Headers.HttpCookiePairHeaderValue: ...
    @winrt_classmethod
    def TryParse(cls: win32more.Windows.Web.Http.Headers.IHttpCookiePairHeaderValueStatics, input: WinRT_String, cookiePairHeaderValue: POINTER(win32more.Windows.Web.Http.Headers.HttpCookiePairHeaderValue)) -> Boolean: ...
    Name = property(get_Name, None)
    Value = property(get_Value, put_Value)
class HttpCookiePairHeaderValueCollection(ComPtr):
    extends: IInspectable
    implements: Tuple[SequenceProtocol[win32more.Windows.Web.Http.Headers.HttpCookiePairHeaderValue]]
    default_interface: win32more.Windows.Web.Http.Headers.IHttpCookiePairHeaderValueCollection
    _classid_ = 'Windows.Web.Http.Headers.HttpCookiePairHeaderValueCollection'
    @winrt_mixinmethod
    def ParseAdd(self: win32more.Windows.Web.Http.Headers.IHttpCookiePairHeaderValueCollection, input: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def TryParseAdd(self: win32more.Windows.Web.Http.Headers.IHttpCookiePairHeaderValueCollection, input: WinRT_String) -> Boolean: ...
    @winrt_mixinmethod
    def GetAt(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.Headers.HttpCookiePairHeaderValue], index: UInt32) -> win32more.Windows.Web.Http.Headers.HttpCookiePairHeaderValue: ...
    @winrt_mixinmethod
    def get_Size(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.Headers.HttpCookiePairHeaderValue]) -> UInt32: ...
    @winrt_mixinmethod
    def GetView(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.Headers.HttpCookiePairHeaderValue]) -> win32more.Windows.Foundation.Collections.IVectorView[win32more.Windows.Web.Http.Headers.HttpCookiePairHeaderValue]: ...
    @winrt_mixinmethod
    def IndexOf(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.Headers.HttpCookiePairHeaderValue], value: win32more.Windows.Web.Http.Headers.HttpCookiePairHeaderValue, index: POINTER(UInt32)) -> Boolean: ...
    @winrt_mixinmethod
    def SetAt(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.Headers.HttpCookiePairHeaderValue], index: UInt32, value: win32more.Windows.Web.Http.Headers.HttpCookiePairHeaderValue) -> Void: ...
    @winrt_mixinmethod
    def InsertAt(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.Headers.HttpCookiePairHeaderValue], index: UInt32, value: win32more.Windows.Web.Http.Headers.HttpCookiePairHeaderValue) -> Void: ...
    @winrt_mixinmethod
    def RemoveAt(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.Headers.HttpCookiePairHeaderValue], index: UInt32) -> Void: ...
    @winrt_mixinmethod
    def Append(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.Headers.HttpCookiePairHeaderValue], value: win32more.Windows.Web.Http.Headers.HttpCookiePairHeaderValue) -> Void: ...
    @winrt_mixinmethod
    def RemoveAtEnd(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.Headers.HttpCookiePairHeaderValue]) -> Void: ...
    @winrt_mixinmethod
    def Clear(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.Headers.HttpCookiePairHeaderValue]) -> Void: ...
    @winrt_mixinmethod
    def GetMany(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.Headers.HttpCookiePairHeaderValue], startIndex: UInt32, items: FillArray[win32more.Windows.Web.Http.Headers.HttpCookiePairHeaderValue]) -> UInt32: ...
    @winrt_mixinmethod
    def ReplaceAll(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.Headers.HttpCookiePairHeaderValue], items: PassArray[win32more.Windows.Web.Http.Headers.HttpCookiePairHeaderValue]) -> Void: ...
    @winrt_mixinmethod
    def First(self: win32more.Windows.Foundation.Collections.IIterable[win32more.Windows.Web.Http.Headers.HttpCookiePairHeaderValue]) -> win32more.Windows.Foundation.Collections.IIterator[win32more.Windows.Web.Http.Headers.HttpCookiePairHeaderValue]: ...
    @winrt_mixinmethod
    def ToString(self: win32more.Windows.Foundation.IStringable) -> WinRT_String: ...
    Size = property(get_Size, None)
class HttpCredentialsHeaderValue(ComPtr):
    extends: IInspectable
    default_interface: win32more.Windows.Web.Http.Headers.IHttpCredentialsHeaderValue
    _classid_ = 'Windows.Web.Http.Headers.HttpCredentialsHeaderValue'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 1:
            super().__init__(move=win32more.Windows.Web.Http.Headers.HttpCredentialsHeaderValue.CreateFromScheme(*args))
        elif len(args) == 2:
            super().__init__(move=win32more.Windows.Web.Http.Headers.HttpCredentialsHeaderValue.CreateFromSchemeWithToken(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_factorymethod
    def CreateFromScheme(cls: win32more.Windows.Web.Http.Headers.IHttpCredentialsHeaderValueFactory, scheme: WinRT_String) -> win32more.Windows.Web.Http.Headers.HttpCredentialsHeaderValue: ...
    @winrt_factorymethod
    def CreateFromSchemeWithToken(cls: win32more.Windows.Web.Http.Headers.IHttpCredentialsHeaderValueFactory, scheme: WinRT_String, token: WinRT_String) -> win32more.Windows.Web.Http.Headers.HttpCredentialsHeaderValue: ...
    @winrt_mixinmethod
    def get_Parameters(self: win32more.Windows.Web.Http.Headers.IHttpCredentialsHeaderValue) -> win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.Headers.HttpNameValueHeaderValue]: ...
    @winrt_mixinmethod
    def get_Scheme(self: win32more.Windows.Web.Http.Headers.IHttpCredentialsHeaderValue) -> WinRT_String: ...
    @winrt_mixinmethod
    def get_Token(self: win32more.Windows.Web.Http.Headers.IHttpCredentialsHeaderValue) -> WinRT_String: ...
    @winrt_mixinmethod
    def ToString(self: win32more.Windows.Foundation.IStringable) -> WinRT_String: ...
    @winrt_classmethod
    def Parse(cls: win32more.Windows.Web.Http.Headers.IHttpCredentialsHeaderValueStatics, input: WinRT_String) -> win32more.Windows.Web.Http.Headers.HttpCredentialsHeaderValue: ...
    @winrt_classmethod
    def TryParse(cls: win32more.Windows.Web.Http.Headers.IHttpCredentialsHeaderValueStatics, input: WinRT_String, credentialsHeaderValue: POINTER(win32more.Windows.Web.Http.Headers.HttpCredentialsHeaderValue)) -> Boolean: ...
    Parameters = property(get_Parameters, None)
    Scheme = property(get_Scheme, None)
    Token = property(get_Token, None)
class HttpDateOrDeltaHeaderValue(ComPtr):
    extends: IInspectable
    default_interface: win32more.Windows.Web.Http.Headers.IHttpDateOrDeltaHeaderValue
    _classid_ = 'Windows.Web.Http.Headers.HttpDateOrDeltaHeaderValue'
    @winrt_mixinmethod
    def get_Date(self: win32more.Windows.Web.Http.Headers.IHttpDateOrDeltaHeaderValue) -> win32more.Windows.Foundation.IReference[win32more.Windows.Foundation.DateTime]: ...
    @winrt_mixinmethod
    def get_Delta(self: win32more.Windows.Web.Http.Headers.IHttpDateOrDeltaHeaderValue) -> win32more.Windows.Foundation.IReference[win32more.Windows.Foundation.TimeSpan]: ...
    @winrt_mixinmethod
    def ToString(self: win32more.Windows.Foundation.IStringable) -> WinRT_String: ...
    @winrt_classmethod
    def Parse(cls: win32more.Windows.Web.Http.Headers.IHttpDateOrDeltaHeaderValueStatics, input: WinRT_String) -> win32more.Windows.Web.Http.Headers.HttpDateOrDeltaHeaderValue: ...
    @winrt_classmethod
    def TryParse(cls: win32more.Windows.Web.Http.Headers.IHttpDateOrDeltaHeaderValueStatics, input: WinRT_String, dateOrDeltaHeaderValue: POINTER(win32more.Windows.Web.Http.Headers.HttpDateOrDeltaHeaderValue)) -> Boolean: ...
    Date = property(get_Date, None)
    Delta = property(get_Delta, None)
class HttpExpectationHeaderValue(ComPtr):
    extends: IInspectable
    default_interface: win32more.Windows.Web.Http.Headers.IHttpExpectationHeaderValue
    _classid_ = 'Windows.Web.Http.Headers.HttpExpectationHeaderValue'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 1:
            super().__init__(move=win32more.Windows.Web.Http.Headers.HttpExpectationHeaderValue.CreateFromName(*args))
        elif len(args) == 2:
            super().__init__(move=win32more.Windows.Web.Http.Headers.HttpExpectationHeaderValue.CreateFromNameWithValue(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_factorymethod
    def CreateFromName(cls: win32more.Windows.Web.Http.Headers.IHttpExpectationHeaderValueFactory, name: WinRT_String) -> win32more.Windows.Web.Http.Headers.HttpExpectationHeaderValue: ...
    @winrt_factorymethod
    def CreateFromNameWithValue(cls: win32more.Windows.Web.Http.Headers.IHttpExpectationHeaderValueFactory, name: WinRT_String, value: WinRT_String) -> win32more.Windows.Web.Http.Headers.HttpExpectationHeaderValue: ...
    @winrt_mixinmethod
    def get_Name(self: win32more.Windows.Web.Http.Headers.IHttpExpectationHeaderValue) -> WinRT_String: ...
    @winrt_mixinmethod
    def get_Value(self: win32more.Windows.Web.Http.Headers.IHttpExpectationHeaderValue) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_Value(self: win32more.Windows.Web.Http.Headers.IHttpExpectationHeaderValue, value: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def get_Parameters(self: win32more.Windows.Web.Http.Headers.IHttpExpectationHeaderValue) -> win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.Headers.HttpNameValueHeaderValue]: ...
    @winrt_mixinmethod
    def ToString(self: win32more.Windows.Foundation.IStringable) -> WinRT_String: ...
    @winrt_classmethod
    def Parse(cls: win32more.Windows.Web.Http.Headers.IHttpExpectationHeaderValueStatics, input: WinRT_String) -> win32more.Windows.Web.Http.Headers.HttpExpectationHeaderValue: ...
    @winrt_classmethod
    def TryParse(cls: win32more.Windows.Web.Http.Headers.IHttpExpectationHeaderValueStatics, input: WinRT_String, expectationHeaderValue: POINTER(win32more.Windows.Web.Http.Headers.HttpExpectationHeaderValue)) -> Boolean: ...
    Name = property(get_Name, None)
    Parameters = property(get_Parameters, None)
    Value = property(get_Value, put_Value)
class HttpExpectationHeaderValueCollection(ComPtr):
    extends: IInspectable
    implements: Tuple[SequenceProtocol[win32more.Windows.Web.Http.Headers.HttpExpectationHeaderValue]]
    default_interface: win32more.Windows.Web.Http.Headers.IHttpExpectationHeaderValueCollection
    _classid_ = 'Windows.Web.Http.Headers.HttpExpectationHeaderValueCollection'
    @winrt_mixinmethod
    def ParseAdd(self: win32more.Windows.Web.Http.Headers.IHttpExpectationHeaderValueCollection, input: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def TryParseAdd(self: win32more.Windows.Web.Http.Headers.IHttpExpectationHeaderValueCollection, input: WinRT_String) -> Boolean: ...
    @winrt_mixinmethod
    def GetAt(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.Headers.HttpExpectationHeaderValue], index: UInt32) -> win32more.Windows.Web.Http.Headers.HttpExpectationHeaderValue: ...
    @winrt_mixinmethod
    def get_Size(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.Headers.HttpExpectationHeaderValue]) -> UInt32: ...
    @winrt_mixinmethod
    def GetView(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.Headers.HttpExpectationHeaderValue]) -> win32more.Windows.Foundation.Collections.IVectorView[win32more.Windows.Web.Http.Headers.HttpExpectationHeaderValue]: ...
    @winrt_mixinmethod
    def IndexOf(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.Headers.HttpExpectationHeaderValue], value: win32more.Windows.Web.Http.Headers.HttpExpectationHeaderValue, index: POINTER(UInt32)) -> Boolean: ...
    @winrt_mixinmethod
    def SetAt(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.Headers.HttpExpectationHeaderValue], index: UInt32, value: win32more.Windows.Web.Http.Headers.HttpExpectationHeaderValue) -> Void: ...
    @winrt_mixinmethod
    def InsertAt(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.Headers.HttpExpectationHeaderValue], index: UInt32, value: win32more.Windows.Web.Http.Headers.HttpExpectationHeaderValue) -> Void: ...
    @winrt_mixinmethod
    def RemoveAt(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.Headers.HttpExpectationHeaderValue], index: UInt32) -> Void: ...
    @winrt_mixinmethod
    def Append(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.Headers.HttpExpectationHeaderValue], value: win32more.Windows.Web.Http.Headers.HttpExpectationHeaderValue) -> Void: ...
    @winrt_mixinmethod
    def RemoveAtEnd(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.Headers.HttpExpectationHeaderValue]) -> Void: ...
    @winrt_mixinmethod
    def Clear(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.Headers.HttpExpectationHeaderValue]) -> Void: ...
    @winrt_mixinmethod
    def GetMany(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.Headers.HttpExpectationHeaderValue], startIndex: UInt32, items: FillArray[win32more.Windows.Web.Http.Headers.HttpExpectationHeaderValue]) -> UInt32: ...
    @winrt_mixinmethod
    def ReplaceAll(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.Headers.HttpExpectationHeaderValue], items: PassArray[win32more.Windows.Web.Http.Headers.HttpExpectationHeaderValue]) -> Void: ...
    @winrt_mixinmethod
    def First(self: win32more.Windows.Foundation.Collections.IIterable[win32more.Windows.Web.Http.Headers.HttpExpectationHeaderValue]) -> win32more.Windows.Foundation.Collections.IIterator[win32more.Windows.Web.Http.Headers.HttpExpectationHeaderValue]: ...
    @winrt_mixinmethod
    def ToString(self: win32more.Windows.Foundation.IStringable) -> WinRT_String: ...
    Size = property(get_Size, None)
class HttpLanguageHeaderValueCollection(ComPtr):
    extends: IInspectable
    implements: Tuple[SequenceProtocol[win32more.Windows.Globalization.Language]]
    default_interface: win32more.Windows.Web.Http.Headers.IHttpLanguageHeaderValueCollection
    _classid_ = 'Windows.Web.Http.Headers.HttpLanguageHeaderValueCollection'
    @winrt_mixinmethod
    def ParseAdd(self: win32more.Windows.Web.Http.Headers.IHttpLanguageHeaderValueCollection, input: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def TryParseAdd(self: win32more.Windows.Web.Http.Headers.IHttpLanguageHeaderValueCollection, input: WinRT_String) -> Boolean: ...
    @winrt_mixinmethod
    def GetAt(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Globalization.Language], index: UInt32) -> win32more.Windows.Globalization.Language: ...
    @winrt_mixinmethod
    def get_Size(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Globalization.Language]) -> UInt32: ...
    @winrt_mixinmethod
    def GetView(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Globalization.Language]) -> win32more.Windows.Foundation.Collections.IVectorView[win32more.Windows.Globalization.Language]: ...
    @winrt_mixinmethod
    def IndexOf(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Globalization.Language], value: win32more.Windows.Globalization.Language, index: POINTER(UInt32)) -> Boolean: ...
    @winrt_mixinmethod
    def SetAt(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Globalization.Language], index: UInt32, value: win32more.Windows.Globalization.Language) -> Void: ...
    @winrt_mixinmethod
    def InsertAt(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Globalization.Language], index: UInt32, value: win32more.Windows.Globalization.Language) -> Void: ...
    @winrt_mixinmethod
    def RemoveAt(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Globalization.Language], index: UInt32) -> Void: ...
    @winrt_mixinmethod
    def Append(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Globalization.Language], value: win32more.Windows.Globalization.Language) -> Void: ...
    @winrt_mixinmethod
    def RemoveAtEnd(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Globalization.Language]) -> Void: ...
    @winrt_mixinmethod
    def Clear(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Globalization.Language]) -> Void: ...
    @winrt_mixinmethod
    def GetMany(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Globalization.Language], startIndex: UInt32, items: FillArray[win32more.Windows.Globalization.Language]) -> UInt32: ...
    @winrt_mixinmethod
    def ReplaceAll(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Globalization.Language], items: PassArray[win32more.Windows.Globalization.Language]) -> Void: ...
    @winrt_mixinmethod
    def First(self: win32more.Windows.Foundation.Collections.IIterable[win32more.Windows.Globalization.Language]) -> win32more.Windows.Foundation.Collections.IIterator[win32more.Windows.Globalization.Language]: ...
    @winrt_mixinmethod
    def ToString(self: win32more.Windows.Foundation.IStringable) -> WinRT_String: ...
    Size = property(get_Size, None)
class HttpLanguageRangeWithQualityHeaderValue(ComPtr):
    extends: IInspectable
    default_interface: win32more.Windows.Web.Http.Headers.IHttpLanguageRangeWithQualityHeaderValue
    _classid_ = 'Windows.Web.Http.Headers.HttpLanguageRangeWithQualityHeaderValue'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 1:
            super().__init__(move=win32more.Windows.Web.Http.Headers.HttpLanguageRangeWithQualityHeaderValue.CreateFromLanguageRange(*args))
        elif len(args) == 2:
            super().__init__(move=win32more.Windows.Web.Http.Headers.HttpLanguageRangeWithQualityHeaderValue.CreateFromLanguageRangeWithQuality(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_factorymethod
    def CreateFromLanguageRange(cls: win32more.Windows.Web.Http.Headers.IHttpLanguageRangeWithQualityHeaderValueFactory, languageRange: WinRT_String) -> win32more.Windows.Web.Http.Headers.HttpLanguageRangeWithQualityHeaderValue: ...
    @winrt_factorymethod
    def CreateFromLanguageRangeWithQuality(cls: win32more.Windows.Web.Http.Headers.IHttpLanguageRangeWithQualityHeaderValueFactory, languageRange: WinRT_String, quality: Double) -> win32more.Windows.Web.Http.Headers.HttpLanguageRangeWithQualityHeaderValue: ...
    @winrt_mixinmethod
    def get_LanguageRange(self: win32more.Windows.Web.Http.Headers.IHttpLanguageRangeWithQualityHeaderValue) -> WinRT_String: ...
    @winrt_mixinmethod
    def get_Quality(self: win32more.Windows.Web.Http.Headers.IHttpLanguageRangeWithQualityHeaderValue) -> win32more.Windows.Foundation.IReference[Double]: ...
    @winrt_mixinmethod
    def ToString(self: win32more.Windows.Foundation.IStringable) -> WinRT_String: ...
    @winrt_classmethod
    def Parse(cls: win32more.Windows.Web.Http.Headers.IHttpLanguageRangeWithQualityHeaderValueStatics, input: WinRT_String) -> win32more.Windows.Web.Http.Headers.HttpLanguageRangeWithQualityHeaderValue: ...
    @winrt_classmethod
    def TryParse(cls: win32more.Windows.Web.Http.Headers.IHttpLanguageRangeWithQualityHeaderValueStatics, input: WinRT_String, languageRangeWithQualityHeaderValue: POINTER(win32more.Windows.Web.Http.Headers.HttpLanguageRangeWithQualityHeaderValue)) -> Boolean: ...
    LanguageRange = property(get_LanguageRange, None)
    Quality = property(get_Quality, None)
class HttpLanguageRangeWithQualityHeaderValueCollection(ComPtr):
    extends: IInspectable
    implements: Tuple[SequenceProtocol[win32more.Windows.Web.Http.Headers.HttpLanguageRangeWithQualityHeaderValue]]
    default_interface: win32more.Windows.Web.Http.Headers.IHttpLanguageRangeWithQualityHeaderValueCollection
    _classid_ = 'Windows.Web.Http.Headers.HttpLanguageRangeWithQualityHeaderValueCollection'
    @winrt_mixinmethod
    def ParseAdd(self: win32more.Windows.Web.Http.Headers.IHttpLanguageRangeWithQualityHeaderValueCollection, input: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def TryParseAdd(self: win32more.Windows.Web.Http.Headers.IHttpLanguageRangeWithQualityHeaderValueCollection, input: WinRT_String) -> Boolean: ...
    @winrt_mixinmethod
    def GetAt(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.Headers.HttpLanguageRangeWithQualityHeaderValue], index: UInt32) -> win32more.Windows.Web.Http.Headers.HttpLanguageRangeWithQualityHeaderValue: ...
    @winrt_mixinmethod
    def get_Size(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.Headers.HttpLanguageRangeWithQualityHeaderValue]) -> UInt32: ...
    @winrt_mixinmethod
    def GetView(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.Headers.HttpLanguageRangeWithQualityHeaderValue]) -> win32more.Windows.Foundation.Collections.IVectorView[win32more.Windows.Web.Http.Headers.HttpLanguageRangeWithQualityHeaderValue]: ...
    @winrt_mixinmethod
    def IndexOf(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.Headers.HttpLanguageRangeWithQualityHeaderValue], value: win32more.Windows.Web.Http.Headers.HttpLanguageRangeWithQualityHeaderValue, index: POINTER(UInt32)) -> Boolean: ...
    @winrt_mixinmethod
    def SetAt(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.Headers.HttpLanguageRangeWithQualityHeaderValue], index: UInt32, value: win32more.Windows.Web.Http.Headers.HttpLanguageRangeWithQualityHeaderValue) -> Void: ...
    @winrt_mixinmethod
    def InsertAt(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.Headers.HttpLanguageRangeWithQualityHeaderValue], index: UInt32, value: win32more.Windows.Web.Http.Headers.HttpLanguageRangeWithQualityHeaderValue) -> Void: ...
    @winrt_mixinmethod
    def RemoveAt(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.Headers.HttpLanguageRangeWithQualityHeaderValue], index: UInt32) -> Void: ...
    @winrt_mixinmethod
    def Append(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.Headers.HttpLanguageRangeWithQualityHeaderValue], value: win32more.Windows.Web.Http.Headers.HttpLanguageRangeWithQualityHeaderValue) -> Void: ...
    @winrt_mixinmethod
    def RemoveAtEnd(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.Headers.HttpLanguageRangeWithQualityHeaderValue]) -> Void: ...
    @winrt_mixinmethod
    def Clear(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.Headers.HttpLanguageRangeWithQualityHeaderValue]) -> Void: ...
    @winrt_mixinmethod
    def GetMany(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.Headers.HttpLanguageRangeWithQualityHeaderValue], startIndex: UInt32, items: FillArray[win32more.Windows.Web.Http.Headers.HttpLanguageRangeWithQualityHeaderValue]) -> UInt32: ...
    @winrt_mixinmethod
    def ReplaceAll(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.Headers.HttpLanguageRangeWithQualityHeaderValue], items: PassArray[win32more.Windows.Web.Http.Headers.HttpLanguageRangeWithQualityHeaderValue]) -> Void: ...
    @winrt_mixinmethod
    def First(self: win32more.Windows.Foundation.Collections.IIterable[win32more.Windows.Web.Http.Headers.HttpLanguageRangeWithQualityHeaderValue]) -> win32more.Windows.Foundation.Collections.IIterator[win32more.Windows.Web.Http.Headers.HttpLanguageRangeWithQualityHeaderValue]: ...
    @winrt_mixinmethod
    def ToString(self: win32more.Windows.Foundation.IStringable) -> WinRT_String: ...
    Size = property(get_Size, None)
class HttpMediaTypeHeaderValue(ComPtr):
    extends: IInspectable
    default_interface: win32more.Windows.Web.Http.Headers.IHttpMediaTypeHeaderValue
    _classid_ = 'Windows.Web.Http.Headers.HttpMediaTypeHeaderValue'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 1:
            super().__init__(move=win32more.Windows.Web.Http.Headers.HttpMediaTypeHeaderValue.Create(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_factorymethod
    def Create(cls: win32more.Windows.Web.Http.Headers.IHttpMediaTypeHeaderValueFactory, mediaType: WinRT_String) -> win32more.Windows.Web.Http.Headers.HttpMediaTypeHeaderValue: ...
    @winrt_mixinmethod
    def get_CharSet(self: win32more.Windows.Web.Http.Headers.IHttpMediaTypeHeaderValue) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_CharSet(self: win32more.Windows.Web.Http.Headers.IHttpMediaTypeHeaderValue, value: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def get_MediaType(self: win32more.Windows.Web.Http.Headers.IHttpMediaTypeHeaderValue) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_MediaType(self: win32more.Windows.Web.Http.Headers.IHttpMediaTypeHeaderValue, value: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def get_Parameters(self: win32more.Windows.Web.Http.Headers.IHttpMediaTypeHeaderValue) -> win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.Headers.HttpNameValueHeaderValue]: ...
    @winrt_mixinmethod
    def ToString(self: win32more.Windows.Foundation.IStringable) -> WinRT_String: ...
    @winrt_classmethod
    def Parse(cls: win32more.Windows.Web.Http.Headers.IHttpMediaTypeHeaderValueStatics, input: WinRT_String) -> win32more.Windows.Web.Http.Headers.HttpMediaTypeHeaderValue: ...
    @winrt_classmethod
    def TryParse(cls: win32more.Windows.Web.Http.Headers.IHttpMediaTypeHeaderValueStatics, input: WinRT_String, mediaTypeHeaderValue: POINTER(win32more.Windows.Web.Http.Headers.HttpMediaTypeHeaderValue)) -> Boolean: ...
    CharSet = property(get_CharSet, put_CharSet)
    MediaType = property(get_MediaType, put_MediaType)
    Parameters = property(get_Parameters, None)
class HttpMediaTypeWithQualityHeaderValue(ComPtr):
    extends: IInspectable
    default_interface: win32more.Windows.Web.Http.Headers.IHttpMediaTypeWithQualityHeaderValue
    _classid_ = 'Windows.Web.Http.Headers.HttpMediaTypeWithQualityHeaderValue'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 1:
            super().__init__(move=win32more.Windows.Web.Http.Headers.HttpMediaTypeWithQualityHeaderValue.CreateFromMediaType(*args))
        elif len(args) == 2:
            super().__init__(move=win32more.Windows.Web.Http.Headers.HttpMediaTypeWithQualityHeaderValue.CreateFromMediaTypeWithQuality(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_factorymethod
    def CreateFromMediaType(cls: win32more.Windows.Web.Http.Headers.IHttpMediaTypeWithQualityHeaderValueFactory, mediaType: WinRT_String) -> win32more.Windows.Web.Http.Headers.HttpMediaTypeWithQualityHeaderValue: ...
    @winrt_factorymethod
    def CreateFromMediaTypeWithQuality(cls: win32more.Windows.Web.Http.Headers.IHttpMediaTypeWithQualityHeaderValueFactory, mediaType: WinRT_String, quality: Double) -> win32more.Windows.Web.Http.Headers.HttpMediaTypeWithQualityHeaderValue: ...
    @winrt_mixinmethod
    def get_CharSet(self: win32more.Windows.Web.Http.Headers.IHttpMediaTypeWithQualityHeaderValue) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_CharSet(self: win32more.Windows.Web.Http.Headers.IHttpMediaTypeWithQualityHeaderValue, value: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def get_MediaType(self: win32more.Windows.Web.Http.Headers.IHttpMediaTypeWithQualityHeaderValue) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_MediaType(self: win32more.Windows.Web.Http.Headers.IHttpMediaTypeWithQualityHeaderValue, value: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def get_Parameters(self: win32more.Windows.Web.Http.Headers.IHttpMediaTypeWithQualityHeaderValue) -> win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.Headers.HttpNameValueHeaderValue]: ...
    @winrt_mixinmethod
    def get_Quality(self: win32more.Windows.Web.Http.Headers.IHttpMediaTypeWithQualityHeaderValue) -> win32more.Windows.Foundation.IReference[Double]: ...
    @winrt_mixinmethod
    def put_Quality(self: win32more.Windows.Web.Http.Headers.IHttpMediaTypeWithQualityHeaderValue, value: win32more.Windows.Foundation.IReference[Double]) -> Void: ...
    @winrt_mixinmethod
    def ToString(self: win32more.Windows.Foundation.IStringable) -> WinRT_String: ...
    @winrt_classmethod
    def Parse(cls: win32more.Windows.Web.Http.Headers.IHttpMediaTypeWithQualityHeaderValueStatics, input: WinRT_String) -> win32more.Windows.Web.Http.Headers.HttpMediaTypeWithQualityHeaderValue: ...
    @winrt_classmethod
    def TryParse(cls: win32more.Windows.Web.Http.Headers.IHttpMediaTypeWithQualityHeaderValueStatics, input: WinRT_String, mediaTypeWithQualityHeaderValue: POINTER(win32more.Windows.Web.Http.Headers.HttpMediaTypeWithQualityHeaderValue)) -> Boolean: ...
    CharSet = property(get_CharSet, put_CharSet)
    MediaType = property(get_MediaType, put_MediaType)
    Parameters = property(get_Parameters, None)
    Quality = property(get_Quality, put_Quality)
class HttpMediaTypeWithQualityHeaderValueCollection(ComPtr):
    extends: IInspectable
    implements: Tuple[SequenceProtocol[win32more.Windows.Web.Http.Headers.HttpMediaTypeWithQualityHeaderValue]]
    default_interface: win32more.Windows.Web.Http.Headers.IHttpMediaTypeWithQualityHeaderValueCollection
    _classid_ = 'Windows.Web.Http.Headers.HttpMediaTypeWithQualityHeaderValueCollection'
    @winrt_mixinmethod
    def ParseAdd(self: win32more.Windows.Web.Http.Headers.IHttpMediaTypeWithQualityHeaderValueCollection, input: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def TryParseAdd(self: win32more.Windows.Web.Http.Headers.IHttpMediaTypeWithQualityHeaderValueCollection, input: WinRT_String) -> Boolean: ...
    @winrt_mixinmethod
    def GetAt(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.Headers.HttpMediaTypeWithQualityHeaderValue], index: UInt32) -> win32more.Windows.Web.Http.Headers.HttpMediaTypeWithQualityHeaderValue: ...
    @winrt_mixinmethod
    def get_Size(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.Headers.HttpMediaTypeWithQualityHeaderValue]) -> UInt32: ...
    @winrt_mixinmethod
    def GetView(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.Headers.HttpMediaTypeWithQualityHeaderValue]) -> win32more.Windows.Foundation.Collections.IVectorView[win32more.Windows.Web.Http.Headers.HttpMediaTypeWithQualityHeaderValue]: ...
    @winrt_mixinmethod
    def IndexOf(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.Headers.HttpMediaTypeWithQualityHeaderValue], value: win32more.Windows.Web.Http.Headers.HttpMediaTypeWithQualityHeaderValue, index: POINTER(UInt32)) -> Boolean: ...
    @winrt_mixinmethod
    def SetAt(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.Headers.HttpMediaTypeWithQualityHeaderValue], index: UInt32, value: win32more.Windows.Web.Http.Headers.HttpMediaTypeWithQualityHeaderValue) -> Void: ...
    @winrt_mixinmethod
    def InsertAt(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.Headers.HttpMediaTypeWithQualityHeaderValue], index: UInt32, value: win32more.Windows.Web.Http.Headers.HttpMediaTypeWithQualityHeaderValue) -> Void: ...
    @winrt_mixinmethod
    def RemoveAt(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.Headers.HttpMediaTypeWithQualityHeaderValue], index: UInt32) -> Void: ...
    @winrt_mixinmethod
    def Append(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.Headers.HttpMediaTypeWithQualityHeaderValue], value: win32more.Windows.Web.Http.Headers.HttpMediaTypeWithQualityHeaderValue) -> Void: ...
    @winrt_mixinmethod
    def RemoveAtEnd(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.Headers.HttpMediaTypeWithQualityHeaderValue]) -> Void: ...
    @winrt_mixinmethod
    def Clear(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.Headers.HttpMediaTypeWithQualityHeaderValue]) -> Void: ...
    @winrt_mixinmethod
    def GetMany(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.Headers.HttpMediaTypeWithQualityHeaderValue], startIndex: UInt32, items: FillArray[win32more.Windows.Web.Http.Headers.HttpMediaTypeWithQualityHeaderValue]) -> UInt32: ...
    @winrt_mixinmethod
    def ReplaceAll(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.Headers.HttpMediaTypeWithQualityHeaderValue], items: PassArray[win32more.Windows.Web.Http.Headers.HttpMediaTypeWithQualityHeaderValue]) -> Void: ...
    @winrt_mixinmethod
    def First(self: win32more.Windows.Foundation.Collections.IIterable[win32more.Windows.Web.Http.Headers.HttpMediaTypeWithQualityHeaderValue]) -> win32more.Windows.Foundation.Collections.IIterator[win32more.Windows.Web.Http.Headers.HttpMediaTypeWithQualityHeaderValue]: ...
    @winrt_mixinmethod
    def ToString(self: win32more.Windows.Foundation.IStringable) -> WinRT_String: ...
    Size = property(get_Size, None)
class HttpMethodHeaderValueCollection(ComPtr):
    extends: IInspectable
    implements: Tuple[SequenceProtocol[win32more.Windows.Web.Http.HttpMethod]]
    default_interface: win32more.Windows.Web.Http.Headers.IHttpMethodHeaderValueCollection
    _classid_ = 'Windows.Web.Http.Headers.HttpMethodHeaderValueCollection'
    @winrt_mixinmethod
    def ParseAdd(self: win32more.Windows.Web.Http.Headers.IHttpMethodHeaderValueCollection, input: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def TryParseAdd(self: win32more.Windows.Web.Http.Headers.IHttpMethodHeaderValueCollection, input: WinRT_String) -> Boolean: ...
    @winrt_mixinmethod
    def GetAt(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.HttpMethod], index: UInt32) -> win32more.Windows.Web.Http.HttpMethod: ...
    @winrt_mixinmethod
    def get_Size(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.HttpMethod]) -> UInt32: ...
    @winrt_mixinmethod
    def GetView(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.HttpMethod]) -> win32more.Windows.Foundation.Collections.IVectorView[win32more.Windows.Web.Http.HttpMethod]: ...
    @winrt_mixinmethod
    def IndexOf(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.HttpMethod], value: win32more.Windows.Web.Http.HttpMethod, index: POINTER(UInt32)) -> Boolean: ...
    @winrt_mixinmethod
    def SetAt(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.HttpMethod], index: UInt32, value: win32more.Windows.Web.Http.HttpMethod) -> Void: ...
    @winrt_mixinmethod
    def InsertAt(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.HttpMethod], index: UInt32, value: win32more.Windows.Web.Http.HttpMethod) -> Void: ...
    @winrt_mixinmethod
    def RemoveAt(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.HttpMethod], index: UInt32) -> Void: ...
    @winrt_mixinmethod
    def Append(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.HttpMethod], value: win32more.Windows.Web.Http.HttpMethod) -> Void: ...
    @winrt_mixinmethod
    def RemoveAtEnd(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.HttpMethod]) -> Void: ...
    @winrt_mixinmethod
    def Clear(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.HttpMethod]) -> Void: ...
    @winrt_mixinmethod
    def GetMany(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.HttpMethod], startIndex: UInt32, items: FillArray[win32more.Windows.Web.Http.HttpMethod]) -> UInt32: ...
    @winrt_mixinmethod
    def ReplaceAll(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.HttpMethod], items: PassArray[win32more.Windows.Web.Http.HttpMethod]) -> Void: ...
    @winrt_mixinmethod
    def First(self: win32more.Windows.Foundation.Collections.IIterable[win32more.Windows.Web.Http.HttpMethod]) -> win32more.Windows.Foundation.Collections.IIterator[win32more.Windows.Web.Http.HttpMethod]: ...
    @winrt_mixinmethod
    def ToString(self: win32more.Windows.Foundation.IStringable) -> WinRT_String: ...
    Size = property(get_Size, None)
class HttpNameValueHeaderValue(ComPtr):
    extends: IInspectable
    default_interface: win32more.Windows.Web.Http.Headers.IHttpNameValueHeaderValue
    _classid_ = 'Windows.Web.Http.Headers.HttpNameValueHeaderValue'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 1:
            super().__init__(move=win32more.Windows.Web.Http.Headers.HttpNameValueHeaderValue.CreateFromName(*args))
        elif len(args) == 2:
            super().__init__(move=win32more.Windows.Web.Http.Headers.HttpNameValueHeaderValue.CreateFromNameWithValue(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_factorymethod
    def CreateFromName(cls: win32more.Windows.Web.Http.Headers.IHttpNameValueHeaderValueFactory, name: WinRT_String) -> win32more.Windows.Web.Http.Headers.HttpNameValueHeaderValue: ...
    @winrt_factorymethod
    def CreateFromNameWithValue(cls: win32more.Windows.Web.Http.Headers.IHttpNameValueHeaderValueFactory, name: WinRT_String, value: WinRT_String) -> win32more.Windows.Web.Http.Headers.HttpNameValueHeaderValue: ...
    @winrt_mixinmethod
    def get_Name(self: win32more.Windows.Web.Http.Headers.IHttpNameValueHeaderValue) -> WinRT_String: ...
    @winrt_mixinmethod
    def get_Value(self: win32more.Windows.Web.Http.Headers.IHttpNameValueHeaderValue) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_Value(self: win32more.Windows.Web.Http.Headers.IHttpNameValueHeaderValue, value: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def ToString(self: win32more.Windows.Foundation.IStringable) -> WinRT_String: ...
    @winrt_classmethod
    def Parse(cls: win32more.Windows.Web.Http.Headers.IHttpNameValueHeaderValueStatics, input: WinRT_String) -> win32more.Windows.Web.Http.Headers.HttpNameValueHeaderValue: ...
    @winrt_classmethod
    def TryParse(cls: win32more.Windows.Web.Http.Headers.IHttpNameValueHeaderValueStatics, input: WinRT_String, nameValueHeaderValue: POINTER(win32more.Windows.Web.Http.Headers.HttpNameValueHeaderValue)) -> Boolean: ...
    Name = property(get_Name, None)
    Value = property(get_Value, put_Value)
class HttpProductHeaderValue(ComPtr):
    extends: IInspectable
    default_interface: win32more.Windows.Web.Http.Headers.IHttpProductHeaderValue
    _classid_ = 'Windows.Web.Http.Headers.HttpProductHeaderValue'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 1:
            super().__init__(move=win32more.Windows.Web.Http.Headers.HttpProductHeaderValue.CreateFromName(*args))
        elif len(args) == 2:
            super().__init__(move=win32more.Windows.Web.Http.Headers.HttpProductHeaderValue.CreateFromNameWithVersion(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_factorymethod
    def CreateFromName(cls: win32more.Windows.Web.Http.Headers.IHttpProductHeaderValueFactory, productName: WinRT_String) -> win32more.Windows.Web.Http.Headers.HttpProductHeaderValue: ...
    @winrt_factorymethod
    def CreateFromNameWithVersion(cls: win32more.Windows.Web.Http.Headers.IHttpProductHeaderValueFactory, productName: WinRT_String, productVersion: WinRT_String) -> win32more.Windows.Web.Http.Headers.HttpProductHeaderValue: ...
    @winrt_mixinmethod
    def get_Name(self: win32more.Windows.Web.Http.Headers.IHttpProductHeaderValue) -> WinRT_String: ...
    @winrt_mixinmethod
    def get_Version(self: win32more.Windows.Web.Http.Headers.IHttpProductHeaderValue) -> WinRT_String: ...
    @winrt_mixinmethod
    def ToString(self: win32more.Windows.Foundation.IStringable) -> WinRT_String: ...
    @winrt_classmethod
    def Parse(cls: win32more.Windows.Web.Http.Headers.IHttpProductHeaderValueStatics, input: WinRT_String) -> win32more.Windows.Web.Http.Headers.HttpProductHeaderValue: ...
    @winrt_classmethod
    def TryParse(cls: win32more.Windows.Web.Http.Headers.IHttpProductHeaderValueStatics, input: WinRT_String, productHeaderValue: POINTER(win32more.Windows.Web.Http.Headers.HttpProductHeaderValue)) -> Boolean: ...
    Name = property(get_Name, None)
    Version = property(get_Version, None)
class HttpProductInfoHeaderValue(ComPtr):
    extends: IInspectable
    default_interface: win32more.Windows.Web.Http.Headers.IHttpProductInfoHeaderValue
    _classid_ = 'Windows.Web.Http.Headers.HttpProductInfoHeaderValue'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 1:
            super().__init__(move=win32more.Windows.Web.Http.Headers.HttpProductInfoHeaderValue.CreateFromComment(*args))
        elif len(args) == 2:
            super().__init__(move=win32more.Windows.Web.Http.Headers.HttpProductInfoHeaderValue.CreateFromNameWithVersion(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_factorymethod
    def CreateFromComment(cls: win32more.Windows.Web.Http.Headers.IHttpProductInfoHeaderValueFactory, productComment: WinRT_String) -> win32more.Windows.Web.Http.Headers.HttpProductInfoHeaderValue: ...
    @winrt_factorymethod
    def CreateFromNameWithVersion(cls: win32more.Windows.Web.Http.Headers.IHttpProductInfoHeaderValueFactory, productName: WinRT_String, productVersion: WinRT_String) -> win32more.Windows.Web.Http.Headers.HttpProductInfoHeaderValue: ...
    @winrt_mixinmethod
    def get_Product(self: win32more.Windows.Web.Http.Headers.IHttpProductInfoHeaderValue) -> win32more.Windows.Web.Http.Headers.HttpProductHeaderValue: ...
    @winrt_mixinmethod
    def get_Comment(self: win32more.Windows.Web.Http.Headers.IHttpProductInfoHeaderValue) -> WinRT_String: ...
    @winrt_mixinmethod
    def ToString(self: win32more.Windows.Foundation.IStringable) -> WinRT_String: ...
    @winrt_classmethod
    def Parse(cls: win32more.Windows.Web.Http.Headers.IHttpProductInfoHeaderValueStatics, input: WinRT_String) -> win32more.Windows.Web.Http.Headers.HttpProductInfoHeaderValue: ...
    @winrt_classmethod
    def TryParse(cls: win32more.Windows.Web.Http.Headers.IHttpProductInfoHeaderValueStatics, input: WinRT_String, productInfoHeaderValue: POINTER(win32more.Windows.Web.Http.Headers.HttpProductInfoHeaderValue)) -> Boolean: ...
    Comment = property(get_Comment, None)
    Product = property(get_Product, None)
class HttpProductInfoHeaderValueCollection(ComPtr):
    extends: IInspectable
    implements: Tuple[SequenceProtocol[win32more.Windows.Web.Http.Headers.HttpProductInfoHeaderValue]]
    default_interface: win32more.Windows.Web.Http.Headers.IHttpProductInfoHeaderValueCollection
    _classid_ = 'Windows.Web.Http.Headers.HttpProductInfoHeaderValueCollection'
    @winrt_mixinmethod
    def ParseAdd(self: win32more.Windows.Web.Http.Headers.IHttpProductInfoHeaderValueCollection, input: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def TryParseAdd(self: win32more.Windows.Web.Http.Headers.IHttpProductInfoHeaderValueCollection, input: WinRT_String) -> Boolean: ...
    @winrt_mixinmethod
    def GetAt(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.Headers.HttpProductInfoHeaderValue], index: UInt32) -> win32more.Windows.Web.Http.Headers.HttpProductInfoHeaderValue: ...
    @winrt_mixinmethod
    def get_Size(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.Headers.HttpProductInfoHeaderValue]) -> UInt32: ...
    @winrt_mixinmethod
    def GetView(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.Headers.HttpProductInfoHeaderValue]) -> win32more.Windows.Foundation.Collections.IVectorView[win32more.Windows.Web.Http.Headers.HttpProductInfoHeaderValue]: ...
    @winrt_mixinmethod
    def IndexOf(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.Headers.HttpProductInfoHeaderValue], value: win32more.Windows.Web.Http.Headers.HttpProductInfoHeaderValue, index: POINTER(UInt32)) -> Boolean: ...
    @winrt_mixinmethod
    def SetAt(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.Headers.HttpProductInfoHeaderValue], index: UInt32, value: win32more.Windows.Web.Http.Headers.HttpProductInfoHeaderValue) -> Void: ...
    @winrt_mixinmethod
    def InsertAt(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.Headers.HttpProductInfoHeaderValue], index: UInt32, value: win32more.Windows.Web.Http.Headers.HttpProductInfoHeaderValue) -> Void: ...
    @winrt_mixinmethod
    def RemoveAt(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.Headers.HttpProductInfoHeaderValue], index: UInt32) -> Void: ...
    @winrt_mixinmethod
    def Append(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.Headers.HttpProductInfoHeaderValue], value: win32more.Windows.Web.Http.Headers.HttpProductInfoHeaderValue) -> Void: ...
    @winrt_mixinmethod
    def RemoveAtEnd(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.Headers.HttpProductInfoHeaderValue]) -> Void: ...
    @winrt_mixinmethod
    def Clear(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.Headers.HttpProductInfoHeaderValue]) -> Void: ...
    @winrt_mixinmethod
    def GetMany(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.Headers.HttpProductInfoHeaderValue], startIndex: UInt32, items: FillArray[win32more.Windows.Web.Http.Headers.HttpProductInfoHeaderValue]) -> UInt32: ...
    @winrt_mixinmethod
    def ReplaceAll(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.Headers.HttpProductInfoHeaderValue], items: PassArray[win32more.Windows.Web.Http.Headers.HttpProductInfoHeaderValue]) -> Void: ...
    @winrt_mixinmethod
    def First(self: win32more.Windows.Foundation.Collections.IIterable[win32more.Windows.Web.Http.Headers.HttpProductInfoHeaderValue]) -> win32more.Windows.Foundation.Collections.IIterator[win32more.Windows.Web.Http.Headers.HttpProductInfoHeaderValue]: ...
    @winrt_mixinmethod
    def ToString(self: win32more.Windows.Foundation.IStringable) -> WinRT_String: ...
    Size = property(get_Size, None)
class HttpRequestHeaderCollection(ComPtr):
    extends: IInspectable
    implements: Tuple[MappingProtocol[WinRT_String, WinRT_String]]
    default_interface: win32more.Windows.Web.Http.Headers.IHttpRequestHeaderCollection
    _classid_ = 'Windows.Web.Http.Headers.HttpRequestHeaderCollection'
    @winrt_mixinmethod
    def get_Accept(self: win32more.Windows.Web.Http.Headers.IHttpRequestHeaderCollection) -> win32more.Windows.Web.Http.Headers.HttpMediaTypeWithQualityHeaderValueCollection: ...
    @winrt_mixinmethod
    def get_AcceptEncoding(self: win32more.Windows.Web.Http.Headers.IHttpRequestHeaderCollection) -> win32more.Windows.Web.Http.Headers.HttpContentCodingWithQualityHeaderValueCollection: ...
    @winrt_mixinmethod
    def get_AcceptLanguage(self: win32more.Windows.Web.Http.Headers.IHttpRequestHeaderCollection) -> win32more.Windows.Web.Http.Headers.HttpLanguageRangeWithQualityHeaderValueCollection: ...
    @winrt_mixinmethod
    def get_Authorization(self: win32more.Windows.Web.Http.Headers.IHttpRequestHeaderCollection) -> win32more.Windows.Web.Http.Headers.HttpCredentialsHeaderValue: ...
    @winrt_mixinmethod
    def put_Authorization(self: win32more.Windows.Web.Http.Headers.IHttpRequestHeaderCollection, value: win32more.Windows.Web.Http.Headers.HttpCredentialsHeaderValue) -> Void: ...
    @winrt_mixinmethod
    def get_CacheControl(self: win32more.Windows.Web.Http.Headers.IHttpRequestHeaderCollection) -> win32more.Windows.Web.Http.Headers.HttpCacheDirectiveHeaderValueCollection: ...
    @winrt_mixinmethod
    def get_Connection(self: win32more.Windows.Web.Http.Headers.IHttpRequestHeaderCollection) -> win32more.Windows.Web.Http.Headers.HttpConnectionOptionHeaderValueCollection: ...
    @winrt_mixinmethod
    def get_Cookie(self: win32more.Windows.Web.Http.Headers.IHttpRequestHeaderCollection) -> win32more.Windows.Web.Http.Headers.HttpCookiePairHeaderValueCollection: ...
    @winrt_mixinmethod
    def get_Date(self: win32more.Windows.Web.Http.Headers.IHttpRequestHeaderCollection) -> win32more.Windows.Foundation.IReference[win32more.Windows.Foundation.DateTime]: ...
    @winrt_mixinmethod
    def put_Date(self: win32more.Windows.Web.Http.Headers.IHttpRequestHeaderCollection, value: win32more.Windows.Foundation.IReference[win32more.Windows.Foundation.DateTime]) -> Void: ...
    @winrt_mixinmethod
    def get_Expect(self: win32more.Windows.Web.Http.Headers.IHttpRequestHeaderCollection) -> win32more.Windows.Web.Http.Headers.HttpExpectationHeaderValueCollection: ...
    @winrt_mixinmethod
    def get_From(self: win32more.Windows.Web.Http.Headers.IHttpRequestHeaderCollection) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_From(self: win32more.Windows.Web.Http.Headers.IHttpRequestHeaderCollection, value: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def get_Host(self: win32more.Windows.Web.Http.Headers.IHttpRequestHeaderCollection) -> win32more.Windows.Networking.HostName: ...
    @winrt_mixinmethod
    def put_Host(self: win32more.Windows.Web.Http.Headers.IHttpRequestHeaderCollection, value: win32more.Windows.Networking.HostName) -> Void: ...
    @winrt_mixinmethod
    def get_IfModifiedSince(self: win32more.Windows.Web.Http.Headers.IHttpRequestHeaderCollection) -> win32more.Windows.Foundation.IReference[win32more.Windows.Foundation.DateTime]: ...
    @winrt_mixinmethod
    def put_IfModifiedSince(self: win32more.Windows.Web.Http.Headers.IHttpRequestHeaderCollection, value: win32more.Windows.Foundation.IReference[win32more.Windows.Foundation.DateTime]) -> Void: ...
    @winrt_mixinmethod
    def get_IfUnmodifiedSince(self: win32more.Windows.Web.Http.Headers.IHttpRequestHeaderCollection) -> win32more.Windows.Foundation.IReference[win32more.Windows.Foundation.DateTime]: ...
    @winrt_mixinmethod
    def put_IfUnmodifiedSince(self: win32more.Windows.Web.Http.Headers.IHttpRequestHeaderCollection, value: win32more.Windows.Foundation.IReference[win32more.Windows.Foundation.DateTime]) -> Void: ...
    @winrt_mixinmethod
    def get_MaxForwards(self: win32more.Windows.Web.Http.Headers.IHttpRequestHeaderCollection) -> win32more.Windows.Foundation.IReference[UInt32]: ...
    @winrt_mixinmethod
    def put_MaxForwards(self: win32more.Windows.Web.Http.Headers.IHttpRequestHeaderCollection, value: win32more.Windows.Foundation.IReference[UInt32]) -> Void: ...
    @winrt_mixinmethod
    def get_ProxyAuthorization(self: win32more.Windows.Web.Http.Headers.IHttpRequestHeaderCollection) -> win32more.Windows.Web.Http.Headers.HttpCredentialsHeaderValue: ...
    @winrt_mixinmethod
    def put_ProxyAuthorization(self: win32more.Windows.Web.Http.Headers.IHttpRequestHeaderCollection, value: win32more.Windows.Web.Http.Headers.HttpCredentialsHeaderValue) -> Void: ...
    @winrt_mixinmethod
    def get_Referer(self: win32more.Windows.Web.Http.Headers.IHttpRequestHeaderCollection) -> win32more.Windows.Foundation.Uri: ...
    @winrt_mixinmethod
    def put_Referer(self: win32more.Windows.Web.Http.Headers.IHttpRequestHeaderCollection, value: win32more.Windows.Foundation.Uri) -> Void: ...
    @winrt_mixinmethod
    def get_TransferEncoding(self: win32more.Windows.Web.Http.Headers.IHttpRequestHeaderCollection) -> win32more.Windows.Web.Http.Headers.HttpTransferCodingHeaderValueCollection: ...
    @winrt_mixinmethod
    def get_UserAgent(self: win32more.Windows.Web.Http.Headers.IHttpRequestHeaderCollection) -> win32more.Windows.Web.Http.Headers.HttpProductInfoHeaderValueCollection: ...
    @winrt_mixinmethod
    def Append(self: win32more.Windows.Web.Http.Headers.IHttpRequestHeaderCollection, name: WinRT_String, value: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def TryAppendWithoutValidation(self: win32more.Windows.Web.Http.Headers.IHttpRequestHeaderCollection, name: WinRT_String, value: WinRT_String) -> Boolean: ...
    @winrt_mixinmethod
    def Lookup(self: win32more.Windows.Foundation.Collections.IMap[WinRT_String, WinRT_String], key: WinRT_String) -> WinRT_String: ...
    @winrt_mixinmethod
    def get_Size(self: win32more.Windows.Foundation.Collections.IMap[WinRT_String, WinRT_String]) -> UInt32: ...
    @winrt_mixinmethod
    def HasKey(self: win32more.Windows.Foundation.Collections.IMap[WinRT_String, WinRT_String], key: WinRT_String) -> Boolean: ...
    @winrt_mixinmethod
    def GetView(self: win32more.Windows.Foundation.Collections.IMap[WinRT_String, WinRT_String]) -> win32more.Windows.Foundation.Collections.IMapView[WinRT_String, WinRT_String]: ...
    @winrt_mixinmethod
    def Insert(self: win32more.Windows.Foundation.Collections.IMap[WinRT_String, WinRT_String], key: WinRT_String, value: WinRT_String) -> Boolean: ...
    @winrt_mixinmethod
    def Remove(self: win32more.Windows.Foundation.Collections.IMap[WinRT_String, WinRT_String], key: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def Clear(self: win32more.Windows.Foundation.Collections.IMap[WinRT_String, WinRT_String]) -> Void: ...
    @winrt_mixinmethod
    def First(self: win32more.Windows.Foundation.Collections.IIterable[win32more.Windows.Foundation.Collections.IKeyValuePair[WinRT_String, WinRT_String]]) -> win32more.Windows.Foundation.Collections.IIterator[win32more.Windows.Foundation.Collections.IKeyValuePair[WinRT_String, WinRT_String]]: ...
    @winrt_mixinmethod
    def ToString(self: win32more.Windows.Foundation.IStringable) -> WinRT_String: ...
    Accept = property(get_Accept, None)
    AcceptEncoding = property(get_AcceptEncoding, None)
    AcceptLanguage = property(get_AcceptLanguage, None)
    Authorization = property(get_Authorization, put_Authorization)
    CacheControl = property(get_CacheControl, None)
    Connection = property(get_Connection, None)
    Cookie = property(get_Cookie, None)
    Date = property(get_Date, put_Date)
    Expect = property(get_Expect, None)
    From = property(get_From, put_From)
    Host = property(get_Host, put_Host)
    IfModifiedSince = property(get_IfModifiedSince, put_IfModifiedSince)
    IfUnmodifiedSince = property(get_IfUnmodifiedSince, put_IfUnmodifiedSince)
    MaxForwards = property(get_MaxForwards, put_MaxForwards)
    ProxyAuthorization = property(get_ProxyAuthorization, put_ProxyAuthorization)
    Referer = property(get_Referer, put_Referer)
    Size = property(get_Size, None)
    TransferEncoding = property(get_TransferEncoding, None)
    UserAgent = property(get_UserAgent, None)
class HttpResponseHeaderCollection(ComPtr):
    extends: IInspectable
    implements: Tuple[MappingProtocol[WinRT_String, WinRT_String]]
    default_interface: win32more.Windows.Web.Http.Headers.IHttpResponseHeaderCollection
    _classid_ = 'Windows.Web.Http.Headers.HttpResponseHeaderCollection'
    @winrt_mixinmethod
    def get_Age(self: win32more.Windows.Web.Http.Headers.IHttpResponseHeaderCollection) -> win32more.Windows.Foundation.IReference[win32more.Windows.Foundation.TimeSpan]: ...
    @winrt_mixinmethod
    def put_Age(self: win32more.Windows.Web.Http.Headers.IHttpResponseHeaderCollection, value: win32more.Windows.Foundation.IReference[win32more.Windows.Foundation.TimeSpan]) -> Void: ...
    @winrt_mixinmethod
    def get_Allow(self: win32more.Windows.Web.Http.Headers.IHttpResponseHeaderCollection) -> win32more.Windows.Web.Http.Headers.HttpMethodHeaderValueCollection: ...
    @winrt_mixinmethod
    def get_CacheControl(self: win32more.Windows.Web.Http.Headers.IHttpResponseHeaderCollection) -> win32more.Windows.Web.Http.Headers.HttpCacheDirectiveHeaderValueCollection: ...
    @winrt_mixinmethod
    def get_Connection(self: win32more.Windows.Web.Http.Headers.IHttpResponseHeaderCollection) -> win32more.Windows.Web.Http.Headers.HttpConnectionOptionHeaderValueCollection: ...
    @winrt_mixinmethod
    def get_Date(self: win32more.Windows.Web.Http.Headers.IHttpResponseHeaderCollection) -> win32more.Windows.Foundation.IReference[win32more.Windows.Foundation.DateTime]: ...
    @winrt_mixinmethod
    def put_Date(self: win32more.Windows.Web.Http.Headers.IHttpResponseHeaderCollection, value: win32more.Windows.Foundation.IReference[win32more.Windows.Foundation.DateTime]) -> Void: ...
    @winrt_mixinmethod
    def get_Location(self: win32more.Windows.Web.Http.Headers.IHttpResponseHeaderCollection) -> win32more.Windows.Foundation.Uri: ...
    @winrt_mixinmethod
    def put_Location(self: win32more.Windows.Web.Http.Headers.IHttpResponseHeaderCollection, value: win32more.Windows.Foundation.Uri) -> Void: ...
    @winrt_mixinmethod
    def get_ProxyAuthenticate(self: win32more.Windows.Web.Http.Headers.IHttpResponseHeaderCollection) -> win32more.Windows.Web.Http.Headers.HttpChallengeHeaderValueCollection: ...
    @winrt_mixinmethod
    def get_RetryAfter(self: win32more.Windows.Web.Http.Headers.IHttpResponseHeaderCollection) -> win32more.Windows.Web.Http.Headers.HttpDateOrDeltaHeaderValue: ...
    @winrt_mixinmethod
    def put_RetryAfter(self: win32more.Windows.Web.Http.Headers.IHttpResponseHeaderCollection, value: win32more.Windows.Web.Http.Headers.HttpDateOrDeltaHeaderValue) -> Void: ...
    @winrt_mixinmethod
    def get_TransferEncoding(self: win32more.Windows.Web.Http.Headers.IHttpResponseHeaderCollection) -> win32more.Windows.Web.Http.Headers.HttpTransferCodingHeaderValueCollection: ...
    @winrt_mixinmethod
    def get_WwwAuthenticate(self: win32more.Windows.Web.Http.Headers.IHttpResponseHeaderCollection) -> win32more.Windows.Web.Http.Headers.HttpChallengeHeaderValueCollection: ...
    @winrt_mixinmethod
    def Append(self: win32more.Windows.Web.Http.Headers.IHttpResponseHeaderCollection, name: WinRT_String, value: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def TryAppendWithoutValidation(self: win32more.Windows.Web.Http.Headers.IHttpResponseHeaderCollection, name: WinRT_String, value: WinRT_String) -> Boolean: ...
    @winrt_mixinmethod
    def Lookup(self: win32more.Windows.Foundation.Collections.IMap[WinRT_String, WinRT_String], key: WinRT_String) -> WinRT_String: ...
    @winrt_mixinmethod
    def get_Size(self: win32more.Windows.Foundation.Collections.IMap[WinRT_String, WinRT_String]) -> UInt32: ...
    @winrt_mixinmethod
    def HasKey(self: win32more.Windows.Foundation.Collections.IMap[WinRT_String, WinRT_String], key: WinRT_String) -> Boolean: ...
    @winrt_mixinmethod
    def GetView(self: win32more.Windows.Foundation.Collections.IMap[WinRT_String, WinRT_String]) -> win32more.Windows.Foundation.Collections.IMapView[WinRT_String, WinRT_String]: ...
    @winrt_mixinmethod
    def Insert(self: win32more.Windows.Foundation.Collections.IMap[WinRT_String, WinRT_String], key: WinRT_String, value: WinRT_String) -> Boolean: ...
    @winrt_mixinmethod
    def Remove(self: win32more.Windows.Foundation.Collections.IMap[WinRT_String, WinRT_String], key: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def Clear(self: win32more.Windows.Foundation.Collections.IMap[WinRT_String, WinRT_String]) -> Void: ...
    @winrt_mixinmethod
    def First(self: win32more.Windows.Foundation.Collections.IIterable[win32more.Windows.Foundation.Collections.IKeyValuePair[WinRT_String, WinRT_String]]) -> win32more.Windows.Foundation.Collections.IIterator[win32more.Windows.Foundation.Collections.IKeyValuePair[WinRT_String, WinRT_String]]: ...
    @winrt_mixinmethod
    def ToString(self: win32more.Windows.Foundation.IStringable) -> WinRT_String: ...
    Age = property(get_Age, put_Age)
    Allow = property(get_Allow, None)
    CacheControl = property(get_CacheControl, None)
    Connection = property(get_Connection, None)
    Date = property(get_Date, put_Date)
    Location = property(get_Location, put_Location)
    ProxyAuthenticate = property(get_ProxyAuthenticate, None)
    RetryAfter = property(get_RetryAfter, put_RetryAfter)
    Size = property(get_Size, None)
    TransferEncoding = property(get_TransferEncoding, None)
    WwwAuthenticate = property(get_WwwAuthenticate, None)
class HttpTransferCodingHeaderValue(ComPtr):
    extends: IInspectable
    default_interface: win32more.Windows.Web.Http.Headers.IHttpTransferCodingHeaderValue
    _classid_ = 'Windows.Web.Http.Headers.HttpTransferCodingHeaderValue'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 1:
            super().__init__(move=win32more.Windows.Web.Http.Headers.HttpTransferCodingHeaderValue.Create(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_factorymethod
    def Create(cls: win32more.Windows.Web.Http.Headers.IHttpTransferCodingHeaderValueFactory, input: WinRT_String) -> win32more.Windows.Web.Http.Headers.HttpTransferCodingHeaderValue: ...
    @winrt_mixinmethod
    def get_Parameters(self: win32more.Windows.Web.Http.Headers.IHttpTransferCodingHeaderValue) -> win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.Headers.HttpNameValueHeaderValue]: ...
    @winrt_mixinmethod
    def get_Value(self: win32more.Windows.Web.Http.Headers.IHttpTransferCodingHeaderValue) -> WinRT_String: ...
    @winrt_mixinmethod
    def ToString(self: win32more.Windows.Foundation.IStringable) -> WinRT_String: ...
    @winrt_classmethod
    def Parse(cls: win32more.Windows.Web.Http.Headers.IHttpTransferCodingHeaderValueStatics, input: WinRT_String) -> win32more.Windows.Web.Http.Headers.HttpTransferCodingHeaderValue: ...
    @winrt_classmethod
    def TryParse(cls: win32more.Windows.Web.Http.Headers.IHttpTransferCodingHeaderValueStatics, input: WinRT_String, transferCodingHeaderValue: POINTER(win32more.Windows.Web.Http.Headers.HttpTransferCodingHeaderValue)) -> Boolean: ...
    Parameters = property(get_Parameters, None)
    Value = property(get_Value, None)
class HttpTransferCodingHeaderValueCollection(ComPtr):
    extends: IInspectable
    implements: Tuple[SequenceProtocol[win32more.Windows.Web.Http.Headers.HttpTransferCodingHeaderValue]]
    default_interface: win32more.Windows.Web.Http.Headers.IHttpTransferCodingHeaderValueCollection
    _classid_ = 'Windows.Web.Http.Headers.HttpTransferCodingHeaderValueCollection'
    @winrt_mixinmethod
    def ParseAdd(self: win32more.Windows.Web.Http.Headers.IHttpTransferCodingHeaderValueCollection, input: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def TryParseAdd(self: win32more.Windows.Web.Http.Headers.IHttpTransferCodingHeaderValueCollection, input: WinRT_String) -> Boolean: ...
    @winrt_mixinmethod
    def GetAt(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.Headers.HttpTransferCodingHeaderValue], index: UInt32) -> win32more.Windows.Web.Http.Headers.HttpTransferCodingHeaderValue: ...
    @winrt_mixinmethod
    def get_Size(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.Headers.HttpTransferCodingHeaderValue]) -> UInt32: ...
    @winrt_mixinmethod
    def GetView(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.Headers.HttpTransferCodingHeaderValue]) -> win32more.Windows.Foundation.Collections.IVectorView[win32more.Windows.Web.Http.Headers.HttpTransferCodingHeaderValue]: ...
    @winrt_mixinmethod
    def IndexOf(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.Headers.HttpTransferCodingHeaderValue], value: win32more.Windows.Web.Http.Headers.HttpTransferCodingHeaderValue, index: POINTER(UInt32)) -> Boolean: ...
    @winrt_mixinmethod
    def SetAt(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.Headers.HttpTransferCodingHeaderValue], index: UInt32, value: win32more.Windows.Web.Http.Headers.HttpTransferCodingHeaderValue) -> Void: ...
    @winrt_mixinmethod
    def InsertAt(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.Headers.HttpTransferCodingHeaderValue], index: UInt32, value: win32more.Windows.Web.Http.Headers.HttpTransferCodingHeaderValue) -> Void: ...
    @winrt_mixinmethod
    def RemoveAt(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.Headers.HttpTransferCodingHeaderValue], index: UInt32) -> Void: ...
    @winrt_mixinmethod
    def Append(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.Headers.HttpTransferCodingHeaderValue], value: win32more.Windows.Web.Http.Headers.HttpTransferCodingHeaderValue) -> Void: ...
    @winrt_mixinmethod
    def RemoveAtEnd(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.Headers.HttpTransferCodingHeaderValue]) -> Void: ...
    @winrt_mixinmethod
    def Clear(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.Headers.HttpTransferCodingHeaderValue]) -> Void: ...
    @winrt_mixinmethod
    def GetMany(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.Headers.HttpTransferCodingHeaderValue], startIndex: UInt32, items: FillArray[win32more.Windows.Web.Http.Headers.HttpTransferCodingHeaderValue]) -> UInt32: ...
    @winrt_mixinmethod
    def ReplaceAll(self: win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.Headers.HttpTransferCodingHeaderValue], items: PassArray[win32more.Windows.Web.Http.Headers.HttpTransferCodingHeaderValue]) -> Void: ...
    @winrt_mixinmethod
    def First(self: win32more.Windows.Foundation.Collections.IIterable[win32more.Windows.Web.Http.Headers.HttpTransferCodingHeaderValue]) -> win32more.Windows.Foundation.Collections.IIterator[win32more.Windows.Web.Http.Headers.HttpTransferCodingHeaderValue]: ...
    @winrt_mixinmethod
    def ToString(self: win32more.Windows.Foundation.IStringable) -> WinRT_String: ...
    Size = property(get_Size, None)
class IHttpCacheDirectiveHeaderValueCollection(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Web.Http.Headers.IHttpCacheDirectiveHeaderValueCollection'
    _iid_ = Guid('{9a586b89-d5d0-4fbe-bd9d-b5b3636811b4}')
    @winrt_commethod(6)
    def get_MaxAge(self) -> win32more.Windows.Foundation.IReference[win32more.Windows.Foundation.TimeSpan]: ...
    @winrt_commethod(7)
    def put_MaxAge(self, value: win32more.Windows.Foundation.IReference[win32more.Windows.Foundation.TimeSpan]) -> Void: ...
    @winrt_commethod(8)
    def get_MaxStale(self) -> win32more.Windows.Foundation.IReference[win32more.Windows.Foundation.TimeSpan]: ...
    @winrt_commethod(9)
    def put_MaxStale(self, value: win32more.Windows.Foundation.IReference[win32more.Windows.Foundation.TimeSpan]) -> Void: ...
    @winrt_commethod(10)
    def get_MinFresh(self) -> win32more.Windows.Foundation.IReference[win32more.Windows.Foundation.TimeSpan]: ...
    @winrt_commethod(11)
    def put_MinFresh(self, value: win32more.Windows.Foundation.IReference[win32more.Windows.Foundation.TimeSpan]) -> Void: ...
    @winrt_commethod(12)
    def get_SharedMaxAge(self) -> win32more.Windows.Foundation.IReference[win32more.Windows.Foundation.TimeSpan]: ...
    @winrt_commethod(13)
    def put_SharedMaxAge(self, value: win32more.Windows.Foundation.IReference[win32more.Windows.Foundation.TimeSpan]) -> Void: ...
    @winrt_commethod(14)
    def ParseAdd(self, input: WinRT_String) -> Void: ...
    @winrt_commethod(15)
    def TryParseAdd(self, input: WinRT_String) -> Boolean: ...
    MaxAge = property(get_MaxAge, put_MaxAge)
    MaxStale = property(get_MaxStale, put_MaxStale)
    MinFresh = property(get_MinFresh, put_MinFresh)
    SharedMaxAge = property(get_SharedMaxAge, put_SharedMaxAge)
class IHttpChallengeHeaderValue(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Web.Http.Headers.IHttpChallengeHeaderValue'
    _iid_ = Guid('{393361af-0f7d-4820-9fdd-a2b956eeaeab}')
    @winrt_commethod(6)
    def get_Parameters(self) -> win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.Headers.HttpNameValueHeaderValue]: ...
    @winrt_commethod(7)
    def get_Scheme(self) -> WinRT_String: ...
    @winrt_commethod(8)
    def get_Token(self) -> WinRT_String: ...
    Parameters = property(get_Parameters, None)
    Scheme = property(get_Scheme, None)
    Token = property(get_Token, None)
class IHttpChallengeHeaderValueCollection(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Web.Http.Headers.IHttpChallengeHeaderValueCollection'
    _iid_ = Guid('{ca9e5f81-aee0-4353-a10b-e625babd64c2}')
    @winrt_commethod(6)
    def ParseAdd(self, input: WinRT_String) -> Void: ...
    @winrt_commethod(7)
    def TryParseAdd(self, input: WinRT_String) -> Boolean: ...
class IHttpChallengeHeaderValueFactory(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Web.Http.Headers.IHttpChallengeHeaderValueFactory'
    _iid_ = Guid('{c452c451-d99c-40aa-9399-90eeb98fc613}')
    @winrt_commethod(6)
    def CreateFromScheme(self, scheme: WinRT_String) -> win32more.Windows.Web.Http.Headers.HttpChallengeHeaderValue: ...
    @winrt_commethod(7)
    def CreateFromSchemeWithToken(self, scheme: WinRT_String, token: WinRT_String) -> win32more.Windows.Web.Http.Headers.HttpChallengeHeaderValue: ...
class IHttpChallengeHeaderValueStatics(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Web.Http.Headers.IHttpChallengeHeaderValueStatics'
    _iid_ = Guid('{f3d38a72-fc01-4d01-a008-fcb7c459d635}')
    @winrt_commethod(6)
    def Parse(self, input: WinRT_String) -> win32more.Windows.Web.Http.Headers.HttpChallengeHeaderValue: ...
    @winrt_commethod(7)
    def TryParse(self, input: WinRT_String, challengeHeaderValue: POINTER(win32more.Windows.Web.Http.Headers.HttpChallengeHeaderValue)) -> Boolean: ...
class IHttpConnectionOptionHeaderValue(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Web.Http.Headers.IHttpConnectionOptionHeaderValue'
    _iid_ = Guid('{cb4af27a-4e90-45eb-8dcd-fd1408f4c44f}')
    @winrt_commethod(6)
    def get_Token(self) -> WinRT_String: ...
    Token = property(get_Token, None)
class IHttpConnectionOptionHeaderValueCollection(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Web.Http.Headers.IHttpConnectionOptionHeaderValueCollection'
    _iid_ = Guid('{e4f56c1d-5142-4e00-8e0f-019509337629}')
    @winrt_commethod(6)
    def ParseAdd(self, input: WinRT_String) -> Void: ...
    @winrt_commethod(7)
    def TryParseAdd(self, input: WinRT_String) -> Boolean: ...
class IHttpConnectionOptionHeaderValueFactory(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Web.Http.Headers.IHttpConnectionOptionHeaderValueFactory'
    _iid_ = Guid('{d93ccc1e-0b7d-4c3f-a58d-a2a1bdeabc0a}')
    @winrt_commethod(6)
    def Create(self, token: WinRT_String) -> win32more.Windows.Web.Http.Headers.HttpConnectionOptionHeaderValue: ...
class IHttpConnectionOptionHeaderValueStatics(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Web.Http.Headers.IHttpConnectionOptionHeaderValueStatics'
    _iid_ = Guid('{aaa75d37-a946-4b1f-85af-48b68b3c50bd}')
    @winrt_commethod(6)
    def Parse(self, input: WinRT_String) -> win32more.Windows.Web.Http.Headers.HttpConnectionOptionHeaderValue: ...
    @winrt_commethod(7)
    def TryParse(self, input: WinRT_String, connectionOptionHeaderValue: POINTER(win32more.Windows.Web.Http.Headers.HttpConnectionOptionHeaderValue)) -> Boolean: ...
class IHttpContentCodingHeaderValue(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Web.Http.Headers.IHttpContentCodingHeaderValue'
    _iid_ = Guid('{bcf7f92a-9376-4d85-bccc-9f4f9acab434}')
    @winrt_commethod(6)
    def get_ContentCoding(self) -> WinRT_String: ...
    ContentCoding = property(get_ContentCoding, None)
class IHttpContentCodingHeaderValueCollection(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Web.Http.Headers.IHttpContentCodingHeaderValueCollection'
    _iid_ = Guid('{7d221721-a6db-436e-8e83-91596192819c}')
    @winrt_commethod(6)
    def ParseAdd(self, input: WinRT_String) -> Void: ...
    @winrt_commethod(7)
    def TryParseAdd(self, input: WinRT_String) -> Boolean: ...
class IHttpContentCodingHeaderValueFactory(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Web.Http.Headers.IHttpContentCodingHeaderValueFactory'
    _iid_ = Guid('{c53d2bd7-332b-4350-8510-2e67a2289a5a}')
    @winrt_commethod(6)
    def Create(self, contentCoding: WinRT_String) -> win32more.Windows.Web.Http.Headers.HttpContentCodingHeaderValue: ...
class IHttpContentCodingHeaderValueStatics(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Web.Http.Headers.IHttpContentCodingHeaderValueStatics'
    _iid_ = Guid('{94d8602e-f9bf-42f7-aa46-ed272a41e212}')
    @winrt_commethod(6)
    def Parse(self, input: WinRT_String) -> win32more.Windows.Web.Http.Headers.HttpContentCodingHeaderValue: ...
    @winrt_commethod(7)
    def TryParse(self, input: WinRT_String, contentCodingHeaderValue: POINTER(win32more.Windows.Web.Http.Headers.HttpContentCodingHeaderValue)) -> Boolean: ...
class IHttpContentCodingWithQualityHeaderValue(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Web.Http.Headers.IHttpContentCodingWithQualityHeaderValue'
    _iid_ = Guid('{94531cd5-8b13-4d73-8651-f76b38f88495}')
    @winrt_commethod(6)
    def get_ContentCoding(self) -> WinRT_String: ...
    @winrt_commethod(7)
    def get_Quality(self) -> win32more.Windows.Foundation.IReference[Double]: ...
    ContentCoding = property(get_ContentCoding, None)
    Quality = property(get_Quality, None)
class IHttpContentCodingWithQualityHeaderValueCollection(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Web.Http.Headers.IHttpContentCodingWithQualityHeaderValueCollection'
    _iid_ = Guid('{7c0d753e-e899-4378-b5c8-412d820711cc}')
    @winrt_commethod(6)
    def ParseAdd(self, input: WinRT_String) -> Void: ...
    @winrt_commethod(7)
    def TryParseAdd(self, input: WinRT_String) -> Boolean: ...
class IHttpContentCodingWithQualityHeaderValueFactory(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Web.Http.Headers.IHttpContentCodingWithQualityHeaderValueFactory'
    _iid_ = Guid('{c45eee1a-c553-46fc-ade2-d75c1d53df7b}')
    @winrt_commethod(6)
    def CreateFromValue(self, contentCoding: WinRT_String) -> win32more.Windows.Web.Http.Headers.HttpContentCodingWithQualityHeaderValue: ...
    @winrt_commethod(7)
    def CreateFromValueWithQuality(self, contentCoding: WinRT_String, quality: Double) -> win32more.Windows.Web.Http.Headers.HttpContentCodingWithQualityHeaderValue: ...
class IHttpContentCodingWithQualityHeaderValueStatics(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Web.Http.Headers.IHttpContentCodingWithQualityHeaderValueStatics'
    _iid_ = Guid('{e8c9357c-8f89-4801-8e75-4c9abfc3de71}')
    @winrt_commethod(6)
    def Parse(self, input: WinRT_String) -> win32more.Windows.Web.Http.Headers.HttpContentCodingWithQualityHeaderValue: ...
    @winrt_commethod(7)
    def TryParse(self, input: WinRT_String, contentCodingWithQualityHeaderValue: POINTER(win32more.Windows.Web.Http.Headers.HttpContentCodingWithQualityHeaderValue)) -> Boolean: ...
class IHttpContentDispositionHeaderValue(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Web.Http.Headers.IHttpContentDispositionHeaderValue'
    _iid_ = Guid('{f2a2eedc-2629-4b49-9908-96a168e9365e}')
    @winrt_commethod(6)
    def get_DispositionType(self) -> WinRT_String: ...
    @winrt_commethod(7)
    def put_DispositionType(self, value: WinRT_String) -> Void: ...
    @winrt_commethod(8)
    def get_FileName(self) -> WinRT_String: ...
    @winrt_commethod(9)
    def put_FileName(self, value: WinRT_String) -> Void: ...
    @winrt_commethod(10)
    def get_FileNameStar(self) -> WinRT_String: ...
    @winrt_commethod(11)
    def put_FileNameStar(self, value: WinRT_String) -> Void: ...
    @winrt_commethod(12)
    def get_Name(self) -> WinRT_String: ...
    @winrt_commethod(13)
    def put_Name(self, value: WinRT_String) -> Void: ...
    @winrt_commethod(14)
    def get_Parameters(self) -> win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.Headers.HttpNameValueHeaderValue]: ...
    @winrt_commethod(15)
    def get_Size(self) -> win32more.Windows.Foundation.IReference[UInt64]: ...
    @winrt_commethod(16)
    def put_Size(self, value: win32more.Windows.Foundation.IReference[UInt64]) -> Void: ...
    DispositionType = property(get_DispositionType, put_DispositionType)
    FileName = property(get_FileName, put_FileName)
    FileNameStar = property(get_FileNameStar, put_FileNameStar)
    Name = property(get_Name, put_Name)
    Parameters = property(get_Parameters, None)
    Size = property(get_Size, put_Size)
class IHttpContentDispositionHeaderValueFactory(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Web.Http.Headers.IHttpContentDispositionHeaderValueFactory'
    _iid_ = Guid('{9915bbc4-456c-4e81-8295-b2ab3cbcf545}')
    @winrt_commethod(6)
    def Create(self, dispositionType: WinRT_String) -> win32more.Windows.Web.Http.Headers.HttpContentDispositionHeaderValue: ...
class IHttpContentDispositionHeaderValueStatics(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Web.Http.Headers.IHttpContentDispositionHeaderValueStatics'
    _iid_ = Guid('{29c56067-5a37-46e4-b074-c5177d69ca66}')
    @winrt_commethod(6)
    def Parse(self, input: WinRT_String) -> win32more.Windows.Web.Http.Headers.HttpContentDispositionHeaderValue: ...
    @winrt_commethod(7)
    def TryParse(self, input: WinRT_String, contentDispositionHeaderValue: POINTER(win32more.Windows.Web.Http.Headers.HttpContentDispositionHeaderValue)) -> Boolean: ...
class IHttpContentHeaderCollection(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Web.Http.Headers.IHttpContentHeaderCollection'
    _iid_ = Guid('{40612a44-47ae-4b7e-9124-69628b64aa18}')
    @winrt_commethod(6)
    def get_ContentDisposition(self) -> win32more.Windows.Web.Http.Headers.HttpContentDispositionHeaderValue: ...
    @winrt_commethod(7)
    def put_ContentDisposition(self, value: win32more.Windows.Web.Http.Headers.HttpContentDispositionHeaderValue) -> Void: ...
    @winrt_commethod(8)
    def get_ContentEncoding(self) -> win32more.Windows.Web.Http.Headers.HttpContentCodingHeaderValueCollection: ...
    @winrt_commethod(9)
    def get_ContentLanguage(self) -> win32more.Windows.Web.Http.Headers.HttpLanguageHeaderValueCollection: ...
    @winrt_commethod(10)
    def get_ContentLength(self) -> win32more.Windows.Foundation.IReference[UInt64]: ...
    @winrt_commethod(11)
    def put_ContentLength(self, value: win32more.Windows.Foundation.IReference[UInt64]) -> Void: ...
    @winrt_commethod(12)
    def get_ContentLocation(self) -> win32more.Windows.Foundation.Uri: ...
    @winrt_commethod(13)
    def put_ContentLocation(self, value: win32more.Windows.Foundation.Uri) -> Void: ...
    @winrt_commethod(14)
    def get_ContentMD5(self) -> win32more.Windows.Storage.Streams.IBuffer: ...
    @winrt_commethod(15)
    def put_ContentMD5(self, value: win32more.Windows.Storage.Streams.IBuffer) -> Void: ...
    @winrt_commethod(16)
    def get_ContentRange(self) -> win32more.Windows.Web.Http.Headers.HttpContentRangeHeaderValue: ...
    @winrt_commethod(17)
    def put_ContentRange(self, value: win32more.Windows.Web.Http.Headers.HttpContentRangeHeaderValue) -> Void: ...
    @winrt_commethod(18)
    def get_ContentType(self) -> win32more.Windows.Web.Http.Headers.HttpMediaTypeHeaderValue: ...
    @winrt_commethod(19)
    def put_ContentType(self, value: win32more.Windows.Web.Http.Headers.HttpMediaTypeHeaderValue) -> Void: ...
    @winrt_commethod(20)
    def get_Expires(self) -> win32more.Windows.Foundation.IReference[win32more.Windows.Foundation.DateTime]: ...
    @winrt_commethod(21)
    def put_Expires(self, value: win32more.Windows.Foundation.IReference[win32more.Windows.Foundation.DateTime]) -> Void: ...
    @winrt_commethod(22)
    def get_LastModified(self) -> win32more.Windows.Foundation.IReference[win32more.Windows.Foundation.DateTime]: ...
    @winrt_commethod(23)
    def put_LastModified(self, value: win32more.Windows.Foundation.IReference[win32more.Windows.Foundation.DateTime]) -> Void: ...
    @winrt_commethod(24)
    def Append(self, name: WinRT_String, value: WinRT_String) -> Void: ...
    @winrt_commethod(25)
    def TryAppendWithoutValidation(self, name: WinRT_String, value: WinRT_String) -> Boolean: ...
    ContentDisposition = property(get_ContentDisposition, put_ContentDisposition)
    ContentEncoding = property(get_ContentEncoding, None)
    ContentLanguage = property(get_ContentLanguage, None)
    ContentLength = property(get_ContentLength, put_ContentLength)
    ContentLocation = property(get_ContentLocation, put_ContentLocation)
    ContentMD5 = property(get_ContentMD5, put_ContentMD5)
    ContentRange = property(get_ContentRange, put_ContentRange)
    ContentType = property(get_ContentType, put_ContentType)
    Expires = property(get_Expires, put_Expires)
    LastModified = property(get_LastModified, put_LastModified)
class IHttpContentRangeHeaderValue(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Web.Http.Headers.IHttpContentRangeHeaderValue'
    _iid_ = Guid('{04d967d3-a4f6-495c-9530-8579fcba8aa9}')
    @winrt_commethod(6)
    def get_FirstBytePosition(self) -> win32more.Windows.Foundation.IReference[UInt64]: ...
    @winrt_commethod(7)
    def get_LastBytePosition(self) -> win32more.Windows.Foundation.IReference[UInt64]: ...
    @winrt_commethod(8)
    def get_Length(self) -> win32more.Windows.Foundation.IReference[UInt64]: ...
    @winrt_commethod(9)
    def get_Unit(self) -> WinRT_String: ...
    @winrt_commethod(10)
    def put_Unit(self, value: WinRT_String) -> Void: ...
    FirstBytePosition = property(get_FirstBytePosition, None)
    LastBytePosition = property(get_LastBytePosition, None)
    Length = property(get_Length, None)
    Unit = property(get_Unit, put_Unit)
class IHttpContentRangeHeaderValueFactory(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Web.Http.Headers.IHttpContentRangeHeaderValueFactory'
    _iid_ = Guid('{3f5bd691-a03c-4456-9a6f-ef27ecd03cae}')
    @winrt_commethod(6)
    def CreateFromLength(self, length: UInt64) -> win32more.Windows.Web.Http.Headers.HttpContentRangeHeaderValue: ...
    @winrt_commethod(7)
    def CreateFromRange(self, from_: UInt64, to: UInt64) -> win32more.Windows.Web.Http.Headers.HttpContentRangeHeaderValue: ...
    @winrt_commethod(8)
    def CreateFromRangeWithLength(self, from_: UInt64, to: UInt64, length: UInt64) -> win32more.Windows.Web.Http.Headers.HttpContentRangeHeaderValue: ...
class IHttpContentRangeHeaderValueStatics(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Web.Http.Headers.IHttpContentRangeHeaderValueStatics'
    _iid_ = Guid('{80a346ca-174c-4fae-821c-134cd294aa38}')
    @winrt_commethod(6)
    def Parse(self, input: WinRT_String) -> win32more.Windows.Web.Http.Headers.HttpContentRangeHeaderValue: ...
    @winrt_commethod(7)
    def TryParse(self, input: WinRT_String, contentRangeHeaderValue: POINTER(win32more.Windows.Web.Http.Headers.HttpContentRangeHeaderValue)) -> Boolean: ...
class IHttpCookiePairHeaderValue(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Web.Http.Headers.IHttpCookiePairHeaderValue'
    _iid_ = Guid('{cbd46217-4b29-412b-bd90-b3d814ab8e1b}')
    @winrt_commethod(6)
    def get_Name(self) -> WinRT_String: ...
    @winrt_commethod(7)
    def get_Value(self) -> WinRT_String: ...
    @winrt_commethod(8)
    def put_Value(self, value: WinRT_String) -> Void: ...
    Name = property(get_Name, None)
    Value = property(get_Value, put_Value)
class IHttpCookiePairHeaderValueCollection(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Web.Http.Headers.IHttpCookiePairHeaderValueCollection'
    _iid_ = Guid('{f3f44350-581e-4ecc-9f59-e507d04f06e6}')
    @winrt_commethod(6)
    def ParseAdd(self, input: WinRT_String) -> Void: ...
    @winrt_commethod(7)
    def TryParseAdd(self, input: WinRT_String) -> Boolean: ...
class IHttpCookiePairHeaderValueFactory(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Web.Http.Headers.IHttpCookiePairHeaderValueFactory'
    _iid_ = Guid('{635e326f-146f-4f56-aa21-2cb7d6d58b1e}')
    @winrt_commethod(6)
    def CreateFromName(self, name: WinRT_String) -> win32more.Windows.Web.Http.Headers.HttpCookiePairHeaderValue: ...
    @winrt_commethod(7)
    def CreateFromNameWithValue(self, name: WinRT_String, value: WinRT_String) -> win32more.Windows.Web.Http.Headers.HttpCookiePairHeaderValue: ...
class IHttpCookiePairHeaderValueStatics(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Web.Http.Headers.IHttpCookiePairHeaderValueStatics'
    _iid_ = Guid('{6e866d48-06af-4462-8158-99388d5dca81}')
    @winrt_commethod(6)
    def Parse(self, input: WinRT_String) -> win32more.Windows.Web.Http.Headers.HttpCookiePairHeaderValue: ...
    @winrt_commethod(7)
    def TryParse(self, input: WinRT_String, cookiePairHeaderValue: POINTER(win32more.Windows.Web.Http.Headers.HttpCookiePairHeaderValue)) -> Boolean: ...
class IHttpCredentialsHeaderValue(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Web.Http.Headers.IHttpCredentialsHeaderValue'
    _iid_ = Guid('{c34cc3cb-542e-4177-a6c7-b674ce193fbf}')
    @winrt_commethod(6)
    def get_Parameters(self) -> win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.Headers.HttpNameValueHeaderValue]: ...
    @winrt_commethod(7)
    def get_Scheme(self) -> WinRT_String: ...
    @winrt_commethod(8)
    def get_Token(self) -> WinRT_String: ...
    Parameters = property(get_Parameters, None)
    Scheme = property(get_Scheme, None)
    Token = property(get_Token, None)
class IHttpCredentialsHeaderValueFactory(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Web.Http.Headers.IHttpCredentialsHeaderValueFactory'
    _iid_ = Guid('{f21d9e91-4d1c-4182-bfd1-34470a62f950}')
    @winrt_commethod(6)
    def CreateFromScheme(self, scheme: WinRT_String) -> win32more.Windows.Web.Http.Headers.HttpCredentialsHeaderValue: ...
    @winrt_commethod(7)
    def CreateFromSchemeWithToken(self, scheme: WinRT_String, token: WinRT_String) -> win32more.Windows.Web.Http.Headers.HttpCredentialsHeaderValue: ...
class IHttpCredentialsHeaderValueStatics(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Web.Http.Headers.IHttpCredentialsHeaderValueStatics'
    _iid_ = Guid('{a69b2be6-ce8c-4443-a35a-1b727b131036}')
    @winrt_commethod(6)
    def Parse(self, input: WinRT_String) -> win32more.Windows.Web.Http.Headers.HttpCredentialsHeaderValue: ...
    @winrt_commethod(7)
    def TryParse(self, input: WinRT_String, credentialsHeaderValue: POINTER(win32more.Windows.Web.Http.Headers.HttpCredentialsHeaderValue)) -> Boolean: ...
class IHttpDateOrDeltaHeaderValue(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Web.Http.Headers.IHttpDateOrDeltaHeaderValue'
    _iid_ = Guid('{eafcaa6a-c4dc-49e2-a27d-043adf5867a3}')
    @winrt_commethod(6)
    def get_Date(self) -> win32more.Windows.Foundation.IReference[win32more.Windows.Foundation.DateTime]: ...
    @winrt_commethod(7)
    def get_Delta(self) -> win32more.Windows.Foundation.IReference[win32more.Windows.Foundation.TimeSpan]: ...
    Date = property(get_Date, None)
    Delta = property(get_Delta, None)
class IHttpDateOrDeltaHeaderValueStatics(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Web.Http.Headers.IHttpDateOrDeltaHeaderValueStatics'
    _iid_ = Guid('{7c2659a8-6672-4e90-9a9a-f39766f7f576}')
    @winrt_commethod(6)
    def Parse(self, input: WinRT_String) -> win32more.Windows.Web.Http.Headers.HttpDateOrDeltaHeaderValue: ...
    @winrt_commethod(7)
    def TryParse(self, input: WinRT_String, dateOrDeltaHeaderValue: POINTER(win32more.Windows.Web.Http.Headers.HttpDateOrDeltaHeaderValue)) -> Boolean: ...
class IHttpExpectationHeaderValue(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Web.Http.Headers.IHttpExpectationHeaderValue'
    _iid_ = Guid('{4ce585cd-3a99-43af-a2e6-ec232fea9658}')
    @winrt_commethod(6)
    def get_Name(self) -> WinRT_String: ...
    @winrt_commethod(7)
    def get_Value(self) -> WinRT_String: ...
    @winrt_commethod(8)
    def put_Value(self, value: WinRT_String) -> Void: ...
    @winrt_commethod(9)
    def get_Parameters(self) -> win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.Headers.HttpNameValueHeaderValue]: ...
    Name = property(get_Name, None)
    Parameters = property(get_Parameters, None)
    Value = property(get_Value, put_Value)
class IHttpExpectationHeaderValueCollection(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Web.Http.Headers.IHttpExpectationHeaderValueCollection'
    _iid_ = Guid('{e78521b3-a0e2-4ac4-9e66-79706cb9fd58}')
    @winrt_commethod(6)
    def ParseAdd(self, input: WinRT_String) -> Void: ...
    @winrt_commethod(7)
    def TryParseAdd(self, input: WinRT_String) -> Boolean: ...
class IHttpExpectationHeaderValueFactory(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Web.Http.Headers.IHttpExpectationHeaderValueFactory'
    _iid_ = Guid('{4ea275cb-d53e-4868-8856-1e21a5030dc0}')
    @winrt_commethod(6)
    def CreateFromName(self, name: WinRT_String) -> win32more.Windows.Web.Http.Headers.HttpExpectationHeaderValue: ...
    @winrt_commethod(7)
    def CreateFromNameWithValue(self, name: WinRT_String, value: WinRT_String) -> win32more.Windows.Web.Http.Headers.HttpExpectationHeaderValue: ...
class IHttpExpectationHeaderValueStatics(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Web.Http.Headers.IHttpExpectationHeaderValueStatics'
    _iid_ = Guid('{3019abe2-cfe5-473b-a57f-fba5b14eb257}')
    @winrt_commethod(6)
    def Parse(self, input: WinRT_String) -> win32more.Windows.Web.Http.Headers.HttpExpectationHeaderValue: ...
    @winrt_commethod(7)
    def TryParse(self, input: WinRT_String, expectationHeaderValue: POINTER(win32more.Windows.Web.Http.Headers.HttpExpectationHeaderValue)) -> Boolean: ...
class IHttpLanguageHeaderValueCollection(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Web.Http.Headers.IHttpLanguageHeaderValueCollection'
    _iid_ = Guid('{9ebd7ca3-8219-44f6-9902-8c56dfd3340c}')
    @winrt_commethod(6)
    def ParseAdd(self, input: WinRT_String) -> Void: ...
    @winrt_commethod(7)
    def TryParseAdd(self, input: WinRT_String) -> Boolean: ...
class IHttpLanguageRangeWithQualityHeaderValue(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Web.Http.Headers.IHttpLanguageRangeWithQualityHeaderValue'
    _iid_ = Guid('{7256e102-0080-4db4-a083-7de7b2e5ba4c}')
    @winrt_commethod(6)
    def get_LanguageRange(self) -> WinRT_String: ...
    @winrt_commethod(7)
    def get_Quality(self) -> win32more.Windows.Foundation.IReference[Double]: ...
    LanguageRange = property(get_LanguageRange, None)
    Quality = property(get_Quality, None)
class IHttpLanguageRangeWithQualityHeaderValueCollection(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Web.Http.Headers.IHttpLanguageRangeWithQualityHeaderValueCollection'
    _iid_ = Guid('{885d5abd-4b4f-480a-89ce-8aedcee6e3a0}')
    @winrt_commethod(6)
    def ParseAdd(self, input: WinRT_String) -> Void: ...
    @winrt_commethod(7)
    def TryParseAdd(self, input: WinRT_String) -> Boolean: ...
class IHttpLanguageRangeWithQualityHeaderValueFactory(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Web.Http.Headers.IHttpLanguageRangeWithQualityHeaderValueFactory'
    _iid_ = Guid('{7bb83970-780f-4c83-9fe4-dc3087f6bd55}')
    @winrt_commethod(6)
    def CreateFromLanguageRange(self, languageRange: WinRT_String) -> win32more.Windows.Web.Http.Headers.HttpLanguageRangeWithQualityHeaderValue: ...
    @winrt_commethod(7)
    def CreateFromLanguageRangeWithQuality(self, languageRange: WinRT_String, quality: Double) -> win32more.Windows.Web.Http.Headers.HttpLanguageRangeWithQualityHeaderValue: ...
class IHttpLanguageRangeWithQualityHeaderValueStatics(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Web.Http.Headers.IHttpLanguageRangeWithQualityHeaderValueStatics'
    _iid_ = Guid('{2541e146-f308-46f5-b695-42f54024ec68}')
    @winrt_commethod(6)
    def Parse(self, input: WinRT_String) -> win32more.Windows.Web.Http.Headers.HttpLanguageRangeWithQualityHeaderValue: ...
    @winrt_commethod(7)
    def TryParse(self, input: WinRT_String, languageRangeWithQualityHeaderValue: POINTER(win32more.Windows.Web.Http.Headers.HttpLanguageRangeWithQualityHeaderValue)) -> Boolean: ...
class IHttpMediaTypeHeaderValue(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Web.Http.Headers.IHttpMediaTypeHeaderValue'
    _iid_ = Guid('{16b28533-e728-4fcb-bdb0-08a431a14844}')
    @winrt_commethod(6)
    def get_CharSet(self) -> WinRT_String: ...
    @winrt_commethod(7)
    def put_CharSet(self, value: WinRT_String) -> Void: ...
    @winrt_commethod(8)
    def get_MediaType(self) -> WinRT_String: ...
    @winrt_commethod(9)
    def put_MediaType(self, value: WinRT_String) -> Void: ...
    @winrt_commethod(10)
    def get_Parameters(self) -> win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.Headers.HttpNameValueHeaderValue]: ...
    CharSet = property(get_CharSet, put_CharSet)
    MediaType = property(get_MediaType, put_MediaType)
    Parameters = property(get_Parameters, None)
class IHttpMediaTypeHeaderValueFactory(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Web.Http.Headers.IHttpMediaTypeHeaderValueFactory'
    _iid_ = Guid('{bed747a8-cd17-42dd-9367-ab9c5b56dd7d}')
    @winrt_commethod(6)
    def Create(self, mediaType: WinRT_String) -> win32more.Windows.Web.Http.Headers.HttpMediaTypeHeaderValue: ...
class IHttpMediaTypeHeaderValueStatics(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Web.Http.Headers.IHttpMediaTypeHeaderValueStatics'
    _iid_ = Guid('{e04d83df-1d41-4d8c-a2de-6fd2ed87399b}')
    @winrt_commethod(6)
    def Parse(self, input: WinRT_String) -> win32more.Windows.Web.Http.Headers.HttpMediaTypeHeaderValue: ...
    @winrt_commethod(7)
    def TryParse(self, input: WinRT_String, mediaTypeHeaderValue: POINTER(win32more.Windows.Web.Http.Headers.HttpMediaTypeHeaderValue)) -> Boolean: ...
class IHttpMediaTypeWithQualityHeaderValue(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Web.Http.Headers.IHttpMediaTypeWithQualityHeaderValue'
    _iid_ = Guid('{188d5e32-76be-44a0-b1cd-2074bded2dde}')
    @winrt_commethod(6)
    def get_CharSet(self) -> WinRT_String: ...
    @winrt_commethod(7)
    def put_CharSet(self, value: WinRT_String) -> Void: ...
    @winrt_commethod(8)
    def get_MediaType(self) -> WinRT_String: ...
    @winrt_commethod(9)
    def put_MediaType(self, value: WinRT_String) -> Void: ...
    @winrt_commethod(10)
    def get_Parameters(self) -> win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.Headers.HttpNameValueHeaderValue]: ...
    @winrt_commethod(11)
    def get_Quality(self) -> win32more.Windows.Foundation.IReference[Double]: ...
    @winrt_commethod(12)
    def put_Quality(self, value: win32more.Windows.Foundation.IReference[Double]) -> Void: ...
    CharSet = property(get_CharSet, put_CharSet)
    MediaType = property(get_MediaType, put_MediaType)
    Parameters = property(get_Parameters, None)
    Quality = property(get_Quality, put_Quality)
class IHttpMediaTypeWithQualityHeaderValueCollection(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Web.Http.Headers.IHttpMediaTypeWithQualityHeaderValueCollection'
    _iid_ = Guid('{3c0c6b73-1342-4587-a056-18d02ff67165}')
    @winrt_commethod(6)
    def ParseAdd(self, input: WinRT_String) -> Void: ...
    @winrt_commethod(7)
    def TryParseAdd(self, input: WinRT_String) -> Boolean: ...
class IHttpMediaTypeWithQualityHeaderValueFactory(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Web.Http.Headers.IHttpMediaTypeWithQualityHeaderValueFactory'
    _iid_ = Guid('{4c6d20f4-9457-44e6-a323-d122b958780b}')
    @winrt_commethod(6)
    def CreateFromMediaType(self, mediaType: WinRT_String) -> win32more.Windows.Web.Http.Headers.HttpMediaTypeWithQualityHeaderValue: ...
    @winrt_commethod(7)
    def CreateFromMediaTypeWithQuality(self, mediaType: WinRT_String, quality: Double) -> win32more.Windows.Web.Http.Headers.HttpMediaTypeWithQualityHeaderValue: ...
class IHttpMediaTypeWithQualityHeaderValueStatics(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Web.Http.Headers.IHttpMediaTypeWithQualityHeaderValueStatics'
    _iid_ = Guid('{5b070cd9-b560-4fc8-9835-7e6c0a657b24}')
    @winrt_commethod(6)
    def Parse(self, input: WinRT_String) -> win32more.Windows.Web.Http.Headers.HttpMediaTypeWithQualityHeaderValue: ...
    @winrt_commethod(7)
    def TryParse(self, input: WinRT_String, mediaTypeWithQualityHeaderValue: POINTER(win32more.Windows.Web.Http.Headers.HttpMediaTypeWithQualityHeaderValue)) -> Boolean: ...
class IHttpMethodHeaderValueCollection(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Web.Http.Headers.IHttpMethodHeaderValueCollection'
    _iid_ = Guid('{43bc3ff4-6119-4adf-938c-34bfffcf92ed}')
    @winrt_commethod(6)
    def ParseAdd(self, input: WinRT_String) -> Void: ...
    @winrt_commethod(7)
    def TryParseAdd(self, input: WinRT_String) -> Boolean: ...
class IHttpNameValueHeaderValue(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Web.Http.Headers.IHttpNameValueHeaderValue'
    _iid_ = Guid('{d8ba7463-5b9a-4d1b-93f9-aa5b44ecfddf}')
    @winrt_commethod(6)
    def get_Name(self) -> WinRT_String: ...
    @winrt_commethod(7)
    def get_Value(self) -> WinRT_String: ...
    @winrt_commethod(8)
    def put_Value(self, value: WinRT_String) -> Void: ...
    Name = property(get_Name, None)
    Value = property(get_Value, put_Value)
class IHttpNameValueHeaderValueFactory(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Web.Http.Headers.IHttpNameValueHeaderValueFactory'
    _iid_ = Guid('{770e2267-cbf8-4736-a925-93fbe10c7ca8}')
    @winrt_commethod(6)
    def CreateFromName(self, name: WinRT_String) -> win32more.Windows.Web.Http.Headers.HttpNameValueHeaderValue: ...
    @winrt_commethod(7)
    def CreateFromNameWithValue(self, name: WinRT_String, value: WinRT_String) -> win32more.Windows.Web.Http.Headers.HttpNameValueHeaderValue: ...
class IHttpNameValueHeaderValueStatics(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Web.Http.Headers.IHttpNameValueHeaderValueStatics'
    _iid_ = Guid('{ffd4030f-1130-4152-8659-256909a9d115}')
    @winrt_commethod(6)
    def Parse(self, input: WinRT_String) -> win32more.Windows.Web.Http.Headers.HttpNameValueHeaderValue: ...
    @winrt_commethod(7)
    def TryParse(self, input: WinRT_String, nameValueHeaderValue: POINTER(win32more.Windows.Web.Http.Headers.HttpNameValueHeaderValue)) -> Boolean: ...
class IHttpProductHeaderValue(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Web.Http.Headers.IHttpProductHeaderValue'
    _iid_ = Guid('{f4feee03-ebd4-4160-b9ff-807c5183b6e6}')
    @winrt_commethod(6)
    def get_Name(self) -> WinRT_String: ...
    @winrt_commethod(7)
    def get_Version(self) -> WinRT_String: ...
    Name = property(get_Name, None)
    Version = property(get_Version, None)
class IHttpProductHeaderValueFactory(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Web.Http.Headers.IHttpProductHeaderValueFactory'
    _iid_ = Guid('{611aa4f5-82bc-42fb-977b-dc00536e5e86}')
    @winrt_commethod(6)
    def CreateFromName(self, productName: WinRT_String) -> win32more.Windows.Web.Http.Headers.HttpProductHeaderValue: ...
    @winrt_commethod(7)
    def CreateFromNameWithVersion(self, productName: WinRT_String, productVersion: WinRT_String) -> win32more.Windows.Web.Http.Headers.HttpProductHeaderValue: ...
class IHttpProductHeaderValueStatics(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Web.Http.Headers.IHttpProductHeaderValueStatics'
    _iid_ = Guid('{90c33e29-befc-4337-be62-49f097975f53}')
    @winrt_commethod(6)
    def Parse(self, input: WinRT_String) -> win32more.Windows.Web.Http.Headers.HttpProductHeaderValue: ...
    @winrt_commethod(7)
    def TryParse(self, input: WinRT_String, productHeaderValue: POINTER(win32more.Windows.Web.Http.Headers.HttpProductHeaderValue)) -> Boolean: ...
class IHttpProductInfoHeaderValue(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Web.Http.Headers.IHttpProductInfoHeaderValue'
    _iid_ = Guid('{1b1a8732-4c35-486a-966f-646489198e4d}')
    @winrt_commethod(6)
    def get_Product(self) -> win32more.Windows.Web.Http.Headers.HttpProductHeaderValue: ...
    @winrt_commethod(7)
    def get_Comment(self) -> WinRT_String: ...
    Comment = property(get_Comment, None)
    Product = property(get_Product, None)
class IHttpProductInfoHeaderValueCollection(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Web.Http.Headers.IHttpProductInfoHeaderValueCollection'
    _iid_ = Guid('{877df74a-d69b-44f8-ad4f-453af9c42ed0}')
    @winrt_commethod(6)
    def ParseAdd(self, input: WinRT_String) -> Void: ...
    @winrt_commethod(7)
    def TryParseAdd(self, input: WinRT_String) -> Boolean: ...
class IHttpProductInfoHeaderValueFactory(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Web.Http.Headers.IHttpProductInfoHeaderValueFactory'
    _iid_ = Guid('{24220fbe-eabe-4464-b460-ec010b7c41e2}')
    @winrt_commethod(6)
    def CreateFromComment(self, productComment: WinRT_String) -> win32more.Windows.Web.Http.Headers.HttpProductInfoHeaderValue: ...
    @winrt_commethod(7)
    def CreateFromNameWithVersion(self, productName: WinRT_String, productVersion: WinRT_String) -> win32more.Windows.Web.Http.Headers.HttpProductInfoHeaderValue: ...
class IHttpProductInfoHeaderValueStatics(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Web.Http.Headers.IHttpProductInfoHeaderValueStatics'
    _iid_ = Guid('{db7fd857-327a-4e73-81e5-7059a302b042}')
    @winrt_commethod(6)
    def Parse(self, input: WinRT_String) -> win32more.Windows.Web.Http.Headers.HttpProductInfoHeaderValue: ...
    @winrt_commethod(7)
    def TryParse(self, input: WinRT_String, productInfoHeaderValue: POINTER(win32more.Windows.Web.Http.Headers.HttpProductInfoHeaderValue)) -> Boolean: ...
class IHttpRequestHeaderCollection(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Web.Http.Headers.IHttpRequestHeaderCollection'
    _iid_ = Guid('{af40329b-b544-469b-86b9-ac3d466fea36}')
    @winrt_commethod(6)
    def get_Accept(self) -> win32more.Windows.Web.Http.Headers.HttpMediaTypeWithQualityHeaderValueCollection: ...
    @winrt_commethod(7)
    def get_AcceptEncoding(self) -> win32more.Windows.Web.Http.Headers.HttpContentCodingWithQualityHeaderValueCollection: ...
    @winrt_commethod(8)
    def get_AcceptLanguage(self) -> win32more.Windows.Web.Http.Headers.HttpLanguageRangeWithQualityHeaderValueCollection: ...
    @winrt_commethod(9)
    def get_Authorization(self) -> win32more.Windows.Web.Http.Headers.HttpCredentialsHeaderValue: ...
    @winrt_commethod(10)
    def put_Authorization(self, value: win32more.Windows.Web.Http.Headers.HttpCredentialsHeaderValue) -> Void: ...
    @winrt_commethod(11)
    def get_CacheControl(self) -> win32more.Windows.Web.Http.Headers.HttpCacheDirectiveHeaderValueCollection: ...
    @winrt_commethod(12)
    def get_Connection(self) -> win32more.Windows.Web.Http.Headers.HttpConnectionOptionHeaderValueCollection: ...
    @winrt_commethod(13)
    def get_Cookie(self) -> win32more.Windows.Web.Http.Headers.HttpCookiePairHeaderValueCollection: ...
    @winrt_commethod(14)
    def get_Date(self) -> win32more.Windows.Foundation.IReference[win32more.Windows.Foundation.DateTime]: ...
    @winrt_commethod(15)
    def put_Date(self, value: win32more.Windows.Foundation.IReference[win32more.Windows.Foundation.DateTime]) -> Void: ...
    @winrt_commethod(16)
    def get_Expect(self) -> win32more.Windows.Web.Http.Headers.HttpExpectationHeaderValueCollection: ...
    @winrt_commethod(17)
    def get_From(self) -> WinRT_String: ...
    @winrt_commethod(18)
    def put_From(self, value: WinRT_String) -> Void: ...
    @winrt_commethod(19)
    def get_Host(self) -> win32more.Windows.Networking.HostName: ...
    @winrt_commethod(20)
    def put_Host(self, value: win32more.Windows.Networking.HostName) -> Void: ...
    @winrt_commethod(21)
    def get_IfModifiedSince(self) -> win32more.Windows.Foundation.IReference[win32more.Windows.Foundation.DateTime]: ...
    @winrt_commethod(22)
    def put_IfModifiedSince(self, value: win32more.Windows.Foundation.IReference[win32more.Windows.Foundation.DateTime]) -> Void: ...
    @winrt_commethod(23)
    def get_IfUnmodifiedSince(self) -> win32more.Windows.Foundation.IReference[win32more.Windows.Foundation.DateTime]: ...
    @winrt_commethod(24)
    def put_IfUnmodifiedSince(self, value: win32more.Windows.Foundation.IReference[win32more.Windows.Foundation.DateTime]) -> Void: ...
    @winrt_commethod(25)
    def get_MaxForwards(self) -> win32more.Windows.Foundation.IReference[UInt32]: ...
    @winrt_commethod(26)
    def put_MaxForwards(self, value: win32more.Windows.Foundation.IReference[UInt32]) -> Void: ...
    @winrt_commethod(27)
    def get_ProxyAuthorization(self) -> win32more.Windows.Web.Http.Headers.HttpCredentialsHeaderValue: ...
    @winrt_commethod(28)
    def put_ProxyAuthorization(self, value: win32more.Windows.Web.Http.Headers.HttpCredentialsHeaderValue) -> Void: ...
    @winrt_commethod(29)
    def get_Referer(self) -> win32more.Windows.Foundation.Uri: ...
    @winrt_commethod(30)
    def put_Referer(self, value: win32more.Windows.Foundation.Uri) -> Void: ...
    @winrt_commethod(31)
    def get_TransferEncoding(self) -> win32more.Windows.Web.Http.Headers.HttpTransferCodingHeaderValueCollection: ...
    @winrt_commethod(32)
    def get_UserAgent(self) -> win32more.Windows.Web.Http.Headers.HttpProductInfoHeaderValueCollection: ...
    @winrt_commethod(33)
    def Append(self, name: WinRT_String, value: WinRT_String) -> Void: ...
    @winrt_commethod(34)
    def TryAppendWithoutValidation(self, name: WinRT_String, value: WinRT_String) -> Boolean: ...
    Accept = property(get_Accept, None)
    AcceptEncoding = property(get_AcceptEncoding, None)
    AcceptLanguage = property(get_AcceptLanguage, None)
    Authorization = property(get_Authorization, put_Authorization)
    CacheControl = property(get_CacheControl, None)
    Connection = property(get_Connection, None)
    Cookie = property(get_Cookie, None)
    Date = property(get_Date, put_Date)
    Expect = property(get_Expect, None)
    From = property(get_From, put_From)
    Host = property(get_Host, put_Host)
    IfModifiedSince = property(get_IfModifiedSince, put_IfModifiedSince)
    IfUnmodifiedSince = property(get_IfUnmodifiedSince, put_IfUnmodifiedSince)
    MaxForwards = property(get_MaxForwards, put_MaxForwards)
    ProxyAuthorization = property(get_ProxyAuthorization, put_ProxyAuthorization)
    Referer = property(get_Referer, put_Referer)
    TransferEncoding = property(get_TransferEncoding, None)
    UserAgent = property(get_UserAgent, None)
class IHttpResponseHeaderCollection(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Web.Http.Headers.IHttpResponseHeaderCollection'
    _iid_ = Guid('{7a990969-fa3f-41ed-aac6-bf957975c16b}')
    @winrt_commethod(6)
    def get_Age(self) -> win32more.Windows.Foundation.IReference[win32more.Windows.Foundation.TimeSpan]: ...
    @winrt_commethod(7)
    def put_Age(self, value: win32more.Windows.Foundation.IReference[win32more.Windows.Foundation.TimeSpan]) -> Void: ...
    @winrt_commethod(8)
    def get_Allow(self) -> win32more.Windows.Web.Http.Headers.HttpMethodHeaderValueCollection: ...
    @winrt_commethod(9)
    def get_CacheControl(self) -> win32more.Windows.Web.Http.Headers.HttpCacheDirectiveHeaderValueCollection: ...
    @winrt_commethod(10)
    def get_Connection(self) -> win32more.Windows.Web.Http.Headers.HttpConnectionOptionHeaderValueCollection: ...
    @winrt_commethod(11)
    def get_Date(self) -> win32more.Windows.Foundation.IReference[win32more.Windows.Foundation.DateTime]: ...
    @winrt_commethod(12)
    def put_Date(self, value: win32more.Windows.Foundation.IReference[win32more.Windows.Foundation.DateTime]) -> Void: ...
    @winrt_commethod(13)
    def get_Location(self) -> win32more.Windows.Foundation.Uri: ...
    @winrt_commethod(14)
    def put_Location(self, value: win32more.Windows.Foundation.Uri) -> Void: ...
    @winrt_commethod(15)
    def get_ProxyAuthenticate(self) -> win32more.Windows.Web.Http.Headers.HttpChallengeHeaderValueCollection: ...
    @winrt_commethod(16)
    def get_RetryAfter(self) -> win32more.Windows.Web.Http.Headers.HttpDateOrDeltaHeaderValue: ...
    @winrt_commethod(17)
    def put_RetryAfter(self, value: win32more.Windows.Web.Http.Headers.HttpDateOrDeltaHeaderValue) -> Void: ...
    @winrt_commethod(18)
    def get_TransferEncoding(self) -> win32more.Windows.Web.Http.Headers.HttpTransferCodingHeaderValueCollection: ...
    @winrt_commethod(19)
    def get_WwwAuthenticate(self) -> win32more.Windows.Web.Http.Headers.HttpChallengeHeaderValueCollection: ...
    @winrt_commethod(20)
    def Append(self, name: WinRT_String, value: WinRT_String) -> Void: ...
    @winrt_commethod(21)
    def TryAppendWithoutValidation(self, name: WinRT_String, value: WinRT_String) -> Boolean: ...
    Age = property(get_Age, put_Age)
    Allow = property(get_Allow, None)
    CacheControl = property(get_CacheControl, None)
    Connection = property(get_Connection, None)
    Date = property(get_Date, put_Date)
    Location = property(get_Location, put_Location)
    ProxyAuthenticate = property(get_ProxyAuthenticate, None)
    RetryAfter = property(get_RetryAfter, put_RetryAfter)
    TransferEncoding = property(get_TransferEncoding, None)
    WwwAuthenticate = property(get_WwwAuthenticate, None)
class IHttpTransferCodingHeaderValue(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Web.Http.Headers.IHttpTransferCodingHeaderValue'
    _iid_ = Guid('{436f32f9-3ded-42bd-b38a-5496a2511ce6}')
    @winrt_commethod(6)
    def get_Parameters(self) -> win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Http.Headers.HttpNameValueHeaderValue]: ...
    @winrt_commethod(7)
    def get_Value(self) -> WinRT_String: ...
    Parameters = property(get_Parameters, None)
    Value = property(get_Value, None)
class IHttpTransferCodingHeaderValueCollection(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Web.Http.Headers.IHttpTransferCodingHeaderValueCollection'
    _iid_ = Guid('{202c8c34-2c03-49b8-9665-73e27cb2fc79}')
    @winrt_commethod(6)
    def ParseAdd(self, input: WinRT_String) -> Void: ...
    @winrt_commethod(7)
    def TryParseAdd(self, input: WinRT_String) -> Boolean: ...
class IHttpTransferCodingHeaderValueFactory(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Web.Http.Headers.IHttpTransferCodingHeaderValueFactory'
    _iid_ = Guid('{bb62dffc-e361-4f08-8e4f-c9e723de703b}')
    @winrt_commethod(6)
    def Create(self, input: WinRT_String) -> win32more.Windows.Web.Http.Headers.HttpTransferCodingHeaderValue: ...
class IHttpTransferCodingHeaderValueStatics(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Web.Http.Headers.IHttpTransferCodingHeaderValueStatics'
    _iid_ = Guid('{6ab8892a-1a98-4d32-a906-7470a9875ce5}')
    @winrt_commethod(6)
    def Parse(self, input: WinRT_String) -> win32more.Windows.Web.Http.Headers.HttpTransferCodingHeaderValue: ...
    @winrt_commethod(7)
    def TryParse(self, input: WinRT_String, transferCodingHeaderValue: POINTER(win32more.Windows.Web.Http.Headers.HttpTransferCodingHeaderValue)) -> Boolean: ...


make_ready(__name__)
