from __future__ import annotations
from win32more.win32.prelude import *
import win32more.Windows.Win32.Devices.Display
import win32more.Windows.Win32.Foundation
import win32more.Windows.Win32.Graphics.Direct3D9
import win32more.Windows.Win32.Graphics.DirectDraw
import win32more.Windows.Win32.Graphics.Gdi
import win32more.Windows.Win32.Graphics.OpenGL
import win32more.Windows.Win32.System.Com
import win32more.Windows.Win32.System.Console
import win32more.Windows.Win32.UI.ColorSystem
AR_STATE = Int32
AR_ENABLED: win32more.Windows.Win32.Devices.Display.AR_STATE = 0
AR_DISABLED: win32more.Windows.Win32.Devices.Display.AR_STATE = 1
AR_SUPPRESSED: win32more.Windows.Win32.Devices.Display.AR_STATE = 2
AR_REMOTESESSION: win32more.Windows.Win32.Devices.Display.AR_STATE = 4
AR_MULTIMON: win32more.Windows.Win32.Devices.Display.AR_STATE = 8
AR_NOSENSOR: win32more.Windows.Win32.Devices.Display.AR_STATE = 16
AR_NOT_SUPPORTED: win32more.Windows.Win32.Devices.Display.AR_STATE = 32
AR_DOCKED: win32more.Windows.Win32.Devices.Display.AR_STATE = 64
AR_LAPTOP: win32more.Windows.Win32.Devices.Display.AR_STATE = 128
class Adapter(Structure):
    AdapterName: Char * 128
    numSources: Int32
    sources: FlexibleArray[win32more.Windows.Win32.Devices.Display.Sources]
class Adapters(Structure):
    numAdapters: Int32
    adapter: FlexibleArray[win32more.Windows.Win32.Devices.Display.Adapter]
GUID_DEVINTERFACE_DISPLAY_ADAPTER: Guid = Guid('{5b45201d-f2f2-4f3b-85bb-30ff1f953599}')
GUID_DEVINTERFACE_MONITOR: Guid = Guid('{e6f07b5f-ee97-4a90-b076-33f57bf4eaa7}')
GUID_DISPLAY_DEVICE_ARRIVAL: Guid = Guid('{1ca05180-a699-450a-9a0c-de4fbe3ddd89}')
GUID_DEVINTERFACE_VIDEO_OUTPUT_ARRIVAL: Guid = Guid('{1ad9e4f0-f88d-4360-bab9-4c2d55e564cd}')
DEVPKEY_IndirectDisplay: win32more.Windows.Win32.Foundation.DEVPROPKEY = ConstantLazyLoader(fmtid=Guid('{c50a3f10-aa5c-4247-b830-d6a6f8eaa310}'), pid=1)
DEVPKEY_Device_TerminalLuid: win32more.Windows.Win32.Foundation.DEVPROPKEY = ConstantLazyLoader(fmtid=Guid('{c50a3f10-aa5c-4247-b830-d6a6f8eaa310}'), pid=2)
DEVPKEY_Device_AdapterLuid: win32more.Windows.Win32.Foundation.DEVPROPKEY = ConstantLazyLoader(fmtid=Guid('{c50a3f10-aa5c-4247-b830-d6a6f8eaa310}'), pid=3)
DEVPKEY_Device_ActivityId: win32more.Windows.Win32.Foundation.DEVPROPKEY = ConstantLazyLoader(fmtid=Guid('{c50a3f10-aa5c-4247-b830-d6a6f8eaa310}'), pid=4)
INDIRECT_DISPLAY_INFO_FLAGS_CREATED_IDDCX_ADAPTER: UInt32 = 1
VIDEO_DEVICE_NAME: String = 'DISPLAY%d'
WVIDEO_DEVICE_NAME: String = 'DISPLAY%d'
IOCTL_VIDEO_DISABLE_VDM: UInt32 = 2293764
IOCTL_VIDEO_REGISTER_VDM: UInt32 = 2293768
IOCTL_VIDEO_SET_OUTPUT_DEVICE_POWER_STATE: UInt32 = 2293772
IOCTL_VIDEO_GET_OUTPUT_DEVICE_POWER_STATE: UInt32 = 2293776
IOCTL_VIDEO_MONITOR_DEVICE: UInt32 = 2293780
IOCTL_VIDEO_ENUM_MONITOR_PDO: UInt32 = 2293784
IOCTL_VIDEO_INIT_WIN32K_CALLBACKS: UInt32 = 2293788
IOCTL_VIDEO_IS_VGA_DEVICE: UInt32 = 2293796
IOCTL_VIDEO_USE_DEVICE_IN_SESSION: UInt32 = 2293800
IOCTL_VIDEO_PREPARE_FOR_EARECOVERY: UInt32 = 2293804
IOCTL_VIDEO_ENABLE_VDM: UInt32 = 2293760
IOCTL_VIDEO_SAVE_HARDWARE_STATE: UInt32 = 2294272
IOCTL_VIDEO_RESTORE_HARDWARE_STATE: UInt32 = 2294276
IOCTL_VIDEO_HANDLE_VIDEOPARAMETERS: UInt32 = 2293792
IOCTL_VIDEO_QUERY_AVAIL_MODES: UInt32 = 2294784
IOCTL_VIDEO_QUERY_NUM_AVAIL_MODES: UInt32 = 2294788
IOCTL_VIDEO_QUERY_CURRENT_MODE: UInt32 = 2294792
IOCTL_VIDEO_SET_CURRENT_MODE: UInt32 = 2294796
IOCTL_VIDEO_RESET_DEVICE: UInt32 = 2294800
IOCTL_VIDEO_LOAD_AND_SET_FONT: UInt32 = 2294804
IOCTL_VIDEO_SET_PALETTE_REGISTERS: UInt32 = 2294808
IOCTL_VIDEO_SET_COLOR_REGISTERS: UInt32 = 2294812
IOCTL_VIDEO_ENABLE_CURSOR: UInt32 = 2294816
IOCTL_VIDEO_DISABLE_CURSOR: UInt32 = 2294820
IOCTL_VIDEO_SET_CURSOR_ATTR: UInt32 = 2294824
IOCTL_VIDEO_QUERY_CURSOR_ATTR: UInt32 = 2294828
IOCTL_VIDEO_SET_CURSOR_POSITION: UInt32 = 2294832
IOCTL_VIDEO_QUERY_CURSOR_POSITION: UInt32 = 2294836
IOCTL_VIDEO_ENABLE_POINTER: UInt32 = 2294840
IOCTL_VIDEO_DISABLE_POINTER: UInt32 = 2294844
IOCTL_VIDEO_SET_POINTER_ATTR: UInt32 = 2294848
IOCTL_VIDEO_QUERY_POINTER_ATTR: UInt32 = 2294852
IOCTL_VIDEO_SET_POINTER_POSITION: UInt32 = 2294856
IOCTL_VIDEO_QUERY_POINTER_POSITION: UInt32 = 2294860
IOCTL_VIDEO_QUERY_POINTER_CAPABILITIES: UInt32 = 2294864
IOCTL_VIDEO_GET_BANK_SELECT_CODE: UInt32 = 2294868
IOCTL_VIDEO_MAP_VIDEO_MEMORY: UInt32 = 2294872
IOCTL_VIDEO_UNMAP_VIDEO_MEMORY: UInt32 = 2294876
IOCTL_VIDEO_QUERY_PUBLIC_ACCESS_RANGES: UInt32 = 2294880
IOCTL_VIDEO_FREE_PUBLIC_ACCESS_RANGES: UInt32 = 2294884
IOCTL_VIDEO_QUERY_COLOR_CAPABILITIES: UInt32 = 2294888
IOCTL_VIDEO_SET_POWER_MANAGEMENT: UInt32 = 2294892
IOCTL_VIDEO_GET_POWER_MANAGEMENT: UInt32 = 2294896
IOCTL_VIDEO_SHARE_VIDEO_MEMORY: UInt32 = 2294900
IOCTL_VIDEO_UNSHARE_VIDEO_MEMORY: UInt32 = 2294904
IOCTL_VIDEO_SET_COLOR_LUT_DATA: UInt32 = 2294908
IOCTL_VIDEO_GET_CHILD_STATE: UInt32 = 2294912
IOCTL_VIDEO_VALIDATE_CHILD_STATE_CONFIGURATION: UInt32 = 2294916
IOCTL_VIDEO_SET_CHILD_STATE_CONFIGURATION: UInt32 = 2294920
IOCTL_VIDEO_SWITCH_DUALVIEW: UInt32 = 2294924
IOCTL_VIDEO_SET_BANK_POSITION: UInt32 = 2294928
IOCTL_VIDEO_QUERY_SUPPORTED_BRIGHTNESS: UInt32 = 2294932
IOCTL_VIDEO_QUERY_DISPLAY_BRIGHTNESS: UInt32 = 2294936
IOCTL_VIDEO_SET_DISPLAY_BRIGHTNESS: UInt32 = 2294940
IOCTL_FSVIDEO_COPY_FRAME_BUFFER: UInt32 = 3409920
IOCTL_FSVIDEO_WRITE_TO_FRAME_BUFFER: UInt32 = 3409924
IOCTL_FSVIDEO_REVERSE_MOUSE_POINTER: UInt32 = 3409928
IOCTL_FSVIDEO_SET_CURRENT_MODE: UInt32 = 3409932
IOCTL_FSVIDEO_SET_SCREEN_INFORMATION: UInt32 = 3409936
IOCTL_FSVIDEO_SET_CURSOR_POSITION: UInt32 = 3409940
IOCTL_PANEL_QUERY_BRIGHTNESS_CAPS: UInt32 = 2296832
IOCTL_PANEL_QUERY_BRIGHTNESS_RANGES: UInt32 = 2296836
IOCTL_PANEL_GET_BRIGHTNESS: UInt32 = 2296840
IOCTL_PANEL_SET_BRIGHTNESS: UInt32 = 2296844
IOCTL_PANEL_SET_BRIGHTNESS_STATE: UInt32 = 2296848
IOCTL_PANEL_SET_BACKLIGHT_OPTIMIZATION: UInt32 = 2296852
IOCTL_PANEL_GET_BACKLIGHT_REDUCTION: UInt32 = 2296856
IOCTL_PANEL_GET_MANUFACTURING_MODE: UInt32 = 2296860
IOCTL_COLORSPACE_TRANSFORM_QUERY_TARGET_CAPS: UInt32 = 2297856
IOCTL_COLORSPACE_TRANSFORM_SET: UInt32 = 2297860
IOCTL_SET_ACTIVE_COLOR_PROFILE_NAME: UInt32 = 2297864
IOCTL_MIPI_DSI_QUERY_CAPS: UInt32 = 2298880
IOCTL_MIPI_DSI_TRANSMISSION: UInt32 = 2298884
IOCTL_MIPI_DSI_RESET: UInt32 = 2298888
DXGK_WIN32K_PARAM_FLAG_UPDATEREGISTRY: UInt32 = 1
DXGK_WIN32K_PARAM_FLAG_MODESWITCH: UInt32 = 2
DXGK_WIN32K_PARAM_FLAG_DISABLEVIEW: UInt32 = 4
VIDEO_DUALVIEW_REMOVABLE: UInt32 = 1
VIDEO_DUALVIEW_PRIMARY: UInt32 = 2147483648
VIDEO_DUALVIEW_SECONDARY: UInt32 = 1073741824
VIDEO_DUALVIEW_WDDM_VGA: UInt32 = 536870912
VIDEO_STATE_NON_STANDARD_VGA: UInt32 = 1
VIDEO_STATE_UNEMULATED_VGA_STATE: UInt32 = 2
VIDEO_STATE_PACKED_CHAIN4_MODE: UInt32 = 4
VIDEO_MODE_NO_ZERO_MEMORY: UInt32 = 2147483648
VIDEO_MODE_MAP_MEM_LINEAR: UInt32 = 1073741824
VIDEO_MODE_COLOR: UInt32 = 1
VIDEO_MODE_GRAPHICS: UInt32 = 2
VIDEO_MODE_PALETTE_DRIVEN: UInt32 = 4
VIDEO_MODE_MANAGED_PALETTE: UInt32 = 8
VIDEO_MODE_INTERLACED: UInt32 = 16
VIDEO_MODE_NO_OFF_SCREEN: UInt32 = 32
VIDEO_MODE_NO_64_BIT_ACCESS: UInt32 = 64
VIDEO_MODE_BANKED: UInt32 = 128
VIDEO_MODE_LINEAR: UInt32 = 256
VIDEO_MODE_ASYNC_POINTER: UInt32 = 1
VIDEO_MODE_MONO_POINTER: UInt32 = 2
VIDEO_MODE_COLOR_POINTER: UInt32 = 4
VIDEO_MODE_ANIMATE_START: UInt32 = 8
VIDEO_MODE_ANIMATE_UPDATE: UInt32 = 16
PLANAR_HC: UInt32 = 1
VIDEO_DEVICE_COLOR: UInt32 = 1
VIDEO_OPTIONAL_GAMMET_TABLE: UInt32 = 2
VIDEO_COLOR_LUT_DATA_FORMAT_RGB256WORDS: UInt32 = 1
VIDEO_COLOR_LUT_DATA_FORMAT_PRIVATEFORMAT: UInt32 = 2147483648
DISPLAYPOLICY_AC: UInt32 = 1
DISPLAYPOLICY_DC: UInt32 = 2
CHAR_TYPE_SBCS: UInt32 = 0
CHAR_TYPE_LEADING: UInt32 = 2
CHAR_TYPE_TRAILING: UInt32 = 3
BITMAP_BITS_BYTE_ALIGN: UInt32 = 8
BITMAP_BITS_WORD_ALIGN: UInt32 = 16
BITMAP_ARRAY_BYTE: UInt32 = 3
BITMAP_PLANES: UInt32 = 1
BITMAP_BITS_PIXEL: UInt32 = 1
DD_FULLSCREEN_VIDEO_DEVICE_NAME: String = '\\Device\\FSVideo'
VIDEO_REASON_NONE: UInt32 = 0
VIDEO_REASON_POLICY1: UInt32 = 1
VIDEO_REASON_POLICY2: UInt32 = 2
VIDEO_REASON_POLICY3: UInt32 = 3
VIDEO_REASON_POLICY4: UInt32 = 4
VIDEO_REASON_LOCK: UInt32 = 5
VIDEO_REASON_FAILED_ROTATION: UInt32 = 5
VIDEO_REASON_ALLOCATION: UInt32 = 6
VIDEO_REASON_SCRATCH: UInt32 = 8
VIDEO_REASON_CONFIGURATION: UInt32 = 9
VIDEO_MAX_REASON: UInt32 = 9
BRIGHTNESS_MAX_LEVEL_COUNT: UInt32 = 103
BRIGHTNESS_MAX_NIT_RANGE_COUNT: UInt32 = 16
DSI_PACKET_EMBEDDED_PAYLOAD_SIZE: UInt32 = 8
MAX_PACKET_COUNT: UInt32 = 128
DSI_INVALID_PACKET_INDEX: UInt32 = 255
DSI_SOT_ERROR: UInt32 = 1
DSI_SOT_SYNC_ERROR: UInt32 = 2
DSI_EOT_SYNC_ERROR: UInt32 = 4
DSI_ESCAPE_MODE_ENTRY_COMMAND_ERROR: UInt32 = 8
DSI_LOW_POWER_TRANSMIT_SYNC_ERROR: UInt32 = 16
DSI_PERIPHERAL_TIMEOUT_ERROR: UInt32 = 32
DSI_FALSE_CONTROL_ERROR: UInt32 = 64
DSI_CONTENTION_DETECTED: UInt32 = 128
DSI_CHECKSUM_ERROR_CORRECTED: UInt32 = 256
DSI_CHECKSUM_ERROR_NOT_CORRECTED: UInt32 = 512
DSI_LONG_PACKET_PAYLOAD_CHECKSUM_ERROR: UInt32 = 1024
DSI_DSI_DATA_TYPE_NOT_RECOGNIZED: UInt32 = 2048
DSI_DSI_VC_ID_INVALID: UInt32 = 4096
DSI_INVALID_TRANSMISSION_LENGTH: UInt32 = 8192
DSI_DSI_PROTOCOL_VIOLATION: UInt32 = 32768
HOST_DSI_DEVICE_NOT_READY: UInt32 = 1
HOST_DSI_INTERFACE_RESET: UInt32 = 2
HOST_DSI_DEVICE_RESET: UInt32 = 4
HOST_DSI_TRANSMISSION_CANCELLED: UInt32 = 16
HOST_DSI_TRANSMISSION_DROPPED: UInt32 = 32
HOST_DSI_TRANSMISSION_TIMEOUT: UInt32 = 64
HOST_DSI_INVALID_TRANSMISSION: UInt32 = 256
HOST_DSI_OS_REJECTED_PACKET: UInt32 = 512
HOST_DSI_DRIVER_REJECTED_PACKET: UInt32 = 1024
HOST_DSI_BAD_TRANSMISSION_MODE: UInt32 = 4096
GUID_MONITOR_OVERRIDE_PSEUDO_SPECIALIZED: Guid = Guid('{f196c02f-f86f-4f9a-aa15-e9cebdfe3b96}')
FD_ERROR: UInt32 = 4294967295
DDI_ERROR: UInt32 = 4294967295
FDM_TYPE_BM_SIDE_CONST: UInt32 = 1
FDM_TYPE_MAXEXT_EQUAL_BM_SIDE: UInt32 = 2
FDM_TYPE_CHAR_INC_EQUAL_BM_BASE: UInt32 = 4
FDM_TYPE_ZERO_BEARINGS: UInt32 = 8
FDM_TYPE_CONST_BEARINGS: UInt32 = 16
GS_UNICODE_HANDLES: UInt32 = 1
GS_8BIT_HANDLES: UInt32 = 2
GS_16BIT_HANDLES: UInt32 = 4
FM_VERSION_NUMBER: UInt32 = 0
FM_TYPE_LICENSED: UInt32 = 2
FM_READONLY_EMBED: UInt32 = 4
FM_EDITABLE_EMBED: UInt32 = 8
FM_NO_EMBEDDING: UInt32 = 2
FM_INFO_TECH_TRUETYPE: UInt32 = 1
FM_INFO_TECH_BITMAP: UInt32 = 2
FM_INFO_TECH_STROKE: UInt32 = 4
FM_INFO_TECH_OUTLINE_NOT_TRUETYPE: UInt32 = 8
FM_INFO_ARB_XFORMS: UInt32 = 16
FM_INFO_1BPP: UInt32 = 32
FM_INFO_4BPP: UInt32 = 64
FM_INFO_8BPP: UInt32 = 128
FM_INFO_16BPP: UInt32 = 256
FM_INFO_24BPP: UInt32 = 512
FM_INFO_32BPP: UInt32 = 1024
FM_INFO_INTEGER_WIDTH: UInt32 = 2048
FM_INFO_CONSTANT_WIDTH: UInt32 = 4096
FM_INFO_NOT_CONTIGUOUS: UInt32 = 8192
FM_INFO_TECH_MM: UInt32 = 16384
FM_INFO_RETURNS_OUTLINES: UInt32 = 32768
FM_INFO_RETURNS_STROKES: UInt32 = 65536
FM_INFO_RETURNS_BITMAPS: UInt32 = 131072
FM_INFO_DSIG: UInt32 = 262144
FM_INFO_RIGHT_HANDED: UInt32 = 524288
FM_INFO_INTEGRAL_SCALING: UInt32 = 1048576
FM_INFO_90DEGREE_ROTATIONS: UInt32 = 2097152
FM_INFO_OPTICALLY_FIXED_PITCH: UInt32 = 4194304
FM_INFO_DO_NOT_ENUMERATE: UInt32 = 8388608
FM_INFO_ISOTROPIC_SCALING_ONLY: UInt32 = 16777216
FM_INFO_ANISOTROPIC_SCALING_ONLY: UInt32 = 33554432
FM_INFO_TECH_CFF: UInt32 = 67108864
FM_INFO_FAMILY_EQUIV: UInt32 = 134217728
FM_INFO_DBCS_FIXED_PITCH: UInt32 = 268435456
FM_INFO_NONNEGATIVE_AC: UInt32 = 536870912
FM_INFO_IGNORE_TC_RA_ABLE: UInt32 = 1073741824
FM_INFO_TECH_TYPE1: UInt32 = 2147483648
MAXCHARSETS: UInt32 = 16
FM_PANOSE_CULTURE_LATIN: UInt32 = 0
FM_SEL_ITALIC: UInt32 = 1
FM_SEL_UNDERSCORE: UInt32 = 2
FM_SEL_NEGATIVE: UInt32 = 4
FM_SEL_OUTLINED: UInt32 = 8
FM_SEL_STRIKEOUT: UInt32 = 16
FM_SEL_BOLD: UInt32 = 32
FM_SEL_REGULAR: UInt32 = 64
OPENGL_CMD: UInt32 = 4352
OPENGL_GETINFO: UInt32 = 4353
WNDOBJ_SETUP: UInt32 = 4354
DDI_DRIVER_VERSION_NT4: UInt32 = 131072
DDI_DRIVER_VERSION_SP3: UInt32 = 131075
DDI_DRIVER_VERSION_NT5: UInt32 = 196608
DDI_DRIVER_VERSION_NT5_01: UInt32 = 196864
DDI_DRIVER_VERSION_NT5_01_SP1: UInt32 = 196865
GDI_DRIVER_VERSION: UInt32 = 16384
INDEX_DrvEnablePDEV: Int32 = 0
INDEX_DrvCompletePDEV: Int32 = 1
INDEX_DrvDisablePDEV: Int32 = 2
INDEX_DrvEnableSurface: Int32 = 3
INDEX_DrvDisableSurface: Int32 = 4
INDEX_DrvAssertMode: Int32 = 5
INDEX_DrvOffset: Int32 = 6
INDEX_DrvResetPDEV: Int32 = 7
INDEX_DrvDisableDriver: Int32 = 8
INDEX_DrvCreateDeviceBitmap: Int32 = 10
INDEX_DrvDeleteDeviceBitmap: Int32 = 11
INDEX_DrvRealizeBrush: Int32 = 12
INDEX_DrvDitherColor: Int32 = 13
INDEX_DrvStrokePath: Int32 = 14
INDEX_DrvFillPath: Int32 = 15
INDEX_DrvStrokeAndFillPath: Int32 = 16
INDEX_DrvPaint: Int32 = 17
INDEX_DrvBitBlt: Int32 = 18
INDEX_DrvCopyBits: Int32 = 19
INDEX_DrvStretchBlt: Int32 = 20
INDEX_DrvSetPalette: Int32 = 22
INDEX_DrvTextOut: Int32 = 23
INDEX_DrvEscape: Int32 = 24
INDEX_DrvDrawEscape: Int32 = 25
INDEX_DrvQueryFont: Int32 = 26
INDEX_DrvQueryFontTree: Int32 = 27
INDEX_DrvQueryFontData: Int32 = 28
INDEX_DrvSetPointerShape: Int32 = 29
INDEX_DrvMovePointer: Int32 = 30
INDEX_DrvLineTo: Int32 = 31
INDEX_DrvSendPage: Int32 = 32
INDEX_DrvStartPage: Int32 = 33
INDEX_DrvEndDoc: Int32 = 34
INDEX_DrvStartDoc: Int32 = 35
INDEX_DrvGetGlyphMode: Int32 = 37
INDEX_DrvSynchronize: Int32 = 38
INDEX_DrvSaveScreenBits: Int32 = 40
INDEX_DrvGetModes: Int32 = 41
INDEX_DrvFree: Int32 = 42
INDEX_DrvDestroyFont: Int32 = 43
INDEX_DrvQueryFontCaps: Int32 = 44
INDEX_DrvLoadFontFile: Int32 = 45
INDEX_DrvUnloadFontFile: Int32 = 46
INDEX_DrvFontManagement: Int32 = 47
INDEX_DrvQueryTrueTypeTable: Int32 = 48
INDEX_DrvQueryTrueTypeOutline: Int32 = 49
INDEX_DrvGetTrueTypeFile: Int32 = 50
INDEX_DrvQueryFontFile: Int32 = 51
INDEX_DrvMovePanning: Int32 = 52
INDEX_DrvQueryAdvanceWidths: Int32 = 53
INDEX_DrvSetPixelFormat: Int32 = 54
INDEX_DrvDescribePixelFormat: Int32 = 55
INDEX_DrvSwapBuffers: Int32 = 56
INDEX_DrvStartBanding: Int32 = 57
INDEX_DrvNextBand: Int32 = 58
INDEX_DrvGetDirectDrawInfo: Int32 = 59
INDEX_DrvEnableDirectDraw: Int32 = 60
INDEX_DrvDisableDirectDraw: Int32 = 61
INDEX_DrvQuerySpoolType: Int32 = 62
INDEX_DrvIcmCreateColorTransform: Int32 = 64
INDEX_DrvIcmDeleteColorTransform: Int32 = 65
INDEX_DrvIcmCheckBitmapBits: Int32 = 66
INDEX_DrvIcmSetDeviceGammaRamp: Int32 = 67
INDEX_DrvGradientFill: Int32 = 68
INDEX_DrvStretchBltROP: Int32 = 69
INDEX_DrvPlgBlt: Int32 = 70
INDEX_DrvAlphaBlend: Int32 = 71
INDEX_DrvSynthesizeFont: Int32 = 72
INDEX_DrvGetSynthesizedFontFiles: Int32 = 73
INDEX_DrvTransparentBlt: Int32 = 74
INDEX_DrvQueryPerBandInfo: Int32 = 75
INDEX_DrvQueryDeviceSupport: Int32 = 76
INDEX_DrvReserved1: Int32 = 77
INDEX_DrvReserved2: Int32 = 78
INDEX_DrvReserved3: Int32 = 79
INDEX_DrvReserved4: Int32 = 80
INDEX_DrvReserved5: Int32 = 81
INDEX_DrvReserved6: Int32 = 82
INDEX_DrvReserved7: Int32 = 83
INDEX_DrvReserved8: Int32 = 84
INDEX_DrvDeriveSurface: Int32 = 85
INDEX_DrvQueryGlyphAttrs: Int32 = 86
INDEX_DrvNotify: Int32 = 87
INDEX_DrvSynchronizeSurface: Int32 = 88
INDEX_DrvResetDevice: Int32 = 89
INDEX_DrvReserved9: Int32 = 90
INDEX_DrvReserved10: Int32 = 91
INDEX_DrvReserved11: Int32 = 92
INDEX_DrvRenderHint: Int32 = 93
INDEX_DrvCreateDeviceBitmapEx: Int32 = 94
INDEX_DrvDeleteDeviceBitmapEx: Int32 = 95
INDEX_DrvAssociateSharedSurface: Int32 = 96
INDEX_DrvSynchronizeRedirectionBitmaps: Int32 = 97
INDEX_DrvAccumulateD3DDirtyRect: Int32 = 98
INDEX_DrvStartDxInterop: Int32 = 99
INDEX_DrvEndDxInterop: Int32 = 100
INDEX_DrvLockDisplayArea: Int32 = 101
INDEX_DrvUnlockDisplayArea: Int32 = 102
INDEX_DrvSurfaceComplete: Int32 = 103
INDEX_LAST: Int32 = 89
GCAPS_BEZIERS: UInt32 = 1
GCAPS_GEOMETRICWIDE: UInt32 = 2
GCAPS_ALTERNATEFILL: UInt32 = 4
GCAPS_WINDINGFILL: UInt32 = 8
GCAPS_HALFTONE: UInt32 = 16
GCAPS_COLOR_DITHER: UInt32 = 32
GCAPS_HORIZSTRIKE: UInt32 = 64
GCAPS_VERTSTRIKE: UInt32 = 128
GCAPS_OPAQUERECT: UInt32 = 256
GCAPS_VECTORFONT: UInt32 = 512
GCAPS_MONO_DITHER: UInt32 = 1024
GCAPS_ASYNCCHANGE: UInt32 = 2048
GCAPS_ASYNCMOVE: UInt32 = 4096
GCAPS_DONTJOURNAL: UInt32 = 8192
GCAPS_DIRECTDRAW: UInt32 = 16384
GCAPS_ARBRUSHOPAQUE: UInt32 = 32768
GCAPS_PANNING: UInt32 = 65536
GCAPS_HIGHRESTEXT: UInt32 = 262144
GCAPS_PALMANAGED: UInt32 = 524288
GCAPS_DITHERONREALIZE: UInt32 = 2097152
GCAPS_NO64BITMEMACCESS: UInt32 = 4194304
GCAPS_FORCEDITHER: UInt32 = 8388608
GCAPS_GRAY16: UInt32 = 16777216
GCAPS_ICM: UInt32 = 33554432
GCAPS_CMYKCOLOR: UInt32 = 67108864
GCAPS_LAYERED: UInt32 = 134217728
GCAPS_ARBRUSHTEXT: UInt32 = 268435456
GCAPS_SCREENPRECISION: UInt32 = 536870912
GCAPS_FONT_RASTERIZER: UInt32 = 1073741824
GCAPS_NUP: UInt32 = 2147483648
GCAPS2_JPEGSRC: UInt32 = 1
GCAPS2_xxxx: UInt32 = 2
GCAPS2_PNGSRC: UInt32 = 8
GCAPS2_CHANGEGAMMARAMP: UInt32 = 16
GCAPS2_ALPHACURSOR: UInt32 = 32
GCAPS2_SYNCFLUSH: UInt32 = 64
GCAPS2_SYNCTIMER: UInt32 = 128
GCAPS2_ICD_MULTIMON: UInt32 = 256
GCAPS2_MOUSETRAILS: UInt32 = 512
GCAPS2_RESERVED1: UInt32 = 1024
GCAPS2_REMOTEDRIVER: UInt32 = 1024
GCAPS2_EXCLUDELAYERED: UInt32 = 2048
GCAPS2_INCLUDEAPIBITMAPS: UInt32 = 4096
GCAPS2_SHOWHIDDENPOINTER: UInt32 = 8192
GCAPS2_CLEARTYPE: UInt32 = 16384
GCAPS2_ACC_DRIVER: UInt32 = 32768
GCAPS2_BITMAPEXREUSE: UInt32 = 65536
LA_GEOMETRIC: UInt32 = 1
LA_ALTERNATE: UInt32 = 2
LA_STARTGAP: UInt32 = 4
LA_STYLED: UInt32 = 8
JOIN_ROUND: Int32 = 0
JOIN_BEVEL: Int32 = 1
JOIN_MITER: Int32 = 2
ENDCAP_ROUND: Int32 = 0
ENDCAP_SQUARE: Int32 = 1
ENDCAP_BUTT: Int32 = 2
PRIMARY_ORDER_ABC: UInt32 = 0
PRIMARY_ORDER_ACB: UInt32 = 1
PRIMARY_ORDER_BAC: UInt32 = 2
PRIMARY_ORDER_BCA: UInt32 = 3
PRIMARY_ORDER_CBA: UInt32 = 4
PRIMARY_ORDER_CAB: UInt32 = 5
HT_PATSIZE_2x2: UInt32 = 0
HT_PATSIZE_2x2_M: UInt32 = 1
HT_PATSIZE_4x4: UInt32 = 2
HT_PATSIZE_4x4_M: UInt32 = 3
HT_PATSIZE_6x6: UInt32 = 4
HT_PATSIZE_6x6_M: UInt32 = 5
HT_PATSIZE_8x8: UInt32 = 6
HT_PATSIZE_8x8_M: UInt32 = 7
HT_PATSIZE_10x10: UInt32 = 8
HT_PATSIZE_10x10_M: UInt32 = 9
HT_PATSIZE_12x12: UInt32 = 10
HT_PATSIZE_12x12_M: UInt32 = 11
HT_PATSIZE_14x14: UInt32 = 12
HT_PATSIZE_14x14_M: UInt32 = 13
HT_PATSIZE_16x16: UInt32 = 14
HT_PATSIZE_16x16_M: UInt32 = 15
HT_PATSIZE_SUPERCELL: UInt32 = 16
HT_PATSIZE_SUPERCELL_M: UInt32 = 17
HT_PATSIZE_USER: UInt32 = 18
HT_PATSIZE_MAX_INDEX: UInt32 = 18
HT_PATSIZE_DEFAULT: UInt32 = 17
HT_USERPAT_CX_MIN: UInt32 = 4
HT_USERPAT_CX_MAX: UInt32 = 256
HT_USERPAT_CY_MIN: UInt32 = 4
HT_USERPAT_CY_MAX: UInt32 = 256
HT_FORMAT_1BPP: UInt32 = 0
HT_FORMAT_4BPP: UInt32 = 2
HT_FORMAT_4BPP_IRGB: UInt32 = 3
HT_FORMAT_8BPP: UInt32 = 4
HT_FORMAT_16BPP: UInt32 = 5
HT_FORMAT_24BPP: UInt32 = 6
HT_FORMAT_32BPP: UInt32 = 7
WINDDI_MAX_BROADCAST_CONTEXT: UInt32 = 64
HT_FLAG_SQUARE_DEVICE_PEL: UInt32 = 1
HT_FLAG_HAS_BLACK_DYE: UInt32 = 2
HT_FLAG_ADDITIVE_PRIMS: UInt32 = 4
HT_FLAG_USE_8BPP_BITMASK: UInt32 = 8
HT_FLAG_INK_HIGH_ABSORPTION: UInt32 = 16
HT_FLAG_INK_ABSORPTION_INDICES: UInt32 = 96
HT_FLAG_DO_DEVCLR_XFORM: UInt32 = 128
HT_FLAG_OUTPUT_CMY: UInt32 = 256
HT_FLAG_PRINT_DRAFT_MODE: UInt32 = 512
HT_FLAG_INVERT_8BPP_BITMASK_IDX: UInt32 = 1024
HT_FLAG_8BPP_CMY332_MASK: UInt32 = 4278190080
HT_FLAG_INK_ABSORPTION_IDX0: UInt32 = 0
HT_FLAG_INK_ABSORPTION_IDX1: UInt32 = 32
HT_FLAG_INK_ABSORPTION_IDX2: UInt32 = 64
HT_FLAG_INK_ABSORPTION_IDX3: UInt32 = 96
HT_FLAG_NORMAL_INK_ABSORPTION: UInt32 = 0
HT_FLAG_LOW_INK_ABSORPTION: UInt32 = 32
HT_FLAG_LOWER_INK_ABSORPTION: UInt32 = 64
HT_FLAG_LOWEST_INK_ABSORPTION: UInt32 = 96
PPC_DEFAULT: UInt32 = 0
PPC_UNDEFINED: UInt32 = 1
PPC_RGB_ORDER_VERTICAL_STRIPES: UInt32 = 2
PPC_BGR_ORDER_VERTICAL_STRIPES: UInt32 = 3
PPC_RGB_ORDER_HORIZONTAL_STRIPES: UInt32 = 4
PPC_BGR_ORDER_HORIZONTAL_STRIPES: UInt32 = 5
PPG_DEFAULT: UInt32 = 0
PPG_SRGB: UInt32 = 1
BR_DEVICE_ICM: UInt32 = 1
BR_HOST_ICM: UInt32 = 2
BR_CMYKCOLOR: UInt32 = 4
BR_ORIGCOLOR: UInt32 = 8
FO_SIM_BOLD: UInt32 = 8192
FO_SIM_ITALIC: UInt32 = 16384
FO_EM_HEIGHT: UInt32 = 32768
FO_GRAY16: UInt32 = 65536
FO_NOGRAY16: UInt32 = 131072
FO_NOHINTS: UInt32 = 262144
FO_NO_CHOICE: UInt32 = 524288
FO_CFF: UInt32 = 1048576
FO_POSTSCRIPT: UInt32 = 2097152
FO_MULTIPLEMASTER: UInt32 = 4194304
FO_VERT_FACE: UInt32 = 8388608
FO_DBCS_FONT: UInt32 = 16777216
FO_NOCLEARTYPE: UInt32 = 33554432
FO_CLEARTYPE_X: UInt32 = 268435456
FO_CLEARTYPE_Y: UInt32 = 536870912
FO_CLEARTYPENATURAL_X: UInt32 = 1073741824
DC_TRIVIAL: UInt32 = 0
DC_RECT: UInt32 = 1
DC_COMPLEX: UInt32 = 3
FC_RECT: UInt32 = 1
FC_RECT4: UInt32 = 2
FC_COMPLEX: UInt32 = 3
TC_RECTANGLES: UInt32 = 0
TC_PATHOBJ: UInt32 = 2
OC_BANK_CLIP: UInt32 = 1
CT_RECTANGLES: Int32 = 0
CD_RIGHTDOWN: Int32 = 0
CD_LEFTDOWN: Int32 = 1
CD_RIGHTUP: Int32 = 2
CD_LEFTUP: Int32 = 3
CD_ANY: Int32 = 4
CD_LEFTWARDS: Int32 = 1
CD_UPWARDS: Int32 = 2
FO_HGLYPHS: Int32 = 0
FO_GLYPHBITS: Int32 = 1
FO_PATHOBJ: Int32 = 2
FD_NEGATIVE_FONT: Int32 = 1
FO_DEVICE_FONT: Int32 = 1
FO_OUTLINE_CAPABLE: Int32 = 2
SO_FLAG_DEFAULT_PLACEMENT: UInt32 = 1
SO_HORIZONTAL: UInt32 = 2
SO_VERTICAL: UInt32 = 4
SO_REVERSED: UInt32 = 8
SO_ZERO_BEARINGS: UInt32 = 16
SO_CHAR_INC_EQUAL_BM_BASE: UInt32 = 32
SO_MAXEXT_EQUAL_BM_SIDE: UInt32 = 64
SO_DO_NOT_SUBSTITUTE_DEVICE_FONT: UInt32 = 128
SO_GLYPHINDEX_TEXTOUT: UInt32 = 256
SO_ESC_NOT_ORIENT: UInt32 = 512
SO_DXDY: UInt32 = 1024
SO_CHARACTER_EXTRA: UInt32 = 2048
SO_BREAK_EXTRA: UInt32 = 4096
FO_ATTR_MODE_ROTATE: UInt32 = 1
PAL_INDEXED: UInt32 = 1
PAL_BITFIELDS: UInt32 = 2
PAL_RGB: UInt32 = 4
PAL_BGR: UInt32 = 8
PAL_CMYK: UInt32 = 16
PO_BEZIERS: UInt32 = 1
PO_ELLIPSE: UInt32 = 2
PO_ALL_INTEGERS: UInt32 = 4
PO_ENUM_AS_INTEGERS: UInt32 = 8
PO_WIDENED: UInt32 = 16
PD_BEGINSUBPATH: UInt32 = 1
PD_ENDSUBPATH: UInt32 = 2
PD_RESETSTYLE: UInt32 = 4
PD_CLOSEFIGURE: UInt32 = 8
PD_BEZIERS: UInt32 = 16
SGI_EXTRASPACE: UInt32 = 0
STYPE_BITMAP: Int32 = 0
STYPE_DEVBITMAP: Int32 = 3
BMF_1BPP: Int32 = 1
BMF_4BPP: Int32 = 2
BMF_8BPP: Int32 = 3
BMF_16BPP: Int32 = 4
BMF_24BPP: Int32 = 5
BMF_32BPP: Int32 = 6
BMF_4RLE: Int32 = 7
BMF_8RLE: Int32 = 8
BMF_JPEG: Int32 = 9
BMF_PNG: Int32 = 10
BMF_TOPDOWN: UInt32 = 1
BMF_NOZEROINIT: UInt32 = 2
BMF_DONTCACHE: UInt32 = 4
BMF_USERMEM: UInt32 = 8
BMF_KMSECTION: UInt32 = 16
BMF_NOTSYSMEM: UInt32 = 32
BMF_WINDOW_BLT: UInt32 = 64
BMF_UMPDMEM: UInt32 = 128
BMF_TEMP_ALPHA: UInt32 = 256
BMF_ACC_NOTIFY: UInt32 = 32768
BMF_RMT_ENTER: UInt32 = 16384
BMF_RESERVED: UInt32 = 15872
GX_IDENTITY: Int32 = 0
GX_OFFSET: Int32 = 1
GX_SCALE: Int32 = 2
GX_GENERAL: Int32 = 3
XF_LTOL: Int32 = 0
XF_INV_LTOL: Int32 = 1
XF_LTOFX: Int32 = 2
XF_INV_FXTOL: Int32 = 3
XO_TRIVIAL: UInt32 = 1
XO_TABLE: UInt32 = 2
XO_TO_MONO: UInt32 = 4
XO_FROM_CMYK: UInt32 = 8
XO_DEVICE_ICM: UInt32 = 16
XO_HOST_ICM: UInt32 = 32
XO_SRCPALETTE: UInt32 = 1
XO_DESTPALETTE: UInt32 = 2
XO_DESTDCPALETTE: UInt32 = 3
XO_SRCBITFIELDS: UInt32 = 4
XO_DESTBITFIELDS: UInt32 = 5
HOOK_BITBLT: UInt32 = 1
HOOK_STRETCHBLT: UInt32 = 2
HOOK_PLGBLT: UInt32 = 4
HOOK_TEXTOUT: UInt32 = 8
HOOK_PAINT: UInt32 = 16
HOOK_STROKEPATH: UInt32 = 32
HOOK_FILLPATH: UInt32 = 64
HOOK_STROKEANDFILLPATH: UInt32 = 128
HOOK_LINETO: UInt32 = 256
HOOK_COPYBITS: UInt32 = 1024
HOOK_MOVEPANNING: UInt32 = 2048
HOOK_SYNCHRONIZE: UInt32 = 4096
HOOK_STRETCHBLTROP: UInt32 = 8192
HOOK_SYNCHRONIZEACCESS: UInt32 = 16384
HOOK_TRANSPARENTBLT: UInt32 = 32768
HOOK_ALPHABLEND: UInt32 = 65536
HOOK_GRADIENTFILL: UInt32 = 131072
HOOK_FLAGS: UInt32 = 243199
MS_NOTSYSTEMMEMORY: UInt32 = 1
MS_SHAREDACCESS: UInt32 = 2
MS_CDDDEVICEBITMAP: UInt32 = 4
MS_REUSEDDEVICEBITMAP: UInt32 = 8
DRVQUERY_USERMODE: UInt32 = 1
HS_DDI_MAX: UInt32 = 6
DRD_SUCCESS: UInt32 = 0
DRD_ERROR: UInt32 = 1
SS_SAVE: UInt32 = 0
SS_RESTORE: UInt32 = 1
SS_FREE: UInt32 = 2
CDBEX_REDIRECTION: UInt32 = 1
CDBEX_DXINTEROP: UInt32 = 2
CDBEX_NTSHAREDSURFACEHANDLE: UInt32 = 4
CDBEX_CROSSADAPTER: UInt32 = 8
CDBEX_REUSE: UInt32 = 16
WINDDI_MAXSETPALETTECOLORS: UInt32 = 256
WINDDI_MAXSETPALETTECOLORINDEX: UInt32 = 255
DM_DEFAULT: UInt32 = 1
DM_MONOCHROME: UInt32 = 2
DCR_SOLID: UInt32 = 0
DCR_DRIVER: UInt32 = 1
DCR_HALFTONE: UInt32 = 2
RB_DITHERCOLOR: Int32 = -2147483648
QFT_LIGATURES: Int32 = 1
QFT_KERNPAIRS: Int32 = 2
QFT_GLYPHSET: Int32 = 3
QFD_GLYPHANDBITMAP: Int32 = 1
QFD_GLYPHANDOUTLINE: Int32 = 2
QFD_MAXEXTENTS: Int32 = 3
QFD_TT_GLYPHANDBITMAP: Int32 = 4
QFD_TT_GRAY1_BITMAP: Int32 = 5
QFD_TT_GRAY2_BITMAP: Int32 = 6
QFD_TT_GRAY4_BITMAP: Int32 = 8
QFD_TT_GRAY8_BITMAP: Int32 = 9
QFD_TT_MONO_BITMAP: Int32 = 5
QC_OUTLINES: UInt32 = 1
QC_1BIT: UInt32 = 2
QC_4BIT: UInt32 = 4
FF_SIGNATURE_VERIFIED: UInt32 = 1
FF_IGNORED_SIGNATURE: UInt32 = 2
QAW_GETWIDTHS: UInt32 = 0
QAW_GETEASYWIDTHS: UInt32 = 1
TTO_METRICS_ONLY: UInt32 = 1
TTO_QUBICS: UInt32 = 2
TTO_UNHINTED: UInt32 = 4
QFF_DESCRIPTION: Int32 = 1
QFF_NUMFACES: Int32 = 2
FP_ALTERNATEMODE: Int32 = 1
FP_WINDINGMODE: Int32 = 2
SPS_ERROR: UInt32 = 0
SPS_DECLINE: UInt32 = 1
SPS_ACCEPT_NOEXCLUDE: UInt32 = 2
SPS_ACCEPT_EXCLUDE: UInt32 = 3
SPS_ACCEPT_SYNCHRONOUS: UInt32 = 4
SPS_CHANGE: Int32 = 1
SPS_ASYNCCHANGE: Int32 = 2
SPS_ANIMATESTART: Int32 = 4
SPS_ANIMATEUPDATE: Int32 = 8
SPS_ALPHA: Int32 = 16
SPS_RESERVED: Int32 = 32
SPS_RESERVED1: Int32 = 64
SPS_FLAGSMASK: Int32 = 255
SPS_LENGTHMASK: Int32 = 3840
SPS_FREQMASK: Int32 = 1044480
ED_ABORTDOC: UInt32 = 1
IGRF_RGB_256BYTES: UInt32 = 0
IGRF_RGB_256WORDS: UInt32 = 1
QDS_CHECKJPEGFORMAT: UInt32 = 0
QDS_CHECKPNGFORMAT: UInt32 = 1
DSS_TIMER_EVENT: UInt32 = 1
DSS_FLUSH_EVENT: UInt32 = 2
DSS_RESERVED: UInt32 = 4
DSS_RESERVED1: UInt32 = 8
DSS_RESERVED2: UInt32 = 16
DN_ACCELERATION_LEVEL: UInt32 = 1
DN_DEVICE_ORIGIN: UInt32 = 2
DN_SLEEP_MODE: UInt32 = 3
DN_DRAWING_BEGIN: UInt32 = 4
DN_ASSOCIATE_WINDOW: UInt32 = 5
DN_COMPOSITION_CHANGED: UInt32 = 6
DN_DRAWING_BEGIN_APIBITMAP: UInt32 = 7
DN_SURFOBJ_DESTRUCTION: UInt32 = 8
WOC_RGN_CLIENT_DELTA: UInt32 = 1
WOC_RGN_CLIENT: UInt32 = 2
WOC_RGN_SURFACE_DELTA: UInt32 = 4
WOC_RGN_SURFACE: UInt32 = 8
WOC_CHANGED: UInt32 = 16
WOC_DELETE: UInt32 = 32
WOC_DRAWN: UInt32 = 64
WOC_SPRITE_OVERLAP: UInt32 = 128
WOC_SPRITE_NO_OVERLAP: UInt32 = 256
WOC_RGN_SPRITE: UInt32 = 512
WO_RGN_CLIENT_DELTA: UInt32 = 1
WO_RGN_CLIENT: UInt32 = 2
WO_RGN_SURFACE_DELTA: UInt32 = 4
WO_RGN_SURFACE: UInt32 = 8
WO_RGN_UPDATE_ALL: UInt32 = 16
WO_RGN_WINDOW: UInt32 = 32
WO_DRAW_NOTIFY: UInt32 = 64
WO_SPRITE_NOTIFY: UInt32 = 128
WO_RGN_DESKTOP_COORD: UInt32 = 256
WO_RGN_SPRITE: UInt32 = 512
EHN_RESTORED: UInt32 = 0
EHN_ERROR: UInt32 = 1
ECS_TEARDOWN: UInt32 = 1
ECS_REDRAW: UInt32 = 2
DEVHTADJF_COLOR_DEVICE: UInt32 = 1
DEVHTADJF_ADDITIVE_DEVICE: UInt32 = 2
FL_ZERO_MEMORY: UInt32 = 1
FL_NONPAGED_MEMORY: UInt32 = 2
FL_NON_SESSION: UInt32 = 4
QSA_MMX: UInt32 = 256
QSA_SSE: UInt32 = 8192
QSA_3DNOW: UInt32 = 16384
QSA_SSE1: UInt32 = 8192
QSA_SSE2: UInt32 = 65536
QSA_SSE3: UInt32 = 524288
ENG_FNT_CACHE_READ_FAULT: UInt32 = 1
ENG_FNT_CACHE_WRITE_FAULT: UInt32 = 2
DRH_APIBITMAP: UInt32 = 1
MC_CAPS_NONE: UInt32 = 0
MC_CAPS_MONITOR_TECHNOLOGY_TYPE: UInt32 = 1
MC_CAPS_BRIGHTNESS: UInt32 = 2
MC_CAPS_CONTRAST: UInt32 = 4
MC_CAPS_COLOR_TEMPERATURE: UInt32 = 8
MC_CAPS_RED_GREEN_BLUE_GAIN: UInt32 = 16
MC_CAPS_RED_GREEN_BLUE_DRIVE: UInt32 = 32
MC_CAPS_DEGAUSS: UInt32 = 64
MC_CAPS_DISPLAY_AREA_POSITION: UInt32 = 128
MC_CAPS_DISPLAY_AREA_SIZE: UInt32 = 256
MC_CAPS_RESTORE_FACTORY_DEFAULTS: UInt32 = 1024
MC_CAPS_RESTORE_FACTORY_COLOR_DEFAULTS: UInt32 = 2048
MC_RESTORE_FACTORY_DEFAULTS_ENABLES_MONITOR_SETTINGS: UInt32 = 4096
MC_SUPPORTED_COLOR_TEMPERATURE_NONE: UInt32 = 0
MC_SUPPORTED_COLOR_TEMPERATURE_4000K: UInt32 = 1
MC_SUPPORTED_COLOR_TEMPERATURE_5000K: UInt32 = 2
MC_SUPPORTED_COLOR_TEMPERATURE_6500K: UInt32 = 4
MC_SUPPORTED_COLOR_TEMPERATURE_7500K: UInt32 = 8
MC_SUPPORTED_COLOR_TEMPERATURE_8200K: UInt32 = 16
MC_SUPPORTED_COLOR_TEMPERATURE_9300K: UInt32 = 32
MC_SUPPORTED_COLOR_TEMPERATURE_10000K: UInt32 = 64
MC_SUPPORTED_COLOR_TEMPERATURE_11500K: UInt32 = 128
PHYSICAL_MONITOR_DESCRIPTION_SIZE: UInt32 = 128
GETCONNECTEDIDS_TARGET: UInt32 = 0
GETCONNECTEDIDS_SOURCE: UInt32 = 1
S_INIT: UInt32 = 2
SETCONFIGURATION_STATUS_APPLIED: UInt32 = 0
SETCONFIGURATION_STATUS_ADDITIONAL: UInt32 = 1
SETCONFIGURATION_STATUS_OVERRIDDEN: UInt32 = 2
@winfunctype('dxva2.dll')
def GetNumberOfPhysicalMonitorsFromHMONITOR(hMonitor: win32more.Windows.Win32.Graphics.Gdi.HMONITOR, pdwNumberOfPhysicalMonitors: POINTER(UInt32)) -> win32more.Windows.Win32.Foundation.BOOL: ...
@winfunctype('dxva2.dll')
def GetNumberOfPhysicalMonitorsFromIDirect3DDevice9(pDirect3DDevice9: win32more.Windows.Win32.Graphics.Direct3D9.IDirect3DDevice9, pdwNumberOfPhysicalMonitors: POINTER(UInt32)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
@winfunctype('dxva2.dll')
def GetPhysicalMonitorsFromHMONITOR(hMonitor: win32more.Windows.Win32.Graphics.Gdi.HMONITOR, dwPhysicalMonitorArraySize: UInt32, pPhysicalMonitorArray: POINTER(win32more.Windows.Win32.Devices.Display.PHYSICAL_MONITOR)) -> win32more.Windows.Win32.Foundation.BOOL: ...
@winfunctype('dxva2.dll')
def GetPhysicalMonitorsFromIDirect3DDevice9(pDirect3DDevice9: win32more.Windows.Win32.Graphics.Direct3D9.IDirect3DDevice9, dwPhysicalMonitorArraySize: UInt32, pPhysicalMonitorArray: POINTER(win32more.Windows.Win32.Devices.Display.PHYSICAL_MONITOR)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
@winfunctype('dxva2.dll')
def DestroyPhysicalMonitor(hMonitor: win32more.Windows.Win32.Foundation.HANDLE) -> win32more.Windows.Win32.Foundation.BOOL: ...
@winfunctype('dxva2.dll')
def DestroyPhysicalMonitors(dwPhysicalMonitorArraySize: UInt32, pPhysicalMonitorArray: POINTER(win32more.Windows.Win32.Devices.Display.PHYSICAL_MONITOR)) -> win32more.Windows.Win32.Foundation.BOOL: ...
@winfunctype('dxva2.dll')
def GetVCPFeatureAndVCPFeatureReply(hMonitor: win32more.Windows.Win32.Foundation.HANDLE, bVCPCode: Byte, pvct: POINTER(win32more.Windows.Win32.Devices.Display.MC_VCP_CODE_TYPE), pdwCurrentValue: POINTER(UInt32), pdwMaximumValue: POINTER(UInt32)) -> Int32: ...
@winfunctype('dxva2.dll')
def SetVCPFeature(hMonitor: win32more.Windows.Win32.Foundation.HANDLE, bVCPCode: Byte, dwNewValue: UInt32) -> Int32: ...
@winfunctype('dxva2.dll')
def SaveCurrentSettings(hMonitor: win32more.Windows.Win32.Foundation.HANDLE) -> Int32: ...
@winfunctype('dxva2.dll')
def GetCapabilitiesStringLength(hMonitor: win32more.Windows.Win32.Foundation.HANDLE, pdwCapabilitiesStringLengthInCharacters: POINTER(UInt32)) -> Int32: ...
@winfunctype('dxva2.dll')
def CapabilitiesRequestAndCapabilitiesReply(hMonitor: win32more.Windows.Win32.Foundation.HANDLE, pszASCIICapabilitiesString: win32more.Windows.Win32.Foundation.PSTR, dwCapabilitiesStringLengthInCharacters: UInt32) -> Int32: ...
@winfunctype('dxva2.dll')
def GetTimingReport(hMonitor: win32more.Windows.Win32.Foundation.HANDLE, pmtrMonitorTimingReport: POINTER(win32more.Windows.Win32.Devices.Display.MC_TIMING_REPORT)) -> Int32: ...
@winfunctype('dxva2.dll')
def GetMonitorCapabilities(hMonitor: win32more.Windows.Win32.Foundation.HANDLE, pdwMonitorCapabilities: POINTER(UInt32), pdwSupportedColorTemperatures: POINTER(UInt32)) -> Int32: ...
@winfunctype('dxva2.dll')
def SaveCurrentMonitorSettings(hMonitor: win32more.Windows.Win32.Foundation.HANDLE) -> Int32: ...
@winfunctype('dxva2.dll')
def GetMonitorTechnologyType(hMonitor: win32more.Windows.Win32.Foundation.HANDLE, pdtyDisplayTechnologyType: POINTER(win32more.Windows.Win32.Devices.Display.MC_DISPLAY_TECHNOLOGY_TYPE)) -> Int32: ...
@winfunctype('dxva2.dll')
def GetMonitorBrightness(hMonitor: win32more.Windows.Win32.Foundation.HANDLE, pdwMinimumBrightness: POINTER(UInt32), pdwCurrentBrightness: POINTER(UInt32), pdwMaximumBrightness: POINTER(UInt32)) -> Int32: ...
@winfunctype('dxva2.dll')
def GetMonitorContrast(hMonitor: win32more.Windows.Win32.Foundation.HANDLE, pdwMinimumContrast: POINTER(UInt32), pdwCurrentContrast: POINTER(UInt32), pdwMaximumContrast: POINTER(UInt32)) -> Int32: ...
@winfunctype('dxva2.dll')
def GetMonitorColorTemperature(hMonitor: win32more.Windows.Win32.Foundation.HANDLE, pctCurrentColorTemperature: POINTER(win32more.Windows.Win32.Devices.Display.MC_COLOR_TEMPERATURE)) -> Int32: ...
@winfunctype('dxva2.dll')
def GetMonitorRedGreenOrBlueDrive(hMonitor: win32more.Windows.Win32.Foundation.HANDLE, dtDriveType: win32more.Windows.Win32.Devices.Display.MC_DRIVE_TYPE, pdwMinimumDrive: POINTER(UInt32), pdwCurrentDrive: POINTER(UInt32), pdwMaximumDrive: POINTER(UInt32)) -> Int32: ...
@winfunctype('dxva2.dll')
def GetMonitorRedGreenOrBlueGain(hMonitor: win32more.Windows.Win32.Foundation.HANDLE, gtGainType: win32more.Windows.Win32.Devices.Display.MC_GAIN_TYPE, pdwMinimumGain: POINTER(UInt32), pdwCurrentGain: POINTER(UInt32), pdwMaximumGain: POINTER(UInt32)) -> Int32: ...
@winfunctype('dxva2.dll')
def SetMonitorBrightness(hMonitor: win32more.Windows.Win32.Foundation.HANDLE, dwNewBrightness: UInt32) -> Int32: ...
@winfunctype('dxva2.dll')
def SetMonitorContrast(hMonitor: win32more.Windows.Win32.Foundation.HANDLE, dwNewContrast: UInt32) -> Int32: ...
@winfunctype('dxva2.dll')
def SetMonitorColorTemperature(hMonitor: win32more.Windows.Win32.Foundation.HANDLE, ctCurrentColorTemperature: win32more.Windows.Win32.Devices.Display.MC_COLOR_TEMPERATURE) -> Int32: ...
@winfunctype('dxva2.dll')
def SetMonitorRedGreenOrBlueDrive(hMonitor: win32more.Windows.Win32.Foundation.HANDLE, dtDriveType: win32more.Windows.Win32.Devices.Display.MC_DRIVE_TYPE, dwNewDrive: UInt32) -> Int32: ...
@winfunctype('dxva2.dll')
def SetMonitorRedGreenOrBlueGain(hMonitor: win32more.Windows.Win32.Foundation.HANDLE, gtGainType: win32more.Windows.Win32.Devices.Display.MC_GAIN_TYPE, dwNewGain: UInt32) -> Int32: ...
@winfunctype('dxva2.dll')
def DegaussMonitor(hMonitor: win32more.Windows.Win32.Foundation.HANDLE) -> Int32: ...
@winfunctype('dxva2.dll')
def GetMonitorDisplayAreaSize(hMonitor: win32more.Windows.Win32.Foundation.HANDLE, stSizeType: win32more.Windows.Win32.Devices.Display.MC_SIZE_TYPE, pdwMinimumWidthOrHeight: POINTER(UInt32), pdwCurrentWidthOrHeight: POINTER(UInt32), pdwMaximumWidthOrHeight: POINTER(UInt32)) -> Int32: ...
@winfunctype('dxva2.dll')
def GetMonitorDisplayAreaPosition(hMonitor: win32more.Windows.Win32.Foundation.HANDLE, ptPositionType: win32more.Windows.Win32.Devices.Display.MC_POSITION_TYPE, pdwMinimumPosition: POINTER(UInt32), pdwCurrentPosition: POINTER(UInt32), pdwMaximumPosition: POINTER(UInt32)) -> Int32: ...
@winfunctype('dxva2.dll')
def SetMonitorDisplayAreaSize(hMonitor: win32more.Windows.Win32.Foundation.HANDLE, stSizeType: win32more.Windows.Win32.Devices.Display.MC_SIZE_TYPE, dwNewDisplayAreaWidthOrHeight: UInt32) -> Int32: ...
@winfunctype('dxva2.dll')
def SetMonitorDisplayAreaPosition(hMonitor: win32more.Windows.Win32.Foundation.HANDLE, ptPositionType: win32more.Windows.Win32.Devices.Display.MC_POSITION_TYPE, dwNewPosition: UInt32) -> Int32: ...
@winfunctype('dxva2.dll')
def RestoreMonitorFactoryColorDefaults(hMonitor: win32more.Windows.Win32.Foundation.HANDLE) -> Int32: ...
@winfunctype('dxva2.dll')
def RestoreMonitorFactoryDefaults(hMonitor: win32more.Windows.Win32.Foundation.HANDLE) -> Int32: ...
@winfunctype('GDI32.dll')
def BRUSHOBJ_pvAllocRbrush(pbo: POINTER(win32more.Windows.Win32.Devices.Display.BRUSHOBJ), cj: UInt32) -> VoidPtr: ...
@winfunctype('GDI32.dll')
def BRUSHOBJ_pvGetRbrush(pbo: POINTER(win32more.Windows.Win32.Devices.Display.BRUSHOBJ)) -> VoidPtr: ...
@winfunctype('GDI32.dll')
def BRUSHOBJ_ulGetBrushColor(pbo: POINTER(win32more.Windows.Win32.Devices.Display.BRUSHOBJ)) -> UInt32: ...
@winfunctype('GDI32.dll')
def BRUSHOBJ_hGetColorTransform(pbo: POINTER(win32more.Windows.Win32.Devices.Display.BRUSHOBJ)) -> win32more.Windows.Win32.Foundation.HANDLE: ...
@winfunctype('GDI32.dll')
def CLIPOBJ_cEnumStart(pco: POINTER(win32more.Windows.Win32.Devices.Display.CLIPOBJ), bAll: win32more.Windows.Win32.Foundation.BOOL, iType: UInt32, iDirection: UInt32, cLimit: UInt32) -> UInt32: ...
@winfunctype('GDI32.dll')
def CLIPOBJ_bEnum(pco: POINTER(win32more.Windows.Win32.Devices.Display.CLIPOBJ), cj: UInt32, pul: POINTER(UInt32)) -> win32more.Windows.Win32.Foundation.BOOL: ...
@winfunctype('GDI32.dll')
def CLIPOBJ_ppoGetPath(pco: POINTER(win32more.Windows.Win32.Devices.Display.CLIPOBJ)) -> POINTER(win32more.Windows.Win32.Devices.Display.PATHOBJ): ...
@winfunctype('GDI32.dll')
def FONTOBJ_cGetAllGlyphHandles(pfo: POINTER(win32more.Windows.Win32.Devices.Display.FONTOBJ), phg: POINTER(UInt32)) -> UInt32: ...
@winfunctype('GDI32.dll')
def FONTOBJ_vGetInfo(pfo: POINTER(win32more.Windows.Win32.Devices.Display.FONTOBJ), cjSize: UInt32, pfi: POINTER(win32more.Windows.Win32.Devices.Display.FONTINFO)) -> Void: ...
@winfunctype('GDI32.dll')
def FONTOBJ_cGetGlyphs(pfo: POINTER(win32more.Windows.Win32.Devices.Display.FONTOBJ), iMode: UInt32, cGlyph: UInt32, phg: POINTER(UInt32), ppvGlyph: POINTER(VoidPtr)) -> UInt32: ...
@winfunctype('GDI32.dll')
def FONTOBJ_pxoGetXform(pfo: POINTER(win32more.Windows.Win32.Devices.Display.FONTOBJ)) -> POINTER(win32more.Windows.Win32.Devices.Display.XFORMOBJ): ...
@winfunctype('GDI32.dll')
def FONTOBJ_pifi(pfo: POINTER(win32more.Windows.Win32.Devices.Display.FONTOBJ)) -> POINTER(win32more.Windows.Win32.Devices.Display.IFIMETRICS): ...
@winfunctype('GDI32.dll')
def FONTOBJ_pfdg(pfo: POINTER(win32more.Windows.Win32.Devices.Display.FONTOBJ)) -> POINTER(win32more.Windows.Win32.Devices.Display.FD_GLYPHSET): ...
@winfunctype('GDI32.dll')
def FONTOBJ_pvTrueTypeFontFile(pfo: POINTER(win32more.Windows.Win32.Devices.Display.FONTOBJ), pcjFile: POINTER(UInt32)) -> VoidPtr: ...
@winfunctype('GDI32.dll')
def FONTOBJ_pQueryGlyphAttrs(pfo: POINTER(win32more.Windows.Win32.Devices.Display.FONTOBJ), iMode: UInt32) -> POINTER(win32more.Windows.Win32.Devices.Display.FD_GLYPHATTR): ...
@winfunctype('GDI32.dll')
def PATHOBJ_vEnumStart(ppo: POINTER(win32more.Windows.Win32.Devices.Display.PATHOBJ)) -> Void: ...
@winfunctype('GDI32.dll')
def PATHOBJ_bEnum(ppo: POINTER(win32more.Windows.Win32.Devices.Display.PATHOBJ), ppd: POINTER(win32more.Windows.Win32.Devices.Display.PATHDATA)) -> win32more.Windows.Win32.Foundation.BOOL: ...
@winfunctype('GDI32.dll')
def PATHOBJ_vEnumStartClipLines(ppo: POINTER(win32more.Windows.Win32.Devices.Display.PATHOBJ), pco: POINTER(win32more.Windows.Win32.Devices.Display.CLIPOBJ), pso: POINTER(win32more.Windows.Win32.Devices.Display.SURFOBJ), pla: POINTER(win32more.Windows.Win32.Devices.Display.LINEATTRS)) -> Void: ...
@winfunctype('GDI32.dll')
def PATHOBJ_bEnumClipLines(ppo: POINTER(win32more.Windows.Win32.Devices.Display.PATHOBJ), cb: UInt32, pcl: POINTER(win32more.Windows.Win32.Devices.Display.CLIPLINE)) -> win32more.Windows.Win32.Foundation.BOOL: ...
@winfunctype('GDI32.dll')
def PATHOBJ_vGetBounds(ppo: POINTER(win32more.Windows.Win32.Devices.Display.PATHOBJ), prectfx: POINTER(win32more.Windows.Win32.Devices.Display.RECTFX)) -> Void: ...
@winfunctype('GDI32.dll')
def STROBJ_vEnumStart(pstro: POINTER(win32more.Windows.Win32.Devices.Display.STROBJ)) -> Void: ...
@winfunctype('GDI32.dll')
def STROBJ_bEnum(pstro: POINTER(win32more.Windows.Win32.Devices.Display.STROBJ), pc: POINTER(UInt32), ppgpos: POINTER(POINTER(win32more.Windows.Win32.Devices.Display.GLYPHPOS))) -> win32more.Windows.Win32.Foundation.BOOL: ...
@winfunctype('GDI32.dll')
def STROBJ_bEnumPositionsOnly(pstro: POINTER(win32more.Windows.Win32.Devices.Display.STROBJ), pc: POINTER(UInt32), ppgpos: POINTER(POINTER(win32more.Windows.Win32.Devices.Display.GLYPHPOS))) -> win32more.Windows.Win32.Foundation.BOOL: ...
@winfunctype('GDI32.dll')
def STROBJ_dwGetCodePage(pstro: POINTER(win32more.Windows.Win32.Devices.Display.STROBJ)) -> UInt32: ...
@winfunctype('GDI32.dll')
def STROBJ_bGetAdvanceWidths(pso: POINTER(win32more.Windows.Win32.Devices.Display.STROBJ), iFirst: UInt32, c: UInt32, pptqD: POINTER(win32more.Windows.Win32.Devices.Display.POINTQF)) -> win32more.Windows.Win32.Foundation.BOOL: ...
@winfunctype('GDI32.dll')
def XFORMOBJ_iGetXform(pxo: POINTER(win32more.Windows.Win32.Devices.Display.XFORMOBJ), pxform: POINTER(win32more.Windows.Win32.Devices.Display.XFORML)) -> UInt32: ...
@winfunctype('GDI32.dll')
def XFORMOBJ_bApplyXform(pxo: POINTER(win32more.Windows.Win32.Devices.Display.XFORMOBJ), iMode: UInt32, cPoints: UInt32, pvIn: VoidPtr, pvOut: VoidPtr) -> win32more.Windows.Win32.Foundation.BOOL: ...
@winfunctype('GDI32.dll')
def XLATEOBJ_iXlate(pxlo: POINTER(win32more.Windows.Win32.Devices.Display.XLATEOBJ), iColor: UInt32) -> UInt32: ...
@winfunctype('GDI32.dll')
def XLATEOBJ_piVector(pxlo: POINTER(win32more.Windows.Win32.Devices.Display.XLATEOBJ)) -> POINTER(UInt32): ...
@winfunctype('GDI32.dll')
def XLATEOBJ_cGetPalette(pxlo: POINTER(win32more.Windows.Win32.Devices.Display.XLATEOBJ), iPal: UInt32, cPal: UInt32, pPal: POINTER(UInt32)) -> UInt32: ...
@winfunctype('GDI32.dll')
def XLATEOBJ_hGetColorTransform(pxlo: POINTER(win32more.Windows.Win32.Devices.Display.XLATEOBJ)) -> win32more.Windows.Win32.Foundation.HANDLE: ...
@winfunctype('GDI32.dll')
def EngCreateBitmap(sizl: win32more.Windows.Win32.Foundation.SIZE, lWidth: Int32, iFormat: UInt32, fl: UInt32, pvBits: VoidPtr) -> win32more.Windows.Win32.Graphics.Gdi.HBITMAP: ...
@winfunctype('GDI32.dll')
def EngCreateDeviceSurface(dhsurf: win32more.Windows.Win32.Devices.Display.DHSURF, sizl: win32more.Windows.Win32.Foundation.SIZE, iFormatCompat: UInt32) -> win32more.Windows.Win32.Devices.Display.HSURF: ...
@winfunctype('GDI32.dll')
def EngCreateDeviceBitmap(dhsurf: win32more.Windows.Win32.Devices.Display.DHSURF, sizl: win32more.Windows.Win32.Foundation.SIZE, iFormatCompat: UInt32) -> win32more.Windows.Win32.Graphics.Gdi.HBITMAP: ...
@winfunctype('GDI32.dll')
def EngDeleteSurface(hsurf: win32more.Windows.Win32.Devices.Display.HSURF) -> win32more.Windows.Win32.Foundation.BOOL: ...
@winfunctype('GDI32.dll')
def EngLockSurface(hsurf: win32more.Windows.Win32.Devices.Display.HSURF) -> POINTER(win32more.Windows.Win32.Devices.Display.SURFOBJ): ...
@winfunctype('GDI32.dll')
def EngUnlockSurface(pso: POINTER(win32more.Windows.Win32.Devices.Display.SURFOBJ)) -> Void: ...
@winfunctype('GDI32.dll')
def EngEraseSurface(pso: POINTER(win32more.Windows.Win32.Devices.Display.SURFOBJ), prcl: POINTER(win32more.Windows.Win32.Foundation.RECTL), iColor: UInt32) -> win32more.Windows.Win32.Foundation.BOOL: ...
@winfunctype('GDI32.dll')
def EngAssociateSurface(hsurf: win32more.Windows.Win32.Devices.Display.HSURF, hdev: win32more.Windows.Win32.Devices.Display.HDEV, flHooks: UInt32) -> win32more.Windows.Win32.Foundation.BOOL: ...
@winfunctype('GDI32.dll')
def EngMarkBandingSurface(hsurf: win32more.Windows.Win32.Devices.Display.HSURF) -> win32more.Windows.Win32.Foundation.BOOL: ...
@winfunctype('GDI32.dll')
def EngCheckAbort(pso: POINTER(win32more.Windows.Win32.Devices.Display.SURFOBJ)) -> win32more.Windows.Win32.Foundation.BOOL: ...
@winfunctype('GDI32.dll')
def EngDeletePath(ppo: POINTER(win32more.Windows.Win32.Devices.Display.PATHOBJ)) -> Void: ...
@winfunctype('GDI32.dll')
def EngCreatePalette(iMode: UInt32, cColors: UInt32, pulColors: POINTER(UInt32), flRed: UInt32, flGreen: UInt32, flBlue: UInt32) -> win32more.Windows.Win32.Graphics.Gdi.HPALETTE: ...
@winfunctype('GDI32.dll')
def EngDeletePalette(hpal: win32more.Windows.Win32.Graphics.Gdi.HPALETTE) -> win32more.Windows.Win32.Foundation.BOOL: ...
@winfunctype('GDI32.dll')
def EngCreateClip() -> POINTER(win32more.Windows.Win32.Devices.Display.CLIPOBJ): ...
@winfunctype('GDI32.dll')
def EngDeleteClip(pco: POINTER(win32more.Windows.Win32.Devices.Display.CLIPOBJ)) -> Void: ...
@winfunctype('GDI32.dll')
def EngBitBlt(psoTrg: POINTER(win32more.Windows.Win32.Devices.Display.SURFOBJ), psoSrc: POINTER(win32more.Windows.Win32.Devices.Display.SURFOBJ), psoMask: POINTER(win32more.Windows.Win32.Devices.Display.SURFOBJ), pco: POINTER(win32more.Windows.Win32.Devices.Display.CLIPOBJ), pxlo: POINTER(win32more.Windows.Win32.Devices.Display.XLATEOBJ), prclTrg: POINTER(win32more.Windows.Win32.Foundation.RECTL), pptlSrc: POINTER(win32more.Windows.Win32.Foundation.POINTL), pptlMask: POINTER(win32more.Windows.Win32.Foundation.POINTL), pbo: POINTER(win32more.Windows.Win32.Devices.Display.BRUSHOBJ), pptlBrush: POINTER(win32more.Windows.Win32.Foundation.POINTL), rop4: UInt32) -> win32more.Windows.Win32.Foundation.BOOL: ...
@winfunctype('GDI32.dll')
def EngLineTo(pso: POINTER(win32more.Windows.Win32.Devices.Display.SURFOBJ), pco: POINTER(win32more.Windows.Win32.Devices.Display.CLIPOBJ), pbo: POINTER(win32more.Windows.Win32.Devices.Display.BRUSHOBJ), x1: Int32, y1: Int32, x2: Int32, y2: Int32, prclBounds: POINTER(win32more.Windows.Win32.Foundation.RECTL), mix: UInt32) -> win32more.Windows.Win32.Foundation.BOOL: ...
@winfunctype('GDI32.dll')
def EngStretchBlt(psoDest: POINTER(win32more.Windows.Win32.Devices.Display.SURFOBJ), psoSrc: POINTER(win32more.Windows.Win32.Devices.Display.SURFOBJ), psoMask: POINTER(win32more.Windows.Win32.Devices.Display.SURFOBJ), pco: POINTER(win32more.Windows.Win32.Devices.Display.CLIPOBJ), pxlo: POINTER(win32more.Windows.Win32.Devices.Display.XLATEOBJ), pca: POINTER(win32more.Windows.Win32.Graphics.Gdi.COLORADJUSTMENT), pptlHTOrg: POINTER(win32more.Windows.Win32.Foundation.POINTL), prclDest: POINTER(win32more.Windows.Win32.Foundation.RECTL), prclSrc: POINTER(win32more.Windows.Win32.Foundation.RECTL), pptlMask: POINTER(win32more.Windows.Win32.Foundation.POINTL), iMode: UInt32) -> win32more.Windows.Win32.Foundation.BOOL: ...
@winfunctype('GDI32.dll')
def EngStretchBltROP(psoDest: POINTER(win32more.Windows.Win32.Devices.Display.SURFOBJ), psoSrc: POINTER(win32more.Windows.Win32.Devices.Display.SURFOBJ), psoMask: POINTER(win32more.Windows.Win32.Devices.Display.SURFOBJ), pco: POINTER(win32more.Windows.Win32.Devices.Display.CLIPOBJ), pxlo: POINTER(win32more.Windows.Win32.Devices.Display.XLATEOBJ), pca: POINTER(win32more.Windows.Win32.Graphics.Gdi.COLORADJUSTMENT), pptlHTOrg: POINTER(win32more.Windows.Win32.Foundation.POINTL), prclDest: POINTER(win32more.Windows.Win32.Foundation.RECTL), prclSrc: POINTER(win32more.Windows.Win32.Foundation.RECTL), pptlMask: POINTER(win32more.Windows.Win32.Foundation.POINTL), iMode: UInt32, pbo: POINTER(win32more.Windows.Win32.Devices.Display.BRUSHOBJ), rop4: UInt32) -> win32more.Windows.Win32.Foundation.BOOL: ...
@winfunctype('GDI32.dll')
def EngAlphaBlend(psoDest: POINTER(win32more.Windows.Win32.Devices.Display.SURFOBJ), psoSrc: POINTER(win32more.Windows.Win32.Devices.Display.SURFOBJ), pco: POINTER(win32more.Windows.Win32.Devices.Display.CLIPOBJ), pxlo: POINTER(win32more.Windows.Win32.Devices.Display.XLATEOBJ), prclDest: POINTER(win32more.Windows.Win32.Foundation.RECTL), prclSrc: POINTER(win32more.Windows.Win32.Foundation.RECTL), pBlendObj: POINTER(win32more.Windows.Win32.Devices.Display.BLENDOBJ)) -> win32more.Windows.Win32.Foundation.BOOL: ...
@winfunctype('GDI32.dll')
def EngGradientFill(psoDest: POINTER(win32more.Windows.Win32.Devices.Display.SURFOBJ), pco: POINTER(win32more.Windows.Win32.Devices.Display.CLIPOBJ), pxlo: POINTER(win32more.Windows.Win32.Devices.Display.XLATEOBJ), pVertex: POINTER(win32more.Windows.Win32.Graphics.Gdi.TRIVERTEX), nVertex: UInt32, pMesh: VoidPtr, nMesh: UInt32, prclExtents: POINTER(win32more.Windows.Win32.Foundation.RECTL), pptlDitherOrg: POINTER(win32more.Windows.Win32.Foundation.POINTL), ulMode: UInt32) -> win32more.Windows.Win32.Foundation.BOOL: ...
@winfunctype('GDI32.dll')
def EngTransparentBlt(psoDst: POINTER(win32more.Windows.Win32.Devices.Display.SURFOBJ), psoSrc: POINTER(win32more.Windows.Win32.Devices.Display.SURFOBJ), pco: POINTER(win32more.Windows.Win32.Devices.Display.CLIPOBJ), pxlo: POINTER(win32more.Windows.Win32.Devices.Display.XLATEOBJ), prclDst: POINTER(win32more.Windows.Win32.Foundation.RECTL), prclSrc: POINTER(win32more.Windows.Win32.Foundation.RECTL), TransColor: UInt32, bCalledFromBitBlt: UInt32) -> win32more.Windows.Win32.Foundation.BOOL: ...
@winfunctype('GDI32.dll')
def EngTextOut(pso: POINTER(win32more.Windows.Win32.Devices.Display.SURFOBJ), pstro: POINTER(win32more.Windows.Win32.Devices.Display.STROBJ), pfo: POINTER(win32more.Windows.Win32.Devices.Display.FONTOBJ), pco: POINTER(win32more.Windows.Win32.Devices.Display.CLIPOBJ), prclExtra: POINTER(win32more.Windows.Win32.Foundation.RECTL), prclOpaque: POINTER(win32more.Windows.Win32.Foundation.RECTL), pboFore: POINTER(win32more.Windows.Win32.Devices.Display.BRUSHOBJ), pboOpaque: POINTER(win32more.Windows.Win32.Devices.Display.BRUSHOBJ), pptlOrg: POINTER(win32more.Windows.Win32.Foundation.POINTL), mix: UInt32) -> win32more.Windows.Win32.Foundation.BOOL: ...
@winfunctype('GDI32.dll')
def EngStrokePath(pso: POINTER(win32more.Windows.Win32.Devices.Display.SURFOBJ), ppo: POINTER(win32more.Windows.Win32.Devices.Display.PATHOBJ), pco: POINTER(win32more.Windows.Win32.Devices.Display.CLIPOBJ), pxo: POINTER(win32more.Windows.Win32.Devices.Display.XFORMOBJ), pbo: POINTER(win32more.Windows.Win32.Devices.Display.BRUSHOBJ), pptlBrushOrg: POINTER(win32more.Windows.Win32.Foundation.POINTL), plineattrs: POINTER(win32more.Windows.Win32.Devices.Display.LINEATTRS), mix: UInt32) -> win32more.Windows.Win32.Foundation.BOOL: ...
@winfunctype('GDI32.dll')
def EngFillPath(pso: POINTER(win32more.Windows.Win32.Devices.Display.SURFOBJ), ppo: POINTER(win32more.Windows.Win32.Devices.Display.PATHOBJ), pco: POINTER(win32more.Windows.Win32.Devices.Display.CLIPOBJ), pbo: POINTER(win32more.Windows.Win32.Devices.Display.BRUSHOBJ), pptlBrushOrg: POINTER(win32more.Windows.Win32.Foundation.POINTL), mix: UInt32, flOptions: UInt32) -> win32more.Windows.Win32.Foundation.BOOL: ...
@winfunctype('GDI32.dll')
def EngStrokeAndFillPath(pso: POINTER(win32more.Windows.Win32.Devices.Display.SURFOBJ), ppo: POINTER(win32more.Windows.Win32.Devices.Display.PATHOBJ), pco: POINTER(win32more.Windows.Win32.Devices.Display.CLIPOBJ), pxo: POINTER(win32more.Windows.Win32.Devices.Display.XFORMOBJ), pboStroke: POINTER(win32more.Windows.Win32.Devices.Display.BRUSHOBJ), plineattrs: POINTER(win32more.Windows.Win32.Devices.Display.LINEATTRS), pboFill: POINTER(win32more.Windows.Win32.Devices.Display.BRUSHOBJ), pptlBrushOrg: POINTER(win32more.Windows.Win32.Foundation.POINTL), mixFill: UInt32, flOptions: UInt32) -> win32more.Windows.Win32.Foundation.BOOL: ...
@winfunctype('GDI32.dll')
def EngPaint(pso: POINTER(win32more.Windows.Win32.Devices.Display.SURFOBJ), pco: POINTER(win32more.Windows.Win32.Devices.Display.CLIPOBJ), pbo: POINTER(win32more.Windows.Win32.Devices.Display.BRUSHOBJ), pptlBrushOrg: POINTER(win32more.Windows.Win32.Foundation.POINTL), mix: UInt32) -> win32more.Windows.Win32.Foundation.BOOL: ...
@winfunctype('GDI32.dll')
def EngCopyBits(psoDest: POINTER(win32more.Windows.Win32.Devices.Display.SURFOBJ), psoSrc: POINTER(win32more.Windows.Win32.Devices.Display.SURFOBJ), pco: POINTER(win32more.Windows.Win32.Devices.Display.CLIPOBJ), pxlo: POINTER(win32more.Windows.Win32.Devices.Display.XLATEOBJ), prclDest: POINTER(win32more.Windows.Win32.Foundation.RECTL), pptlSrc: POINTER(win32more.Windows.Win32.Foundation.POINTL)) -> win32more.Windows.Win32.Foundation.BOOL: ...
@winfunctype('GDI32.dll')
def EngPlgBlt(psoTrg: POINTER(win32more.Windows.Win32.Devices.Display.SURFOBJ), psoSrc: POINTER(win32more.Windows.Win32.Devices.Display.SURFOBJ), psoMsk: POINTER(win32more.Windows.Win32.Devices.Display.SURFOBJ), pco: POINTER(win32more.Windows.Win32.Devices.Display.CLIPOBJ), pxlo: POINTER(win32more.Windows.Win32.Devices.Display.XLATEOBJ), pca: POINTER(win32more.Windows.Win32.Graphics.Gdi.COLORADJUSTMENT), pptlBrushOrg: POINTER(win32more.Windows.Win32.Foundation.POINTL), pptfx: POINTER(win32more.Windows.Win32.Devices.Display.POINTFIX), prcl: POINTER(win32more.Windows.Win32.Foundation.RECTL), pptl: POINTER(win32more.Windows.Win32.Foundation.POINTL), iMode: UInt32) -> win32more.Windows.Win32.Foundation.BOOL: ...
@winfunctype('GDI32.dll')
def HT_Get8BPPFormatPalette(pPaletteEntry: POINTER(win32more.Windows.Win32.Graphics.Gdi.PALETTEENTRY), RedGamma: UInt16, GreenGamma: UInt16, BlueGamma: UInt16) -> Int32: ...
@winfunctype('GDI32.dll')
def HT_Get8BPPMaskPalette(pPaletteEntry: POINTER(win32more.Windows.Win32.Graphics.Gdi.PALETTEENTRY), Use8BPPMaskPal: win32more.Windows.Win32.Foundation.BOOL, CMYMask: Byte, RedGamma: UInt16, GreenGamma: UInt16, BlueGamma: UInt16) -> Int32: ...
@winfunctype('GDI32.dll')
def EngGetPrinterDataFileName(hdev: win32more.Windows.Win32.Devices.Display.HDEV) -> win32more.Windows.Win32.Foundation.PWSTR: ...
@winfunctype('GDI32.dll')
def EngGetDriverName(hdev: win32more.Windows.Win32.Devices.Display.HDEV) -> win32more.Windows.Win32.Foundation.PWSTR: ...
@winfunctype('GDI32.dll')
def EngLoadModule(pwsz: win32more.Windows.Win32.Foundation.PWSTR) -> win32more.Windows.Win32.Foundation.HANDLE: ...
@winfunctype('GDI32.dll')
def EngFindResource(h: win32more.Windows.Win32.Foundation.HANDLE, iName: Int32, iType: Int32, pulSize: POINTER(UInt32)) -> VoidPtr: ...
@winfunctype('GDI32.dll')
def EngFreeModule(h: win32more.Windows.Win32.Foundation.HANDLE) -> Void: ...
@winfunctype('GDI32.dll')
def EngCreateSemaphore() -> win32more.Windows.Win32.Devices.Display.HSEMAPHORE: ...
@winfunctype('GDI32.dll')
def EngAcquireSemaphore(hsem: win32more.Windows.Win32.Devices.Display.HSEMAPHORE) -> Void: ...
@winfunctype('GDI32.dll')
def EngReleaseSemaphore(hsem: win32more.Windows.Win32.Devices.Display.HSEMAPHORE) -> Void: ...
@winfunctype('GDI32.dll')
def EngDeleteSemaphore(hsem: win32more.Windows.Win32.Devices.Display.HSEMAPHORE) -> Void: ...
@winfunctype('GDI32.dll')
def EngMultiByteToUnicodeN(UnicodeString: win32more.Windows.Win32.Foundation.PWSTR, MaxBytesInUnicodeString: UInt32, BytesInUnicodeString: POINTER(UInt32), MultiByteString: win32more.Windows.Win32.Foundation.PSTR, BytesInMultiByteString: UInt32) -> Void: ...
@winfunctype('GDI32.dll')
def EngUnicodeToMultiByteN(MultiByteString: win32more.Windows.Win32.Foundation.PSTR, MaxBytesInMultiByteString: UInt32, BytesInMultiByteString: POINTER(UInt32), UnicodeString: win32more.Windows.Win32.Foundation.PWSTR, BytesInUnicodeString: UInt32) -> Void: ...
@winfunctype('GDI32.dll')
def EngQueryLocalTime(param0: POINTER(win32more.Windows.Win32.Devices.Display.ENG_TIME_FIELDS)) -> Void: ...
@winfunctype('GDI32.dll')
def EngComputeGlyphSet(nCodePage: Int32, nFirstChar: Int32, cChars: Int32) -> POINTER(win32more.Windows.Win32.Devices.Display.FD_GLYPHSET): ...
@winfunctype('GDI32.dll')
def EngMultiByteToWideChar(CodePage: UInt32, WideCharString: win32more.Windows.Win32.Foundation.PWSTR, BytesInWideCharString: Int32, MultiByteString: win32more.Windows.Win32.Foundation.PSTR, BytesInMultiByteString: Int32) -> Int32: ...
@winfunctype('GDI32.dll')
def EngWideCharToMultiByte(CodePage: UInt32, WideCharString: win32more.Windows.Win32.Foundation.PWSTR, BytesInWideCharString: Int32, MultiByteString: win32more.Windows.Win32.Foundation.PSTR, BytesInMultiByteString: Int32) -> Int32: ...
@winfunctype('GDI32.dll')
def EngGetCurrentCodePage(OemCodePage: POINTER(UInt16), AnsiCodePage: POINTER(UInt16)) -> Void: ...
@winfunctype('GDI32.dll')
def EngQueryEMFInfo(hdev: win32more.Windows.Win32.Devices.Display.HDEV, pEMFInfo: POINTER(win32more.Windows.Win32.Devices.Display.EMFINFO)) -> win32more.Windows.Win32.Foundation.BOOL: ...
@winfunctype('USER32.dll')
def GetDisplayConfigBufferSizes(flags: win32more.Windows.Win32.Devices.Display.QUERY_DISPLAY_CONFIG_FLAGS, numPathArrayElements: POINTER(UInt32), numModeInfoArrayElements: POINTER(UInt32)) -> win32more.Windows.Win32.Foundation.WIN32_ERROR: ...
@winfunctype('USER32.dll')
def SetDisplayConfig(numPathArrayElements: UInt32, pathArray: POINTER(win32more.Windows.Win32.Devices.Display.DISPLAYCONFIG_PATH_INFO), numModeInfoArrayElements: UInt32, modeInfoArray: POINTER(win32more.Windows.Win32.Devices.Display.DISPLAYCONFIG_MODE_INFO), flags: win32more.Windows.Win32.Devices.Display.SET_DISPLAY_CONFIG_FLAGS) -> Int32: ...
@winfunctype('USER32.dll')
def QueryDisplayConfig(flags: win32more.Windows.Win32.Devices.Display.QUERY_DISPLAY_CONFIG_FLAGS, numPathArrayElements: POINTER(UInt32), pathArray: POINTER(win32more.Windows.Win32.Devices.Display.DISPLAYCONFIG_PATH_INFO), numModeInfoArrayElements: POINTER(UInt32), modeInfoArray: POINTER(win32more.Windows.Win32.Devices.Display.DISPLAYCONFIG_MODE_INFO), currentTopologyId: POINTER(win32more.Windows.Win32.Devices.Display.DISPLAYCONFIG_TOPOLOGY_ID)) -> win32more.Windows.Win32.Foundation.WIN32_ERROR: ...
@winfunctype('USER32.dll')
def DisplayConfigGetDeviceInfo(requestPacket: POINTER(win32more.Windows.Win32.Devices.Display.DISPLAYCONFIG_DEVICE_INFO_HEADER)) -> Int32: ...
@winfunctype('USER32.dll')
def DisplayConfigSetDeviceInfo(setPacket: POINTER(win32more.Windows.Win32.Devices.Display.DISPLAYCONFIG_DEVICE_INFO_HEADER)) -> Int32: ...
@winfunctype('USER32.dll')
def GetAutoRotationState(pState: POINTER(win32more.Windows.Win32.Devices.Display.AR_STATE)) -> win32more.Windows.Win32.Foundation.BOOL: ...
@winfunctype('USER32.dll')
def GetDisplayAutoRotationPreferences(pOrientation: POINTER(win32more.Windows.Win32.Devices.Display.ORIENTATION_PREFERENCE)) -> win32more.Windows.Win32.Foundation.BOOL: ...
@winfunctype('USER32.dll')
def SetDisplayAutoRotationPreferences(orientation: win32more.Windows.Win32.Devices.Display.ORIENTATION_PREFERENCE) -> win32more.Windows.Win32.Foundation.BOOL: ...
BACKLIGHT_OPTIMIZATION_LEVEL = Int32
BacklightOptimizationDisable: win32more.Windows.Win32.Devices.Display.BACKLIGHT_OPTIMIZATION_LEVEL = 0
BacklightOptimizationDesktop: win32more.Windows.Win32.Devices.Display.BACKLIGHT_OPTIMIZATION_LEVEL = 1
BacklightOptimizationDynamic: win32more.Windows.Win32.Devices.Display.BACKLIGHT_OPTIMIZATION_LEVEL = 2
BacklightOptimizationDimmed: win32more.Windows.Win32.Devices.Display.BACKLIGHT_OPTIMIZATION_LEVEL = 3
BacklightOptimizationEDR: win32more.Windows.Win32.Devices.Display.BACKLIGHT_OPTIMIZATION_LEVEL = 4
class BACKLIGHT_REDUCTION_GAMMA_RAMP(Structure):
    R: UInt16 * 256
    G: UInt16 * 256
    B: UInt16 * 256
class BANK_POSITION(Structure):
    ReadBankPosition: UInt32
    WriteBankPosition: UInt32
class BLENDOBJ(Structure):
    BlendFunction: win32more.Windows.Win32.Graphics.Gdi.BLENDFUNCTION
BRIGHTNESS_INTERFACE_VERSION = Int32
BRIGHTNESS_INTERFACE_VERSION_1: win32more.Windows.Win32.Devices.Display.BRIGHTNESS_INTERFACE_VERSION = 1
BRIGHTNESS_INTERFACE_VERSION_2: win32more.Windows.Win32.Devices.Display.BRIGHTNESS_INTERFACE_VERSION = 2
BRIGHTNESS_INTERFACE_VERSION_3: win32more.Windows.Win32.Devices.Display.BRIGHTNESS_INTERFACE_VERSION = 3
class BRIGHTNESS_LEVEL(Structure):
    Count: Byte
    Level: Byte * 103
class BRIGHTNESS_NIT_RANGE(Structure):
    MinLevelInMillinit: UInt32
    MaxLevelInMillinit: UInt32
    StepSizeInMillinit: UInt32
class BRIGHTNESS_NIT_RANGES(Structure):
    NormalRangeCount: UInt32
    RangeCount: UInt32
    PreferredMaximumBrightness: UInt32
    SupportedRanges: win32more.Windows.Win32.Devices.Display.BRIGHTNESS_NIT_RANGE * 16
class BRUSHOBJ(Structure):
    iSolidColor: UInt32
    pvRbrush: VoidPtr
    flColorType: UInt32
BlackScreenDiagnosticsCalloutParam = Int32
BlackScreenDiagnosticsData: win32more.Windows.Win32.Devices.Display.BlackScreenDiagnosticsCalloutParam = 1
BlackScreenDisplayRecovery: win32more.Windows.Win32.Devices.Display.BlackScreenDiagnosticsCalloutParam = 2
class CDDDXGK_REDIRBITMAPPRESENTINFO(Structure):
    NumDirtyRects: UInt32
    DirtyRect: POINTER(win32more.Windows.Win32.Foundation.RECT)
    NumContexts: UInt32
    hContext: win32more.Windows.Win32.Foundation.HANDLE * 65
    bDoNotSynchronizeWithDxContent: win32more.Windows.Win32.Foundation.BOOLEAN
class CHAR_IMAGE_INFO(Structure):
    CharInfo: win32more.Windows.Win32.System.Console.CHAR_INFO
    FontImageInfo: win32more.Windows.Win32.Devices.Display.FONT_IMAGE_INFO
class CHROMATICITY_COORDINATE(Structure):
    x: Single
    y: Single
class CIECHROMA(Structure):
    x: Int32
    y: Int32
    Y: Int32
class CLIPLINE(Structure):
    ptfxA: win32more.Windows.Win32.Devices.Display.POINTFIX
    ptfxB: win32more.Windows.Win32.Devices.Display.POINTFIX
    lStyleState: Int32
    c: UInt32
    arun: FlexibleArray[win32more.Windows.Win32.Devices.Display.RUN]
class CLIPOBJ(Structure):
    iUniq: UInt32
    rclBounds: win32more.Windows.Win32.Foundation.RECTL
    iDComplexity: Byte
    iFComplexity: Byte
    iMode: Byte
    fjOptions: Byte
class COLORINFO(Structure):
    Red: win32more.Windows.Win32.Devices.Display.CIECHROMA
    Green: win32more.Windows.Win32.Devices.Display.CIECHROMA
    Blue: win32more.Windows.Win32.Devices.Display.CIECHROMA
    Cyan: win32more.Windows.Win32.Devices.Display.CIECHROMA
    Magenta: win32more.Windows.Win32.Devices.Display.CIECHROMA
    Yellow: win32more.Windows.Win32.Devices.Display.CIECHROMA
    AlignmentWhite: win32more.Windows.Win32.Devices.Display.CIECHROMA
    RedGamma: Int32
    GreenGamma: Int32
    BlueGamma: Int32
    MagentaInCyanDye: Int32
    YellowInCyanDye: Int32
    CyanInMagentaDye: Int32
    YellowInMagentaDye: Int32
    CyanInYellowDye: Int32
    MagentaInYellowDye: Int32
class COLORSPACE_TRANSFORM(Structure):
    Type: win32more.Windows.Win32.Devices.Display.COLORSPACE_TRANSFORM_TYPE
    Data: _Data_e__Union
    class _Data_e__Union(Union):
        Rgb256x3x16: win32more.Windows.Win32.Devices.Display.GAMMA_RAMP_RGB256x3x16
        Dxgi1: win32more.Windows.Win32.Devices.Display.GAMMA_RAMP_DXGI_1
        T3x4: win32more.Windows.Win32.Devices.Display.COLORSPACE_TRANSFORM_3x4
        MatrixV2: win32more.Windows.Win32.Devices.Display.COLORSPACE_TRANSFORM_MATRIX_V2
class COLORSPACE_TRANSFORM_1DLUT_CAP(Structure):
    NumberOfLUTEntries: UInt32
    DataCap: win32more.Windows.Win32.Devices.Display.COLORSPACE_TRANSFORM_DATA_CAP
class COLORSPACE_TRANSFORM_3x4(Structure):
    ColorMatrix3x4: Single * 12
    ScalarMultiplier: Single
    LookupTable1D: win32more.Windows.Win32.Devices.Display.GAMMA_RAMP_RGB * 4096
class COLORSPACE_TRANSFORM_DATA_CAP(Structure):
    DataType: win32more.Windows.Win32.Devices.Display.COLORSPACE_TRANSFORM_DATA_TYPE
    Anonymous: _Anonymous_e__Union
    NumericRangeMin: Single
    NumericRangeMax: Single
    _anonymous_ = ('Anonymous',)
    class _Anonymous_e__Union(Union):
        Anonymous1: _Anonymous1_e__Struct
        Anonymous2: _Anonymous2_e__Struct
        Value: UInt32
        _anonymous_ = ('Anonymous1', 'Anonymous2')
        class _Anonymous1_e__Struct(Structure):
            BitCountOfInteger: Annotated[UInt32, NativeBitfieldAttribute(6)]
            BitCountOfFraction: Annotated[UInt32, NativeBitfieldAttribute(6)]
        class _Anonymous2_e__Struct(Structure):
            BitCountOfExponent: Annotated[UInt32, NativeBitfieldAttribute(6)]
            BitCountOfMantissa: Annotated[UInt32, NativeBitfieldAttribute(6)]
COLORSPACE_TRANSFORM_DATA_TYPE = Int32
COLORSPACE_TRANSFORM_DATA_TYPE_FIXED_POINT: win32more.Windows.Win32.Devices.Display.COLORSPACE_TRANSFORM_DATA_TYPE = 0
COLORSPACE_TRANSFORM_DATA_TYPE_FLOAT: win32more.Windows.Win32.Devices.Display.COLORSPACE_TRANSFORM_DATA_TYPE = 1
class COLORSPACE_TRANSFORM_MATRIX_CAP(Structure):
    Anonymous: _Anonymous_e__Union
    DataCap: win32more.Windows.Win32.Devices.Display.COLORSPACE_TRANSFORM_DATA_CAP
    _anonymous_ = ('Anonymous',)
    class _Anonymous_e__Union(Union):
        Anonymous: _Anonymous_e__Struct
        Value: UInt32
        _anonymous_ = ('Anonymous',)
        class _Anonymous_e__Struct(Structure):
            MatrixSizeX: Annotated[UInt32, NativeBitfieldAttribute(10)]
            MatrixSizeY: Annotated[UInt32, NativeBitfieldAttribute(10)]
class COLORSPACE_TRANSFORM_MATRIX_V2(Structure):
    StageControlLookupTable1DDegamma: win32more.Windows.Win32.Devices.Display.COLORSPACE_TRANSFORM_STAGE_CONTROL
    LookupTable1DDegamma: win32more.Windows.Win32.Devices.Display.GAMMA_RAMP_RGB * 4096
    StageControlColorMatrix3x3: win32more.Windows.Win32.Devices.Display.COLORSPACE_TRANSFORM_STAGE_CONTROL
    ColorMatrix3x3: Single * 9
    StageControlLookupTable1DRegamma: win32more.Windows.Win32.Devices.Display.COLORSPACE_TRANSFORM_STAGE_CONTROL
    LookupTable1DRegamma: win32more.Windows.Win32.Devices.Display.GAMMA_RAMP_RGB * 4096
class COLORSPACE_TRANSFORM_SET_INPUT(Structure):
    OutputWireColorSpaceExpected: win32more.Windows.Win32.Devices.Display.OUTPUT_WIRE_COLOR_SPACE_TYPE
    OutputWireFormatExpected: win32more.Windows.Win32.Devices.Display.OUTPUT_WIRE_FORMAT
    ColorSpaceTransform: win32more.Windows.Win32.Devices.Display.COLORSPACE_TRANSFORM
COLORSPACE_TRANSFORM_STAGE_CONTROL = Int32
ColorSpaceTransformStageControl_No_Change: win32more.Windows.Win32.Devices.Display.COLORSPACE_TRANSFORM_STAGE_CONTROL = 0
ColorSpaceTransformStageControl_Enable: win32more.Windows.Win32.Devices.Display.COLORSPACE_TRANSFORM_STAGE_CONTROL = 1
ColorSpaceTransformStageControl_Bypass: win32more.Windows.Win32.Devices.Display.COLORSPACE_TRANSFORM_STAGE_CONTROL = 2
class COLORSPACE_TRANSFORM_TARGET_CAPS(Structure):
    Version: win32more.Windows.Win32.Devices.Display.COLORSPACE_TRANSFORM_TARGET_CAPS_VERSION
    LookupTable1DDegammaCap: win32more.Windows.Win32.Devices.Display.COLORSPACE_TRANSFORM_1DLUT_CAP
    ColorMatrix3x3Cap: win32more.Windows.Win32.Devices.Display.COLORSPACE_TRANSFORM_MATRIX_CAP
    LookupTable1DRegammaCap: win32more.Windows.Win32.Devices.Display.COLORSPACE_TRANSFORM_1DLUT_CAP
COLORSPACE_TRANSFORM_TARGET_CAPS_VERSION = Int32
COLORSPACE_TRANSFORM_VERSION_DEFAULT: win32more.Windows.Win32.Devices.Display.COLORSPACE_TRANSFORM_TARGET_CAPS_VERSION = 0
COLORSPACE_TRANSFORM_VERSION_1: win32more.Windows.Win32.Devices.Display.COLORSPACE_TRANSFORM_TARGET_CAPS_VERSION = 1
COLORSPACE_TRANSFORM_VERSION_NOT_SUPPORTED: win32more.Windows.Win32.Devices.Display.COLORSPACE_TRANSFORM_TARGET_CAPS_VERSION = 0
COLORSPACE_TRANSFORM_TYPE = Int32
COLORSPACE_TRANSFORM_TYPE_UNINITIALIZED: win32more.Windows.Win32.Devices.Display.COLORSPACE_TRANSFORM_TYPE = 0
COLORSPACE_TRANSFORM_TYPE_DEFAULT: win32more.Windows.Win32.Devices.Display.COLORSPACE_TRANSFORM_TYPE = 1
COLORSPACE_TRANSFORM_TYPE_RGB256x3x16: win32more.Windows.Win32.Devices.Display.COLORSPACE_TRANSFORM_TYPE = 2
COLORSPACE_TRANSFORM_TYPE_DXGI_1: win32more.Windows.Win32.Devices.Display.COLORSPACE_TRANSFORM_TYPE = 3
COLORSPACE_TRANSFORM_TYPE_MATRIX_3x4: win32more.Windows.Win32.Devices.Display.COLORSPACE_TRANSFORM_TYPE = 4
COLORSPACE_TRANSFORM_TYPE_MATRIX_V2: win32more.Windows.Win32.Devices.Display.COLORSPACE_TRANSFORM_TYPE = 5
class DEVHTADJDATA(Structure):
    DeviceFlags: UInt32
    DeviceXDPI: UInt32
    DeviceYDPI: UInt32
    pDefHTInfo: POINTER(win32more.Windows.Win32.Devices.Display.DEVHTINFO)
    pAdjHTInfo: POINTER(win32more.Windows.Win32.Devices.Display.DEVHTINFO)
class DEVHTINFO(Structure):
    HTFlags: UInt32
    HTPatternSize: UInt32
    DevPelsDPI: UInt32
    ColorInfo: win32more.Windows.Win32.Devices.Display.COLORINFO
class DEVINFO(Structure):
    flGraphicsCaps: UInt32
    lfDefaultFont: win32more.Windows.Win32.Graphics.Gdi.LOGFONTW
    lfAnsiVarFont: win32more.Windows.Win32.Graphics.Gdi.LOGFONTW
    lfAnsiFixFont: win32more.Windows.Win32.Graphics.Gdi.LOGFONTW
    cFonts: UInt32
    iDitherFormat: UInt32
    cxDither: UInt16
    cyDither: UInt16
    hpalDefault: win32more.Windows.Win32.Graphics.Gdi.HPALETTE
    flGraphicsCaps2: UInt32
DHPDEV = VoidPtr
DHSURF = VoidPtr
class DISPLAYCONFIG_2DREGION(Structure):
    cx: UInt32
    cy: UInt32
class DISPLAYCONFIG_ADAPTER_NAME(Structure):
    header: win32more.Windows.Win32.Devices.Display.DISPLAYCONFIG_DEVICE_INFO_HEADER
    adapterDevicePath: Char * 128
class DISPLAYCONFIG_DESKTOP_IMAGE_INFO(Structure):
    PathSourceSize: win32more.Windows.Win32.Foundation.POINTL
    DesktopImageRegion: win32more.Windows.Win32.Foundation.RECTL
    DesktopImageClip: win32more.Windows.Win32.Foundation.RECTL
class DISPLAYCONFIG_DEVICE_INFO_HEADER(Structure):
    type: win32more.Windows.Win32.Devices.Display.DISPLAYCONFIG_DEVICE_INFO_TYPE
    size: UInt32
    adapterId: win32more.Windows.Win32.Foundation.LUID
    id: UInt32
DISPLAYCONFIG_DEVICE_INFO_TYPE = Int32
DISPLAYCONFIG_DEVICE_INFO_GET_SOURCE_NAME: win32more.Windows.Win32.Devices.Display.DISPLAYCONFIG_DEVICE_INFO_TYPE = 1
DISPLAYCONFIG_DEVICE_INFO_GET_TARGET_NAME: win32more.Windows.Win32.Devices.Display.DISPLAYCONFIG_DEVICE_INFO_TYPE = 2
DISPLAYCONFIG_DEVICE_INFO_GET_TARGET_PREFERRED_MODE: win32more.Windows.Win32.Devices.Display.DISPLAYCONFIG_DEVICE_INFO_TYPE = 3
DISPLAYCONFIG_DEVICE_INFO_GET_ADAPTER_NAME: win32more.Windows.Win32.Devices.Display.DISPLAYCONFIG_DEVICE_INFO_TYPE = 4
DISPLAYCONFIG_DEVICE_INFO_SET_TARGET_PERSISTENCE: win32more.Windows.Win32.Devices.Display.DISPLAYCONFIG_DEVICE_INFO_TYPE = 5
DISPLAYCONFIG_DEVICE_INFO_GET_TARGET_BASE_TYPE: win32more.Windows.Win32.Devices.Display.DISPLAYCONFIG_DEVICE_INFO_TYPE = 6
DISPLAYCONFIG_DEVICE_INFO_GET_SUPPORT_VIRTUAL_RESOLUTION: win32more.Windows.Win32.Devices.Display.DISPLAYCONFIG_DEVICE_INFO_TYPE = 7
DISPLAYCONFIG_DEVICE_INFO_SET_SUPPORT_VIRTUAL_RESOLUTION: win32more.Windows.Win32.Devices.Display.DISPLAYCONFIG_DEVICE_INFO_TYPE = 8
DISPLAYCONFIG_DEVICE_INFO_GET_ADVANCED_COLOR_INFO: win32more.Windows.Win32.Devices.Display.DISPLAYCONFIG_DEVICE_INFO_TYPE = 9
DISPLAYCONFIG_DEVICE_INFO_SET_ADVANCED_COLOR_STATE: win32more.Windows.Win32.Devices.Display.DISPLAYCONFIG_DEVICE_INFO_TYPE = 10
DISPLAYCONFIG_DEVICE_INFO_GET_SDR_WHITE_LEVEL: win32more.Windows.Win32.Devices.Display.DISPLAYCONFIG_DEVICE_INFO_TYPE = 11
DISPLAYCONFIG_DEVICE_INFO_GET_MONITOR_SPECIALIZATION: win32more.Windows.Win32.Devices.Display.DISPLAYCONFIG_DEVICE_INFO_TYPE = 12
DISPLAYCONFIG_DEVICE_INFO_SET_MONITOR_SPECIALIZATION: win32more.Windows.Win32.Devices.Display.DISPLAYCONFIG_DEVICE_INFO_TYPE = 13
class DISPLAYCONFIG_GET_ADVANCED_COLOR_INFO(Structure):
    header: win32more.Windows.Win32.Devices.Display.DISPLAYCONFIG_DEVICE_INFO_HEADER
    Anonymous: _Anonymous_e__Union
    colorEncoding: win32more.Windows.Win32.Graphics.Gdi.DISPLAYCONFIG_COLOR_ENCODING
    bitsPerColorChannel: UInt32
    _anonymous_ = ('Anonymous',)
    class _Anonymous_e__Union(Union):
        Anonymous: _Anonymous_e__Struct
        value: UInt32
        _anonymous_ = ('Anonymous',)
        class _Anonymous_e__Struct(Structure):
            advancedColorSupported: Annotated[UInt32, NativeBitfieldAttribute(1)]
            advancedColorEnabled: Annotated[UInt32, NativeBitfieldAttribute(1)]
            wideColorEnforced: Annotated[UInt32, NativeBitfieldAttribute(1)]
            advancedColorForceDisabled: Annotated[UInt32, NativeBitfieldAttribute(1)]
            reserved: Annotated[UInt32, NativeBitfieldAttribute(28)]
class DISPLAYCONFIG_GET_MONITOR_SPECIALIZATION(Structure):
    header: win32more.Windows.Win32.Devices.Display.DISPLAYCONFIG_DEVICE_INFO_HEADER
    Anonymous: _Anonymous_e__Union
    _anonymous_ = ('Anonymous',)
    class _Anonymous_e__Union(Union):
        Anonymous: _Anonymous_e__Struct
        value: UInt32
        _anonymous_ = ('Anonymous',)
        class _Anonymous_e__Struct(Structure):
            isSpecializationEnabled: Annotated[UInt32, NativeBitfieldAttribute(1)]
            isSpecializationAvailableForMonitor: Annotated[UInt32, NativeBitfieldAttribute(1)]
            isSpecializationAvailableForSystem: Annotated[UInt32, NativeBitfieldAttribute(1)]
            reserved: Annotated[UInt32, NativeBitfieldAttribute(29)]
class DISPLAYCONFIG_MODE_INFO(Structure):
    infoType: win32more.Windows.Win32.Devices.Display.DISPLAYCONFIG_MODE_INFO_TYPE
    id: UInt32
    adapterId: win32more.Windows.Win32.Foundation.LUID
    Anonymous: _Anonymous_e__Union
    _anonymous_ = ('Anonymous',)
    class _Anonymous_e__Union(Union):
        targetMode: win32more.Windows.Win32.Devices.Display.DISPLAYCONFIG_TARGET_MODE
        sourceMode: win32more.Windows.Win32.Devices.Display.DISPLAYCONFIG_SOURCE_MODE
        desktopImageInfo: win32more.Windows.Win32.Devices.Display.DISPLAYCONFIG_DESKTOP_IMAGE_INFO
DISPLAYCONFIG_MODE_INFO_TYPE = Int32
DISPLAYCONFIG_MODE_INFO_TYPE_SOURCE: win32more.Windows.Win32.Devices.Display.DISPLAYCONFIG_MODE_INFO_TYPE = 1
DISPLAYCONFIG_MODE_INFO_TYPE_TARGET: win32more.Windows.Win32.Devices.Display.DISPLAYCONFIG_MODE_INFO_TYPE = 2
DISPLAYCONFIG_MODE_INFO_TYPE_DESKTOP_IMAGE: win32more.Windows.Win32.Devices.Display.DISPLAYCONFIG_MODE_INFO_TYPE = 3
class DISPLAYCONFIG_PATH_INFO(Structure):
    sourceInfo: win32more.Windows.Win32.Devices.Display.DISPLAYCONFIG_PATH_SOURCE_INFO
    targetInfo: win32more.Windows.Win32.Devices.Display.DISPLAYCONFIG_PATH_TARGET_INFO
    flags: UInt32
class DISPLAYCONFIG_PATH_SOURCE_INFO(Structure):
    adapterId: win32more.Windows.Win32.Foundation.LUID
    id: UInt32
    Anonymous: _Anonymous_e__Union
    statusFlags: UInt32
    _anonymous_ = ('Anonymous',)
    class _Anonymous_e__Union(Union):
        modeInfoIdx: UInt32
        Anonymous: _Anonymous_e__Struct
        _anonymous_ = ('Anonymous',)
        class _Anonymous_e__Struct(Structure):
            cloneGroupId: Annotated[UInt32, NativeBitfieldAttribute(16)]
            sourceModeInfoIdx: Annotated[UInt32, NativeBitfieldAttribute(16)]
class DISPLAYCONFIG_PATH_TARGET_INFO(Structure):
    adapterId: win32more.Windows.Win32.Foundation.LUID
    id: UInt32
    Anonymous: _Anonymous_e__Union
    outputTechnology: win32more.Windows.Win32.Devices.Display.DISPLAYCONFIG_VIDEO_OUTPUT_TECHNOLOGY
    rotation: win32more.Windows.Win32.Devices.Display.DISPLAYCONFIG_ROTATION
    scaling: win32more.Windows.Win32.Devices.Display.DISPLAYCONFIG_SCALING
    refreshRate: win32more.Windows.Win32.Devices.Display.DISPLAYCONFIG_RATIONAL
    scanLineOrdering: win32more.Windows.Win32.Devices.Display.DISPLAYCONFIG_SCANLINE_ORDERING
    targetAvailable: win32more.Windows.Win32.Foundation.BOOL
    statusFlags: UInt32
    _anonymous_ = ('Anonymous',)
    class _Anonymous_e__Union(Union):
        modeInfoIdx: UInt32
        Anonymous: _Anonymous_e__Struct
        _anonymous_ = ('Anonymous',)
        class _Anonymous_e__Struct(Structure):
            desktopModeInfoIdx: Annotated[UInt32, NativeBitfieldAttribute(16)]
            targetModeInfoIdx: Annotated[UInt32, NativeBitfieldAttribute(16)]
DISPLAYCONFIG_PIXELFORMAT = Int32
DISPLAYCONFIG_PIXELFORMAT_8BPP: win32more.Windows.Win32.Devices.Display.DISPLAYCONFIG_PIXELFORMAT = 1
DISPLAYCONFIG_PIXELFORMAT_16BPP: win32more.Windows.Win32.Devices.Display.DISPLAYCONFIG_PIXELFORMAT = 2
DISPLAYCONFIG_PIXELFORMAT_24BPP: win32more.Windows.Win32.Devices.Display.DISPLAYCONFIG_PIXELFORMAT = 3
DISPLAYCONFIG_PIXELFORMAT_32BPP: win32more.Windows.Win32.Devices.Display.DISPLAYCONFIG_PIXELFORMAT = 4
DISPLAYCONFIG_PIXELFORMAT_NONGDI: win32more.Windows.Win32.Devices.Display.DISPLAYCONFIG_PIXELFORMAT = 5
class DISPLAYCONFIG_RATIONAL(Structure):
    Numerator: UInt32
    Denominator: UInt32
DISPLAYCONFIG_ROTATION = Int32
DISPLAYCONFIG_ROTATION_IDENTITY: win32more.Windows.Win32.Devices.Display.DISPLAYCONFIG_ROTATION = 1
DISPLAYCONFIG_ROTATION_ROTATE90: win32more.Windows.Win32.Devices.Display.DISPLAYCONFIG_ROTATION = 2
DISPLAYCONFIG_ROTATION_ROTATE180: win32more.Windows.Win32.Devices.Display.DISPLAYCONFIG_ROTATION = 3
DISPLAYCONFIG_ROTATION_ROTATE270: win32more.Windows.Win32.Devices.Display.DISPLAYCONFIG_ROTATION = 4
DISPLAYCONFIG_SCALING = Int32
DISPLAYCONFIG_SCALING_IDENTITY: win32more.Windows.Win32.Devices.Display.DISPLAYCONFIG_SCALING = 1
DISPLAYCONFIG_SCALING_CENTERED: win32more.Windows.Win32.Devices.Display.DISPLAYCONFIG_SCALING = 2
DISPLAYCONFIG_SCALING_STRETCHED: win32more.Windows.Win32.Devices.Display.DISPLAYCONFIG_SCALING = 3
DISPLAYCONFIG_SCALING_ASPECTRATIOCENTEREDMAX: win32more.Windows.Win32.Devices.Display.DISPLAYCONFIG_SCALING = 4
DISPLAYCONFIG_SCALING_CUSTOM: win32more.Windows.Win32.Devices.Display.DISPLAYCONFIG_SCALING = 5
DISPLAYCONFIG_SCALING_PREFERRED: win32more.Windows.Win32.Devices.Display.DISPLAYCONFIG_SCALING = 128
DISPLAYCONFIG_SCANLINE_ORDERING = Int32
DISPLAYCONFIG_SCANLINE_ORDERING_UNSPECIFIED: win32more.Windows.Win32.Devices.Display.DISPLAYCONFIG_SCANLINE_ORDERING = 0
DISPLAYCONFIG_SCANLINE_ORDERING_PROGRESSIVE: win32more.Windows.Win32.Devices.Display.DISPLAYCONFIG_SCANLINE_ORDERING = 1
DISPLAYCONFIG_SCANLINE_ORDERING_INTERLACED: win32more.Windows.Win32.Devices.Display.DISPLAYCONFIG_SCANLINE_ORDERING = 2
DISPLAYCONFIG_SCANLINE_ORDERING_INTERLACED_UPPERFIELDFIRST: win32more.Windows.Win32.Devices.Display.DISPLAYCONFIG_SCANLINE_ORDERING = 2
DISPLAYCONFIG_SCANLINE_ORDERING_INTERLACED_LOWERFIELDFIRST: win32more.Windows.Win32.Devices.Display.DISPLAYCONFIG_SCANLINE_ORDERING = 3
class DISPLAYCONFIG_SDR_WHITE_LEVEL(Structure):
    header: win32more.Windows.Win32.Devices.Display.DISPLAYCONFIG_DEVICE_INFO_HEADER
    SDRWhiteLevel: UInt32
class DISPLAYCONFIG_SET_ADVANCED_COLOR_STATE(Structure):
    header: win32more.Windows.Win32.Devices.Display.DISPLAYCONFIG_DEVICE_INFO_HEADER
    Anonymous: _Anonymous_e__Union
    _anonymous_ = ('Anonymous',)
    class _Anonymous_e__Union(Union):
        Anonymous: _Anonymous_e__Struct
        value: UInt32
        _anonymous_ = ('Anonymous',)
        class _Anonymous_e__Struct(Structure):
            enableAdvancedColor: Annotated[UInt32, NativeBitfieldAttribute(1)]
            reserved: Annotated[UInt32, NativeBitfieldAttribute(31)]
class DISPLAYCONFIG_SET_MONITOR_SPECIALIZATION(Structure):
    header: win32more.Windows.Win32.Devices.Display.DISPLAYCONFIG_DEVICE_INFO_HEADER
    Anonymous: _Anonymous_e__Union
    specializationType: Guid
    specializationSubType: Guid
    specializationApplicationName: Char * 128
    _anonymous_ = ('Anonymous',)
    class _Anonymous_e__Union(Union):
        Anonymous: _Anonymous_e__Struct
        value: UInt32
        _anonymous_ = ('Anonymous',)
        class _Anonymous_e__Struct(Structure):
            isSpecializationEnabled: Annotated[UInt32, NativeBitfieldAttribute(1)]
            reserved: Annotated[UInt32, NativeBitfieldAttribute(31)]
class DISPLAYCONFIG_SET_TARGET_PERSISTENCE(Structure):
    header: win32more.Windows.Win32.Devices.Display.DISPLAYCONFIG_DEVICE_INFO_HEADER
    Anonymous: _Anonymous_e__Union
    _anonymous_ = ('Anonymous',)
    class _Anonymous_e__Union(Union):
        Anonymous: _Anonymous_e__Struct
        value: UInt32
        _anonymous_ = ('Anonymous',)
        class _Anonymous_e__Struct(Structure):
            bootPersistenceOn: Annotated[UInt32, NativeBitfieldAttribute(1)]
            reserved: Annotated[UInt32, NativeBitfieldAttribute(31)]
class DISPLAYCONFIG_SOURCE_DEVICE_NAME(Structure):
    header: win32more.Windows.Win32.Devices.Display.DISPLAYCONFIG_DEVICE_INFO_HEADER
    viewGdiDeviceName: Char * 32
class DISPLAYCONFIG_SOURCE_MODE(Structure):
    width: UInt32
    height: UInt32
    pixelFormat: win32more.Windows.Win32.Devices.Display.DISPLAYCONFIG_PIXELFORMAT
    position: win32more.Windows.Win32.Foundation.POINTL
class DISPLAYCONFIG_SUPPORT_VIRTUAL_RESOLUTION(Structure):
    header: win32more.Windows.Win32.Devices.Display.DISPLAYCONFIG_DEVICE_INFO_HEADER
    Anonymous: _Anonymous_e__Union
    _anonymous_ = ('Anonymous',)
    class _Anonymous_e__Union(Union):
        Anonymous: _Anonymous_e__Struct
        value: UInt32
        _anonymous_ = ('Anonymous',)
        class _Anonymous_e__Struct(Structure):
            disableMonitorVirtualResolution: Annotated[UInt32, NativeBitfieldAttribute(1)]
            reserved: Annotated[UInt32, NativeBitfieldAttribute(31)]
class DISPLAYCONFIG_TARGET_BASE_TYPE(Structure):
    header: win32more.Windows.Win32.Devices.Display.DISPLAYCONFIG_DEVICE_INFO_HEADER
    baseOutputTechnology: win32more.Windows.Win32.Devices.Display.DISPLAYCONFIG_VIDEO_OUTPUT_TECHNOLOGY
class DISPLAYCONFIG_TARGET_DEVICE_NAME(Structure):
    header: win32more.Windows.Win32.Devices.Display.DISPLAYCONFIG_DEVICE_INFO_HEADER
    flags: win32more.Windows.Win32.Devices.Display.DISPLAYCONFIG_TARGET_DEVICE_NAME_FLAGS
    outputTechnology: win32more.Windows.Win32.Devices.Display.DISPLAYCONFIG_VIDEO_OUTPUT_TECHNOLOGY
    edidManufactureId: UInt16
    edidProductCodeId: UInt16
    connectorInstance: UInt32
    monitorFriendlyDeviceName: Char * 64
    monitorDevicePath: Char * 128
class DISPLAYCONFIG_TARGET_DEVICE_NAME_FLAGS(Structure):
    Anonymous: _Anonymous_e__Union
    _anonymous_ = ('Anonymous',)
    class _Anonymous_e__Union(Union):
        Anonymous: _Anonymous_e__Struct
        value: UInt32
        _anonymous_ = ('Anonymous',)
        class _Anonymous_e__Struct(Structure):
            friendlyNameFromEdid: Annotated[UInt32, NativeBitfieldAttribute(1)]
            friendlyNameForced: Annotated[UInt32, NativeBitfieldAttribute(1)]
            edidIdsValid: Annotated[UInt32, NativeBitfieldAttribute(1)]
            reserved: Annotated[UInt32, NativeBitfieldAttribute(29)]
class DISPLAYCONFIG_TARGET_MODE(Structure):
    targetVideoSignalInfo: win32more.Windows.Win32.Devices.Display.DISPLAYCONFIG_VIDEO_SIGNAL_INFO
class DISPLAYCONFIG_TARGET_PREFERRED_MODE(Structure):
    header: win32more.Windows.Win32.Devices.Display.DISPLAYCONFIG_DEVICE_INFO_HEADER
    width: UInt32
    height: UInt32
    targetMode: win32more.Windows.Win32.Devices.Display.DISPLAYCONFIG_TARGET_MODE
DISPLAYCONFIG_TOPOLOGY_ID = Int32
DISPLAYCONFIG_TOPOLOGY_INTERNAL: win32more.Windows.Win32.Devices.Display.DISPLAYCONFIG_TOPOLOGY_ID = 1
DISPLAYCONFIG_TOPOLOGY_CLONE: win32more.Windows.Win32.Devices.Display.DISPLAYCONFIG_TOPOLOGY_ID = 2
DISPLAYCONFIG_TOPOLOGY_EXTEND: win32more.Windows.Win32.Devices.Display.DISPLAYCONFIG_TOPOLOGY_ID = 4
DISPLAYCONFIG_TOPOLOGY_EXTERNAL: win32more.Windows.Win32.Devices.Display.DISPLAYCONFIG_TOPOLOGY_ID = 8
DISPLAYCONFIG_VIDEO_OUTPUT_TECHNOLOGY = Int32
DISPLAYCONFIG_OUTPUT_TECHNOLOGY_OTHER: win32more.Windows.Win32.Devices.Display.DISPLAYCONFIG_VIDEO_OUTPUT_TECHNOLOGY = -1
DISPLAYCONFIG_OUTPUT_TECHNOLOGY_HD15: win32more.Windows.Win32.Devices.Display.DISPLAYCONFIG_VIDEO_OUTPUT_TECHNOLOGY = 0
DISPLAYCONFIG_OUTPUT_TECHNOLOGY_SVIDEO: win32more.Windows.Win32.Devices.Display.DISPLAYCONFIG_VIDEO_OUTPUT_TECHNOLOGY = 1
DISPLAYCONFIG_OUTPUT_TECHNOLOGY_COMPOSITE_VIDEO: win32more.Windows.Win32.Devices.Display.DISPLAYCONFIG_VIDEO_OUTPUT_TECHNOLOGY = 2
DISPLAYCONFIG_OUTPUT_TECHNOLOGY_COMPONENT_VIDEO: win32more.Windows.Win32.Devices.Display.DISPLAYCONFIG_VIDEO_OUTPUT_TECHNOLOGY = 3
DISPLAYCONFIG_OUTPUT_TECHNOLOGY_DVI: win32more.Windows.Win32.Devices.Display.DISPLAYCONFIG_VIDEO_OUTPUT_TECHNOLOGY = 4
DISPLAYCONFIG_OUTPUT_TECHNOLOGY_HDMI: win32more.Windows.Win32.Devices.Display.DISPLAYCONFIG_VIDEO_OUTPUT_TECHNOLOGY = 5
DISPLAYCONFIG_OUTPUT_TECHNOLOGY_LVDS: win32more.Windows.Win32.Devices.Display.DISPLAYCONFIG_VIDEO_OUTPUT_TECHNOLOGY = 6
DISPLAYCONFIG_OUTPUT_TECHNOLOGY_D_JPN: win32more.Windows.Win32.Devices.Display.DISPLAYCONFIG_VIDEO_OUTPUT_TECHNOLOGY = 8
DISPLAYCONFIG_OUTPUT_TECHNOLOGY_SDI: win32more.Windows.Win32.Devices.Display.DISPLAYCONFIG_VIDEO_OUTPUT_TECHNOLOGY = 9
DISPLAYCONFIG_OUTPUT_TECHNOLOGY_DISPLAYPORT_EXTERNAL: win32more.Windows.Win32.Devices.Display.DISPLAYCONFIG_VIDEO_OUTPUT_TECHNOLOGY = 10
DISPLAYCONFIG_OUTPUT_TECHNOLOGY_DISPLAYPORT_EMBEDDED: win32more.Windows.Win32.Devices.Display.DISPLAYCONFIG_VIDEO_OUTPUT_TECHNOLOGY = 11
DISPLAYCONFIG_OUTPUT_TECHNOLOGY_UDI_EXTERNAL: win32more.Windows.Win32.Devices.Display.DISPLAYCONFIG_VIDEO_OUTPUT_TECHNOLOGY = 12
DISPLAYCONFIG_OUTPUT_TECHNOLOGY_UDI_EMBEDDED: win32more.Windows.Win32.Devices.Display.DISPLAYCONFIG_VIDEO_OUTPUT_TECHNOLOGY = 13
DISPLAYCONFIG_OUTPUT_TECHNOLOGY_SDTVDONGLE: win32more.Windows.Win32.Devices.Display.DISPLAYCONFIG_VIDEO_OUTPUT_TECHNOLOGY = 14
DISPLAYCONFIG_OUTPUT_TECHNOLOGY_MIRACAST: win32more.Windows.Win32.Devices.Display.DISPLAYCONFIG_VIDEO_OUTPUT_TECHNOLOGY = 15
DISPLAYCONFIG_OUTPUT_TECHNOLOGY_INDIRECT_WIRED: win32more.Windows.Win32.Devices.Display.DISPLAYCONFIG_VIDEO_OUTPUT_TECHNOLOGY = 16
DISPLAYCONFIG_OUTPUT_TECHNOLOGY_INDIRECT_VIRTUAL: win32more.Windows.Win32.Devices.Display.DISPLAYCONFIG_VIDEO_OUTPUT_TECHNOLOGY = 17
DISPLAYCONFIG_OUTPUT_TECHNOLOGY_DISPLAYPORT_USB_TUNNEL: win32more.Windows.Win32.Devices.Display.DISPLAYCONFIG_VIDEO_OUTPUT_TECHNOLOGY = 18
DISPLAYCONFIG_OUTPUT_TECHNOLOGY_INTERNAL: win32more.Windows.Win32.Devices.Display.DISPLAYCONFIG_VIDEO_OUTPUT_TECHNOLOGY = -2147483648
class DISPLAYCONFIG_VIDEO_SIGNAL_INFO(Structure):
    pixelRate: UInt64
    hSyncFreq: win32more.Windows.Win32.Devices.Display.DISPLAYCONFIG_RATIONAL
    vSyncFreq: win32more.Windows.Win32.Devices.Display.DISPLAYCONFIG_RATIONAL
    activeSize: win32more.Windows.Win32.Devices.Display.DISPLAYCONFIG_2DREGION
    totalSize: win32more.Windows.Win32.Devices.Display.DISPLAYCONFIG_2DREGION
    Anonymous: _Anonymous_e__Union
    scanLineOrdering: win32more.Windows.Win32.Devices.Display.DISPLAYCONFIG_SCANLINE_ORDERING
    _anonymous_ = ('Anonymous',)
    class _Anonymous_e__Union(Union):
        AdditionalSignalInfo: _AdditionalSignalInfo_e__Struct
        videoStandard: UInt32
        class _AdditionalSignalInfo_e__Struct(Structure):
            videoStandard: Annotated[UInt32, NativeBitfieldAttribute(16)]
            vSyncFreqDivider: Annotated[UInt32, NativeBitfieldAttribute(6)]
            reserved: Annotated[UInt32, NativeBitfieldAttribute(10)]
class DISPLAY_BRIGHTNESS(Structure):
    ucDisplayPolicy: Byte
    ucACBrightness: Byte
    ucDCBrightness: Byte
class DRH_APIBITMAPDATA(Structure):
    pso: POINTER(win32more.Windows.Win32.Devices.Display.SURFOBJ)
    b: win32more.Windows.Win32.Foundation.BOOL
class DRIVEROBJ(Structure):
    pvObj: VoidPtr
    pFreeProc: win32more.Windows.Win32.Devices.Display.FREEOBJPROC
    hdev: win32more.Windows.Win32.Devices.Display.HDEV
    dhpdev: win32more.Windows.Win32.Devices.Display.DHPDEV
class DRVENABLEDATA(Structure):
    iDriverVersion: UInt32
    c: UInt32
    pdrvfn: POINTER(win32more.Windows.Win32.Devices.Display.DRVFN)
class DRVFN(Structure):
    iFunc: UInt32
    pfn: win32more.Windows.Win32.Devices.Display.PFN
DSI_CONTROL_TRANSMISSION_MODE = Int32
DCT_DEFAULT: win32more.Windows.Win32.Devices.Display.DSI_CONTROL_TRANSMISSION_MODE = 0
DCT_FORCE_LOW_POWER: win32more.Windows.Win32.Devices.Display.DSI_CONTROL_TRANSMISSION_MODE = 1
DCT_FORCE_HIGH_PERFORMANCE: win32more.Windows.Win32.Devices.Display.DSI_CONTROL_TRANSMISSION_MODE = 2
class DXGK_WIN32K_PARAM_DATA(Structure):
    PathsArray: VoidPtr
    ModesArray: VoidPtr
    NumPathArrayElements: UInt32
    NumModeArrayElements: UInt32
    SDCFlags: UInt32
class DisplayMode(Structure):
    DeviceName: Char * 32
    devMode: win32more.Windows.Win32.Graphics.Gdi.DEVMODEW
class DisplayModes(Structure):
    numDisplayModes: Int32
    displayMode: FlexibleArray[win32more.Windows.Win32.Devices.Display.DisplayMode]
class EMFINFO(Structure):
    nSize: UInt32
    hdc: win32more.Windows.Win32.Graphics.Gdi.HDC
    pvEMF: POINTER(Byte)
    pvCurrentRecord: POINTER(Byte)
class ENGSAFESEMAPHORE(Structure):
    hsem: win32more.Windows.Win32.Devices.Display.HSEMAPHORE
    lCount: Int32
ENG_DEVICE_ATTRIBUTE = Int32
QDA_RESERVED: win32more.Windows.Win32.Devices.Display.ENG_DEVICE_ATTRIBUTE = 0
QDA_ACCELERATION_LEVEL: win32more.Windows.Win32.Devices.Display.ENG_DEVICE_ATTRIBUTE = 1
class ENG_EVENT(Structure):
    pKEvent: VoidPtr
    fFlags: UInt32
ENG_SYSTEM_ATTRIBUTE = Int32
EngProcessorFeature: win32more.Windows.Win32.Devices.Display.ENG_SYSTEM_ATTRIBUTE = 1
EngNumberOfProcessors: win32more.Windows.Win32.Devices.Display.ENG_SYSTEM_ATTRIBUTE = 2
EngOptimumAvailableUserMemory: win32more.Windows.Win32.Devices.Display.ENG_SYSTEM_ATTRIBUTE = 3
EngOptimumAvailableSystemMemory: win32more.Windows.Win32.Devices.Display.ENG_SYSTEM_ATTRIBUTE = 4
class ENG_TIME_FIELDS(Structure):
    usYear: UInt16
    usMonth: UInt16
    usDay: UInt16
    usHour: UInt16
    usMinute: UInt16
    usSecond: UInt16
    usMilliseconds: UInt16
    usWeekday: UInt16
class ENUMRECTS(Structure):
    c: UInt32
    arcl: FlexibleArray[win32more.Windows.Win32.Foundation.RECTL]
class FD_DEVICEMETRICS(Structure):
    flRealizedType: UInt32
    pteBase: win32more.Windows.Win32.Devices.Display.POINTE
    pteSide: win32more.Windows.Win32.Devices.Display.POINTE
    lD: Int32
    fxMaxAscender: Int32
    fxMaxDescender: Int32
    ptlUnderline1: win32more.Windows.Win32.Foundation.POINTL
    ptlStrikeOut: win32more.Windows.Win32.Foundation.POINTL
    ptlULThickness: win32more.Windows.Win32.Foundation.POINTL
    ptlSOThickness: win32more.Windows.Win32.Foundation.POINTL
    cxMax: UInt32
    cyMax: UInt32
    cjGlyphMax: UInt32
    fdxQuantized: win32more.Windows.Win32.Devices.Display.FD_XFORM
    lNonLinearExtLeading: Int32
    lNonLinearIntLeading: Int32
    lNonLinearMaxCharWidth: Int32
    lNonLinearAvgCharWidth: Int32
    lMinA: Int32
    lMinC: Int32
    lMinD: Int32
    alReserved: FlexibleArray[Int32]
class FD_GLYPHATTR(Structure):
    cjThis: UInt32
    cGlyphs: UInt32
    iMode: UInt32
    aGlyphAttr: FlexibleArray[Byte]
class FD_GLYPHSET(Structure):
    cjThis: UInt32
    flAccel: UInt32
    cGlyphsSupported: UInt32
    cRuns: UInt32
    awcrun: FlexibleArray[win32more.Windows.Win32.Devices.Display.WCRUN]
class FD_KERNINGPAIR(Structure):
    wcFirst: Char
    wcSecond: Char
    fwdKern: Int16
class FD_LIGATURE(Structure):
    culThis: UInt32
    ulType: UInt32
    cLigatures: UInt32
    alig: FlexibleArray[win32more.Windows.Win32.Devices.Display.LIGATURE]
if ARCH in 'X64,ARM64':
    class FD_XFORM(Structure):
        eXX: Single
        eXY: Single
        eYX: Single
        eYY: Single
elif ARCH in 'X86':
    class FD_XFORM(Structure):
        eXX: UInt32
        eXY: UInt32
        eYX: UInt32
        eYY: UInt32
if ARCH in 'X86':
    class FLOATOBJ(Structure):
        ul1: UInt32
        ul2: UInt32
if ARCH in 'X64,ARM64':
    class FLOATOBJ_XFORM(Structure):
        eM11: Single
        eM12: Single
        eM21: Single
        eM22: Single
        eDx: Single
        eDy: Single
elif ARCH in 'X86':
    class FLOATOBJ_XFORM(Structure):
        eM11: win32more.Windows.Win32.Devices.Display.FLOATOBJ
        eM12: win32more.Windows.Win32.Devices.Display.FLOATOBJ
        eM21: win32more.Windows.Win32.Devices.Display.FLOATOBJ
        eM22: win32more.Windows.Win32.Devices.Display.FLOATOBJ
        eDx: win32more.Windows.Win32.Devices.Display.FLOATOBJ
        eDy: win32more.Windows.Win32.Devices.Display.FLOATOBJ
if ARCH in 'X64,ARM64':
    class FLOAT_LONG(Union):
        e: Single
        l: Int32
elif ARCH in 'X86':
    class FLOAT_LONG(Union):
        e: UInt32
        l: Int32
class FONTDIFF(Structure):
    jReserved1: Byte
    jReserved2: Byte
    jReserved3: Byte
    bWeight: Byte
    usWinWeight: UInt16
    fsSelection: UInt16
    fwdAveCharWidth: Int16
    fwdMaxCharInc: Int16
    ptlCaret: win32more.Windows.Win32.Foundation.POINTL
class FONTINFO(Structure):
    cjThis: UInt32
    flCaps: UInt32
    cGlyphsSupported: UInt32
    cjMaxGlyph1: UInt32
    cjMaxGlyph4: UInt32
    cjMaxGlyph8: UInt32
    cjMaxGlyph32: UInt32
class FONTOBJ(Structure):
    iUniq: UInt32
    iFace: UInt32
    cxMax: UInt32
    flFontType: UInt32
    iTTUniq: UIntPtr
    iFile: UIntPtr
    sizLogResPpi: win32more.Windows.Win32.Foundation.SIZE
    ulStyleSize: UInt32
    pvConsumer: VoidPtr
    pvProducer: VoidPtr
class FONTSIM(Structure):
    dpBold: Int32
    dpItalic: Int32
    dpBoldItalic: Int32
class FONT_IMAGE_INFO(Structure):
    FontSize: win32more.Windows.Win32.System.Console.COORD
    ImageBits: POINTER(Byte)
@winfunctype_pointer
def FREEOBJPROC(pDriverObj: POINTER(win32more.Windows.Win32.Devices.Display.DRIVEROBJ)) -> win32more.Windows.Win32.Foundation.BOOL: ...
class FSCNTL_SCREEN_INFO(Structure):
    Position: win32more.Windows.Win32.System.Console.COORD
    ScreenSize: win32more.Windows.Win32.System.Console.COORD
    nNumberOfChars: UInt32
class FSVIDEO_COPY_FRAME_BUFFER(Structure):
    SrcScreen: win32more.Windows.Win32.Devices.Display.FSCNTL_SCREEN_INFO
    DestScreen: win32more.Windows.Win32.Devices.Display.FSCNTL_SCREEN_INFO
class FSVIDEO_CURSOR_POSITION(Structure):
    Coord: win32more.Windows.Win32.Devices.Display.VIDEO_CURSOR_POSITION
    dwType: UInt32
class FSVIDEO_MODE_INFORMATION(Structure):
    VideoMode: win32more.Windows.Win32.Devices.Display.VIDEO_MODE_INFORMATION
    VideoMemory: win32more.Windows.Win32.Devices.Display.VIDEO_MEMORY_INFORMATION
class FSVIDEO_REVERSE_MOUSE_POINTER(Structure):
    Screen: win32more.Windows.Win32.Devices.Display.FSCNTL_SCREEN_INFO
    dwType: UInt32
class FSVIDEO_SCREEN_INFORMATION(Structure):
    ScreenSize: win32more.Windows.Win32.System.Console.COORD
    FontSize: win32more.Windows.Win32.System.Console.COORD
class FSVIDEO_WRITE_TO_FRAME_BUFFER(Structure):
    SrcBuffer: POINTER(win32more.Windows.Win32.Devices.Display.CHAR_IMAGE_INFO)
    DestScreen: win32more.Windows.Win32.Devices.Display.FSCNTL_SCREEN_INFO
class GAMMARAMP(Structure):
    Red: UInt16 * 256
    Green: UInt16 * 256
    Blue: UInt16 * 256
class GAMMA_RAMP_DXGI_1(Structure):
    Scale: win32more.Windows.Win32.Devices.Display.GAMMA_RAMP_RGB
    Offset: win32more.Windows.Win32.Devices.Display.GAMMA_RAMP_RGB
    GammaCurve: win32more.Windows.Win32.Devices.Display.GAMMA_RAMP_RGB * 1025
class GAMMA_RAMP_RGB(Structure):
    Red: Single
    Green: Single
    Blue: Single
class GAMMA_RAMP_RGB256x3x16(Structure):
    Red: UInt16 * 256
    Green: UInt16 * 256
    Blue: UInt16 * 256
class GDIINFO(Structure):
    ulVersion: UInt32
    ulTechnology: UInt32
    ulHorzSize: UInt32
    ulVertSize: UInt32
    ulHorzRes: UInt32
    ulVertRes: UInt32
    cBitsPixel: UInt32
    cPlanes: UInt32
    ulNumColors: UInt32
    flRaster: UInt32
    ulLogPixelsX: UInt32
    ulLogPixelsY: UInt32
    flTextCaps: UInt32
    ulDACRed: UInt32
    ulDACGreen: UInt32
    ulDACBlue: UInt32
    ulAspectX: UInt32
    ulAspectY: UInt32
    ulAspectXY: UInt32
    xStyleStep: Int32
    yStyleStep: Int32
    denStyleStep: Int32
    ptlPhysOffset: win32more.Windows.Win32.Foundation.POINTL
    szlPhysSize: win32more.Windows.Win32.Foundation.SIZE
    ulNumPalReg: UInt32
    ciDevice: win32more.Windows.Win32.Devices.Display.COLORINFO
    ulDevicePelsDPI: UInt32
    ulPrimaryOrder: UInt32
    ulHTPatternSize: UInt32
    ulHTOutputFormat: UInt32
    flHTFlags: UInt32
    ulVRefresh: UInt32
    ulBltAlignment: UInt32
    ulPanningHorzRes: UInt32
    ulPanningVertRes: UInt32
    xPanningAlignment: UInt32
    yPanningAlignment: UInt32
    cxHTPat: UInt32
    cyHTPat: UInt32
    pHTPatA: POINTER(Byte)
    pHTPatB: POINTER(Byte)
    pHTPatC: POINTER(Byte)
    flShadeBlend: UInt32
    ulPhysicalPixelCharacteristics: UInt32
    ulPhysicalPixelGamma: UInt32
class GLYPHBITS(Structure):
    ptlOrigin: win32more.Windows.Win32.Foundation.POINTL
    sizlBitmap: win32more.Windows.Win32.Foundation.SIZE
    aj: FlexibleArray[Byte]
class GLYPHDATA(Structure):
    gdf: win32more.Windows.Win32.Devices.Display.GLYPHDEF
    hg: UInt32
    fxD: Int32
    fxA: Int32
    fxAB: Int32
    fxInkTop: Int32
    fxInkBottom: Int32
    rclInk: win32more.Windows.Win32.Foundation.RECTL
    ptqD: win32more.Windows.Win32.Devices.Display.POINTQF
class GLYPHDEF(Union):
    pgb: POINTER(win32more.Windows.Win32.Devices.Display.GLYPHBITS)
    ppo: POINTER(win32more.Windows.Win32.Devices.Display.PATHOBJ)
class GLYPHPOS(Structure):
    hg: UInt32
    pgdf: POINTER(win32more.Windows.Win32.Devices.Display.GLYPHDEF)
    ptl: win32more.Windows.Win32.Foundation.POINTL
HBM = VoidPtr
HDEV = VoidPtr
HDRVOBJ = VoidPtr
HFASTMUTEX = VoidPtr
HSEMAPHORE = VoidPtr
HSURF = VoidPtr
class ICloneViewHelper(ComPtr):
    extends: win32more.Windows.Win32.System.Com.IUnknown
    _iid_ = Guid('{f6a3d4c4-5632-4d83-b0a1-fb88712b1eb7}')
    @commethod(3)
    def GetConnectedIDs(self, wszAdaptorName: win32more.Windows.Win32.Foundation.PWSTR, pulCount: POINTER(UInt32), pulID: POINTER(UInt32), ulFlags: UInt32) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(4)
    def GetActiveTopology(self, wszAdaptorName: win32more.Windows.Win32.Foundation.PWSTR, ulSourceID: UInt32, pulCount: POINTER(UInt32), pulTargetID: POINTER(UInt32)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(5)
    def SetActiveTopology(self, wszAdaptorName: win32more.Windows.Win32.Foundation.PWSTR, ulSourceID: UInt32, ulCount: UInt32, pulTargetID: POINTER(UInt32)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(6)
    def Commit(self, fFinalCall: win32more.Windows.Win32.Foundation.BOOL) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class IFIEXTRA(Structure):
    ulIdentifier: UInt32
    dpFontSig: Int32
    cig: UInt32
    dpDesignVector: Int32
    dpAxesInfoW: Int32
    aulReserved: FlexibleArray[UInt32]
if ARCH in 'X64,ARM64':
    class IFIMETRICS(Structure):
        cjThis: UInt32
        cjIfiExtra: UInt32
        dpwszFamilyName: Int32
        dpwszStyleName: Int32
        dpwszFaceName: Int32
        dpwszUniqueName: Int32
        dpFontSim: Int32
        lEmbedId: Int32
        lItalicAngle: Int32
        lCharBias: Int32
        dpCharSets: Int32
        jWinCharSet: Byte
        jWinPitchAndFamily: Byte
        usWinWeight: UInt16
        flInfo: UInt32
        fsSelection: UInt16
        fsType: UInt16
        fwdUnitsPerEm: Int16
        fwdLowestPPEm: Int16
        fwdWinAscender: Int16
        fwdWinDescender: Int16
        fwdMacAscender: Int16
        fwdMacDescender: Int16
        fwdMacLineGap: Int16
        fwdTypoAscender: Int16
        fwdTypoDescender: Int16
        fwdTypoLineGap: Int16
        fwdAveCharWidth: Int16
        fwdMaxCharInc: Int16
        fwdCapHeight: Int16
        fwdXHeight: Int16
        fwdSubscriptXSize: Int16
        fwdSubscriptYSize: Int16
        fwdSubscriptXOffset: Int16
        fwdSubscriptYOffset: Int16
        fwdSuperscriptXSize: Int16
        fwdSuperscriptYSize: Int16
        fwdSuperscriptXOffset: Int16
        fwdSuperscriptYOffset: Int16
        fwdUnderscoreSize: Int16
        fwdUnderscorePosition: Int16
        fwdStrikeoutSize: Int16
        fwdStrikeoutPosition: Int16
        chFirstChar: Byte
        chLastChar: Byte
        chDefaultChar: Byte
        chBreakChar: Byte
        wcFirstChar: Char
        wcLastChar: Char
        wcDefaultChar: Char
        wcBreakChar: Char
        ptlBaseline: win32more.Windows.Win32.Foundation.POINTL
        ptlAspect: win32more.Windows.Win32.Foundation.POINTL
        ptlCaret: win32more.Windows.Win32.Foundation.POINTL
        rclFontBox: win32more.Windows.Win32.Foundation.RECTL
        achVendId: Byte * 4
        cKerningPairs: UInt32
        ulPanoseCulture: UInt32
        panose: win32more.Windows.Win32.Graphics.Gdi.PANOSE
        Align: VoidPtr
elif ARCH in 'X86':
    class IFIMETRICS(Structure):
        cjThis: UInt32
        cjIfiExtra: UInt32
        dpwszFamilyName: Int32
        dpwszStyleName: Int32
        dpwszFaceName: Int32
        dpwszUniqueName: Int32
        dpFontSim: Int32
        lEmbedId: Int32
        lItalicAngle: Int32
        lCharBias: Int32
        dpCharSets: Int32
        jWinCharSet: Byte
        jWinPitchAndFamily: Byte
        usWinWeight: UInt16
        flInfo: UInt32
        fsSelection: UInt16
        fsType: UInt16
        fwdUnitsPerEm: Int16
        fwdLowestPPEm: Int16
        fwdWinAscender: Int16
        fwdWinDescender: Int16
        fwdMacAscender: Int16
        fwdMacDescender: Int16
        fwdMacLineGap: Int16
        fwdTypoAscender: Int16
        fwdTypoDescender: Int16
        fwdTypoLineGap: Int16
        fwdAveCharWidth: Int16
        fwdMaxCharInc: Int16
        fwdCapHeight: Int16
        fwdXHeight: Int16
        fwdSubscriptXSize: Int16
        fwdSubscriptYSize: Int16
        fwdSubscriptXOffset: Int16
        fwdSubscriptYOffset: Int16
        fwdSuperscriptXSize: Int16
        fwdSuperscriptYSize: Int16
        fwdSuperscriptXOffset: Int16
        fwdSuperscriptYOffset: Int16
        fwdUnderscoreSize: Int16
        fwdUnderscorePosition: Int16
        fwdStrikeoutSize: Int16
        fwdStrikeoutPosition: Int16
        chFirstChar: Byte
        chLastChar: Byte
        chDefaultChar: Byte
        chBreakChar: Byte
        wcFirstChar: Char
        wcLastChar: Char
        wcDefaultChar: Char
        wcBreakChar: Char
        ptlBaseline: win32more.Windows.Win32.Foundation.POINTL
        ptlAspect: win32more.Windows.Win32.Foundation.POINTL
        ptlCaret: win32more.Windows.Win32.Foundation.POINTL
        rclFontBox: win32more.Windows.Win32.Foundation.RECTL
        achVendId: Byte * 4
        cKerningPairs: UInt32
        ulPanoseCulture: UInt32
        panose: win32more.Windows.Win32.Graphics.Gdi.PANOSE
class INDIRECT_DISPLAY_INFO(Structure):
    DisplayAdapterLuid: win32more.Windows.Win32.Foundation.LUID
    Flags: UInt32
    NumMonitors: UInt32
    DisplayAdapterTargetBase: UInt32
class IViewHelper(ComPtr):
    extends: win32more.Windows.Win32.System.Com.IUnknown
    _iid_ = Guid('{e85ccef5-aaaa-47f0-b5e3-61f7aecdc4c1}')
    @commethod(3)
    def GetConnectedIDs(self, wszAdaptorName: win32more.Windows.Win32.Foundation.PWSTR, pulCount: POINTER(UInt32), pulID: POINTER(UInt32), ulFlags: UInt32) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(4)
    def GetActiveTopology(self, wszAdaptorName: win32more.Windows.Win32.Foundation.PWSTR, ulSourceID: UInt32, pulCount: POINTER(UInt32), pulTargetID: POINTER(UInt32)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(5)
    def SetActiveTopology(self, wszAdaptorName: win32more.Windows.Win32.Foundation.PWSTR, ulSourceID: UInt32, ulCount: UInt32, pulTargetID: POINTER(UInt32)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(6)
    def Commit(self) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(7)
    def SetConfiguration(self, pIStream: win32more.Windows.Win32.System.Com.IStream, pulStatus: POINTER(UInt32)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(8)
    def GetProceedOnNewConfiguration(self) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class LIGATURE(Structure):
    culSize: UInt32
    pwsz: win32more.Windows.Win32.Foundation.PWSTR
    chglyph: UInt32
    ahglyph: FlexibleArray[UInt32]
if ARCH in 'X64,ARM64':
    class LINEATTRS(Structure):
        fl: UInt32
        iJoin: UInt32
        iEndCap: UInt32
        elWidth: win32more.Windows.Win32.Devices.Display.FLOAT_LONG
        eMiterLimit: Single
        cstyle: UInt32
        pstyle: POINTER(win32more.Windows.Win32.Devices.Display.FLOAT_LONG)
        elStyleState: win32more.Windows.Win32.Devices.Display.FLOAT_LONG
elif ARCH in 'X86':
    class LINEATTRS(Structure):
        fl: UInt32
        iJoin: UInt32
        iEndCap: UInt32
        elWidth: win32more.Windows.Win32.Devices.Display.FLOAT_LONG
        eMiterLimit: UInt32
        cstyle: UInt32
        pstyle: POINTER(win32more.Windows.Win32.Devices.Display.FLOAT_LONG)
        elStyleState: win32more.Windows.Win32.Devices.Display.FLOAT_LONG
MC_COLOR_TEMPERATURE = Int32
MC_COLOR_TEMPERATURE_UNKNOWN: win32more.Windows.Win32.Devices.Display.MC_COLOR_TEMPERATURE = 0
MC_COLOR_TEMPERATURE_4000K: win32more.Windows.Win32.Devices.Display.MC_COLOR_TEMPERATURE = 1
MC_COLOR_TEMPERATURE_5000K: win32more.Windows.Win32.Devices.Display.MC_COLOR_TEMPERATURE = 2
MC_COLOR_TEMPERATURE_6500K: win32more.Windows.Win32.Devices.Display.MC_COLOR_TEMPERATURE = 3
MC_COLOR_TEMPERATURE_7500K: win32more.Windows.Win32.Devices.Display.MC_COLOR_TEMPERATURE = 4
MC_COLOR_TEMPERATURE_8200K: win32more.Windows.Win32.Devices.Display.MC_COLOR_TEMPERATURE = 5
MC_COLOR_TEMPERATURE_9300K: win32more.Windows.Win32.Devices.Display.MC_COLOR_TEMPERATURE = 6
MC_COLOR_TEMPERATURE_10000K: win32more.Windows.Win32.Devices.Display.MC_COLOR_TEMPERATURE = 7
MC_COLOR_TEMPERATURE_11500K: win32more.Windows.Win32.Devices.Display.MC_COLOR_TEMPERATURE = 8
MC_DISPLAY_TECHNOLOGY_TYPE = Int32
MC_SHADOW_MASK_CATHODE_RAY_TUBE: win32more.Windows.Win32.Devices.Display.MC_DISPLAY_TECHNOLOGY_TYPE = 0
MC_APERTURE_GRILL_CATHODE_RAY_TUBE: win32more.Windows.Win32.Devices.Display.MC_DISPLAY_TECHNOLOGY_TYPE = 1
MC_THIN_FILM_TRANSISTOR: win32more.Windows.Win32.Devices.Display.MC_DISPLAY_TECHNOLOGY_TYPE = 2
MC_LIQUID_CRYSTAL_ON_SILICON: win32more.Windows.Win32.Devices.Display.MC_DISPLAY_TECHNOLOGY_TYPE = 3
MC_PLASMA: win32more.Windows.Win32.Devices.Display.MC_DISPLAY_TECHNOLOGY_TYPE = 4
MC_ORGANIC_LIGHT_EMITTING_DIODE: win32more.Windows.Win32.Devices.Display.MC_DISPLAY_TECHNOLOGY_TYPE = 5
MC_ELECTROLUMINESCENT: win32more.Windows.Win32.Devices.Display.MC_DISPLAY_TECHNOLOGY_TYPE = 6
MC_MICROELECTROMECHANICAL: win32more.Windows.Win32.Devices.Display.MC_DISPLAY_TECHNOLOGY_TYPE = 7
MC_FIELD_EMISSION_DEVICE: win32more.Windows.Win32.Devices.Display.MC_DISPLAY_TECHNOLOGY_TYPE = 8
MC_DRIVE_TYPE = Int32
MC_RED_DRIVE: win32more.Windows.Win32.Devices.Display.MC_DRIVE_TYPE = 0
MC_GREEN_DRIVE: win32more.Windows.Win32.Devices.Display.MC_DRIVE_TYPE = 1
MC_BLUE_DRIVE: win32more.Windows.Win32.Devices.Display.MC_DRIVE_TYPE = 2
MC_GAIN_TYPE = Int32
MC_RED_GAIN: win32more.Windows.Win32.Devices.Display.MC_GAIN_TYPE = 0
MC_GREEN_GAIN: win32more.Windows.Win32.Devices.Display.MC_GAIN_TYPE = 1
MC_BLUE_GAIN: win32more.Windows.Win32.Devices.Display.MC_GAIN_TYPE = 2
MC_POSITION_TYPE = Int32
MC_HORIZONTAL_POSITION: win32more.Windows.Win32.Devices.Display.MC_POSITION_TYPE = 0
MC_VERTICAL_POSITION: win32more.Windows.Win32.Devices.Display.MC_POSITION_TYPE = 1
MC_SIZE_TYPE = Int32
MC_WIDTH: win32more.Windows.Win32.Devices.Display.MC_SIZE_TYPE = 0
MC_HEIGHT: win32more.Windows.Win32.Devices.Display.MC_SIZE_TYPE = 1
class MC_TIMING_REPORT(Structure):
    dwHorizontalFrequencyInHZ: UInt32
    dwVerticalFrequencyInHZ: UInt32
    bTimingStatusByte: Byte
    _pack_ = 1
MC_VCP_CODE_TYPE = Int32
MC_MOMENTARY: win32more.Windows.Win32.Devices.Display.MC_VCP_CODE_TYPE = 0
MC_SET_PARAMETER: win32more.Windows.Win32.Devices.Display.MC_VCP_CODE_TYPE = 1
class MIPI_DSI_CAPS(Structure):
    DSITypeMajor: Byte
    DSITypeMinor: Byte
    SpecVersionMajor: Byte
    SpecVersionMinor: Byte
    SpecVersionPatch: Byte
    TargetMaximumReturnPacketSize: UInt16
    ResultCodeFlags: Byte
    ResultCodeStatus: Byte
    Revision: Byte
    Level: Byte
    DeviceClassHi: Byte
    DeviceClassLo: Byte
    ManufacturerHi: Byte
    ManufacturerLo: Byte
    ProductHi: Byte
    ProductLo: Byte
    LengthHi: Byte
    LengthLo: Byte
class MIPI_DSI_PACKET(Structure):
    Anonymous1: _Anonymous1_e__Union
    Anonymous2: _Anonymous2_e__Union
    EccFiller: Byte
    Payload: Byte * 8
    _anonymous_ = ('Anonymous1', 'Anonymous2')
    class _Anonymous1_e__Union(Union):
        DataId: Byte
        Anonymous: _Anonymous_e__Struct
        _anonymous_ = ('Anonymous',)
        class _Anonymous_e__Struct(Structure):
            DataType: Annotated[Byte, NativeBitfieldAttribute(6)]
            VirtualChannel: Annotated[Byte, NativeBitfieldAttribute(2)]
    class _Anonymous2_e__Union(Union):
        Anonymous: _Anonymous_e__Struct
        LongWriteWordCount: UInt16
        _anonymous_ = ('Anonymous',)
        class _Anonymous_e__Struct(Structure):
            Data0: Byte
            Data1: Byte
class MIPI_DSI_RESET(Structure):
    Flags: UInt32
    Anonymous: _Anonymous_e__Union
    _anonymous_ = ('Anonymous',)
    class _Anonymous_e__Union(Union):
        Anonymous: _Anonymous_e__Struct
        Results: UInt32
        _anonymous_ = ('Anonymous',)
        class _Anonymous_e__Struct(Structure):
            MipiErrors: Annotated[UInt32, NativeBitfieldAttribute(16)]
            ResetFailed: Annotated[UInt32, NativeBitfieldAttribute(1)]
            NeedModeSet: Annotated[UInt32, NativeBitfieldAttribute(1)]
class MIPI_DSI_TRANSMISSION(Structure):
    TotalBufferSize: UInt32
    PacketCount: Byte
    FailedPacket: Byte
    Anonymous: _Anonymous_e__Struct
    ReadWordCount: UInt16
    FinalCommandExtraPayload: UInt16
    MipiErrors: UInt16
    HostErrors: UInt16
    Packets: FlexibleArray[win32more.Windows.Win32.Devices.Display.MIPI_DSI_PACKET]
    _anonymous_ = ('Anonymous',)
    class _Anonymous_e__Struct(Structure):
        TransmissionMode: Annotated[UInt16, NativeBitfieldAttribute(2)]
        ReportMipiErrors: Annotated[UInt16, NativeBitfieldAttribute(1)]
        ClearMipiErrors: Annotated[UInt16, NativeBitfieldAttribute(1)]
        SecondaryPort: Annotated[UInt16, NativeBitfieldAttribute(1)]
        ManufacturingMode: Annotated[UInt16, NativeBitfieldAttribute(1)]
        Reserved: Annotated[UInt16, NativeBitfieldAttribute(10)]
ORIENTATION_PREFERENCE = Int32
ORIENTATION_PREFERENCE_NONE: win32more.Windows.Win32.Devices.Display.ORIENTATION_PREFERENCE = 0
ORIENTATION_PREFERENCE_LANDSCAPE: win32more.Windows.Win32.Devices.Display.ORIENTATION_PREFERENCE = 1
ORIENTATION_PREFERENCE_PORTRAIT: win32more.Windows.Win32.Devices.Display.ORIENTATION_PREFERENCE = 2
ORIENTATION_PREFERENCE_LANDSCAPE_FLIPPED: win32more.Windows.Win32.Devices.Display.ORIENTATION_PREFERENCE = 4
ORIENTATION_PREFERENCE_PORTRAIT_FLIPPED: win32more.Windows.Win32.Devices.Display.ORIENTATION_PREFERENCE = 8
OUTPUT_COLOR_ENCODING = Int32
OUTPUT_COLOR_ENCODING_RGB: win32more.Windows.Win32.Devices.Display.OUTPUT_COLOR_ENCODING = 0
OUTPUT_COLOR_ENCODING_YCBCR444: win32more.Windows.Win32.Devices.Display.OUTPUT_COLOR_ENCODING = 1
OUTPUT_COLOR_ENCODING_YCBCR422: win32more.Windows.Win32.Devices.Display.OUTPUT_COLOR_ENCODING = 2
OUTPUT_COLOR_ENCODING_YCBCR420: win32more.Windows.Win32.Devices.Display.OUTPUT_COLOR_ENCODING = 3
OUTPUT_COLOR_ENCODING_INTENSITY: win32more.Windows.Win32.Devices.Display.OUTPUT_COLOR_ENCODING = 4
OUTPUT_WIRE_COLOR_SPACE_TYPE = Int32
OUTPUT_WIRE_COLOR_SPACE_G22_P709: win32more.Windows.Win32.Devices.Display.OUTPUT_WIRE_COLOR_SPACE_TYPE = 0
OUTPUT_WIRE_COLOR_SPACE_RESERVED: win32more.Windows.Win32.Devices.Display.OUTPUT_WIRE_COLOR_SPACE_TYPE = 4
OUTPUT_WIRE_COLOR_SPACE_G2084_P2020: win32more.Windows.Win32.Devices.Display.OUTPUT_WIRE_COLOR_SPACE_TYPE = 12
OUTPUT_WIRE_COLOR_SPACE_G22_P709_WCG: win32more.Windows.Win32.Devices.Display.OUTPUT_WIRE_COLOR_SPACE_TYPE = 30
OUTPUT_WIRE_COLOR_SPACE_G22_P2020: win32more.Windows.Win32.Devices.Display.OUTPUT_WIRE_COLOR_SPACE_TYPE = 31
OUTPUT_WIRE_COLOR_SPACE_G2084_P2020_HDR10PLUS: win32more.Windows.Win32.Devices.Display.OUTPUT_WIRE_COLOR_SPACE_TYPE = 32
OUTPUT_WIRE_COLOR_SPACE_G2084_P2020_DVLL: win32more.Windows.Win32.Devices.Display.OUTPUT_WIRE_COLOR_SPACE_TYPE = 33
class OUTPUT_WIRE_FORMAT(Structure):
    ColorEncoding: win32more.Windows.Win32.Devices.Display.OUTPUT_COLOR_ENCODING
    BitsPerPixel: UInt32
class PALOBJ(Structure):
    ulReserved: UInt32
class PANEL_BRIGHTNESS_SENSOR_DATA(Structure):
    Anonymous: _Anonymous_e__Union
    AlsReading: Single
    ChromaticityCoordinate: win32more.Windows.Win32.Devices.Display.CHROMATICITY_COORDINATE
    ColorTemperature: Single
    _anonymous_ = ('Anonymous',)
    class _Anonymous_e__Union(Union):
        Anonymous: _Anonymous_e__Struct
        Value: UInt32
        _anonymous_ = ('Anonymous',)
        class _Anonymous_e__Struct(Structure):
            AlsReadingValid: Annotated[UInt32, NativeBitfieldAttribute(1)]
            ChromaticityCoordinateValid: Annotated[UInt32, NativeBitfieldAttribute(1)]
            ColorTemperatureValid: Annotated[UInt32, NativeBitfieldAttribute(1)]
            Reserved: Annotated[UInt32, NativeBitfieldAttribute(29)]
class PANEL_GET_BACKLIGHT_REDUCTION(Structure):
    BacklightUsersetting: UInt16
    BacklightEffective: UInt16
    GammaRamp: win32more.Windows.Win32.Devices.Display.BACKLIGHT_REDUCTION_GAMMA_RAMP
class PANEL_GET_BRIGHTNESS(Structure):
    Version: win32more.Windows.Win32.Devices.Display.BRIGHTNESS_INTERFACE_VERSION
    Anonymous: _Anonymous_e__Union
    _anonymous_ = ('Anonymous',)
    class _Anonymous_e__Union(Union):
        Level: Byte
        Anonymous: _Anonymous_e__Struct
        _anonymous_ = ('Anonymous',)
        class _Anonymous_e__Struct(Structure):
            CurrentInMillinits: UInt32
            TargetInMillinits: UInt32
class PANEL_QUERY_BRIGHTNESS_CAPS(Structure):
    Version: win32more.Windows.Win32.Devices.Display.BRIGHTNESS_INTERFACE_VERSION
    Anonymous: _Anonymous_e__Union
    _anonymous_ = ('Anonymous',)
    class _Anonymous_e__Union(Union):
        Anonymous: _Anonymous_e__Struct
        Value: UInt32
        _anonymous_ = ('Anonymous',)
        class _Anonymous_e__Struct(Structure):
            Smooth: Annotated[UInt32, NativeBitfieldAttribute(1)]
            Adaptive: Annotated[UInt32, NativeBitfieldAttribute(1)]
            NitsCalibrated: Annotated[UInt32, NativeBitfieldAttribute(1)]
            Reserved: Annotated[UInt32, NativeBitfieldAttribute(29)]
class PANEL_QUERY_BRIGHTNESS_RANGES(Structure):
    Version: win32more.Windows.Win32.Devices.Display.BRIGHTNESS_INTERFACE_VERSION
    Anonymous: _Anonymous_e__Union
    _anonymous_ = ('Anonymous',)
    class _Anonymous_e__Union(Union):
        BrightnessLevel: win32more.Windows.Win32.Devices.Display.BRIGHTNESS_LEVEL
        NitRanges: win32more.Windows.Win32.Devices.Display.BRIGHTNESS_NIT_RANGES
class PANEL_SET_BACKLIGHT_OPTIMIZATION(Structure):
    Level: win32more.Windows.Win32.Devices.Display.BACKLIGHT_OPTIMIZATION_LEVEL
class PANEL_SET_BRIGHTNESS(Structure):
    Version: win32more.Windows.Win32.Devices.Display.BRIGHTNESS_INTERFACE_VERSION
    Anonymous: _Anonymous_e__Union
    _anonymous_ = ('Anonymous',)
    class _Anonymous_e__Union(Union):
        Level: Byte
        Anonymous: _Anonymous_e__Struct
        _anonymous_ = ('Anonymous',)
        class _Anonymous_e__Struct(Structure):
            Millinits: UInt32
            TransitionTimeInMs: UInt32
            SensorData: win32more.Windows.Win32.Devices.Display.PANEL_BRIGHTNESS_SENSOR_DATA
class PANEL_SET_BRIGHTNESS_STATE(Structure):
    Anonymous: _Anonymous_e__Union
    _anonymous_ = ('Anonymous',)
    class _Anonymous_e__Union(Union):
        Anonymous: _Anonymous_e__Struct
        Value: UInt32
        _anonymous_ = ('Anonymous',)
        class _Anonymous_e__Struct(Structure):
            Smooth: Annotated[UInt32, NativeBitfieldAttribute(1)]
            Reserved: Annotated[UInt32, NativeBitfieldAttribute(31)]
class PATHDATA(Structure):
    flags: UInt32
    count: UInt32
    pptfx: POINTER(win32more.Windows.Win32.Devices.Display.POINTFIX)
class PATHOBJ(Structure):
    fl: UInt32
    cCurves: UInt32
class PERBANDINFO(Structure):
    bRepeatThisBand: win32more.Windows.Win32.Foundation.BOOL
    szlBand: win32more.Windows.Win32.Foundation.SIZE
    ulHorzRes: UInt32
    ulVertRes: UInt32
@winfunctype_pointer
def PFN() -> IntPtr: ...
@winfunctype_pointer
def PFN_DrvAccumulateD3DDirtyRect(param0: POINTER(win32more.Windows.Win32.Devices.Display.SURFOBJ), param1: POINTER(win32more.Windows.Win32.Devices.Display.CDDDXGK_REDIRBITMAPPRESENTINFO)) -> win32more.Windows.Win32.Foundation.BOOL: ...
@winfunctype_pointer
def PFN_DrvAlphaBlend(param0: POINTER(win32more.Windows.Win32.Devices.Display.SURFOBJ), param1: POINTER(win32more.Windows.Win32.Devices.Display.SURFOBJ), param2: POINTER(win32more.Windows.Win32.Devices.Display.CLIPOBJ), param3: POINTER(win32more.Windows.Win32.Devices.Display.XLATEOBJ), param4: POINTER(win32more.Windows.Win32.Foundation.RECTL), param5: POINTER(win32more.Windows.Win32.Foundation.RECTL), param6: POINTER(win32more.Windows.Win32.Devices.Display.BLENDOBJ)) -> win32more.Windows.Win32.Foundation.BOOL: ...
@winfunctype_pointer
def PFN_DrvAssertMode(param0: win32more.Windows.Win32.Devices.Display.DHPDEV, param1: win32more.Windows.Win32.Foundation.BOOL) -> win32more.Windows.Win32.Foundation.BOOL: ...
@winfunctype_pointer
def PFN_DrvAssociateSharedSurface(param0: POINTER(win32more.Windows.Win32.Devices.Display.SURFOBJ), param1: win32more.Windows.Win32.Foundation.HANDLE, param2: win32more.Windows.Win32.Foundation.HANDLE, param3: win32more.Windows.Win32.Foundation.SIZE) -> win32more.Windows.Win32.Foundation.BOOL: ...
@winfunctype_pointer
def PFN_DrvBitBlt(param0: POINTER(win32more.Windows.Win32.Devices.Display.SURFOBJ), param1: POINTER(win32more.Windows.Win32.Devices.Display.SURFOBJ), param2: POINTER(win32more.Windows.Win32.Devices.Display.SURFOBJ), param3: POINTER(win32more.Windows.Win32.Devices.Display.CLIPOBJ), param4: POINTER(win32more.Windows.Win32.Devices.Display.XLATEOBJ), param5: POINTER(win32more.Windows.Win32.Foundation.RECTL), param6: POINTER(win32more.Windows.Win32.Foundation.POINTL), param7: POINTER(win32more.Windows.Win32.Foundation.POINTL), param8: POINTER(win32more.Windows.Win32.Devices.Display.BRUSHOBJ), param9: POINTER(win32more.Windows.Win32.Foundation.POINTL), param10: UInt32) -> win32more.Windows.Win32.Foundation.BOOL: ...
@winfunctype_pointer
def PFN_DrvCompletePDEV(param0: win32more.Windows.Win32.Devices.Display.DHPDEV, param1: win32more.Windows.Win32.Devices.Display.HDEV) -> Void: ...
@winfunctype_pointer
def PFN_DrvCopyBits(param0: POINTER(win32more.Windows.Win32.Devices.Display.SURFOBJ), param1: POINTER(win32more.Windows.Win32.Devices.Display.SURFOBJ), param2: POINTER(win32more.Windows.Win32.Devices.Display.CLIPOBJ), param3: POINTER(win32more.Windows.Win32.Devices.Display.XLATEOBJ), param4: POINTER(win32more.Windows.Win32.Foundation.RECTL), param5: POINTER(win32more.Windows.Win32.Foundation.POINTL)) -> win32more.Windows.Win32.Foundation.BOOL: ...
@winfunctype_pointer
def PFN_DrvCreateDeviceBitmap(param0: win32more.Windows.Win32.Devices.Display.DHPDEV, param1: win32more.Windows.Win32.Foundation.SIZE, param2: UInt32) -> win32more.Windows.Win32.Graphics.Gdi.HBITMAP: ...
@winfunctype_pointer
def PFN_DrvCreateDeviceBitmapEx(param0: win32more.Windows.Win32.Devices.Display.DHPDEV, param1: win32more.Windows.Win32.Foundation.SIZE, param2: UInt32, param3: UInt32, param4: win32more.Windows.Win32.Devices.Display.DHSURF, param5: UInt32, param6: UInt32, param7: POINTER(win32more.Windows.Win32.Foundation.HANDLE)) -> win32more.Windows.Win32.Graphics.Gdi.HBITMAP: ...
@winfunctype_pointer
def PFN_DrvDeleteDeviceBitmap(param0: win32more.Windows.Win32.Devices.Display.DHSURF) -> Void: ...
@winfunctype_pointer
def PFN_DrvDeleteDeviceBitmapEx(param0: win32more.Windows.Win32.Devices.Display.DHSURF) -> Void: ...
@winfunctype_pointer
def PFN_DrvDeriveSurface(param0: POINTER(win32more.Windows.Win32.Graphics.DirectDraw.DD_DIRECTDRAW_GLOBAL), param1: POINTER(win32more.Windows.Win32.Graphics.DirectDraw.DD_SURFACE_LOCAL)) -> win32more.Windows.Win32.Graphics.Gdi.HBITMAP: ...
@winfunctype_pointer
def PFN_DrvDescribePixelFormat(param0: win32more.Windows.Win32.Devices.Display.DHPDEV, param1: Int32, param2: UInt32, param3: POINTER(win32more.Windows.Win32.Graphics.OpenGL.PIXELFORMATDESCRIPTOR)) -> Int32: ...
@winfunctype_pointer
def PFN_DrvDestroyFont(param0: POINTER(win32more.Windows.Win32.Devices.Display.FONTOBJ)) -> Void: ...
@winfunctype_pointer
def PFN_DrvDisableDirectDraw(param0: win32more.Windows.Win32.Devices.Display.DHPDEV) -> Void: ...
@winfunctype_pointer
def PFN_DrvDisableDriver() -> Void: ...
@winfunctype_pointer
def PFN_DrvDisablePDEV(param0: win32more.Windows.Win32.Devices.Display.DHPDEV) -> Void: ...
@winfunctype_pointer
def PFN_DrvDisableSurface(param0: win32more.Windows.Win32.Devices.Display.DHPDEV) -> Void: ...
@winfunctype_pointer
def PFN_DrvDitherColor(param0: win32more.Windows.Win32.Devices.Display.DHPDEV, param1: UInt32, param2: UInt32, param3: POINTER(UInt32)) -> UInt32: ...
@winfunctype_pointer
def PFN_DrvDrawEscape(param0: POINTER(win32more.Windows.Win32.Devices.Display.SURFOBJ), param1: UInt32, param2: POINTER(win32more.Windows.Win32.Devices.Display.CLIPOBJ), param3: POINTER(win32more.Windows.Win32.Foundation.RECTL), param4: UInt32, param5: VoidPtr) -> UInt32: ...
@winfunctype_pointer
def PFN_DrvEnableDirectDraw(param0: win32more.Windows.Win32.Devices.Display.DHPDEV, param1: POINTER(win32more.Windows.Win32.Graphics.DirectDraw.DD_CALLBACKS), param2: POINTER(win32more.Windows.Win32.Graphics.DirectDraw.DD_SURFACECALLBACKS), param3: POINTER(win32more.Windows.Win32.Graphics.DirectDraw.DD_PALETTECALLBACKS)) -> win32more.Windows.Win32.Foundation.BOOL: ...
@winfunctype_pointer
def PFN_DrvEnableDriver(param0: UInt32, param1: UInt32, param2: POINTER(win32more.Windows.Win32.Devices.Display.DRVENABLEDATA)) -> win32more.Windows.Win32.Foundation.BOOL: ...
@winfunctype_pointer
def PFN_DrvEnablePDEV(param0: POINTER(win32more.Windows.Win32.Graphics.Gdi.DEVMODEW), param1: win32more.Windows.Win32.Foundation.PWSTR, param2: UInt32, param3: POINTER(win32more.Windows.Win32.Devices.Display.HSURF), param4: UInt32, param5: POINTER(win32more.Windows.Win32.Devices.Display.GDIINFO), param6: UInt32, param7: POINTER(win32more.Windows.Win32.Devices.Display.DEVINFO), param8: win32more.Windows.Win32.Devices.Display.HDEV, param9: win32more.Windows.Win32.Foundation.PWSTR, param10: win32more.Windows.Win32.Foundation.HANDLE) -> win32more.Windows.Win32.Devices.Display.DHPDEV: ...
@winfunctype_pointer
def PFN_DrvEnableSurface(param0: win32more.Windows.Win32.Devices.Display.DHPDEV) -> win32more.Windows.Win32.Devices.Display.HSURF: ...
@winfunctype_pointer
def PFN_DrvEndDoc(pso: POINTER(win32more.Windows.Win32.Devices.Display.SURFOBJ), fl: UInt32) -> win32more.Windows.Win32.Foundation.BOOL: ...
@winfunctype_pointer
def PFN_DrvEndDxInterop(param0: POINTER(win32more.Windows.Win32.Devices.Display.SURFOBJ), param1: win32more.Windows.Win32.Foundation.BOOL, param2: POINTER(win32more.Windows.Win32.Foundation.BOOL), KernelModeDeviceHandle: VoidPtr) -> win32more.Windows.Win32.Foundation.BOOL: ...
@winfunctype_pointer
def PFN_DrvEscape(param0: POINTER(win32more.Windows.Win32.Devices.Display.SURFOBJ), param1: UInt32, param2: UInt32, param3: VoidPtr, param4: UInt32, param5: VoidPtr) -> UInt32: ...
@winfunctype_pointer
def PFN_DrvFillPath(param0: POINTER(win32more.Windows.Win32.Devices.Display.SURFOBJ), param1: POINTER(win32more.Windows.Win32.Devices.Display.PATHOBJ), param2: POINTER(win32more.Windows.Win32.Devices.Display.CLIPOBJ), param3: POINTER(win32more.Windows.Win32.Devices.Display.BRUSHOBJ), param4: POINTER(win32more.Windows.Win32.Foundation.POINTL), param5: UInt32, param6: UInt32) -> win32more.Windows.Win32.Foundation.BOOL: ...
@winfunctype_pointer
def PFN_DrvFontManagement(param0: POINTER(win32more.Windows.Win32.Devices.Display.SURFOBJ), param1: POINTER(win32more.Windows.Win32.Devices.Display.FONTOBJ), param2: UInt32, param3: UInt32, param4: VoidPtr, param5: UInt32, param6: VoidPtr) -> UInt32: ...
@winfunctype_pointer
def PFN_DrvFree(param0: VoidPtr, param1: UIntPtr) -> Void: ...
@winfunctype_pointer
def PFN_DrvGetDirectDrawInfo(param0: win32more.Windows.Win32.Devices.Display.DHPDEV, param1: POINTER(win32more.Windows.Win32.Graphics.DirectDraw.DD_HALINFO), param2: POINTER(UInt32), param3: POINTER(win32more.Windows.Win32.Graphics.DirectDraw.VIDEOMEMORY), param4: POINTER(UInt32), param5: POINTER(UInt32)) -> win32more.Windows.Win32.Foundation.BOOL: ...
@winfunctype_pointer
def PFN_DrvGetGlyphMode(dhpdev: win32more.Windows.Win32.Devices.Display.DHPDEV, pfo: POINTER(win32more.Windows.Win32.Devices.Display.FONTOBJ)) -> UInt32: ...
@winfunctype_pointer
def PFN_DrvGetModes(param0: win32more.Windows.Win32.Foundation.HANDLE, param1: UInt32, param2: POINTER(win32more.Windows.Win32.Graphics.Gdi.DEVMODEW)) -> UInt32: ...
@winfunctype_pointer
def PFN_DrvGetTrueTypeFile(param0: UIntPtr, param1: POINTER(UInt32)) -> VoidPtr: ...
@winfunctype_pointer
def PFN_DrvGradientFill(param0: POINTER(win32more.Windows.Win32.Devices.Display.SURFOBJ), param1: POINTER(win32more.Windows.Win32.Devices.Display.CLIPOBJ), param2: POINTER(win32more.Windows.Win32.Devices.Display.XLATEOBJ), param3: POINTER(win32more.Windows.Win32.Graphics.Gdi.TRIVERTEX), param4: UInt32, param5: VoidPtr, param6: UInt32, param7: POINTER(win32more.Windows.Win32.Foundation.RECTL), param8: POINTER(win32more.Windows.Win32.Foundation.POINTL), param9: UInt32) -> win32more.Windows.Win32.Foundation.BOOL: ...
@winfunctype_pointer
def PFN_DrvIcmCheckBitmapBits(param0: win32more.Windows.Win32.Devices.Display.DHPDEV, param1: win32more.Windows.Win32.Foundation.HANDLE, param2: POINTER(win32more.Windows.Win32.Devices.Display.SURFOBJ), param3: POINTER(Byte)) -> win32more.Windows.Win32.Foundation.BOOL: ...
@winfunctype_pointer
def PFN_DrvIcmCreateColorTransform(param0: win32more.Windows.Win32.Devices.Display.DHPDEV, param1: POINTER(win32more.Windows.Win32.UI.ColorSystem.LOGCOLORSPACEW), param2: VoidPtr, param3: UInt32, param4: VoidPtr, param5: UInt32, param6: VoidPtr, param7: UInt32, param8: UInt32) -> win32more.Windows.Win32.Foundation.HANDLE: ...
@winfunctype_pointer
def PFN_DrvIcmDeleteColorTransform(param0: win32more.Windows.Win32.Devices.Display.DHPDEV, param1: win32more.Windows.Win32.Foundation.HANDLE) -> win32more.Windows.Win32.Foundation.BOOL: ...
@winfunctype_pointer
def PFN_DrvIcmSetDeviceGammaRamp(param0: win32more.Windows.Win32.Devices.Display.DHPDEV, param1: UInt32, param2: VoidPtr) -> win32more.Windows.Win32.Foundation.BOOL: ...
@winfunctype_pointer
def PFN_DrvLineTo(param0: POINTER(win32more.Windows.Win32.Devices.Display.SURFOBJ), param1: POINTER(win32more.Windows.Win32.Devices.Display.CLIPOBJ), param2: POINTER(win32more.Windows.Win32.Devices.Display.BRUSHOBJ), param3: Int32, param4: Int32, param5: Int32, param6: Int32, param7: POINTER(win32more.Windows.Win32.Foundation.RECTL), param8: UInt32) -> win32more.Windows.Win32.Foundation.BOOL: ...
@winfunctype_pointer
def PFN_DrvLoadFontFile(param0: UInt32, param1: POINTER(UIntPtr), param2: POINTER(VoidPtr), param3: POINTER(UInt32), param4: POINTER(win32more.Windows.Win32.Graphics.Gdi.DESIGNVECTOR), param5: UInt32, param6: UInt32) -> UIntPtr: ...
@winfunctype_pointer
def PFN_DrvLockDisplayArea(param0: win32more.Windows.Win32.Devices.Display.DHPDEV, param1: POINTER(win32more.Windows.Win32.Foundation.RECTL)) -> Void: ...
@winfunctype_pointer
def PFN_DrvMovePointer(pso: POINTER(win32more.Windows.Win32.Devices.Display.SURFOBJ), x: Int32, y: Int32, prcl: POINTER(win32more.Windows.Win32.Foundation.RECTL)) -> Void: ...
@winfunctype_pointer
def PFN_DrvNextBand(param0: POINTER(win32more.Windows.Win32.Devices.Display.SURFOBJ), ppointl: POINTER(win32more.Windows.Win32.Foundation.POINTL)) -> win32more.Windows.Win32.Foundation.BOOL: ...
@winfunctype_pointer
def PFN_DrvNotify(param0: POINTER(win32more.Windows.Win32.Devices.Display.SURFOBJ), param1: UInt32, param2: VoidPtr) -> Void: ...
@winfunctype_pointer
def PFN_DrvPaint(param0: POINTER(win32more.Windows.Win32.Devices.Display.SURFOBJ), param1: POINTER(win32more.Windows.Win32.Devices.Display.CLIPOBJ), param2: POINTER(win32more.Windows.Win32.Devices.Display.BRUSHOBJ), param3: POINTER(win32more.Windows.Win32.Foundation.POINTL), param4: UInt32) -> win32more.Windows.Win32.Foundation.BOOL: ...
@winfunctype_pointer
def PFN_DrvPlgBlt(param0: POINTER(win32more.Windows.Win32.Devices.Display.SURFOBJ), param1: POINTER(win32more.Windows.Win32.Devices.Display.SURFOBJ), param2: POINTER(win32more.Windows.Win32.Devices.Display.SURFOBJ), param3: POINTER(win32more.Windows.Win32.Devices.Display.CLIPOBJ), param4: POINTER(win32more.Windows.Win32.Devices.Display.XLATEOBJ), param5: POINTER(win32more.Windows.Win32.Graphics.Gdi.COLORADJUSTMENT), param6: POINTER(win32more.Windows.Win32.Foundation.POINTL), param7: POINTER(win32more.Windows.Win32.Devices.Display.POINTFIX), param8: POINTER(win32more.Windows.Win32.Foundation.RECTL), param9: POINTER(win32more.Windows.Win32.Foundation.POINTL), param10: UInt32) -> win32more.Windows.Win32.Foundation.BOOL: ...
@winfunctype_pointer
def PFN_DrvQueryAdvanceWidths(param0: win32more.Windows.Win32.Devices.Display.DHPDEV, param1: POINTER(win32more.Windows.Win32.Devices.Display.FONTOBJ), param2: UInt32, param3: POINTER(UInt32), param4: VoidPtr, param5: UInt32) -> win32more.Windows.Win32.Foundation.BOOL: ...
@winfunctype_pointer
def PFN_DrvQueryDeviceSupport(param0: POINTER(win32more.Windows.Win32.Devices.Display.SURFOBJ), param1: POINTER(win32more.Windows.Win32.Devices.Display.XLATEOBJ), param2: POINTER(win32more.Windows.Win32.Devices.Display.XFORMOBJ), param3: UInt32, param4: UInt32, param5: VoidPtr, param6: UInt32, param7: VoidPtr) -> win32more.Windows.Win32.Foundation.BOOL: ...
@winfunctype_pointer
def PFN_DrvQueryFont(param0: win32more.Windows.Win32.Devices.Display.DHPDEV, param1: UIntPtr, param2: UInt32, param3: POINTER(UIntPtr)) -> POINTER(win32more.Windows.Win32.Devices.Display.IFIMETRICS): ...
@winfunctype_pointer
def PFN_DrvQueryFontCaps(param0: UInt32, param1: POINTER(UInt32)) -> Int32: ...
@winfunctype_pointer
def PFN_DrvQueryFontData(param0: win32more.Windows.Win32.Devices.Display.DHPDEV, param1: POINTER(win32more.Windows.Win32.Devices.Display.FONTOBJ), param2: UInt32, param3: UInt32, param4: POINTER(win32more.Windows.Win32.Devices.Display.GLYPHDATA), param5: VoidPtr, param6: UInt32) -> Int32: ...
@winfunctype_pointer
def PFN_DrvQueryFontFile(param0: UIntPtr, param1: UInt32, param2: UInt32, param3: POINTER(UInt32)) -> Int32: ...
@winfunctype_pointer
def PFN_DrvQueryFontTree(param0: win32more.Windows.Win32.Devices.Display.DHPDEV, param1: UIntPtr, param2: UInt32, param3: UInt32, param4: POINTER(UIntPtr)) -> VoidPtr: ...
@winfunctype_pointer
def PFN_DrvQueryGlyphAttrs(param0: POINTER(win32more.Windows.Win32.Devices.Display.FONTOBJ), param1: UInt32) -> POINTER(win32more.Windows.Win32.Devices.Display.FD_GLYPHATTR): ...
@winfunctype_pointer
def PFN_DrvQueryPerBandInfo(param0: POINTER(win32more.Windows.Win32.Devices.Display.SURFOBJ), param1: POINTER(win32more.Windows.Win32.Devices.Display.PERBANDINFO)) -> win32more.Windows.Win32.Foundation.BOOL: ...
@winfunctype_pointer
def PFN_DrvQuerySpoolType(dhpdev: win32more.Windows.Win32.Devices.Display.DHPDEV, pwchType: win32more.Windows.Win32.Foundation.PWSTR) -> win32more.Windows.Win32.Foundation.BOOL: ...
@winfunctype_pointer
def PFN_DrvQueryTrueTypeOutline(param0: win32more.Windows.Win32.Devices.Display.DHPDEV, param1: POINTER(win32more.Windows.Win32.Devices.Display.FONTOBJ), param2: UInt32, param3: win32more.Windows.Win32.Foundation.BOOL, param4: POINTER(win32more.Windows.Win32.Devices.Display.GLYPHDATA), param5: UInt32, param6: POINTER(win32more.Windows.Win32.Graphics.Gdi.TTPOLYGONHEADER)) -> Int32: ...
@winfunctype_pointer
def PFN_DrvQueryTrueTypeSection(param0: UInt32, param1: UInt32, param2: UInt32, param3: POINTER(win32more.Windows.Win32.Foundation.HANDLE), param4: POINTER(Int32)) -> Int32: ...
@winfunctype_pointer
def PFN_DrvQueryTrueTypeTable(param0: UIntPtr, param1: UInt32, param2: UInt32, param3: Int32, param4: UInt32, param5: POINTER(Byte), param6: POINTER(POINTER(Byte)), param7: POINTER(UInt32)) -> Int32: ...
@winfunctype_pointer
def PFN_DrvRealizeBrush(param0: POINTER(win32more.Windows.Win32.Devices.Display.BRUSHOBJ), param1: POINTER(win32more.Windows.Win32.Devices.Display.SURFOBJ), param2: POINTER(win32more.Windows.Win32.Devices.Display.SURFOBJ), param3: POINTER(win32more.Windows.Win32.Devices.Display.SURFOBJ), param4: POINTER(win32more.Windows.Win32.Devices.Display.XLATEOBJ), param5: UInt32) -> win32more.Windows.Win32.Foundation.BOOL: ...
@winfunctype_pointer
def PFN_DrvRenderHint(dhpdev: win32more.Windows.Win32.Devices.Display.DHPDEV, NotifyCode: UInt32, Length: UIntPtr, Data: VoidPtr) -> Int32: ...
@winfunctype_pointer
def PFN_DrvResetDevice(param0: win32more.Windows.Win32.Devices.Display.DHPDEV, param1: VoidPtr) -> UInt32: ...
@winfunctype_pointer
def PFN_DrvResetPDEV(dhpdevOld: win32more.Windows.Win32.Devices.Display.DHPDEV, dhpdevNew: win32more.Windows.Win32.Devices.Display.DHPDEV) -> win32more.Windows.Win32.Foundation.BOOL: ...
@winfunctype_pointer
def PFN_DrvSaveScreenBits(param0: POINTER(win32more.Windows.Win32.Devices.Display.SURFOBJ), param1: UInt32, param2: UIntPtr, param3: POINTER(win32more.Windows.Win32.Foundation.RECTL)) -> UIntPtr: ...
@winfunctype_pointer
def PFN_DrvSendPage(param0: POINTER(win32more.Windows.Win32.Devices.Display.SURFOBJ)) -> win32more.Windows.Win32.Foundation.BOOL: ...
@winfunctype_pointer
def PFN_DrvSetPalette(param0: win32more.Windows.Win32.Devices.Display.DHPDEV, param1: POINTER(win32more.Windows.Win32.Devices.Display.PALOBJ), param2: UInt32, param3: UInt32, param4: UInt32) -> win32more.Windows.Win32.Foundation.BOOL: ...
@winfunctype_pointer
def PFN_DrvSetPixelFormat(param0: POINTER(win32more.Windows.Win32.Devices.Display.SURFOBJ), param1: Int32, param2: win32more.Windows.Win32.Foundation.HWND) -> win32more.Windows.Win32.Foundation.BOOL: ...
@winfunctype_pointer
def PFN_DrvSetPointerShape(param0: POINTER(win32more.Windows.Win32.Devices.Display.SURFOBJ), param1: POINTER(win32more.Windows.Win32.Devices.Display.SURFOBJ), param2: POINTER(win32more.Windows.Win32.Devices.Display.SURFOBJ), param3: POINTER(win32more.Windows.Win32.Devices.Display.XLATEOBJ), param4: Int32, param5: Int32, param6: Int32, param7: Int32, param8: POINTER(win32more.Windows.Win32.Foundation.RECTL), param9: UInt32) -> UInt32: ...
@winfunctype_pointer
def PFN_DrvStartBanding(param0: POINTER(win32more.Windows.Win32.Devices.Display.SURFOBJ), ppointl: POINTER(win32more.Windows.Win32.Foundation.POINTL)) -> win32more.Windows.Win32.Foundation.BOOL: ...
@winfunctype_pointer
def PFN_DrvStartDoc(pso: POINTER(win32more.Windows.Win32.Devices.Display.SURFOBJ), pwszDocName: win32more.Windows.Win32.Foundation.PWSTR, dwJobId: UInt32) -> win32more.Windows.Win32.Foundation.BOOL: ...
@winfunctype_pointer
def PFN_DrvStartDxInterop(param0: POINTER(win32more.Windows.Win32.Devices.Display.SURFOBJ), param1: win32more.Windows.Win32.Foundation.BOOL, KernelModeDeviceHandle: VoidPtr) -> win32more.Windows.Win32.Foundation.BOOL: ...
@winfunctype_pointer
def PFN_DrvStartPage(pso: POINTER(win32more.Windows.Win32.Devices.Display.SURFOBJ)) -> win32more.Windows.Win32.Foundation.BOOL: ...
@winfunctype_pointer
def PFN_DrvStretchBlt(param0: POINTER(win32more.Windows.Win32.Devices.Display.SURFOBJ), param1: POINTER(win32more.Windows.Win32.Devices.Display.SURFOBJ), param2: POINTER(win32more.Windows.Win32.Devices.Display.SURFOBJ), param3: POINTER(win32more.Windows.Win32.Devices.Display.CLIPOBJ), param4: POINTER(win32more.Windows.Win32.Devices.Display.XLATEOBJ), param5: POINTER(win32more.Windows.Win32.Graphics.Gdi.COLORADJUSTMENT), param6: POINTER(win32more.Windows.Win32.Foundation.POINTL), param7: POINTER(win32more.Windows.Win32.Foundation.RECTL), param8: POINTER(win32more.Windows.Win32.Foundation.RECTL), param9: POINTER(win32more.Windows.Win32.Foundation.POINTL), param10: UInt32) -> win32more.Windows.Win32.Foundation.BOOL: ...
@winfunctype_pointer
def PFN_DrvStretchBltROP(param0: POINTER(win32more.Windows.Win32.Devices.Display.SURFOBJ), param1: POINTER(win32more.Windows.Win32.Devices.Display.SURFOBJ), param2: POINTER(win32more.Windows.Win32.Devices.Display.SURFOBJ), param3: POINTER(win32more.Windows.Win32.Devices.Display.CLIPOBJ), param4: POINTER(win32more.Windows.Win32.Devices.Display.XLATEOBJ), param5: POINTER(win32more.Windows.Win32.Graphics.Gdi.COLORADJUSTMENT), param6: POINTER(win32more.Windows.Win32.Foundation.POINTL), param7: POINTER(win32more.Windows.Win32.Foundation.RECTL), param8: POINTER(win32more.Windows.Win32.Foundation.RECTL), param9: POINTER(win32more.Windows.Win32.Foundation.POINTL), param10: UInt32, param11: POINTER(win32more.Windows.Win32.Devices.Display.BRUSHOBJ), param12: UInt32) -> win32more.Windows.Win32.Foundation.BOOL: ...
@winfunctype_pointer
def PFN_DrvStrokeAndFillPath(param0: POINTER(win32more.Windows.Win32.Devices.Display.SURFOBJ), param1: POINTER(win32more.Windows.Win32.Devices.Display.PATHOBJ), param2: POINTER(win32more.Windows.Win32.Devices.Display.CLIPOBJ), param3: POINTER(win32more.Windows.Win32.Devices.Display.XFORMOBJ), param4: POINTER(win32more.Windows.Win32.Devices.Display.BRUSHOBJ), param5: POINTER(win32more.Windows.Win32.Devices.Display.LINEATTRS), param6: POINTER(win32more.Windows.Win32.Devices.Display.BRUSHOBJ), param7: POINTER(win32more.Windows.Win32.Foundation.POINTL), param8: UInt32, param9: UInt32) -> win32more.Windows.Win32.Foundation.BOOL: ...
@winfunctype_pointer
def PFN_DrvStrokePath(param0: POINTER(win32more.Windows.Win32.Devices.Display.SURFOBJ), param1: POINTER(win32more.Windows.Win32.Devices.Display.PATHOBJ), param2: POINTER(win32more.Windows.Win32.Devices.Display.CLIPOBJ), param3: POINTER(win32more.Windows.Win32.Devices.Display.XFORMOBJ), param4: POINTER(win32more.Windows.Win32.Devices.Display.BRUSHOBJ), param5: POINTER(win32more.Windows.Win32.Foundation.POINTL), param6: POINTER(win32more.Windows.Win32.Devices.Display.LINEATTRS), param7: UInt32) -> win32more.Windows.Win32.Foundation.BOOL: ...
@winfunctype_pointer
def PFN_DrvSurfaceComplete(param0: win32more.Windows.Win32.Devices.Display.DHPDEV, param1: win32more.Windows.Win32.Foundation.HANDLE) -> win32more.Windows.Win32.Foundation.BOOL: ...
@winfunctype_pointer
def PFN_DrvSwapBuffers(param0: POINTER(win32more.Windows.Win32.Devices.Display.SURFOBJ), param1: POINTER(win32more.Windows.Win32.Devices.Display.WNDOBJ)) -> win32more.Windows.Win32.Foundation.BOOL: ...
@winfunctype_pointer
def PFN_DrvSynchronize(param0: win32more.Windows.Win32.Devices.Display.DHPDEV, param1: POINTER(win32more.Windows.Win32.Foundation.RECTL)) -> Void: ...
@winfunctype_pointer
def PFN_DrvSynchronizeRedirectionBitmaps(param0: win32more.Windows.Win32.Devices.Display.DHPDEV, param1: POINTER(UInt64)) -> win32more.Windows.Win32.Foundation.NTSTATUS: ...
@winfunctype_pointer
def PFN_DrvSynchronizeSurface(param0: POINTER(win32more.Windows.Win32.Devices.Display.SURFOBJ), param1: POINTER(win32more.Windows.Win32.Foundation.RECTL), param2: UInt32) -> Void: ...
@winfunctype_pointer
def PFN_DrvTextOut(param0: POINTER(win32more.Windows.Win32.Devices.Display.SURFOBJ), param1: POINTER(win32more.Windows.Win32.Devices.Display.STROBJ), param2: POINTER(win32more.Windows.Win32.Devices.Display.FONTOBJ), param3: POINTER(win32more.Windows.Win32.Devices.Display.CLIPOBJ), param4: POINTER(win32more.Windows.Win32.Foundation.RECTL), param5: POINTER(win32more.Windows.Win32.Foundation.RECTL), param6: POINTER(win32more.Windows.Win32.Devices.Display.BRUSHOBJ), param7: POINTER(win32more.Windows.Win32.Devices.Display.BRUSHOBJ), param8: POINTER(win32more.Windows.Win32.Foundation.POINTL), param9: UInt32) -> win32more.Windows.Win32.Foundation.BOOL: ...
@winfunctype_pointer
def PFN_DrvTransparentBlt(param0: POINTER(win32more.Windows.Win32.Devices.Display.SURFOBJ), param1: POINTER(win32more.Windows.Win32.Devices.Display.SURFOBJ), param2: POINTER(win32more.Windows.Win32.Devices.Display.CLIPOBJ), param3: POINTER(win32more.Windows.Win32.Devices.Display.XLATEOBJ), param4: POINTER(win32more.Windows.Win32.Foundation.RECTL), param5: POINTER(win32more.Windows.Win32.Foundation.RECTL), param6: UInt32, param7: UInt32) -> win32more.Windows.Win32.Foundation.BOOL: ...
@winfunctype_pointer
def PFN_DrvUnloadFontFile(param0: UIntPtr) -> win32more.Windows.Win32.Foundation.BOOL: ...
@winfunctype_pointer
def PFN_DrvUnlockDisplayArea(param0: win32more.Windows.Win32.Devices.Display.DHPDEV, param1: POINTER(win32more.Windows.Win32.Foundation.RECTL)) -> Void: ...
@winfunctype_pointer
def PFN_EngCombineRgn(hrgnTrg: win32more.Windows.Win32.Foundation.HANDLE, hrgnSrc1: win32more.Windows.Win32.Foundation.HANDLE, hrgnSrc2: win32more.Windows.Win32.Foundation.HANDLE, imode: Int32) -> Int32: ...
@winfunctype_pointer
def PFN_EngCopyRgn(hrgnDst: win32more.Windows.Win32.Foundation.HANDLE, hrgnSrc: win32more.Windows.Win32.Foundation.HANDLE) -> Int32: ...
@winfunctype_pointer
def PFN_EngCreateRectRgn(left: Int32, top: Int32, right: Int32, bottom: Int32) -> win32more.Windows.Win32.Foundation.HANDLE: ...
@winfunctype_pointer
def PFN_EngDeleteRgn(hrgn: win32more.Windows.Win32.Foundation.HANDLE) -> Void: ...
@winfunctype_pointer
def PFN_EngIntersectRgn(hrgnResult: win32more.Windows.Win32.Foundation.HANDLE, hRgnA: win32more.Windows.Win32.Foundation.HANDLE, hRgnB: win32more.Windows.Win32.Foundation.HANDLE) -> Int32: ...
@winfunctype_pointer
def PFN_EngSubtractRgn(hrgnResult: win32more.Windows.Win32.Foundation.HANDLE, hRgnA: win32more.Windows.Win32.Foundation.HANDLE, hRgnB: win32more.Windows.Win32.Foundation.HANDLE) -> Int32: ...
@winfunctype_pointer
def PFN_EngUnionRgn(hrgnResult: win32more.Windows.Win32.Foundation.HANDLE, hRgnA: win32more.Windows.Win32.Foundation.HANDLE, hRgnB: win32more.Windows.Win32.Foundation.HANDLE) -> Int32: ...
@winfunctype_pointer
def PFN_EngXorRgn(hrgnResult: win32more.Windows.Win32.Foundation.HANDLE, hRgnA: win32more.Windows.Win32.Foundation.HANDLE, hRgnB: win32more.Windows.Win32.Foundation.HANDLE) -> Int32: ...
class PHYSICAL_MONITOR(Structure):
    hPhysicalMonitor: win32more.Windows.Win32.Foundation.HANDLE
    szPhysicalMonitorDescription: Char * 128
    _pack_ = 1
if ARCH in 'X64,ARM64':
    class POINTE(Structure):
        x: Single
        y: Single
elif ARCH in 'X86':
    class POINTE(Structure):
        x: UInt32
        y: UInt32
class POINTFIX(Structure):
    x: Int32
    y: Int32
class POINTQF(Structure):
    x: Int64
    y: Int64
@winfunctype_pointer
def PVIDEO_WIN32K_CALLOUT(Params: VoidPtr) -> Void: ...
QUERY_DISPLAY_CONFIG_FLAGS = UInt32
QDC_ALL_PATHS: win32more.Windows.Win32.Devices.Display.QUERY_DISPLAY_CONFIG_FLAGS = 1
QDC_ONLY_ACTIVE_PATHS: win32more.Windows.Win32.Devices.Display.QUERY_DISPLAY_CONFIG_FLAGS = 2
QDC_DATABASE_CURRENT: win32more.Windows.Win32.Devices.Display.QUERY_DISPLAY_CONFIG_FLAGS = 4
QDC_VIRTUAL_MODE_AWARE: win32more.Windows.Win32.Devices.Display.QUERY_DISPLAY_CONFIG_FLAGS = 16
QDC_INCLUDE_HMD: win32more.Windows.Win32.Devices.Display.QUERY_DISPLAY_CONFIG_FLAGS = 32
QDC_VIRTUAL_REFRESH_RATE_AWARE: win32more.Windows.Win32.Devices.Display.QUERY_DISPLAY_CONFIG_FLAGS = 64
class RECTFX(Structure):
    xLeft: Int32
    yTop: Int32
    xRight: Int32
    yBottom: Int32
class RUN(Structure):
    iStart: Int32
    iStop: Int32
class SET_ACTIVE_COLOR_PROFILE_NAME(Structure):
    ColorProfileName: FlexibleArray[Char]
SET_DISPLAY_CONFIG_FLAGS = UInt32
SDC_USE_DATABASE_CURRENT: win32more.Windows.Win32.Devices.Display.SET_DISPLAY_CONFIG_FLAGS = 15
SDC_TOPOLOGY_INTERNAL: win32more.Windows.Win32.Devices.Display.SET_DISPLAY_CONFIG_FLAGS = 1
SDC_TOPOLOGY_CLONE: win32more.Windows.Win32.Devices.Display.SET_DISPLAY_CONFIG_FLAGS = 2
SDC_TOPOLOGY_EXTEND: win32more.Windows.Win32.Devices.Display.SET_DISPLAY_CONFIG_FLAGS = 4
SDC_TOPOLOGY_EXTERNAL: win32more.Windows.Win32.Devices.Display.SET_DISPLAY_CONFIG_FLAGS = 8
SDC_TOPOLOGY_SUPPLIED: win32more.Windows.Win32.Devices.Display.SET_DISPLAY_CONFIG_FLAGS = 16
SDC_USE_SUPPLIED_DISPLAY_CONFIG: win32more.Windows.Win32.Devices.Display.SET_DISPLAY_CONFIG_FLAGS = 32
SDC_VALIDATE: win32more.Windows.Win32.Devices.Display.SET_DISPLAY_CONFIG_FLAGS = 64
SDC_APPLY: win32more.Windows.Win32.Devices.Display.SET_DISPLAY_CONFIG_FLAGS = 128
SDC_NO_OPTIMIZATION: win32more.Windows.Win32.Devices.Display.SET_DISPLAY_CONFIG_FLAGS = 256
SDC_SAVE_TO_DATABASE: win32more.Windows.Win32.Devices.Display.SET_DISPLAY_CONFIG_FLAGS = 512
SDC_ALLOW_CHANGES: win32more.Windows.Win32.Devices.Display.SET_DISPLAY_CONFIG_FLAGS = 1024
SDC_PATH_PERSIST_IF_REQUIRED: win32more.Windows.Win32.Devices.Display.SET_DISPLAY_CONFIG_FLAGS = 2048
SDC_FORCE_MODE_ENUMERATION: win32more.Windows.Win32.Devices.Display.SET_DISPLAY_CONFIG_FLAGS = 4096
SDC_ALLOW_PATH_ORDER_CHANGES: win32more.Windows.Win32.Devices.Display.SET_DISPLAY_CONFIG_FLAGS = 8192
SDC_VIRTUAL_MODE_AWARE: win32more.Windows.Win32.Devices.Display.SET_DISPLAY_CONFIG_FLAGS = 32768
SDC_VIRTUAL_REFRESH_RATE_AWARE: win32more.Windows.Win32.Devices.Display.SET_DISPLAY_CONFIG_FLAGS = 131072
@cfunctype_pointer
def SORTCOMP(pv1: VoidPtr, pv2: VoidPtr) -> Int32: ...
class STROBJ(Structure):
    cGlyphs: UInt32
    flAccel: UInt32
    ulCharInc: UInt32
    rclBkGround: win32more.Windows.Win32.Foundation.RECTL
    pgp: POINTER(win32more.Windows.Win32.Devices.Display.GLYPHPOS)
    pwszOrg: win32more.Windows.Win32.Foundation.PWSTR
class SURFOBJ(Structure):
    dhsurf: win32more.Windows.Win32.Devices.Display.DHSURF
    hsurf: win32more.Windows.Win32.Devices.Display.HSURF
    dhpdev: win32more.Windows.Win32.Devices.Display.DHPDEV
    hdev: win32more.Windows.Win32.Devices.Display.HDEV
    sizlBitmap: win32more.Windows.Win32.Foundation.SIZE
    cjBits: UInt32
    pvBits: VoidPtr
    pvScan0: VoidPtr
    lDelta: Int32
    iUniq: UInt32
    iBitmapFormat: UInt32
    iType: UInt16
    fjBitmap: UInt16
class Sources(Structure):
    sourceId: UInt32
    numTargets: Int32
    aTargets: FlexibleArray[UInt32]
class TYPE1_FONT(Structure):
    hPFM: win32more.Windows.Win32.Foundation.HANDLE
    hPFB: win32more.Windows.Win32.Foundation.HANDLE
    ulIdentifier: UInt32
class VGA_CHAR(Structure):
    Char: win32more.Windows.Win32.Foundation.CHAR
    Attributes: win32more.Windows.Win32.Foundation.CHAR
class VIDEOPARAMETERS(Structure):
    Guid: Guid
    dwOffset: UInt32
    dwCommand: UInt32
    dwFlags: UInt32
    dwMode: UInt32
    dwTVStandard: UInt32
    dwAvailableModes: UInt32
    dwAvailableTVStandard: UInt32
    dwFlickerFilter: UInt32
    dwOverScanX: UInt32
    dwOverScanY: UInt32
    dwMaxUnscaledX: UInt32
    dwMaxUnscaledY: UInt32
    dwPositionX: UInt32
    dwPositionY: UInt32
    dwBrightness: UInt32
    dwContrast: UInt32
    dwCPType: UInt32
    dwCPCommand: UInt32
    dwCPStandard: UInt32
    dwCPKey: UInt32
    bCP_APSTriggerBits: UInt32
    bOEMCopyProtection: Byte * 256
class VIDEO_BANK_SELECT(Structure):
    Length: UInt32
    Size: UInt32
    BankingFlags: UInt32
    BankingType: UInt32
    PlanarHCBankingType: UInt32
    BitmapWidthInBytes: UInt32
    BitmapSize: UInt32
    Granularity: UInt32
    PlanarHCGranularity: UInt32
    CodeOffset: UInt32
    PlanarHCBankCodeOffset: UInt32
    PlanarHCEnableCodeOffset: UInt32
    PlanarHCDisableCodeOffset: UInt32
VIDEO_BANK_TYPE = Int32
VideoNotBanked: win32more.Windows.Win32.Devices.Display.VIDEO_BANK_TYPE = 0
VideoBanked1RW: win32more.Windows.Win32.Devices.Display.VIDEO_BANK_TYPE = 1
VideoBanked1R1W: win32more.Windows.Win32.Devices.Display.VIDEO_BANK_TYPE = 2
VideoBanked2RW: win32more.Windows.Win32.Devices.Display.VIDEO_BANK_TYPE = 3
NumVideoBankTypes: win32more.Windows.Win32.Devices.Display.VIDEO_BANK_TYPE = 4
class VIDEO_BRIGHTNESS_POLICY(Structure):
    DefaultToBiosPolicy: win32more.Windows.Win32.Foundation.BOOLEAN
    LevelCount: Byte
    Level: FlexibleArray[_Anonymous_e__Struct]
    class _Anonymous_e__Struct(Structure):
        BatteryLevel: Byte
        Brightness: Byte
class VIDEO_CLUT(Structure):
    NumEntries: UInt16
    FirstEntry: UInt16
    LookupTable: FlexibleArray[_Anonymous_e__Union]
    class _Anonymous_e__Union(Union):
        RgbArray: win32more.Windows.Win32.Devices.Display.VIDEO_CLUTDATA
        RgbLong: UInt32
class VIDEO_CLUTDATA(Structure):
    Red: Byte
    Green: Byte
    Blue: Byte
    Unused: Byte
class VIDEO_COLOR_CAPABILITIES(Structure):
    Length: UInt32
    AttributeFlags: UInt32
    RedPhosphoreDecay: Int32
    GreenPhosphoreDecay: Int32
    BluePhosphoreDecay: Int32
    WhiteChromaticity_x: Int32
    WhiteChromaticity_y: Int32
    WhiteChromaticity_Y: Int32
    RedChromaticity_x: Int32
    RedChromaticity_y: Int32
    GreenChromaticity_x: Int32
    GreenChromaticity_y: Int32
    BlueChromaticity_x: Int32
    BlueChromaticity_y: Int32
    WhiteGamma: Int32
    RedGamma: Int32
    GreenGamma: Int32
    BlueGamma: Int32
class VIDEO_COLOR_LUT_DATA(Structure):
    Length: UInt32
    LutDataFormat: UInt32
    LutData: FlexibleArray[Byte]
class VIDEO_CURSOR_ATTRIBUTES(Structure):
    Width: UInt16
    Height: UInt16
    Column: Int16
    Row: Int16
    Rate: Byte
    Enable: Byte
class VIDEO_CURSOR_POSITION(Structure):
    Column: Int16
    Row: Int16
class VIDEO_DEVICE_SESSION_STATUS(Structure):
    bEnable: UInt32
    bSuccess: UInt32
class VIDEO_HARDWARE_STATE(Structure):
    StateHeader: POINTER(win32more.Windows.Win32.Devices.Display.VIDEO_HARDWARE_STATE_HEADER)
    StateLength: UInt32
class VIDEO_HARDWARE_STATE_HEADER(Structure):
    Length: UInt32
    PortValue: Byte * 48
    AttribIndexDataState: UInt32
    BasicSequencerOffset: UInt32
    BasicCrtContOffset: UInt32
    BasicGraphContOffset: UInt32
    BasicAttribContOffset: UInt32
    BasicDacOffset: UInt32
    BasicLatchesOffset: UInt32
    ExtendedSequencerOffset: UInt32
    ExtendedCrtContOffset: UInt32
    ExtendedGraphContOffset: UInt32
    ExtendedAttribContOffset: UInt32
    ExtendedDacOffset: UInt32
    ExtendedValidatorStateOffset: UInt32
    ExtendedMiscDataOffset: UInt32
    PlaneLength: UInt32
    Plane1Offset: UInt32
    Plane2Offset: UInt32
    Plane3Offset: UInt32
    Plane4Offset: UInt32
    VGAStateFlags: UInt32
    DIBOffset: UInt32
    DIBBitsPerPixel: UInt32
    DIBXResolution: UInt32
    DIBYResolution: UInt32
    DIBXlatOffset: UInt32
    DIBXlatLength: UInt32
    VesaInfoOffset: UInt32
    FrameBufferData: VoidPtr
class VIDEO_LOAD_FONT_INFORMATION(Structure):
    WidthInPixels: UInt16
    HeightInPixels: UInt16
    FontSize: UInt32
    Font: FlexibleArray[Byte]
class VIDEO_LUT_RGB256WORDS(Structure):
    Red: UInt16 * 256
    Green: UInt16 * 256
    Blue: UInt16 * 256
class VIDEO_MEMORY(Structure):
    RequestedVirtualAddress: VoidPtr
class VIDEO_MEMORY_INFORMATION(Structure):
    VideoRamBase: VoidPtr
    VideoRamLength: UInt32
    FrameBufferBase: VoidPtr
    FrameBufferLength: UInt32
class VIDEO_MODE(Structure):
    RequestedMode: UInt32
class VIDEO_MODE_INFORMATION(Structure):
    Length: UInt32
    ModeIndex: UInt32
    VisScreenWidth: UInt32
    VisScreenHeight: UInt32
    ScreenStride: UInt32
    NumberOfPlanes: UInt32
    BitsPerPlane: UInt32
    Frequency: UInt32
    XMillimeter: UInt32
    YMillimeter: UInt32
    NumberRedBits: UInt32
    NumberGreenBits: UInt32
    NumberBlueBits: UInt32
    RedMask: UInt32
    GreenMask: UInt32
    BlueMask: UInt32
    AttributeFlags: UInt32
    VideoMemoryBitmapWidth: UInt32
    VideoMemoryBitmapHeight: UInt32
    DriverSpecificAttributeFlags: UInt32
class VIDEO_MONITOR_DESCRIPTOR(Structure):
    DescriptorSize: UInt32
    Descriptor: FlexibleArray[Byte]
class VIDEO_NUM_MODES(Structure):
    NumModes: UInt32
    ModeInformationLength: UInt32
class VIDEO_PALETTE_DATA(Structure):
    NumEntries: UInt16
    FirstEntry: UInt16
    Colors: FlexibleArray[UInt16]
class VIDEO_PERFORMANCE_COUNTER(Structure):
    NbOfAllocationEvicted: UInt64 * 10
    NbOfAllocationMarked: UInt64 * 10
    NbOfAllocationRestored: UInt64 * 10
    KBytesEvicted: UInt64 * 10
    KBytesMarked: UInt64 * 10
    KBytesRestored: UInt64 * 10
    NbProcessCommited: UInt64
    NbAllocationCommited: UInt64
    NbAllocationMarked: UInt64
    KBytesAllocated: UInt64
    KBytesAvailable: UInt64
    KBytesCurMarked: UInt64
    Reference: UInt64
    Unreference: UInt64
    TrueReference: UInt64
    NbOfPageIn: UInt64
    KBytesPageIn: UInt64
    NbOfPageOut: UInt64
    KBytesPageOut: UInt64
    NbOfRotateOut: UInt64
    KBytesRotateOut: UInt64
class VIDEO_POINTER_ATTRIBUTES(Structure):
    Flags: UInt32
    Width: UInt32
    Height: UInt32
    WidthInBytes: UInt32
    Enable: UInt32
    Column: Int16
    Row: Int16
    Pixels: FlexibleArray[Byte]
class VIDEO_POINTER_CAPABILITIES(Structure):
    Flags: UInt32
    MaxWidth: UInt32
    MaxHeight: UInt32
    HWPtrBitmapStart: UInt32
    HWPtrBitmapEnd: UInt32
class VIDEO_POINTER_POSITION(Structure):
    Column: Int16
    Row: Int16
class VIDEO_POWER_MANAGEMENT(Structure):
    Length: UInt32
    DPMSVersion: UInt32
    PowerState: UInt32
VIDEO_POWER_STATE = Int32
VideoPowerUnspecified: win32more.Windows.Win32.Devices.Display.VIDEO_POWER_STATE = 0
VideoPowerOn: win32more.Windows.Win32.Devices.Display.VIDEO_POWER_STATE = 1
VideoPowerStandBy: win32more.Windows.Win32.Devices.Display.VIDEO_POWER_STATE = 2
VideoPowerSuspend: win32more.Windows.Win32.Devices.Display.VIDEO_POWER_STATE = 3
VideoPowerOff: win32more.Windows.Win32.Devices.Display.VIDEO_POWER_STATE = 4
VideoPowerHibernate: win32more.Windows.Win32.Devices.Display.VIDEO_POWER_STATE = 5
VideoPowerShutdown: win32more.Windows.Win32.Devices.Display.VIDEO_POWER_STATE = 6
VideoPowerMaximum: win32more.Windows.Win32.Devices.Display.VIDEO_POWER_STATE = 7
class VIDEO_PUBLIC_ACCESS_RANGES(Structure):
    InIoSpace: UInt32
    MappedInIoSpace: UInt32
    VirtualAddress: VoidPtr
class VIDEO_QUERY_PERFORMANCE_COUNTER(Structure):
    BufferSize: UInt32
    Buffer: POINTER(win32more.Windows.Win32.Devices.Display.VIDEO_PERFORMANCE_COUNTER)
class VIDEO_REGISTER_VDM(Structure):
    MinimumStateSize: UInt32
class VIDEO_SHARE_MEMORY(Structure):
    ProcessHandle: win32more.Windows.Win32.Foundation.HANDLE
    ViewOffset: UInt32
    ViewSize: UInt32
    RequestedVirtualAddress: VoidPtr
class VIDEO_SHARE_MEMORY_INFORMATION(Structure):
    SharedViewOffset: UInt32
    SharedViewSize: UInt32
    VirtualAddress: VoidPtr
class VIDEO_VDM(Structure):
    ProcessHandle: win32more.Windows.Win32.Foundation.HANDLE
class VIDEO_WIN32K_CALLBACKS(Structure):
    PhysDisp: VoidPtr
    Callout: win32more.Windows.Win32.Devices.Display.PVIDEO_WIN32K_CALLOUT
    bACPI: UInt32
    pPhysDeviceObject: win32more.Windows.Win32.Foundation.HANDLE
    DualviewFlags: UInt32
class VIDEO_WIN32K_CALLBACKS_PARAMS(Structure):
    CalloutType: win32more.Windows.Win32.Devices.Display.VIDEO_WIN32K_CALLBACKS_PARAMS_TYPE
    PhysDisp: VoidPtr
    Param: UIntPtr
    Status: Int32
    LockUserSession: win32more.Windows.Win32.Foundation.BOOLEAN
    IsPostDevice: win32more.Windows.Win32.Foundation.BOOLEAN
    SurpriseRemoval: win32more.Windows.Win32.Foundation.BOOLEAN
    WaitForQueueReady: win32more.Windows.Win32.Foundation.BOOLEAN
VIDEO_WIN32K_CALLBACKS_PARAMS_TYPE = Int32
VideoPowerNotifyCallout: win32more.Windows.Win32.Devices.Display.VIDEO_WIN32K_CALLBACKS_PARAMS_TYPE = 1
VideoEnumChildPdoNotifyCallout: win32more.Windows.Win32.Devices.Display.VIDEO_WIN32K_CALLBACKS_PARAMS_TYPE = 3
VideoFindAdapterCallout: win32more.Windows.Win32.Devices.Display.VIDEO_WIN32K_CALLBACKS_PARAMS_TYPE = 4
VideoPnpNotifyCallout: win32more.Windows.Win32.Devices.Display.VIDEO_WIN32K_CALLBACKS_PARAMS_TYPE = 7
VideoDxgkDisplaySwitchCallout: win32more.Windows.Win32.Devices.Display.VIDEO_WIN32K_CALLBACKS_PARAMS_TYPE = 8
VideoDxgkFindAdapterTdrCallout: win32more.Windows.Win32.Devices.Display.VIDEO_WIN32K_CALLBACKS_PARAMS_TYPE = 10
VideoDxgkHardwareProtectionTeardown: win32more.Windows.Win32.Devices.Display.VIDEO_WIN32K_CALLBACKS_PARAMS_TYPE = 11
VideoRepaintDesktop: win32more.Windows.Win32.Devices.Display.VIDEO_WIN32K_CALLBACKS_PARAMS_TYPE = 12
VideoUpdateCursor: win32more.Windows.Win32.Devices.Display.VIDEO_WIN32K_CALLBACKS_PARAMS_TYPE = 13
VideoDisableMultiPlaneOverlay: win32more.Windows.Win32.Devices.Display.VIDEO_WIN32K_CALLBACKS_PARAMS_TYPE = 14
VideoDesktopDuplicationChange: win32more.Windows.Win32.Devices.Display.VIDEO_WIN32K_CALLBACKS_PARAMS_TYPE = 15
VideoBlackScreenDiagnostics: win32more.Windows.Win32.Devices.Display.VIDEO_WIN32K_CALLBACKS_PARAMS_TYPE = 16
class WCRUN(Structure):
    wcLow: Char
    cGlyphs: UInt16
    phg: POINTER(UInt32)
class WNDOBJ(Structure):
    coClient: win32more.Windows.Win32.Devices.Display.CLIPOBJ
    pvConsumer: VoidPtr
    rclClient: win32more.Windows.Win32.Foundation.RECTL
    psoOwner: POINTER(win32more.Windows.Win32.Devices.Display.SURFOBJ)
@winfunctype_pointer
def WNDOBJCHANGEPROC(pwo: POINTER(win32more.Windows.Win32.Devices.Display.WNDOBJ), fl: UInt32) -> Void: ...
if ARCH in 'X64,ARM64':
    class XFORML(Structure):
        eM11: Single
        eM12: Single
        eM21: Single
        eM22: Single
        eDx: Single
        eDy: Single
elif ARCH in 'X86':
    class XFORML(Structure):
        eM11: UInt32
        eM12: UInt32
        eM21: UInt32
        eM22: UInt32
        eDx: UInt32
        eDy: UInt32
class XFORMOBJ(Structure):
    ulReserved: UInt32
class XLATEOBJ(Structure):
    iUniq: UInt32
    flXlate: UInt32
    iSrcType: UInt16
    iDstType: UInt16
    cEntries: UInt32
    pulXlate: POINTER(UInt32)


make_ready(__name__)
