from __future__ import annotations
from win32more.win32.prelude import *
import win32more.Windows.Win32.Devices.Usb
import win32more.Windows.Win32.Foundation
import win32more.Windows.Win32.System.IO
class ALTERNATE_INTERFACE(Structure):
    InterfaceNumber: UInt16
    AlternateInterfaceNumber: UInt16
DEVICE_SPEED: UInt32 = 1
LowSpeed: UInt32 = 1
FullSpeed: UInt32 = 2
HighSpeed: UInt32 = 3
IOCTL_GENERICUSBFN_TRANSFER_IN: UInt32 = 2277389
IOCTL_GENERICUSBFN_TRANSFER_IN_APPEND_ZERO_PKT: UInt32 = 2277393
IOCTL_GENERICUSBFN_TRANSFER_OUT: UInt32 = 2277398
IOCTL_GENERICUSBFN_CONTROL_STATUS_HANDSHAKE_IN: UInt32 = 2277400
IOCTL_GENERICUSBFN_CONTROL_STATUS_HANDSHAKE_OUT: UInt32 = 2277404
IOCTL_GENERICUSBFN_GET_CLASS_INFO: UInt32 = 2277410
IOCTL_GENERICUSBFN_GET_PIPE_STATE: UInt32 = 2277414
IOCTL_GENERICUSBFN_SET_PIPE_STATE: UInt32 = 2277417
IOCTL_GENERICUSBFN_ACTIVATE_USB_BUS: UInt32 = 2277420
IOCTL_GENERICUSBFN_DEACTIVATE_USB_BUS: UInt32 = 2277424
IOCTL_GENERICUSBFN_BUS_EVENT_NOTIFICATION: UInt32 = 2277430
IOCTL_GENERICUSBFN_GET_CLASS_INFO_EX: UInt32 = 2277434
IOCTL_GENERICUSBFN_GET_INTERFACE_DESCRIPTOR_SET: UInt32 = 2277438
IOCTL_GENERICUSBFN_REGISTER_USB_STRING: UInt32 = 2277441
USBUSER_VERSION: UInt32 = 4
USBUSER_GET_CONTROLLER_INFO_0: UInt32 = 1
USBUSER_GET_CONTROLLER_DRIVER_KEY: UInt32 = 2
USBUSER_PASS_THRU: UInt32 = 3
USBUSER_GET_POWER_STATE_MAP: UInt32 = 4
USBUSER_GET_BANDWIDTH_INFORMATION: UInt32 = 5
USBUSER_GET_BUS_STATISTICS_0: UInt32 = 6
USBUSER_GET_ROOTHUB_SYMBOLIC_NAME: UInt32 = 7
USBUSER_GET_USB_DRIVER_VERSION: UInt32 = 8
USBUSER_GET_USB2_HW_VERSION: UInt32 = 9
USBUSER_USB_REFRESH_HCT_REG: UInt32 = 10
USBUSER_OP_SEND_ONE_PACKET: UInt32 = 268435457
USBUSER_OP_RAW_RESET_PORT: UInt32 = 536870913
USBUSER_OP_OPEN_RAW_DEVICE: UInt32 = 536870914
USBUSER_OP_CLOSE_RAW_DEVICE: UInt32 = 536870915
USBUSER_OP_SEND_RAW_COMMAND: UInt32 = 536870916
USBUSER_SET_ROOTPORT_FEATURE: UInt32 = 536870917
USBUSER_CLEAR_ROOTPORT_FEATURE: UInt32 = 536870918
USBUSER_GET_ROOTPORT_STATUS: UInt32 = 536870919
USBUSER_INVALID_REQUEST: UInt32 = 4294967280
USBUSER_OP_MASK_DEVONLY_API: UInt32 = 268435456
USBUSER_OP_MASK_HCTEST_API: UInt32 = 536870912
USB_PACKETFLAG_LOW_SPEED: UInt32 = 1
USB_PACKETFLAG_FULL_SPEED: UInt32 = 2
USB_PACKETFLAG_HIGH_SPEED: UInt32 = 4
USB_PACKETFLAG_ASYNC_IN: UInt32 = 8
USB_PACKETFLAG_ASYNC_OUT: UInt32 = 16
USB_PACKETFLAG_ISO_IN: UInt32 = 32
USB_PACKETFLAG_ISO_OUT: UInt32 = 64
USB_PACKETFLAG_SETUP: UInt32 = 128
USB_PACKETFLAG_TOGGLE0: UInt32 = 256
USB_PACKETFLAG_TOGGLE1: UInt32 = 512
USB_HC_FEATURE_FLAG_PORT_POWER_SWITCHING: UInt32 = 1
USB_HC_FEATURE_FLAG_SEL_SUSPEND: UInt32 = 2
USB_HC_FEATURE_LEGACY_BIOS: UInt32 = 4
USB_HC_FEATURE_TIME_SYNC_API: UInt32 = 8
USB_SUBMIT_URB: UInt32 = 0
USB_RESET_PORT: UInt32 = 1
USB_GET_ROOTHUB_PDO: UInt32 = 3
USB_GET_PORT_STATUS: UInt32 = 4
USB_ENABLE_PORT: UInt32 = 5
USB_GET_HUB_COUNT: UInt32 = 6
USB_CYCLE_PORT: UInt32 = 7
USB_GET_HUB_NAME: UInt32 = 8
USB_IDLE_NOTIFICATION: UInt32 = 9
USB_RECORD_FAILURE: UInt32 = 10
USB_GET_BUS_INFO: UInt32 = 264
USB_GET_CONTROLLER_NAME: UInt32 = 265
USB_GET_BUSGUID_INFO: UInt32 = 266
USB_GET_PARENT_HUB_INFO: UInt32 = 267
USB_GET_DEVICE_HANDLE: UInt32 = 268
USB_GET_DEVICE_HANDLE_EX: UInt32 = 269
USB_GET_TT_DEVICE_HANDLE: UInt32 = 270
USB_GET_TOPOLOGY_ADDRESS: UInt32 = 271
USB_IDLE_NOTIFICATION_EX: UInt32 = 272
USB_REQ_GLOBAL_SUSPEND: UInt32 = 273
USB_REQ_GLOBAL_RESUME: UInt32 = 274
USB_GET_HUB_CONFIG_INFO: UInt32 = 275
USB_FAIL_GET_STATUS: UInt32 = 280
USB_REGISTER_COMPOSITE_DEVICE: UInt32 = 0
USB_UNREGISTER_COMPOSITE_DEVICE: UInt32 = 1
USB_REQUEST_REMOTE_WAKE_NOTIFICATION: UInt32 = 2
HCD_GET_STATS_1: UInt32 = 255
HCD_DIAGNOSTIC_MODE_ON: UInt32 = 256
HCD_DIAGNOSTIC_MODE_OFF: UInt32 = 257
HCD_GET_ROOT_HUB_NAME: UInt32 = 258
HCD_GET_DRIVERKEY_NAME: UInt32 = 265
HCD_GET_STATS_2: UInt32 = 266
HCD_DISABLE_PORT: UInt32 = 268
HCD_ENABLE_PORT: UInt32 = 269
HCD_USER_REQUEST: UInt32 = 270
HCD_TRACE_READ_REQUEST: UInt32 = 275
USB_GET_NODE_INFORMATION: UInt32 = 258
USB_GET_NODE_CONNECTION_INFORMATION: UInt32 = 259
USB_GET_DESCRIPTOR_FROM_NODE_CONNECTION: UInt32 = 260
USB_GET_NODE_CONNECTION_NAME: UInt32 = 261
USB_DIAG_IGNORE_HUBS_ON: UInt32 = 262
USB_DIAG_IGNORE_HUBS_OFF: UInt32 = 263
USB_GET_NODE_CONNECTION_DRIVERKEY_NAME: UInt32 = 264
USB_GET_HUB_CAPABILITIES: UInt32 = 271
USB_GET_NODE_CONNECTION_ATTRIBUTES: UInt32 = 272
USB_HUB_CYCLE_PORT: UInt32 = 273
USB_GET_NODE_CONNECTION_INFORMATION_EX: UInt32 = 274
USB_RESET_HUB: UInt32 = 275
USB_GET_HUB_CAPABILITIES_EX: UInt32 = 276
USB_GET_HUB_INFORMATION_EX: UInt32 = 277
USB_GET_PORT_CONNECTOR_PROPERTIES: UInt32 = 278
USB_GET_NODE_CONNECTION_INFORMATION_EX_V2: UInt32 = 279
USB_GET_TRANSPORT_CHARACTERISTICS: UInt32 = 281
USB_REGISTER_FOR_TRANSPORT_CHARACTERISTICS_CHANGE: UInt32 = 282
USB_NOTIFY_ON_TRANSPORT_CHARACTERISTICS_CHANGE: UInt32 = 283
USB_UNREGISTER_FOR_TRANSPORT_CHARACTERISTICS_CHANGE: UInt32 = 284
USB_START_TRACKING_FOR_TIME_SYNC: UInt32 = 285
USB_GET_FRAME_NUMBER_AND_QPC_FOR_TIME_SYNC: UInt32 = 286
USB_STOP_TRACKING_FOR_TIME_SYNC: UInt32 = 287
USB_GET_DEVICE_CHARACTERISTICS: UInt32 = 288
USB_RESERVED_USER_BASE: UInt32 = 1024
GUID_DEVINTERFACE_USB_HUB: Guid = Guid('{f18a0e88-c30c-11d0-8815-00a0c906bed8}')
GUID_DEVINTERFACE_USB_BILLBOARD: Guid = Guid('{5e9adaef-f879-473f-b807-4e5ea77d1b1c}')
GUID_DEVINTERFACE_USB_DEVICE: Guid = Guid('{a5dcbf10-6530-11d2-901f-00c04fb951ed}')
GUID_DEVINTERFACE_USB_HOST_CONTROLLER: Guid = Guid('{3abf6f2d-71c4-462a-8a92-1e6861e6af27}')
GUID_USB_WMI_STD_DATA: Guid = Guid('{4e623b20-cb14-11d1-b331-00a0c959bbd2}')
GUID_USB_WMI_STD_NOTIFICATION: Guid = Guid('{4e623b20-cb14-11d1-b331-00a0c959bbd2}')
GUID_USB_WMI_DEVICE_PERF_INFO: Guid = Guid('{66c1aa3c-499f-49a0-a9a5-61e2359f6407}')
GUID_USB_WMI_NODE_INFO: Guid = Guid('{9c179357-dc7a-4f41-b66b-323b9ddcb5b1}')
GUID_USB_WMI_TRACING: Guid = Guid('{3a61881b-b4e6-4bf9-ae0f-3cd8f394e52f}')
GUID_USB_TRANSFER_TRACING: Guid = Guid('{681eb8aa-403d-452c-9f8a-f0616fac9540}')
GUID_USB_PERFORMANCE_TRACING: Guid = Guid('{d5de77a6-6ae9-425c-b1e2-f5615fd348a9}')
GUID_USB_WMI_SURPRISE_REMOVAL_NOTIFICATION: Guid = Guid('{9bbbf831-a2f2-43b4-96d1-86944b5914b3}')
FILE_DEVICE_USB: UInt32 = 34
BMREQUEST_HOST_TO_DEVICE: UInt32 = 0
BMREQUEST_DEVICE_TO_HOST: UInt32 = 1
BMREQUEST_STANDARD: UInt32 = 0
BMREQUEST_CLASS: UInt32 = 1
BMREQUEST_VENDOR: UInt32 = 2
BMREQUEST_TO_DEVICE: UInt32 = 0
BMREQUEST_TO_INTERFACE: UInt32 = 1
BMREQUEST_TO_ENDPOINT: UInt32 = 2
BMREQUEST_TO_OTHER: UInt32 = 3
USB_REQUEST_GET_STATUS: UInt32 = 0
USB_REQUEST_CLEAR_FEATURE: UInt32 = 1
USB_REQUEST_SET_FEATURE: UInt32 = 3
USB_REQUEST_SET_ADDRESS: UInt32 = 5
USB_REQUEST_GET_DESCRIPTOR: UInt32 = 6
USB_REQUEST_SET_DESCRIPTOR: UInt32 = 7
USB_REQUEST_GET_CONFIGURATION: UInt32 = 8
USB_REQUEST_SET_CONFIGURATION: UInt32 = 9
USB_REQUEST_GET_INTERFACE: UInt32 = 10
USB_REQUEST_SET_INTERFACE: UInt32 = 11
USB_REQUEST_SYNC_FRAME: UInt32 = 12
USB_REQUEST_GET_FIRMWARE_STATUS: UInt32 = 26
USB_REQUEST_SET_FIRMWARE_STATUS: UInt32 = 27
USB_GET_FIRMWARE_ALLOWED_OR_DISALLOWED_STATE: UInt32 = 0
USB_GET_FIRMWARE_HASH: UInt32 = 1
USB_DEVICE_FIRMWARE_HASH_LENGTH: UInt32 = 32
USB_DISALLOW_FIRMWARE_UPDATE: UInt32 = 0
USB_ALLOW_FIRMWARE_UPDATE: UInt32 = 1
USB_REQUEST_SET_SEL: UInt32 = 48
USB_REQUEST_ISOCH_DELAY: UInt32 = 49
USB_DEVICE_DESCRIPTOR_TYPE: UInt32 = 1
USB_CONFIGURATION_DESCRIPTOR_TYPE: UInt32 = 2
USB_STRING_DESCRIPTOR_TYPE: UInt32 = 3
USB_INTERFACE_DESCRIPTOR_TYPE: UInt32 = 4
USB_ENDPOINT_DESCRIPTOR_TYPE: UInt32 = 5
USB_DEVICE_QUALIFIER_DESCRIPTOR_TYPE: UInt32 = 6
USB_OTHER_SPEED_CONFIGURATION_DESCRIPTOR_TYPE: UInt32 = 7
USB_INTERFACE_POWER_DESCRIPTOR_TYPE: UInt32 = 8
USB_OTG_DESCRIPTOR_TYPE: UInt32 = 9
USB_DEBUG_DESCRIPTOR_TYPE: UInt32 = 10
USB_INTERFACE_ASSOCIATION_DESCRIPTOR_TYPE: UInt32 = 11
USB_BOS_DESCRIPTOR_TYPE: UInt32 = 15
USB_DEVICE_CAPABILITY_DESCRIPTOR_TYPE: UInt32 = 16
USB_SUPERSPEED_ENDPOINT_COMPANION_DESCRIPTOR_TYPE: UInt32 = 48
USB_SUPERSPEEDPLUS_ISOCH_ENDPOINT_COMPANION_DESCRIPTOR_TYPE: UInt32 = 49
USB_RESERVED_DESCRIPTOR_TYPE: UInt32 = 6
USB_CONFIG_POWER_DESCRIPTOR_TYPE: UInt32 = 7
USB_FEATURE_ENDPOINT_STALL: UInt32 = 0
USB_FEATURE_REMOTE_WAKEUP: UInt32 = 1
USB_FEATURE_TEST_MODE: UInt32 = 2
USB_FEATURE_FUNCTION_SUSPEND: UInt32 = 0
USB_FEATURE_U1_ENABLE: UInt32 = 48
USB_FEATURE_U2_ENABLE: UInt32 = 49
USB_FEATURE_LTM_ENABLE: UInt32 = 50
USB_FEATURE_LDM_ENABLE: UInt32 = 53
USB_FEATURE_BATTERY_WAKE_MASK: UInt32 = 40
USB_FEATURE_OS_IS_PD_AWARE: UInt32 = 41
USB_FEATURE_POLICY_MODE: UInt32 = 42
USB_FEATURE_CHARGING_POLICY: UInt32 = 54
USB_CHARGING_POLICY_DEFAULT: UInt32 = 0
USB_CHARGING_POLICY_ICCHPF: UInt32 = 1
USB_CHARGING_POLICY_ICCLPF: UInt32 = 2
USB_CHARGING_POLICY_NO_POWER: UInt32 = 3
USB_STATUS_PORT_STATUS: UInt32 = 0
USB_STATUS_PD_STATUS: UInt32 = 1
USB_STATUS_EXT_PORT_STATUS: UInt32 = 2
USB_GETSTATUS_SELF_POWERED: UInt32 = 1
USB_GETSTATUS_REMOTE_WAKEUP_ENABLED: UInt32 = 2
USB_GETSTATUS_U1_ENABLE: UInt32 = 4
USB_GETSTATUS_U2_ENABLE: UInt32 = 8
USB_GETSTATUS_LTM_ENABLE: UInt32 = 16
USB_DEVICE_CLASS_RESERVED: UInt32 = 0
USB_DEVICE_CLASS_AUDIO: UInt32 = 1
USB_DEVICE_CLASS_COMMUNICATIONS: UInt32 = 2
USB_DEVICE_CLASS_HUMAN_INTERFACE: UInt32 = 3
USB_DEVICE_CLASS_MONITOR: UInt32 = 4
USB_DEVICE_CLASS_PHYSICAL_INTERFACE: UInt32 = 5
USB_DEVICE_CLASS_POWER: UInt32 = 6
USB_DEVICE_CLASS_IMAGE: UInt32 = 6
USB_DEVICE_CLASS_PRINTER: UInt32 = 7
USB_DEVICE_CLASS_STORAGE: UInt32 = 8
USB_DEVICE_CLASS_HUB: UInt32 = 9
USB_DEVICE_CLASS_CDC_DATA: UInt32 = 10
USB_DEVICE_CLASS_SMART_CARD: UInt32 = 11
USB_DEVICE_CLASS_CONTENT_SECURITY: UInt32 = 13
USB_DEVICE_CLASS_VIDEO: UInt32 = 14
USB_DEVICE_CLASS_PERSONAL_HEALTHCARE: UInt32 = 15
USB_DEVICE_CLASS_AUDIO_VIDEO: UInt32 = 16
USB_DEVICE_CLASS_BILLBOARD: UInt32 = 17
USB_DEVICE_CLASS_DIAGNOSTIC_DEVICE: UInt32 = 220
USB_DEVICE_CLASS_WIRELESS_CONTROLLER: UInt32 = 224
USB_DEVICE_CLASS_MISCELLANEOUS: UInt32 = 239
USB_DEVICE_CLASS_APPLICATION_SPECIFIC: UInt32 = 254
USB_DEVICE_CLASS_VENDOR_SPECIFIC: UInt32 = 255
USB_DEVICE_CAPABILITY_WIRELESS_USB: UInt32 = 1
USB_DEVICE_CAPABILITY_USB20_EXTENSION: UInt32 = 2
USB_DEVICE_CAPABILITY_SUPERSPEED_USB: UInt32 = 3
USB_DEVICE_CAPABILITY_CONTAINER_ID: UInt32 = 4
USB_DEVICE_CAPABILITY_PLATFORM: UInt32 = 5
USB_DEVICE_CAPABILITY_POWER_DELIVERY: UInt32 = 6
USB_DEVICE_CAPABILITY_BATTERY_INFO: UInt32 = 7
USB_DEVICE_CAPABILITY_PD_CONSUMER_PORT: UInt32 = 8
USB_DEVICE_CAPABILITY_PD_PROVIDER_PORT: UInt32 = 9
USB_DEVICE_CAPABILITY_SUPERSPEEDPLUS_USB: UInt32 = 10
USB_DEVICE_CAPABILITY_PRECISION_TIME_MEASUREMENT: UInt32 = 11
USB_DEVICE_CAPABILITY_BILLBOARD: UInt32 = 13
USB_DEVICE_CAPABILITY_FIRMWARE_STATUS: UInt32 = 17
USB_DEVICE_CAPABILITY_USB20_EXTENSION_BMATTRIBUTES_RESERVED_MASK: UInt32 = 4294901985
USB_DEVICE_CAPABILITY_SUPERSPEED_BMATTRIBUTES_RESERVED_MASK: UInt32 = 253
USB_DEVICE_CAPABILITY_SUPERSPEED_BMATTRIBUTES_LTM_CAPABLE: UInt32 = 2
USB_DEVICE_CAPABILITY_SUPERSPEED_SPEEDS_SUPPORTED_RESERVED_MASK: UInt32 = 65520
USB_DEVICE_CAPABILITY_SUPERSPEED_SPEEDS_SUPPORTED_LOW: UInt32 = 1
USB_DEVICE_CAPABILITY_SUPERSPEED_SPEEDS_SUPPORTED_FULL: UInt32 = 2
USB_DEVICE_CAPABILITY_SUPERSPEED_SPEEDS_SUPPORTED_HIGH: UInt32 = 4
USB_DEVICE_CAPABILITY_SUPERSPEED_SPEEDS_SUPPORTED_SUPER: UInt32 = 8
USB_DEVICE_CAPABILITY_SUPERSPEED_U1_DEVICE_EXIT_MAX_VALUE: UInt32 = 10
USB_DEVICE_CAPABILITY_SUPERSPEED_U2_DEVICE_EXIT_MAX_VALUE: UInt32 = 2047
USB_DEVICE_CAPABILITY_MAX_U1_LATENCY: UInt32 = 10
USB_DEVICE_CAPABILITY_MAX_U2_LATENCY: UInt32 = 2047
USB_DEVICE_CAPABILITY_SUPERSPEEDPLUS_SPEED_LSE_BPS: UInt32 = 0
USB_DEVICE_CAPABILITY_SUPERSPEEDPLUS_SPEED_LSE_KBPS: UInt32 = 1
USB_DEVICE_CAPABILITY_SUPERSPEEDPLUS_SPEED_LSE_MBPS: UInt32 = 2
USB_DEVICE_CAPABILITY_SUPERSPEEDPLUS_SPEED_LSE_GBPS: UInt32 = 3
USB_DEVICE_CAPABILITY_SUPERSPEEDPLUS_SPEED_MODE_SYMMETRIC: UInt32 = 0
USB_DEVICE_CAPABILITY_SUPERSPEEDPLUS_SPEED_MODE_ASYMMETRIC: UInt32 = 1
USB_DEVICE_CAPABILITY_SUPERSPEEDPLUS_SPEED_DIR_RX: UInt32 = 0
USB_DEVICE_CAPABILITY_SUPERSPEEDPLUS_SPEED_DIR_TX: UInt32 = 1
USB_DEVICE_CAPABILITY_SUPERSPEEDPLUS_SPEED_PROTOCOL_SS: UInt32 = 0
USB_DEVICE_CAPABILITY_SUPERSPEEDPLUS_SPEED_PROTOCOL_SSP: UInt32 = 1
GUID_USB_MSOS20_PLATFORM_CAPABILITY_ID: Guid = Guid('{d8dd60df-4589-4cc7-9cd2-659d9e648a9f}')
USB_CONFIG_POWERED_MASK: UInt32 = 192
USB_CONFIG_BUS_POWERED: UInt32 = 128
USB_CONFIG_SELF_POWERED: UInt32 = 64
USB_CONFIG_REMOTE_WAKEUP: UInt32 = 32
USB_CONFIG_RESERVED: UInt32 = 31
USB_ENDPOINT_DIRECTION_MASK: UInt32 = 128
USB_ENDPOINT_ADDRESS_MASK: UInt32 = 15
USB_ENDPOINT_TYPE_MASK: UInt32 = 3
USB_ENDPOINT_TYPE_CONTROL: UInt32 = 0
USB_ENDPOINT_TYPE_ISOCHRONOUS: UInt32 = 1
USB_ENDPOINT_TYPE_BULK: UInt32 = 2
USB_ENDPOINT_TYPE_INTERRUPT: UInt32 = 3
USB_ENDPOINT_TYPE_BULK_RESERVED_MASK: UInt32 = 252
USB_ENDPOINT_TYPE_CONTROL_RESERVED_MASK: UInt32 = 252
USB_20_ENDPOINT_TYPE_INTERRUPT_RESERVED_MASK: UInt32 = 252
USB_30_ENDPOINT_TYPE_INTERRUPT_RESERVED_MASK: UInt32 = 204
USB_ENDPOINT_TYPE_ISOCHRONOUS_RESERVED_MASK: UInt32 = 192
USB_30_ENDPOINT_TYPE_INTERRUPT_USAGE_MASK: UInt32 = 48
USB_30_ENDPOINT_TYPE_INTERRUPT_USAGE_PERIODIC: UInt32 = 0
USB_30_ENDPOINT_TYPE_INTERRUPT_USAGE_NOTIFICATION: UInt32 = 16
USB_30_ENDPOINT_TYPE_INTERRUPT_USAGE_RESERVED10: UInt32 = 32
USB_30_ENDPOINT_TYPE_INTERRUPT_USAGE_RESERVED11: UInt32 = 48
USB_ENDPOINT_TYPE_ISOCHRONOUS_SYNCHRONIZATION_MASK: UInt32 = 12
USB_ENDPOINT_TYPE_ISOCHRONOUS_SYNCHRONIZATION_NO_SYNCHRONIZATION: UInt32 = 0
USB_ENDPOINT_TYPE_ISOCHRONOUS_SYNCHRONIZATION_ASYNCHRONOUS: UInt32 = 4
USB_ENDPOINT_TYPE_ISOCHRONOUS_SYNCHRONIZATION_ADAPTIVE: UInt32 = 8
USB_ENDPOINT_TYPE_ISOCHRONOUS_SYNCHRONIZATION_SYNCHRONOUS: UInt32 = 12
USB_ENDPOINT_TYPE_ISOCHRONOUS_USAGE_MASK: UInt32 = 48
USB_ENDPOINT_TYPE_ISOCHRONOUS_USAGE_DATA_ENDOINT: UInt32 = 0
USB_ENDPOINT_TYPE_ISOCHRONOUS_USAGE_FEEDBACK_ENDPOINT: UInt32 = 16
USB_ENDPOINT_TYPE_ISOCHRONOUS_USAGE_IMPLICIT_FEEDBACK_DATA_ENDPOINT: UInt32 = 32
USB_ENDPOINT_TYPE_ISOCHRONOUS_USAGE_RESERVED: UInt32 = 48
USB_ENDPOINT_SUPERSPEED_BULK_MAX_PACKET_SIZE: UInt32 = 1024
USB_ENDPOINT_SUPERSPEED_CONTROL_MAX_PACKET_SIZE: UInt32 = 512
USB_ENDPOINT_SUPERSPEED_ISO_MAX_PACKET_SIZE: UInt32 = 1024
USB_ENDPOINT_SUPERSPEED_INTERRUPT_MAX_PACKET_SIZE: UInt32 = 1024
MAXIMUM_USB_STRING_LENGTH: UInt32 = 255
USB_SUPERSPEED_ISOCHRONOUS_MAX_MULTIPLIER: UInt32 = 2
USB_SUPERSPEEDPLUS_ISOCHRONOUS_MIN_BYTESPERINTERVAL: UInt32 = 49153
USB_SUPERSPEEDPLUS_ISOCHRONOUS_MAX_BYTESPERINTERVAL: UInt32 = 16777215
USB_20_HUB_DESCRIPTOR_TYPE: UInt32 = 41
USB_30_HUB_DESCRIPTOR_TYPE: UInt32 = 42
USB_REQUEST_GET_STATE: UInt32 = 2
USB_REQUEST_CLEAR_TT_BUFFER: UInt32 = 8
USB_REQUEST_RESET_TT: UInt32 = 9
USB_REQUEST_GET_TT_STATE: UInt32 = 10
USB_REQUEST_STOP_TT: UInt32 = 11
USB_REQUEST_SET_HUB_DEPTH: UInt32 = 12
USB_REQUEST_GET_PORT_ERR_COUNT: UInt32 = 13
USB_PORT_STATUS_CONNECT: UInt32 = 1
USB_PORT_STATUS_ENABLE: UInt32 = 2
USB_PORT_STATUS_SUSPEND: UInt32 = 4
USB_PORT_STATUS_OVER_CURRENT: UInt32 = 8
USB_PORT_STATUS_RESET: UInt32 = 16
USB_PORT_STATUS_POWER: UInt32 = 256
USB_PORT_STATUS_LOW_SPEED: UInt32 = 512
USB_PORT_STATUS_HIGH_SPEED: UInt32 = 1024
PORT_LINK_STATE_U0: UInt32 = 0
PORT_LINK_STATE_U1: UInt32 = 1
PORT_LINK_STATE_U2: UInt32 = 2
PORT_LINK_STATE_U3: UInt32 = 3
PORT_LINK_STATE_DISABLED: UInt32 = 4
PORT_LINK_STATE_RX_DETECT: UInt32 = 5
PORT_LINK_STATE_INACTIVE: UInt32 = 6
PORT_LINK_STATE_POLLING: UInt32 = 7
PORT_LINK_STATE_RECOVERY: UInt32 = 8
PORT_LINK_STATE_HOT_RESET: UInt32 = 9
PORT_LINK_STATE_COMPLIANCE_MODE: UInt32 = 10
PORT_LINK_STATE_LOOPBACK: UInt32 = 11
PORT_LINK_STATE_TEST_MODE: UInt32 = 11
USB_FEATURE_INTERFACE_POWER_D0: UInt32 = 2
USB_FEATURE_INTERFACE_POWER_D1: UInt32 = 3
USB_FEATURE_INTERFACE_POWER_D2: UInt32 = 4
USB_FEATURE_INTERFACE_POWER_D3: UInt32 = 5
USB_SUPPORT_D0_COMMAND: UInt32 = 1
USB_SUPPORT_D1_COMMAND: UInt32 = 2
USB_SUPPORT_D2_COMMAND: UInt32 = 4
USB_SUPPORT_D3_COMMAND: UInt32 = 8
USB_SUPPORT_D1_WAKEUP: UInt32 = 16
USB_SUPPORT_D2_WAKEUP: UInt32 = 32
USBDI_VERSION: UInt32 = 1536
USB_PORTATTR_NO_CONNECTOR: UInt32 = 1
USB_PORTATTR_SHARED_USB2: UInt32 = 2
USB_PORTATTR_MINI_CONNECTOR: UInt32 = 4
USB_PORTATTR_OEM_CONNECTOR: UInt32 = 8
USB_PORTATTR_OWNED_BY_CC: UInt32 = 16777216
USB_PORTATTR_NO_OVERCURRENT_UI: UInt32 = 33554432
USB_DEFAULT_DEVICE_ADDRESS: UInt32 = 0
USB_DEFAULT_ENDPOINT_ADDRESS: UInt32 = 0
USB_DEFAULT_MAX_PACKET: UInt32 = 64
URB_FUNCTION_SELECT_CONFIGURATION: UInt32 = 0
URB_FUNCTION_SELECT_INTERFACE: UInt32 = 1
URB_FUNCTION_ABORT_PIPE: UInt32 = 2
URB_FUNCTION_TAKE_FRAME_LENGTH_CONTROL: UInt32 = 3
URB_FUNCTION_RELEASE_FRAME_LENGTH_CONTROL: UInt32 = 4
URB_FUNCTION_GET_FRAME_LENGTH: UInt32 = 5
URB_FUNCTION_SET_FRAME_LENGTH: UInt32 = 6
URB_FUNCTION_GET_CURRENT_FRAME_NUMBER: UInt32 = 7
URB_FUNCTION_CONTROL_TRANSFER: UInt32 = 8
URB_FUNCTION_BULK_OR_INTERRUPT_TRANSFER: UInt32 = 9
URB_FUNCTION_ISOCH_TRANSFER: UInt32 = 10
URB_FUNCTION_GET_DESCRIPTOR_FROM_DEVICE: UInt32 = 11
URB_FUNCTION_SET_DESCRIPTOR_TO_DEVICE: UInt32 = 12
URB_FUNCTION_SET_FEATURE_TO_DEVICE: UInt32 = 13
URB_FUNCTION_SET_FEATURE_TO_INTERFACE: UInt32 = 14
URB_FUNCTION_SET_FEATURE_TO_ENDPOINT: UInt32 = 15
URB_FUNCTION_CLEAR_FEATURE_TO_DEVICE: UInt32 = 16
URB_FUNCTION_CLEAR_FEATURE_TO_INTERFACE: UInt32 = 17
URB_FUNCTION_CLEAR_FEATURE_TO_ENDPOINT: UInt32 = 18
URB_FUNCTION_GET_STATUS_FROM_DEVICE: UInt32 = 19
URB_FUNCTION_GET_STATUS_FROM_INTERFACE: UInt32 = 20
URB_FUNCTION_GET_STATUS_FROM_ENDPOINT: UInt32 = 21
URB_FUNCTION_RESERVED_0X0016: UInt32 = 22
URB_FUNCTION_VENDOR_DEVICE: UInt32 = 23
URB_FUNCTION_VENDOR_INTERFACE: UInt32 = 24
URB_FUNCTION_VENDOR_ENDPOINT: UInt32 = 25
URB_FUNCTION_CLASS_DEVICE: UInt32 = 26
URB_FUNCTION_CLASS_INTERFACE: UInt32 = 27
URB_FUNCTION_CLASS_ENDPOINT: UInt32 = 28
URB_FUNCTION_RESERVE_0X001D: UInt32 = 29
URB_FUNCTION_SYNC_RESET_PIPE_AND_CLEAR_STALL: UInt32 = 30
URB_FUNCTION_CLASS_OTHER: UInt32 = 31
URB_FUNCTION_VENDOR_OTHER: UInt32 = 32
URB_FUNCTION_GET_STATUS_FROM_OTHER: UInt32 = 33
URB_FUNCTION_CLEAR_FEATURE_TO_OTHER: UInt32 = 34
URB_FUNCTION_SET_FEATURE_TO_OTHER: UInt32 = 35
URB_FUNCTION_GET_DESCRIPTOR_FROM_ENDPOINT: UInt32 = 36
URB_FUNCTION_SET_DESCRIPTOR_TO_ENDPOINT: UInt32 = 37
URB_FUNCTION_GET_CONFIGURATION: UInt32 = 38
URB_FUNCTION_GET_INTERFACE: UInt32 = 39
URB_FUNCTION_GET_DESCRIPTOR_FROM_INTERFACE: UInt32 = 40
URB_FUNCTION_SET_DESCRIPTOR_TO_INTERFACE: UInt32 = 41
URB_FUNCTION_RESERVE_0X002B: UInt32 = 43
URB_FUNCTION_RESERVE_0X002C: UInt32 = 44
URB_FUNCTION_RESERVE_0X002D: UInt32 = 45
URB_FUNCTION_RESERVE_0X002E: UInt32 = 46
URB_FUNCTION_RESERVE_0X002F: UInt32 = 47
URB_FUNCTION_GET_MS_FEATURE_DESCRIPTOR: UInt32 = 42
URB_FUNCTION_SYNC_RESET_PIPE: UInt32 = 48
URB_FUNCTION_SYNC_CLEAR_STALL: UInt32 = 49
URB_FUNCTION_CONTROL_TRANSFER_EX: UInt32 = 50
URB_FUNCTION_RESERVE_0X0033: UInt32 = 51
URB_FUNCTION_RESERVE_0X0034: UInt32 = 52
URB_FUNCTION_OPEN_STATIC_STREAMS: UInt32 = 53
URB_FUNCTION_CLOSE_STATIC_STREAMS: UInt32 = 54
URB_FUNCTION_BULK_OR_INTERRUPT_TRANSFER_USING_CHAINED_MDL: UInt32 = 55
URB_FUNCTION_ISOCH_TRANSFER_USING_CHAINED_MDL: UInt32 = 56
URB_FUNCTION_GET_ISOCH_PIPE_TRANSFER_PATH_DELAYS: UInt32 = 61
URB_FUNCTION_RESET_PIPE: UInt32 = 30
USBD_SHORT_TRANSFER_OK: UInt32 = 2
USBD_START_ISO_TRANSFER_ASAP: UInt32 = 4
USBD_DEFAULT_PIPE_TRANSFER: UInt32 = 8
USBD_TRANSFER_DIRECTION_OUT: UInt32 = 0
USBD_TRANSFER_DIRECTION_IN: UInt32 = 1
USBD_TRANSFER_DIRECTION: UInt32 = 1
USBD_ISO_START_FRAME_RANGE: UInt32 = 1024
USBD_DEFAULT_MAXIMUM_TRANSFER_SIZE: UInt32 = 4294967295
USBD_PF_CHANGE_MAX_PACKET: UInt32 = 1
USBD_PF_SHORT_PACKET_OPT: UInt32 = 2
USBD_PF_ENABLE_RT_THREAD_ACCESS: UInt32 = 4
USBD_PF_MAP_ADD_TRANSFERS: UInt32 = 8
USBD_PF_VIDEO_PRIORITY: UInt32 = 16
USBD_PF_VOICE_PRIORITY: UInt32 = 32
USBD_PF_INTERACTIVE_PRIORITY: UInt32 = 48
USBD_PF_PRIORITY_MASK: UInt32 = 240
USBD_PF_HANDLES_SSP_HIGH_BANDWIDTH_ISOCH: UInt32 = 256
USBD_PF_SSP_HIGH_BANDWIDTH_ISOCH: UInt32 = 65536
OS_STRING_DESCRIPTOR_INDEX: UInt32 = 238
MS_GENRE_DESCRIPTOR_INDEX: UInt32 = 1
MS_POWER_DESCRIPTOR_INDEX: UInt32 = 2
MS_OS_STRING_SIGNATURE: String = 'MSFT100'
MS_OS_FLAGS_CONTAINERID: UInt32 = 2
URB_OPEN_STATIC_STREAMS_VERSION_100: UInt32 = 256
KREGUSBFNENUMPATH: String = '\\Registry\\Machine\\SYSTEM\\CurrentControlSet\\Control\\USBFN\\'
UREGUSBFNENUMPATH: String = 'HKEY_LOCAL_MACHINE\\SYSTEM\\CurrentControlSet\\Control\\USBFN\\'
KREGMANUSBFNENUMPATH: String = '\\Registry\\Machine\\SYSTEM\\CurrentControlSet\\Control\\ManufacturingMode\\Current\\USBFN\\'
UREGMANUSBFNENUMPATH: String = 'HKEY_LOCAL_MACHINE\\SYSTEM\\CurrentControlSet\\Control\\ManufacturingMode\\Current\\USBFN\\'
MAX_NUM_USBFN_ENDPOINTS: UInt32 = 15
MAX_CONFIGURATION_NAME_LENGTH: UInt32 = 40
MAX_USB_STRING_LENGTH: UInt32 = 255
MAX_SUPPORTED_CONFIGURATIONS: UInt32 = 12
USBFN_INTERRUPT_ENDPOINT_SIZE_NOT_UPDATEABLE_MASK: UInt32 = 128
USB_TEST_MODE_TEST_J: UInt32 = 1
USB_TEST_MODE_TEST_K: UInt32 = 2
USB_TEST_MODE_TEST_SE0_NAK: UInt32 = 3
USB_TEST_MODE_TEST_PACKET: UInt32 = 4
USB_TEST_MODE_TEST_FORCE_ENABLE: UInt32 = 5
MAX_INTERFACE_NAME_LENGTH: UInt32 = 40
MAX_ALTERNATE_NAME_LENGTH: UInt32 = 40
MAX_ASSOCIATION_NAME_LENGTH: UInt32 = 40
IOCTL_INTERNAL_USB_SUBMIT_URB: UInt32 = 2228227
IOCTL_INTERNAL_USB_RESET_PORT: UInt32 = 2228231
IOCTL_INTERNAL_USB_GET_ROOTHUB_PDO: UInt32 = 2228239
USBD_PORT_ENABLED: UInt32 = 1
USBD_PORT_CONNECTED: UInt32 = 2
IOCTL_INTERNAL_USB_GET_PORT_STATUS: UInt32 = 2228243
IOCTL_INTERNAL_USB_ENABLE_PORT: UInt32 = 2228247
IOCTL_INTERNAL_USB_GET_HUB_COUNT: UInt32 = 2228251
IOCTL_INTERNAL_USB_CYCLE_PORT: UInt32 = 2228255
IOCTL_INTERNAL_USB_GET_HUB_NAME: UInt32 = 2228256
IOCTL_INTERNAL_USB_GET_BUS_INFO: UInt32 = 2229280
IOCTL_INTERNAL_USB_GET_CONTROLLER_NAME: UInt32 = 2229284
IOCTL_INTERNAL_USB_GET_BUSGUID_INFO: UInt32 = 2229288
IOCTL_INTERNAL_USB_GET_PARENT_HUB_INFO: UInt32 = 2229292
IOCTL_INTERNAL_USB_SUBMIT_IDLE_NOTIFICATION: UInt32 = 2228263
IOCTL_INTERNAL_USB_GET_DEVICE_HANDLE: UInt32 = 2229299
IOCTL_INTERNAL_USB_NOTIFY_IDLE_READY: UInt32 = 2229315
IOCTL_INTERNAL_USB_REQ_GLOBAL_SUSPEND: UInt32 = 2229319
IOCTL_INTERNAL_USB_REQ_GLOBAL_RESUME: UInt32 = 2229323
IOCTL_INTERNAL_USB_RECORD_FAILURE: UInt32 = 2228267
IOCTL_INTERNAL_USB_GET_DEVICE_HANDLE_EX: UInt32 = 2229303
IOCTL_INTERNAL_USB_GET_TT_DEVICE_HANDLE: UInt32 = 2229307
IOCTL_INTERNAL_USB_GET_TOPOLOGY_ADDRESS: UInt32 = 2229311
IOCTL_INTERNAL_USB_GET_DEVICE_CONFIG_INFO: UInt32 = 2229327
IOCTL_INTERNAL_USB_REGISTER_COMPOSITE_DEVICE: UInt32 = 4784131
IOCTL_INTERNAL_USB_UNREGISTER_COMPOSITE_DEVICE: UInt32 = 4784135
IOCTL_INTERNAL_USB_REQUEST_REMOTE_WAKE_NOTIFICATION: UInt32 = 4784139
IOCTL_INTERNAL_USB_FAIL_GET_STATUS_FROM_DEVICE: UInt32 = 2229347
IOCTL_USB_HCD_GET_STATS_1: UInt32 = 2229244
IOCTL_USB_HCD_GET_STATS_2: UInt32 = 2229288
IOCTL_USB_HCD_DISABLE_PORT: UInt32 = 2229296
IOCTL_USB_HCD_ENABLE_PORT: UInt32 = 2229300
IOCTL_USB_DIAGNOSTIC_MODE_ON: UInt32 = 2229248
IOCTL_USB_DIAGNOSTIC_MODE_OFF: UInt32 = 2229252
IOCTL_USB_GET_ROOT_HUB_NAME: UInt32 = 2229256
IOCTL_GET_HCD_DRIVERKEY_NAME: UInt32 = 2229284
IOCTL_USB_GET_NODE_INFORMATION: UInt32 = 2229256
IOCTL_USB_GET_NODE_CONNECTION_INFORMATION: UInt32 = 2229260
IOCTL_USB_GET_DESCRIPTOR_FROM_NODE_CONNECTION: UInt32 = 2229264
IOCTL_USB_GET_NODE_CONNECTION_NAME: UInt32 = 2229268
IOCTL_USB_DIAG_IGNORE_HUBS_ON: UInt32 = 2229272
IOCTL_USB_DIAG_IGNORE_HUBS_OFF: UInt32 = 2229276
IOCTL_USB_GET_NODE_CONNECTION_DRIVERKEY_NAME: UInt32 = 2229280
IOCTL_USB_GET_HUB_CAPABILITIES: UInt32 = 2229308
IOCTL_USB_HUB_CYCLE_PORT: UInt32 = 2229316
IOCTL_USB_GET_NODE_CONNECTION_ATTRIBUTES: UInt32 = 2229312
IOCTL_USB_GET_NODE_CONNECTION_INFORMATION_EX: UInt32 = 2229320
IOCTL_USB_RESET_HUB: UInt32 = 2229324
IOCTL_USB_GET_HUB_CAPABILITIES_EX: UInt32 = 2229328
IOCTL_USB_GET_HUB_INFORMATION_EX: UInt32 = 2229332
IOCTL_USB_GET_PORT_CONNECTOR_PROPERTIES: UInt32 = 2229336
IOCTL_USB_GET_NODE_CONNECTION_INFORMATION_EX_V2: UInt32 = 2229340
IOCTL_USB_GET_TRANSPORT_CHARACTERISTICS: UInt32 = 2229348
IOCTL_USB_REGISTER_FOR_TRANSPORT_CHARACTERISTICS_CHANGE: UInt32 = 2229352
IOCTL_USB_NOTIFY_ON_TRANSPORT_CHARACTERISTICS_CHANGE: UInt32 = 2229356
IOCTL_USB_UNREGISTER_FOR_TRANSPORT_CHARACTERISTICS_CHANGE: UInt32 = 2229360
IOCTL_USB_START_TRACKING_FOR_TIME_SYNC: UInt32 = 2229364
IOCTL_USB_GET_FRAME_NUMBER_AND_QPC_FOR_TIME_SYNC: UInt32 = 2229368
IOCTL_USB_STOP_TRACKING_FOR_TIME_SYNC: UInt32 = 2229372
IOCTL_USB_GET_DEVICE_CHARACTERISTICS: UInt32 = 2229376
WMI_USB_DRIVER_INFORMATION: UInt32 = 0
WMI_USB_DRIVER_NOTIFICATION: UInt32 = 1
WMI_USB_POWER_DEVICE_ENABLE: UInt32 = 2
WMI_USB_HUB_NODE_INFORMATION: UInt32 = 4
WMI_USB_PERFORMANCE_INFORMATION: UInt32 = 1
WMI_USB_DEVICE_NODE_INFORMATION: UInt32 = 2
USB_TRANSPORT_CHARACTERISTICS_VERSION_1: UInt32 = 1
USB_TRANSPORT_CHARACTERISTICS_LATENCY_AVAILABLE: UInt32 = 1
USB_TRANSPORT_CHARACTERISTICS_BANDWIDTH_AVAILABLE: UInt32 = 2
USB_REGISTER_FOR_TRANSPORT_LATENCY_CHANGE: UInt32 = 1
USB_REGISTER_FOR_TRANSPORT_BANDWIDTH_CHANGE: UInt32 = 2
USB_DEVICE_CHARACTERISTICS_VERSION_1: UInt32 = 1
USB_DEVICE_CHARACTERISTICS_MAXIMUM_PATH_DELAYS_AVAILABLE: UInt32 = 1
MAX_NUM_PIPES: UInt32 = 8
BULKIN_FLAG: UInt32 = 128
FILE_DEVICE_USB_SCAN: UInt32 = 32768
IOCTL_INDEX: UInt32 = 2048
IOCTL_GET_VERSION: UInt32 = 2147491840
IOCTL_CANCEL_IO: UInt32 = 2147491844
IOCTL_WAIT_ON_DEVICE_EVENT: UInt32 = 2147491848
IOCTL_READ_REGISTERS: UInt32 = 2147491852
IOCTL_WRITE_REGISTERS: UInt32 = 2147491856
IOCTL_GET_CHANNEL_ALIGN_RQST: UInt32 = 2147491860
IOCTL_GET_DEVICE_DESCRIPTOR: UInt32 = 2147491864
IOCTL_RESET_PIPE: UInt32 = 2147491868
IOCTL_GET_USB_DESCRIPTOR: UInt32 = 2147491872
IOCTL_SEND_USB_REQUEST: UInt32 = 2147491876
IOCTL_GET_PIPE_CONFIGURATION: UInt32 = 2147491880
IOCTL_SET_TIMEOUT: UInt32 = 2147491884
IOCTL_ABORT_PIPE: UInt32 = 2147491844
WinUSB_TestGuid: Guid = Guid('{da812bff-12c3-46a2-8e2b-dbd3b7834c43}')
@winfunctype('WINUSB.dll')
def WinUsb_Initialize(DeviceHandle: win32more.Windows.Win32.Foundation.HANDLE, InterfaceHandle: POINTER(win32more.Windows.Win32.Devices.Usb.WINUSB_INTERFACE_HANDLE)) -> win32more.Windows.Win32.Foundation.BOOL: ...
@winfunctype('WINUSB.dll')
def WinUsb_Free(InterfaceHandle: win32more.Windows.Win32.Devices.Usb.WINUSB_INTERFACE_HANDLE) -> win32more.Windows.Win32.Foundation.BOOL: ...
@winfunctype('WINUSB.dll')
def WinUsb_GetAssociatedInterface(InterfaceHandle: win32more.Windows.Win32.Devices.Usb.WINUSB_INTERFACE_HANDLE, AssociatedInterfaceIndex: Byte, AssociatedInterfaceHandle: POINTER(win32more.Windows.Win32.Devices.Usb.WINUSB_INTERFACE_HANDLE)) -> win32more.Windows.Win32.Foundation.BOOL: ...
@winfunctype('WINUSB.dll')
def WinUsb_GetDescriptor(InterfaceHandle: win32more.Windows.Win32.Devices.Usb.WINUSB_INTERFACE_HANDLE, DescriptorType: Byte, Index: Byte, LanguageID: UInt16, Buffer: POINTER(Byte), BufferLength: UInt32, LengthTransferred: POINTER(UInt32)) -> win32more.Windows.Win32.Foundation.BOOL: ...
@winfunctype('WINUSB.dll')
def WinUsb_QueryInterfaceSettings(InterfaceHandle: win32more.Windows.Win32.Devices.Usb.WINUSB_INTERFACE_HANDLE, AlternateInterfaceNumber: Byte, UsbAltInterfaceDescriptor: POINTER(win32more.Windows.Win32.Devices.Usb.USB_INTERFACE_DESCRIPTOR)) -> win32more.Windows.Win32.Foundation.BOOL: ...
@winfunctype('WINUSB.dll')
def WinUsb_QueryDeviceInformation(InterfaceHandle: win32more.Windows.Win32.Devices.Usb.WINUSB_INTERFACE_HANDLE, InformationType: UInt32, BufferLength: POINTER(UInt32), Buffer: VoidPtr) -> win32more.Windows.Win32.Foundation.BOOL: ...
@winfunctype('WINUSB.dll')
def WinUsb_SetCurrentAlternateSetting(InterfaceHandle: win32more.Windows.Win32.Devices.Usb.WINUSB_INTERFACE_HANDLE, SettingNumber: Byte) -> win32more.Windows.Win32.Foundation.BOOL: ...
@winfunctype('WINUSB.dll')
def WinUsb_GetCurrentAlternateSetting(InterfaceHandle: win32more.Windows.Win32.Devices.Usb.WINUSB_INTERFACE_HANDLE, SettingNumber: POINTER(Byte)) -> win32more.Windows.Win32.Foundation.BOOL: ...
@winfunctype('WINUSB.dll')
def WinUsb_QueryPipe(InterfaceHandle: win32more.Windows.Win32.Devices.Usb.WINUSB_INTERFACE_HANDLE, AlternateInterfaceNumber: Byte, PipeIndex: Byte, PipeInformation: POINTER(win32more.Windows.Win32.Devices.Usb.WINUSB_PIPE_INFORMATION)) -> win32more.Windows.Win32.Foundation.BOOL: ...
@winfunctype('WINUSB.dll')
def WinUsb_QueryPipeEx(InterfaceHandle: win32more.Windows.Win32.Devices.Usb.WINUSB_INTERFACE_HANDLE, AlternateSettingNumber: Byte, PipeIndex: Byte, PipeInformationEx: POINTER(win32more.Windows.Win32.Devices.Usb.WINUSB_PIPE_INFORMATION_EX)) -> win32more.Windows.Win32.Foundation.BOOL: ...
@winfunctype('WINUSB.dll')
def WinUsb_SetPipePolicy(InterfaceHandle: win32more.Windows.Win32.Devices.Usb.WINUSB_INTERFACE_HANDLE, PipeID: Byte, PolicyType: win32more.Windows.Win32.Devices.Usb.WINUSB_PIPE_POLICY, ValueLength: UInt32, Value: VoidPtr) -> win32more.Windows.Win32.Foundation.BOOL: ...
@winfunctype('WINUSB.dll')
def WinUsb_GetPipePolicy(InterfaceHandle: win32more.Windows.Win32.Devices.Usb.WINUSB_INTERFACE_HANDLE, PipeID: Byte, PolicyType: win32more.Windows.Win32.Devices.Usb.WINUSB_PIPE_POLICY, ValueLength: POINTER(UInt32), Value: VoidPtr) -> win32more.Windows.Win32.Foundation.BOOL: ...
@winfunctype('WINUSB.dll')
def WinUsb_ReadPipe(InterfaceHandle: win32more.Windows.Win32.Devices.Usb.WINUSB_INTERFACE_HANDLE, PipeID: Byte, Buffer: POINTER(Byte), BufferLength: UInt32, LengthTransferred: POINTER(UInt32), Overlapped: POINTER(win32more.Windows.Win32.System.IO.OVERLAPPED)) -> win32more.Windows.Win32.Foundation.BOOL: ...
@winfunctype('WINUSB.dll')
def WinUsb_WritePipe(InterfaceHandle: win32more.Windows.Win32.Devices.Usb.WINUSB_INTERFACE_HANDLE, PipeID: Byte, Buffer: POINTER(Byte), BufferLength: UInt32, LengthTransferred: POINTER(UInt32), Overlapped: POINTER(win32more.Windows.Win32.System.IO.OVERLAPPED)) -> win32more.Windows.Win32.Foundation.BOOL: ...
@winfunctype('WINUSB.dll')
def WinUsb_ControlTransfer(InterfaceHandle: win32more.Windows.Win32.Devices.Usb.WINUSB_INTERFACE_HANDLE, SetupPacket: win32more.Windows.Win32.Devices.Usb.WINUSB_SETUP_PACKET, Buffer: POINTER(Byte), BufferLength: UInt32, LengthTransferred: POINTER(UInt32), Overlapped: POINTER(win32more.Windows.Win32.System.IO.OVERLAPPED)) -> win32more.Windows.Win32.Foundation.BOOL: ...
@winfunctype('WINUSB.dll')
def WinUsb_ResetPipe(InterfaceHandle: win32more.Windows.Win32.Devices.Usb.WINUSB_INTERFACE_HANDLE, PipeID: Byte) -> win32more.Windows.Win32.Foundation.BOOL: ...
@winfunctype('WINUSB.dll')
def WinUsb_AbortPipe(InterfaceHandle: win32more.Windows.Win32.Devices.Usb.WINUSB_INTERFACE_HANDLE, PipeID: Byte) -> win32more.Windows.Win32.Foundation.BOOL: ...
@winfunctype('WINUSB.dll')
def WinUsb_FlushPipe(InterfaceHandle: win32more.Windows.Win32.Devices.Usb.WINUSB_INTERFACE_HANDLE, PipeID: Byte) -> win32more.Windows.Win32.Foundation.BOOL: ...
@winfunctype('WINUSB.dll')
def WinUsb_SetPowerPolicy(InterfaceHandle: win32more.Windows.Win32.Devices.Usb.WINUSB_INTERFACE_HANDLE, PolicyType: win32more.Windows.Win32.Devices.Usb.WINUSB_POWER_POLICY, ValueLength: UInt32, Value: VoidPtr) -> win32more.Windows.Win32.Foundation.BOOL: ...
@winfunctype('WINUSB.dll')
def WinUsb_GetPowerPolicy(InterfaceHandle: win32more.Windows.Win32.Devices.Usb.WINUSB_INTERFACE_HANDLE, PolicyType: win32more.Windows.Win32.Devices.Usb.WINUSB_POWER_POLICY, ValueLength: POINTER(UInt32), Value: VoidPtr) -> win32more.Windows.Win32.Foundation.BOOL: ...
@winfunctype('WINUSB.dll')
def WinUsb_GetOverlappedResult(InterfaceHandle: win32more.Windows.Win32.Devices.Usb.WINUSB_INTERFACE_HANDLE, lpOverlapped: POINTER(win32more.Windows.Win32.System.IO.OVERLAPPED), lpNumberOfBytesTransferred: POINTER(UInt32), bWait: win32more.Windows.Win32.Foundation.BOOL) -> win32more.Windows.Win32.Foundation.BOOL: ...
@winfunctype('WINUSB.dll')
def WinUsb_ParseConfigurationDescriptor(ConfigurationDescriptor: POINTER(win32more.Windows.Win32.Devices.Usb.USB_CONFIGURATION_DESCRIPTOR), StartPosition: VoidPtr, InterfaceNumber: Int32, AlternateSetting: Int32, InterfaceClass: Int32, InterfaceSubClass: Int32, InterfaceProtocol: Int32) -> POINTER(win32more.Windows.Win32.Devices.Usb.USB_INTERFACE_DESCRIPTOR): ...
@winfunctype('WINUSB.dll')
def WinUsb_ParseDescriptors(DescriptorBuffer: VoidPtr, TotalLength: UInt32, StartPosition: VoidPtr, DescriptorType: Int32) -> POINTER(win32more.Windows.Win32.Devices.Usb.USB_COMMON_DESCRIPTOR): ...
@winfunctype('WINUSB.dll')
def WinUsb_GetCurrentFrameNumber(InterfaceHandle: win32more.Windows.Win32.Devices.Usb.WINUSB_INTERFACE_HANDLE, CurrentFrameNumber: POINTER(UInt32), TimeStamp: POINTER(Int64)) -> win32more.Windows.Win32.Foundation.BOOL: ...
@winfunctype('WINUSB.dll')
def WinUsb_GetAdjustedFrameNumber(CurrentFrameNumber: POINTER(UInt32), TimeStamp: Int64) -> win32more.Windows.Win32.Foundation.BOOL: ...
@winfunctype('WINUSB.dll')
def WinUsb_RegisterIsochBuffer(InterfaceHandle: win32more.Windows.Win32.Devices.Usb.WINUSB_INTERFACE_HANDLE, PipeID: Byte, Buffer: POINTER(Byte), BufferLength: UInt32, IsochBufferHandle: POINTER(VoidPtr)) -> win32more.Windows.Win32.Foundation.BOOL: ...
@winfunctype('WINUSB.dll')
def WinUsb_UnregisterIsochBuffer(IsochBufferHandle: VoidPtr) -> win32more.Windows.Win32.Foundation.BOOL: ...
@winfunctype('WINUSB.dll')
def WinUsb_WriteIsochPipe(BufferHandle: VoidPtr, Offset: UInt32, Length: UInt32, FrameNumber: POINTER(UInt32), Overlapped: POINTER(win32more.Windows.Win32.System.IO.OVERLAPPED)) -> win32more.Windows.Win32.Foundation.BOOL: ...
@winfunctype('WINUSB.dll')
def WinUsb_ReadIsochPipe(BufferHandle: VoidPtr, Offset: UInt32, Length: UInt32, FrameNumber: POINTER(UInt32), NumberOfPackets: UInt32, IsoPacketDescriptors: POINTER(win32more.Windows.Win32.Devices.Usb.USBD_ISO_PACKET_DESCRIPTOR), Overlapped: POINTER(win32more.Windows.Win32.System.IO.OVERLAPPED)) -> win32more.Windows.Win32.Foundation.BOOL: ...
@winfunctype('WINUSB.dll')
def WinUsb_WriteIsochPipeAsap(BufferHandle: VoidPtr, Offset: UInt32, Length: UInt32, ContinueStream: win32more.Windows.Win32.Foundation.BOOL, Overlapped: POINTER(win32more.Windows.Win32.System.IO.OVERLAPPED)) -> win32more.Windows.Win32.Foundation.BOOL: ...
@winfunctype('WINUSB.dll')
def WinUsb_ReadIsochPipeAsap(BufferHandle: VoidPtr, Offset: UInt32, Length: UInt32, ContinueStream: win32more.Windows.Win32.Foundation.BOOL, NumberOfPackets: UInt32, IsoPacketDescriptors: POINTER(win32more.Windows.Win32.Devices.Usb.USBD_ISO_PACKET_DESCRIPTOR), Overlapped: POINTER(win32more.Windows.Win32.System.IO.OVERLAPPED)) -> win32more.Windows.Win32.Foundation.BOOL: ...
@winfunctype('WINUSB.dll')
def WinUsb_StartTrackingForTimeSync(InterfaceHandle: win32more.Windows.Win32.Devices.Usb.WINUSB_INTERFACE_HANDLE, StartTrackingInfo: POINTER(win32more.Windows.Win32.Devices.Usb.USB_START_TRACKING_FOR_TIME_SYNC_INFORMATION)) -> win32more.Windows.Win32.Foundation.BOOL: ...
@winfunctype('WINUSB.dll')
def WinUsb_GetCurrentFrameNumberAndQpc(InterfaceHandle: win32more.Windows.Win32.Devices.Usb.WINUSB_INTERFACE_HANDLE, FrameQpcInfo: POINTER(win32more.Windows.Win32.Devices.Usb.USB_FRAME_NUMBER_AND_QPC_FOR_TIME_SYNC_INFORMATION)) -> win32more.Windows.Win32.Foundation.BOOL: ...
@winfunctype('WINUSB.dll')
def WinUsb_StopTrackingForTimeSync(InterfaceHandle: win32more.Windows.Win32.Devices.Usb.WINUSB_INTERFACE_HANDLE, StopTrackingInfo: POINTER(win32more.Windows.Win32.Devices.Usb.USB_STOP_TRACKING_FOR_TIME_SYNC_INFORMATION)) -> win32more.Windows.Win32.Foundation.BOOL: ...
class BM_REQUEST_TYPE(Union):
    s: _BM
    B: Byte
    class _BM(Structure):
        Recipient: Annotated[Byte, NativeBitfieldAttribute(2)]
        Reserved: Annotated[Byte, NativeBitfieldAttribute(3)]
        Type: Annotated[Byte, NativeBitfieldAttribute(2)]
        Dir: Annotated[Byte, NativeBitfieldAttribute(1)]
class CHANNEL_INFO(Structure):
    EventChannelSize: UInt32
    uReadDataAlignment: UInt32
    uWriteDataAlignment: UInt32
class DEVICE_DESCRIPTOR(Structure):
    usVendorId: UInt16
    usProductId: UInt16
    usBcdDevice: UInt16
    usLanguageId: UInt16
class DRV_VERSION(Structure):
    major: UInt32
    minor: UInt32
    internal: UInt32
class HCD_ISO_STAT_COUNTERS(Structure):
    LateUrbs: UInt16
    DoubleBufferedPackets: UInt16
    TransfersCF_5ms: UInt16
    TransfersCF_2ms: UInt16
    TransfersCF_1ms: UInt16
    MaxInterruptLatency: UInt16
    BadStartFrame: UInt16
    StaleUrbs: UInt16
    IsoPacketNotAccesed: UInt16
    IsoPacketHWError: UInt16
    SmallestUrbPacketCount: UInt16
    LargestUrbPacketCount: UInt16
    IsoCRC_Error: UInt16
    IsoOVERRUN_Error: UInt16
    IsoINTERNAL_Error: UInt16
    IsoUNKNOWN_Error: UInt16
    IsoBytesTransferred: UInt32
    LateMissedCount: UInt16
    HWIsoMissedCount: UInt16
    Reserved7: UInt32 * 8
    _pack_ = 1
class HCD_STAT_COUNTERS(Structure):
    BytesTransferred: UInt32
    IsoMissedCount: UInt16
    DataOverrunErrorCount: UInt16
    CrcErrorCount: UInt16
    ScheduleOverrunCount: UInt16
    TimeoutErrorCount: UInt16
    InternalHcErrorCount: UInt16
    BufferOverrunErrorCount: UInt16
    SWErrorCount: UInt16
    StallPidCount: UInt16
    PortDisableCount: UInt16
    _pack_ = 1
class HCD_STAT_INFORMATION_1(Structure):
    Reserved1: UInt32
    Reserved2: UInt32
    ResetCounters: UInt32
    TimeRead: Int64
    Counters: win32more.Windows.Win32.Devices.Usb.HCD_STAT_COUNTERS
    _pack_ = 1
class HCD_STAT_INFORMATION_2(Structure):
    Reserved1: UInt32
    Reserved2: UInt32
    ResetCounters: UInt32
    TimeRead: Int64
    LockedMemoryUsed: Int32
    Counters: win32more.Windows.Win32.Devices.Usb.HCD_STAT_COUNTERS
    IsoCounters: win32more.Windows.Win32.Devices.Usb.HCD_ISO_STAT_COUNTERS
    _pack_ = 1
class HUB_DEVICE_CONFIG_INFO(Structure):
    Version: UInt32
    Length: UInt32
    HubFlags: win32more.Windows.Win32.Devices.Usb.USB_HUB_CAP_FLAGS
    HardwareIds: win32more.Windows.Win32.Devices.Usb.USB_ID_STRING
    CompatibleIds: win32more.Windows.Win32.Devices.Usb.USB_ID_STRING
    DeviceDescription: win32more.Windows.Win32.Devices.Usb.USB_ID_STRING
    Reserved: UInt32 * 19
    UxdSettings: win32more.Windows.Win32.Devices.Usb.USB_HUB_DEVICE_UXD_SETTINGS
    _pack_ = 1
class IO_BLOCK(Structure):
    uOffset: UInt32
    uLength: UInt32
    pbyData: POINTER(Byte)
    uIndex: UInt32
class IO_BLOCK_EX(Structure):
    uOffset: UInt32
    uLength: UInt32
    pbyData: POINTER(Byte)
    uIndex: UInt32
    bRequest: Byte
    bmRequestType: Byte
    fTransferDirectionIn: Byte
class OS_STRING(Structure):
    bLength: Byte
    bDescriptorType: Byte
    MicrosoftString: Char * 7
    bVendorCode: Byte
    Anonymous: _Anonymous_e__Union
    _anonymous_ = ('Anonymous',)
    class _Anonymous_e__Union(Union):
        bPad: Byte
        bFlags: Byte
class PACKET_PARAMETERS(Structure):
    DeviceAddress: Byte
    EndpointAddress: Byte
    MaximumPacketSize: UInt16
    Timeout: UInt32
    Flags: UInt32
    DataLength: UInt32
    HubDeviceAddress: UInt16
    PortTTNumber: UInt16
    ErrorCount: Byte
    Pad: Byte * 3
    UsbdStatusCode: Int32
    Data: Byte * 4
    _pack_ = 1
PIPE_TYPE = Int32
EVENT_PIPE: win32more.Windows.Win32.Devices.Usb.PIPE_TYPE = 0
READ_DATA_PIPE: win32more.Windows.Win32.Devices.Usb.PIPE_TYPE = 1
WRITE_DATA_PIPE: win32more.Windows.Win32.Devices.Usb.PIPE_TYPE = 2
ALL_PIPE: win32more.Windows.Win32.Devices.Usb.PIPE_TYPE = 3
RAW_PIPE_TYPE = Int32
USBSCAN_PIPE_CONTROL: win32more.Windows.Win32.Devices.Usb.RAW_PIPE_TYPE = 0
USBSCAN_PIPE_ISOCHRONOUS: win32more.Windows.Win32.Devices.Usb.RAW_PIPE_TYPE = 1
USBSCAN_PIPE_BULK: win32more.Windows.Win32.Devices.Usb.RAW_PIPE_TYPE = 2
USBSCAN_PIPE_INTERRUPT: win32more.Windows.Win32.Devices.Usb.RAW_PIPE_TYPE = 3
class RAW_RESET_PORT_PARAMETERS(Structure):
    PortNumber: UInt16
    PortStatus: UInt16
    _pack_ = 1
class RAW_ROOTPORT_FEATURE(Structure):
    PortNumber: UInt16
    PortFeature: UInt16
    PortStatus: UInt16
    _pack_ = 1
class RAW_ROOTPORT_PARAMETERS(Structure):
    PortNumber: UInt16
    PortStatus: UInt16
    _pack_ = 1
class URB(Structure):
    Anonymous: _Anonymous_e__Union
    _anonymous_ = ('Anonymous',)
    class _Anonymous_e__Union(Union):
        UrbHeader: win32more.Windows.Win32.Devices.Usb._URB_HEADER
        UrbSelectInterface: win32more.Windows.Win32.Devices.Usb._URB_SELECT_INTERFACE
        UrbSelectConfiguration: win32more.Windows.Win32.Devices.Usb._URB_SELECT_CONFIGURATION
        UrbPipeRequest: win32more.Windows.Win32.Devices.Usb._URB_PIPE_REQUEST
        UrbFrameLengthControl: win32more.Windows.Win32.Devices.Usb._URB_FRAME_LENGTH_CONTROL
        UrbGetFrameLength: win32more.Windows.Win32.Devices.Usb._URB_GET_FRAME_LENGTH
        UrbSetFrameLength: win32more.Windows.Win32.Devices.Usb._URB_SET_FRAME_LENGTH
        UrbGetCurrentFrameNumber: win32more.Windows.Win32.Devices.Usb._URB_GET_CURRENT_FRAME_NUMBER
        UrbControlTransfer: win32more.Windows.Win32.Devices.Usb._URB_CONTROL_TRANSFER
        UrbControlTransferEx: win32more.Windows.Win32.Devices.Usb._URB_CONTROL_TRANSFER_EX
        UrbBulkOrInterruptTransfer: win32more.Windows.Win32.Devices.Usb._URB_BULK_OR_INTERRUPT_TRANSFER
        UrbIsochronousTransfer: win32more.Windows.Win32.Devices.Usb._URB_ISOCH_TRANSFER
        UrbControlDescriptorRequest: win32more.Windows.Win32.Devices.Usb._URB_CONTROL_DESCRIPTOR_REQUEST
        UrbControlGetStatusRequest: win32more.Windows.Win32.Devices.Usb._URB_CONTROL_GET_STATUS_REQUEST
        UrbControlFeatureRequest: win32more.Windows.Win32.Devices.Usb._URB_CONTROL_FEATURE_REQUEST
        UrbControlVendorClassRequest: win32more.Windows.Win32.Devices.Usb._URB_CONTROL_VENDOR_OR_CLASS_REQUEST
        UrbControlGetInterfaceRequest: win32more.Windows.Win32.Devices.Usb._URB_CONTROL_GET_INTERFACE_REQUEST
        UrbControlGetConfigurationRequest: win32more.Windows.Win32.Devices.Usb._URB_CONTROL_GET_CONFIGURATION_REQUEST
        UrbOSFeatureDescriptorRequest: win32more.Windows.Win32.Devices.Usb._URB_OS_FEATURE_DESCRIPTOR_REQUEST
        UrbOpenStaticStreams: win32more.Windows.Win32.Devices.Usb._URB_OPEN_STATIC_STREAMS
        UrbGetIsochPipeTransferPathDelays: win32more.Windows.Win32.Devices.Usb._URB_GET_ISOCH_PIPE_TRANSFER_PATH_DELAYS
class USBD_DEVICE_INFORMATION(Structure):
    OffsetNext: UInt32
    UsbdDeviceHandle: VoidPtr
    DeviceDescriptor: win32more.Windows.Win32.Devices.Usb.USB_DEVICE_DESCRIPTOR
class USBD_ENDPOINT_OFFLOAD_INFORMATION(Structure):
    Size: UInt32
    EndpointAddress: UInt16
    ResourceId: UInt32
    Mode: win32more.Windows.Win32.Devices.Usb.USBD_ENDPOINT_OFFLOAD_MODE
    RootHubPortNumber: Annotated[UInt32, NativeBitfieldAttribute(8)]
    RouteString: Annotated[UInt32, NativeBitfieldAttribute(20)]
    Speed: Annotated[UInt32, NativeBitfieldAttribute(4)]
    UsbDeviceAddress: Annotated[UInt32, NativeBitfieldAttribute(8)]
    SlotId: Annotated[UInt32, NativeBitfieldAttribute(8)]
    MultiTT: Annotated[UInt32, NativeBitfieldAttribute(1)]
    LSOrFSDeviceConnectedToTTHub: Annotated[UInt32, NativeBitfieldAttribute(1)]
    Reserved0: Annotated[UInt32, NativeBitfieldAttribute(14)]
    TransferSegmentLA: Int64
    TransferSegmentVA: VoidPtr
    TransferRingSize: UIntPtr
    TransferRingInitialCycleBit: UInt32
    MessageNumber: UInt32
    EventRingSegmentLA: Int64
    EventRingSegmentVA: VoidPtr
    EventRingSize: UIntPtr
    EventRingInitialCycleBit: UInt32
    _pack_ = 1
USBD_ENDPOINT_OFFLOAD_MODE = Int32
UsbdEndpointOffloadModeNotSupported: win32more.Windows.Win32.Devices.Usb.USBD_ENDPOINT_OFFLOAD_MODE = 0
UsbdEndpointOffloadSoftwareAssisted: win32more.Windows.Win32.Devices.Usb.USBD_ENDPOINT_OFFLOAD_MODE = 1
UsbdEndpointOffloadHardwareAssisted: win32more.Windows.Win32.Devices.Usb.USBD_ENDPOINT_OFFLOAD_MODE = 2
class USBD_INTERFACE_INFORMATION(Structure):
    Length: UInt16
    InterfaceNumber: Byte
    AlternateSetting: Byte
    Class: Byte
    SubClass: Byte
    Protocol: Byte
    Reserved: Byte
    InterfaceHandle: VoidPtr
    NumberOfPipes: UInt32
    Pipes: FlexibleArray[win32more.Windows.Win32.Devices.Usb.USBD_PIPE_INFORMATION]
class USBD_ISO_PACKET_DESCRIPTOR(Structure):
    Offset: UInt32
    Length: UInt32
    Status: Int32
class USBD_PIPE_INFORMATION(Structure):
    MaximumPacketSize: UInt16
    EndpointAddress: Byte
    Interval: Byte
    PipeType: win32more.Windows.Win32.Devices.Usb.USBD_PIPE_TYPE
    PipeHandle: VoidPtr
    MaximumTransferSize: UInt32
    PipeFlags: UInt32
USBD_PIPE_TYPE = Int32
UsbdPipeTypeControl: win32more.Windows.Win32.Devices.Usb.USBD_PIPE_TYPE = 0
UsbdPipeTypeIsochronous: win32more.Windows.Win32.Devices.Usb.USBD_PIPE_TYPE = 1
UsbdPipeTypeBulk: win32more.Windows.Win32.Devices.Usb.USBD_PIPE_TYPE = 2
UsbdPipeTypeInterrupt: win32more.Windows.Win32.Devices.Usb.USBD_PIPE_TYPE = 3
class USBD_STREAM_INFORMATION(Structure):
    PipeHandle: VoidPtr
    StreamID: UInt32
    MaximumTransferSize: UInt32
    PipeFlags: UInt32
class USBD_VERSION_INFORMATION(Structure):
    USBDI_Version: UInt32
    Supported_USB_Version: UInt32
class USBFN_BUS_CONFIGURATION_INFO(Structure):
    ConfigurationName: Char * 40
    IsCurrent: win32more.Windows.Win32.Foundation.BOOLEAN
    IsActive: win32more.Windows.Win32.Foundation.BOOLEAN
USBFN_BUS_SPEED = Int32
UsbfnBusSpeedLow: win32more.Windows.Win32.Devices.Usb.USBFN_BUS_SPEED = 0
UsbfnBusSpeedFull: win32more.Windows.Win32.Devices.Usb.USBFN_BUS_SPEED = 1
UsbfnBusSpeedHigh: win32more.Windows.Win32.Devices.Usb.USBFN_BUS_SPEED = 2
UsbfnBusSpeedSuper: win32more.Windows.Win32.Devices.Usb.USBFN_BUS_SPEED = 3
UsbfnBusSpeedMaximum: win32more.Windows.Win32.Devices.Usb.USBFN_BUS_SPEED = 4
class USBFN_CLASS_INFORMATION_PACKET(Structure):
    FullSpeedClassInterface: win32more.Windows.Win32.Devices.Usb.USBFN_CLASS_INTERFACE
    HighSpeedClassInterface: win32more.Windows.Win32.Devices.Usb.USBFN_CLASS_INTERFACE
    InterfaceName: Char * 40
    InterfaceGuid: Char * 39
    HasInterfaceGuid: win32more.Windows.Win32.Foundation.BOOLEAN
    SuperSpeedClassInterface: win32more.Windows.Win32.Devices.Usb.USBFN_CLASS_INTERFACE
class USBFN_CLASS_INFORMATION_PACKET_EX(Structure):
    FullSpeedClassInterfaceEx: win32more.Windows.Win32.Devices.Usb.USBFN_CLASS_INTERFACE_EX
    HighSpeedClassInterfaceEx: win32more.Windows.Win32.Devices.Usb.USBFN_CLASS_INTERFACE_EX
    SuperSpeedClassInterfaceEx: win32more.Windows.Win32.Devices.Usb.USBFN_CLASS_INTERFACE_EX
    InterfaceName: Char * 40
    InterfaceGuid: Char * 39
    HasInterfaceGuid: win32more.Windows.Win32.Foundation.BOOLEAN
class USBFN_CLASS_INTERFACE(Structure):
    InterfaceNumber: Byte
    PipeCount: Byte
    PipeArr: win32more.Windows.Win32.Devices.Usb.USBFN_PIPE_INFORMATION * 16
class USBFN_CLASS_INTERFACE_EX(Structure):
    BaseInterfaceNumber: Byte
    InterfaceCount: Byte
    PipeCount: Byte
    PipeArr: win32more.Windows.Win32.Devices.Usb.USBFN_PIPE_INFORMATION * 16
USBFN_DEVICE_STATE = Int32
UsbfnDeviceStateMinimum: win32more.Windows.Win32.Devices.Usb.USBFN_DEVICE_STATE = 0
UsbfnDeviceStateAttached: win32more.Windows.Win32.Devices.Usb.USBFN_DEVICE_STATE = 1
UsbfnDeviceStateDefault: win32more.Windows.Win32.Devices.Usb.USBFN_DEVICE_STATE = 2
UsbfnDeviceStateDetached: win32more.Windows.Win32.Devices.Usb.USBFN_DEVICE_STATE = 3
UsbfnDeviceStateAddressed: win32more.Windows.Win32.Devices.Usb.USBFN_DEVICE_STATE = 4
UsbfnDeviceStateConfigured: win32more.Windows.Win32.Devices.Usb.USBFN_DEVICE_STATE = 5
UsbfnDeviceStateSuspended: win32more.Windows.Win32.Devices.Usb.USBFN_DEVICE_STATE = 6
UsbfnDeviceStateStateMaximum: win32more.Windows.Win32.Devices.Usb.USBFN_DEVICE_STATE = 7
USBFN_DIRECTION = Int32
UsbfnDirectionMinimum: win32more.Windows.Win32.Devices.Usb.USBFN_DIRECTION = 0
UsbfnDirectionIn: win32more.Windows.Win32.Devices.Usb.USBFN_DIRECTION = 1
UsbfnDirectionOut: win32more.Windows.Win32.Devices.Usb.USBFN_DIRECTION = 2
UsbfnDirectionTx: win32more.Windows.Win32.Devices.Usb.USBFN_DIRECTION = 1
UsbfnDirectionRx: win32more.Windows.Win32.Devices.Usb.USBFN_DIRECTION = 2
UsbfnDirectionMaximum: win32more.Windows.Win32.Devices.Usb.USBFN_DIRECTION = 3
USBFN_EVENT = Int32
UsbfnEventMinimum: win32more.Windows.Win32.Devices.Usb.USBFN_EVENT = 0
UsbfnEventAttach: win32more.Windows.Win32.Devices.Usb.USBFN_EVENT = 1
UsbfnEventReset: win32more.Windows.Win32.Devices.Usb.USBFN_EVENT = 2
UsbfnEventDetach: win32more.Windows.Win32.Devices.Usb.USBFN_EVENT = 3
UsbfnEventSuspend: win32more.Windows.Win32.Devices.Usb.USBFN_EVENT = 4
UsbfnEventResume: win32more.Windows.Win32.Devices.Usb.USBFN_EVENT = 5
UsbfnEventSetupPacket: win32more.Windows.Win32.Devices.Usb.USBFN_EVENT = 6
UsbfnEventConfigured: win32more.Windows.Win32.Devices.Usb.USBFN_EVENT = 7
UsbfnEventUnConfigured: win32more.Windows.Win32.Devices.Usb.USBFN_EVENT = 8
UsbfnEventPortType: win32more.Windows.Win32.Devices.Usb.USBFN_EVENT = 9
UsbfnEventBusTearDown: win32more.Windows.Win32.Devices.Usb.USBFN_EVENT = 10
UsbfnEventSetInterface: win32more.Windows.Win32.Devices.Usb.USBFN_EVENT = 11
UsbfnEventMaximum: win32more.Windows.Win32.Devices.Usb.USBFN_EVENT = 12
class USBFN_INTERFACE_INFO(Structure):
    InterfaceNumber: Byte
    Speed: win32more.Windows.Win32.Devices.Usb.USBFN_BUS_SPEED
    Size: UInt16
    InterfaceDescriptorSet: FlexibleArray[Byte]
class USBFN_NOTIFICATION(Structure):
    Event: win32more.Windows.Win32.Devices.Usb.USBFN_EVENT
    u: _u_e__Union
    class _u_e__Union(Union):
        BusSpeed: win32more.Windows.Win32.Devices.Usb.USBFN_BUS_SPEED
        SetupPacket: win32more.Windows.Win32.Devices.Usb.USB_DEFAULT_PIPE_SETUP_PACKET
        ConfigurationValue: UInt16
        PortType: win32more.Windows.Win32.Devices.Usb.USBFN_PORT_TYPE
        AlternateInterface: win32more.Windows.Win32.Devices.Usb.ALTERNATE_INTERFACE
class USBFN_PIPE_INFORMATION(Structure):
    EpDesc: win32more.Windows.Win32.Devices.Usb.USB_ENDPOINT_DESCRIPTOR
    PipeId: UInt32
USBFN_PORT_TYPE = Int32
UsbfnUnknownPort: win32more.Windows.Win32.Devices.Usb.USBFN_PORT_TYPE = 0
UsbfnStandardDownstreamPort: win32more.Windows.Win32.Devices.Usb.USBFN_PORT_TYPE = 1
UsbfnChargingDownstreamPort: win32more.Windows.Win32.Devices.Usb.USBFN_PORT_TYPE = 2
UsbfnDedicatedChargingPort: win32more.Windows.Win32.Devices.Usb.USBFN_PORT_TYPE = 3
UsbfnInvalidDedicatedChargingPort: win32more.Windows.Win32.Devices.Usb.USBFN_PORT_TYPE = 4
UsbfnProprietaryDedicatedChargingPort: win32more.Windows.Win32.Devices.Usb.USBFN_PORT_TYPE = 5
UsbfnPortTypeMaximum: win32more.Windows.Win32.Devices.Usb.USBFN_PORT_TYPE = 6
class USBFN_USB_STRING(Structure):
    StringIndex: Byte
    UsbString: Char * 255
class USBSCAN_GET_DESCRIPTOR(Structure):
    DescriptorType: Byte
    Index: Byte
    LanguageId: UInt16
class USBSCAN_PIPE_CONFIGURATION(Structure):
    NumberOfPipes: UInt32
    PipeInfo: win32more.Windows.Win32.Devices.Usb.USBSCAN_PIPE_INFORMATION * 8
class USBSCAN_PIPE_INFORMATION(Structure):
    MaximumPacketSize: UInt16
    EndpointAddress: Byte
    Interval: Byte
    PipeType: win32more.Windows.Win32.Devices.Usb.RAW_PIPE_TYPE
class USBSCAN_TIMEOUT(Structure):
    TimeoutRead: UInt32
    TimeoutWrite: UInt32
    TimeoutEvent: UInt32
class USBUSER_BANDWIDTH_INFO_REQUEST(Structure):
    Header: win32more.Windows.Win32.Devices.Usb.USBUSER_REQUEST_HEADER
    BandwidthInformation: win32more.Windows.Win32.Devices.Usb.USB_BANDWIDTH_INFO
    _pack_ = 1
class USBUSER_BUS_STATISTICS_0_REQUEST(Structure):
    Header: win32more.Windows.Win32.Devices.Usb.USBUSER_REQUEST_HEADER
    BusStatistics0: win32more.Windows.Win32.Devices.Usb.USB_BUS_STATISTICS_0
    _pack_ = 1
class USBUSER_CLOSE_RAW_DEVICE(Structure):
    Header: win32more.Windows.Win32.Devices.Usb.USBUSER_REQUEST_HEADER
    Parameters: win32more.Windows.Win32.Devices.Usb.USB_CLOSE_RAW_DEVICE_PARAMETERS
    _pack_ = 1
class USBUSER_CONTROLLER_INFO_0(Structure):
    Header: win32more.Windows.Win32.Devices.Usb.USBUSER_REQUEST_HEADER
    Info0: win32more.Windows.Win32.Devices.Usb.USB_CONTROLLER_INFO_0
    _pack_ = 1
class USBUSER_CONTROLLER_UNICODE_NAME(Structure):
    Header: win32more.Windows.Win32.Devices.Usb.USBUSER_REQUEST_HEADER
    UnicodeName: win32more.Windows.Win32.Devices.Usb.USB_UNICODE_NAME
    _pack_ = 1
class USBUSER_GET_DRIVER_VERSION(Structure):
    Header: win32more.Windows.Win32.Devices.Usb.USBUSER_REQUEST_HEADER
    Parameters: win32more.Windows.Win32.Devices.Usb.USB_DRIVER_VERSION_PARAMETERS
    _pack_ = 1
class USBUSER_GET_USB2HW_VERSION(Structure):
    Header: win32more.Windows.Win32.Devices.Usb.USBUSER_REQUEST_HEADER
    Parameters: win32more.Windows.Win32.Devices.Usb.USB_USB2HW_VERSION_PARAMETERS
    _pack_ = 1
class USBUSER_OPEN_RAW_DEVICE(Structure):
    Header: win32more.Windows.Win32.Devices.Usb.USBUSER_REQUEST_HEADER
    Parameters: win32more.Windows.Win32.Devices.Usb.USB_OPEN_RAW_DEVICE_PARAMETERS
    _pack_ = 1
class USBUSER_PASS_THRU_REQUEST(Structure):
    Header: win32more.Windows.Win32.Devices.Usb.USBUSER_REQUEST_HEADER
    PassThru: win32more.Windows.Win32.Devices.Usb.USB_PASS_THRU_PARAMETERS
    _pack_ = 1
class USBUSER_POWER_INFO_REQUEST(Structure):
    Header: win32more.Windows.Win32.Devices.Usb.USBUSER_REQUEST_HEADER
    PowerInformation: win32more.Windows.Win32.Devices.Usb.USB_POWER_INFO
    _pack_ = 1
class USBUSER_RAW_RESET_ROOT_PORT(Structure):
    Header: win32more.Windows.Win32.Devices.Usb.USBUSER_REQUEST_HEADER
    Parameters: win32more.Windows.Win32.Devices.Usb.RAW_RESET_PORT_PARAMETERS
    _pack_ = 1
class USBUSER_REFRESH_HCT_REG(Structure):
    Header: win32more.Windows.Win32.Devices.Usb.USBUSER_REQUEST_HEADER
    Flags: UInt32
    _pack_ = 1
class USBUSER_REQUEST_HEADER(Structure):
    UsbUserRequest: UInt32
    UsbUserStatusCode: win32more.Windows.Win32.Devices.Usb.USB_USER_ERROR_CODE
    RequestBufferLength: UInt32
    ActualBufferLength: UInt32
    _pack_ = 1
class USBUSER_ROOTPORT_FEATURE_REQUEST(Structure):
    Header: win32more.Windows.Win32.Devices.Usb.USBUSER_REQUEST_HEADER
    Parameters: win32more.Windows.Win32.Devices.Usb.RAW_ROOTPORT_FEATURE
    _pack_ = 1
class USBUSER_ROOTPORT_PARAMETERS(Structure):
    Header: win32more.Windows.Win32.Devices.Usb.USBUSER_REQUEST_HEADER
    Parameters: win32more.Windows.Win32.Devices.Usb.RAW_ROOTPORT_PARAMETERS
    _pack_ = 1
class USBUSER_SEND_ONE_PACKET(Structure):
    Header: win32more.Windows.Win32.Devices.Usb.USBUSER_REQUEST_HEADER
    PacketParameters: win32more.Windows.Win32.Devices.Usb.PACKET_PARAMETERS
    _pack_ = 1
class USBUSER_SEND_RAW_COMMAND(Structure):
    Header: win32more.Windows.Win32.Devices.Usb.USBUSER_REQUEST_HEADER
    Parameters: win32more.Windows.Win32.Devices.Usb.USB_SEND_RAW_COMMAND_PARAMETERS
    _pack_ = 1
class USB_20_PORT_CHANGE(Union):
    AsUshort16: UInt16
    Anonymous: _Anonymous_e__Struct
    _anonymous_ = ('Anonymous',)
    _pack_ = 1
    class _Anonymous_e__Struct(Structure):
        ConnectStatusChange: Annotated[UInt16, NativeBitfieldAttribute(1)]
        PortEnableDisableChange: Annotated[UInt16, NativeBitfieldAttribute(1)]
        SuspendChange: Annotated[UInt16, NativeBitfieldAttribute(1)]
        OverCurrentIndicatorChange: Annotated[UInt16, NativeBitfieldAttribute(1)]
        ResetChange: Annotated[UInt16, NativeBitfieldAttribute(1)]
        Reserved2: Annotated[UInt16, NativeBitfieldAttribute(11)]
        _pack_ = 1
class USB_20_PORT_STATUS(Union):
    AsUshort16: UInt16
    Anonymous: _Anonymous_e__Struct
    _anonymous_ = ('Anonymous',)
    _pack_ = 1
    class _Anonymous_e__Struct(Structure):
        CurrentConnectStatus: Annotated[UInt16, NativeBitfieldAttribute(1)]
        PortEnabledDisabled: Annotated[UInt16, NativeBitfieldAttribute(1)]
        Suspend: Annotated[UInt16, NativeBitfieldAttribute(1)]
        OverCurrent: Annotated[UInt16, NativeBitfieldAttribute(1)]
        Reset: Annotated[UInt16, NativeBitfieldAttribute(1)]
        L1: Annotated[UInt16, NativeBitfieldAttribute(1)]
        Reserved0: Annotated[UInt16, NativeBitfieldAttribute(2)]
        PortPower: Annotated[UInt16, NativeBitfieldAttribute(1)]
        LowSpeedDeviceAttached: Annotated[UInt16, NativeBitfieldAttribute(1)]
        HighSpeedDeviceAttached: Annotated[UInt16, NativeBitfieldAttribute(1)]
        PortTestMode: Annotated[UInt16, NativeBitfieldAttribute(1)]
        PortIndicatorControl: Annotated[UInt16, NativeBitfieldAttribute(1)]
        Reserved1: Annotated[UInt16, NativeBitfieldAttribute(3)]
        _pack_ = 1
class USB_30_HUB_DESCRIPTOR(Structure):
    bLength: Byte
    bDescriptorType: Byte
    bNumberOfPorts: Byte
    wHubCharacteristics: UInt16
    bPowerOnToPowerGood: Byte
    bHubControlCurrent: Byte
    bHubHdrDecLat: Byte
    wHubDelay: UInt16
    DeviceRemovable: UInt16
    _pack_ = 1
class USB_30_PORT_CHANGE(Union):
    AsUshort16: UInt16
    Anonymous: _Anonymous_e__Struct
    _anonymous_ = ('Anonymous',)
    _pack_ = 1
    class _Anonymous_e__Struct(Structure):
        ConnectStatusChange: Annotated[UInt16, NativeBitfieldAttribute(1)]
        Reserved2: Annotated[UInt16, NativeBitfieldAttribute(2)]
        OverCurrentIndicatorChange: Annotated[UInt16, NativeBitfieldAttribute(1)]
        ResetChange: Annotated[UInt16, NativeBitfieldAttribute(1)]
        BHResetChange: Annotated[UInt16, NativeBitfieldAttribute(1)]
        PortLinkStateChange: Annotated[UInt16, NativeBitfieldAttribute(1)]
        PortConfigErrorChange: Annotated[UInt16, NativeBitfieldAttribute(1)]
        Reserved3: Annotated[UInt16, NativeBitfieldAttribute(8)]
        _pack_ = 1
class USB_30_PORT_STATUS(Union):
    AsUshort16: UInt16
    Anonymous: _Anonymous_e__Struct
    _anonymous_ = ('Anonymous',)
    _pack_ = 1
    class _Anonymous_e__Struct(Structure):
        CurrentConnectStatus: Annotated[UInt16, NativeBitfieldAttribute(1)]
        PortEnabledDisabled: Annotated[UInt16, NativeBitfieldAttribute(1)]
        Reserved0: Annotated[UInt16, NativeBitfieldAttribute(1)]
        OverCurrent: Annotated[UInt16, NativeBitfieldAttribute(1)]
        Reset: Annotated[UInt16, NativeBitfieldAttribute(1)]
        PortLinkState: Annotated[UInt16, NativeBitfieldAttribute(4)]
        PortPower: Annotated[UInt16, NativeBitfieldAttribute(1)]
        NegotiatedDeviceSpeed: Annotated[UInt16, NativeBitfieldAttribute(3)]
        Reserved1: Annotated[UInt16, NativeBitfieldAttribute(3)]
        _pack_ = 1
class USB_ACQUIRE_INFO(Structure):
    NotificationType: win32more.Windows.Win32.Devices.Usb.USB_NOTIFICATION_TYPE
    TotalSize: UInt32
    Buffer: FlexibleArray[Char]
    _pack_ = 1
class USB_BANDWIDTH_INFO(Structure):
    DeviceCount: UInt32
    TotalBusBandwidth: UInt32
    Total32secBandwidth: UInt32
    AllocedBulkAndControl: UInt32
    AllocedIso: UInt32
    AllocedInterrupt_1ms: UInt32
    AllocedInterrupt_2ms: UInt32
    AllocedInterrupt_4ms: UInt32
    AllocedInterrupt_8ms: UInt32
    AllocedInterrupt_16ms: UInt32
    AllocedInterrupt_32ms: UInt32
    _pack_ = 1
class USB_BOS_DESCRIPTOR(Structure):
    bLength: Byte
    bDescriptorType: Byte
    wTotalLength: UInt16
    bNumDeviceCaps: Byte
    _pack_ = 1
class USB_BUS_NOTIFICATION(Structure):
    NotificationType: win32more.Windows.Win32.Devices.Usb.USB_NOTIFICATION_TYPE
    TotalBandwidth: UInt32
    ConsumedBandwidth: UInt32
    ControllerNameLength: UInt32
    _pack_ = 1
class USB_BUS_STATISTICS_0(Structure):
    DeviceCount: UInt32
    CurrentSystemTime: Int64
    CurrentUsbFrame: UInt32
    BulkBytes: UInt32
    IsoBytes: UInt32
    InterruptBytes: UInt32
    ControlDataBytes: UInt32
    PciInterruptCount: UInt32
    HardResetCount: UInt32
    WorkerSignalCount: UInt32
    CommonBufferBytes: UInt32
    WorkerIdleTimeMs: UInt32
    RootHubEnabled: win32more.Windows.Win32.Foundation.BOOLEAN
    RootHubDevicePowerState: Byte
    Unused: Byte
    NameIndex: Byte
    _pack_ = 1
USB_CHANGE_REGISTRATION_HANDLE = VoidPtr
class USB_CLOSE_RAW_DEVICE_PARAMETERS(Structure):
    xxx: UInt32
    _pack_ = 1
class USB_COMMON_DESCRIPTOR(Structure):
    bLength: Byte
    bDescriptorType: Byte
class USB_COMPOSITE_DEVICE_INFO(Structure):
    DeviceDescriptor: win32more.Windows.Win32.Devices.Usb.USB_DEVICE_DESCRIPTOR
    CurrentConfigDescriptor: win32more.Windows.Win32.Devices.Usb.USB_CONFIGURATION_DESCRIPTOR
    CurrentConfigurationValue: Byte
    NumberOfFunctions: Byte
    FunctionInfo: FlexibleArray[win32more.Windows.Win32.Devices.Usb.USB_COMPOSITE_FUNCTION_INFO]
class USB_COMPOSITE_FUNCTION_INFO(Structure):
    FunctionNumber: Byte
    BaseInterfaceNumber: Byte
    NumberOfInterfaces: Byte
    FunctionIsIdle: win32more.Windows.Win32.Foundation.BOOLEAN
class USB_CONFIGURATION_DESCRIPTOR(Structure):
    bLength: Byte
    bDescriptorType: Byte
    wTotalLength: UInt16
    bNumInterfaces: Byte
    bConfigurationValue: Byte
    iConfiguration: Byte
    bmAttributes: Byte
    MaxPower: Byte
    _pack_ = 1
class USB_CONFIGURATION_POWER_DESCRIPTOR(Structure):
    bLength: Byte
    bDescriptorType: Byte
    SelfPowerConsumedD0: Byte * 3
    bPowerSummaryId: Byte
    bBusPowerSavingD1: Byte
    bSelfPowerSavingD1: Byte
    bBusPowerSavingD2: Byte
    bSelfPowerSavingD2: Byte
    bBusPowerSavingD3: Byte
    bSelfPowerSavingD3: Byte
    TransitionTimeFromD1: UInt16
    TransitionTimeFromD2: UInt16
    TransitionTimeFromD3: UInt16
    _pack_ = 1
class USB_CONNECTION_NOTIFICATION(Structure):
    NotificationType: win32more.Windows.Win32.Devices.Usb.USB_NOTIFICATION_TYPE
    ConnectionNumber: UInt32
    RequestedBandwidth: UInt32
    EnumerationFailReason: UInt32
    PowerRequested: UInt32
    HubNameLength: UInt32
    _pack_ = 1
USB_CONNECTION_STATUS = Int32
NoDeviceConnected: win32more.Windows.Win32.Devices.Usb.USB_CONNECTION_STATUS = 0
DeviceConnected: win32more.Windows.Win32.Devices.Usb.USB_CONNECTION_STATUS = 1
DeviceFailedEnumeration: win32more.Windows.Win32.Devices.Usb.USB_CONNECTION_STATUS = 2
DeviceGeneralFailure: win32more.Windows.Win32.Devices.Usb.USB_CONNECTION_STATUS = 3
DeviceCausedOvercurrent: win32more.Windows.Win32.Devices.Usb.USB_CONNECTION_STATUS = 4
DeviceNotEnoughPower: win32more.Windows.Win32.Devices.Usb.USB_CONNECTION_STATUS = 5
DeviceNotEnoughBandwidth: win32more.Windows.Win32.Devices.Usb.USB_CONNECTION_STATUS = 6
DeviceHubNestedTooDeeply: win32more.Windows.Win32.Devices.Usb.USB_CONNECTION_STATUS = 7
DeviceInLegacyHub: win32more.Windows.Win32.Devices.Usb.USB_CONNECTION_STATUS = 8
DeviceEnumerating: win32more.Windows.Win32.Devices.Usb.USB_CONNECTION_STATUS = 9
DeviceReset: win32more.Windows.Win32.Devices.Usb.USB_CONNECTION_STATUS = 10
class USB_CONTROLLER_DEVICE_INFO(Structure):
    PciVendorId: UInt32
    PciDeviceId: UInt32
    PciRevision: UInt32
    NumberOfRootPorts: UInt32
    HcFeatureFlags: UInt32
    _pack_ = 1
USB_CONTROLLER_FLAVOR = Int32
USB_HcGeneric: win32more.Windows.Win32.Devices.Usb.USB_CONTROLLER_FLAVOR = 0
OHCI_Generic: win32more.Windows.Win32.Devices.Usb.USB_CONTROLLER_FLAVOR = 100
OHCI_Hydra: win32more.Windows.Win32.Devices.Usb.USB_CONTROLLER_FLAVOR = 101
OHCI_NEC: win32more.Windows.Win32.Devices.Usb.USB_CONTROLLER_FLAVOR = 102
UHCI_Generic: win32more.Windows.Win32.Devices.Usb.USB_CONTROLLER_FLAVOR = 200
UHCI_Piix4: win32more.Windows.Win32.Devices.Usb.USB_CONTROLLER_FLAVOR = 201
UHCI_Piix3: win32more.Windows.Win32.Devices.Usb.USB_CONTROLLER_FLAVOR = 202
UHCI_Ich2: win32more.Windows.Win32.Devices.Usb.USB_CONTROLLER_FLAVOR = 203
UHCI_Reserved204: win32more.Windows.Win32.Devices.Usb.USB_CONTROLLER_FLAVOR = 204
UHCI_Ich1: win32more.Windows.Win32.Devices.Usb.USB_CONTROLLER_FLAVOR = 205
UHCI_Ich3m: win32more.Windows.Win32.Devices.Usb.USB_CONTROLLER_FLAVOR = 206
UHCI_Ich4: win32more.Windows.Win32.Devices.Usb.USB_CONTROLLER_FLAVOR = 207
UHCI_Ich5: win32more.Windows.Win32.Devices.Usb.USB_CONTROLLER_FLAVOR = 208
UHCI_Ich6: win32more.Windows.Win32.Devices.Usb.USB_CONTROLLER_FLAVOR = 209
UHCI_Intel: win32more.Windows.Win32.Devices.Usb.USB_CONTROLLER_FLAVOR = 249
UHCI_VIA: win32more.Windows.Win32.Devices.Usb.USB_CONTROLLER_FLAVOR = 250
UHCI_VIA_x01: win32more.Windows.Win32.Devices.Usb.USB_CONTROLLER_FLAVOR = 251
UHCI_VIA_x02: win32more.Windows.Win32.Devices.Usb.USB_CONTROLLER_FLAVOR = 252
UHCI_VIA_x03: win32more.Windows.Win32.Devices.Usb.USB_CONTROLLER_FLAVOR = 253
UHCI_VIA_x04: win32more.Windows.Win32.Devices.Usb.USB_CONTROLLER_FLAVOR = 254
UHCI_VIA_x0E_FIFO: win32more.Windows.Win32.Devices.Usb.USB_CONTROLLER_FLAVOR = 264
EHCI_Generic: win32more.Windows.Win32.Devices.Usb.USB_CONTROLLER_FLAVOR = 1000
EHCI_NEC: win32more.Windows.Win32.Devices.Usb.USB_CONTROLLER_FLAVOR = 2000
EHCI_Lucent: win32more.Windows.Win32.Devices.Usb.USB_CONTROLLER_FLAVOR = 3000
EHCI_NVIDIA_Tegra2: win32more.Windows.Win32.Devices.Usb.USB_CONTROLLER_FLAVOR = 4000
EHCI_NVIDIA_Tegra3: win32more.Windows.Win32.Devices.Usb.USB_CONTROLLER_FLAVOR = 4001
EHCI_Intel_Medfield: win32more.Windows.Win32.Devices.Usb.USB_CONTROLLER_FLAVOR = 5001
class USB_CONTROLLER_INFO_0(Structure):
    PciVendorId: UInt32
    PciDeviceId: UInt32
    PciRevision: UInt32
    NumberOfRootPorts: UInt32
    ControllerFlavor: win32more.Windows.Win32.Devices.Usb.USB_CONTROLLER_FLAVOR
    HcFeatureFlags: UInt32
    _pack_ = 1
class USB_CYCLE_PORT_PARAMS(Structure):
    ConnectionIndex: UInt32
    StatusReturned: UInt32
    _pack_ = 1
class USB_DEFAULT_PIPE_SETUP_PACKET(Structure):
    bmRequestType: win32more.Windows.Win32.Devices.Usb.BM_REQUEST_TYPE
    bRequest: Byte
    wValue: _wValue
    wIndex: _wIndex
    wLength: UInt16
    _pack_ = 1
    class _wValue(Union):
        Anonymous: _Anonymous_e__Struct
        W: UInt16
        _anonymous_ = ('Anonymous',)
        _pack_ = 1
        class _Anonymous_e__Struct(Structure):
            LowByte: Byte
            HiByte: Byte
    class _wIndex(Union):
        Anonymous: _Anonymous_e__Struct
        W: UInt16
        _anonymous_ = ('Anonymous',)
        _pack_ = 1
        class _Anonymous_e__Struct(Structure):
            LowByte: Byte
            HiByte: Byte
class USB_DESCRIPTOR_REQUEST(Structure):
    ConnectionIndex: UInt32
    SetupPacket: _SetupPacket_e__Struct
    Data: FlexibleArray[Byte]
    _pack_ = 1
    class _SetupPacket_e__Struct(Structure):
        bmRequest: Byte
        bRequest: Byte
        wValue: UInt16
        wIndex: UInt16
        wLength: UInt16
        _pack_ = 1
class USB_DEVICE_CAPABILITY_BILLBOARD_DESCRIPTOR(Structure):
    bLength: Byte
    bDescriptorType: Byte
    bDevCapabilityType: Byte
    iAddtionalInfoURL: Byte
    bNumberOfAlternateModes: Byte
    bPreferredAlternateMode: Byte
    VconnPower: _VconnPower_e__Union
    bmConfigured: Byte * 32
    bReserved: UInt32
    AlternateMode: FlexibleArray[_Anonymous_e__Struct]
    _pack_ = 1
    class _VconnPower_e__Union(Union):
        AsUshort: UInt16
        Anonymous: _Anonymous_e__Struct
        _anonymous_ = ('Anonymous',)
        _pack_ = 1
        class _Anonymous_e__Struct(Structure):
            VConnPowerNeededForFullFunctionality: Annotated[UInt16, NativeBitfieldAttribute(3)]
            Reserved: Annotated[UInt16, NativeBitfieldAttribute(12)]
            NoVconnPowerRequired: Annotated[UInt16, NativeBitfieldAttribute(1)]
            _pack_ = 1
    class _Anonymous_e__Struct(Structure):
        wSVID: UInt16
        bAlternateMode: Byte
        iAlternateModeSetting: Byte
        _pack_ = 1
class USB_DEVICE_CAPABILITY_CONTAINER_ID_DESCRIPTOR(Structure):
    bLength: Byte
    bDescriptorType: Byte
    bDevCapabilityType: Byte
    bReserved: Byte
    ContainerID: Byte * 16
class USB_DEVICE_CAPABILITY_DESCRIPTOR(Structure):
    bLength: Byte
    bDescriptorType: Byte
    bDevCapabilityType: Byte
class USB_DEVICE_CAPABILITY_FIRMWARE_STATUS_DESCRIPTOR(Structure):
    bLength: Byte
    bDescriptorType: Byte
    bDevCapabilityType: Byte
    bcdDescriptorVersion: Byte
    bmAttributes: _bmAttributes_e__Union
    class _bmAttributes_e__Union(Union):
        AsUlong: UInt32
        Anonymous: _Anonymous_e__Struct
        _anonymous_ = ('Anonymous',)
        _pack_ = 1
        class _Anonymous_e__Struct(Structure):
            GetFirmwareImageHashSupport: Annotated[UInt32, NativeBitfieldAttribute(1)]
            DisallowFirmwareUpdateSupport: Annotated[UInt32, NativeBitfieldAttribute(1)]
            Reserved: Annotated[UInt32, NativeBitfieldAttribute(30)]
            _pack_ = 1
class USB_DEVICE_CAPABILITY_PD_CONSUMER_PORT_DESCRIPTOR(Structure):
    bLength: Byte
    bDescriptorType: Byte
    bDevCapabilityType: Byte
    bReserved: Byte
    bmCapabilities: _bmCapabilities_e__Union
    wMinVoltage: UInt16
    wMaxVoltage: UInt16
    wReserved: UInt16
    dwMaxOperatingPower: UInt32
    dwMaxPeakPower: UInt32
    dwMaxPeakPowerTime: UInt32
    _pack_ = 1
    class _bmCapabilities_e__Union(Union):
        AsUshort: UInt16
        Anonymous: _Anonymous_e__Struct
        _anonymous_ = ('Anonymous',)
        _pack_ = 1
        class _Anonymous_e__Struct(Structure):
            BatteryCharging: Annotated[UInt16, NativeBitfieldAttribute(1)]
            USBPowerDelivery: Annotated[UInt16, NativeBitfieldAttribute(1)]
            USBTypeCCurrent: Annotated[UInt16, NativeBitfieldAttribute(1)]
            Reserved: Annotated[UInt16, NativeBitfieldAttribute(13)]
            _pack_ = 1
class USB_DEVICE_CAPABILITY_PLATFORM_DESCRIPTOR(Structure):
    bLength: Byte
    bDescriptorType: Byte
    bDevCapabilityType: Byte
    bReserved: Byte
    PlatformCapabilityUuid: Guid
    CapabililityData: FlexibleArray[Byte]
    _pack_ = 1
class USB_DEVICE_CAPABILITY_POWER_DELIVERY_DESCRIPTOR(Structure):
    bLength: Byte
    bDescriptorType: Byte
    bDevCapabilityType: Byte
    bReserved: Byte
    bmAttributes: _bmAttributes_e__Union
    bmProviderPorts: UInt16
    bmConsumerPorts: UInt16
    bcdBCVersion: UInt16
    bcdPDVersion: UInt16
    bcdUSBTypeCVersion: UInt16
    _pack_ = 1
    class _bmAttributes_e__Union(Union):
        AsUlong: UInt32
        Anonymous: _Anonymous_e__Struct
        _anonymous_ = ('Anonymous',)
        _pack_ = 1
        class _Anonymous_e__Struct(Structure):
            Reserved1: Annotated[UInt32, NativeBitfieldAttribute(1)]
            BatteryCharging: Annotated[UInt32, NativeBitfieldAttribute(1)]
            USBPowerDelivery: Annotated[UInt32, NativeBitfieldAttribute(1)]
            Provider: Annotated[UInt32, NativeBitfieldAttribute(1)]
            Consumer: Annotated[UInt32, NativeBitfieldAttribute(1)]
            ChargingPolicy: Annotated[UInt32, NativeBitfieldAttribute(1)]
            TypeCCurrent: Annotated[UInt32, NativeBitfieldAttribute(1)]
            Reserved2: Annotated[UInt32, NativeBitfieldAttribute(1)]
            ACSupply: Annotated[UInt32, NativeBitfieldAttribute(1)]
            Battery: Annotated[UInt32, NativeBitfieldAttribute(1)]
            Other: Annotated[UInt32, NativeBitfieldAttribute(1)]
            NumBatteries: Annotated[UInt32, NativeBitfieldAttribute(3)]
            UsesVbus: Annotated[UInt32, NativeBitfieldAttribute(1)]
            Reserved3: Annotated[UInt32, NativeBitfieldAttribute(17)]
            _pack_ = 1
class USB_DEVICE_CAPABILITY_SUPERSPEEDPLUS_SPEED(Union):
    AsUlong32: UInt32
    Anonymous: _Anonymous_e__Struct
    _anonymous_ = ('Anonymous',)
    _pack_ = 1
    class _Anonymous_e__Struct(Structure):
        SublinkSpeedAttrID: Annotated[UInt32, NativeBitfieldAttribute(4)]
        LaneSpeedExponent: Annotated[UInt32, NativeBitfieldAttribute(2)]
        SublinkTypeMode: Annotated[UInt32, NativeBitfieldAttribute(1)]
        SublinkTypeDir: Annotated[UInt32, NativeBitfieldAttribute(1)]
        Reserved: Annotated[UInt32, NativeBitfieldAttribute(6)]
        LinkProtocol: Annotated[UInt32, NativeBitfieldAttribute(2)]
        LaneSpeedMantissa: Annotated[UInt32, NativeBitfieldAttribute(16)]
        _pack_ = 1
class USB_DEVICE_CAPABILITY_SUPERSPEEDPLUS_USB_DESCRIPTOR(Structure):
    bLength: Byte
    bDescriptorType: Byte
    bDevCapabilityType: Byte
    bReserved: Byte
    bmAttributes: _bmAttributes_e__Union
    wFunctionalitySupport: _wFunctionalitySupport_e__Union
    wReserved: UInt16
    bmSublinkSpeedAttr: FlexibleArray[win32more.Windows.Win32.Devices.Usb.USB_DEVICE_CAPABILITY_SUPERSPEEDPLUS_SPEED]
    _pack_ = 1
    class _bmAttributes_e__Union(Union):
        AsUlong: UInt32
        Anonymous: _Anonymous_e__Struct
        _anonymous_ = ('Anonymous',)
        _pack_ = 1
        class _Anonymous_e__Struct(Structure):
            SublinkSpeedAttrCount: Annotated[UInt32, NativeBitfieldAttribute(5)]
            SublinkSpeedIDCount: Annotated[UInt32, NativeBitfieldAttribute(4)]
            Reserved: Annotated[UInt32, NativeBitfieldAttribute(23)]
            _pack_ = 1
    class _wFunctionalitySupport_e__Union(Union):
        AsUshort: UInt16
        Anonymous: _Anonymous_e__Struct
        _anonymous_ = ('Anonymous',)
        _pack_ = 1
        class _Anonymous_e__Struct(Structure):
            SublinkSpeedAttrID: Annotated[UInt16, NativeBitfieldAttribute(4)]
            Reserved: Annotated[UInt16, NativeBitfieldAttribute(4)]
            MinRxLaneCount: Annotated[UInt16, NativeBitfieldAttribute(4)]
            MinTxLaneCount: Annotated[UInt16, NativeBitfieldAttribute(4)]
            _pack_ = 1
class USB_DEVICE_CAPABILITY_SUPERSPEED_USB_DESCRIPTOR(Structure):
    bLength: Byte
    bDescriptorType: Byte
    bDevCapabilityType: Byte
    bmAttributes: Byte
    wSpeedsSupported: UInt16
    bFunctionalitySupport: Byte
    bU1DevExitLat: Byte
    wU2DevExitLat: UInt16
    _pack_ = 1
class USB_DEVICE_CAPABILITY_USB20_EXTENSION_DESCRIPTOR(Structure):
    bLength: Byte
    bDescriptorType: Byte
    bDevCapabilityType: Byte
    bmAttributes: _bmAttributes_e__Union
    class _bmAttributes_e__Union(Union):
        AsUlong: UInt32
        Anonymous: _Anonymous_e__Struct
        _anonymous_ = ('Anonymous',)
        _pack_ = 1
        class _Anonymous_e__Struct(Structure):
            Reserved: Annotated[UInt32, NativeBitfieldAttribute(1)]
            LPMCapable: Annotated[UInt32, NativeBitfieldAttribute(1)]
            BESLAndAlternateHIRDSupported: Annotated[UInt32, NativeBitfieldAttribute(1)]
            BaselineBESLValid: Annotated[UInt32, NativeBitfieldAttribute(1)]
            DeepBESLValid: Annotated[UInt32, NativeBitfieldAttribute(1)]
            Reserved1: Annotated[UInt32, NativeBitfieldAttribute(3)]
            BaselineBESL: Annotated[UInt32, NativeBitfieldAttribute(4)]
            DeepBESL: Annotated[UInt32, NativeBitfieldAttribute(4)]
            Reserved2: Annotated[UInt32, NativeBitfieldAttribute(16)]
            _pack_ = 1
class USB_DEVICE_CHARACTERISTICS(Structure):
    Version: UInt32
    Reserved: UInt32 * 2
    UsbDeviceCharacteristicsFlags: UInt32
    MaximumSendPathDelayInMilliSeconds: UInt32
    MaximumCompletionPathDelayInMilliSeconds: UInt32
    _pack_ = 1
class USB_DEVICE_DESCRIPTOR(Structure):
    bLength: Byte
    bDescriptorType: Byte
    bcdUSB: UInt16
    bDeviceClass: Byte
    bDeviceSubClass: Byte
    bDeviceProtocol: Byte
    bMaxPacketSize0: Byte
    idVendor: UInt16
    idProduct: UInt16
    bcdDevice: UInt16
    iManufacturer: Byte
    iProduct: Byte
    iSerialNumber: Byte
    bNumConfigurations: Byte
    _pack_ = 1
class USB_DEVICE_INFO(Structure):
    DeviceState: win32more.Windows.Win32.Devices.Usb.USB_DEVICE_STATE
    PortNumber: UInt16
    DeviceDescriptor: win32more.Windows.Win32.Devices.Usb.USB_DEVICE_DESCRIPTOR
    CurrentConfigurationValue: Byte
    Speed: win32more.Windows.Win32.Devices.Usb.USB_DEVICE_SPEED
    DeviceAddress: UInt16
    ConnectionIndex: UInt32
    ConnectionStatus: win32more.Windows.Win32.Devices.Usb.USB_CONNECTION_STATUS
    PnpHardwareId: Char * 128
    PnpCompatibleId: Char * 128
    SerialNumberId: Char * 128
    PnpDeviceDescription: Char * 128
    NumberOfOpenPipes: UInt32
    PipeList: FlexibleArray[win32more.Windows.Win32.Devices.Usb.USB_PIPE_INFO]
    _pack_ = 1
class USB_DEVICE_NODE_INFO(Structure):
    Sig: UInt32
    LengthInBytes: UInt32
    DeviceDescription: Char * 40
    NodeType: win32more.Windows.Win32.Devices.Usb.USB_WMI_DEVICE_NODE_TYPE
    BusAddress: win32more.Windows.Win32.Devices.Usb.USB_TOPOLOGY_ADDRESS
    Anonymous: _Anonymous_e__Union
    _anonymous_ = ('Anonymous',)
    _pack_ = 1
    class _Anonymous_e__Union(Union):
        UsbDeviceInfo: win32more.Windows.Win32.Devices.Usb.USB_DEVICE_INFO
        HubDeviceInfo: win32more.Windows.Win32.Devices.Usb.USB_HUB_DEVICE_INFO
        CompositeDeviceInfo: win32more.Windows.Win32.Devices.Usb.USB_COMPOSITE_DEVICE_INFO
        ControllerDeviceInfo: win32more.Windows.Win32.Devices.Usb.USB_CONTROLLER_DEVICE_INFO
        DeviceInformation: Byte * 4
class USB_DEVICE_PERFORMANCE_INFO(Structure):
    BulkBytes: UInt32
    ControlDataBytes: UInt32
    IsoBytes: UInt32
    InterruptBytes: UInt32
    BulkUrbCount: UInt32
    ControlUrbCount: UInt32
    IsoUrbCount: UInt32
    InterruptUrbCount: UInt32
    AllocedInterrupt: UInt32 * 6
    AllocedIso: UInt32
    Total32secBandwidth: UInt32
    TotalTtBandwidth: UInt32
    DeviceDescription: Char * 60
    DeviceSpeed: win32more.Windows.Win32.Devices.Usb.USB_DEVICE_SPEED
    TotalIsoLatency: UInt32
    DroppedIsoPackets: UInt32
    TransferErrors: UInt32
    PciInterruptCount: UInt32
    HcIdleState: UInt32
    HcAsyncIdleState: UInt32
    HcAsyncCacheFlushCount: UInt32
    HcPeriodicIdleState: UInt32
    HcPeriodicCacheFlushCount: UInt32
    _pack_ = 1
class USB_DEVICE_QUALIFIER_DESCRIPTOR(Structure):
    bLength: Byte
    bDescriptorType: Byte
    bcdUSB: UInt16
    bDeviceClass: Byte
    bDeviceSubClass: Byte
    bDeviceProtocol: Byte
    bMaxPacketSize0: Byte
    bNumConfigurations: Byte
    bReserved: Byte
    _pack_ = 1
USB_DEVICE_SPEED = Int32
UsbLowSpeed: win32more.Windows.Win32.Devices.Usb.USB_DEVICE_SPEED = 0
UsbFullSpeed: win32more.Windows.Win32.Devices.Usb.USB_DEVICE_SPEED = 1
UsbHighSpeed: win32more.Windows.Win32.Devices.Usb.USB_DEVICE_SPEED = 2
UsbSuperSpeed: win32more.Windows.Win32.Devices.Usb.USB_DEVICE_SPEED = 3
class USB_DEVICE_STATE(Structure):
    DeviceConnected: Annotated[UInt32, NativeBitfieldAttribute(1)]
    DeviceStarted: Annotated[UInt32, NativeBitfieldAttribute(1)]
    _pack_ = 1
class USB_DEVICE_STATUS(Union):
    AsUshort16: UInt16
    Anonymous: _Anonymous_e__Struct
    _anonymous_ = ('Anonymous',)
    _pack_ = 1
    class _Anonymous_e__Struct(Structure):
        SelfPowered: Annotated[UInt16, NativeBitfieldAttribute(1)]
        RemoteWakeup: Annotated[UInt16, NativeBitfieldAttribute(1)]
        U1Enable: Annotated[UInt16, NativeBitfieldAttribute(1)]
        U2Enable: Annotated[UInt16, NativeBitfieldAttribute(1)]
        LtmEnable: Annotated[UInt16, NativeBitfieldAttribute(1)]
        Reserved: Annotated[UInt16, NativeBitfieldAttribute(11)]
        _pack_ = 1
USB_DEVICE_TYPE = Int32
Usb11Device: win32more.Windows.Win32.Devices.Usb.USB_DEVICE_TYPE = 0
Usb20Device: win32more.Windows.Win32.Devices.Usb.USB_DEVICE_TYPE = 1
class USB_DRIVER_VERSION_PARAMETERS(Structure):
    DriverTrackingCode: UInt32
    USBDI_Version: UInt32
    USBUSER_Version: UInt32
    CheckedPortDriver: win32more.Windows.Win32.Foundation.BOOLEAN
    CheckedMiniportDriver: win32more.Windows.Win32.Foundation.BOOLEAN
    USB_Version: UInt16
    _pack_ = 1
class USB_ENDPOINT_DESCRIPTOR(Structure):
    bLength: Byte
    bDescriptorType: Byte
    bEndpointAddress: Byte
    bmAttributes: Byte
    wMaxPacketSize: UInt16
    bInterval: Byte
    _pack_ = 1
class USB_ENDPOINT_STATUS(Union):
    AsUshort16: UInt16
    Anonymous: _Anonymous_e__Struct
    _anonymous_ = ('Anonymous',)
    _pack_ = 1
    class _Anonymous_e__Struct(Structure):
        Halt: Annotated[UInt16, NativeBitfieldAttribute(1)]
        Reserved: Annotated[UInt16, NativeBitfieldAttribute(15)]
        _pack_ = 1
class USB_FRAME_NUMBER_AND_QPC_FOR_TIME_SYNC_INFORMATION(Structure):
    TimeTrackingHandle: win32more.Windows.Win32.Foundation.HANDLE
    InputFrameNumber: UInt32
    InputMicroFrameNumber: UInt32
    QueryPerformanceCounterAtInputFrameOrMicroFrame: Int64
    QueryPerformanceCounterFrequency: Int64
    PredictedAccuracyInMicroSeconds: UInt32
    CurrentGenerationID: UInt32
    CurrentQueryPerformanceCounter: Int64
    CurrentHardwareFrameNumber: UInt32
    CurrentHardwareMicroFrameNumber: UInt32
    CurrentUSBFrameNumber: UInt32
    _pack_ = 1
class USB_FUNCTION_SUSPEND_OPTIONS(Union):
    AsUchar: Byte
    Anonymous: _Anonymous_e__Struct
    _anonymous_ = ('Anonymous',)
    class _Anonymous_e__Struct(Structure):
        PowerState: Annotated[Byte, NativeBitfieldAttribute(1)]
        RemoteWakeEnabled: Annotated[Byte, NativeBitfieldAttribute(1)]
        Reserved: Annotated[Byte, NativeBitfieldAttribute(6)]
class USB_HCD_DRIVERKEY_NAME(Structure):
    ActualLength: UInt32
    DriverKeyName: FlexibleArray[Char]
    _pack_ = 1
class USB_HIGH_SPEED_MAXPACKET(Union):
    us: UInt16
    _pack_ = 1
    class _MP(Structure):
        MaxPacket: Annotated[UInt16, NativeBitfieldAttribute(11)]
        HSmux: Annotated[UInt16, NativeBitfieldAttribute(2)]
        Reserved: Annotated[UInt16, NativeBitfieldAttribute(3)]
        _pack_ = 1
class USB_HUB_30_PORT_REMOTE_WAKE_MASK(Union):
    AsUchar8: Byte
    Anonymous: _Anonymous_e__Struct
    _anonymous_ = ('Anonymous',)
    class _Anonymous_e__Struct(Structure):
        ConnectRemoteWakeEnable: Annotated[Byte, NativeBitfieldAttribute(1)]
        DisconnectRemoteWakeEnable: Annotated[Byte, NativeBitfieldAttribute(1)]
        OverCurrentRemoteWakeEnable: Annotated[Byte, NativeBitfieldAttribute(1)]
        Reserved0: Annotated[Byte, NativeBitfieldAttribute(5)]
class USB_HUB_CAPABILITIES(Structure):
    HubIs2xCapable: Annotated[UInt32, NativeBitfieldAttribute(1)]
    _pack_ = 1
class USB_HUB_CAPABILITIES_EX(Structure):
    CapabilityFlags: win32more.Windows.Win32.Devices.Usb.USB_HUB_CAP_FLAGS
class USB_HUB_CAP_FLAGS(Union):
    ul: UInt32
    Anonymous: _Anonymous_e__Struct
    _anonymous_ = ('Anonymous',)
    _pack_ = 1
    class _Anonymous_e__Struct(Structure):
        HubIsHighSpeedCapable: Annotated[UInt32, NativeBitfieldAttribute(1)]
        HubIsHighSpeed: Annotated[UInt32, NativeBitfieldAttribute(1)]
        HubIsMultiTtCapable: Annotated[UInt32, NativeBitfieldAttribute(1)]
        HubIsMultiTt: Annotated[UInt32, NativeBitfieldAttribute(1)]
        HubIsRoot: Annotated[UInt32, NativeBitfieldAttribute(1)]
        HubIsArmedWakeOnConnect: Annotated[UInt32, NativeBitfieldAttribute(1)]
        HubIsBusPowered: Annotated[UInt32, NativeBitfieldAttribute(1)]
        ReservedMBZ: Annotated[UInt32, NativeBitfieldAttribute(25)]
        _pack_ = 1
class USB_HUB_CHANGE(Union):
    AsUshort16: UInt16
    Anonymous: _Anonymous_e__Struct
    _anonymous_ = ('Anonymous',)
    _pack_ = 1
    class _Anonymous_e__Struct(Structure):
        LocalPowerChange: Annotated[UInt16, NativeBitfieldAttribute(1)]
        OverCurrentChange: Annotated[UInt16, NativeBitfieldAttribute(1)]
        Reserved: Annotated[UInt16, NativeBitfieldAttribute(14)]
        _pack_ = 1
class USB_HUB_DESCRIPTOR(Structure):
    bDescriptorLength: Byte
    bDescriptorType: Byte
    bNumberOfPorts: Byte
    wHubCharacteristics: UInt16
    bPowerOnToPowerGood: Byte
    bHubControlCurrent: Byte
    bRemoveAndPowerMask: Byte * 64
    _pack_ = 1
class USB_HUB_DEVICE_INFO(Structure):
    HubDescriptor: win32more.Windows.Win32.Devices.Usb.USB_HUB_DESCRIPTOR
    HubNumber: UInt32
    DeviceAddress: UInt16
    HubIsSelfPowered: win32more.Windows.Win32.Foundation.BOOLEAN
    HubIsRootHub: win32more.Windows.Win32.Foundation.BOOLEAN
    HubCapabilities: win32more.Windows.Win32.Devices.Usb.USB_HUB_CAPABILITIES
    NumberOfHubPorts: UInt32
    PortInfo: FlexibleArray[win32more.Windows.Win32.Devices.Usb.USB_HUB_PORT_INFORMATION]
    _pack_ = 1
class USB_HUB_DEVICE_UXD_SETTINGS(Structure):
    Version: UInt32
    PnpGuid: Guid
    OwnerGuid: Guid
    DeleteOnShutdown: UInt32
    DeleteOnReload: UInt32
    DeleteOnDisconnect: UInt32
    Reserved: UInt32 * 5
    _pack_ = 1
class USB_HUB_INFORMATION(Structure):
    HubDescriptor: win32more.Windows.Win32.Devices.Usb.USB_HUB_DESCRIPTOR
    HubIsBusPowered: win32more.Windows.Win32.Foundation.BOOLEAN
class USB_HUB_INFORMATION_EX(Structure):
    HubType: win32more.Windows.Win32.Devices.Usb.USB_HUB_TYPE
    HighestPortNumber: UInt16
    u: _u_e__Union
    _pack_ = 1
    class _u_e__Union(Union):
        UsbHubDescriptor: win32more.Windows.Win32.Devices.Usb.USB_HUB_DESCRIPTOR
        Usb30HubDescriptor: win32more.Windows.Win32.Devices.Usb.USB_30_HUB_DESCRIPTOR
class USB_HUB_NAME(Structure):
    ActualLength: UInt32
    HubName: FlexibleArray[Char]
    _pack_ = 1
USB_HUB_NODE = Int32
UsbHub: win32more.Windows.Win32.Devices.Usb.USB_HUB_NODE = 0
UsbMIParent: win32more.Windows.Win32.Devices.Usb.USB_HUB_NODE = 1
class USB_HUB_PORT_INFORMATION(Structure):
    DeviceState: win32more.Windows.Win32.Devices.Usb.USB_DEVICE_STATE
    PortNumber: UInt16
    DeviceAddress: UInt16
    ConnectionIndex: UInt32
    ConnectionStatus: win32more.Windows.Win32.Devices.Usb.USB_CONNECTION_STATUS
    _pack_ = 1
class USB_HUB_STATUS(Union):
    AsUshort16: UInt16
    Anonymous: _Anonymous_e__Struct
    _anonymous_ = ('Anonymous',)
    _pack_ = 1
    class _Anonymous_e__Struct(Structure):
        LocalPowerLost: Annotated[UInt16, NativeBitfieldAttribute(1)]
        OverCurrent: Annotated[UInt16, NativeBitfieldAttribute(1)]
        Reserved: Annotated[UInt16, NativeBitfieldAttribute(14)]
        _pack_ = 1
class USB_HUB_STATUS_AND_CHANGE(Union):
    AsUlong32: UInt32
    Anonymous: _Anonymous_e__Struct
    _anonymous_ = ('Anonymous',)
    _pack_ = 1
    class _Anonymous_e__Struct(Structure):
        HubStatus: win32more.Windows.Win32.Devices.Usb.USB_HUB_STATUS
        HubChange: win32more.Windows.Win32.Devices.Usb.USB_HUB_CHANGE
USB_HUB_TYPE = Int32
UsbRootHub: win32more.Windows.Win32.Devices.Usb.USB_HUB_TYPE = 1
Usb20Hub: win32more.Windows.Win32.Devices.Usb.USB_HUB_TYPE = 2
Usb30Hub: win32more.Windows.Win32.Devices.Usb.USB_HUB_TYPE = 3
@winfunctype_pointer
def USB_IDLE_CALLBACK(Context: VoidPtr) -> Void: ...
class USB_IDLE_CALLBACK_INFO(Structure):
    IdleCallback: win32more.Windows.Win32.Devices.Usb.USB_IDLE_CALLBACK
    IdleContext: VoidPtr
class USB_ID_STRING(Structure):
    LanguageId: UInt16
    Pad: UInt16
    LengthInBytes: UInt32
    Buffer: win32more.Windows.Win32.Foundation.PWSTR
    _pack_ = 1
class USB_INTERFACE_ASSOCIATION_DESCRIPTOR(Structure):
    bLength: Byte
    bDescriptorType: Byte
    bFirstInterface: Byte
    bInterfaceCount: Byte
    bFunctionClass: Byte
    bFunctionSubClass: Byte
    bFunctionProtocol: Byte
    iFunction: Byte
class USB_INTERFACE_DESCRIPTOR(Structure):
    bLength: Byte
    bDescriptorType: Byte
    bInterfaceNumber: Byte
    bAlternateSetting: Byte
    bNumEndpoints: Byte
    bInterfaceClass: Byte
    bInterfaceSubClass: Byte
    bInterfaceProtocol: Byte
    iInterface: Byte
class USB_INTERFACE_POWER_DESCRIPTOR(Structure):
    bLength: Byte
    bDescriptorType: Byte
    bmCapabilitiesFlags: Byte
    bBusPowerSavingD1: Byte
    bSelfPowerSavingD1: Byte
    bBusPowerSavingD2: Byte
    bSelfPowerSavingD2: Byte
    bBusPowerSavingD3: Byte
    bSelfPowerSavingD3: Byte
    TransitionTimeFromD1: UInt16
    TransitionTimeFromD2: UInt16
    TransitionTimeFromD3: UInt16
    _pack_ = 1
class USB_INTERFACE_STATUS(Union):
    AsUshort16: UInt16
    Anonymous: _Anonymous_e__Struct
    _anonymous_ = ('Anonymous',)
    _pack_ = 1
    class _Anonymous_e__Struct(Structure):
        RemoteWakeupCapable: Annotated[UInt16, NativeBitfieldAttribute(1)]
        RemoteWakeupEnabled: Annotated[UInt16, NativeBitfieldAttribute(1)]
        Reserved: Annotated[UInt16, NativeBitfieldAttribute(14)]
        _pack_ = 1
class USB_MI_PARENT_INFORMATION(Structure):
    NumberOfInterfaces: UInt32
    _pack_ = 1
class USB_NODE_CONNECTION_ATTRIBUTES(Structure):
    ConnectionIndex: UInt32
    ConnectionStatus: win32more.Windows.Win32.Devices.Usb.USB_CONNECTION_STATUS
    PortAttributes: UInt32
    _pack_ = 1
class USB_NODE_CONNECTION_DRIVERKEY_NAME(Structure):
    ConnectionIndex: UInt32
    ActualLength: UInt32
    DriverKeyName: FlexibleArray[Char]
    _pack_ = 1
class USB_NODE_CONNECTION_INFORMATION(Structure):
    ConnectionIndex: UInt32
    DeviceDescriptor: win32more.Windows.Win32.Devices.Usb.USB_DEVICE_DESCRIPTOR
    CurrentConfigurationValue: Byte
    LowSpeed: win32more.Windows.Win32.Foundation.BOOLEAN
    DeviceIsHub: win32more.Windows.Win32.Foundation.BOOLEAN
    DeviceAddress: UInt16
    NumberOfOpenPipes: UInt32
    ConnectionStatus: win32more.Windows.Win32.Devices.Usb.USB_CONNECTION_STATUS
    PipeList: FlexibleArray[win32more.Windows.Win32.Devices.Usb.USB_PIPE_INFO]
    _pack_ = 1
class USB_NODE_CONNECTION_INFORMATION_EX(Structure):
    ConnectionIndex: UInt32
    DeviceDescriptor: win32more.Windows.Win32.Devices.Usb.USB_DEVICE_DESCRIPTOR
    CurrentConfigurationValue: Byte
    Speed: Byte
    DeviceIsHub: win32more.Windows.Win32.Foundation.BOOLEAN
    DeviceAddress: UInt16
    NumberOfOpenPipes: UInt32
    ConnectionStatus: win32more.Windows.Win32.Devices.Usb.USB_CONNECTION_STATUS
    PipeList: FlexibleArray[win32more.Windows.Win32.Devices.Usb.USB_PIPE_INFO]
    _pack_ = 1
class USB_NODE_CONNECTION_INFORMATION_EX_V2(Structure):
    ConnectionIndex: UInt32
    Length: UInt32
    SupportedUsbProtocols: win32more.Windows.Win32.Devices.Usb.USB_PROTOCOLS
    Flags: win32more.Windows.Win32.Devices.Usb.USB_NODE_CONNECTION_INFORMATION_EX_V2_FLAGS
    _pack_ = 1
class USB_NODE_CONNECTION_INFORMATION_EX_V2_FLAGS(Union):
    ul: UInt32
    Anonymous: _Anonymous_e__Struct
    _anonymous_ = ('Anonymous',)
    _pack_ = 1
    class _Anonymous_e__Struct(Structure):
        DeviceIsOperatingAtSuperSpeedOrHigher: Annotated[UInt32, NativeBitfieldAttribute(1)]
        DeviceIsSuperSpeedCapableOrHigher: Annotated[UInt32, NativeBitfieldAttribute(1)]
        DeviceIsOperatingAtSuperSpeedPlusOrHigher: Annotated[UInt32, NativeBitfieldAttribute(1)]
        DeviceIsSuperSpeedPlusCapableOrHigher: Annotated[UInt32, NativeBitfieldAttribute(1)]
        ReservedMBZ: Annotated[UInt32, NativeBitfieldAttribute(28)]
        _pack_ = 1
class USB_NODE_CONNECTION_NAME(Structure):
    ConnectionIndex: UInt32
    ActualLength: UInt32
    NodeName: FlexibleArray[Char]
    _pack_ = 1
class USB_NODE_INFORMATION(Structure):
    NodeType: win32more.Windows.Win32.Devices.Usb.USB_HUB_NODE
    u: _u_e__Union
    _pack_ = 1
    class _u_e__Union(Union):
        HubInformation: win32more.Windows.Win32.Devices.Usb.USB_HUB_INFORMATION
        MiParentInformation: win32more.Windows.Win32.Devices.Usb.USB_MI_PARENT_INFORMATION
class USB_NOTIFICATION(Structure):
    NotificationType: win32more.Windows.Win32.Devices.Usb.USB_NOTIFICATION_TYPE
    _pack_ = 1
USB_NOTIFICATION_TYPE = Int32
EnumerationFailure: win32more.Windows.Win32.Devices.Usb.USB_NOTIFICATION_TYPE = 0
InsufficentBandwidth: win32more.Windows.Win32.Devices.Usb.USB_NOTIFICATION_TYPE = 1
InsufficentPower: win32more.Windows.Win32.Devices.Usb.USB_NOTIFICATION_TYPE = 2
OverCurrent: win32more.Windows.Win32.Devices.Usb.USB_NOTIFICATION_TYPE = 3
ResetOvercurrent: win32more.Windows.Win32.Devices.Usb.USB_NOTIFICATION_TYPE = 4
AcquireBusInfo: win32more.Windows.Win32.Devices.Usb.USB_NOTIFICATION_TYPE = 5
AcquireHubName: win32more.Windows.Win32.Devices.Usb.USB_NOTIFICATION_TYPE = 6
AcquireControllerName: win32more.Windows.Win32.Devices.Usb.USB_NOTIFICATION_TYPE = 7
HubOvercurrent: win32more.Windows.Win32.Devices.Usb.USB_NOTIFICATION_TYPE = 8
HubPowerChange: win32more.Windows.Win32.Devices.Usb.USB_NOTIFICATION_TYPE = 9
HubNestedTooDeeply: win32more.Windows.Win32.Devices.Usb.USB_NOTIFICATION_TYPE = 10
ModernDeviceInLegacyHub: win32more.Windows.Win32.Devices.Usb.USB_NOTIFICATION_TYPE = 11
class USB_OPEN_RAW_DEVICE_PARAMETERS(Structure):
    PortStatus: UInt16
    MaxPacketEp0: UInt16
    _pack_ = 1
class USB_PASS_THRU_PARAMETERS(Structure):
    FunctionGUID: Guid
    ParameterLength: UInt32
    Parameters: Byte * 4
    _pack_ = 1
class USB_PIPE_INFO(Structure):
    EndpointDescriptor: win32more.Windows.Win32.Devices.Usb.USB_ENDPOINT_DESCRIPTOR
    ScheduleOffset: UInt32
    _pack_ = 1
class USB_PORT_CHANGE(Union):
    AsUshort16: UInt16
    Usb20PortChange: win32more.Windows.Win32.Devices.Usb.USB_20_PORT_CHANGE
    Usb30PortChange: win32more.Windows.Win32.Devices.Usb.USB_30_PORT_CHANGE
    _pack_ = 1
class USB_PORT_CONNECTOR_PROPERTIES(Structure):
    ConnectionIndex: UInt32
    ActualLength: UInt32
    UsbPortProperties: win32more.Windows.Win32.Devices.Usb.USB_PORT_PROPERTIES
    CompanionIndex: UInt16
    CompanionPortNumber: UInt16
    CompanionHubSymbolicLinkName: FlexibleArray[Char]
    _pack_ = 1
class USB_PORT_EXT_STATUS(Union):
    AsUlong32: UInt32
    Anonymous: _Anonymous_e__Struct
    _anonymous_ = ('Anonymous',)
    _pack_ = 1
    class _Anonymous_e__Struct(Structure):
        RxSublinkSpeedID: Annotated[UInt32, NativeBitfieldAttribute(4)]
        TxSublinkSpeedID: Annotated[UInt32, NativeBitfieldAttribute(4)]
        RxLaneCount: Annotated[UInt32, NativeBitfieldAttribute(4)]
        TxLaneCount: Annotated[UInt32, NativeBitfieldAttribute(4)]
        Reserved: Annotated[UInt32, NativeBitfieldAttribute(16)]
        _pack_ = 1
class USB_PORT_EXT_STATUS_AND_CHANGE(Union):
    AsUlong64: UInt64
    Anonymous: _Anonymous_e__Struct
    _anonymous_ = ('Anonymous',)
    _pack_ = 1
    class _Anonymous_e__Struct(Structure):
        PortStatusChange: win32more.Windows.Win32.Devices.Usb.USB_PORT_STATUS_AND_CHANGE
        PortExtStatus: win32more.Windows.Win32.Devices.Usb.USB_PORT_EXT_STATUS
class USB_PORT_PROPERTIES(Union):
    ul: UInt32
    Anonymous: _Anonymous_e__Struct
    _anonymous_ = ('Anonymous',)
    _pack_ = 1
    class _Anonymous_e__Struct(Structure):
        PortIsUserConnectable: Annotated[UInt32, NativeBitfieldAttribute(1)]
        PortIsDebugCapable: Annotated[UInt32, NativeBitfieldAttribute(1)]
        PortHasMultipleCompanions: Annotated[UInt32, NativeBitfieldAttribute(1)]
        PortConnectorIsTypeC: Annotated[UInt32, NativeBitfieldAttribute(1)]
        ReservedMBZ: Annotated[UInt32, NativeBitfieldAttribute(28)]
        _pack_ = 1
class USB_PORT_STATUS(Union):
    AsUshort16: UInt16
    Usb20PortStatus: win32more.Windows.Win32.Devices.Usb.USB_20_PORT_STATUS
    Usb30PortStatus: win32more.Windows.Win32.Devices.Usb.USB_30_PORT_STATUS
    _pack_ = 1
class USB_PORT_STATUS_AND_CHANGE(Union):
    AsUlong32: UInt32
    Anonymous: _Anonymous_e__Struct
    _anonymous_ = ('Anonymous',)
    _pack_ = 1
    class _Anonymous_e__Struct(Structure):
        PortStatus: win32more.Windows.Win32.Devices.Usb.USB_PORT_STATUS
        PortChange: win32more.Windows.Win32.Devices.Usb.USB_PORT_CHANGE
class USB_POWER_INFO(Structure):
    SystemState: win32more.Windows.Win32.Devices.Usb.WDMUSB_POWER_STATE
    HcDevicePowerState: win32more.Windows.Win32.Devices.Usb.WDMUSB_POWER_STATE
    HcDeviceWake: win32more.Windows.Win32.Devices.Usb.WDMUSB_POWER_STATE
    HcSystemWake: win32more.Windows.Win32.Devices.Usb.WDMUSB_POWER_STATE
    RhDevicePowerState: win32more.Windows.Win32.Devices.Usb.WDMUSB_POWER_STATE
    RhDeviceWake: win32more.Windows.Win32.Devices.Usb.WDMUSB_POWER_STATE
    RhSystemWake: win32more.Windows.Win32.Devices.Usb.WDMUSB_POWER_STATE
    LastSystemSleepState: win32more.Windows.Win32.Devices.Usb.WDMUSB_POWER_STATE
    CanWakeup: win32more.Windows.Win32.Foundation.BOOLEAN
    IsPowered: win32more.Windows.Win32.Foundation.BOOLEAN
    _pack_ = 1
class USB_PROTOCOLS(Union):
    ul: UInt32
    Anonymous: _Anonymous_e__Struct
    _anonymous_ = ('Anonymous',)
    _pack_ = 1
    class _Anonymous_e__Struct(Structure):
        Usb110: Annotated[UInt32, NativeBitfieldAttribute(1)]
        Usb200: Annotated[UInt32, NativeBitfieldAttribute(1)]
        Usb300: Annotated[UInt32, NativeBitfieldAttribute(1)]
        ReservedMBZ: Annotated[UInt32, NativeBitfieldAttribute(29)]
        _pack_ = 1
class USB_ROOT_HUB_NAME(Structure):
    ActualLength: UInt32
    RootHubName: FlexibleArray[Char]
    _pack_ = 1
class USB_SEND_RAW_COMMAND_PARAMETERS(Structure):
    Usb_bmRequest: Byte
    Usb_bRequest: Byte
    Usb_wVlaue: UInt16
    Usb_wIndex: UInt16
    Usb_wLength: UInt16
    DeviceAddress: UInt16
    MaximumPacketSize: UInt16
    Timeout: UInt32
    DataLength: UInt32
    UsbdStatusCode: Int32
    Data: Byte * 4
    _pack_ = 1
class USB_START_TRACKING_FOR_TIME_SYNC_INFORMATION(Structure):
    TimeTrackingHandle: win32more.Windows.Win32.Foundation.HANDLE
    IsStartupDelayTolerable: win32more.Windows.Win32.Foundation.BOOLEAN
    _pack_ = 1
class USB_STOP_TRACKING_FOR_TIME_SYNC_INFORMATION(Structure):
    TimeTrackingHandle: win32more.Windows.Win32.Foundation.HANDLE
    _pack_ = 1
class USB_STRING_DESCRIPTOR(Structure):
    bLength: Byte
    bDescriptorType: Byte
    bString: FlexibleArray[Char]
    _pack_ = 1
class USB_SUPERSPEEDPLUS_ISOCH_ENDPOINT_COMPANION_DESCRIPTOR(Structure):
    bLength: Byte
    bDescriptorType: Byte
    wReserved: UInt16
    dwBytesPerInterval: UInt32
    _pack_ = 1
class USB_SUPERSPEED_ENDPOINT_COMPANION_DESCRIPTOR(Structure):
    bLength: Byte
    bDescriptorType: Byte
    bMaxBurst: Byte
    bmAttributes: _bmAttributes_e__Union
    wBytesPerInterval: UInt16
    _pack_ = 1
    class _bmAttributes_e__Union(Union):
        AsUchar: Byte
        Bulk: _Bulk_e__Struct
        Isochronous: _Isochronous_e__Struct
        class _Bulk_e__Struct(Structure):
            MaxStreams: Annotated[Byte, NativeBitfieldAttribute(5)]
            Reserved1: Annotated[Byte, NativeBitfieldAttribute(3)]
        class _Isochronous_e__Struct(Structure):
            Mult: Annotated[Byte, NativeBitfieldAttribute(2)]
            Reserved2: Annotated[Byte, NativeBitfieldAttribute(5)]
            SspCompanion: Annotated[Byte, NativeBitfieldAttribute(1)]
class USB_TOPOLOGY_ADDRESS(Structure):
    PciBusNumber: UInt32
    PciDeviceNumber: UInt32
    PciFunctionNumber: UInt32
    Reserved: UInt32
    RootHubPortNumber: UInt16
    HubPortNumber: UInt16 * 5
    Reserved2: UInt16
class USB_TRANSPORT_CHARACTERISTICS(Structure):
    Version: UInt32
    TransportCharacteristicsFlags: UInt32
    CurrentRoundtripLatencyInMilliSeconds: UInt64
    MaxPotentialBandwidth: UInt64
    _pack_ = 1
class USB_TRANSPORT_CHARACTERISTICS_CHANGE_NOTIFICATION(Structure):
    Handle: win32more.Windows.Win32.Devices.Usb.USB_CHANGE_REGISTRATION_HANDLE
    UsbTransportCharacteristics: win32more.Windows.Win32.Devices.Usb.USB_TRANSPORT_CHARACTERISTICS
    _pack_ = 1
class USB_TRANSPORT_CHARACTERISTICS_CHANGE_REGISTRATION(Structure):
    ChangeNotificationInputFlags: UInt32
    Handle: win32more.Windows.Win32.Devices.Usb.USB_CHANGE_REGISTRATION_HANDLE
    UsbTransportCharacteristics: win32more.Windows.Win32.Devices.Usb.USB_TRANSPORT_CHARACTERISTICS
    _pack_ = 1
class USB_TRANSPORT_CHARACTERISTICS_CHANGE_UNREGISTRATION(Structure):
    Handle: win32more.Windows.Win32.Devices.Usb.USB_CHANGE_REGISTRATION_HANDLE
    _pack_ = 1
class USB_UNICODE_NAME(Structure):
    Length: UInt32
    String: FlexibleArray[Char]
    _pack_ = 1
class USB_USB2HW_VERSION_PARAMETERS(Structure):
    Usb2HwRevision: Byte
    _pack_ = 1
USB_USER_ERROR_CODE = Int32
UsbUserSuccess: win32more.Windows.Win32.Devices.Usb.USB_USER_ERROR_CODE = 0
UsbUserNotSupported: win32more.Windows.Win32.Devices.Usb.USB_USER_ERROR_CODE = 1
UsbUserInvalidRequestCode: win32more.Windows.Win32.Devices.Usb.USB_USER_ERROR_CODE = 2
UsbUserFeatureDisabled: win32more.Windows.Win32.Devices.Usb.USB_USER_ERROR_CODE = 3
UsbUserInvalidHeaderParameter: win32more.Windows.Win32.Devices.Usb.USB_USER_ERROR_CODE = 4
UsbUserInvalidParameter: win32more.Windows.Win32.Devices.Usb.USB_USER_ERROR_CODE = 5
UsbUserMiniportError: win32more.Windows.Win32.Devices.Usb.USB_USER_ERROR_CODE = 6
UsbUserBufferTooSmall: win32more.Windows.Win32.Devices.Usb.USB_USER_ERROR_CODE = 7
UsbUserErrorNotMapped: win32more.Windows.Win32.Devices.Usb.USB_USER_ERROR_CODE = 8
UsbUserDeviceNotStarted: win32more.Windows.Win32.Devices.Usb.USB_USER_ERROR_CODE = 9
UsbUserNoDeviceConnected: win32more.Windows.Win32.Devices.Usb.USB_USER_ERROR_CODE = 10
USB_WMI_DEVICE_NODE_TYPE = Int32
UsbDevice: win32more.Windows.Win32.Devices.Usb.USB_WMI_DEVICE_NODE_TYPE = 0
HubDevice: win32more.Windows.Win32.Devices.Usb.USB_WMI_DEVICE_NODE_TYPE = 1
CompositeDevice: win32more.Windows.Win32.Devices.Usb.USB_WMI_DEVICE_NODE_TYPE = 2
UsbController: win32more.Windows.Win32.Devices.Usb.USB_WMI_DEVICE_NODE_TYPE = 3
WDMUSB_POWER_STATE = Int32
WdmUsbPowerNotMapped: win32more.Windows.Win32.Devices.Usb.WDMUSB_POWER_STATE = 0
WdmUsbPowerSystemUnspecified: win32more.Windows.Win32.Devices.Usb.WDMUSB_POWER_STATE = 100
WdmUsbPowerSystemWorking: win32more.Windows.Win32.Devices.Usb.WDMUSB_POWER_STATE = 101
WdmUsbPowerSystemSleeping1: win32more.Windows.Win32.Devices.Usb.WDMUSB_POWER_STATE = 102
WdmUsbPowerSystemSleeping2: win32more.Windows.Win32.Devices.Usb.WDMUSB_POWER_STATE = 103
WdmUsbPowerSystemSleeping3: win32more.Windows.Win32.Devices.Usb.WDMUSB_POWER_STATE = 104
WdmUsbPowerSystemHibernate: win32more.Windows.Win32.Devices.Usb.WDMUSB_POWER_STATE = 105
WdmUsbPowerSystemShutdown: win32more.Windows.Win32.Devices.Usb.WDMUSB_POWER_STATE = 106
WdmUsbPowerDeviceUnspecified: win32more.Windows.Win32.Devices.Usb.WDMUSB_POWER_STATE = 200
WdmUsbPowerDeviceD0: win32more.Windows.Win32.Devices.Usb.WDMUSB_POWER_STATE = 201
WdmUsbPowerDeviceD1: win32more.Windows.Win32.Devices.Usb.WDMUSB_POWER_STATE = 202
WdmUsbPowerDeviceD2: win32more.Windows.Win32.Devices.Usb.WDMUSB_POWER_STATE = 203
WdmUsbPowerDeviceD3: win32more.Windows.Win32.Devices.Usb.WDMUSB_POWER_STATE = 204
WINUSB_INTERFACE_HANDLE = VoidPtr
class WINUSB_PIPE_INFORMATION(Structure):
    PipeType: win32more.Windows.Win32.Devices.Usb.USBD_PIPE_TYPE
    PipeId: Byte
    MaximumPacketSize: UInt16
    Interval: Byte
class WINUSB_PIPE_INFORMATION_EX(Structure):
    PipeType: win32more.Windows.Win32.Devices.Usb.USBD_PIPE_TYPE
    PipeId: Byte
    MaximumPacketSize: UInt16
    Interval: Byte
    MaximumBytesPerInterval: UInt32
WINUSB_PIPE_POLICY = UInt32
SHORT_PACKET_TERMINATE: win32more.Windows.Win32.Devices.Usb.WINUSB_PIPE_POLICY = 1
AUTO_CLEAR_STALL: win32more.Windows.Win32.Devices.Usb.WINUSB_PIPE_POLICY = 2
PIPE_TRANSFER_TIMEOUT: win32more.Windows.Win32.Devices.Usb.WINUSB_PIPE_POLICY = 3
IGNORE_SHORT_PACKETS: win32more.Windows.Win32.Devices.Usb.WINUSB_PIPE_POLICY = 4
ALLOW_PARTIAL_READS: win32more.Windows.Win32.Devices.Usb.WINUSB_PIPE_POLICY = 5
AUTO_FLUSH: win32more.Windows.Win32.Devices.Usb.WINUSB_PIPE_POLICY = 6
RAW_IO: win32more.Windows.Win32.Devices.Usb.WINUSB_PIPE_POLICY = 7
MAXIMUM_TRANSFER_SIZE: win32more.Windows.Win32.Devices.Usb.WINUSB_PIPE_POLICY = 8
RESET_PIPE_ON_RESUME: win32more.Windows.Win32.Devices.Usb.WINUSB_PIPE_POLICY = 9
WINUSB_POWER_POLICY = UInt32
AUTO_SUSPEND: win32more.Windows.Win32.Devices.Usb.WINUSB_POWER_POLICY = 129
SUSPEND_DELAY: win32more.Windows.Win32.Devices.Usb.WINUSB_POWER_POLICY = 131
class WINUSB_SETUP_PACKET(Structure):
    RequestType: Byte
    Request: Byte
    Value: UInt16
    Index: UInt16
    Length: UInt16
    _pack_ = 1
class _URB_BULK_OR_INTERRUPT_TRANSFER(Structure):
    Hdr: win32more.Windows.Win32.Devices.Usb._URB_HEADER
    PipeHandle: VoidPtr
    TransferFlags: UInt32
    TransferBufferLength: UInt32
    TransferBuffer: VoidPtr
    TransferBufferMDL: VoidPtr
    UrbLink: POINTER(win32more.Windows.Win32.Devices.Usb.URB)
    hca: win32more.Windows.Win32.Devices.Usb._URB_HCD_AREA
class _URB_CONTROL_DESCRIPTOR_REQUEST(Structure):
    Hdr: win32more.Windows.Win32.Devices.Usb._URB_HEADER
    Reserved: VoidPtr
    Reserved0: UInt32
    TransferBufferLength: UInt32
    TransferBuffer: VoidPtr
    TransferBufferMDL: VoidPtr
    UrbLink: POINTER(win32more.Windows.Win32.Devices.Usb.URB)
    hca: win32more.Windows.Win32.Devices.Usb._URB_HCD_AREA
    Reserved1: UInt16
    Index: Byte
    DescriptorType: Byte
    LanguageId: UInt16
    Reserved2: UInt16
class _URB_CONTROL_FEATURE_REQUEST(Structure):
    Hdr: win32more.Windows.Win32.Devices.Usb._URB_HEADER
    Reserved: VoidPtr
    Reserved2: UInt32
    Reserved3: UInt32
    Reserved4: VoidPtr
    Reserved5: VoidPtr
    UrbLink: POINTER(win32more.Windows.Win32.Devices.Usb.URB)
    hca: win32more.Windows.Win32.Devices.Usb._URB_HCD_AREA
    Reserved0: UInt16
    FeatureSelector: UInt16
    Index: UInt16
    Reserved1: UInt16
class _URB_CONTROL_GET_CONFIGURATION_REQUEST(Structure):
    Hdr: win32more.Windows.Win32.Devices.Usb._URB_HEADER
    Reserved: VoidPtr
    Reserved0: UInt32
    TransferBufferLength: UInt32
    TransferBuffer: VoidPtr
    TransferBufferMDL: VoidPtr
    UrbLink: POINTER(win32more.Windows.Win32.Devices.Usb.URB)
    hca: win32more.Windows.Win32.Devices.Usb._URB_HCD_AREA
    Reserved1: Byte * 8
class _URB_CONTROL_GET_INTERFACE_REQUEST(Structure):
    Hdr: win32more.Windows.Win32.Devices.Usb._URB_HEADER
    Reserved: VoidPtr
    Reserved0: UInt32
    TransferBufferLength: UInt32
    TransferBuffer: VoidPtr
    TransferBufferMDL: VoidPtr
    UrbLink: POINTER(win32more.Windows.Win32.Devices.Usb.URB)
    hca: win32more.Windows.Win32.Devices.Usb._URB_HCD_AREA
    Reserved1: Byte * 4
    Interface: UInt16
    Reserved2: UInt16
class _URB_CONTROL_GET_STATUS_REQUEST(Structure):
    Hdr: win32more.Windows.Win32.Devices.Usb._URB_HEADER
    Reserved: VoidPtr
    Reserved0: UInt32
    TransferBufferLength: UInt32
    TransferBuffer: VoidPtr
    TransferBufferMDL: VoidPtr
    UrbLink: POINTER(win32more.Windows.Win32.Devices.Usb.URB)
    hca: win32more.Windows.Win32.Devices.Usb._URB_HCD_AREA
    Reserved1: Byte * 4
    Index: UInt16
    Reserved2: UInt16
class _URB_CONTROL_TRANSFER(Structure):
    Hdr: win32more.Windows.Win32.Devices.Usb._URB_HEADER
    PipeHandle: VoidPtr
    TransferFlags: UInt32
    TransferBufferLength: UInt32
    TransferBuffer: VoidPtr
    TransferBufferMDL: VoidPtr
    UrbLink: POINTER(win32more.Windows.Win32.Devices.Usb.URB)
    hca: win32more.Windows.Win32.Devices.Usb._URB_HCD_AREA
    SetupPacket: Byte * 8
class _URB_CONTROL_TRANSFER_EX(Structure):
    Hdr: win32more.Windows.Win32.Devices.Usb._URB_HEADER
    PipeHandle: VoidPtr
    TransferFlags: UInt32
    TransferBufferLength: UInt32
    TransferBuffer: VoidPtr
    TransferBufferMDL: VoidPtr
    Timeout: UInt32
    hca: win32more.Windows.Win32.Devices.Usb._URB_HCD_AREA
    SetupPacket: Byte * 8
class _URB_CONTROL_VENDOR_OR_CLASS_REQUEST(Structure):
    Hdr: win32more.Windows.Win32.Devices.Usb._URB_HEADER
    Reserved: VoidPtr
    TransferFlags: UInt32
    TransferBufferLength: UInt32
    TransferBuffer: VoidPtr
    TransferBufferMDL: VoidPtr
    UrbLink: POINTER(win32more.Windows.Win32.Devices.Usb.URB)
    hca: win32more.Windows.Win32.Devices.Usb._URB_HCD_AREA
    RequestTypeReservedBits: Byte
    Request: Byte
    Value: UInt16
    Index: UInt16
    Reserved1: UInt16
class _URB_FRAME_LENGTH_CONTROL(Structure):
    Hdr: win32more.Windows.Win32.Devices.Usb._URB_HEADER
class _URB_GET_CURRENT_FRAME_NUMBER(Structure):
    Hdr: win32more.Windows.Win32.Devices.Usb._URB_HEADER
    FrameNumber: UInt32
class _URB_GET_FRAME_LENGTH(Structure):
    Hdr: win32more.Windows.Win32.Devices.Usb._URB_HEADER
    FrameLength: UInt32
    FrameNumber: UInt32
class _URB_GET_ISOCH_PIPE_TRANSFER_PATH_DELAYS(Structure):
    Hdr: win32more.Windows.Win32.Devices.Usb._URB_HEADER
    PipeHandle: VoidPtr
    MaximumSendPathDelayInMilliSeconds: UInt32
    MaximumCompletionPathDelayInMilliSeconds: UInt32
class _URB_HCD_AREA(Structure):
    Reserved8: VoidPtr * 8
class _URB_HEADER(Structure):
    Length: UInt16
    Function: UInt16
    Status: Int32
    UsbdDeviceHandle: VoidPtr
    UsbdFlags: UInt32
class _URB_ISOCH_TRANSFER(Structure):
    Hdr: win32more.Windows.Win32.Devices.Usb._URB_HEADER
    PipeHandle: VoidPtr
    TransferFlags: UInt32
    TransferBufferLength: UInt32
    TransferBuffer: VoidPtr
    TransferBufferMDL: VoidPtr
    UrbLink: POINTER(win32more.Windows.Win32.Devices.Usb.URB)
    hca: win32more.Windows.Win32.Devices.Usb._URB_HCD_AREA
    StartFrame: UInt32
    NumberOfPackets: UInt32
    ErrorCount: UInt32
    IsoPacket: FlexibleArray[win32more.Windows.Win32.Devices.Usb.USBD_ISO_PACKET_DESCRIPTOR]
class _URB_OPEN_STATIC_STREAMS(Structure):
    Hdr: win32more.Windows.Win32.Devices.Usb._URB_HEADER
    PipeHandle: VoidPtr
    NumberOfStreams: UInt32
    StreamInfoVersion: UInt16
    StreamInfoSize: UInt16
    Streams: POINTER(win32more.Windows.Win32.Devices.Usb.USBD_STREAM_INFORMATION)
class _URB_OS_FEATURE_DESCRIPTOR_REQUEST(Structure):
    Hdr: win32more.Windows.Win32.Devices.Usb._URB_HEADER
    Reserved: VoidPtr
    Reserved0: UInt32
    TransferBufferLength: UInt32
    TransferBuffer: VoidPtr
    TransferBufferMDL: VoidPtr
    UrbLink: POINTER(win32more.Windows.Win32.Devices.Usb.URB)
    hca: win32more.Windows.Win32.Devices.Usb._URB_HCD_AREA
    Recipient: Annotated[Byte, NativeBitfieldAttribute(5)]
    Reserved1: Annotated[Byte, NativeBitfieldAttribute(3)]
    Reserved2: Byte
    InterfaceNumber: Byte
    MS_PageIndex: Byte
    MS_FeatureDescriptorIndex: UInt16
    Reserved3: UInt16
class _URB_PIPE_REQUEST(Structure):
    Hdr: win32more.Windows.Win32.Devices.Usb._URB_HEADER
    PipeHandle: VoidPtr
    Reserved: UInt32
class _URB_SELECT_CONFIGURATION(Structure):
    Hdr: win32more.Windows.Win32.Devices.Usb._URB_HEADER
    ConfigurationDescriptor: POINTER(win32more.Windows.Win32.Devices.Usb.USB_CONFIGURATION_DESCRIPTOR)
    ConfigurationHandle: VoidPtr
    Interface: win32more.Windows.Win32.Devices.Usb.USBD_INTERFACE_INFORMATION
class _URB_SELECT_INTERFACE(Structure):
    Hdr: win32more.Windows.Win32.Devices.Usb._URB_HEADER
    ConfigurationHandle: VoidPtr
    Interface: win32more.Windows.Win32.Devices.Usb.USBD_INTERFACE_INFORMATION
class _URB_SET_FRAME_LENGTH(Structure):
    Hdr: win32more.Windows.Win32.Devices.Usb._URB_HEADER
    FrameLengthDelta: Int32


make_ready(__name__)
