from __future__ import annotations
from win32more.win32.prelude import *
import win32more.Windows.Win32.Foundation
import win32more.Windows.Win32.Graphics.Direct2D
import win32more.Windows.Win32.Graphics.Direct2D.Common
import win32more.Windows.Win32.Graphics.Direct3D
import win32more.Windows.Win32.Graphics.DirectWrite
import win32more.Windows.Win32.Graphics.Dxgi
import win32more.Windows.Win32.Graphics.Dxgi.Common
import win32more.Windows.Win32.Graphics.Gdi
import win32more.Windows.Win32.Graphics.Imaging
import win32more.Windows.Win32.Storage.Xps.Printing
import win32more.Windows.Win32.System.Com
D2D1_DEFAULT_FLATTENING_TOLERANCE: Single = 0.25
CLSID_D2D12DAffineTransform: Guid = Guid('{6aa97485-6354-4cfc-908c-e4a74f62c96c}')
CLSID_D2D13DPerspectiveTransform: Guid = Guid('{c2844d0b-3d86-46e7-85ba-526c9240f3fb}')
CLSID_D2D13DTransform: Guid = Guid('{e8467b04-ec61-4b8a-b5de-d4d73debea5a}')
CLSID_D2D1ArithmeticComposite: Guid = Guid('{fc151437-049a-4784-a24a-f1c4daf20987}')
CLSID_D2D1Atlas: Guid = Guid('{913e2be4-fdcf-4fe2-a5f0-2454f14ff408}')
CLSID_D2D1BitmapSource: Guid = Guid('{5fb6c24d-c6dd-4231-9404-50f4d5c3252d}')
CLSID_D2D1Blend: Guid = Guid('{81c5b77b-13f8-4cdd-ad20-c890547ac65d}')
CLSID_D2D1Border: Guid = Guid('{2a2d49c0-4acf-43c7-8c6a-7c4a27874d27}')
CLSID_D2D1Brightness: Guid = Guid('{8cea8d1e-77b0-4986-b3b9-2f0c0eae7887}')
CLSID_D2D1ColorManagement: Guid = Guid('{1a28524c-fdd6-4aa4-ae8f-837eb8267b37}')
CLSID_D2D1ColorMatrix: Guid = Guid('{921f03d6-641c-47df-852d-b4bb6153ae11}')
CLSID_D2D1Composite: Guid = Guid('{48fc9f51-f6ac-48f1-8b58-3b28ac46f76d}')
CLSID_D2D1ConvolveMatrix: Guid = Guid('{407f8c08-5533-4331-a341-23cc3877843e}')
CLSID_D2D1Crop: Guid = Guid('{e23f7110-0e9a-4324-af47-6a2c0c46f35b}')
CLSID_D2D1DirectionalBlur: Guid = Guid('{174319a6-58e9-49b2-bb63-caf2c811a3db}')
CLSID_D2D1DiscreteTransfer: Guid = Guid('{90866fcd-488e-454b-af06-e5041b66c36c}')
CLSID_D2D1DisplacementMap: Guid = Guid('{edc48364-0417-4111-9450-43845fa9f890}')
CLSID_D2D1DistantDiffuse: Guid = Guid('{3e7efd62-a32d-46d4-a83c-5278889ac954}')
CLSID_D2D1DistantSpecular: Guid = Guid('{428c1ee5-77b8-4450-8ab5-72219c21abda}')
CLSID_D2D1DpiCompensation: Guid = Guid('{6c26c5c7-34e0-46fc-9cfd-e5823706e228}')
CLSID_D2D1Flood: Guid = Guid('{61c23c20-ae69-4d8e-94cf-50078df638f2}')
CLSID_D2D1GammaTransfer: Guid = Guid('{409444c4-c419-41a0-b0c1-8cd0c0a18e42}')
CLSID_D2D1GaussianBlur: Guid = Guid('{1feb6d69-2fe6-4ac9-8c58-1d7f93e7a6a5}')
CLSID_D2D1Scale: Guid = Guid('{9daf9369-3846-4d0e-a44e-0c607934a5d7}')
CLSID_D2D1Histogram: Guid = Guid('{881db7d0-f7ee-4d4d-a6d2-4697acc66ee8}')
CLSID_D2D1HueRotation: Guid = Guid('{0f4458ec-4b32-491b-9e85-bd73f44d3eb6}')
CLSID_D2D1LinearTransfer: Guid = Guid('{ad47c8fd-63ef-4acc-9b51-67979c036c06}')
CLSID_D2D1LuminanceToAlpha: Guid = Guid('{41251ab7-0beb-46f8-9da7-59e93fcce5de}')
CLSID_D2D1Morphology: Guid = Guid('{eae6c40d-626a-4c2d-bfcb-391001abe202}')
CLSID_D2D1OpacityMetadata: Guid = Guid('{6c53006a-4450-4199-aa5b-ad1656fece5e}')
CLSID_D2D1PointDiffuse: Guid = Guid('{b9e303c3-c08c-4f91-8b7b-38656bc48c20}')
CLSID_D2D1PointSpecular: Guid = Guid('{09c3ca26-3ae2-4f09-9ebc-ed3865d53f22}')
CLSID_D2D1Premultiply: Guid = Guid('{06eab419-deed-4018-80d2-3e1d471adeb2}')
CLSID_D2D1Saturation: Guid = Guid('{5cb2d9cf-327d-459f-a0ce-40c0b2086bf7}')
CLSID_D2D1Shadow: Guid = Guid('{c67ea361-1863-4e69-89db-695d3e9a5b6b}')
CLSID_D2D1SpotDiffuse: Guid = Guid('{818a1105-7932-44f4-aa86-08ae7b2f2c93}')
CLSID_D2D1SpotSpecular: Guid = Guid('{edae421e-7654-4a37-9db8-71acc1beb3c1}')
CLSID_D2D1TableTransfer: Guid = Guid('{5bf818c3-5e43-48cb-b631-868396d6a1d4}')
CLSID_D2D1Tile: Guid = Guid('{b0784138-3b76-4bc5-b13b-0fa2ad02659f}')
CLSID_D2D1Turbulence: Guid = Guid('{cf2bb6ae-889a-4ad7-ba29-a2fd732c9fc9}')
CLSID_D2D1UnPremultiply: Guid = Guid('{fb9ac489-ad8d-41ed-9999-bb6347d110f7}')
CLSID_D2D1YCbCr: Guid = Guid('{99503cc1-66c7-45c9-a875-8ad8a7914401}')
CLSID_D2D1Contrast: Guid = Guid('{b648a78a-0ed5-4f80-a94a-8e825aca6b77}')
CLSID_D2D1RgbToHue: Guid = Guid('{23f3e5ec-91e8-4d3d-ad0a-afadc1004aa1}')
CLSID_D2D1HueToRgb: Guid = Guid('{7b78a6bd-0141-4def-8a52-6356ee0cbdd5}')
CLSID_D2D1ChromaKey: Guid = Guid('{74c01f5b-2a0d-408c-88e2-c7a3c7197742}')
CLSID_D2D1Emboss: Guid = Guid('{b1c5eb2b-0348-43f0-8107-4957cacba2ae}')
CLSID_D2D1Exposure: Guid = Guid('{b56c8cfa-f634-41ee-bee0-ffa617106004}')
CLSID_D2D1Grayscale: Guid = Guid('{36dde0eb-3725-42e0-836d-52fb20aee644}')
CLSID_D2D1Invert: Guid = Guid('{e0c3784d-cb39-4e84-b6fd-6b72f0810263}')
CLSID_D2D1Posterize: Guid = Guid('{2188945e-33a3-4366-b7bc-086bd02d0884}')
CLSID_D2D1Sepia: Guid = Guid('{3a1af410-5f1d-4dbe-84df-915da79b7153}')
CLSID_D2D1Sharpen: Guid = Guid('{c9b887cb-c5ff-4dc5-9779-273dcf417c7d}')
CLSID_D2D1Straighten: Guid = Guid('{4da47b12-79a3-4fb0-8237-bbc3b2a4de08}')
CLSID_D2D1TemperatureTint: Guid = Guid('{89176087-8af9-4a08-aeb1-895f38db1766}')
CLSID_D2D1Vignette: Guid = Guid('{c00c40be-5e67-4ca3-95b4-f4b02c115135}')
CLSID_D2D1EdgeDetection: Guid = Guid('{eff583ca-cb07-4aa9-ac5d-2cc44c76460f}')
CLSID_D2D1HighlightsShadows: Guid = Guid('{cadc8384-323f-4c7e-a361-2e2b24df6ee4}')
CLSID_D2D1LookupTable3D: Guid = Guid('{349e0eda-0088-4a79-9ca3-c7e300202020}')
CLSID_D2D1Opacity: Guid = Guid('{811d79a4-de28-4454-8094-c64685f8bd4c}')
CLSID_D2D1AlphaMask: Guid = Guid('{c80ecff0-3fd5-4f05-8328-c5d1724b4f0a}')
CLSID_D2D1CrossFade: Guid = Guid('{12f575e8-4db1-485f-9a84-03a07dd3829f}')
CLSID_D2D1Tint: Guid = Guid('{36312b17-f7dd-4014-915d-ffca768cf211}')
D2D1_SCENE_REFERRED_SDR_WHITE_LEVEL: Single = 80
CLSID_D2D1WhiteLevelAdjustment: Guid = Guid('{44a1cadb-6cdd-4818-8ff4-26c1cfe95bdb}')
CLSID_D2D1HdrToneMap: Guid = Guid('{7b0b748d-4610-4486-a90c-999d9a2e2b11}')
D2D1_APPEND_ALIGNED_ELEMENT: UInt32 = 4294967295
FACILITY_D2D: UInt32 = 2201
@winfunctype('d2d1.dll')
def D2D1CreateFactory(factoryType: win32more.Windows.Win32.Graphics.Direct2D.D2D1_FACTORY_TYPE, riid: POINTER(Guid), pFactoryOptions: POINTER(win32more.Windows.Win32.Graphics.Direct2D.D2D1_FACTORY_OPTIONS), ppIFactory: POINTER(VoidPtr)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
@winfunctype('d2d1.dll')
def D2D1MakeRotateMatrix(angle: Single, center: win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_POINT_2F, matrix: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_MATRIX_3X2_F)) -> Void: ...
@winfunctype('d2d1.dll')
def D2D1MakeSkewMatrix(angleX: Single, angleY: Single, center: win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_POINT_2F, matrix: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_MATRIX_3X2_F)) -> Void: ...
@winfunctype('d2d1.dll')
def D2D1IsMatrixInvertible(matrix: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_MATRIX_3X2_F)) -> win32more.Windows.Win32.Foundation.BOOL: ...
@winfunctype('d2d1.dll')
def D2D1InvertMatrix(matrix: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_MATRIX_3X2_F)) -> win32more.Windows.Win32.Foundation.BOOL: ...
@winfunctype('d2d1.dll')
def D2D1CreateDevice(dxgiDevice: win32more.Windows.Win32.Graphics.Dxgi.IDXGIDevice, creationProperties: POINTER(win32more.Windows.Win32.Graphics.Direct2D.D2D1_CREATION_PROPERTIES), d2dDevice: POINTER(win32more.Windows.Win32.Graphics.Direct2D.ID2D1Device)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
@winfunctype('d2d1.dll')
def D2D1CreateDeviceContext(dxgiSurface: win32more.Windows.Win32.Graphics.Dxgi.IDXGISurface, creationProperties: POINTER(win32more.Windows.Win32.Graphics.Direct2D.D2D1_CREATION_PROPERTIES), d2dDeviceContext: POINTER(win32more.Windows.Win32.Graphics.Direct2D.ID2D1DeviceContext)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
@winfunctype('d2d1.dll')
def D2D1ConvertColorSpace(sourceColorSpace: win32more.Windows.Win32.Graphics.Direct2D.D2D1_COLOR_SPACE, destinationColorSpace: win32more.Windows.Win32.Graphics.Direct2D.D2D1_COLOR_SPACE, color: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D1_COLOR_F)) -> win32more.Windows.Win32.Graphics.Direct2D.Common.D2D1_COLOR_F: ...
@winfunctype('d2d1.dll')
def D2D1SinCos(angle: Single, s: POINTER(Single), c: POINTER(Single)) -> Void: ...
@winfunctype('d2d1.dll')
def D2D1Tan(angle: Single) -> Single: ...
@winfunctype('d2d1.dll')
def D2D1Vec3Length(x: Single, y: Single, z: Single) -> Single: ...
@winfunctype('d2d1.dll')
def D2D1ComputeMaximumScaleFactor(matrix: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_MATRIX_3X2_F)) -> Single: ...
@winfunctype('d2d1.dll')
def D2D1GetGradientMeshInteriorPointsFromCoonsPatch(pPoint0: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_POINT_2F), pPoint1: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_POINT_2F), pPoint2: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_POINT_2F), pPoint3: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_POINT_2F), pPoint4: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_POINT_2F), pPoint5: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_POINT_2F), pPoint6: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_POINT_2F), pPoint7: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_POINT_2F), pPoint8: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_POINT_2F), pPoint9: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_POINT_2F), pPoint10: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_POINT_2F), pPoint11: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_POINT_2F), pTensorPoint11: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_POINT_2F), pTensorPoint12: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_POINT_2F), pTensorPoint21: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_POINT_2F), pTensorPoint22: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_POINT_2F)) -> Void: ...
D2D1_2DAFFINETRANSFORM_PROP = Int32
D2D1_2DAFFINETRANSFORM_PROP_INTERPOLATION_MODE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_2DAFFINETRANSFORM_PROP = 0
D2D1_2DAFFINETRANSFORM_PROP_BORDER_MODE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_2DAFFINETRANSFORM_PROP = 1
D2D1_2DAFFINETRANSFORM_PROP_TRANSFORM_MATRIX: win32more.Windows.Win32.Graphics.Direct2D.D2D1_2DAFFINETRANSFORM_PROP = 2
D2D1_2DAFFINETRANSFORM_PROP_SHARPNESS: win32more.Windows.Win32.Graphics.Direct2D.D2D1_2DAFFINETRANSFORM_PROP = 3
D2D1_3DPERSPECTIVETRANSFORM_INTERPOLATION_MODE = Int32
D2D1_3DPERSPECTIVETRANSFORM_INTERPOLATION_MODE_NEAREST_NEIGHBOR: win32more.Windows.Win32.Graphics.Direct2D.D2D1_3DPERSPECTIVETRANSFORM_INTERPOLATION_MODE = 0
D2D1_3DPERSPECTIVETRANSFORM_INTERPOLATION_MODE_LINEAR: win32more.Windows.Win32.Graphics.Direct2D.D2D1_3DPERSPECTIVETRANSFORM_INTERPOLATION_MODE = 1
D2D1_3DPERSPECTIVETRANSFORM_INTERPOLATION_MODE_CUBIC: win32more.Windows.Win32.Graphics.Direct2D.D2D1_3DPERSPECTIVETRANSFORM_INTERPOLATION_MODE = 2
D2D1_3DPERSPECTIVETRANSFORM_INTERPOLATION_MODE_MULTI_SAMPLE_LINEAR: win32more.Windows.Win32.Graphics.Direct2D.D2D1_3DPERSPECTIVETRANSFORM_INTERPOLATION_MODE = 3
D2D1_3DPERSPECTIVETRANSFORM_INTERPOLATION_MODE_ANISOTROPIC: win32more.Windows.Win32.Graphics.Direct2D.D2D1_3DPERSPECTIVETRANSFORM_INTERPOLATION_MODE = 4
D2D1_3DPERSPECTIVETRANSFORM_PROP = Int32
D2D1_3DPERSPECTIVETRANSFORM_PROP_INTERPOLATION_MODE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_3DPERSPECTIVETRANSFORM_PROP = 0
D2D1_3DPERSPECTIVETRANSFORM_PROP_BORDER_MODE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_3DPERSPECTIVETRANSFORM_PROP = 1
D2D1_3DPERSPECTIVETRANSFORM_PROP_DEPTH: win32more.Windows.Win32.Graphics.Direct2D.D2D1_3DPERSPECTIVETRANSFORM_PROP = 2
D2D1_3DPERSPECTIVETRANSFORM_PROP_PERSPECTIVE_ORIGIN: win32more.Windows.Win32.Graphics.Direct2D.D2D1_3DPERSPECTIVETRANSFORM_PROP = 3
D2D1_3DPERSPECTIVETRANSFORM_PROP_LOCAL_OFFSET: win32more.Windows.Win32.Graphics.Direct2D.D2D1_3DPERSPECTIVETRANSFORM_PROP = 4
D2D1_3DPERSPECTIVETRANSFORM_PROP_GLOBAL_OFFSET: win32more.Windows.Win32.Graphics.Direct2D.D2D1_3DPERSPECTIVETRANSFORM_PROP = 5
D2D1_3DPERSPECTIVETRANSFORM_PROP_ROTATION_ORIGIN: win32more.Windows.Win32.Graphics.Direct2D.D2D1_3DPERSPECTIVETRANSFORM_PROP = 6
D2D1_3DPERSPECTIVETRANSFORM_PROP_ROTATION: win32more.Windows.Win32.Graphics.Direct2D.D2D1_3DPERSPECTIVETRANSFORM_PROP = 7
D2D1_3DTRANSFORM_INTERPOLATION_MODE = Int32
D2D1_3DTRANSFORM_INTERPOLATION_MODE_NEAREST_NEIGHBOR: win32more.Windows.Win32.Graphics.Direct2D.D2D1_3DTRANSFORM_INTERPOLATION_MODE = 0
D2D1_3DTRANSFORM_INTERPOLATION_MODE_LINEAR: win32more.Windows.Win32.Graphics.Direct2D.D2D1_3DTRANSFORM_INTERPOLATION_MODE = 1
D2D1_3DTRANSFORM_INTERPOLATION_MODE_CUBIC: win32more.Windows.Win32.Graphics.Direct2D.D2D1_3DTRANSFORM_INTERPOLATION_MODE = 2
D2D1_3DTRANSFORM_INTERPOLATION_MODE_MULTI_SAMPLE_LINEAR: win32more.Windows.Win32.Graphics.Direct2D.D2D1_3DTRANSFORM_INTERPOLATION_MODE = 3
D2D1_3DTRANSFORM_INTERPOLATION_MODE_ANISOTROPIC: win32more.Windows.Win32.Graphics.Direct2D.D2D1_3DTRANSFORM_INTERPOLATION_MODE = 4
D2D1_3DTRANSFORM_PROP = Int32
D2D1_3DTRANSFORM_PROP_INTERPOLATION_MODE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_3DTRANSFORM_PROP = 0
D2D1_3DTRANSFORM_PROP_BORDER_MODE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_3DTRANSFORM_PROP = 1
D2D1_3DTRANSFORM_PROP_TRANSFORM_MATRIX: win32more.Windows.Win32.Graphics.Direct2D.D2D1_3DTRANSFORM_PROP = 2
D2D1_ANTIALIAS_MODE = Int32
D2D1_ANTIALIAS_MODE_PER_PRIMITIVE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_ANTIALIAS_MODE = 0
D2D1_ANTIALIAS_MODE_ALIASED: win32more.Windows.Win32.Graphics.Direct2D.D2D1_ANTIALIAS_MODE = 1
class D2D1_ARC_SEGMENT(Structure):
    point: win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_POINT_2F
    size: win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_SIZE_F
    rotationAngle: Single
    sweepDirection: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SWEEP_DIRECTION
    arcSize: win32more.Windows.Win32.Graphics.Direct2D.D2D1_ARC_SIZE
D2D1_ARC_SIZE = Int32
D2D1_ARC_SIZE_SMALL: win32more.Windows.Win32.Graphics.Direct2D.D2D1_ARC_SIZE = 0
D2D1_ARC_SIZE_LARGE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_ARC_SIZE = 1
D2D1_ARITHMETICCOMPOSITE_PROP = Int32
D2D1_ARITHMETICCOMPOSITE_PROP_COEFFICIENTS: win32more.Windows.Win32.Graphics.Direct2D.D2D1_ARITHMETICCOMPOSITE_PROP = 0
D2D1_ARITHMETICCOMPOSITE_PROP_CLAMP_OUTPUT: win32more.Windows.Win32.Graphics.Direct2D.D2D1_ARITHMETICCOMPOSITE_PROP = 1
D2D1_ATLAS_PROP = Int32
D2D1_ATLAS_PROP_INPUT_RECT: win32more.Windows.Win32.Graphics.Direct2D.D2D1_ATLAS_PROP = 0
D2D1_ATLAS_PROP_INPUT_PADDING_RECT: win32more.Windows.Win32.Graphics.Direct2D.D2D1_ATLAS_PROP = 1
D2D1_BITMAPSOURCE_ALPHA_MODE = Int32
D2D1_BITMAPSOURCE_ALPHA_MODE_PREMULTIPLIED: win32more.Windows.Win32.Graphics.Direct2D.D2D1_BITMAPSOURCE_ALPHA_MODE = 1
D2D1_BITMAPSOURCE_ALPHA_MODE_STRAIGHT: win32more.Windows.Win32.Graphics.Direct2D.D2D1_BITMAPSOURCE_ALPHA_MODE = 2
D2D1_BITMAPSOURCE_INTERPOLATION_MODE = Int32
D2D1_BITMAPSOURCE_INTERPOLATION_MODE_NEAREST_NEIGHBOR: win32more.Windows.Win32.Graphics.Direct2D.D2D1_BITMAPSOURCE_INTERPOLATION_MODE = 0
D2D1_BITMAPSOURCE_INTERPOLATION_MODE_LINEAR: win32more.Windows.Win32.Graphics.Direct2D.D2D1_BITMAPSOURCE_INTERPOLATION_MODE = 1
D2D1_BITMAPSOURCE_INTERPOLATION_MODE_CUBIC: win32more.Windows.Win32.Graphics.Direct2D.D2D1_BITMAPSOURCE_INTERPOLATION_MODE = 2
D2D1_BITMAPSOURCE_INTERPOLATION_MODE_FANT: win32more.Windows.Win32.Graphics.Direct2D.D2D1_BITMAPSOURCE_INTERPOLATION_MODE = 6
D2D1_BITMAPSOURCE_INTERPOLATION_MODE_MIPMAP_LINEAR: win32more.Windows.Win32.Graphics.Direct2D.D2D1_BITMAPSOURCE_INTERPOLATION_MODE = 7
D2D1_BITMAPSOURCE_ORIENTATION = Int32
D2D1_BITMAPSOURCE_ORIENTATION_DEFAULT: win32more.Windows.Win32.Graphics.Direct2D.D2D1_BITMAPSOURCE_ORIENTATION = 1
D2D1_BITMAPSOURCE_ORIENTATION_FLIP_HORIZONTAL: win32more.Windows.Win32.Graphics.Direct2D.D2D1_BITMAPSOURCE_ORIENTATION = 2
D2D1_BITMAPSOURCE_ORIENTATION_ROTATE_CLOCKWISE180: win32more.Windows.Win32.Graphics.Direct2D.D2D1_BITMAPSOURCE_ORIENTATION = 3
D2D1_BITMAPSOURCE_ORIENTATION_ROTATE_CLOCKWISE180_FLIP_HORIZONTAL: win32more.Windows.Win32.Graphics.Direct2D.D2D1_BITMAPSOURCE_ORIENTATION = 4
D2D1_BITMAPSOURCE_ORIENTATION_ROTATE_CLOCKWISE270_FLIP_HORIZONTAL: win32more.Windows.Win32.Graphics.Direct2D.D2D1_BITMAPSOURCE_ORIENTATION = 5
D2D1_BITMAPSOURCE_ORIENTATION_ROTATE_CLOCKWISE90: win32more.Windows.Win32.Graphics.Direct2D.D2D1_BITMAPSOURCE_ORIENTATION = 6
D2D1_BITMAPSOURCE_ORIENTATION_ROTATE_CLOCKWISE90_FLIP_HORIZONTAL: win32more.Windows.Win32.Graphics.Direct2D.D2D1_BITMAPSOURCE_ORIENTATION = 7
D2D1_BITMAPSOURCE_ORIENTATION_ROTATE_CLOCKWISE270: win32more.Windows.Win32.Graphics.Direct2D.D2D1_BITMAPSOURCE_ORIENTATION = 8
D2D1_BITMAPSOURCE_PROP = Int32
D2D1_BITMAPSOURCE_PROP_WIC_BITMAP_SOURCE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_BITMAPSOURCE_PROP = 0
D2D1_BITMAPSOURCE_PROP_SCALE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_BITMAPSOURCE_PROP = 1
D2D1_BITMAPSOURCE_PROP_INTERPOLATION_MODE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_BITMAPSOURCE_PROP = 2
D2D1_BITMAPSOURCE_PROP_ENABLE_DPI_CORRECTION: win32more.Windows.Win32.Graphics.Direct2D.D2D1_BITMAPSOURCE_PROP = 3
D2D1_BITMAPSOURCE_PROP_ALPHA_MODE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_BITMAPSOURCE_PROP = 4
D2D1_BITMAPSOURCE_PROP_ORIENTATION: win32more.Windows.Win32.Graphics.Direct2D.D2D1_BITMAPSOURCE_PROP = 5
class D2D1_BITMAP_BRUSH_PROPERTIES(Structure):
    extendModeX: win32more.Windows.Win32.Graphics.Direct2D.D2D1_EXTEND_MODE
    extendModeY: win32more.Windows.Win32.Graphics.Direct2D.D2D1_EXTEND_MODE
    interpolationMode: win32more.Windows.Win32.Graphics.Direct2D.D2D1_BITMAP_INTERPOLATION_MODE
class D2D1_BITMAP_BRUSH_PROPERTIES1(Structure):
    extendModeX: win32more.Windows.Win32.Graphics.Direct2D.D2D1_EXTEND_MODE
    extendModeY: win32more.Windows.Win32.Graphics.Direct2D.D2D1_EXTEND_MODE
    interpolationMode: win32more.Windows.Win32.Graphics.Direct2D.D2D1_INTERPOLATION_MODE
D2D1_BITMAP_INTERPOLATION_MODE = Int32
D2D1_BITMAP_INTERPOLATION_MODE_NEAREST_NEIGHBOR: win32more.Windows.Win32.Graphics.Direct2D.D2D1_BITMAP_INTERPOLATION_MODE = 0
D2D1_BITMAP_INTERPOLATION_MODE_LINEAR: win32more.Windows.Win32.Graphics.Direct2D.D2D1_BITMAP_INTERPOLATION_MODE = 1
D2D1_BITMAP_OPTIONS = Int32
D2D1_BITMAP_OPTIONS_NONE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_BITMAP_OPTIONS = 0
D2D1_BITMAP_OPTIONS_TARGET: win32more.Windows.Win32.Graphics.Direct2D.D2D1_BITMAP_OPTIONS = 1
D2D1_BITMAP_OPTIONS_CANNOT_DRAW: win32more.Windows.Win32.Graphics.Direct2D.D2D1_BITMAP_OPTIONS = 2
D2D1_BITMAP_OPTIONS_CPU_READ: win32more.Windows.Win32.Graphics.Direct2D.D2D1_BITMAP_OPTIONS = 4
D2D1_BITMAP_OPTIONS_GDI_COMPATIBLE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_BITMAP_OPTIONS = 8
class D2D1_BITMAP_PROPERTIES(Structure):
    pixelFormat: win32more.Windows.Win32.Graphics.Direct2D.Common.D2D1_PIXEL_FORMAT
    dpiX: Single
    dpiY: Single
class D2D1_BITMAP_PROPERTIES1(Structure):
    pixelFormat: win32more.Windows.Win32.Graphics.Direct2D.Common.D2D1_PIXEL_FORMAT
    dpiX: Single
    dpiY: Single
    bitmapOptions: win32more.Windows.Win32.Graphics.Direct2D.D2D1_BITMAP_OPTIONS
    colorContext: win32more.Windows.Win32.Graphics.Direct2D.ID2D1ColorContext
D2D1_BLEND = Int32
D2D1_BLEND_ZERO: win32more.Windows.Win32.Graphics.Direct2D.D2D1_BLEND = 1
D2D1_BLEND_ONE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_BLEND = 2
D2D1_BLEND_SRC_COLOR: win32more.Windows.Win32.Graphics.Direct2D.D2D1_BLEND = 3
D2D1_BLEND_INV_SRC_COLOR: win32more.Windows.Win32.Graphics.Direct2D.D2D1_BLEND = 4
D2D1_BLEND_SRC_ALPHA: win32more.Windows.Win32.Graphics.Direct2D.D2D1_BLEND = 5
D2D1_BLEND_INV_SRC_ALPHA: win32more.Windows.Win32.Graphics.Direct2D.D2D1_BLEND = 6
D2D1_BLEND_DEST_ALPHA: win32more.Windows.Win32.Graphics.Direct2D.D2D1_BLEND = 7
D2D1_BLEND_INV_DEST_ALPHA: win32more.Windows.Win32.Graphics.Direct2D.D2D1_BLEND = 8
D2D1_BLEND_DEST_COLOR: win32more.Windows.Win32.Graphics.Direct2D.D2D1_BLEND = 9
D2D1_BLEND_INV_DEST_COLOR: win32more.Windows.Win32.Graphics.Direct2D.D2D1_BLEND = 10
D2D1_BLEND_SRC_ALPHA_SAT: win32more.Windows.Win32.Graphics.Direct2D.D2D1_BLEND = 11
D2D1_BLEND_BLEND_FACTOR: win32more.Windows.Win32.Graphics.Direct2D.D2D1_BLEND = 14
D2D1_BLEND_INV_BLEND_FACTOR: win32more.Windows.Win32.Graphics.Direct2D.D2D1_BLEND = 15
class D2D1_BLEND_DESCRIPTION(Structure):
    sourceBlend: win32more.Windows.Win32.Graphics.Direct2D.D2D1_BLEND
    destinationBlend: win32more.Windows.Win32.Graphics.Direct2D.D2D1_BLEND
    blendOperation: win32more.Windows.Win32.Graphics.Direct2D.D2D1_BLEND_OPERATION
    sourceBlendAlpha: win32more.Windows.Win32.Graphics.Direct2D.D2D1_BLEND
    destinationBlendAlpha: win32more.Windows.Win32.Graphics.Direct2D.D2D1_BLEND
    blendOperationAlpha: win32more.Windows.Win32.Graphics.Direct2D.D2D1_BLEND_OPERATION
    blendFactor: Single * 4
D2D1_BLEND_OPERATION = Int32
D2D1_BLEND_OPERATION_ADD: win32more.Windows.Win32.Graphics.Direct2D.D2D1_BLEND_OPERATION = 1
D2D1_BLEND_OPERATION_SUBTRACT: win32more.Windows.Win32.Graphics.Direct2D.D2D1_BLEND_OPERATION = 2
D2D1_BLEND_OPERATION_REV_SUBTRACT: win32more.Windows.Win32.Graphics.Direct2D.D2D1_BLEND_OPERATION = 3
D2D1_BLEND_OPERATION_MIN: win32more.Windows.Win32.Graphics.Direct2D.D2D1_BLEND_OPERATION = 4
D2D1_BLEND_OPERATION_MAX: win32more.Windows.Win32.Graphics.Direct2D.D2D1_BLEND_OPERATION = 5
D2D1_BLEND_PROP = Int32
D2D1_BLEND_PROP_MODE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_BLEND_PROP = 0
D2D1_BORDER_EDGE_MODE = Int32
D2D1_BORDER_EDGE_MODE_CLAMP: win32more.Windows.Win32.Graphics.Direct2D.D2D1_BORDER_EDGE_MODE = 0
D2D1_BORDER_EDGE_MODE_WRAP: win32more.Windows.Win32.Graphics.Direct2D.D2D1_BORDER_EDGE_MODE = 1
D2D1_BORDER_EDGE_MODE_MIRROR: win32more.Windows.Win32.Graphics.Direct2D.D2D1_BORDER_EDGE_MODE = 2
D2D1_BORDER_PROP = Int32
D2D1_BORDER_PROP_EDGE_MODE_X: win32more.Windows.Win32.Graphics.Direct2D.D2D1_BORDER_PROP = 0
D2D1_BORDER_PROP_EDGE_MODE_Y: win32more.Windows.Win32.Graphics.Direct2D.D2D1_BORDER_PROP = 1
D2D1_BRIGHTNESS_PROP = Int32
D2D1_BRIGHTNESS_PROP_WHITE_POINT: win32more.Windows.Win32.Graphics.Direct2D.D2D1_BRIGHTNESS_PROP = 0
D2D1_BRIGHTNESS_PROP_BLACK_POINT: win32more.Windows.Win32.Graphics.Direct2D.D2D1_BRIGHTNESS_PROP = 1
class D2D1_BRUSH_PROPERTIES(Structure):
    opacity: Single
    transform: win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_MATRIX_3X2_F
D2D1_BUFFER_PRECISION = Int32
D2D1_BUFFER_PRECISION_UNKNOWN: win32more.Windows.Win32.Graphics.Direct2D.D2D1_BUFFER_PRECISION = 0
D2D1_BUFFER_PRECISION_8BPC_UNORM: win32more.Windows.Win32.Graphics.Direct2D.D2D1_BUFFER_PRECISION = 1
D2D1_BUFFER_PRECISION_8BPC_UNORM_SRGB: win32more.Windows.Win32.Graphics.Direct2D.D2D1_BUFFER_PRECISION = 2
D2D1_BUFFER_PRECISION_16BPC_UNORM: win32more.Windows.Win32.Graphics.Direct2D.D2D1_BUFFER_PRECISION = 3
D2D1_BUFFER_PRECISION_16BPC_FLOAT: win32more.Windows.Win32.Graphics.Direct2D.D2D1_BUFFER_PRECISION = 4
D2D1_BUFFER_PRECISION_32BPC_FLOAT: win32more.Windows.Win32.Graphics.Direct2D.D2D1_BUFFER_PRECISION = 5
D2D1_CAP_STYLE = Int32
D2D1_CAP_STYLE_FLAT: win32more.Windows.Win32.Graphics.Direct2D.D2D1_CAP_STYLE = 0
D2D1_CAP_STYLE_SQUARE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_CAP_STYLE = 1
D2D1_CAP_STYLE_ROUND: win32more.Windows.Win32.Graphics.Direct2D.D2D1_CAP_STYLE = 2
D2D1_CAP_STYLE_TRIANGLE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_CAP_STYLE = 3
D2D1_CHANGE_TYPE = Int32
D2D1_CHANGE_TYPE_NONE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_CHANGE_TYPE = 0
D2D1_CHANGE_TYPE_PROPERTIES: win32more.Windows.Win32.Graphics.Direct2D.D2D1_CHANGE_TYPE = 1
D2D1_CHANGE_TYPE_CONTEXT: win32more.Windows.Win32.Graphics.Direct2D.D2D1_CHANGE_TYPE = 2
D2D1_CHANGE_TYPE_GRAPH: win32more.Windows.Win32.Graphics.Direct2D.D2D1_CHANGE_TYPE = 3
D2D1_CHANNEL_DEPTH = Int32
D2D1_CHANNEL_DEPTH_DEFAULT: win32more.Windows.Win32.Graphics.Direct2D.D2D1_CHANNEL_DEPTH = 0
D2D1_CHANNEL_DEPTH_1: win32more.Windows.Win32.Graphics.Direct2D.D2D1_CHANNEL_DEPTH = 1
D2D1_CHANNEL_DEPTH_4: win32more.Windows.Win32.Graphics.Direct2D.D2D1_CHANNEL_DEPTH = 4
D2D1_CHANNEL_SELECTOR = Int32
D2D1_CHANNEL_SELECTOR_R: win32more.Windows.Win32.Graphics.Direct2D.D2D1_CHANNEL_SELECTOR = 0
D2D1_CHANNEL_SELECTOR_G: win32more.Windows.Win32.Graphics.Direct2D.D2D1_CHANNEL_SELECTOR = 1
D2D1_CHANNEL_SELECTOR_B: win32more.Windows.Win32.Graphics.Direct2D.D2D1_CHANNEL_SELECTOR = 2
D2D1_CHANNEL_SELECTOR_A: win32more.Windows.Win32.Graphics.Direct2D.D2D1_CHANNEL_SELECTOR = 3
D2D1_CHROMAKEY_PROP = Int32
D2D1_CHROMAKEY_PROP_COLOR: win32more.Windows.Win32.Graphics.Direct2D.D2D1_CHROMAKEY_PROP = 0
D2D1_CHROMAKEY_PROP_TOLERANCE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_CHROMAKEY_PROP = 1
D2D1_CHROMAKEY_PROP_INVERT_ALPHA: win32more.Windows.Win32.Graphics.Direct2D.D2D1_CHROMAKEY_PROP = 2
D2D1_CHROMAKEY_PROP_FEATHER: win32more.Windows.Win32.Graphics.Direct2D.D2D1_CHROMAKEY_PROP = 3
D2D1_COLORMANAGEMENT_ALPHA_MODE = Int32
D2D1_COLORMANAGEMENT_ALPHA_MODE_PREMULTIPLIED: win32more.Windows.Win32.Graphics.Direct2D.D2D1_COLORMANAGEMENT_ALPHA_MODE = 1
D2D1_COLORMANAGEMENT_ALPHA_MODE_STRAIGHT: win32more.Windows.Win32.Graphics.Direct2D.D2D1_COLORMANAGEMENT_ALPHA_MODE = 2
D2D1_COLORMANAGEMENT_PROP = Int32
D2D1_COLORMANAGEMENT_PROP_SOURCE_COLOR_CONTEXT: win32more.Windows.Win32.Graphics.Direct2D.D2D1_COLORMANAGEMENT_PROP = 0
D2D1_COLORMANAGEMENT_PROP_SOURCE_RENDERING_INTENT: win32more.Windows.Win32.Graphics.Direct2D.D2D1_COLORMANAGEMENT_PROP = 1
D2D1_COLORMANAGEMENT_PROP_DESTINATION_COLOR_CONTEXT: win32more.Windows.Win32.Graphics.Direct2D.D2D1_COLORMANAGEMENT_PROP = 2
D2D1_COLORMANAGEMENT_PROP_DESTINATION_RENDERING_INTENT: win32more.Windows.Win32.Graphics.Direct2D.D2D1_COLORMANAGEMENT_PROP = 3
D2D1_COLORMANAGEMENT_PROP_ALPHA_MODE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_COLORMANAGEMENT_PROP = 4
D2D1_COLORMANAGEMENT_PROP_QUALITY: win32more.Windows.Win32.Graphics.Direct2D.D2D1_COLORMANAGEMENT_PROP = 5
D2D1_COLORMANAGEMENT_QUALITY = Int32
D2D1_COLORMANAGEMENT_QUALITY_PROOF: win32more.Windows.Win32.Graphics.Direct2D.D2D1_COLORMANAGEMENT_QUALITY = 0
D2D1_COLORMANAGEMENT_QUALITY_NORMAL: win32more.Windows.Win32.Graphics.Direct2D.D2D1_COLORMANAGEMENT_QUALITY = 1
D2D1_COLORMANAGEMENT_QUALITY_BEST: win32more.Windows.Win32.Graphics.Direct2D.D2D1_COLORMANAGEMENT_QUALITY = 2
D2D1_COLORMANAGEMENT_RENDERING_INTENT = Int32
D2D1_COLORMANAGEMENT_RENDERING_INTENT_PERCEPTUAL: win32more.Windows.Win32.Graphics.Direct2D.D2D1_COLORMANAGEMENT_RENDERING_INTENT = 0
D2D1_COLORMANAGEMENT_RENDERING_INTENT_RELATIVE_COLORIMETRIC: win32more.Windows.Win32.Graphics.Direct2D.D2D1_COLORMANAGEMENT_RENDERING_INTENT = 1
D2D1_COLORMANAGEMENT_RENDERING_INTENT_SATURATION: win32more.Windows.Win32.Graphics.Direct2D.D2D1_COLORMANAGEMENT_RENDERING_INTENT = 2
D2D1_COLORMANAGEMENT_RENDERING_INTENT_ABSOLUTE_COLORIMETRIC: win32more.Windows.Win32.Graphics.Direct2D.D2D1_COLORMANAGEMENT_RENDERING_INTENT = 3
D2D1_COLORMATRIX_PROP = Int32
D2D1_COLORMATRIX_PROP_COLOR_MATRIX: win32more.Windows.Win32.Graphics.Direct2D.D2D1_COLORMATRIX_PROP = 0
D2D1_COLORMATRIX_PROP_ALPHA_MODE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_COLORMATRIX_PROP = 1
D2D1_COLORMATRIX_PROP_CLAMP_OUTPUT: win32more.Windows.Win32.Graphics.Direct2D.D2D1_COLORMATRIX_PROP = 2
D2D1_COLOR_BITMAP_GLYPH_SNAP_OPTION = Int32
D2D1_COLOR_BITMAP_GLYPH_SNAP_OPTION_DEFAULT: win32more.Windows.Win32.Graphics.Direct2D.D2D1_COLOR_BITMAP_GLYPH_SNAP_OPTION = 0
D2D1_COLOR_BITMAP_GLYPH_SNAP_OPTION_DISABLE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_COLOR_BITMAP_GLYPH_SNAP_OPTION = 1
D2D1_COLOR_CONTEXT_TYPE = Int32
D2D1_COLOR_CONTEXT_TYPE_ICC: win32more.Windows.Win32.Graphics.Direct2D.D2D1_COLOR_CONTEXT_TYPE = 0
D2D1_COLOR_CONTEXT_TYPE_SIMPLE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_COLOR_CONTEXT_TYPE = 1
D2D1_COLOR_CONTEXT_TYPE_DXGI: win32more.Windows.Win32.Graphics.Direct2D.D2D1_COLOR_CONTEXT_TYPE = 2
D2D1_COLOR_INTERPOLATION_MODE = Int32
D2D1_COLOR_INTERPOLATION_MODE_STRAIGHT: win32more.Windows.Win32.Graphics.Direct2D.D2D1_COLOR_INTERPOLATION_MODE = 0
D2D1_COLOR_INTERPOLATION_MODE_PREMULTIPLIED: win32more.Windows.Win32.Graphics.Direct2D.D2D1_COLOR_INTERPOLATION_MODE = 1
D2D1_COLOR_SPACE = Int32
D2D1_COLOR_SPACE_CUSTOM: win32more.Windows.Win32.Graphics.Direct2D.D2D1_COLOR_SPACE = 0
D2D1_COLOR_SPACE_SRGB: win32more.Windows.Win32.Graphics.Direct2D.D2D1_COLOR_SPACE = 1
D2D1_COLOR_SPACE_SCRGB: win32more.Windows.Win32.Graphics.Direct2D.D2D1_COLOR_SPACE = 2
D2D1_COMBINE_MODE = Int32
D2D1_COMBINE_MODE_UNION: win32more.Windows.Win32.Graphics.Direct2D.D2D1_COMBINE_MODE = 0
D2D1_COMBINE_MODE_INTERSECT: win32more.Windows.Win32.Graphics.Direct2D.D2D1_COMBINE_MODE = 1
D2D1_COMBINE_MODE_XOR: win32more.Windows.Win32.Graphics.Direct2D.D2D1_COMBINE_MODE = 2
D2D1_COMBINE_MODE_EXCLUDE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_COMBINE_MODE = 3
D2D1_COMPATIBLE_RENDER_TARGET_OPTIONS = Int32
D2D1_COMPATIBLE_RENDER_TARGET_OPTIONS_NONE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_COMPATIBLE_RENDER_TARGET_OPTIONS = 0
D2D1_COMPATIBLE_RENDER_TARGET_OPTIONS_GDI_COMPATIBLE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_COMPATIBLE_RENDER_TARGET_OPTIONS = 1
D2D1_COMPOSITE_PROP = Int32
D2D1_COMPOSITE_PROP_MODE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_COMPOSITE_PROP = 0
D2D1_CONTRAST_PROP = Int32
D2D1_CONTRAST_PROP_CONTRAST: win32more.Windows.Win32.Graphics.Direct2D.D2D1_CONTRAST_PROP = 0
D2D1_CONTRAST_PROP_CLAMP_INPUT: win32more.Windows.Win32.Graphics.Direct2D.D2D1_CONTRAST_PROP = 1
D2D1_CONVOLVEMATRIX_PROP = Int32
D2D1_CONVOLVEMATRIX_PROP_KERNEL_UNIT_LENGTH: win32more.Windows.Win32.Graphics.Direct2D.D2D1_CONVOLVEMATRIX_PROP = 0
D2D1_CONVOLVEMATRIX_PROP_SCALE_MODE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_CONVOLVEMATRIX_PROP = 1
D2D1_CONVOLVEMATRIX_PROP_KERNEL_SIZE_X: win32more.Windows.Win32.Graphics.Direct2D.D2D1_CONVOLVEMATRIX_PROP = 2
D2D1_CONVOLVEMATRIX_PROP_KERNEL_SIZE_Y: win32more.Windows.Win32.Graphics.Direct2D.D2D1_CONVOLVEMATRIX_PROP = 3
D2D1_CONVOLVEMATRIX_PROP_KERNEL_MATRIX: win32more.Windows.Win32.Graphics.Direct2D.D2D1_CONVOLVEMATRIX_PROP = 4
D2D1_CONVOLVEMATRIX_PROP_DIVISOR: win32more.Windows.Win32.Graphics.Direct2D.D2D1_CONVOLVEMATRIX_PROP = 5
D2D1_CONVOLVEMATRIX_PROP_BIAS: win32more.Windows.Win32.Graphics.Direct2D.D2D1_CONVOLVEMATRIX_PROP = 6
D2D1_CONVOLVEMATRIX_PROP_KERNEL_OFFSET: win32more.Windows.Win32.Graphics.Direct2D.D2D1_CONVOLVEMATRIX_PROP = 7
D2D1_CONVOLVEMATRIX_PROP_PRESERVE_ALPHA: win32more.Windows.Win32.Graphics.Direct2D.D2D1_CONVOLVEMATRIX_PROP = 8
D2D1_CONVOLVEMATRIX_PROP_BORDER_MODE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_CONVOLVEMATRIX_PROP = 9
D2D1_CONVOLVEMATRIX_PROP_CLAMP_OUTPUT: win32more.Windows.Win32.Graphics.Direct2D.D2D1_CONVOLVEMATRIX_PROP = 10
D2D1_CONVOLVEMATRIX_SCALE_MODE = Int32
D2D1_CONVOLVEMATRIX_SCALE_MODE_NEAREST_NEIGHBOR: win32more.Windows.Win32.Graphics.Direct2D.D2D1_CONVOLVEMATRIX_SCALE_MODE = 0
D2D1_CONVOLVEMATRIX_SCALE_MODE_LINEAR: win32more.Windows.Win32.Graphics.Direct2D.D2D1_CONVOLVEMATRIX_SCALE_MODE = 1
D2D1_CONVOLVEMATRIX_SCALE_MODE_CUBIC: win32more.Windows.Win32.Graphics.Direct2D.D2D1_CONVOLVEMATRIX_SCALE_MODE = 2
D2D1_CONVOLVEMATRIX_SCALE_MODE_MULTI_SAMPLE_LINEAR: win32more.Windows.Win32.Graphics.Direct2D.D2D1_CONVOLVEMATRIX_SCALE_MODE = 3
D2D1_CONVOLVEMATRIX_SCALE_MODE_ANISOTROPIC: win32more.Windows.Win32.Graphics.Direct2D.D2D1_CONVOLVEMATRIX_SCALE_MODE = 4
D2D1_CONVOLVEMATRIX_SCALE_MODE_HIGH_QUALITY_CUBIC: win32more.Windows.Win32.Graphics.Direct2D.D2D1_CONVOLVEMATRIX_SCALE_MODE = 5
class D2D1_CREATION_PROPERTIES(Structure):
    threadingMode: win32more.Windows.Win32.Graphics.Direct2D.D2D1_THREADING_MODE
    debugLevel: win32more.Windows.Win32.Graphics.Direct2D.D2D1_DEBUG_LEVEL
    options: win32more.Windows.Win32.Graphics.Direct2D.D2D1_DEVICE_CONTEXT_OPTIONS
D2D1_CROP_PROP = Int32
D2D1_CROP_PROP_RECT: win32more.Windows.Win32.Graphics.Direct2D.D2D1_CROP_PROP = 0
D2D1_CROP_PROP_BORDER_MODE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_CROP_PROP = 1
D2D1_CROSSFADE_PROP = Int32
D2D1_CROSSFADE_PROP_WEIGHT: win32more.Windows.Win32.Graphics.Direct2D.D2D1_CROSSFADE_PROP = 0
class D2D1_CUSTOM_VERTEX_BUFFER_PROPERTIES(Structure):
    shaderBufferWithInputSignature: POINTER(Byte)
    shaderBufferSize: UInt32
    inputElements: POINTER(win32more.Windows.Win32.Graphics.Direct2D.D2D1_INPUT_ELEMENT_DESC)
    elementCount: UInt32
    stride: UInt32
D2D1_DASH_STYLE = Int32
D2D1_DASH_STYLE_SOLID: win32more.Windows.Win32.Graphics.Direct2D.D2D1_DASH_STYLE = 0
D2D1_DASH_STYLE_DASH: win32more.Windows.Win32.Graphics.Direct2D.D2D1_DASH_STYLE = 1
D2D1_DASH_STYLE_DOT: win32more.Windows.Win32.Graphics.Direct2D.D2D1_DASH_STYLE = 2
D2D1_DASH_STYLE_DASH_DOT: win32more.Windows.Win32.Graphics.Direct2D.D2D1_DASH_STYLE = 3
D2D1_DASH_STYLE_DASH_DOT_DOT: win32more.Windows.Win32.Graphics.Direct2D.D2D1_DASH_STYLE = 4
D2D1_DASH_STYLE_CUSTOM: win32more.Windows.Win32.Graphics.Direct2D.D2D1_DASH_STYLE = 5
D2D1_DC_INITIALIZE_MODE = Int32
D2D1_DC_INITIALIZE_MODE_COPY: win32more.Windows.Win32.Graphics.Direct2D.D2D1_DC_INITIALIZE_MODE = 0
D2D1_DC_INITIALIZE_MODE_CLEAR: win32more.Windows.Win32.Graphics.Direct2D.D2D1_DC_INITIALIZE_MODE = 1
D2D1_DEBUG_LEVEL = Int32
D2D1_DEBUG_LEVEL_NONE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_DEBUG_LEVEL = 0
D2D1_DEBUG_LEVEL_ERROR: win32more.Windows.Win32.Graphics.Direct2D.D2D1_DEBUG_LEVEL = 1
D2D1_DEBUG_LEVEL_WARNING: win32more.Windows.Win32.Graphics.Direct2D.D2D1_DEBUG_LEVEL = 2
D2D1_DEBUG_LEVEL_INFORMATION: win32more.Windows.Win32.Graphics.Direct2D.D2D1_DEBUG_LEVEL = 3
D2D1_DEVICE_CONTEXT_OPTIONS = Int32
D2D1_DEVICE_CONTEXT_OPTIONS_NONE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_DEVICE_CONTEXT_OPTIONS = 0
D2D1_DEVICE_CONTEXT_OPTIONS_ENABLE_MULTITHREADED_OPTIMIZATIONS: win32more.Windows.Win32.Graphics.Direct2D.D2D1_DEVICE_CONTEXT_OPTIONS = 1
D2D1_DIRECTIONALBLUR_OPTIMIZATION = Int32
D2D1_DIRECTIONALBLUR_OPTIMIZATION_SPEED: win32more.Windows.Win32.Graphics.Direct2D.D2D1_DIRECTIONALBLUR_OPTIMIZATION = 0
D2D1_DIRECTIONALBLUR_OPTIMIZATION_BALANCED: win32more.Windows.Win32.Graphics.Direct2D.D2D1_DIRECTIONALBLUR_OPTIMIZATION = 1
D2D1_DIRECTIONALBLUR_OPTIMIZATION_QUALITY: win32more.Windows.Win32.Graphics.Direct2D.D2D1_DIRECTIONALBLUR_OPTIMIZATION = 2
D2D1_DIRECTIONALBLUR_PROP = Int32
D2D1_DIRECTIONALBLUR_PROP_STANDARD_DEVIATION: win32more.Windows.Win32.Graphics.Direct2D.D2D1_DIRECTIONALBLUR_PROP = 0
D2D1_DIRECTIONALBLUR_PROP_ANGLE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_DIRECTIONALBLUR_PROP = 1
D2D1_DIRECTIONALBLUR_PROP_OPTIMIZATION: win32more.Windows.Win32.Graphics.Direct2D.D2D1_DIRECTIONALBLUR_PROP = 2
D2D1_DIRECTIONALBLUR_PROP_BORDER_MODE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_DIRECTIONALBLUR_PROP = 3
D2D1_DISCRETETRANSFER_PROP = Int32
D2D1_DISCRETETRANSFER_PROP_RED_TABLE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_DISCRETETRANSFER_PROP = 0
D2D1_DISCRETETRANSFER_PROP_RED_DISABLE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_DISCRETETRANSFER_PROP = 1
D2D1_DISCRETETRANSFER_PROP_GREEN_TABLE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_DISCRETETRANSFER_PROP = 2
D2D1_DISCRETETRANSFER_PROP_GREEN_DISABLE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_DISCRETETRANSFER_PROP = 3
D2D1_DISCRETETRANSFER_PROP_BLUE_TABLE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_DISCRETETRANSFER_PROP = 4
D2D1_DISCRETETRANSFER_PROP_BLUE_DISABLE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_DISCRETETRANSFER_PROP = 5
D2D1_DISCRETETRANSFER_PROP_ALPHA_TABLE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_DISCRETETRANSFER_PROP = 6
D2D1_DISCRETETRANSFER_PROP_ALPHA_DISABLE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_DISCRETETRANSFER_PROP = 7
D2D1_DISCRETETRANSFER_PROP_CLAMP_OUTPUT: win32more.Windows.Win32.Graphics.Direct2D.D2D1_DISCRETETRANSFER_PROP = 8
D2D1_DISPLACEMENTMAP_PROP = Int32
D2D1_DISPLACEMENTMAP_PROP_SCALE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_DISPLACEMENTMAP_PROP = 0
D2D1_DISPLACEMENTMAP_PROP_X_CHANNEL_SELECT: win32more.Windows.Win32.Graphics.Direct2D.D2D1_DISPLACEMENTMAP_PROP = 1
D2D1_DISPLACEMENTMAP_PROP_Y_CHANNEL_SELECT: win32more.Windows.Win32.Graphics.Direct2D.D2D1_DISPLACEMENTMAP_PROP = 2
D2D1_DISTANTDIFFUSE_PROP = Int32
D2D1_DISTANTDIFFUSE_PROP_AZIMUTH: win32more.Windows.Win32.Graphics.Direct2D.D2D1_DISTANTDIFFUSE_PROP = 0
D2D1_DISTANTDIFFUSE_PROP_ELEVATION: win32more.Windows.Win32.Graphics.Direct2D.D2D1_DISTANTDIFFUSE_PROP = 1
D2D1_DISTANTDIFFUSE_PROP_DIFFUSE_CONSTANT: win32more.Windows.Win32.Graphics.Direct2D.D2D1_DISTANTDIFFUSE_PROP = 2
D2D1_DISTANTDIFFUSE_PROP_SURFACE_SCALE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_DISTANTDIFFUSE_PROP = 3
D2D1_DISTANTDIFFUSE_PROP_COLOR: win32more.Windows.Win32.Graphics.Direct2D.D2D1_DISTANTDIFFUSE_PROP = 4
D2D1_DISTANTDIFFUSE_PROP_KERNEL_UNIT_LENGTH: win32more.Windows.Win32.Graphics.Direct2D.D2D1_DISTANTDIFFUSE_PROP = 5
D2D1_DISTANTDIFFUSE_PROP_SCALE_MODE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_DISTANTDIFFUSE_PROP = 6
D2D1_DISTANTDIFFUSE_SCALE_MODE = Int32
D2D1_DISTANTDIFFUSE_SCALE_MODE_NEAREST_NEIGHBOR: win32more.Windows.Win32.Graphics.Direct2D.D2D1_DISTANTDIFFUSE_SCALE_MODE = 0
D2D1_DISTANTDIFFUSE_SCALE_MODE_LINEAR: win32more.Windows.Win32.Graphics.Direct2D.D2D1_DISTANTDIFFUSE_SCALE_MODE = 1
D2D1_DISTANTDIFFUSE_SCALE_MODE_CUBIC: win32more.Windows.Win32.Graphics.Direct2D.D2D1_DISTANTDIFFUSE_SCALE_MODE = 2
D2D1_DISTANTDIFFUSE_SCALE_MODE_MULTI_SAMPLE_LINEAR: win32more.Windows.Win32.Graphics.Direct2D.D2D1_DISTANTDIFFUSE_SCALE_MODE = 3
D2D1_DISTANTDIFFUSE_SCALE_MODE_ANISOTROPIC: win32more.Windows.Win32.Graphics.Direct2D.D2D1_DISTANTDIFFUSE_SCALE_MODE = 4
D2D1_DISTANTDIFFUSE_SCALE_MODE_HIGH_QUALITY_CUBIC: win32more.Windows.Win32.Graphics.Direct2D.D2D1_DISTANTDIFFUSE_SCALE_MODE = 5
D2D1_DISTANTSPECULAR_PROP = Int32
D2D1_DISTANTSPECULAR_PROP_AZIMUTH: win32more.Windows.Win32.Graphics.Direct2D.D2D1_DISTANTSPECULAR_PROP = 0
D2D1_DISTANTSPECULAR_PROP_ELEVATION: win32more.Windows.Win32.Graphics.Direct2D.D2D1_DISTANTSPECULAR_PROP = 1
D2D1_DISTANTSPECULAR_PROP_SPECULAR_EXPONENT: win32more.Windows.Win32.Graphics.Direct2D.D2D1_DISTANTSPECULAR_PROP = 2
D2D1_DISTANTSPECULAR_PROP_SPECULAR_CONSTANT: win32more.Windows.Win32.Graphics.Direct2D.D2D1_DISTANTSPECULAR_PROP = 3
D2D1_DISTANTSPECULAR_PROP_SURFACE_SCALE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_DISTANTSPECULAR_PROP = 4
D2D1_DISTANTSPECULAR_PROP_COLOR: win32more.Windows.Win32.Graphics.Direct2D.D2D1_DISTANTSPECULAR_PROP = 5
D2D1_DISTANTSPECULAR_PROP_KERNEL_UNIT_LENGTH: win32more.Windows.Win32.Graphics.Direct2D.D2D1_DISTANTSPECULAR_PROP = 6
D2D1_DISTANTSPECULAR_PROP_SCALE_MODE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_DISTANTSPECULAR_PROP = 7
D2D1_DISTANTSPECULAR_SCALE_MODE = Int32
D2D1_DISTANTSPECULAR_SCALE_MODE_NEAREST_NEIGHBOR: win32more.Windows.Win32.Graphics.Direct2D.D2D1_DISTANTSPECULAR_SCALE_MODE = 0
D2D1_DISTANTSPECULAR_SCALE_MODE_LINEAR: win32more.Windows.Win32.Graphics.Direct2D.D2D1_DISTANTSPECULAR_SCALE_MODE = 1
D2D1_DISTANTSPECULAR_SCALE_MODE_CUBIC: win32more.Windows.Win32.Graphics.Direct2D.D2D1_DISTANTSPECULAR_SCALE_MODE = 2
D2D1_DISTANTSPECULAR_SCALE_MODE_MULTI_SAMPLE_LINEAR: win32more.Windows.Win32.Graphics.Direct2D.D2D1_DISTANTSPECULAR_SCALE_MODE = 3
D2D1_DISTANTSPECULAR_SCALE_MODE_ANISOTROPIC: win32more.Windows.Win32.Graphics.Direct2D.D2D1_DISTANTSPECULAR_SCALE_MODE = 4
D2D1_DISTANTSPECULAR_SCALE_MODE_HIGH_QUALITY_CUBIC: win32more.Windows.Win32.Graphics.Direct2D.D2D1_DISTANTSPECULAR_SCALE_MODE = 5
D2D1_DPICOMPENSATION_INTERPOLATION_MODE = Int32
D2D1_DPICOMPENSATION_INTERPOLATION_MODE_NEAREST_NEIGHBOR: win32more.Windows.Win32.Graphics.Direct2D.D2D1_DPICOMPENSATION_INTERPOLATION_MODE = 0
D2D1_DPICOMPENSATION_INTERPOLATION_MODE_LINEAR: win32more.Windows.Win32.Graphics.Direct2D.D2D1_DPICOMPENSATION_INTERPOLATION_MODE = 1
D2D1_DPICOMPENSATION_INTERPOLATION_MODE_CUBIC: win32more.Windows.Win32.Graphics.Direct2D.D2D1_DPICOMPENSATION_INTERPOLATION_MODE = 2
D2D1_DPICOMPENSATION_INTERPOLATION_MODE_MULTI_SAMPLE_LINEAR: win32more.Windows.Win32.Graphics.Direct2D.D2D1_DPICOMPENSATION_INTERPOLATION_MODE = 3
D2D1_DPICOMPENSATION_INTERPOLATION_MODE_ANISOTROPIC: win32more.Windows.Win32.Graphics.Direct2D.D2D1_DPICOMPENSATION_INTERPOLATION_MODE = 4
D2D1_DPICOMPENSATION_INTERPOLATION_MODE_HIGH_QUALITY_CUBIC: win32more.Windows.Win32.Graphics.Direct2D.D2D1_DPICOMPENSATION_INTERPOLATION_MODE = 5
D2D1_DPICOMPENSATION_PROP = Int32
D2D1_DPICOMPENSATION_PROP_INTERPOLATION_MODE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_DPICOMPENSATION_PROP = 0
D2D1_DPICOMPENSATION_PROP_BORDER_MODE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_DPICOMPENSATION_PROP = 1
D2D1_DPICOMPENSATION_PROP_INPUT_DPI: win32more.Windows.Win32.Graphics.Direct2D.D2D1_DPICOMPENSATION_PROP = 2
class D2D1_DRAWING_STATE_DESCRIPTION(Structure):
    antialiasMode: win32more.Windows.Win32.Graphics.Direct2D.D2D1_ANTIALIAS_MODE
    textAntialiasMode: win32more.Windows.Win32.Graphics.Direct2D.D2D1_TEXT_ANTIALIAS_MODE
    tag1: UInt64
    tag2: UInt64
    transform: win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_MATRIX_3X2_F
class D2D1_DRAWING_STATE_DESCRIPTION1(Structure):
    antialiasMode: win32more.Windows.Win32.Graphics.Direct2D.D2D1_ANTIALIAS_MODE
    textAntialiasMode: win32more.Windows.Win32.Graphics.Direct2D.D2D1_TEXT_ANTIALIAS_MODE
    tag1: UInt64
    tag2: UInt64
    transform: win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_MATRIX_3X2_F
    primitiveBlend: win32more.Windows.Win32.Graphics.Direct2D.D2D1_PRIMITIVE_BLEND
    unitMode: win32more.Windows.Win32.Graphics.Direct2D.D2D1_UNIT_MODE
D2D1_DRAW_TEXT_OPTIONS = Int32
D2D1_DRAW_TEXT_OPTIONS_NO_SNAP: win32more.Windows.Win32.Graphics.Direct2D.D2D1_DRAW_TEXT_OPTIONS = 1
D2D1_DRAW_TEXT_OPTIONS_CLIP: win32more.Windows.Win32.Graphics.Direct2D.D2D1_DRAW_TEXT_OPTIONS = 2
D2D1_DRAW_TEXT_OPTIONS_ENABLE_COLOR_FONT: win32more.Windows.Win32.Graphics.Direct2D.D2D1_DRAW_TEXT_OPTIONS = 4
D2D1_DRAW_TEXT_OPTIONS_DISABLE_COLOR_BITMAP_SNAPPING: win32more.Windows.Win32.Graphics.Direct2D.D2D1_DRAW_TEXT_OPTIONS = 8
D2D1_DRAW_TEXT_OPTIONS_NONE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_DRAW_TEXT_OPTIONS = 0
D2D1_EDGEDETECTION_MODE = Int32
D2D1_EDGEDETECTION_MODE_SOBEL: win32more.Windows.Win32.Graphics.Direct2D.D2D1_EDGEDETECTION_MODE = 0
D2D1_EDGEDETECTION_MODE_PREWITT: win32more.Windows.Win32.Graphics.Direct2D.D2D1_EDGEDETECTION_MODE = 1
D2D1_EDGEDETECTION_PROP = Int32
D2D1_EDGEDETECTION_PROP_STRENGTH: win32more.Windows.Win32.Graphics.Direct2D.D2D1_EDGEDETECTION_PROP = 0
D2D1_EDGEDETECTION_PROP_BLUR_RADIUS: win32more.Windows.Win32.Graphics.Direct2D.D2D1_EDGEDETECTION_PROP = 1
D2D1_EDGEDETECTION_PROP_MODE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_EDGEDETECTION_PROP = 2
D2D1_EDGEDETECTION_PROP_OVERLAY_EDGES: win32more.Windows.Win32.Graphics.Direct2D.D2D1_EDGEDETECTION_PROP = 3
D2D1_EDGEDETECTION_PROP_ALPHA_MODE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_EDGEDETECTION_PROP = 4
class D2D1_EFFECT_INPUT_DESCRIPTION(Structure):
    effect: win32more.Windows.Win32.Graphics.Direct2D.ID2D1Effect
    inputIndex: UInt32
    inputRectangle: win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_RECT_F
class D2D1_ELLIPSE(Structure):
    point: win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_POINT_2F
    radiusX: Single
    radiusY: Single
D2D1_EMBOSS_PROP = Int32
D2D1_EMBOSS_PROP_HEIGHT: win32more.Windows.Win32.Graphics.Direct2D.D2D1_EMBOSS_PROP = 0
D2D1_EMBOSS_PROP_DIRECTION: win32more.Windows.Win32.Graphics.Direct2D.D2D1_EMBOSS_PROP = 1
D2D1_EXPOSURE_PROP = Int32
D2D1_EXPOSURE_PROP_EXPOSURE_VALUE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_EXPOSURE_PROP = 0
D2D1_EXTEND_MODE = Int32
D2D1_EXTEND_MODE_CLAMP: win32more.Windows.Win32.Graphics.Direct2D.D2D1_EXTEND_MODE = 0
D2D1_EXTEND_MODE_WRAP: win32more.Windows.Win32.Graphics.Direct2D.D2D1_EXTEND_MODE = 1
D2D1_EXTEND_MODE_MIRROR: win32more.Windows.Win32.Graphics.Direct2D.D2D1_EXTEND_MODE = 2
class D2D1_FACTORY_OPTIONS(Structure):
    debugLevel: win32more.Windows.Win32.Graphics.Direct2D.D2D1_DEBUG_LEVEL
D2D1_FACTORY_TYPE = Int32
D2D1_FACTORY_TYPE_SINGLE_THREADED: win32more.Windows.Win32.Graphics.Direct2D.D2D1_FACTORY_TYPE = 0
D2D1_FACTORY_TYPE_MULTI_THREADED: win32more.Windows.Win32.Graphics.Direct2D.D2D1_FACTORY_TYPE = 1
D2D1_FEATURE = Int32
D2D1_FEATURE_DOUBLES: win32more.Windows.Win32.Graphics.Direct2D.D2D1_FEATURE = 0
D2D1_FEATURE_D3D10_X_HARDWARE_OPTIONS: win32more.Windows.Win32.Graphics.Direct2D.D2D1_FEATURE = 1
class D2D1_FEATURE_DATA_D3D10_X_HARDWARE_OPTIONS(Structure):
    computeShaders_Plus_RawAndStructuredBuffers_Via_Shader_4_x: win32more.Windows.Win32.Foundation.BOOL
class D2D1_FEATURE_DATA_DOUBLES(Structure):
    doublePrecisionFloatShaderOps: win32more.Windows.Win32.Foundation.BOOL
D2D1_FEATURE_LEVEL = Int32
D2D1_FEATURE_LEVEL_DEFAULT: win32more.Windows.Win32.Graphics.Direct2D.D2D1_FEATURE_LEVEL = 0
D2D1_FEATURE_LEVEL_9: win32more.Windows.Win32.Graphics.Direct2D.D2D1_FEATURE_LEVEL = 37120
D2D1_FEATURE_LEVEL_10: win32more.Windows.Win32.Graphics.Direct2D.D2D1_FEATURE_LEVEL = 40960
D2D1_FILTER = Int32
D2D1_FILTER_MIN_MAG_MIP_POINT: win32more.Windows.Win32.Graphics.Direct2D.D2D1_FILTER = 0
D2D1_FILTER_MIN_MAG_POINT_MIP_LINEAR: win32more.Windows.Win32.Graphics.Direct2D.D2D1_FILTER = 1
D2D1_FILTER_MIN_POINT_MAG_LINEAR_MIP_POINT: win32more.Windows.Win32.Graphics.Direct2D.D2D1_FILTER = 4
D2D1_FILTER_MIN_POINT_MAG_MIP_LINEAR: win32more.Windows.Win32.Graphics.Direct2D.D2D1_FILTER = 5
D2D1_FILTER_MIN_LINEAR_MAG_MIP_POINT: win32more.Windows.Win32.Graphics.Direct2D.D2D1_FILTER = 16
D2D1_FILTER_MIN_LINEAR_MAG_POINT_MIP_LINEAR: win32more.Windows.Win32.Graphics.Direct2D.D2D1_FILTER = 17
D2D1_FILTER_MIN_MAG_LINEAR_MIP_POINT: win32more.Windows.Win32.Graphics.Direct2D.D2D1_FILTER = 20
D2D1_FILTER_MIN_MAG_MIP_LINEAR: win32more.Windows.Win32.Graphics.Direct2D.D2D1_FILTER = 21
D2D1_FILTER_ANISOTROPIC: win32more.Windows.Win32.Graphics.Direct2D.D2D1_FILTER = 85
D2D1_FLOOD_PROP = Int32
D2D1_FLOOD_PROP_COLOR: win32more.Windows.Win32.Graphics.Direct2D.D2D1_FLOOD_PROP = 0
D2D1_GAMMA = Int32
D2D1_GAMMA_2_2: win32more.Windows.Win32.Graphics.Direct2D.D2D1_GAMMA = 0
D2D1_GAMMA_1_0: win32more.Windows.Win32.Graphics.Direct2D.D2D1_GAMMA = 1
D2D1_GAMMA1 = Int32
D2D1_GAMMA1_G22: win32more.Windows.Win32.Graphics.Direct2D.D2D1_GAMMA1 = 0
D2D1_GAMMA1_G10: win32more.Windows.Win32.Graphics.Direct2D.D2D1_GAMMA1 = 1
D2D1_GAMMA1_G2084: win32more.Windows.Win32.Graphics.Direct2D.D2D1_GAMMA1 = 2
D2D1_GAMMATRANSFER_PROP = Int32
D2D1_GAMMATRANSFER_PROP_RED_AMPLITUDE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_GAMMATRANSFER_PROP = 0
D2D1_GAMMATRANSFER_PROP_RED_EXPONENT: win32more.Windows.Win32.Graphics.Direct2D.D2D1_GAMMATRANSFER_PROP = 1
D2D1_GAMMATRANSFER_PROP_RED_OFFSET: win32more.Windows.Win32.Graphics.Direct2D.D2D1_GAMMATRANSFER_PROP = 2
D2D1_GAMMATRANSFER_PROP_RED_DISABLE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_GAMMATRANSFER_PROP = 3
D2D1_GAMMATRANSFER_PROP_GREEN_AMPLITUDE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_GAMMATRANSFER_PROP = 4
D2D1_GAMMATRANSFER_PROP_GREEN_EXPONENT: win32more.Windows.Win32.Graphics.Direct2D.D2D1_GAMMATRANSFER_PROP = 5
D2D1_GAMMATRANSFER_PROP_GREEN_OFFSET: win32more.Windows.Win32.Graphics.Direct2D.D2D1_GAMMATRANSFER_PROP = 6
D2D1_GAMMATRANSFER_PROP_GREEN_DISABLE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_GAMMATRANSFER_PROP = 7
D2D1_GAMMATRANSFER_PROP_BLUE_AMPLITUDE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_GAMMATRANSFER_PROP = 8
D2D1_GAMMATRANSFER_PROP_BLUE_EXPONENT: win32more.Windows.Win32.Graphics.Direct2D.D2D1_GAMMATRANSFER_PROP = 9
D2D1_GAMMATRANSFER_PROP_BLUE_OFFSET: win32more.Windows.Win32.Graphics.Direct2D.D2D1_GAMMATRANSFER_PROP = 10
D2D1_GAMMATRANSFER_PROP_BLUE_DISABLE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_GAMMATRANSFER_PROP = 11
D2D1_GAMMATRANSFER_PROP_ALPHA_AMPLITUDE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_GAMMATRANSFER_PROP = 12
D2D1_GAMMATRANSFER_PROP_ALPHA_EXPONENT: win32more.Windows.Win32.Graphics.Direct2D.D2D1_GAMMATRANSFER_PROP = 13
D2D1_GAMMATRANSFER_PROP_ALPHA_OFFSET: win32more.Windows.Win32.Graphics.Direct2D.D2D1_GAMMATRANSFER_PROP = 14
D2D1_GAMMATRANSFER_PROP_ALPHA_DISABLE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_GAMMATRANSFER_PROP = 15
D2D1_GAMMATRANSFER_PROP_CLAMP_OUTPUT: win32more.Windows.Win32.Graphics.Direct2D.D2D1_GAMMATRANSFER_PROP = 16
D2D1_GAUSSIANBLUR_OPTIMIZATION = Int32
D2D1_GAUSSIANBLUR_OPTIMIZATION_SPEED: win32more.Windows.Win32.Graphics.Direct2D.D2D1_GAUSSIANBLUR_OPTIMIZATION = 0
D2D1_GAUSSIANBLUR_OPTIMIZATION_BALANCED: win32more.Windows.Win32.Graphics.Direct2D.D2D1_GAUSSIANBLUR_OPTIMIZATION = 1
D2D1_GAUSSIANBLUR_OPTIMIZATION_QUALITY: win32more.Windows.Win32.Graphics.Direct2D.D2D1_GAUSSIANBLUR_OPTIMIZATION = 2
D2D1_GAUSSIANBLUR_PROP = Int32
D2D1_GAUSSIANBLUR_PROP_STANDARD_DEVIATION: win32more.Windows.Win32.Graphics.Direct2D.D2D1_GAUSSIANBLUR_PROP = 0
D2D1_GAUSSIANBLUR_PROP_OPTIMIZATION: win32more.Windows.Win32.Graphics.Direct2D.D2D1_GAUSSIANBLUR_PROP = 1
D2D1_GAUSSIANBLUR_PROP_BORDER_MODE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_GAUSSIANBLUR_PROP = 2
D2D1_GEOMETRY_RELATION = Int32
D2D1_GEOMETRY_RELATION_UNKNOWN: win32more.Windows.Win32.Graphics.Direct2D.D2D1_GEOMETRY_RELATION = 0
D2D1_GEOMETRY_RELATION_DISJOINT: win32more.Windows.Win32.Graphics.Direct2D.D2D1_GEOMETRY_RELATION = 1
D2D1_GEOMETRY_RELATION_IS_CONTAINED: win32more.Windows.Win32.Graphics.Direct2D.D2D1_GEOMETRY_RELATION = 2
D2D1_GEOMETRY_RELATION_CONTAINS: win32more.Windows.Win32.Graphics.Direct2D.D2D1_GEOMETRY_RELATION = 3
D2D1_GEOMETRY_RELATION_OVERLAP: win32more.Windows.Win32.Graphics.Direct2D.D2D1_GEOMETRY_RELATION = 4
D2D1_GEOMETRY_SIMPLIFICATION_OPTION = Int32
D2D1_GEOMETRY_SIMPLIFICATION_OPTION_CUBICS_AND_LINES: win32more.Windows.Win32.Graphics.Direct2D.D2D1_GEOMETRY_SIMPLIFICATION_OPTION = 0
D2D1_GEOMETRY_SIMPLIFICATION_OPTION_LINES: win32more.Windows.Win32.Graphics.Direct2D.D2D1_GEOMETRY_SIMPLIFICATION_OPTION = 1
class D2D1_GRADIENT_MESH_PATCH(Structure):
    point00: win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_POINT_2F
    point01: win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_POINT_2F
    point02: win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_POINT_2F
    point03: win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_POINT_2F
    point10: win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_POINT_2F
    point11: win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_POINT_2F
    point12: win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_POINT_2F
    point13: win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_POINT_2F
    point20: win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_POINT_2F
    point21: win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_POINT_2F
    point22: win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_POINT_2F
    point23: win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_POINT_2F
    point30: win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_POINT_2F
    point31: win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_POINT_2F
    point32: win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_POINT_2F
    point33: win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_POINT_2F
    color00: win32more.Windows.Win32.Graphics.Direct2D.Common.D2D1_COLOR_F
    color03: win32more.Windows.Win32.Graphics.Direct2D.Common.D2D1_COLOR_F
    color30: win32more.Windows.Win32.Graphics.Direct2D.Common.D2D1_COLOR_F
    color33: win32more.Windows.Win32.Graphics.Direct2D.Common.D2D1_COLOR_F
    topEdgeMode: win32more.Windows.Win32.Graphics.Direct2D.D2D1_PATCH_EDGE_MODE
    leftEdgeMode: win32more.Windows.Win32.Graphics.Direct2D.D2D1_PATCH_EDGE_MODE
    bottomEdgeMode: win32more.Windows.Win32.Graphics.Direct2D.D2D1_PATCH_EDGE_MODE
    rightEdgeMode: win32more.Windows.Win32.Graphics.Direct2D.D2D1_PATCH_EDGE_MODE
D2D1_HDRTONEMAP_DISPLAY_MODE = Int32
D2D1_HDRTONEMAP_DISPLAY_MODE_SDR: win32more.Windows.Win32.Graphics.Direct2D.D2D1_HDRTONEMAP_DISPLAY_MODE = 0
D2D1_HDRTONEMAP_DISPLAY_MODE_HDR: win32more.Windows.Win32.Graphics.Direct2D.D2D1_HDRTONEMAP_DISPLAY_MODE = 1
D2D1_HDRTONEMAP_PROP = Int32
D2D1_HDRTONEMAP_PROP_INPUT_MAX_LUMINANCE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_HDRTONEMAP_PROP = 0
D2D1_HDRTONEMAP_PROP_OUTPUT_MAX_LUMINANCE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_HDRTONEMAP_PROP = 1
D2D1_HDRTONEMAP_PROP_DISPLAY_MODE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_HDRTONEMAP_PROP = 2
D2D1_HIGHLIGHTSANDSHADOWS_INPUT_GAMMA = Int32
D2D1_HIGHLIGHTSANDSHADOWS_INPUT_GAMMA_LINEAR: win32more.Windows.Win32.Graphics.Direct2D.D2D1_HIGHLIGHTSANDSHADOWS_INPUT_GAMMA = 0
D2D1_HIGHLIGHTSANDSHADOWS_INPUT_GAMMA_SRGB: win32more.Windows.Win32.Graphics.Direct2D.D2D1_HIGHLIGHTSANDSHADOWS_INPUT_GAMMA = 1
D2D1_HIGHLIGHTSANDSHADOWS_PROP = Int32
D2D1_HIGHLIGHTSANDSHADOWS_PROP_HIGHLIGHTS: win32more.Windows.Win32.Graphics.Direct2D.D2D1_HIGHLIGHTSANDSHADOWS_PROP = 0
D2D1_HIGHLIGHTSANDSHADOWS_PROP_SHADOWS: win32more.Windows.Win32.Graphics.Direct2D.D2D1_HIGHLIGHTSANDSHADOWS_PROP = 1
D2D1_HIGHLIGHTSANDSHADOWS_PROP_CLARITY: win32more.Windows.Win32.Graphics.Direct2D.D2D1_HIGHLIGHTSANDSHADOWS_PROP = 2
D2D1_HIGHLIGHTSANDSHADOWS_PROP_INPUT_GAMMA: win32more.Windows.Win32.Graphics.Direct2D.D2D1_HIGHLIGHTSANDSHADOWS_PROP = 3
D2D1_HIGHLIGHTSANDSHADOWS_PROP_MASK_BLUR_RADIUS: win32more.Windows.Win32.Graphics.Direct2D.D2D1_HIGHLIGHTSANDSHADOWS_PROP = 4
D2D1_HISTOGRAM_PROP = Int32
D2D1_HISTOGRAM_PROP_NUM_BINS: win32more.Windows.Win32.Graphics.Direct2D.D2D1_HISTOGRAM_PROP = 0
D2D1_HISTOGRAM_PROP_CHANNEL_SELECT: win32more.Windows.Win32.Graphics.Direct2D.D2D1_HISTOGRAM_PROP = 1
D2D1_HISTOGRAM_PROP_HISTOGRAM_OUTPUT: win32more.Windows.Win32.Graphics.Direct2D.D2D1_HISTOGRAM_PROP = 2
D2D1_HUEROTATION_PROP = Int32
D2D1_HUEROTATION_PROP_ANGLE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_HUEROTATION_PROP = 0
D2D1_HUETORGB_INPUT_COLOR_SPACE = Int32
D2D1_HUETORGB_INPUT_COLOR_SPACE_HUE_SATURATION_VALUE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_HUETORGB_INPUT_COLOR_SPACE = 0
D2D1_HUETORGB_INPUT_COLOR_SPACE_HUE_SATURATION_LIGHTNESS: win32more.Windows.Win32.Graphics.Direct2D.D2D1_HUETORGB_INPUT_COLOR_SPACE = 1
D2D1_HUETORGB_PROP = Int32
D2D1_HUETORGB_PROP_INPUT_COLOR_SPACE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_HUETORGB_PROP = 0
class D2D1_HWND_RENDER_TARGET_PROPERTIES(Structure):
    hwnd: win32more.Windows.Win32.Foundation.HWND
    pixelSize: win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_SIZE_U
    presentOptions: win32more.Windows.Win32.Graphics.Direct2D.D2D1_PRESENT_OPTIONS
class D2D1_IMAGE_BRUSH_PROPERTIES(Structure):
    sourceRectangle: win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_RECT_F
    extendModeX: win32more.Windows.Win32.Graphics.Direct2D.D2D1_EXTEND_MODE
    extendModeY: win32more.Windows.Win32.Graphics.Direct2D.D2D1_EXTEND_MODE
    interpolationMode: win32more.Windows.Win32.Graphics.Direct2D.D2D1_INTERPOLATION_MODE
D2D1_IMAGE_SOURCE_FROM_DXGI_OPTIONS = Int32
D2D1_IMAGE_SOURCE_FROM_DXGI_OPTIONS_NONE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_IMAGE_SOURCE_FROM_DXGI_OPTIONS = 0
D2D1_IMAGE_SOURCE_FROM_DXGI_OPTIONS_LOW_QUALITY_PRIMARY_CONVERSION: win32more.Windows.Win32.Graphics.Direct2D.D2D1_IMAGE_SOURCE_FROM_DXGI_OPTIONS = 1
D2D1_IMAGE_SOURCE_LOADING_OPTIONS = Int32
D2D1_IMAGE_SOURCE_LOADING_OPTIONS_NONE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_IMAGE_SOURCE_LOADING_OPTIONS = 0
D2D1_IMAGE_SOURCE_LOADING_OPTIONS_RELEASE_SOURCE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_IMAGE_SOURCE_LOADING_OPTIONS = 1
D2D1_IMAGE_SOURCE_LOADING_OPTIONS_CACHE_ON_DEMAND: win32more.Windows.Win32.Graphics.Direct2D.D2D1_IMAGE_SOURCE_LOADING_OPTIONS = 2
class D2D1_INK_BEZIER_SEGMENT(Structure):
    point1: win32more.Windows.Win32.Graphics.Direct2D.D2D1_INK_POINT
    point2: win32more.Windows.Win32.Graphics.Direct2D.D2D1_INK_POINT
    point3: win32more.Windows.Win32.Graphics.Direct2D.D2D1_INK_POINT
D2D1_INK_NIB_SHAPE = Int32
D2D1_INK_NIB_SHAPE_ROUND: win32more.Windows.Win32.Graphics.Direct2D.D2D1_INK_NIB_SHAPE = 0
D2D1_INK_NIB_SHAPE_SQUARE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_INK_NIB_SHAPE = 1
class D2D1_INK_POINT(Structure):
    x: Single
    y: Single
    radius: Single
class D2D1_INK_STYLE_PROPERTIES(Structure):
    nibShape: win32more.Windows.Win32.Graphics.Direct2D.D2D1_INK_NIB_SHAPE
    nibTransform: win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_MATRIX_3X2_F
class D2D1_INPUT_DESCRIPTION(Structure):
    filter: win32more.Windows.Win32.Graphics.Direct2D.D2D1_FILTER
    levelOfDetailCount: UInt32
class D2D1_INPUT_ELEMENT_DESC(Structure):
    semanticName: win32more.Windows.Win32.Foundation.PSTR
    semanticIndex: UInt32
    format: win32more.Windows.Win32.Graphics.Dxgi.Common.DXGI_FORMAT
    inputSlot: UInt32
    alignedByteOffset: UInt32
D2D1_INTERPOLATION_MODE = Int32
D2D1_INTERPOLATION_MODE_NEAREST_NEIGHBOR: win32more.Windows.Win32.Graphics.Direct2D.D2D1_INTERPOLATION_MODE = 0
D2D1_INTERPOLATION_MODE_LINEAR: win32more.Windows.Win32.Graphics.Direct2D.D2D1_INTERPOLATION_MODE = 1
D2D1_INTERPOLATION_MODE_CUBIC: win32more.Windows.Win32.Graphics.Direct2D.D2D1_INTERPOLATION_MODE = 2
D2D1_INTERPOLATION_MODE_MULTI_SAMPLE_LINEAR: win32more.Windows.Win32.Graphics.Direct2D.D2D1_INTERPOLATION_MODE = 3
D2D1_INTERPOLATION_MODE_ANISOTROPIC: win32more.Windows.Win32.Graphics.Direct2D.D2D1_INTERPOLATION_MODE = 4
D2D1_INTERPOLATION_MODE_HIGH_QUALITY_CUBIC: win32more.Windows.Win32.Graphics.Direct2D.D2D1_INTERPOLATION_MODE = 5
D2D1_INTERPOLATION_MODE_DEFINITION = Int32
D2D1_INTERPOLATION_MODE_DEFINITION_NEAREST_NEIGHBOR: win32more.Windows.Win32.Graphics.Direct2D.D2D1_INTERPOLATION_MODE_DEFINITION = 0
D2D1_INTERPOLATION_MODE_DEFINITION_LINEAR: win32more.Windows.Win32.Graphics.Direct2D.D2D1_INTERPOLATION_MODE_DEFINITION = 1
D2D1_INTERPOLATION_MODE_DEFINITION_CUBIC: win32more.Windows.Win32.Graphics.Direct2D.D2D1_INTERPOLATION_MODE_DEFINITION = 2
D2D1_INTERPOLATION_MODE_DEFINITION_MULTI_SAMPLE_LINEAR: win32more.Windows.Win32.Graphics.Direct2D.D2D1_INTERPOLATION_MODE_DEFINITION = 3
D2D1_INTERPOLATION_MODE_DEFINITION_ANISOTROPIC: win32more.Windows.Win32.Graphics.Direct2D.D2D1_INTERPOLATION_MODE_DEFINITION = 4
D2D1_INTERPOLATION_MODE_DEFINITION_HIGH_QUALITY_CUBIC: win32more.Windows.Win32.Graphics.Direct2D.D2D1_INTERPOLATION_MODE_DEFINITION = 5
D2D1_INTERPOLATION_MODE_DEFINITION_FANT: win32more.Windows.Win32.Graphics.Direct2D.D2D1_INTERPOLATION_MODE_DEFINITION = 6
D2D1_INTERPOLATION_MODE_DEFINITION_MIPMAP_LINEAR: win32more.Windows.Win32.Graphics.Direct2D.D2D1_INTERPOLATION_MODE_DEFINITION = 7
D2D1_LAYER_OPTIONS = Int32
D2D1_LAYER_OPTIONS_NONE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_LAYER_OPTIONS = 0
D2D1_LAYER_OPTIONS_INITIALIZE_FOR_CLEARTYPE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_LAYER_OPTIONS = 1
D2D1_LAYER_OPTIONS1 = Int32
D2D1_LAYER_OPTIONS1_NONE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_LAYER_OPTIONS1 = 0
D2D1_LAYER_OPTIONS1_INITIALIZE_FROM_BACKGROUND: win32more.Windows.Win32.Graphics.Direct2D.D2D1_LAYER_OPTIONS1 = 1
D2D1_LAYER_OPTIONS1_IGNORE_ALPHA: win32more.Windows.Win32.Graphics.Direct2D.D2D1_LAYER_OPTIONS1 = 2
class D2D1_LAYER_PARAMETERS(Structure):
    contentBounds: win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_RECT_F
    geometricMask: win32more.Windows.Win32.Graphics.Direct2D.ID2D1Geometry
    maskAntialiasMode: win32more.Windows.Win32.Graphics.Direct2D.D2D1_ANTIALIAS_MODE
    maskTransform: win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_MATRIX_3X2_F
    opacity: Single
    opacityBrush: win32more.Windows.Win32.Graphics.Direct2D.ID2D1Brush
    layerOptions: win32more.Windows.Win32.Graphics.Direct2D.D2D1_LAYER_OPTIONS
class D2D1_LAYER_PARAMETERS1(Structure):
    contentBounds: win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_RECT_F
    geometricMask: win32more.Windows.Win32.Graphics.Direct2D.ID2D1Geometry
    maskAntialiasMode: win32more.Windows.Win32.Graphics.Direct2D.D2D1_ANTIALIAS_MODE
    maskTransform: win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_MATRIX_3X2_F
    opacity: Single
    opacityBrush: win32more.Windows.Win32.Graphics.Direct2D.ID2D1Brush
    layerOptions: win32more.Windows.Win32.Graphics.Direct2D.D2D1_LAYER_OPTIONS1
D2D1_LINEARTRANSFER_PROP = Int32
D2D1_LINEARTRANSFER_PROP_RED_Y_INTERCEPT: win32more.Windows.Win32.Graphics.Direct2D.D2D1_LINEARTRANSFER_PROP = 0
D2D1_LINEARTRANSFER_PROP_RED_SLOPE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_LINEARTRANSFER_PROP = 1
D2D1_LINEARTRANSFER_PROP_RED_DISABLE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_LINEARTRANSFER_PROP = 2
D2D1_LINEARTRANSFER_PROP_GREEN_Y_INTERCEPT: win32more.Windows.Win32.Graphics.Direct2D.D2D1_LINEARTRANSFER_PROP = 3
D2D1_LINEARTRANSFER_PROP_GREEN_SLOPE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_LINEARTRANSFER_PROP = 4
D2D1_LINEARTRANSFER_PROP_GREEN_DISABLE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_LINEARTRANSFER_PROP = 5
D2D1_LINEARTRANSFER_PROP_BLUE_Y_INTERCEPT: win32more.Windows.Win32.Graphics.Direct2D.D2D1_LINEARTRANSFER_PROP = 6
D2D1_LINEARTRANSFER_PROP_BLUE_SLOPE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_LINEARTRANSFER_PROP = 7
D2D1_LINEARTRANSFER_PROP_BLUE_DISABLE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_LINEARTRANSFER_PROP = 8
D2D1_LINEARTRANSFER_PROP_ALPHA_Y_INTERCEPT: win32more.Windows.Win32.Graphics.Direct2D.D2D1_LINEARTRANSFER_PROP = 9
D2D1_LINEARTRANSFER_PROP_ALPHA_SLOPE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_LINEARTRANSFER_PROP = 10
D2D1_LINEARTRANSFER_PROP_ALPHA_DISABLE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_LINEARTRANSFER_PROP = 11
D2D1_LINEARTRANSFER_PROP_CLAMP_OUTPUT: win32more.Windows.Win32.Graphics.Direct2D.D2D1_LINEARTRANSFER_PROP = 12
class D2D1_LINEAR_GRADIENT_BRUSH_PROPERTIES(Structure):
    startPoint: win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_POINT_2F
    endPoint: win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_POINT_2F
D2D1_LINE_JOIN = Int32
D2D1_LINE_JOIN_MITER: win32more.Windows.Win32.Graphics.Direct2D.D2D1_LINE_JOIN = 0
D2D1_LINE_JOIN_BEVEL: win32more.Windows.Win32.Graphics.Direct2D.D2D1_LINE_JOIN = 1
D2D1_LINE_JOIN_ROUND: win32more.Windows.Win32.Graphics.Direct2D.D2D1_LINE_JOIN = 2
D2D1_LINE_JOIN_MITER_OR_BEVEL: win32more.Windows.Win32.Graphics.Direct2D.D2D1_LINE_JOIN = 3
D2D1_LOOKUPTABLE3D_PROP = Int32
D2D1_LOOKUPTABLE3D_PROP_LUT: win32more.Windows.Win32.Graphics.Direct2D.D2D1_LOOKUPTABLE3D_PROP = 0
D2D1_LOOKUPTABLE3D_PROP_ALPHA_MODE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_LOOKUPTABLE3D_PROP = 1
class D2D1_MAPPED_RECT(Structure):
    pitch: UInt32
    bits: POINTER(Byte)
D2D1_MAP_OPTIONS = Int32
D2D1_MAP_OPTIONS_NONE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_MAP_OPTIONS = 0
D2D1_MAP_OPTIONS_READ: win32more.Windows.Win32.Graphics.Direct2D.D2D1_MAP_OPTIONS = 1
D2D1_MAP_OPTIONS_WRITE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_MAP_OPTIONS = 2
D2D1_MAP_OPTIONS_DISCARD: win32more.Windows.Win32.Graphics.Direct2D.D2D1_MAP_OPTIONS = 4
D2D1_MORPHOLOGY_MODE = Int32
D2D1_MORPHOLOGY_MODE_ERODE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_MORPHOLOGY_MODE = 0
D2D1_MORPHOLOGY_MODE_DILATE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_MORPHOLOGY_MODE = 1
D2D1_MORPHOLOGY_PROP = Int32
D2D1_MORPHOLOGY_PROP_MODE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_MORPHOLOGY_PROP = 0
D2D1_MORPHOLOGY_PROP_WIDTH: win32more.Windows.Win32.Graphics.Direct2D.D2D1_MORPHOLOGY_PROP = 1
D2D1_MORPHOLOGY_PROP_HEIGHT: win32more.Windows.Win32.Graphics.Direct2D.D2D1_MORPHOLOGY_PROP = 2
D2D1_OPACITYMETADATA_PROP = Int32
D2D1_OPACITYMETADATA_PROP_INPUT_OPAQUE_RECT: win32more.Windows.Win32.Graphics.Direct2D.D2D1_OPACITYMETADATA_PROP = 0
D2D1_OPACITY_MASK_CONTENT = Int32
D2D1_OPACITY_MASK_CONTENT_GRAPHICS: win32more.Windows.Win32.Graphics.Direct2D.D2D1_OPACITY_MASK_CONTENT = 0
D2D1_OPACITY_MASK_CONTENT_TEXT_NATURAL: win32more.Windows.Win32.Graphics.Direct2D.D2D1_OPACITY_MASK_CONTENT = 1
D2D1_OPACITY_MASK_CONTENT_TEXT_GDI_COMPATIBLE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_OPACITY_MASK_CONTENT = 2
D2D1_OPACITY_PROP = Int32
D2D1_OPACITY_PROP_OPACITY: win32more.Windows.Win32.Graphics.Direct2D.D2D1_OPACITY_PROP = 0
D2D1_ORIENTATION = Int32
D2D1_ORIENTATION_DEFAULT: win32more.Windows.Win32.Graphics.Direct2D.D2D1_ORIENTATION = 1
D2D1_ORIENTATION_FLIP_HORIZONTAL: win32more.Windows.Win32.Graphics.Direct2D.D2D1_ORIENTATION = 2
D2D1_ORIENTATION_ROTATE_CLOCKWISE180: win32more.Windows.Win32.Graphics.Direct2D.D2D1_ORIENTATION = 3
D2D1_ORIENTATION_ROTATE_CLOCKWISE180_FLIP_HORIZONTAL: win32more.Windows.Win32.Graphics.Direct2D.D2D1_ORIENTATION = 4
D2D1_ORIENTATION_ROTATE_CLOCKWISE90_FLIP_HORIZONTAL: win32more.Windows.Win32.Graphics.Direct2D.D2D1_ORIENTATION = 5
D2D1_ORIENTATION_ROTATE_CLOCKWISE270: win32more.Windows.Win32.Graphics.Direct2D.D2D1_ORIENTATION = 6
D2D1_ORIENTATION_ROTATE_CLOCKWISE270_FLIP_HORIZONTAL: win32more.Windows.Win32.Graphics.Direct2D.D2D1_ORIENTATION = 7
D2D1_ORIENTATION_ROTATE_CLOCKWISE90: win32more.Windows.Win32.Graphics.Direct2D.D2D1_ORIENTATION = 8
D2D1_PATCH_EDGE_MODE = Int32
D2D1_PATCH_EDGE_MODE_ALIASED: win32more.Windows.Win32.Graphics.Direct2D.D2D1_PATCH_EDGE_MODE = 0
D2D1_PATCH_EDGE_MODE_ANTIALIASED: win32more.Windows.Win32.Graphics.Direct2D.D2D1_PATCH_EDGE_MODE = 1
D2D1_PATCH_EDGE_MODE_ALIASED_INFLATED: win32more.Windows.Win32.Graphics.Direct2D.D2D1_PATCH_EDGE_MODE = 2
D2D1_PIXEL_OPTIONS = Int32
D2D1_PIXEL_OPTIONS_NONE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_PIXEL_OPTIONS = 0
D2D1_PIXEL_OPTIONS_TRIVIAL_SAMPLING: win32more.Windows.Win32.Graphics.Direct2D.D2D1_PIXEL_OPTIONS = 1
D2D1_POINTDIFFUSE_PROP = Int32
D2D1_POINTDIFFUSE_PROP_LIGHT_POSITION: win32more.Windows.Win32.Graphics.Direct2D.D2D1_POINTDIFFUSE_PROP = 0
D2D1_POINTDIFFUSE_PROP_DIFFUSE_CONSTANT: win32more.Windows.Win32.Graphics.Direct2D.D2D1_POINTDIFFUSE_PROP = 1
D2D1_POINTDIFFUSE_PROP_SURFACE_SCALE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_POINTDIFFUSE_PROP = 2
D2D1_POINTDIFFUSE_PROP_COLOR: win32more.Windows.Win32.Graphics.Direct2D.D2D1_POINTDIFFUSE_PROP = 3
D2D1_POINTDIFFUSE_PROP_KERNEL_UNIT_LENGTH: win32more.Windows.Win32.Graphics.Direct2D.D2D1_POINTDIFFUSE_PROP = 4
D2D1_POINTDIFFUSE_PROP_SCALE_MODE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_POINTDIFFUSE_PROP = 5
D2D1_POINTDIFFUSE_SCALE_MODE = Int32
D2D1_POINTDIFFUSE_SCALE_MODE_NEAREST_NEIGHBOR: win32more.Windows.Win32.Graphics.Direct2D.D2D1_POINTDIFFUSE_SCALE_MODE = 0
D2D1_POINTDIFFUSE_SCALE_MODE_LINEAR: win32more.Windows.Win32.Graphics.Direct2D.D2D1_POINTDIFFUSE_SCALE_MODE = 1
D2D1_POINTDIFFUSE_SCALE_MODE_CUBIC: win32more.Windows.Win32.Graphics.Direct2D.D2D1_POINTDIFFUSE_SCALE_MODE = 2
D2D1_POINTDIFFUSE_SCALE_MODE_MULTI_SAMPLE_LINEAR: win32more.Windows.Win32.Graphics.Direct2D.D2D1_POINTDIFFUSE_SCALE_MODE = 3
D2D1_POINTDIFFUSE_SCALE_MODE_ANISOTROPIC: win32more.Windows.Win32.Graphics.Direct2D.D2D1_POINTDIFFUSE_SCALE_MODE = 4
D2D1_POINTDIFFUSE_SCALE_MODE_HIGH_QUALITY_CUBIC: win32more.Windows.Win32.Graphics.Direct2D.D2D1_POINTDIFFUSE_SCALE_MODE = 5
D2D1_POINTSPECULAR_PROP = Int32
D2D1_POINTSPECULAR_PROP_LIGHT_POSITION: win32more.Windows.Win32.Graphics.Direct2D.D2D1_POINTSPECULAR_PROP = 0
D2D1_POINTSPECULAR_PROP_SPECULAR_EXPONENT: win32more.Windows.Win32.Graphics.Direct2D.D2D1_POINTSPECULAR_PROP = 1
D2D1_POINTSPECULAR_PROP_SPECULAR_CONSTANT: win32more.Windows.Win32.Graphics.Direct2D.D2D1_POINTSPECULAR_PROP = 2
D2D1_POINTSPECULAR_PROP_SURFACE_SCALE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_POINTSPECULAR_PROP = 3
D2D1_POINTSPECULAR_PROP_COLOR: win32more.Windows.Win32.Graphics.Direct2D.D2D1_POINTSPECULAR_PROP = 4
D2D1_POINTSPECULAR_PROP_KERNEL_UNIT_LENGTH: win32more.Windows.Win32.Graphics.Direct2D.D2D1_POINTSPECULAR_PROP = 5
D2D1_POINTSPECULAR_PROP_SCALE_MODE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_POINTSPECULAR_PROP = 6
D2D1_POINTSPECULAR_SCALE_MODE = Int32
D2D1_POINTSPECULAR_SCALE_MODE_NEAREST_NEIGHBOR: win32more.Windows.Win32.Graphics.Direct2D.D2D1_POINTSPECULAR_SCALE_MODE = 0
D2D1_POINTSPECULAR_SCALE_MODE_LINEAR: win32more.Windows.Win32.Graphics.Direct2D.D2D1_POINTSPECULAR_SCALE_MODE = 1
D2D1_POINTSPECULAR_SCALE_MODE_CUBIC: win32more.Windows.Win32.Graphics.Direct2D.D2D1_POINTSPECULAR_SCALE_MODE = 2
D2D1_POINTSPECULAR_SCALE_MODE_MULTI_SAMPLE_LINEAR: win32more.Windows.Win32.Graphics.Direct2D.D2D1_POINTSPECULAR_SCALE_MODE = 3
D2D1_POINTSPECULAR_SCALE_MODE_ANISOTROPIC: win32more.Windows.Win32.Graphics.Direct2D.D2D1_POINTSPECULAR_SCALE_MODE = 4
D2D1_POINTSPECULAR_SCALE_MODE_HIGH_QUALITY_CUBIC: win32more.Windows.Win32.Graphics.Direct2D.D2D1_POINTSPECULAR_SCALE_MODE = 5
class D2D1_POINT_DESCRIPTION(Structure):
    point: win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_POINT_2F
    unitTangentVector: win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_POINT_2F
    endSegment: UInt32
    endFigure: UInt32
    lengthToEndSegment: Single
D2D1_POSTERIZE_PROP = Int32
D2D1_POSTERIZE_PROP_RED_VALUE_COUNT: win32more.Windows.Win32.Graphics.Direct2D.D2D1_POSTERIZE_PROP = 0
D2D1_POSTERIZE_PROP_GREEN_VALUE_COUNT: win32more.Windows.Win32.Graphics.Direct2D.D2D1_POSTERIZE_PROP = 1
D2D1_POSTERIZE_PROP_BLUE_VALUE_COUNT: win32more.Windows.Win32.Graphics.Direct2D.D2D1_POSTERIZE_PROP = 2
D2D1_PRESENT_OPTIONS = Int32
D2D1_PRESENT_OPTIONS_NONE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_PRESENT_OPTIONS = 0
D2D1_PRESENT_OPTIONS_RETAIN_CONTENTS: win32more.Windows.Win32.Graphics.Direct2D.D2D1_PRESENT_OPTIONS = 1
D2D1_PRESENT_OPTIONS_IMMEDIATELY: win32more.Windows.Win32.Graphics.Direct2D.D2D1_PRESENT_OPTIONS = 2
D2D1_PRIMITIVE_BLEND = Int32
D2D1_PRIMITIVE_BLEND_SOURCE_OVER: win32more.Windows.Win32.Graphics.Direct2D.D2D1_PRIMITIVE_BLEND = 0
D2D1_PRIMITIVE_BLEND_COPY: win32more.Windows.Win32.Graphics.Direct2D.D2D1_PRIMITIVE_BLEND = 1
D2D1_PRIMITIVE_BLEND_MIN: win32more.Windows.Win32.Graphics.Direct2D.D2D1_PRIMITIVE_BLEND = 2
D2D1_PRIMITIVE_BLEND_ADD: win32more.Windows.Win32.Graphics.Direct2D.D2D1_PRIMITIVE_BLEND = 3
D2D1_PRIMITIVE_BLEND_MAX: win32more.Windows.Win32.Graphics.Direct2D.D2D1_PRIMITIVE_BLEND = 4
class D2D1_PRINT_CONTROL_PROPERTIES(Structure):
    fontSubset: win32more.Windows.Win32.Graphics.Direct2D.D2D1_PRINT_FONT_SUBSET_MODE
    rasterDPI: Single
    colorSpace: win32more.Windows.Win32.Graphics.Direct2D.D2D1_COLOR_SPACE
D2D1_PRINT_FONT_SUBSET_MODE = Int32
D2D1_PRINT_FONT_SUBSET_MODE_DEFAULT: win32more.Windows.Win32.Graphics.Direct2D.D2D1_PRINT_FONT_SUBSET_MODE = 0
D2D1_PRINT_FONT_SUBSET_MODE_EACHPAGE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_PRINT_FONT_SUBSET_MODE = 1
D2D1_PRINT_FONT_SUBSET_MODE_NONE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_PRINT_FONT_SUBSET_MODE = 2
D2D1_PROPERTY = Int32
D2D1_PROPERTY_CLSID: win32more.Windows.Win32.Graphics.Direct2D.D2D1_PROPERTY = -2147483648
D2D1_PROPERTY_DISPLAYNAME: win32more.Windows.Win32.Graphics.Direct2D.D2D1_PROPERTY = -2147483647
D2D1_PROPERTY_AUTHOR: win32more.Windows.Win32.Graphics.Direct2D.D2D1_PROPERTY = -2147483646
D2D1_PROPERTY_CATEGORY: win32more.Windows.Win32.Graphics.Direct2D.D2D1_PROPERTY = -2147483645
D2D1_PROPERTY_DESCRIPTION: win32more.Windows.Win32.Graphics.Direct2D.D2D1_PROPERTY = -2147483644
D2D1_PROPERTY_INPUTS: win32more.Windows.Win32.Graphics.Direct2D.D2D1_PROPERTY = -2147483643
D2D1_PROPERTY_CACHED: win32more.Windows.Win32.Graphics.Direct2D.D2D1_PROPERTY = -2147483642
D2D1_PROPERTY_PRECISION: win32more.Windows.Win32.Graphics.Direct2D.D2D1_PROPERTY = -2147483641
D2D1_PROPERTY_MIN_INPUTS: win32more.Windows.Win32.Graphics.Direct2D.D2D1_PROPERTY = -2147483640
D2D1_PROPERTY_MAX_INPUTS: win32more.Windows.Win32.Graphics.Direct2D.D2D1_PROPERTY = -2147483639
class D2D1_PROPERTY_BINDING(Structure):
    propertyName: win32more.Windows.Win32.Foundation.PWSTR
    setFunction: win32more.Windows.Win32.Graphics.Direct2D.PD2D1_PROPERTY_SET_FUNCTION
    getFunction: win32more.Windows.Win32.Graphics.Direct2D.PD2D1_PROPERTY_GET_FUNCTION
D2D1_PROPERTY_TYPE = Int32
D2D1_PROPERTY_TYPE_UNKNOWN: win32more.Windows.Win32.Graphics.Direct2D.D2D1_PROPERTY_TYPE = 0
D2D1_PROPERTY_TYPE_STRING: win32more.Windows.Win32.Graphics.Direct2D.D2D1_PROPERTY_TYPE = 1
D2D1_PROPERTY_TYPE_BOOL: win32more.Windows.Win32.Graphics.Direct2D.D2D1_PROPERTY_TYPE = 2
D2D1_PROPERTY_TYPE_UINT32: win32more.Windows.Win32.Graphics.Direct2D.D2D1_PROPERTY_TYPE = 3
D2D1_PROPERTY_TYPE_INT32: win32more.Windows.Win32.Graphics.Direct2D.D2D1_PROPERTY_TYPE = 4
D2D1_PROPERTY_TYPE_FLOAT: win32more.Windows.Win32.Graphics.Direct2D.D2D1_PROPERTY_TYPE = 5
D2D1_PROPERTY_TYPE_VECTOR2: win32more.Windows.Win32.Graphics.Direct2D.D2D1_PROPERTY_TYPE = 6
D2D1_PROPERTY_TYPE_VECTOR3: win32more.Windows.Win32.Graphics.Direct2D.D2D1_PROPERTY_TYPE = 7
D2D1_PROPERTY_TYPE_VECTOR4: win32more.Windows.Win32.Graphics.Direct2D.D2D1_PROPERTY_TYPE = 8
D2D1_PROPERTY_TYPE_BLOB: win32more.Windows.Win32.Graphics.Direct2D.D2D1_PROPERTY_TYPE = 9
D2D1_PROPERTY_TYPE_IUNKNOWN: win32more.Windows.Win32.Graphics.Direct2D.D2D1_PROPERTY_TYPE = 10
D2D1_PROPERTY_TYPE_ENUM: win32more.Windows.Win32.Graphics.Direct2D.D2D1_PROPERTY_TYPE = 11
D2D1_PROPERTY_TYPE_ARRAY: win32more.Windows.Win32.Graphics.Direct2D.D2D1_PROPERTY_TYPE = 12
D2D1_PROPERTY_TYPE_CLSID: win32more.Windows.Win32.Graphics.Direct2D.D2D1_PROPERTY_TYPE = 13
D2D1_PROPERTY_TYPE_MATRIX_3X2: win32more.Windows.Win32.Graphics.Direct2D.D2D1_PROPERTY_TYPE = 14
D2D1_PROPERTY_TYPE_MATRIX_4X3: win32more.Windows.Win32.Graphics.Direct2D.D2D1_PROPERTY_TYPE = 15
D2D1_PROPERTY_TYPE_MATRIX_4X4: win32more.Windows.Win32.Graphics.Direct2D.D2D1_PROPERTY_TYPE = 16
D2D1_PROPERTY_TYPE_MATRIX_5X4: win32more.Windows.Win32.Graphics.Direct2D.D2D1_PROPERTY_TYPE = 17
D2D1_PROPERTY_TYPE_COLOR_CONTEXT: win32more.Windows.Win32.Graphics.Direct2D.D2D1_PROPERTY_TYPE = 18
class D2D1_QUADRATIC_BEZIER_SEGMENT(Structure):
    point1: win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_POINT_2F
    point2: win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_POINT_2F
class D2D1_RADIAL_GRADIENT_BRUSH_PROPERTIES(Structure):
    center: win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_POINT_2F
    gradientOriginOffset: win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_POINT_2F
    radiusX: Single
    radiusY: Single
class D2D1_RENDERING_CONTROLS(Structure):
    bufferPrecision: win32more.Windows.Win32.Graphics.Direct2D.D2D1_BUFFER_PRECISION
    tileSize: win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_SIZE_U
D2D1_RENDERING_PRIORITY = Int32
D2D1_RENDERING_PRIORITY_NORMAL: win32more.Windows.Win32.Graphics.Direct2D.D2D1_RENDERING_PRIORITY = 0
D2D1_RENDERING_PRIORITY_LOW: win32more.Windows.Win32.Graphics.Direct2D.D2D1_RENDERING_PRIORITY = 1
class D2D1_RENDER_TARGET_PROPERTIES(Structure):
    type: win32more.Windows.Win32.Graphics.Direct2D.D2D1_RENDER_TARGET_TYPE
    pixelFormat: win32more.Windows.Win32.Graphics.Direct2D.Common.D2D1_PIXEL_FORMAT
    dpiX: Single
    dpiY: Single
    usage: win32more.Windows.Win32.Graphics.Direct2D.D2D1_RENDER_TARGET_USAGE
    minLevel: win32more.Windows.Win32.Graphics.Direct2D.D2D1_FEATURE_LEVEL
D2D1_RENDER_TARGET_TYPE = Int32
D2D1_RENDER_TARGET_TYPE_DEFAULT: win32more.Windows.Win32.Graphics.Direct2D.D2D1_RENDER_TARGET_TYPE = 0
D2D1_RENDER_TARGET_TYPE_SOFTWARE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_RENDER_TARGET_TYPE = 1
D2D1_RENDER_TARGET_TYPE_HARDWARE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_RENDER_TARGET_TYPE = 2
D2D1_RENDER_TARGET_USAGE = Int32
D2D1_RENDER_TARGET_USAGE_NONE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_RENDER_TARGET_USAGE = 0
D2D1_RENDER_TARGET_USAGE_FORCE_BITMAP_REMOTING: win32more.Windows.Win32.Graphics.Direct2D.D2D1_RENDER_TARGET_USAGE = 1
D2D1_RENDER_TARGET_USAGE_GDI_COMPATIBLE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_RENDER_TARGET_USAGE = 2
class D2D1_RESOURCE_TEXTURE_PROPERTIES(Structure):
    extents: POINTER(UInt32)
    dimensions: UInt32
    bufferPrecision: win32more.Windows.Win32.Graphics.Direct2D.D2D1_BUFFER_PRECISION
    channelDepth: win32more.Windows.Win32.Graphics.Direct2D.D2D1_CHANNEL_DEPTH
    filter: win32more.Windows.Win32.Graphics.Direct2D.D2D1_FILTER
    extendModes: POINTER(win32more.Windows.Win32.Graphics.Direct2D.D2D1_EXTEND_MODE)
D2D1_RGBTOHUE_OUTPUT_COLOR_SPACE = Int32
D2D1_RGBTOHUE_OUTPUT_COLOR_SPACE_HUE_SATURATION_VALUE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_RGBTOHUE_OUTPUT_COLOR_SPACE = 0
D2D1_RGBTOHUE_OUTPUT_COLOR_SPACE_HUE_SATURATION_LIGHTNESS: win32more.Windows.Win32.Graphics.Direct2D.D2D1_RGBTOHUE_OUTPUT_COLOR_SPACE = 1
D2D1_RGBTOHUE_PROP = Int32
D2D1_RGBTOHUE_PROP_OUTPUT_COLOR_SPACE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_RGBTOHUE_PROP = 0
class D2D1_ROUNDED_RECT(Structure):
    rect: win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_RECT_F
    radiusX: Single
    radiusY: Single
D2D1_SATURATION_PROP = Int32
D2D1_SATURATION_PROP_SATURATION: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SATURATION_PROP = 0
D2D1_SCALE_INTERPOLATION_MODE = Int32
D2D1_SCALE_INTERPOLATION_MODE_NEAREST_NEIGHBOR: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SCALE_INTERPOLATION_MODE = 0
D2D1_SCALE_INTERPOLATION_MODE_LINEAR: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SCALE_INTERPOLATION_MODE = 1
D2D1_SCALE_INTERPOLATION_MODE_CUBIC: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SCALE_INTERPOLATION_MODE = 2
D2D1_SCALE_INTERPOLATION_MODE_MULTI_SAMPLE_LINEAR: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SCALE_INTERPOLATION_MODE = 3
D2D1_SCALE_INTERPOLATION_MODE_ANISOTROPIC: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SCALE_INTERPOLATION_MODE = 4
D2D1_SCALE_INTERPOLATION_MODE_HIGH_QUALITY_CUBIC: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SCALE_INTERPOLATION_MODE = 5
D2D1_SCALE_PROP = Int32
D2D1_SCALE_PROP_SCALE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SCALE_PROP = 0
D2D1_SCALE_PROP_CENTER_POINT: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SCALE_PROP = 1
D2D1_SCALE_PROP_INTERPOLATION_MODE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SCALE_PROP = 2
D2D1_SCALE_PROP_BORDER_MODE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SCALE_PROP = 3
D2D1_SCALE_PROP_SHARPNESS: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SCALE_PROP = 4
D2D1_SEPIA_PROP = Int32
D2D1_SEPIA_PROP_INTENSITY: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SEPIA_PROP = 0
D2D1_SEPIA_PROP_ALPHA_MODE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SEPIA_PROP = 1
D2D1_SHADOW_OPTIMIZATION = Int32
D2D1_SHADOW_OPTIMIZATION_SPEED: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SHADOW_OPTIMIZATION = 0
D2D1_SHADOW_OPTIMIZATION_BALANCED: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SHADOW_OPTIMIZATION = 1
D2D1_SHADOW_OPTIMIZATION_QUALITY: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SHADOW_OPTIMIZATION = 2
D2D1_SHADOW_PROP = Int32
D2D1_SHADOW_PROP_BLUR_STANDARD_DEVIATION: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SHADOW_PROP = 0
D2D1_SHADOW_PROP_COLOR: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SHADOW_PROP = 1
D2D1_SHADOW_PROP_OPTIMIZATION: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SHADOW_PROP = 2
D2D1_SHARPEN_PROP = Int32
D2D1_SHARPEN_PROP_SHARPNESS: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SHARPEN_PROP = 0
D2D1_SHARPEN_PROP_THRESHOLD: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SHARPEN_PROP = 1
class D2D1_SIMPLE_COLOR_PROFILE(Structure):
    redPrimary: win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_POINT_2F
    greenPrimary: win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_POINT_2F
    bluePrimary: win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_POINT_2F
    whitePointXZ: win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_POINT_2F
    gamma: win32more.Windows.Win32.Graphics.Direct2D.D2D1_GAMMA1
D2D1_SPOTDIFFUSE_PROP = Int32
D2D1_SPOTDIFFUSE_PROP_LIGHT_POSITION: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SPOTDIFFUSE_PROP = 0
D2D1_SPOTDIFFUSE_PROP_POINTS_AT: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SPOTDIFFUSE_PROP = 1
D2D1_SPOTDIFFUSE_PROP_FOCUS: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SPOTDIFFUSE_PROP = 2
D2D1_SPOTDIFFUSE_PROP_LIMITING_CONE_ANGLE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SPOTDIFFUSE_PROP = 3
D2D1_SPOTDIFFUSE_PROP_DIFFUSE_CONSTANT: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SPOTDIFFUSE_PROP = 4
D2D1_SPOTDIFFUSE_PROP_SURFACE_SCALE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SPOTDIFFUSE_PROP = 5
D2D1_SPOTDIFFUSE_PROP_COLOR: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SPOTDIFFUSE_PROP = 6
D2D1_SPOTDIFFUSE_PROP_KERNEL_UNIT_LENGTH: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SPOTDIFFUSE_PROP = 7
D2D1_SPOTDIFFUSE_PROP_SCALE_MODE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SPOTDIFFUSE_PROP = 8
D2D1_SPOTDIFFUSE_SCALE_MODE = Int32
D2D1_SPOTDIFFUSE_SCALE_MODE_NEAREST_NEIGHBOR: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SPOTDIFFUSE_SCALE_MODE = 0
D2D1_SPOTDIFFUSE_SCALE_MODE_LINEAR: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SPOTDIFFUSE_SCALE_MODE = 1
D2D1_SPOTDIFFUSE_SCALE_MODE_CUBIC: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SPOTDIFFUSE_SCALE_MODE = 2
D2D1_SPOTDIFFUSE_SCALE_MODE_MULTI_SAMPLE_LINEAR: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SPOTDIFFUSE_SCALE_MODE = 3
D2D1_SPOTDIFFUSE_SCALE_MODE_ANISOTROPIC: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SPOTDIFFUSE_SCALE_MODE = 4
D2D1_SPOTDIFFUSE_SCALE_MODE_HIGH_QUALITY_CUBIC: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SPOTDIFFUSE_SCALE_MODE = 5
D2D1_SPOTSPECULAR_PROP = Int32
D2D1_SPOTSPECULAR_PROP_LIGHT_POSITION: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SPOTSPECULAR_PROP = 0
D2D1_SPOTSPECULAR_PROP_POINTS_AT: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SPOTSPECULAR_PROP = 1
D2D1_SPOTSPECULAR_PROP_FOCUS: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SPOTSPECULAR_PROP = 2
D2D1_SPOTSPECULAR_PROP_LIMITING_CONE_ANGLE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SPOTSPECULAR_PROP = 3
D2D1_SPOTSPECULAR_PROP_SPECULAR_EXPONENT: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SPOTSPECULAR_PROP = 4
D2D1_SPOTSPECULAR_PROP_SPECULAR_CONSTANT: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SPOTSPECULAR_PROP = 5
D2D1_SPOTSPECULAR_PROP_SURFACE_SCALE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SPOTSPECULAR_PROP = 6
D2D1_SPOTSPECULAR_PROP_COLOR: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SPOTSPECULAR_PROP = 7
D2D1_SPOTSPECULAR_PROP_KERNEL_UNIT_LENGTH: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SPOTSPECULAR_PROP = 8
D2D1_SPOTSPECULAR_PROP_SCALE_MODE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SPOTSPECULAR_PROP = 9
D2D1_SPOTSPECULAR_SCALE_MODE = Int32
D2D1_SPOTSPECULAR_SCALE_MODE_NEAREST_NEIGHBOR: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SPOTSPECULAR_SCALE_MODE = 0
D2D1_SPOTSPECULAR_SCALE_MODE_LINEAR: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SPOTSPECULAR_SCALE_MODE = 1
D2D1_SPOTSPECULAR_SCALE_MODE_CUBIC: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SPOTSPECULAR_SCALE_MODE = 2
D2D1_SPOTSPECULAR_SCALE_MODE_MULTI_SAMPLE_LINEAR: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SPOTSPECULAR_SCALE_MODE = 3
D2D1_SPOTSPECULAR_SCALE_MODE_ANISOTROPIC: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SPOTSPECULAR_SCALE_MODE = 4
D2D1_SPOTSPECULAR_SCALE_MODE_HIGH_QUALITY_CUBIC: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SPOTSPECULAR_SCALE_MODE = 5
D2D1_SPRITE_OPTIONS = Int32
D2D1_SPRITE_OPTIONS_NONE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SPRITE_OPTIONS = 0
D2D1_SPRITE_OPTIONS_CLAMP_TO_SOURCE_RECTANGLE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SPRITE_OPTIONS = 1
D2D1_STRAIGHTEN_PROP = Int32
D2D1_STRAIGHTEN_PROP_ANGLE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_STRAIGHTEN_PROP = 0
D2D1_STRAIGHTEN_PROP_MAINTAIN_SIZE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_STRAIGHTEN_PROP = 1
D2D1_STRAIGHTEN_PROP_SCALE_MODE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_STRAIGHTEN_PROP = 2
D2D1_STRAIGHTEN_SCALE_MODE = Int32
D2D1_STRAIGHTEN_SCALE_MODE_NEAREST_NEIGHBOR: win32more.Windows.Win32.Graphics.Direct2D.D2D1_STRAIGHTEN_SCALE_MODE = 0
D2D1_STRAIGHTEN_SCALE_MODE_LINEAR: win32more.Windows.Win32.Graphics.Direct2D.D2D1_STRAIGHTEN_SCALE_MODE = 1
D2D1_STRAIGHTEN_SCALE_MODE_CUBIC: win32more.Windows.Win32.Graphics.Direct2D.D2D1_STRAIGHTEN_SCALE_MODE = 2
D2D1_STRAIGHTEN_SCALE_MODE_MULTI_SAMPLE_LINEAR: win32more.Windows.Win32.Graphics.Direct2D.D2D1_STRAIGHTEN_SCALE_MODE = 3
D2D1_STRAIGHTEN_SCALE_MODE_ANISOTROPIC: win32more.Windows.Win32.Graphics.Direct2D.D2D1_STRAIGHTEN_SCALE_MODE = 4
class D2D1_STROKE_STYLE_PROPERTIES(Structure):
    startCap: win32more.Windows.Win32.Graphics.Direct2D.D2D1_CAP_STYLE
    endCap: win32more.Windows.Win32.Graphics.Direct2D.D2D1_CAP_STYLE
    dashCap: win32more.Windows.Win32.Graphics.Direct2D.D2D1_CAP_STYLE
    lineJoin: win32more.Windows.Win32.Graphics.Direct2D.D2D1_LINE_JOIN
    miterLimit: Single
    dashStyle: win32more.Windows.Win32.Graphics.Direct2D.D2D1_DASH_STYLE
    dashOffset: Single
class D2D1_STROKE_STYLE_PROPERTIES1(Structure):
    startCap: win32more.Windows.Win32.Graphics.Direct2D.D2D1_CAP_STYLE
    endCap: win32more.Windows.Win32.Graphics.Direct2D.D2D1_CAP_STYLE
    dashCap: win32more.Windows.Win32.Graphics.Direct2D.D2D1_CAP_STYLE
    lineJoin: win32more.Windows.Win32.Graphics.Direct2D.D2D1_LINE_JOIN
    miterLimit: Single
    dashStyle: win32more.Windows.Win32.Graphics.Direct2D.D2D1_DASH_STYLE
    dashOffset: Single
    transformType: win32more.Windows.Win32.Graphics.Direct2D.D2D1_STROKE_TRANSFORM_TYPE
D2D1_STROKE_TRANSFORM_TYPE = Int32
D2D1_STROKE_TRANSFORM_TYPE_NORMAL: win32more.Windows.Win32.Graphics.Direct2D.D2D1_STROKE_TRANSFORM_TYPE = 0
D2D1_STROKE_TRANSFORM_TYPE_FIXED: win32more.Windows.Win32.Graphics.Direct2D.D2D1_STROKE_TRANSFORM_TYPE = 1
D2D1_STROKE_TRANSFORM_TYPE_HAIRLINE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_STROKE_TRANSFORM_TYPE = 2
D2D1_SUBPROPERTY = Int32
D2D1_SUBPROPERTY_DISPLAYNAME: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SUBPROPERTY = -2147483648
D2D1_SUBPROPERTY_ISREADONLY: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SUBPROPERTY = -2147483647
D2D1_SUBPROPERTY_MIN: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SUBPROPERTY = -2147483646
D2D1_SUBPROPERTY_MAX: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SUBPROPERTY = -2147483645
D2D1_SUBPROPERTY_DEFAULT: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SUBPROPERTY = -2147483644
D2D1_SUBPROPERTY_FIELDS: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SUBPROPERTY = -2147483643
D2D1_SUBPROPERTY_INDEX: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SUBPROPERTY = -2147483642
D2D1_SVG_ASPECT_ALIGN = Int32
D2D1_SVG_ASPECT_ALIGN_NONE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SVG_ASPECT_ALIGN = 0
D2D1_SVG_ASPECT_ALIGN_X_MIN_Y_MIN: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SVG_ASPECT_ALIGN = 1
D2D1_SVG_ASPECT_ALIGN_X_MID_Y_MIN: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SVG_ASPECT_ALIGN = 2
D2D1_SVG_ASPECT_ALIGN_X_MAX_Y_MIN: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SVG_ASPECT_ALIGN = 3
D2D1_SVG_ASPECT_ALIGN_X_MIN_Y_MID: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SVG_ASPECT_ALIGN = 4
D2D1_SVG_ASPECT_ALIGN_X_MID_Y_MID: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SVG_ASPECT_ALIGN = 5
D2D1_SVG_ASPECT_ALIGN_X_MAX_Y_MID: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SVG_ASPECT_ALIGN = 6
D2D1_SVG_ASPECT_ALIGN_X_MIN_Y_MAX: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SVG_ASPECT_ALIGN = 7
D2D1_SVG_ASPECT_ALIGN_X_MID_Y_MAX: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SVG_ASPECT_ALIGN = 8
D2D1_SVG_ASPECT_ALIGN_X_MAX_Y_MAX: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SVG_ASPECT_ALIGN = 9
D2D1_SVG_ASPECT_SCALING = Int32
D2D1_SVG_ASPECT_SCALING_MEET: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SVG_ASPECT_SCALING = 0
D2D1_SVG_ASPECT_SCALING_SLICE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SVG_ASPECT_SCALING = 1
D2D1_SVG_ATTRIBUTE_POD_TYPE = Int32
D2D1_SVG_ATTRIBUTE_POD_TYPE_FLOAT: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SVG_ATTRIBUTE_POD_TYPE = 0
D2D1_SVG_ATTRIBUTE_POD_TYPE_COLOR: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SVG_ATTRIBUTE_POD_TYPE = 1
D2D1_SVG_ATTRIBUTE_POD_TYPE_FILL_MODE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SVG_ATTRIBUTE_POD_TYPE = 2
D2D1_SVG_ATTRIBUTE_POD_TYPE_DISPLAY: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SVG_ATTRIBUTE_POD_TYPE = 3
D2D1_SVG_ATTRIBUTE_POD_TYPE_OVERFLOW: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SVG_ATTRIBUTE_POD_TYPE = 4
D2D1_SVG_ATTRIBUTE_POD_TYPE_LINE_CAP: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SVG_ATTRIBUTE_POD_TYPE = 5
D2D1_SVG_ATTRIBUTE_POD_TYPE_LINE_JOIN: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SVG_ATTRIBUTE_POD_TYPE = 6
D2D1_SVG_ATTRIBUTE_POD_TYPE_VISIBILITY: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SVG_ATTRIBUTE_POD_TYPE = 7
D2D1_SVG_ATTRIBUTE_POD_TYPE_MATRIX: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SVG_ATTRIBUTE_POD_TYPE = 8
D2D1_SVG_ATTRIBUTE_POD_TYPE_UNIT_TYPE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SVG_ATTRIBUTE_POD_TYPE = 9
D2D1_SVG_ATTRIBUTE_POD_TYPE_EXTEND_MODE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SVG_ATTRIBUTE_POD_TYPE = 10
D2D1_SVG_ATTRIBUTE_POD_TYPE_PRESERVE_ASPECT_RATIO: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SVG_ATTRIBUTE_POD_TYPE = 11
D2D1_SVG_ATTRIBUTE_POD_TYPE_VIEWBOX: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SVG_ATTRIBUTE_POD_TYPE = 12
D2D1_SVG_ATTRIBUTE_POD_TYPE_LENGTH: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SVG_ATTRIBUTE_POD_TYPE = 13
D2D1_SVG_ATTRIBUTE_STRING_TYPE = Int32
D2D1_SVG_ATTRIBUTE_STRING_TYPE_SVG: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SVG_ATTRIBUTE_STRING_TYPE = 0
D2D1_SVG_ATTRIBUTE_STRING_TYPE_ID: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SVG_ATTRIBUTE_STRING_TYPE = 1
D2D1_SVG_DISPLAY = Int32
D2D1_SVG_DISPLAY_INLINE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SVG_DISPLAY = 0
D2D1_SVG_DISPLAY_NONE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SVG_DISPLAY = 1
class D2D1_SVG_LENGTH(Structure):
    value: Single
    units: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SVG_LENGTH_UNITS
D2D1_SVG_LENGTH_UNITS = Int32
D2D1_SVG_LENGTH_UNITS_NUMBER: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SVG_LENGTH_UNITS = 0
D2D1_SVG_LENGTH_UNITS_PERCENTAGE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SVG_LENGTH_UNITS = 1
D2D1_SVG_LINE_CAP = Int32
D2D1_SVG_LINE_CAP_BUTT: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SVG_LINE_CAP = 0
D2D1_SVG_LINE_CAP_SQUARE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SVG_LINE_CAP = 1
D2D1_SVG_LINE_CAP_ROUND: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SVG_LINE_CAP = 2
D2D1_SVG_LINE_JOIN = Int32
D2D1_SVG_LINE_JOIN_BEVEL: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SVG_LINE_JOIN = 1
D2D1_SVG_LINE_JOIN_MITER: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SVG_LINE_JOIN = 3
D2D1_SVG_LINE_JOIN_ROUND: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SVG_LINE_JOIN = 2
D2D1_SVG_OVERFLOW = Int32
D2D1_SVG_OVERFLOW_VISIBLE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SVG_OVERFLOW = 0
D2D1_SVG_OVERFLOW_HIDDEN: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SVG_OVERFLOW = 1
D2D1_SVG_PAINT_TYPE = Int32
D2D1_SVG_PAINT_TYPE_NONE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SVG_PAINT_TYPE = 0
D2D1_SVG_PAINT_TYPE_COLOR: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SVG_PAINT_TYPE = 1
D2D1_SVG_PAINT_TYPE_CURRENT_COLOR: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SVG_PAINT_TYPE = 2
D2D1_SVG_PAINT_TYPE_URI: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SVG_PAINT_TYPE = 3
D2D1_SVG_PAINT_TYPE_URI_NONE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SVG_PAINT_TYPE = 4
D2D1_SVG_PAINT_TYPE_URI_COLOR: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SVG_PAINT_TYPE = 5
D2D1_SVG_PAINT_TYPE_URI_CURRENT_COLOR: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SVG_PAINT_TYPE = 6
D2D1_SVG_PATH_COMMAND = Int32
D2D1_SVG_PATH_COMMAND_CLOSE_PATH: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SVG_PATH_COMMAND = 0
D2D1_SVG_PATH_COMMAND_MOVE_ABSOLUTE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SVG_PATH_COMMAND = 1
D2D1_SVG_PATH_COMMAND_MOVE_RELATIVE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SVG_PATH_COMMAND = 2
D2D1_SVG_PATH_COMMAND_LINE_ABSOLUTE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SVG_PATH_COMMAND = 3
D2D1_SVG_PATH_COMMAND_LINE_RELATIVE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SVG_PATH_COMMAND = 4
D2D1_SVG_PATH_COMMAND_CUBIC_ABSOLUTE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SVG_PATH_COMMAND = 5
D2D1_SVG_PATH_COMMAND_CUBIC_RELATIVE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SVG_PATH_COMMAND = 6
D2D1_SVG_PATH_COMMAND_QUADRADIC_ABSOLUTE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SVG_PATH_COMMAND = 7
D2D1_SVG_PATH_COMMAND_QUADRADIC_RELATIVE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SVG_PATH_COMMAND = 8
D2D1_SVG_PATH_COMMAND_ARC_ABSOLUTE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SVG_PATH_COMMAND = 9
D2D1_SVG_PATH_COMMAND_ARC_RELATIVE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SVG_PATH_COMMAND = 10
D2D1_SVG_PATH_COMMAND_HORIZONTAL_ABSOLUTE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SVG_PATH_COMMAND = 11
D2D1_SVG_PATH_COMMAND_HORIZONTAL_RELATIVE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SVG_PATH_COMMAND = 12
D2D1_SVG_PATH_COMMAND_VERTICAL_ABSOLUTE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SVG_PATH_COMMAND = 13
D2D1_SVG_PATH_COMMAND_VERTICAL_RELATIVE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SVG_PATH_COMMAND = 14
D2D1_SVG_PATH_COMMAND_CUBIC_SMOOTH_ABSOLUTE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SVG_PATH_COMMAND = 15
D2D1_SVG_PATH_COMMAND_CUBIC_SMOOTH_RELATIVE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SVG_PATH_COMMAND = 16
D2D1_SVG_PATH_COMMAND_QUADRADIC_SMOOTH_ABSOLUTE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SVG_PATH_COMMAND = 17
D2D1_SVG_PATH_COMMAND_QUADRADIC_SMOOTH_RELATIVE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SVG_PATH_COMMAND = 18
class D2D1_SVG_PRESERVE_ASPECT_RATIO(Structure):
    defer: win32more.Windows.Win32.Foundation.BOOL
    align: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SVG_ASPECT_ALIGN
    meetOrSlice: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SVG_ASPECT_SCALING
D2D1_SVG_UNIT_TYPE = Int32
D2D1_SVG_UNIT_TYPE_USER_SPACE_ON_USE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SVG_UNIT_TYPE = 0
D2D1_SVG_UNIT_TYPE_OBJECT_BOUNDING_BOX: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SVG_UNIT_TYPE = 1
class D2D1_SVG_VIEWBOX(Structure):
    x: Single
    y: Single
    width: Single
    height: Single
D2D1_SVG_VISIBILITY = Int32
D2D1_SVG_VISIBILITY_VISIBLE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SVG_VISIBILITY = 0
D2D1_SVG_VISIBILITY_HIDDEN: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SVG_VISIBILITY = 1
D2D1_SWEEP_DIRECTION = Int32
D2D1_SWEEP_DIRECTION_COUNTER_CLOCKWISE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SWEEP_DIRECTION = 0
D2D1_SWEEP_DIRECTION_CLOCKWISE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SWEEP_DIRECTION = 1
D2D1_TABLETRANSFER_PROP = Int32
D2D1_TABLETRANSFER_PROP_RED_TABLE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_TABLETRANSFER_PROP = 0
D2D1_TABLETRANSFER_PROP_RED_DISABLE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_TABLETRANSFER_PROP = 1
D2D1_TABLETRANSFER_PROP_GREEN_TABLE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_TABLETRANSFER_PROP = 2
D2D1_TABLETRANSFER_PROP_GREEN_DISABLE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_TABLETRANSFER_PROP = 3
D2D1_TABLETRANSFER_PROP_BLUE_TABLE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_TABLETRANSFER_PROP = 4
D2D1_TABLETRANSFER_PROP_BLUE_DISABLE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_TABLETRANSFER_PROP = 5
D2D1_TABLETRANSFER_PROP_ALPHA_TABLE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_TABLETRANSFER_PROP = 6
D2D1_TABLETRANSFER_PROP_ALPHA_DISABLE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_TABLETRANSFER_PROP = 7
D2D1_TABLETRANSFER_PROP_CLAMP_OUTPUT: win32more.Windows.Win32.Graphics.Direct2D.D2D1_TABLETRANSFER_PROP = 8
D2D1_TEMPERATUREANDTINT_PROP = Int32
D2D1_TEMPERATUREANDTINT_PROP_TEMPERATURE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_TEMPERATUREANDTINT_PROP = 0
D2D1_TEMPERATUREANDTINT_PROP_TINT: win32more.Windows.Win32.Graphics.Direct2D.D2D1_TEMPERATUREANDTINT_PROP = 1
D2D1_TEXT_ANTIALIAS_MODE = Int32
D2D1_TEXT_ANTIALIAS_MODE_DEFAULT: win32more.Windows.Win32.Graphics.Direct2D.D2D1_TEXT_ANTIALIAS_MODE = 0
D2D1_TEXT_ANTIALIAS_MODE_CLEARTYPE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_TEXT_ANTIALIAS_MODE = 1
D2D1_TEXT_ANTIALIAS_MODE_GRAYSCALE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_TEXT_ANTIALIAS_MODE = 2
D2D1_TEXT_ANTIALIAS_MODE_ALIASED: win32more.Windows.Win32.Graphics.Direct2D.D2D1_TEXT_ANTIALIAS_MODE = 3
D2D1_THREADING_MODE = Int32
D2D1_THREADING_MODE_SINGLE_THREADED: win32more.Windows.Win32.Graphics.Direct2D.D2D1_THREADING_MODE = 0
D2D1_THREADING_MODE_MULTI_THREADED: win32more.Windows.Win32.Graphics.Direct2D.D2D1_THREADING_MODE = 1
D2D1_TILE_PROP = Int32
D2D1_TILE_PROP_RECT: win32more.Windows.Win32.Graphics.Direct2D.D2D1_TILE_PROP = 0
D2D1_TINT_PROP = Int32
D2D1_TINT_PROP_COLOR: win32more.Windows.Win32.Graphics.Direct2D.D2D1_TINT_PROP = 0
D2D1_TINT_PROP_CLAMP_OUTPUT: win32more.Windows.Win32.Graphics.Direct2D.D2D1_TINT_PROP = 1
D2D1_TRANSFORMED_IMAGE_SOURCE_OPTIONS = Int32
D2D1_TRANSFORMED_IMAGE_SOURCE_OPTIONS_NONE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_TRANSFORMED_IMAGE_SOURCE_OPTIONS = 0
D2D1_TRANSFORMED_IMAGE_SOURCE_OPTIONS_DISABLE_DPI_SCALE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_TRANSFORMED_IMAGE_SOURCE_OPTIONS = 1
class D2D1_TRANSFORMED_IMAGE_SOURCE_PROPERTIES(Structure):
    orientation: win32more.Windows.Win32.Graphics.Direct2D.D2D1_ORIENTATION
    scaleX: Single
    scaleY: Single
    interpolationMode: win32more.Windows.Win32.Graphics.Direct2D.D2D1_INTERPOLATION_MODE
    options: win32more.Windows.Win32.Graphics.Direct2D.D2D1_TRANSFORMED_IMAGE_SOURCE_OPTIONS
class D2D1_TRIANGLE(Structure):
    point1: win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_POINT_2F
    point2: win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_POINT_2F
    point3: win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_POINT_2F
D2D1_TURBULENCE_PROP = Int32
D2D1_TURBULENCE_PROP_OFFSET: win32more.Windows.Win32.Graphics.Direct2D.D2D1_TURBULENCE_PROP = 0
D2D1_TURBULENCE_PROP_SIZE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_TURBULENCE_PROP = 1
D2D1_TURBULENCE_PROP_BASE_FREQUENCY: win32more.Windows.Win32.Graphics.Direct2D.D2D1_TURBULENCE_PROP = 2
D2D1_TURBULENCE_PROP_NUM_OCTAVES: win32more.Windows.Win32.Graphics.Direct2D.D2D1_TURBULENCE_PROP = 3
D2D1_TURBULENCE_PROP_SEED: win32more.Windows.Win32.Graphics.Direct2D.D2D1_TURBULENCE_PROP = 4
D2D1_TURBULENCE_PROP_NOISE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_TURBULENCE_PROP = 5
D2D1_TURBULENCE_PROP_STITCHABLE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_TURBULENCE_PROP = 6
D2D1_UNIT_MODE = Int32
D2D1_UNIT_MODE_DIPS: win32more.Windows.Win32.Graphics.Direct2D.D2D1_UNIT_MODE = 0
D2D1_UNIT_MODE_PIXELS: win32more.Windows.Win32.Graphics.Direct2D.D2D1_UNIT_MODE = 1
class D2D1_VERTEX_BUFFER_PROPERTIES(Structure):
    inputCount: UInt32
    usage: win32more.Windows.Win32.Graphics.Direct2D.D2D1_VERTEX_USAGE
    data: POINTER(Byte)
    byteWidth: UInt32
D2D1_VERTEX_OPTIONS = Int32
D2D1_VERTEX_OPTIONS_NONE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_VERTEX_OPTIONS = 0
D2D1_VERTEX_OPTIONS_DO_NOT_CLEAR: win32more.Windows.Win32.Graphics.Direct2D.D2D1_VERTEX_OPTIONS = 1
D2D1_VERTEX_OPTIONS_USE_DEPTH_BUFFER: win32more.Windows.Win32.Graphics.Direct2D.D2D1_VERTEX_OPTIONS = 2
D2D1_VERTEX_OPTIONS_ASSUME_NO_OVERLAP: win32more.Windows.Win32.Graphics.Direct2D.D2D1_VERTEX_OPTIONS = 4
class D2D1_VERTEX_RANGE(Structure):
    startVertex: UInt32
    vertexCount: UInt32
D2D1_VERTEX_USAGE = Int32
D2D1_VERTEX_USAGE_STATIC: win32more.Windows.Win32.Graphics.Direct2D.D2D1_VERTEX_USAGE = 0
D2D1_VERTEX_USAGE_DYNAMIC: win32more.Windows.Win32.Graphics.Direct2D.D2D1_VERTEX_USAGE = 1
D2D1_VIGNETTE_PROP = Int32
D2D1_VIGNETTE_PROP_COLOR: win32more.Windows.Win32.Graphics.Direct2D.D2D1_VIGNETTE_PROP = 0
D2D1_VIGNETTE_PROP_TRANSITION_SIZE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_VIGNETTE_PROP = 1
D2D1_VIGNETTE_PROP_STRENGTH: win32more.Windows.Win32.Graphics.Direct2D.D2D1_VIGNETTE_PROP = 2
D2D1_WHITELEVELADJUSTMENT_PROP = Int32
D2D1_WHITELEVELADJUSTMENT_PROP_INPUT_WHITE_LEVEL: win32more.Windows.Win32.Graphics.Direct2D.D2D1_WHITELEVELADJUSTMENT_PROP = 0
D2D1_WHITELEVELADJUSTMENT_PROP_OUTPUT_WHITE_LEVEL: win32more.Windows.Win32.Graphics.Direct2D.D2D1_WHITELEVELADJUSTMENT_PROP = 1
D2D1_WINDOW_STATE = Int32
D2D1_WINDOW_STATE_NONE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_WINDOW_STATE = 0
D2D1_WINDOW_STATE_OCCLUDED: win32more.Windows.Win32.Graphics.Direct2D.D2D1_WINDOW_STATE = 1
D2D1_YCBCR_CHROMA_SUBSAMPLING = Int32
D2D1_YCBCR_CHROMA_SUBSAMPLING_AUTO: win32more.Windows.Win32.Graphics.Direct2D.D2D1_YCBCR_CHROMA_SUBSAMPLING = 0
D2D1_YCBCR_CHROMA_SUBSAMPLING_420: win32more.Windows.Win32.Graphics.Direct2D.D2D1_YCBCR_CHROMA_SUBSAMPLING = 1
D2D1_YCBCR_CHROMA_SUBSAMPLING_422: win32more.Windows.Win32.Graphics.Direct2D.D2D1_YCBCR_CHROMA_SUBSAMPLING = 2
D2D1_YCBCR_CHROMA_SUBSAMPLING_444: win32more.Windows.Win32.Graphics.Direct2D.D2D1_YCBCR_CHROMA_SUBSAMPLING = 3
D2D1_YCBCR_CHROMA_SUBSAMPLING_440: win32more.Windows.Win32.Graphics.Direct2D.D2D1_YCBCR_CHROMA_SUBSAMPLING = 4
D2D1_YCBCR_INTERPOLATION_MODE = Int32
D2D1_YCBCR_INTERPOLATION_MODE_NEAREST_NEIGHBOR: win32more.Windows.Win32.Graphics.Direct2D.D2D1_YCBCR_INTERPOLATION_MODE = 0
D2D1_YCBCR_INTERPOLATION_MODE_LINEAR: win32more.Windows.Win32.Graphics.Direct2D.D2D1_YCBCR_INTERPOLATION_MODE = 1
D2D1_YCBCR_INTERPOLATION_MODE_CUBIC: win32more.Windows.Win32.Graphics.Direct2D.D2D1_YCBCR_INTERPOLATION_MODE = 2
D2D1_YCBCR_INTERPOLATION_MODE_MULTI_SAMPLE_LINEAR: win32more.Windows.Win32.Graphics.Direct2D.D2D1_YCBCR_INTERPOLATION_MODE = 3
D2D1_YCBCR_INTERPOLATION_MODE_ANISOTROPIC: win32more.Windows.Win32.Graphics.Direct2D.D2D1_YCBCR_INTERPOLATION_MODE = 4
D2D1_YCBCR_INTERPOLATION_MODE_HIGH_QUALITY_CUBIC: win32more.Windows.Win32.Graphics.Direct2D.D2D1_YCBCR_INTERPOLATION_MODE = 5
D2D1_YCBCR_PROP = Int32
D2D1_YCBCR_PROP_CHROMA_SUBSAMPLING: win32more.Windows.Win32.Graphics.Direct2D.D2D1_YCBCR_PROP = 0
D2D1_YCBCR_PROP_TRANSFORM_MATRIX: win32more.Windows.Win32.Graphics.Direct2D.D2D1_YCBCR_PROP = 1
D2D1_YCBCR_PROP_INTERPOLATION_MODE: win32more.Windows.Win32.Graphics.Direct2D.D2D1_YCBCR_PROP = 2
class ID2D1AnalysisTransform(ComPtr):
    extends: win32more.Windows.Win32.System.Com.IUnknown
    _iid_ = Guid('{0359dc30-95e6-4568-9055-27720d130e93}')
    @commethod(3)
    def ProcessAnalysisResults(self, analysisData: POINTER(Byte), analysisDataCount: UInt32) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class ID2D1Bitmap(ComPtr):
    extends: win32more.Windows.Win32.Graphics.Direct2D.ID2D1Image
    _iid_ = Guid('{a2296057-ea42-4099-983b-539fb6505426}')
    @commethod(4)
    def GetSize(self) -> win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_SIZE_F: ...
    @commethod(5)
    def GetPixelSize(self) -> win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_SIZE_U: ...
    @commethod(6)
    def GetPixelFormat(self) -> win32more.Windows.Win32.Graphics.Direct2D.Common.D2D1_PIXEL_FORMAT: ...
    @commethod(7)
    def GetDpi(self, dpiX: POINTER(Single), dpiY: POINTER(Single)) -> Void: ...
    @commethod(8)
    def CopyFromBitmap(self, destPoint: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_POINT_2U), bitmap: win32more.Windows.Win32.Graphics.Direct2D.ID2D1Bitmap, srcRect: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_RECT_U)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(9)
    def CopyFromRenderTarget(self, destPoint: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_POINT_2U), renderTarget: win32more.Windows.Win32.Graphics.Direct2D.ID2D1RenderTarget, srcRect: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_RECT_U)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(10)
    def CopyFromMemory(self, dstRect: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_RECT_U), srcData: VoidPtr, pitch: UInt32) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class ID2D1Bitmap1(ComPtr):
    extends: win32more.Windows.Win32.Graphics.Direct2D.ID2D1Bitmap
    _iid_ = Guid('{a898a84c-3873-4588-b08b-ebbf978df041}')
    @commethod(11)
    def GetColorContext(self, colorContext: POINTER(win32more.Windows.Win32.Graphics.Direct2D.ID2D1ColorContext)) -> Void: ...
    @commethod(12)
    def GetOptions(self) -> win32more.Windows.Win32.Graphics.Direct2D.D2D1_BITMAP_OPTIONS: ...
    @commethod(13)
    def GetSurface(self, dxgiSurface: POINTER(win32more.Windows.Win32.Graphics.Dxgi.IDXGISurface)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(14)
    def Map(self, options: win32more.Windows.Win32.Graphics.Direct2D.D2D1_MAP_OPTIONS, mappedRect: POINTER(win32more.Windows.Win32.Graphics.Direct2D.D2D1_MAPPED_RECT)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(15)
    def Unmap(self) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class ID2D1BitmapBrush(ComPtr):
    extends: win32more.Windows.Win32.Graphics.Direct2D.ID2D1Brush
    _iid_ = Guid('{2cd906aa-12e2-11dc-9fed-001143a055f9}')
    @commethod(8)
    def SetExtendModeX(self, extendModeX: win32more.Windows.Win32.Graphics.Direct2D.D2D1_EXTEND_MODE) -> Void: ...
    @commethod(9)
    def SetExtendModeY(self, extendModeY: win32more.Windows.Win32.Graphics.Direct2D.D2D1_EXTEND_MODE) -> Void: ...
    @commethod(10)
    def SetInterpolationMode(self, interpolationMode: win32more.Windows.Win32.Graphics.Direct2D.D2D1_BITMAP_INTERPOLATION_MODE) -> Void: ...
    @commethod(11)
    def SetBitmap(self, bitmap: win32more.Windows.Win32.Graphics.Direct2D.ID2D1Bitmap) -> Void: ...
    @commethod(12)
    def GetExtendModeX(self) -> win32more.Windows.Win32.Graphics.Direct2D.D2D1_EXTEND_MODE: ...
    @commethod(13)
    def GetExtendModeY(self) -> win32more.Windows.Win32.Graphics.Direct2D.D2D1_EXTEND_MODE: ...
    @commethod(14)
    def GetInterpolationMode(self) -> win32more.Windows.Win32.Graphics.Direct2D.D2D1_BITMAP_INTERPOLATION_MODE: ...
    @commethod(15)
    def GetBitmap(self, bitmap: POINTER(win32more.Windows.Win32.Graphics.Direct2D.ID2D1Bitmap)) -> Void: ...
class ID2D1BitmapBrush1(ComPtr):
    extends: win32more.Windows.Win32.Graphics.Direct2D.ID2D1BitmapBrush
    _iid_ = Guid('{41343a53-e41a-49a2-91cd-21793bbb62e5}')
    @commethod(16)
    def SetInterpolationMode1(self, interpolationMode: win32more.Windows.Win32.Graphics.Direct2D.D2D1_INTERPOLATION_MODE) -> Void: ...
    @commethod(17)
    def GetInterpolationMode1(self) -> win32more.Windows.Win32.Graphics.Direct2D.D2D1_INTERPOLATION_MODE: ...
class ID2D1BitmapRenderTarget(ComPtr):
    extends: win32more.Windows.Win32.Graphics.Direct2D.ID2D1RenderTarget
    _iid_ = Guid('{2cd90695-12e2-11dc-9fed-001143a055f9}')
    @commethod(57)
    def GetBitmap(self, bitmap: POINTER(win32more.Windows.Win32.Graphics.Direct2D.ID2D1Bitmap)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class ID2D1BlendTransform(ComPtr):
    extends: win32more.Windows.Win32.Graphics.Direct2D.ID2D1ConcreteTransform
    _iid_ = Guid('{63ac0b32-ba44-450f-8806-7f4ca1ff2f1b}')
    @commethod(6)
    def SetDescription(self, description: POINTER(win32more.Windows.Win32.Graphics.Direct2D.D2D1_BLEND_DESCRIPTION)) -> Void: ...
    @commethod(7)
    def GetDescription(self, description: POINTER(win32more.Windows.Win32.Graphics.Direct2D.D2D1_BLEND_DESCRIPTION)) -> Void: ...
class ID2D1BorderTransform(ComPtr):
    extends: win32more.Windows.Win32.Graphics.Direct2D.ID2D1ConcreteTransform
    _iid_ = Guid('{4998735c-3a19-473c-9781-656847e3a347}')
    @commethod(6)
    def SetExtendModeX(self, extendMode: win32more.Windows.Win32.Graphics.Direct2D.D2D1_EXTEND_MODE) -> Void: ...
    @commethod(7)
    def SetExtendModeY(self, extendMode: win32more.Windows.Win32.Graphics.Direct2D.D2D1_EXTEND_MODE) -> Void: ...
    @commethod(8)
    def GetExtendModeX(self) -> win32more.Windows.Win32.Graphics.Direct2D.D2D1_EXTEND_MODE: ...
    @commethod(9)
    def GetExtendModeY(self) -> win32more.Windows.Win32.Graphics.Direct2D.D2D1_EXTEND_MODE: ...
class ID2D1BoundsAdjustmentTransform(ComPtr):
    extends: win32more.Windows.Win32.Graphics.Direct2D.ID2D1TransformNode
    _iid_ = Guid('{90f732e2-5092-4606-a819-8651970baccd}')
    @commethod(4)
    def SetOutputBounds(self, outputBounds: POINTER(win32more.Windows.Win32.Foundation.RECT)) -> Void: ...
    @commethod(5)
    def GetOutputBounds(self, outputBounds: POINTER(win32more.Windows.Win32.Foundation.RECT)) -> Void: ...
class ID2D1Brush(ComPtr):
    extends: win32more.Windows.Win32.Graphics.Direct2D.ID2D1Resource
    _iid_ = Guid('{2cd906a8-12e2-11dc-9fed-001143a055f9}')
    @commethod(4)
    def SetOpacity(self, opacity: Single) -> Void: ...
    @commethod(5)
    def SetTransform(self, transform: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_MATRIX_3X2_F)) -> Void: ...
    @commethod(6)
    def GetOpacity(self) -> Single: ...
    @commethod(7)
    def GetTransform(self, transform: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_MATRIX_3X2_F)) -> Void: ...
class ID2D1ColorContext(ComPtr):
    extends: win32more.Windows.Win32.Graphics.Direct2D.ID2D1Resource
    _iid_ = Guid('{1c4820bb-5771-4518-a581-2fe4dd0ec657}')
    @commethod(4)
    def GetColorSpace(self) -> win32more.Windows.Win32.Graphics.Direct2D.D2D1_COLOR_SPACE: ...
    @commethod(5)
    def GetProfileSize(self) -> UInt32: ...
    @commethod(6)
    def GetProfile(self, profile: POINTER(Byte), profileSize: UInt32) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class ID2D1ColorContext1(ComPtr):
    extends: win32more.Windows.Win32.Graphics.Direct2D.ID2D1ColorContext
    _iid_ = Guid('{1ab42875-c57f-4be9-bd85-9cd78d6f55ee}')
    @commethod(7)
    def GetColorContextType(self) -> win32more.Windows.Win32.Graphics.Direct2D.D2D1_COLOR_CONTEXT_TYPE: ...
    @commethod(8)
    def GetDXGIColorSpace(self) -> win32more.Windows.Win32.Graphics.Dxgi.Common.DXGI_COLOR_SPACE_TYPE: ...
    @commethod(9)
    def GetSimpleColorProfile(self, simpleProfile: POINTER(win32more.Windows.Win32.Graphics.Direct2D.D2D1_SIMPLE_COLOR_PROFILE)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class ID2D1CommandList(ComPtr):
    extends: win32more.Windows.Win32.Graphics.Direct2D.ID2D1Image
    _iid_ = Guid('{b4f34a19-2383-4d76-94f6-ec343657c3dc}')
    @commethod(4)
    def Stream(self, sink: win32more.Windows.Win32.Graphics.Direct2D.ID2D1CommandSink) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(5)
    def Close(self) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class ID2D1CommandSink(ComPtr):
    extends: win32more.Windows.Win32.System.Com.IUnknown
    _iid_ = Guid('{54d7898a-a061-40a7-bec7-e465bcba2c4f}')
    @commethod(3)
    def BeginDraw(self) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(4)
    def EndDraw(self) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(5)
    def SetAntialiasMode(self, antialiasMode: win32more.Windows.Win32.Graphics.Direct2D.D2D1_ANTIALIAS_MODE) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(6)
    def SetTags(self, tag1: UInt64, tag2: UInt64) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(7)
    def SetTextAntialiasMode(self, textAntialiasMode: win32more.Windows.Win32.Graphics.Direct2D.D2D1_TEXT_ANTIALIAS_MODE) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(8)
    def SetTextRenderingParams(self, textRenderingParams: win32more.Windows.Win32.Graphics.DirectWrite.IDWriteRenderingParams) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(9)
    def SetTransform(self, transform: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_MATRIX_3X2_F)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(10)
    def SetPrimitiveBlend(self, primitiveBlend: win32more.Windows.Win32.Graphics.Direct2D.D2D1_PRIMITIVE_BLEND) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(11)
    def SetUnitMode(self, unitMode: win32more.Windows.Win32.Graphics.Direct2D.D2D1_UNIT_MODE) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(12)
    def Clear(self, color: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D1_COLOR_F)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(13)
    def DrawGlyphRun(self, baselineOrigin: win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_POINT_2F, glyphRun: POINTER(win32more.Windows.Win32.Graphics.DirectWrite.DWRITE_GLYPH_RUN), glyphRunDescription: POINTER(win32more.Windows.Win32.Graphics.DirectWrite.DWRITE_GLYPH_RUN_DESCRIPTION), foregroundBrush: win32more.Windows.Win32.Graphics.Direct2D.ID2D1Brush, measuringMode: win32more.Windows.Win32.Graphics.DirectWrite.DWRITE_MEASURING_MODE) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(14)
    def DrawLine(self, point0: win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_POINT_2F, point1: win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_POINT_2F, brush: win32more.Windows.Win32.Graphics.Direct2D.ID2D1Brush, strokeWidth: Single, strokeStyle: win32more.Windows.Win32.Graphics.Direct2D.ID2D1StrokeStyle) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(15)
    def DrawGeometry(self, geometry: win32more.Windows.Win32.Graphics.Direct2D.ID2D1Geometry, brush: win32more.Windows.Win32.Graphics.Direct2D.ID2D1Brush, strokeWidth: Single, strokeStyle: win32more.Windows.Win32.Graphics.Direct2D.ID2D1StrokeStyle) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(16)
    def DrawRectangle(self, rect: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_RECT_F), brush: win32more.Windows.Win32.Graphics.Direct2D.ID2D1Brush, strokeWidth: Single, strokeStyle: win32more.Windows.Win32.Graphics.Direct2D.ID2D1StrokeStyle) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(17)
    def DrawBitmap(self, bitmap: win32more.Windows.Win32.Graphics.Direct2D.ID2D1Bitmap, destinationRectangle: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_RECT_F), opacity: Single, interpolationMode: win32more.Windows.Win32.Graphics.Direct2D.D2D1_INTERPOLATION_MODE, sourceRectangle: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_RECT_F), perspectiveTransform: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_MATRIX_4X4_F)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(18)
    def DrawImage(self, image: win32more.Windows.Win32.Graphics.Direct2D.ID2D1Image, targetOffset: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_POINT_2F), imageRectangle: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_RECT_F), interpolationMode: win32more.Windows.Win32.Graphics.Direct2D.D2D1_INTERPOLATION_MODE, compositeMode: win32more.Windows.Win32.Graphics.Direct2D.Common.D2D1_COMPOSITE_MODE) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(19)
    def DrawGdiMetafile(self, gdiMetafile: win32more.Windows.Win32.Graphics.Direct2D.ID2D1GdiMetafile, targetOffset: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_POINT_2F)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(20)
    def FillMesh(self, mesh: win32more.Windows.Win32.Graphics.Direct2D.ID2D1Mesh, brush: win32more.Windows.Win32.Graphics.Direct2D.ID2D1Brush) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(21)
    def FillOpacityMask(self, opacityMask: win32more.Windows.Win32.Graphics.Direct2D.ID2D1Bitmap, brush: win32more.Windows.Win32.Graphics.Direct2D.ID2D1Brush, destinationRectangle: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_RECT_F), sourceRectangle: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_RECT_F)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(22)
    def FillGeometry(self, geometry: win32more.Windows.Win32.Graphics.Direct2D.ID2D1Geometry, brush: win32more.Windows.Win32.Graphics.Direct2D.ID2D1Brush, opacityBrush: win32more.Windows.Win32.Graphics.Direct2D.ID2D1Brush) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(23)
    def FillRectangle(self, rect: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_RECT_F), brush: win32more.Windows.Win32.Graphics.Direct2D.ID2D1Brush) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(24)
    def PushAxisAlignedClip(self, clipRect: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_RECT_F), antialiasMode: win32more.Windows.Win32.Graphics.Direct2D.D2D1_ANTIALIAS_MODE) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(25)
    def PushLayer(self, layerParameters1: POINTER(win32more.Windows.Win32.Graphics.Direct2D.D2D1_LAYER_PARAMETERS1), layer: win32more.Windows.Win32.Graphics.Direct2D.ID2D1Layer) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(26)
    def PopAxisAlignedClip(self) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(27)
    def PopLayer(self) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class ID2D1CommandSink1(ComPtr):
    extends: win32more.Windows.Win32.Graphics.Direct2D.ID2D1CommandSink
    _iid_ = Guid('{9eb767fd-4269-4467-b8c2-eb30cb305743}')
    @commethod(28)
    def SetPrimitiveBlend1(self, primitiveBlend: win32more.Windows.Win32.Graphics.Direct2D.D2D1_PRIMITIVE_BLEND) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class ID2D1CommandSink2(ComPtr):
    extends: win32more.Windows.Win32.Graphics.Direct2D.ID2D1CommandSink1
    _iid_ = Guid('{3bab440e-417e-47df-a2e2-bc0be6a00916}')
    @commethod(29)
    def DrawInk(self, ink: win32more.Windows.Win32.Graphics.Direct2D.ID2D1Ink, brush: win32more.Windows.Win32.Graphics.Direct2D.ID2D1Brush, inkStyle: win32more.Windows.Win32.Graphics.Direct2D.ID2D1InkStyle) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(30)
    def DrawGradientMesh(self, gradientMesh: win32more.Windows.Win32.Graphics.Direct2D.ID2D1GradientMesh) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(31)
    def DrawGdiMetafile(self, gdiMetafile: win32more.Windows.Win32.Graphics.Direct2D.ID2D1GdiMetafile, destinationRectangle: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_RECT_F), sourceRectangle: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_RECT_F)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class ID2D1CommandSink3(ComPtr):
    extends: win32more.Windows.Win32.Graphics.Direct2D.ID2D1CommandSink2
    _iid_ = Guid('{18079135-4cf3-4868-bc8e-06067e6d242d}')
    @commethod(32)
    def DrawSpriteBatch(self, spriteBatch: win32more.Windows.Win32.Graphics.Direct2D.ID2D1SpriteBatch, startIndex: UInt32, spriteCount: UInt32, bitmap: win32more.Windows.Win32.Graphics.Direct2D.ID2D1Bitmap, interpolationMode: win32more.Windows.Win32.Graphics.Direct2D.D2D1_BITMAP_INTERPOLATION_MODE, spriteOptions: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SPRITE_OPTIONS) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class ID2D1CommandSink4(ComPtr):
    extends: win32more.Windows.Win32.Graphics.Direct2D.ID2D1CommandSink3
    _iid_ = Guid('{c78a6519-40d6-4218-b2de-beeeb744bb3e}')
    @commethod(33)
    def SetPrimitiveBlend2(self, primitiveBlend: win32more.Windows.Win32.Graphics.Direct2D.D2D1_PRIMITIVE_BLEND) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class ID2D1CommandSink5(ComPtr):
    extends: win32more.Windows.Win32.Graphics.Direct2D.ID2D1CommandSink4
    _iid_ = Guid('{7047dd26-b1e7-44a7-959a-8349e2144fa8}')
    @commethod(34)
    def BlendImage(self, image: win32more.Windows.Win32.Graphics.Direct2D.ID2D1Image, blendMode: win32more.Windows.Win32.Graphics.Direct2D.Common.D2D1_BLEND_MODE, targetOffset: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_POINT_2F), imageRectangle: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_RECT_F), interpolationMode: win32more.Windows.Win32.Graphics.Direct2D.D2D1_INTERPOLATION_MODE) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class ID2D1ComputeInfo(ComPtr):
    extends: win32more.Windows.Win32.Graphics.Direct2D.ID2D1RenderInfo
    _iid_ = Guid('{5598b14b-9fd7-48b7-9bdb-8f0964eb38bc}')
    @commethod(7)
    def SetComputeShaderConstantBuffer(self, buffer: POINTER(Byte), bufferCount: UInt32) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(8)
    def SetComputeShader(self, shaderId: POINTER(Guid)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(9)
    def SetResourceTexture(self, textureIndex: UInt32, resourceTexture: win32more.Windows.Win32.Graphics.Direct2D.ID2D1ResourceTexture) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class ID2D1ComputeTransform(ComPtr):
    extends: win32more.Windows.Win32.Graphics.Direct2D.ID2D1Transform
    _iid_ = Guid('{0d85573c-01e3-4f7d-bfd9-0d60608bf3c3}')
    @commethod(7)
    def SetComputeInfo(self, computeInfo: win32more.Windows.Win32.Graphics.Direct2D.ID2D1ComputeInfo) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(8)
    def CalculateThreadgroups(self, outputRect: POINTER(win32more.Windows.Win32.Foundation.RECT), dimensionX: POINTER(UInt32), dimensionY: POINTER(UInt32), dimensionZ: POINTER(UInt32)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class ID2D1ConcreteTransform(ComPtr):
    extends: win32more.Windows.Win32.Graphics.Direct2D.ID2D1TransformNode
    _iid_ = Guid('{1a799d8a-69f7-4e4c-9fed-437ccc6684cc}')
    @commethod(4)
    def SetOutputBuffer(self, bufferPrecision: win32more.Windows.Win32.Graphics.Direct2D.D2D1_BUFFER_PRECISION, channelDepth: win32more.Windows.Win32.Graphics.Direct2D.D2D1_CHANNEL_DEPTH) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(5)
    def SetCached(self, isCached: win32more.Windows.Win32.Foundation.BOOL) -> Void: ...
class ID2D1DCRenderTarget(ComPtr):
    extends: win32more.Windows.Win32.Graphics.Direct2D.ID2D1RenderTarget
    _iid_ = Guid('{1c51bc64-de61-46fd-9899-63a5d8f03950}')
    @commethod(57)
    def BindDC(self, hDC: win32more.Windows.Win32.Graphics.Gdi.HDC, pSubRect: POINTER(win32more.Windows.Win32.Foundation.RECT)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class ID2D1Device(ComPtr):
    extends: win32more.Windows.Win32.Graphics.Direct2D.ID2D1Resource
    _iid_ = Guid('{47dd575d-ac05-4cdd-8049-9b02cd16f44c}')
    @commethod(4)
    def CreateDeviceContext(self, options: win32more.Windows.Win32.Graphics.Direct2D.D2D1_DEVICE_CONTEXT_OPTIONS, deviceContext: POINTER(win32more.Windows.Win32.Graphics.Direct2D.ID2D1DeviceContext)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(5)
    def CreatePrintControl(self, wicFactory: win32more.Windows.Win32.Graphics.Imaging.IWICImagingFactory, documentTarget: win32more.Windows.Win32.Storage.Xps.Printing.IPrintDocumentPackageTarget, printControlProperties: POINTER(win32more.Windows.Win32.Graphics.Direct2D.D2D1_PRINT_CONTROL_PROPERTIES), printControl: POINTER(win32more.Windows.Win32.Graphics.Direct2D.ID2D1PrintControl)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(6)
    def SetMaximumTextureMemory(self, maximumInBytes: UInt64) -> Void: ...
    @commethod(7)
    def GetMaximumTextureMemory(self) -> UInt64: ...
    @commethod(8)
    def ClearResources(self, millisecondsSinceUse: UInt32) -> Void: ...
class ID2D1Device1(ComPtr):
    extends: win32more.Windows.Win32.Graphics.Direct2D.ID2D1Device
    _iid_ = Guid('{d21768e1-23a4-4823-a14b-7c3eba85d658}')
    @commethod(9)
    def GetRenderingPriority(self) -> win32more.Windows.Win32.Graphics.Direct2D.D2D1_RENDERING_PRIORITY: ...
    @commethod(10)
    def SetRenderingPriority(self, renderingPriority: win32more.Windows.Win32.Graphics.Direct2D.D2D1_RENDERING_PRIORITY) -> Void: ...
    @commethod(11)
    def CreateDeviceContext(self, options: win32more.Windows.Win32.Graphics.Direct2D.D2D1_DEVICE_CONTEXT_OPTIONS, deviceContext1: POINTER(win32more.Windows.Win32.Graphics.Direct2D.ID2D1DeviceContext1)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class ID2D1Device2(ComPtr):
    extends: win32more.Windows.Win32.Graphics.Direct2D.ID2D1Device1
    _iid_ = Guid('{a44472e1-8dfb-4e60-8492-6e2861c9ca8b}')
    @commethod(12)
    def CreateDeviceContext(self, options: win32more.Windows.Win32.Graphics.Direct2D.D2D1_DEVICE_CONTEXT_OPTIONS, deviceContext2: POINTER(win32more.Windows.Win32.Graphics.Direct2D.ID2D1DeviceContext2)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(13)
    def FlushDeviceContexts(self, bitmap: win32more.Windows.Win32.Graphics.Direct2D.ID2D1Bitmap) -> Void: ...
    @commethod(14)
    def GetDxgiDevice(self, dxgiDevice: POINTER(win32more.Windows.Win32.Graphics.Dxgi.IDXGIDevice)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class ID2D1Device3(ComPtr):
    extends: win32more.Windows.Win32.Graphics.Direct2D.ID2D1Device2
    _iid_ = Guid('{852f2087-802c-4037-ab60-ff2e7ee6fc01}')
    @commethod(15)
    def CreateDeviceContext(self, options: win32more.Windows.Win32.Graphics.Direct2D.D2D1_DEVICE_CONTEXT_OPTIONS, deviceContext3: POINTER(win32more.Windows.Win32.Graphics.Direct2D.ID2D1DeviceContext3)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class ID2D1Device4(ComPtr):
    extends: win32more.Windows.Win32.Graphics.Direct2D.ID2D1Device3
    _iid_ = Guid('{d7bdb159-5683-4a46-bc9c-72dc720b858b}')
    @commethod(16)
    def CreateDeviceContext(self, options: win32more.Windows.Win32.Graphics.Direct2D.D2D1_DEVICE_CONTEXT_OPTIONS, deviceContext4: POINTER(win32more.Windows.Win32.Graphics.Direct2D.ID2D1DeviceContext4)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(17)
    def SetMaximumColorGlyphCacheMemory(self, maximumInBytes: UInt64) -> Void: ...
    @commethod(18)
    def GetMaximumColorGlyphCacheMemory(self) -> UInt64: ...
class ID2D1Device5(ComPtr):
    extends: win32more.Windows.Win32.Graphics.Direct2D.ID2D1Device4
    _iid_ = Guid('{d55ba0a4-6405-4694-aef5-08ee1a4358b4}')
    @commethod(19)
    def CreateDeviceContext(self, options: win32more.Windows.Win32.Graphics.Direct2D.D2D1_DEVICE_CONTEXT_OPTIONS, deviceContext5: POINTER(win32more.Windows.Win32.Graphics.Direct2D.ID2D1DeviceContext5)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class ID2D1Device6(ComPtr):
    extends: win32more.Windows.Win32.Graphics.Direct2D.ID2D1Device5
    _iid_ = Guid('{7bfef914-2d75-4bad-be87-e18ddb077b6d}')
    @commethod(20)
    def CreateDeviceContext(self, options: win32more.Windows.Win32.Graphics.Direct2D.D2D1_DEVICE_CONTEXT_OPTIONS, deviceContext6: POINTER(win32more.Windows.Win32.Graphics.Direct2D.ID2D1DeviceContext6)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class ID2D1Device7(ComPtr):
    extends: win32more.Windows.Win32.Graphics.Direct2D.ID2D1Device6
    _iid_ = Guid('{f07c8968-dd4e-4ba6-9cbd-eb6d3752dcbb}')
    @commethod(21)
    def CreateDeviceContext(self, options: win32more.Windows.Win32.Graphics.Direct2D.D2D1_DEVICE_CONTEXT_OPTIONS, deviceContext: POINTER(win32more.Windows.Win32.Graphics.Direct2D.ID2D1DeviceContext7)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class ID2D1DeviceContext(ComPtr):
    extends: win32more.Windows.Win32.Graphics.Direct2D.ID2D1RenderTarget
    _iid_ = Guid('{e8f7fe7a-191c-466d-ad95-975678bda998}')
    @commethod(57)
    def CreateBitmap(self, size: win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_SIZE_U, sourceData: VoidPtr, pitch: UInt32, bitmapProperties: POINTER(win32more.Windows.Win32.Graphics.Direct2D.D2D1_BITMAP_PROPERTIES1), bitmap: POINTER(win32more.Windows.Win32.Graphics.Direct2D.ID2D1Bitmap1)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(58)
    def CreateBitmapFromWicBitmap(self, wicBitmapSource: win32more.Windows.Win32.Graphics.Imaging.IWICBitmapSource, bitmapProperties: POINTER(win32more.Windows.Win32.Graphics.Direct2D.D2D1_BITMAP_PROPERTIES1), bitmap: POINTER(win32more.Windows.Win32.Graphics.Direct2D.ID2D1Bitmap1)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(59)
    def CreateColorContext(self, space: win32more.Windows.Win32.Graphics.Direct2D.D2D1_COLOR_SPACE, profile: POINTER(Byte), profileSize: UInt32, colorContext: POINTER(win32more.Windows.Win32.Graphics.Direct2D.ID2D1ColorContext)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(60)
    def CreateColorContextFromFilename(self, filename: win32more.Windows.Win32.Foundation.PWSTR, colorContext: POINTER(win32more.Windows.Win32.Graphics.Direct2D.ID2D1ColorContext)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(61)
    def CreateColorContextFromWicColorContext(self, wicColorContext: win32more.Windows.Win32.Graphics.Imaging.IWICColorContext, colorContext: POINTER(win32more.Windows.Win32.Graphics.Direct2D.ID2D1ColorContext)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(62)
    def CreateBitmapFromDxgiSurface(self, surface: win32more.Windows.Win32.Graphics.Dxgi.IDXGISurface, bitmapProperties: POINTER(win32more.Windows.Win32.Graphics.Direct2D.D2D1_BITMAP_PROPERTIES1), bitmap: POINTER(win32more.Windows.Win32.Graphics.Direct2D.ID2D1Bitmap1)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(63)
    def CreateEffect(self, effectId: POINTER(Guid), effect: POINTER(win32more.Windows.Win32.Graphics.Direct2D.ID2D1Effect)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(64)
    def CreateGradientStopCollection(self, straightAlphaGradientStops: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D1_GRADIENT_STOP), straightAlphaGradientStopsCount: UInt32, preInterpolationSpace: win32more.Windows.Win32.Graphics.Direct2D.D2D1_COLOR_SPACE, postInterpolationSpace: win32more.Windows.Win32.Graphics.Direct2D.D2D1_COLOR_SPACE, bufferPrecision: win32more.Windows.Win32.Graphics.Direct2D.D2D1_BUFFER_PRECISION, extendMode: win32more.Windows.Win32.Graphics.Direct2D.D2D1_EXTEND_MODE, colorInterpolationMode: win32more.Windows.Win32.Graphics.Direct2D.D2D1_COLOR_INTERPOLATION_MODE, gradientStopCollection1: POINTER(win32more.Windows.Win32.Graphics.Direct2D.ID2D1GradientStopCollection1)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(65)
    def CreateImageBrush(self, image: win32more.Windows.Win32.Graphics.Direct2D.ID2D1Image, imageBrushProperties: POINTER(win32more.Windows.Win32.Graphics.Direct2D.D2D1_IMAGE_BRUSH_PROPERTIES), brushProperties: POINTER(win32more.Windows.Win32.Graphics.Direct2D.D2D1_BRUSH_PROPERTIES), imageBrush: POINTER(win32more.Windows.Win32.Graphics.Direct2D.ID2D1ImageBrush)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(66)
    def CreateBitmapBrush(self, bitmap: win32more.Windows.Win32.Graphics.Direct2D.ID2D1Bitmap, bitmapBrushProperties: POINTER(win32more.Windows.Win32.Graphics.Direct2D.D2D1_BITMAP_BRUSH_PROPERTIES1), brushProperties: POINTER(win32more.Windows.Win32.Graphics.Direct2D.D2D1_BRUSH_PROPERTIES), bitmapBrush: POINTER(win32more.Windows.Win32.Graphics.Direct2D.ID2D1BitmapBrush1)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(67)
    def CreateCommandList(self, commandList: POINTER(win32more.Windows.Win32.Graphics.Direct2D.ID2D1CommandList)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(68)
    def IsDxgiFormatSupported(self, format: win32more.Windows.Win32.Graphics.Dxgi.Common.DXGI_FORMAT) -> win32more.Windows.Win32.Foundation.BOOL: ...
    @commethod(69)
    def IsBufferPrecisionSupported(self, bufferPrecision: win32more.Windows.Win32.Graphics.Direct2D.D2D1_BUFFER_PRECISION) -> win32more.Windows.Win32.Foundation.BOOL: ...
    @commethod(70)
    def GetImageLocalBounds(self, image: win32more.Windows.Win32.Graphics.Direct2D.ID2D1Image, localBounds: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_RECT_F)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(71)
    def GetImageWorldBounds(self, image: win32more.Windows.Win32.Graphics.Direct2D.ID2D1Image, worldBounds: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_RECT_F)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(72)
    def GetGlyphRunWorldBounds(self, baselineOrigin: win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_POINT_2F, glyphRun: POINTER(win32more.Windows.Win32.Graphics.DirectWrite.DWRITE_GLYPH_RUN), measuringMode: win32more.Windows.Win32.Graphics.DirectWrite.DWRITE_MEASURING_MODE, bounds: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_RECT_F)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(73)
    def GetDevice(self, device: POINTER(win32more.Windows.Win32.Graphics.Direct2D.ID2D1Device)) -> Void: ...
    @commethod(74)
    def SetTarget(self, image: win32more.Windows.Win32.Graphics.Direct2D.ID2D1Image) -> Void: ...
    @commethod(75)
    def GetTarget(self, image: POINTER(win32more.Windows.Win32.Graphics.Direct2D.ID2D1Image)) -> Void: ...
    @commethod(76)
    def SetRenderingControls(self, renderingControls: POINTER(win32more.Windows.Win32.Graphics.Direct2D.D2D1_RENDERING_CONTROLS)) -> Void: ...
    @commethod(77)
    def GetRenderingControls(self, renderingControls: POINTER(win32more.Windows.Win32.Graphics.Direct2D.D2D1_RENDERING_CONTROLS)) -> Void: ...
    @commethod(78)
    def SetPrimitiveBlend(self, primitiveBlend: win32more.Windows.Win32.Graphics.Direct2D.D2D1_PRIMITIVE_BLEND) -> Void: ...
    @commethod(79)
    def GetPrimitiveBlend(self) -> win32more.Windows.Win32.Graphics.Direct2D.D2D1_PRIMITIVE_BLEND: ...
    @commethod(80)
    def SetUnitMode(self, unitMode: win32more.Windows.Win32.Graphics.Direct2D.D2D1_UNIT_MODE) -> Void: ...
    @commethod(81)
    def GetUnitMode(self) -> win32more.Windows.Win32.Graphics.Direct2D.D2D1_UNIT_MODE: ...
    @commethod(82)
    def DrawGlyphRun(self, baselineOrigin: win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_POINT_2F, glyphRun: POINTER(win32more.Windows.Win32.Graphics.DirectWrite.DWRITE_GLYPH_RUN), glyphRunDescription: POINTER(win32more.Windows.Win32.Graphics.DirectWrite.DWRITE_GLYPH_RUN_DESCRIPTION), foregroundBrush: win32more.Windows.Win32.Graphics.Direct2D.ID2D1Brush, measuringMode: win32more.Windows.Win32.Graphics.DirectWrite.DWRITE_MEASURING_MODE) -> Void: ...
    @commethod(83)
    def DrawImage(self, image: win32more.Windows.Win32.Graphics.Direct2D.ID2D1Image, targetOffset: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_POINT_2F), imageRectangle: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_RECT_F), interpolationMode: win32more.Windows.Win32.Graphics.Direct2D.D2D1_INTERPOLATION_MODE, compositeMode: win32more.Windows.Win32.Graphics.Direct2D.Common.D2D1_COMPOSITE_MODE) -> Void: ...
    @commethod(84)
    def DrawGdiMetafile(self, gdiMetafile: win32more.Windows.Win32.Graphics.Direct2D.ID2D1GdiMetafile, targetOffset: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_POINT_2F)) -> Void: ...
    @commethod(85)
    def DrawBitmap(self, bitmap: win32more.Windows.Win32.Graphics.Direct2D.ID2D1Bitmap, destinationRectangle: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_RECT_F), opacity: Single, interpolationMode: win32more.Windows.Win32.Graphics.Direct2D.D2D1_INTERPOLATION_MODE, sourceRectangle: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_RECT_F), perspectiveTransform: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_MATRIX_4X4_F)) -> Void: ...
    @commethod(86)
    def PushLayer(self, layerParameters: POINTER(win32more.Windows.Win32.Graphics.Direct2D.D2D1_LAYER_PARAMETERS1), layer: win32more.Windows.Win32.Graphics.Direct2D.ID2D1Layer) -> Void: ...
    @commethod(87)
    def InvalidateEffectInputRectangle(self, effect: win32more.Windows.Win32.Graphics.Direct2D.ID2D1Effect, input: UInt32, inputRectangle: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_RECT_F)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(88)
    def GetEffectInvalidRectangleCount(self, effect: win32more.Windows.Win32.Graphics.Direct2D.ID2D1Effect, rectangleCount: POINTER(UInt32)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(89)
    def GetEffectInvalidRectangles(self, effect: win32more.Windows.Win32.Graphics.Direct2D.ID2D1Effect, rectangles: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_RECT_F), rectanglesCount: UInt32) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(90)
    def GetEffectRequiredInputRectangles(self, renderEffect: win32more.Windows.Win32.Graphics.Direct2D.ID2D1Effect, renderImageRectangle: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_RECT_F), inputDescriptions: POINTER(win32more.Windows.Win32.Graphics.Direct2D.D2D1_EFFECT_INPUT_DESCRIPTION), requiredInputRects: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_RECT_F), inputCount: UInt32) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(91)
    def FillOpacityMask(self, opacityMask: win32more.Windows.Win32.Graphics.Direct2D.ID2D1Bitmap, brush: win32more.Windows.Win32.Graphics.Direct2D.ID2D1Brush, destinationRectangle: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_RECT_F), sourceRectangle: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_RECT_F)) -> Void: ...
class ID2D1DeviceContext1(ComPtr):
    extends: win32more.Windows.Win32.Graphics.Direct2D.ID2D1DeviceContext
    _iid_ = Guid('{d37f57e4-6908-459f-a199-e72f24f79987}')
    @commethod(92)
    def CreateFilledGeometryRealization(self, geometry: win32more.Windows.Win32.Graphics.Direct2D.ID2D1Geometry, flatteningTolerance: Single, geometryRealization: POINTER(win32more.Windows.Win32.Graphics.Direct2D.ID2D1GeometryRealization)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(93)
    def CreateStrokedGeometryRealization(self, geometry: win32more.Windows.Win32.Graphics.Direct2D.ID2D1Geometry, flatteningTolerance: Single, strokeWidth: Single, strokeStyle: win32more.Windows.Win32.Graphics.Direct2D.ID2D1StrokeStyle, geometryRealization: POINTER(win32more.Windows.Win32.Graphics.Direct2D.ID2D1GeometryRealization)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(94)
    def DrawGeometryRealization(self, geometryRealization: win32more.Windows.Win32.Graphics.Direct2D.ID2D1GeometryRealization, brush: win32more.Windows.Win32.Graphics.Direct2D.ID2D1Brush) -> Void: ...
class ID2D1DeviceContext2(ComPtr):
    extends: win32more.Windows.Win32.Graphics.Direct2D.ID2D1DeviceContext1
    _iid_ = Guid('{394ea6a3-0c34-4321-950b-6ca20f0be6c7}')
    @commethod(95)
    def CreateInk(self, startPoint: POINTER(win32more.Windows.Win32.Graphics.Direct2D.D2D1_INK_POINT), ink: POINTER(win32more.Windows.Win32.Graphics.Direct2D.ID2D1Ink)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(96)
    def CreateInkStyle(self, inkStyleProperties: POINTER(win32more.Windows.Win32.Graphics.Direct2D.D2D1_INK_STYLE_PROPERTIES), inkStyle: POINTER(win32more.Windows.Win32.Graphics.Direct2D.ID2D1InkStyle)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(97)
    def CreateGradientMesh(self, patches: POINTER(win32more.Windows.Win32.Graphics.Direct2D.D2D1_GRADIENT_MESH_PATCH), patchesCount: UInt32, gradientMesh: POINTER(win32more.Windows.Win32.Graphics.Direct2D.ID2D1GradientMesh)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(98)
    def CreateImageSourceFromWic(self, wicBitmapSource: win32more.Windows.Win32.Graphics.Imaging.IWICBitmapSource, loadingOptions: win32more.Windows.Win32.Graphics.Direct2D.D2D1_IMAGE_SOURCE_LOADING_OPTIONS, alphaMode: win32more.Windows.Win32.Graphics.Direct2D.Common.D2D1_ALPHA_MODE, imageSource: POINTER(win32more.Windows.Win32.Graphics.Direct2D.ID2D1ImageSourceFromWic)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(99)
    def CreateLookupTable3D(self, precision: win32more.Windows.Win32.Graphics.Direct2D.D2D1_BUFFER_PRECISION, extents: POINTER(UInt32), data: POINTER(Byte), dataCount: UInt32, strides: POINTER(UInt32), lookupTable: POINTER(win32more.Windows.Win32.Graphics.Direct2D.ID2D1LookupTable3D)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(100)
    def CreateImageSourceFromDxgi(self, surfaces: POINTER(win32more.Windows.Win32.Graphics.Dxgi.IDXGISurface), surfaceCount: UInt32, colorSpace: win32more.Windows.Win32.Graphics.Dxgi.Common.DXGI_COLOR_SPACE_TYPE, options: win32more.Windows.Win32.Graphics.Direct2D.D2D1_IMAGE_SOURCE_FROM_DXGI_OPTIONS, imageSource: POINTER(win32more.Windows.Win32.Graphics.Direct2D.ID2D1ImageSource)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(101)
    def GetGradientMeshWorldBounds(self, gradientMesh: win32more.Windows.Win32.Graphics.Direct2D.ID2D1GradientMesh, pBounds: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_RECT_F)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(102)
    def DrawInk(self, ink: win32more.Windows.Win32.Graphics.Direct2D.ID2D1Ink, brush: win32more.Windows.Win32.Graphics.Direct2D.ID2D1Brush, inkStyle: win32more.Windows.Win32.Graphics.Direct2D.ID2D1InkStyle) -> Void: ...
    @commethod(103)
    def DrawGradientMesh(self, gradientMesh: win32more.Windows.Win32.Graphics.Direct2D.ID2D1GradientMesh) -> Void: ...
    @commethod(104)
    def DrawGdiMetafile(self, gdiMetafile: win32more.Windows.Win32.Graphics.Direct2D.ID2D1GdiMetafile, destinationRectangle: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_RECT_F), sourceRectangle: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_RECT_F)) -> Void: ...
    @commethod(105)
    def CreateTransformedImageSource(self, imageSource: win32more.Windows.Win32.Graphics.Direct2D.ID2D1ImageSource, properties: POINTER(win32more.Windows.Win32.Graphics.Direct2D.D2D1_TRANSFORMED_IMAGE_SOURCE_PROPERTIES), transformedImageSource: POINTER(win32more.Windows.Win32.Graphics.Direct2D.ID2D1TransformedImageSource)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class ID2D1DeviceContext3(ComPtr):
    extends: win32more.Windows.Win32.Graphics.Direct2D.ID2D1DeviceContext2
    _iid_ = Guid('{235a7496-8351-414c-bcd4-6672ab2d8e00}')
    @commethod(106)
    def CreateSpriteBatch(self, spriteBatch: POINTER(win32more.Windows.Win32.Graphics.Direct2D.ID2D1SpriteBatch)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(107)
    def DrawSpriteBatch(self, spriteBatch: win32more.Windows.Win32.Graphics.Direct2D.ID2D1SpriteBatch, startIndex: UInt32, spriteCount: UInt32, bitmap: win32more.Windows.Win32.Graphics.Direct2D.ID2D1Bitmap, interpolationMode: win32more.Windows.Win32.Graphics.Direct2D.D2D1_BITMAP_INTERPOLATION_MODE, spriteOptions: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SPRITE_OPTIONS) -> Void: ...
class ID2D1DeviceContext4(ComPtr):
    extends: win32more.Windows.Win32.Graphics.Direct2D.ID2D1DeviceContext3
    _iid_ = Guid('{8c427831-3d90-4476-b647-c4fae349e4db}')
    @commethod(108)
    def CreateSvgGlyphStyle(self, svgGlyphStyle: POINTER(win32more.Windows.Win32.Graphics.Direct2D.ID2D1SvgGlyphStyle)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(109)
    def DrawText(self, string: win32more.Windows.Win32.Foundation.PWSTR, stringLength: UInt32, textFormat: win32more.Windows.Win32.Graphics.DirectWrite.IDWriteTextFormat, layoutRect: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_RECT_F), defaultFillBrush: win32more.Windows.Win32.Graphics.Direct2D.ID2D1Brush, svgGlyphStyle: win32more.Windows.Win32.Graphics.Direct2D.ID2D1SvgGlyphStyle, colorPaletteIndex: UInt32, options: win32more.Windows.Win32.Graphics.Direct2D.D2D1_DRAW_TEXT_OPTIONS, measuringMode: win32more.Windows.Win32.Graphics.DirectWrite.DWRITE_MEASURING_MODE) -> Void: ...
    @commethod(110)
    def DrawTextLayout(self, origin: win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_POINT_2F, textLayout: win32more.Windows.Win32.Graphics.DirectWrite.IDWriteTextLayout, defaultFillBrush: win32more.Windows.Win32.Graphics.Direct2D.ID2D1Brush, svgGlyphStyle: win32more.Windows.Win32.Graphics.Direct2D.ID2D1SvgGlyphStyle, colorPaletteIndex: UInt32, options: win32more.Windows.Win32.Graphics.Direct2D.D2D1_DRAW_TEXT_OPTIONS) -> Void: ...
    @commethod(111)
    def DrawColorBitmapGlyphRun(self, glyphImageFormat: win32more.Windows.Win32.Graphics.DirectWrite.DWRITE_GLYPH_IMAGE_FORMATS, baselineOrigin: win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_POINT_2F, glyphRun: POINTER(win32more.Windows.Win32.Graphics.DirectWrite.DWRITE_GLYPH_RUN), measuringMode: win32more.Windows.Win32.Graphics.DirectWrite.DWRITE_MEASURING_MODE, bitmapSnapOption: win32more.Windows.Win32.Graphics.Direct2D.D2D1_COLOR_BITMAP_GLYPH_SNAP_OPTION) -> Void: ...
    @commethod(112)
    def DrawSvgGlyphRun(self, baselineOrigin: win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_POINT_2F, glyphRun: POINTER(win32more.Windows.Win32.Graphics.DirectWrite.DWRITE_GLYPH_RUN), defaultFillBrush: win32more.Windows.Win32.Graphics.Direct2D.ID2D1Brush, svgGlyphStyle: win32more.Windows.Win32.Graphics.Direct2D.ID2D1SvgGlyphStyle, colorPaletteIndex: UInt32, measuringMode: win32more.Windows.Win32.Graphics.DirectWrite.DWRITE_MEASURING_MODE) -> Void: ...
    @commethod(113)
    def GetColorBitmapGlyphImage(self, glyphImageFormat: win32more.Windows.Win32.Graphics.DirectWrite.DWRITE_GLYPH_IMAGE_FORMATS, glyphOrigin: win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_POINT_2F, fontFace: win32more.Windows.Win32.Graphics.DirectWrite.IDWriteFontFace, fontEmSize: Single, glyphIndex: UInt16, isSideways: win32more.Windows.Win32.Foundation.BOOL, worldTransform: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_MATRIX_3X2_F), dpiX: Single, dpiY: Single, glyphTransform: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_MATRIX_3X2_F), glyphImage: POINTER(win32more.Windows.Win32.Graphics.Direct2D.ID2D1Image)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(114)
    def GetSvgGlyphImage(self, glyphOrigin: win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_POINT_2F, fontFace: win32more.Windows.Win32.Graphics.DirectWrite.IDWriteFontFace, fontEmSize: Single, glyphIndex: UInt16, isSideways: win32more.Windows.Win32.Foundation.BOOL, worldTransform: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_MATRIX_3X2_F), defaultFillBrush: win32more.Windows.Win32.Graphics.Direct2D.ID2D1Brush, svgGlyphStyle: win32more.Windows.Win32.Graphics.Direct2D.ID2D1SvgGlyphStyle, colorPaletteIndex: UInt32, glyphTransform: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_MATRIX_3X2_F), glyphImage: POINTER(win32more.Windows.Win32.Graphics.Direct2D.ID2D1CommandList)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class ID2D1DeviceContext5(ComPtr):
    extends: win32more.Windows.Win32.Graphics.Direct2D.ID2D1DeviceContext4
    _iid_ = Guid('{7836d248-68cc-4df6-b9e8-de991bf62eb7}')
    @commethod(115)
    def CreateSvgDocument(self, inputXmlStream: win32more.Windows.Win32.System.Com.IStream, viewportSize: win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_SIZE_F, svgDocument: POINTER(win32more.Windows.Win32.Graphics.Direct2D.ID2D1SvgDocument)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(116)
    def DrawSvgDocument(self, svgDocument: win32more.Windows.Win32.Graphics.Direct2D.ID2D1SvgDocument) -> Void: ...
    @commethod(117)
    def CreateColorContextFromDxgiColorSpace(self, colorSpace: win32more.Windows.Win32.Graphics.Dxgi.Common.DXGI_COLOR_SPACE_TYPE, colorContext: POINTER(win32more.Windows.Win32.Graphics.Direct2D.ID2D1ColorContext1)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(118)
    def CreateColorContextFromSimpleColorProfile(self, simpleProfile: POINTER(win32more.Windows.Win32.Graphics.Direct2D.D2D1_SIMPLE_COLOR_PROFILE), colorContext: POINTER(win32more.Windows.Win32.Graphics.Direct2D.ID2D1ColorContext1)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class ID2D1DeviceContext6(ComPtr):
    extends: win32more.Windows.Win32.Graphics.Direct2D.ID2D1DeviceContext5
    _iid_ = Guid('{985f7e37-4ed0-4a19-98a3-15b0edfde306}')
    @commethod(119)
    def BlendImage(self, image: win32more.Windows.Win32.Graphics.Direct2D.ID2D1Image, blendMode: win32more.Windows.Win32.Graphics.Direct2D.Common.D2D1_BLEND_MODE, targetOffset: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_POINT_2F), imageRectangle: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_RECT_F), interpolationMode: win32more.Windows.Win32.Graphics.Direct2D.D2D1_INTERPOLATION_MODE) -> Void: ...
class ID2D1DeviceContext7(ComPtr):
    extends: win32more.Windows.Win32.Graphics.Direct2D.ID2D1DeviceContext6
    _iid_ = Guid('{ec891cf7-9b69-4851-9def-4e0915771e62}')
    @commethod(120)
    def GetPaintFeatureLevel(self) -> win32more.Windows.Win32.Graphics.DirectWrite.DWRITE_PAINT_FEATURE_LEVEL: ...
    @commethod(121)
    def DrawPaintGlyphRun(self, baselineOrigin: win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_POINT_2F, glyphRun: POINTER(win32more.Windows.Win32.Graphics.DirectWrite.DWRITE_GLYPH_RUN), defaultFillBrush: win32more.Windows.Win32.Graphics.Direct2D.ID2D1Brush, colorPaletteIndex: UInt32, measuringMode: win32more.Windows.Win32.Graphics.DirectWrite.DWRITE_MEASURING_MODE) -> Void: ...
    @commethod(122)
    def DrawGlyphRunWithColorSupport(self, baselineOrigin: win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_POINT_2F, glyphRun: POINTER(win32more.Windows.Win32.Graphics.DirectWrite.DWRITE_GLYPH_RUN), glyphRunDescription: POINTER(win32more.Windows.Win32.Graphics.DirectWrite.DWRITE_GLYPH_RUN_DESCRIPTION), foregroundBrush: win32more.Windows.Win32.Graphics.Direct2D.ID2D1Brush, svgGlyphStyle: win32more.Windows.Win32.Graphics.Direct2D.ID2D1SvgGlyphStyle, colorPaletteIndex: UInt32, measuringMode: win32more.Windows.Win32.Graphics.DirectWrite.DWRITE_MEASURING_MODE, bitmapSnapOption: win32more.Windows.Win32.Graphics.Direct2D.D2D1_COLOR_BITMAP_GLYPH_SNAP_OPTION) -> Void: ...
class ID2D1DrawInfo(ComPtr):
    extends: win32more.Windows.Win32.Graphics.Direct2D.ID2D1RenderInfo
    _iid_ = Guid('{693ce632-7f2f-45de-93fe-18d88b37aa21}')
    @commethod(7)
    def SetPixelShaderConstantBuffer(self, buffer: POINTER(Byte), bufferCount: UInt32) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(8)
    def SetResourceTexture(self, textureIndex: UInt32, resourceTexture: win32more.Windows.Win32.Graphics.Direct2D.ID2D1ResourceTexture) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(9)
    def SetVertexShaderConstantBuffer(self, buffer: POINTER(Byte), bufferCount: UInt32) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(10)
    def SetPixelShader(self, shaderId: POINTER(Guid), pixelOptions: win32more.Windows.Win32.Graphics.Direct2D.D2D1_PIXEL_OPTIONS) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(11)
    def SetVertexProcessing(self, vertexBuffer: win32more.Windows.Win32.Graphics.Direct2D.ID2D1VertexBuffer, vertexOptions: win32more.Windows.Win32.Graphics.Direct2D.D2D1_VERTEX_OPTIONS, blendDescription: POINTER(win32more.Windows.Win32.Graphics.Direct2D.D2D1_BLEND_DESCRIPTION), vertexRange: POINTER(win32more.Windows.Win32.Graphics.Direct2D.D2D1_VERTEX_RANGE), vertexShader: POINTER(Guid)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class ID2D1DrawTransform(ComPtr):
    extends: win32more.Windows.Win32.Graphics.Direct2D.ID2D1Transform
    _iid_ = Guid('{36bfdcb6-9739-435d-a30d-a653beff6a6f}')
    @commethod(7)
    def SetDrawInfo(self, drawInfo: win32more.Windows.Win32.Graphics.Direct2D.ID2D1DrawInfo) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class ID2D1DrawingStateBlock(ComPtr):
    extends: win32more.Windows.Win32.Graphics.Direct2D.ID2D1Resource
    _iid_ = Guid('{28506e39-ebf6-46a1-bb47-fd85565ab957}')
    @commethod(4)
    def GetDescription(self, stateDescription: POINTER(win32more.Windows.Win32.Graphics.Direct2D.D2D1_DRAWING_STATE_DESCRIPTION)) -> Void: ...
    @commethod(5)
    def SetDescription(self, stateDescription: POINTER(win32more.Windows.Win32.Graphics.Direct2D.D2D1_DRAWING_STATE_DESCRIPTION)) -> Void: ...
    @commethod(6)
    def SetTextRenderingParams(self, textRenderingParams: win32more.Windows.Win32.Graphics.DirectWrite.IDWriteRenderingParams) -> Void: ...
    @commethod(7)
    def GetTextRenderingParams(self, textRenderingParams: POINTER(win32more.Windows.Win32.Graphics.DirectWrite.IDWriteRenderingParams)) -> Void: ...
class ID2D1DrawingStateBlock1(ComPtr):
    extends: win32more.Windows.Win32.Graphics.Direct2D.ID2D1DrawingStateBlock
    _iid_ = Guid('{689f1f85-c72e-4e33-8f19-85754efd5ace}')
    @commethod(8)
    def GetDescription(self, stateDescription: POINTER(win32more.Windows.Win32.Graphics.Direct2D.D2D1_DRAWING_STATE_DESCRIPTION1)) -> Void: ...
    @commethod(9)
    def SetDescription(self, stateDescription: POINTER(win32more.Windows.Win32.Graphics.Direct2D.D2D1_DRAWING_STATE_DESCRIPTION1)) -> Void: ...
class ID2D1Effect(ComPtr):
    extends: win32more.Windows.Win32.Graphics.Direct2D.ID2D1Properties
    _iid_ = Guid('{28211a43-7d89-476f-8181-2d6159b220ad}')
    @commethod(14)
    def SetInput(self, index: UInt32, input: win32more.Windows.Win32.Graphics.Direct2D.ID2D1Image, invalidate: win32more.Windows.Win32.Foundation.BOOL) -> Void: ...
    @commethod(15)
    def SetInputCount(self, inputCount: UInt32) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(16)
    def GetInput(self, index: UInt32, input: POINTER(win32more.Windows.Win32.Graphics.Direct2D.ID2D1Image)) -> Void: ...
    @commethod(17)
    def GetInputCount(self) -> UInt32: ...
    @commethod(18)
    def GetOutput(self, outputImage: POINTER(win32more.Windows.Win32.Graphics.Direct2D.ID2D1Image)) -> Void: ...
class ID2D1EffectContext(ComPtr):
    extends: win32more.Windows.Win32.System.Com.IUnknown
    _iid_ = Guid('{3d9f916b-27dc-4ad7-b4f1-64945340f563}')
    @commethod(3)
    def GetDpi(self, dpiX: POINTER(Single), dpiY: POINTER(Single)) -> Void: ...
    @commethod(4)
    def CreateEffect(self, effectId: POINTER(Guid), effect: POINTER(win32more.Windows.Win32.Graphics.Direct2D.ID2D1Effect)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(5)
    def GetMaximumSupportedFeatureLevel(self, featureLevels: POINTER(win32more.Windows.Win32.Graphics.Direct3D.D3D_FEATURE_LEVEL), featureLevelsCount: UInt32, maximumSupportedFeatureLevel: POINTER(win32more.Windows.Win32.Graphics.Direct3D.D3D_FEATURE_LEVEL)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(6)
    def CreateTransformNodeFromEffect(self, effect: win32more.Windows.Win32.Graphics.Direct2D.ID2D1Effect, transformNode: POINTER(win32more.Windows.Win32.Graphics.Direct2D.ID2D1TransformNode)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(7)
    def CreateBlendTransform(self, numInputs: UInt32, blendDescription: POINTER(win32more.Windows.Win32.Graphics.Direct2D.D2D1_BLEND_DESCRIPTION), transform: POINTER(win32more.Windows.Win32.Graphics.Direct2D.ID2D1BlendTransform)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(8)
    def CreateBorderTransform(self, extendModeX: win32more.Windows.Win32.Graphics.Direct2D.D2D1_EXTEND_MODE, extendModeY: win32more.Windows.Win32.Graphics.Direct2D.D2D1_EXTEND_MODE, transform: POINTER(win32more.Windows.Win32.Graphics.Direct2D.ID2D1BorderTransform)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(9)
    def CreateOffsetTransform(self, offset: win32more.Windows.Win32.Foundation.POINT, transform: POINTER(win32more.Windows.Win32.Graphics.Direct2D.ID2D1OffsetTransform)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(10)
    def CreateBoundsAdjustmentTransform(self, outputRectangle: POINTER(win32more.Windows.Win32.Foundation.RECT), transform: POINTER(win32more.Windows.Win32.Graphics.Direct2D.ID2D1BoundsAdjustmentTransform)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(11)
    def LoadPixelShader(self, shaderId: POINTER(Guid), shaderBuffer: POINTER(Byte), shaderBufferCount: UInt32) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(12)
    def LoadVertexShader(self, resourceId: POINTER(Guid), shaderBuffer: POINTER(Byte), shaderBufferCount: UInt32) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(13)
    def LoadComputeShader(self, resourceId: POINTER(Guid), shaderBuffer: POINTER(Byte), shaderBufferCount: UInt32) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(14)
    def IsShaderLoaded(self, shaderId: POINTER(Guid)) -> win32more.Windows.Win32.Foundation.BOOL: ...
    @commethod(15)
    def CreateResourceTexture(self, resourceId: POINTER(Guid), resourceTextureProperties: POINTER(win32more.Windows.Win32.Graphics.Direct2D.D2D1_RESOURCE_TEXTURE_PROPERTIES), data: POINTER(Byte), strides: POINTER(UInt32), dataSize: UInt32, resourceTexture: POINTER(win32more.Windows.Win32.Graphics.Direct2D.ID2D1ResourceTexture)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(16)
    def FindResourceTexture(self, resourceId: POINTER(Guid), resourceTexture: POINTER(win32more.Windows.Win32.Graphics.Direct2D.ID2D1ResourceTexture)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(17)
    def CreateVertexBuffer(self, vertexBufferProperties: POINTER(win32more.Windows.Win32.Graphics.Direct2D.D2D1_VERTEX_BUFFER_PROPERTIES), resourceId: POINTER(Guid), customVertexBufferProperties: POINTER(win32more.Windows.Win32.Graphics.Direct2D.D2D1_CUSTOM_VERTEX_BUFFER_PROPERTIES), buffer: POINTER(win32more.Windows.Win32.Graphics.Direct2D.ID2D1VertexBuffer)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(18)
    def FindVertexBuffer(self, resourceId: POINTER(Guid), buffer: POINTER(win32more.Windows.Win32.Graphics.Direct2D.ID2D1VertexBuffer)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(19)
    def CreateColorContext(self, space: win32more.Windows.Win32.Graphics.Direct2D.D2D1_COLOR_SPACE, profile: POINTER(Byte), profileSize: UInt32, colorContext: POINTER(win32more.Windows.Win32.Graphics.Direct2D.ID2D1ColorContext)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(20)
    def CreateColorContextFromFilename(self, filename: win32more.Windows.Win32.Foundation.PWSTR, colorContext: POINTER(win32more.Windows.Win32.Graphics.Direct2D.ID2D1ColorContext)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(21)
    def CreateColorContextFromWicColorContext(self, wicColorContext: win32more.Windows.Win32.Graphics.Imaging.IWICColorContext, colorContext: POINTER(win32more.Windows.Win32.Graphics.Direct2D.ID2D1ColorContext)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(22)
    def CheckFeatureSupport(self, feature: win32more.Windows.Win32.Graphics.Direct2D.D2D1_FEATURE, featureSupportData: VoidPtr, featureSupportDataSize: UInt32) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(23)
    def IsBufferPrecisionSupported(self, bufferPrecision: win32more.Windows.Win32.Graphics.Direct2D.D2D1_BUFFER_PRECISION) -> win32more.Windows.Win32.Foundation.BOOL: ...
class ID2D1EffectContext1(ComPtr):
    extends: win32more.Windows.Win32.Graphics.Direct2D.ID2D1EffectContext
    _iid_ = Guid('{84ab595a-fc81-4546-bacd-e8ef4d8abe7a}')
    @commethod(24)
    def CreateLookupTable3D(self, precision: win32more.Windows.Win32.Graphics.Direct2D.D2D1_BUFFER_PRECISION, extents: POINTER(UInt32), data: POINTER(Byte), dataCount: UInt32, strides: POINTER(UInt32), lookupTable: POINTER(win32more.Windows.Win32.Graphics.Direct2D.ID2D1LookupTable3D)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class ID2D1EffectContext2(ComPtr):
    extends: win32more.Windows.Win32.Graphics.Direct2D.ID2D1EffectContext1
    _iid_ = Guid('{577ad2a0-9fc7-4dda-8b18-dab810140052}')
    @commethod(25)
    def CreateColorContextFromDxgiColorSpace(self, colorSpace: win32more.Windows.Win32.Graphics.Dxgi.Common.DXGI_COLOR_SPACE_TYPE, colorContext: POINTER(win32more.Windows.Win32.Graphics.Direct2D.ID2D1ColorContext1)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(26)
    def CreateColorContextFromSimpleColorProfile(self, simpleProfile: POINTER(win32more.Windows.Win32.Graphics.Direct2D.D2D1_SIMPLE_COLOR_PROFILE), colorContext: POINTER(win32more.Windows.Win32.Graphics.Direct2D.ID2D1ColorContext1)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class ID2D1EffectImpl(ComPtr):
    extends: win32more.Windows.Win32.System.Com.IUnknown
    _iid_ = Guid('{a248fd3f-3e6c-4e63-9f03-7f68ecc91db9}')
    @commethod(3)
    def Initialize(self, effectContext: win32more.Windows.Win32.Graphics.Direct2D.ID2D1EffectContext, transformGraph: win32more.Windows.Win32.Graphics.Direct2D.ID2D1TransformGraph) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(4)
    def PrepareForRender(self, changeType: win32more.Windows.Win32.Graphics.Direct2D.D2D1_CHANGE_TYPE) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(5)
    def SetGraph(self, transformGraph: win32more.Windows.Win32.Graphics.Direct2D.ID2D1TransformGraph) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class ID2D1EllipseGeometry(ComPtr):
    extends: win32more.Windows.Win32.Graphics.Direct2D.ID2D1Geometry
    _iid_ = Guid('{2cd906a4-12e2-11dc-9fed-001143a055f9}')
    @commethod(17)
    def GetEllipse(self, ellipse: POINTER(win32more.Windows.Win32.Graphics.Direct2D.D2D1_ELLIPSE)) -> Void: ...
class ID2D1Factory(ComPtr):
    extends: win32more.Windows.Win32.System.Com.IUnknown
    _iid_ = Guid('{06152247-6f50-465a-9245-118bfd3b6007}')
    @commethod(3)
    def ReloadSystemMetrics(self) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(4)
    def GetDesktopDpi(self, dpiX: POINTER(Single), dpiY: POINTER(Single)) -> Void: ...
    @commethod(5)
    def CreateRectangleGeometry(self, rectangle: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_RECT_F), rectangleGeometry: POINTER(win32more.Windows.Win32.Graphics.Direct2D.ID2D1RectangleGeometry)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(6)
    def CreateRoundedRectangleGeometry(self, roundedRectangle: POINTER(win32more.Windows.Win32.Graphics.Direct2D.D2D1_ROUNDED_RECT), roundedRectangleGeometry: POINTER(win32more.Windows.Win32.Graphics.Direct2D.ID2D1RoundedRectangleGeometry)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(7)
    def CreateEllipseGeometry(self, ellipse: POINTER(win32more.Windows.Win32.Graphics.Direct2D.D2D1_ELLIPSE), ellipseGeometry: POINTER(win32more.Windows.Win32.Graphics.Direct2D.ID2D1EllipseGeometry)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(8)
    def CreateGeometryGroup(self, fillMode: win32more.Windows.Win32.Graphics.Direct2D.Common.D2D1_FILL_MODE, geometries: POINTER(win32more.Windows.Win32.Graphics.Direct2D.ID2D1Geometry), geometriesCount: UInt32, geometryGroup: POINTER(win32more.Windows.Win32.Graphics.Direct2D.ID2D1GeometryGroup)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(9)
    def CreateTransformedGeometry(self, sourceGeometry: win32more.Windows.Win32.Graphics.Direct2D.ID2D1Geometry, transform: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_MATRIX_3X2_F), transformedGeometry: POINTER(win32more.Windows.Win32.Graphics.Direct2D.ID2D1TransformedGeometry)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(10)
    def CreatePathGeometry(self, pathGeometry: POINTER(win32more.Windows.Win32.Graphics.Direct2D.ID2D1PathGeometry)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(11)
    def CreateStrokeStyle(self, strokeStyleProperties: POINTER(win32more.Windows.Win32.Graphics.Direct2D.D2D1_STROKE_STYLE_PROPERTIES), dashes: POINTER(Single), dashesCount: UInt32, strokeStyle: POINTER(win32more.Windows.Win32.Graphics.Direct2D.ID2D1StrokeStyle)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(12)
    def CreateDrawingStateBlock(self, drawingStateDescription: POINTER(win32more.Windows.Win32.Graphics.Direct2D.D2D1_DRAWING_STATE_DESCRIPTION), textRenderingParams: win32more.Windows.Win32.Graphics.DirectWrite.IDWriteRenderingParams, drawingStateBlock: POINTER(win32more.Windows.Win32.Graphics.Direct2D.ID2D1DrawingStateBlock)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(13)
    def CreateWicBitmapRenderTarget(self, target: win32more.Windows.Win32.Graphics.Imaging.IWICBitmap, renderTargetProperties: POINTER(win32more.Windows.Win32.Graphics.Direct2D.D2D1_RENDER_TARGET_PROPERTIES), renderTarget: POINTER(win32more.Windows.Win32.Graphics.Direct2D.ID2D1RenderTarget)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(14)
    def CreateHwndRenderTarget(self, renderTargetProperties: POINTER(win32more.Windows.Win32.Graphics.Direct2D.D2D1_RENDER_TARGET_PROPERTIES), hwndRenderTargetProperties: POINTER(win32more.Windows.Win32.Graphics.Direct2D.D2D1_HWND_RENDER_TARGET_PROPERTIES), hwndRenderTarget: POINTER(win32more.Windows.Win32.Graphics.Direct2D.ID2D1HwndRenderTarget)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(15)
    def CreateDxgiSurfaceRenderTarget(self, dxgiSurface: win32more.Windows.Win32.Graphics.Dxgi.IDXGISurface, renderTargetProperties: POINTER(win32more.Windows.Win32.Graphics.Direct2D.D2D1_RENDER_TARGET_PROPERTIES), renderTarget: POINTER(win32more.Windows.Win32.Graphics.Direct2D.ID2D1RenderTarget)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(16)
    def CreateDCRenderTarget(self, renderTargetProperties: POINTER(win32more.Windows.Win32.Graphics.Direct2D.D2D1_RENDER_TARGET_PROPERTIES), dcRenderTarget: POINTER(win32more.Windows.Win32.Graphics.Direct2D.ID2D1DCRenderTarget)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class ID2D1Factory1(ComPtr):
    extends: win32more.Windows.Win32.Graphics.Direct2D.ID2D1Factory
    _iid_ = Guid('{bb12d362-daee-4b9a-aa1d-14ba401cfa1f}')
    @commethod(17)
    def CreateDevice(self, dxgiDevice: win32more.Windows.Win32.Graphics.Dxgi.IDXGIDevice, d2dDevice: POINTER(win32more.Windows.Win32.Graphics.Direct2D.ID2D1Device)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(18)
    def CreateStrokeStyle(self, strokeStyleProperties: POINTER(win32more.Windows.Win32.Graphics.Direct2D.D2D1_STROKE_STYLE_PROPERTIES1), dashes: POINTER(Single), dashesCount: UInt32, strokeStyle: POINTER(win32more.Windows.Win32.Graphics.Direct2D.ID2D1StrokeStyle1)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(19)
    def CreatePathGeometry(self, pathGeometry: POINTER(win32more.Windows.Win32.Graphics.Direct2D.ID2D1PathGeometry1)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(20)
    def CreateDrawingStateBlock(self, drawingStateDescription: POINTER(win32more.Windows.Win32.Graphics.Direct2D.D2D1_DRAWING_STATE_DESCRIPTION1), textRenderingParams: win32more.Windows.Win32.Graphics.DirectWrite.IDWriteRenderingParams, drawingStateBlock: POINTER(win32more.Windows.Win32.Graphics.Direct2D.ID2D1DrawingStateBlock1)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(21)
    def CreateGdiMetafile(self, metafileStream: win32more.Windows.Win32.System.Com.IStream, metafile: POINTER(win32more.Windows.Win32.Graphics.Direct2D.ID2D1GdiMetafile)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(22)
    def RegisterEffectFromStream(self, classId: POINTER(Guid), propertyXml: win32more.Windows.Win32.System.Com.IStream, bindings: POINTER(win32more.Windows.Win32.Graphics.Direct2D.D2D1_PROPERTY_BINDING), bindingsCount: UInt32, effectFactory: win32more.Windows.Win32.Graphics.Direct2D.PD2D1_EFFECT_FACTORY) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(23)
    def RegisterEffectFromString(self, classId: POINTER(Guid), propertyXml: win32more.Windows.Win32.Foundation.PWSTR, bindings: POINTER(win32more.Windows.Win32.Graphics.Direct2D.D2D1_PROPERTY_BINDING), bindingsCount: UInt32, effectFactory: win32more.Windows.Win32.Graphics.Direct2D.PD2D1_EFFECT_FACTORY) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(24)
    def UnregisterEffect(self, classId: POINTER(Guid)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(25)
    def GetRegisteredEffects(self, effects: POINTER(Guid), effectsCount: UInt32, effectsReturned: POINTER(UInt32), effectsRegistered: POINTER(UInt32)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(26)
    def GetEffectProperties(self, effectId: POINTER(Guid), properties: POINTER(win32more.Windows.Win32.Graphics.Direct2D.ID2D1Properties)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class ID2D1Factory2(ComPtr):
    extends: win32more.Windows.Win32.Graphics.Direct2D.ID2D1Factory1
    _iid_ = Guid('{94f81a73-9212-4376-9c58-b16a3a0d3992}')
    @commethod(27)
    def CreateDevice(self, dxgiDevice: win32more.Windows.Win32.Graphics.Dxgi.IDXGIDevice, d2dDevice1: POINTER(win32more.Windows.Win32.Graphics.Direct2D.ID2D1Device1)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class ID2D1Factory3(ComPtr):
    extends: win32more.Windows.Win32.Graphics.Direct2D.ID2D1Factory2
    _iid_ = Guid('{0869759f-4f00-413f-b03e-2bda45404d0f}')
    @commethod(28)
    def CreateDevice(self, dxgiDevice: win32more.Windows.Win32.Graphics.Dxgi.IDXGIDevice, d2dDevice2: POINTER(win32more.Windows.Win32.Graphics.Direct2D.ID2D1Device2)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class ID2D1Factory4(ComPtr):
    extends: win32more.Windows.Win32.Graphics.Direct2D.ID2D1Factory3
    _iid_ = Guid('{bd4ec2d2-0662-4bee-ba8e-6f29f032e096}')
    @commethod(29)
    def CreateDevice(self, dxgiDevice: win32more.Windows.Win32.Graphics.Dxgi.IDXGIDevice, d2dDevice3: POINTER(win32more.Windows.Win32.Graphics.Direct2D.ID2D1Device3)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class ID2D1Factory5(ComPtr):
    extends: win32more.Windows.Win32.Graphics.Direct2D.ID2D1Factory4
    _iid_ = Guid('{c4349994-838e-4b0f-8cab-44997d9eeacc}')
    @commethod(30)
    def CreateDevice(self, dxgiDevice: win32more.Windows.Win32.Graphics.Dxgi.IDXGIDevice, d2dDevice4: POINTER(win32more.Windows.Win32.Graphics.Direct2D.ID2D1Device4)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class ID2D1Factory6(ComPtr):
    extends: win32more.Windows.Win32.Graphics.Direct2D.ID2D1Factory5
    _iid_ = Guid('{f9976f46-f642-44c1-97ca-da32ea2a2635}')
    @commethod(31)
    def CreateDevice(self, dxgiDevice: win32more.Windows.Win32.Graphics.Dxgi.IDXGIDevice, d2dDevice5: POINTER(win32more.Windows.Win32.Graphics.Direct2D.ID2D1Device5)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class ID2D1Factory7(ComPtr):
    extends: win32more.Windows.Win32.Graphics.Direct2D.ID2D1Factory6
    _iid_ = Guid('{bdc2bdd3-b96c-4de6-bdf7-99d4745454de}')
    @commethod(32)
    def CreateDevice(self, dxgiDevice: win32more.Windows.Win32.Graphics.Dxgi.IDXGIDevice, d2dDevice6: POINTER(win32more.Windows.Win32.Graphics.Direct2D.ID2D1Device6)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class ID2D1Factory8(ComPtr):
    extends: win32more.Windows.Win32.Graphics.Direct2D.ID2D1Factory7
    _iid_ = Guid('{677c9311-f36d-4b1f-ae86-86d1223ffd3a}')
    @commethod(33)
    def CreateDevice(self, dxgiDevice: win32more.Windows.Win32.Graphics.Dxgi.IDXGIDevice, d2dDevice6: POINTER(win32more.Windows.Win32.Graphics.Direct2D.ID2D1Device7)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class ID2D1GdiInteropRenderTarget(ComPtr):
    extends: win32more.Windows.Win32.System.Com.IUnknown
    _iid_ = Guid('{e0db51c3-6f77-4bae-b3d5-e47509b35838}')
    @commethod(3)
    def GetDC(self, mode: win32more.Windows.Win32.Graphics.Direct2D.D2D1_DC_INITIALIZE_MODE, hdc: POINTER(win32more.Windows.Win32.Graphics.Gdi.HDC)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(4)
    def ReleaseDC(self, update: POINTER(win32more.Windows.Win32.Foundation.RECT)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class ID2D1GdiMetafile(ComPtr):
    extends: win32more.Windows.Win32.Graphics.Direct2D.ID2D1Resource
    _iid_ = Guid('{2f543dc3-cfc1-4211-864f-cfd91c6f3395}')
    @commethod(4)
    def Stream(self, sink: win32more.Windows.Win32.Graphics.Direct2D.ID2D1GdiMetafileSink) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(5)
    def GetBounds(self, bounds: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_RECT_F)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class ID2D1GdiMetafile1(ComPtr):
    extends: win32more.Windows.Win32.Graphics.Direct2D.ID2D1GdiMetafile
    _iid_ = Guid('{2e69f9e8-dd3f-4bf9-95ba-c04f49d788df}')
    @commethod(6)
    def GetDpi(self, dpiX: POINTER(Single), dpiY: POINTER(Single)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(7)
    def GetSourceBounds(self, bounds: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_RECT_F)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class ID2D1GdiMetafileSink(ComPtr):
    extends: win32more.Windows.Win32.System.Com.IUnknown
    _iid_ = Guid('{82237326-8111-4f7c-bcf4-b5c1175564fe}')
    @commethod(3)
    def ProcessRecord(self, recordType: UInt32, recordData: VoidPtr, recordDataSize: UInt32) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class ID2D1GdiMetafileSink1(ComPtr):
    extends: win32more.Windows.Win32.Graphics.Direct2D.ID2D1GdiMetafileSink
    _iid_ = Guid('{fd0ecb6b-91e6-411e-8655-395e760f91b4}')
    @commethod(4)
    def ProcessRecord(self, recordType: UInt32, recordData: VoidPtr, recordDataSize: UInt32, flags: UInt32) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class ID2D1Geometry(ComPtr):
    extends: win32more.Windows.Win32.Graphics.Direct2D.ID2D1Resource
    _iid_ = Guid('{2cd906a1-12e2-11dc-9fed-001143a055f9}')
    @commethod(4)
    def GetBounds(self, worldTransform: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_MATRIX_3X2_F), bounds: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_RECT_F)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(5)
    def GetWidenedBounds(self, strokeWidth: Single, strokeStyle: win32more.Windows.Win32.Graphics.Direct2D.ID2D1StrokeStyle, worldTransform: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_MATRIX_3X2_F), flatteningTolerance: Single, bounds: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_RECT_F)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(6)
    def StrokeContainsPoint(self, point: win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_POINT_2F, strokeWidth: Single, strokeStyle: win32more.Windows.Win32.Graphics.Direct2D.ID2D1StrokeStyle, worldTransform: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_MATRIX_3X2_F), flatteningTolerance: Single, contains: POINTER(win32more.Windows.Win32.Foundation.BOOL)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(7)
    def FillContainsPoint(self, point: win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_POINT_2F, worldTransform: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_MATRIX_3X2_F), flatteningTolerance: Single, contains: POINTER(win32more.Windows.Win32.Foundation.BOOL)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(8)
    def CompareWithGeometry(self, inputGeometry: win32more.Windows.Win32.Graphics.Direct2D.ID2D1Geometry, inputGeometryTransform: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_MATRIX_3X2_F), flatteningTolerance: Single, relation: POINTER(win32more.Windows.Win32.Graphics.Direct2D.D2D1_GEOMETRY_RELATION)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(9)
    def Simplify(self, simplificationOption: win32more.Windows.Win32.Graphics.Direct2D.D2D1_GEOMETRY_SIMPLIFICATION_OPTION, worldTransform: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_MATRIX_3X2_F), flatteningTolerance: Single, geometrySink: win32more.Windows.Win32.Graphics.Direct2D.Common.ID2D1SimplifiedGeometrySink) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(10)
    def Tessellate(self, worldTransform: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_MATRIX_3X2_F), flatteningTolerance: Single, tessellationSink: win32more.Windows.Win32.Graphics.Direct2D.ID2D1TessellationSink) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(11)
    def CombineWithGeometry(self, inputGeometry: win32more.Windows.Win32.Graphics.Direct2D.ID2D1Geometry, combineMode: win32more.Windows.Win32.Graphics.Direct2D.D2D1_COMBINE_MODE, inputGeometryTransform: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_MATRIX_3X2_F), flatteningTolerance: Single, geometrySink: win32more.Windows.Win32.Graphics.Direct2D.Common.ID2D1SimplifiedGeometrySink) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(12)
    def Outline(self, worldTransform: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_MATRIX_3X2_F), flatteningTolerance: Single, geometrySink: win32more.Windows.Win32.Graphics.Direct2D.Common.ID2D1SimplifiedGeometrySink) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(13)
    def ComputeArea(self, worldTransform: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_MATRIX_3X2_F), flatteningTolerance: Single, area: POINTER(Single)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(14)
    def ComputeLength(self, worldTransform: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_MATRIX_3X2_F), flatteningTolerance: Single, length: POINTER(Single)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(15)
    def ComputePointAtLength(self, length: Single, worldTransform: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_MATRIX_3X2_F), flatteningTolerance: Single, point: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_POINT_2F), unitTangentVector: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_POINT_2F)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(16)
    def Widen(self, strokeWidth: Single, strokeStyle: win32more.Windows.Win32.Graphics.Direct2D.ID2D1StrokeStyle, worldTransform: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_MATRIX_3X2_F), flatteningTolerance: Single, geometrySink: win32more.Windows.Win32.Graphics.Direct2D.Common.ID2D1SimplifiedGeometrySink) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class ID2D1GeometryGroup(ComPtr):
    extends: win32more.Windows.Win32.Graphics.Direct2D.ID2D1Geometry
    _iid_ = Guid('{2cd906a6-12e2-11dc-9fed-001143a055f9}')
    @commethod(17)
    def GetFillMode(self) -> win32more.Windows.Win32.Graphics.Direct2D.Common.D2D1_FILL_MODE: ...
    @commethod(18)
    def GetSourceGeometryCount(self) -> UInt32: ...
    @commethod(19)
    def GetSourceGeometries(self, geometries: POINTER(win32more.Windows.Win32.Graphics.Direct2D.ID2D1Geometry), geometriesCount: UInt32) -> Void: ...
class ID2D1GeometryRealization(ComPtr):
    extends: win32more.Windows.Win32.Graphics.Direct2D.ID2D1Resource
    _iid_ = Guid('{a16907d7-bc02-4801-99e8-8cf7f485f774}')
class ID2D1GeometrySink(ComPtr):
    extends: win32more.Windows.Win32.Graphics.Direct2D.Common.ID2D1SimplifiedGeometrySink
    _iid_ = Guid('{2cd9069f-12e2-11dc-9fed-001143a055f9}')
    @commethod(10)
    def AddLine(self, point: win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_POINT_2F) -> Void: ...
    @commethod(11)
    def AddBezier(self, bezier: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D1_BEZIER_SEGMENT)) -> Void: ...
    @commethod(12)
    def AddQuadraticBezier(self, bezier: POINTER(win32more.Windows.Win32.Graphics.Direct2D.D2D1_QUADRATIC_BEZIER_SEGMENT)) -> Void: ...
    @commethod(13)
    def AddQuadraticBeziers(self, beziers: POINTER(win32more.Windows.Win32.Graphics.Direct2D.D2D1_QUADRATIC_BEZIER_SEGMENT), beziersCount: UInt32) -> Void: ...
    @commethod(14)
    def AddArc(self, arc: POINTER(win32more.Windows.Win32.Graphics.Direct2D.D2D1_ARC_SEGMENT)) -> Void: ...
class ID2D1GradientMesh(ComPtr):
    extends: win32more.Windows.Win32.Graphics.Direct2D.ID2D1Resource
    _iid_ = Guid('{f292e401-c050-4cde-83d7-04962d3b23c2}')
    @commethod(4)
    def GetPatchCount(self) -> UInt32: ...
    @commethod(5)
    def GetPatches(self, startIndex: UInt32, patches: POINTER(win32more.Windows.Win32.Graphics.Direct2D.D2D1_GRADIENT_MESH_PATCH), patchesCount: UInt32) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class ID2D1GradientStopCollection(ComPtr):
    extends: win32more.Windows.Win32.Graphics.Direct2D.ID2D1Resource
    _iid_ = Guid('{2cd906a7-12e2-11dc-9fed-001143a055f9}')
    @commethod(4)
    def GetGradientStopCount(self) -> UInt32: ...
    @commethod(5)
    def GetGradientStops(self, gradientStops: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D1_GRADIENT_STOP), gradientStopsCount: UInt32) -> Void: ...
    @commethod(6)
    def GetColorInterpolationGamma(self) -> win32more.Windows.Win32.Graphics.Direct2D.D2D1_GAMMA: ...
    @commethod(7)
    def GetExtendMode(self) -> win32more.Windows.Win32.Graphics.Direct2D.D2D1_EXTEND_MODE: ...
class ID2D1GradientStopCollection1(ComPtr):
    extends: win32more.Windows.Win32.Graphics.Direct2D.ID2D1GradientStopCollection
    _iid_ = Guid('{ae1572f4-5dd0-4777-998b-9279472ae63b}')
    @commethod(8)
    def GetGradientStops1(self, gradientStops: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D1_GRADIENT_STOP), gradientStopsCount: UInt32) -> Void: ...
    @commethod(9)
    def GetPreInterpolationSpace(self) -> win32more.Windows.Win32.Graphics.Direct2D.D2D1_COLOR_SPACE: ...
    @commethod(10)
    def GetPostInterpolationSpace(self) -> win32more.Windows.Win32.Graphics.Direct2D.D2D1_COLOR_SPACE: ...
    @commethod(11)
    def GetBufferPrecision(self) -> win32more.Windows.Win32.Graphics.Direct2D.D2D1_BUFFER_PRECISION: ...
    @commethod(12)
    def GetColorInterpolationMode(self) -> win32more.Windows.Win32.Graphics.Direct2D.D2D1_COLOR_INTERPOLATION_MODE: ...
class ID2D1HwndRenderTarget(ComPtr):
    extends: win32more.Windows.Win32.Graphics.Direct2D.ID2D1RenderTarget
    _iid_ = Guid('{2cd90698-12e2-11dc-9fed-001143a055f9}')
    @commethod(57)
    def CheckWindowState(self) -> win32more.Windows.Win32.Graphics.Direct2D.D2D1_WINDOW_STATE: ...
    @commethod(58)
    def Resize(self, pixelSize: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_SIZE_U)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(59)
    def GetHwnd(self) -> win32more.Windows.Win32.Foundation.HWND: ...
class ID2D1Image(ComPtr):
    extends: win32more.Windows.Win32.Graphics.Direct2D.ID2D1Resource
    _iid_ = Guid('{65019f75-8da2-497c-b32c-dfa34e48ede6}')
class ID2D1ImageBrush(ComPtr):
    extends: win32more.Windows.Win32.Graphics.Direct2D.ID2D1Brush
    _iid_ = Guid('{fe9e984d-3f95-407c-b5db-cb94d4e8f87c}')
    @commethod(8)
    def SetImage(self, image: win32more.Windows.Win32.Graphics.Direct2D.ID2D1Image) -> Void: ...
    @commethod(9)
    def SetExtendModeX(self, extendModeX: win32more.Windows.Win32.Graphics.Direct2D.D2D1_EXTEND_MODE) -> Void: ...
    @commethod(10)
    def SetExtendModeY(self, extendModeY: win32more.Windows.Win32.Graphics.Direct2D.D2D1_EXTEND_MODE) -> Void: ...
    @commethod(11)
    def SetInterpolationMode(self, interpolationMode: win32more.Windows.Win32.Graphics.Direct2D.D2D1_INTERPOLATION_MODE) -> Void: ...
    @commethod(12)
    def SetSourceRectangle(self, sourceRectangle: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_RECT_F)) -> Void: ...
    @commethod(13)
    def GetImage(self, image: POINTER(win32more.Windows.Win32.Graphics.Direct2D.ID2D1Image)) -> Void: ...
    @commethod(14)
    def GetExtendModeX(self) -> win32more.Windows.Win32.Graphics.Direct2D.D2D1_EXTEND_MODE: ...
    @commethod(15)
    def GetExtendModeY(self) -> win32more.Windows.Win32.Graphics.Direct2D.D2D1_EXTEND_MODE: ...
    @commethod(16)
    def GetInterpolationMode(self) -> win32more.Windows.Win32.Graphics.Direct2D.D2D1_INTERPOLATION_MODE: ...
    @commethod(17)
    def GetSourceRectangle(self, sourceRectangle: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_RECT_F)) -> Void: ...
class ID2D1ImageSource(ComPtr):
    extends: win32more.Windows.Win32.Graphics.Direct2D.ID2D1Image
    _iid_ = Guid('{c9b664e5-74a1-4378-9ac2-eefc37a3f4d8}')
    @commethod(4)
    def OfferResources(self) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(5)
    def TryReclaimResources(self, resourcesDiscarded: POINTER(win32more.Windows.Win32.Foundation.BOOL)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class ID2D1ImageSourceFromWic(ComPtr):
    extends: win32more.Windows.Win32.Graphics.Direct2D.ID2D1ImageSource
    _iid_ = Guid('{77395441-1c8f-4555-8683-f50dab0fe792}')
    @commethod(6)
    def EnsureCached(self, rectangleToFill: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_RECT_U)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(7)
    def TrimCache(self, rectangleToPreserve: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_RECT_U)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(8)
    def GetSource(self, wicBitmapSource: POINTER(win32more.Windows.Win32.Graphics.Imaging.IWICBitmapSource)) -> Void: ...
class ID2D1Ink(ComPtr):
    extends: win32more.Windows.Win32.Graphics.Direct2D.ID2D1Resource
    _iid_ = Guid('{b499923b-7029-478f-a8b3-432c7c5f5312}')
    @commethod(4)
    def SetStartPoint(self, startPoint: POINTER(win32more.Windows.Win32.Graphics.Direct2D.D2D1_INK_POINT)) -> Void: ...
    @commethod(5)
    def GetStartPoint(self) -> win32more.Windows.Win32.Graphics.Direct2D.D2D1_INK_POINT: ...
    @commethod(6)
    def AddSegments(self, segments: POINTER(win32more.Windows.Win32.Graphics.Direct2D.D2D1_INK_BEZIER_SEGMENT), segmentsCount: UInt32) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(7)
    def RemoveSegmentsAtEnd(self, segmentsCount: UInt32) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(8)
    def SetSegments(self, startSegment: UInt32, segments: POINTER(win32more.Windows.Win32.Graphics.Direct2D.D2D1_INK_BEZIER_SEGMENT), segmentsCount: UInt32) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(9)
    def SetSegmentAtEnd(self, segment: POINTER(win32more.Windows.Win32.Graphics.Direct2D.D2D1_INK_BEZIER_SEGMENT)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(10)
    def GetSegmentCount(self) -> UInt32: ...
    @commethod(11)
    def GetSegments(self, startSegment: UInt32, segments: POINTER(win32more.Windows.Win32.Graphics.Direct2D.D2D1_INK_BEZIER_SEGMENT), segmentsCount: UInt32) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(12)
    def StreamAsGeometry(self, inkStyle: win32more.Windows.Win32.Graphics.Direct2D.ID2D1InkStyle, worldTransform: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_MATRIX_3X2_F), flatteningTolerance: Single, geometrySink: win32more.Windows.Win32.Graphics.Direct2D.Common.ID2D1SimplifiedGeometrySink) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(13)
    def GetBounds(self, inkStyle: win32more.Windows.Win32.Graphics.Direct2D.ID2D1InkStyle, worldTransform: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_MATRIX_3X2_F), bounds: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_RECT_F)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class ID2D1InkStyle(ComPtr):
    extends: win32more.Windows.Win32.Graphics.Direct2D.ID2D1Resource
    _iid_ = Guid('{bae8b344-23fc-4071-8cb5-d05d6f073848}')
    @commethod(4)
    def SetNibTransform(self, transform: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_MATRIX_3X2_F)) -> Void: ...
    @commethod(5)
    def GetNibTransform(self, transform: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_MATRIX_3X2_F)) -> Void: ...
    @commethod(6)
    def SetNibShape(self, nibShape: win32more.Windows.Win32.Graphics.Direct2D.D2D1_INK_NIB_SHAPE) -> Void: ...
    @commethod(7)
    def GetNibShape(self) -> win32more.Windows.Win32.Graphics.Direct2D.D2D1_INK_NIB_SHAPE: ...
class ID2D1Layer(ComPtr):
    extends: win32more.Windows.Win32.Graphics.Direct2D.ID2D1Resource
    _iid_ = Guid('{2cd9069b-12e2-11dc-9fed-001143a055f9}')
    @commethod(4)
    def GetSize(self) -> win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_SIZE_F: ...
class ID2D1LinearGradientBrush(ComPtr):
    extends: win32more.Windows.Win32.Graphics.Direct2D.ID2D1Brush
    _iid_ = Guid('{2cd906ab-12e2-11dc-9fed-001143a055f9}')
    @commethod(8)
    def SetStartPoint(self, startPoint: win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_POINT_2F) -> Void: ...
    @commethod(9)
    def SetEndPoint(self, endPoint: win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_POINT_2F) -> Void: ...
    @commethod(10)
    def GetStartPoint(self) -> win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_POINT_2F: ...
    @commethod(11)
    def GetEndPoint(self) -> win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_POINT_2F: ...
    @commethod(12)
    def GetGradientStopCollection(self, gradientStopCollection: POINTER(win32more.Windows.Win32.Graphics.Direct2D.ID2D1GradientStopCollection)) -> Void: ...
class ID2D1LookupTable3D(ComPtr):
    extends: win32more.Windows.Win32.Graphics.Direct2D.ID2D1Resource
    _iid_ = Guid('{53dd9855-a3b0-4d5b-82e1-26e25c5e5797}')
class ID2D1Mesh(ComPtr):
    extends: win32more.Windows.Win32.Graphics.Direct2D.ID2D1Resource
    _iid_ = Guid('{2cd906c2-12e2-11dc-9fed-001143a055f9}')
    @commethod(4)
    def Open(self, tessellationSink: POINTER(win32more.Windows.Win32.Graphics.Direct2D.ID2D1TessellationSink)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class ID2D1Multithread(ComPtr):
    extends: win32more.Windows.Win32.System.Com.IUnknown
    _iid_ = Guid('{31e6e7bc-e0ff-4d46-8c64-a0a8c41c15d3}')
    @commethod(3)
    def GetMultithreadProtected(self) -> win32more.Windows.Win32.Foundation.BOOL: ...
    @commethod(4)
    def Enter(self) -> Void: ...
    @commethod(5)
    def Leave(self) -> Void: ...
class ID2D1OffsetTransform(ComPtr):
    extends: win32more.Windows.Win32.Graphics.Direct2D.ID2D1TransformNode
    _iid_ = Guid('{3fe6adea-7643-4f53-bd14-a0ce63f24042}')
    @commethod(4)
    def SetOffset(self, offset: win32more.Windows.Win32.Foundation.POINT) -> Void: ...
    @commethod(5)
    def GetOffset(self) -> win32more.Windows.Win32.Foundation.POINT: ...
class ID2D1PathGeometry(ComPtr):
    extends: win32more.Windows.Win32.Graphics.Direct2D.ID2D1Geometry
    _iid_ = Guid('{2cd906a5-12e2-11dc-9fed-001143a055f9}')
    @commethod(17)
    def Open(self, geometrySink: POINTER(win32more.Windows.Win32.Graphics.Direct2D.ID2D1GeometrySink)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(18)
    def Stream(self, geometrySink: win32more.Windows.Win32.Graphics.Direct2D.ID2D1GeometrySink) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(19)
    def GetSegmentCount(self, count: POINTER(UInt32)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(20)
    def GetFigureCount(self, count: POINTER(UInt32)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class ID2D1PathGeometry1(ComPtr):
    extends: win32more.Windows.Win32.Graphics.Direct2D.ID2D1PathGeometry
    _iid_ = Guid('{62baa2d2-ab54-41b7-b872-787e0106a421}')
    @commethod(21)
    def ComputePointAndSegmentAtLength(self, length: Single, startSegment: UInt32, worldTransform: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_MATRIX_3X2_F), flatteningTolerance: Single, pointDescription: POINTER(win32more.Windows.Win32.Graphics.Direct2D.D2D1_POINT_DESCRIPTION)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class ID2D1PrintControl(ComPtr):
    extends: win32more.Windows.Win32.System.Com.IUnknown
    _iid_ = Guid('{2c1d867d-c290-41c8-ae7e-34a98702e9a5}')
    @commethod(3)
    def AddPage(self, commandList: win32more.Windows.Win32.Graphics.Direct2D.ID2D1CommandList, pageSize: win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_SIZE_F, pagePrintTicketStream: win32more.Windows.Win32.System.Com.IStream, tag1: POINTER(UInt64), tag2: POINTER(UInt64)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(4)
    def Close(self) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class ID2D1Properties(ComPtr):
    extends: win32more.Windows.Win32.System.Com.IUnknown
    _iid_ = Guid('{483473d7-cd46-4f9d-9d3a-3112aa80159d}')
    @commethod(3)
    def GetPropertyCount(self) -> UInt32: ...
    @commethod(4)
    def GetPropertyName(self, index: UInt32, name: win32more.Windows.Win32.Foundation.PWSTR, nameCount: UInt32) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(5)
    def GetPropertyNameLength(self, index: UInt32) -> UInt32: ...
    @commethod(6)
    def GetType(self, index: UInt32) -> win32more.Windows.Win32.Graphics.Direct2D.D2D1_PROPERTY_TYPE: ...
    @commethod(7)
    def GetPropertyIndex(self, name: win32more.Windows.Win32.Foundation.PWSTR) -> UInt32: ...
    @commethod(8)
    def SetValueByName(self, name: win32more.Windows.Win32.Foundation.PWSTR, type: win32more.Windows.Win32.Graphics.Direct2D.D2D1_PROPERTY_TYPE, data: POINTER(Byte), dataSize: UInt32) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(9)
    def SetValue(self, index: UInt32, type: win32more.Windows.Win32.Graphics.Direct2D.D2D1_PROPERTY_TYPE, data: POINTER(Byte), dataSize: UInt32) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(10)
    def GetValueByName(self, name: win32more.Windows.Win32.Foundation.PWSTR, type: win32more.Windows.Win32.Graphics.Direct2D.D2D1_PROPERTY_TYPE, data: POINTER(Byte), dataSize: UInt32) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(11)
    def GetValue(self, index: UInt32, type: win32more.Windows.Win32.Graphics.Direct2D.D2D1_PROPERTY_TYPE, data: POINTER(Byte), dataSize: UInt32) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(12)
    def GetValueSize(self, index: UInt32) -> UInt32: ...
    @commethod(13)
    def GetSubProperties(self, index: UInt32, subProperties: POINTER(win32more.Windows.Win32.Graphics.Direct2D.ID2D1Properties)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class ID2D1RadialGradientBrush(ComPtr):
    extends: win32more.Windows.Win32.Graphics.Direct2D.ID2D1Brush
    _iid_ = Guid('{2cd906ac-12e2-11dc-9fed-001143a055f9}')
    @commethod(8)
    def SetCenter(self, center: win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_POINT_2F) -> Void: ...
    @commethod(9)
    def SetGradientOriginOffset(self, gradientOriginOffset: win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_POINT_2F) -> Void: ...
    @commethod(10)
    def SetRadiusX(self, radiusX: Single) -> Void: ...
    @commethod(11)
    def SetRadiusY(self, radiusY: Single) -> Void: ...
    @commethod(12)
    def GetCenter(self) -> win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_POINT_2F: ...
    @commethod(13)
    def GetGradientOriginOffset(self) -> win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_POINT_2F: ...
    @commethod(14)
    def GetRadiusX(self) -> Single: ...
    @commethod(15)
    def GetRadiusY(self) -> Single: ...
    @commethod(16)
    def GetGradientStopCollection(self, gradientStopCollection: POINTER(win32more.Windows.Win32.Graphics.Direct2D.ID2D1GradientStopCollection)) -> Void: ...
class ID2D1RectangleGeometry(ComPtr):
    extends: win32more.Windows.Win32.Graphics.Direct2D.ID2D1Geometry
    _iid_ = Guid('{2cd906a2-12e2-11dc-9fed-001143a055f9}')
    @commethod(17)
    def GetRect(self, rect: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_RECT_F)) -> Void: ...
class ID2D1RenderInfo(ComPtr):
    extends: win32more.Windows.Win32.System.Com.IUnknown
    _iid_ = Guid('{519ae1bd-d19a-420d-b849-364f594776b7}')
    @commethod(3)
    def SetInputDescription(self, inputIndex: UInt32, inputDescription: win32more.Windows.Win32.Graphics.Direct2D.D2D1_INPUT_DESCRIPTION) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(4)
    def SetOutputBuffer(self, bufferPrecision: win32more.Windows.Win32.Graphics.Direct2D.D2D1_BUFFER_PRECISION, channelDepth: win32more.Windows.Win32.Graphics.Direct2D.D2D1_CHANNEL_DEPTH) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(5)
    def SetCached(self, isCached: win32more.Windows.Win32.Foundation.BOOL) -> Void: ...
    @commethod(6)
    def SetInstructionCountHint(self, instructionCount: UInt32) -> Void: ...
class ID2D1RenderTarget(ComPtr):
    extends: win32more.Windows.Win32.Graphics.Direct2D.ID2D1Resource
    _iid_ = Guid('{2cd90694-12e2-11dc-9fed-001143a055f9}')
    @commethod(4)
    def CreateBitmap(self, size: win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_SIZE_U, srcData: VoidPtr, pitch: UInt32, bitmapProperties: POINTER(win32more.Windows.Win32.Graphics.Direct2D.D2D1_BITMAP_PROPERTIES), bitmap: POINTER(win32more.Windows.Win32.Graphics.Direct2D.ID2D1Bitmap)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(5)
    def CreateBitmapFromWicBitmap(self, wicBitmapSource: win32more.Windows.Win32.Graphics.Imaging.IWICBitmapSource, bitmapProperties: POINTER(win32more.Windows.Win32.Graphics.Direct2D.D2D1_BITMAP_PROPERTIES), bitmap: POINTER(win32more.Windows.Win32.Graphics.Direct2D.ID2D1Bitmap)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(6)
    def CreateSharedBitmap(self, riid: POINTER(Guid), data: VoidPtr, bitmapProperties: POINTER(win32more.Windows.Win32.Graphics.Direct2D.D2D1_BITMAP_PROPERTIES), bitmap: POINTER(win32more.Windows.Win32.Graphics.Direct2D.ID2D1Bitmap)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(7)
    def CreateBitmapBrush(self, bitmap: win32more.Windows.Win32.Graphics.Direct2D.ID2D1Bitmap, bitmapBrushProperties: POINTER(win32more.Windows.Win32.Graphics.Direct2D.D2D1_BITMAP_BRUSH_PROPERTIES), brushProperties: POINTER(win32more.Windows.Win32.Graphics.Direct2D.D2D1_BRUSH_PROPERTIES), bitmapBrush: POINTER(win32more.Windows.Win32.Graphics.Direct2D.ID2D1BitmapBrush)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(8)
    def CreateSolidColorBrush(self, color: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D1_COLOR_F), brushProperties: POINTER(win32more.Windows.Win32.Graphics.Direct2D.D2D1_BRUSH_PROPERTIES), solidColorBrush: POINTER(win32more.Windows.Win32.Graphics.Direct2D.ID2D1SolidColorBrush)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(9)
    def CreateGradientStopCollection(self, gradientStops: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D1_GRADIENT_STOP), gradientStopsCount: UInt32, colorInterpolationGamma: win32more.Windows.Win32.Graphics.Direct2D.D2D1_GAMMA, extendMode: win32more.Windows.Win32.Graphics.Direct2D.D2D1_EXTEND_MODE, gradientStopCollection: POINTER(win32more.Windows.Win32.Graphics.Direct2D.ID2D1GradientStopCollection)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(10)
    def CreateLinearGradientBrush(self, linearGradientBrushProperties: POINTER(win32more.Windows.Win32.Graphics.Direct2D.D2D1_LINEAR_GRADIENT_BRUSH_PROPERTIES), brushProperties: POINTER(win32more.Windows.Win32.Graphics.Direct2D.D2D1_BRUSH_PROPERTIES), gradientStopCollection: win32more.Windows.Win32.Graphics.Direct2D.ID2D1GradientStopCollection, linearGradientBrush: POINTER(win32more.Windows.Win32.Graphics.Direct2D.ID2D1LinearGradientBrush)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(11)
    def CreateRadialGradientBrush(self, radialGradientBrushProperties: POINTER(win32more.Windows.Win32.Graphics.Direct2D.D2D1_RADIAL_GRADIENT_BRUSH_PROPERTIES), brushProperties: POINTER(win32more.Windows.Win32.Graphics.Direct2D.D2D1_BRUSH_PROPERTIES), gradientStopCollection: win32more.Windows.Win32.Graphics.Direct2D.ID2D1GradientStopCollection, radialGradientBrush: POINTER(win32more.Windows.Win32.Graphics.Direct2D.ID2D1RadialGradientBrush)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(12)
    def CreateCompatibleRenderTarget(self, desiredSize: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_SIZE_F), desiredPixelSize: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_SIZE_U), desiredFormat: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D1_PIXEL_FORMAT), options: win32more.Windows.Win32.Graphics.Direct2D.D2D1_COMPATIBLE_RENDER_TARGET_OPTIONS, bitmapRenderTarget: POINTER(win32more.Windows.Win32.Graphics.Direct2D.ID2D1BitmapRenderTarget)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(13)
    def CreateLayer(self, size: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_SIZE_F), layer: POINTER(win32more.Windows.Win32.Graphics.Direct2D.ID2D1Layer)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(14)
    def CreateMesh(self, mesh: POINTER(win32more.Windows.Win32.Graphics.Direct2D.ID2D1Mesh)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(15)
    def DrawLine(self, point0: win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_POINT_2F, point1: win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_POINT_2F, brush: win32more.Windows.Win32.Graphics.Direct2D.ID2D1Brush, strokeWidth: Single, strokeStyle: win32more.Windows.Win32.Graphics.Direct2D.ID2D1StrokeStyle) -> Void: ...
    @commethod(16)
    def DrawRectangle(self, rect: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_RECT_F), brush: win32more.Windows.Win32.Graphics.Direct2D.ID2D1Brush, strokeWidth: Single, strokeStyle: win32more.Windows.Win32.Graphics.Direct2D.ID2D1StrokeStyle) -> Void: ...
    @commethod(17)
    def FillRectangle(self, rect: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_RECT_F), brush: win32more.Windows.Win32.Graphics.Direct2D.ID2D1Brush) -> Void: ...
    @commethod(18)
    def DrawRoundedRectangle(self, roundedRect: POINTER(win32more.Windows.Win32.Graphics.Direct2D.D2D1_ROUNDED_RECT), brush: win32more.Windows.Win32.Graphics.Direct2D.ID2D1Brush, strokeWidth: Single, strokeStyle: win32more.Windows.Win32.Graphics.Direct2D.ID2D1StrokeStyle) -> Void: ...
    @commethod(19)
    def FillRoundedRectangle(self, roundedRect: POINTER(win32more.Windows.Win32.Graphics.Direct2D.D2D1_ROUNDED_RECT), brush: win32more.Windows.Win32.Graphics.Direct2D.ID2D1Brush) -> Void: ...
    @commethod(20)
    def DrawEllipse(self, ellipse: POINTER(win32more.Windows.Win32.Graphics.Direct2D.D2D1_ELLIPSE), brush: win32more.Windows.Win32.Graphics.Direct2D.ID2D1Brush, strokeWidth: Single, strokeStyle: win32more.Windows.Win32.Graphics.Direct2D.ID2D1StrokeStyle) -> Void: ...
    @commethod(21)
    def FillEllipse(self, ellipse: POINTER(win32more.Windows.Win32.Graphics.Direct2D.D2D1_ELLIPSE), brush: win32more.Windows.Win32.Graphics.Direct2D.ID2D1Brush) -> Void: ...
    @commethod(22)
    def DrawGeometry(self, geometry: win32more.Windows.Win32.Graphics.Direct2D.ID2D1Geometry, brush: win32more.Windows.Win32.Graphics.Direct2D.ID2D1Brush, strokeWidth: Single, strokeStyle: win32more.Windows.Win32.Graphics.Direct2D.ID2D1StrokeStyle) -> Void: ...
    @commethod(23)
    def FillGeometry(self, geometry: win32more.Windows.Win32.Graphics.Direct2D.ID2D1Geometry, brush: win32more.Windows.Win32.Graphics.Direct2D.ID2D1Brush, opacityBrush: win32more.Windows.Win32.Graphics.Direct2D.ID2D1Brush) -> Void: ...
    @commethod(24)
    def FillMesh(self, mesh: win32more.Windows.Win32.Graphics.Direct2D.ID2D1Mesh, brush: win32more.Windows.Win32.Graphics.Direct2D.ID2D1Brush) -> Void: ...
    @commethod(25)
    def FillOpacityMask(self, opacityMask: win32more.Windows.Win32.Graphics.Direct2D.ID2D1Bitmap, brush: win32more.Windows.Win32.Graphics.Direct2D.ID2D1Brush, content: win32more.Windows.Win32.Graphics.Direct2D.D2D1_OPACITY_MASK_CONTENT, destinationRectangle: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_RECT_F), sourceRectangle: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_RECT_F)) -> Void: ...
    @commethod(26)
    def DrawBitmap(self, bitmap: win32more.Windows.Win32.Graphics.Direct2D.ID2D1Bitmap, destinationRectangle: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_RECT_F), opacity: Single, interpolationMode: win32more.Windows.Win32.Graphics.Direct2D.D2D1_BITMAP_INTERPOLATION_MODE, sourceRectangle: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_RECT_F)) -> Void: ...
    @commethod(27)
    def DrawText(self, string: win32more.Windows.Win32.Foundation.PWSTR, stringLength: UInt32, textFormat: win32more.Windows.Win32.Graphics.DirectWrite.IDWriteTextFormat, layoutRect: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_RECT_F), defaultFillBrush: win32more.Windows.Win32.Graphics.Direct2D.ID2D1Brush, options: win32more.Windows.Win32.Graphics.Direct2D.D2D1_DRAW_TEXT_OPTIONS, measuringMode: win32more.Windows.Win32.Graphics.DirectWrite.DWRITE_MEASURING_MODE) -> Void: ...
    @commethod(28)
    def DrawTextLayout(self, origin: win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_POINT_2F, textLayout: win32more.Windows.Win32.Graphics.DirectWrite.IDWriteTextLayout, defaultFillBrush: win32more.Windows.Win32.Graphics.Direct2D.ID2D1Brush, options: win32more.Windows.Win32.Graphics.Direct2D.D2D1_DRAW_TEXT_OPTIONS) -> Void: ...
    @commethod(29)
    def DrawGlyphRun(self, baselineOrigin: win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_POINT_2F, glyphRun: POINTER(win32more.Windows.Win32.Graphics.DirectWrite.DWRITE_GLYPH_RUN), foregroundBrush: win32more.Windows.Win32.Graphics.Direct2D.ID2D1Brush, measuringMode: win32more.Windows.Win32.Graphics.DirectWrite.DWRITE_MEASURING_MODE) -> Void: ...
    @commethod(30)
    def SetTransform(self, transform: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_MATRIX_3X2_F)) -> Void: ...
    @commethod(31)
    def GetTransform(self, transform: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_MATRIX_3X2_F)) -> Void: ...
    @commethod(32)
    def SetAntialiasMode(self, antialiasMode: win32more.Windows.Win32.Graphics.Direct2D.D2D1_ANTIALIAS_MODE) -> Void: ...
    @commethod(33)
    def GetAntialiasMode(self) -> win32more.Windows.Win32.Graphics.Direct2D.D2D1_ANTIALIAS_MODE: ...
    @commethod(34)
    def SetTextAntialiasMode(self, textAntialiasMode: win32more.Windows.Win32.Graphics.Direct2D.D2D1_TEXT_ANTIALIAS_MODE) -> Void: ...
    @commethod(35)
    def GetTextAntialiasMode(self) -> win32more.Windows.Win32.Graphics.Direct2D.D2D1_TEXT_ANTIALIAS_MODE: ...
    @commethod(36)
    def SetTextRenderingParams(self, textRenderingParams: win32more.Windows.Win32.Graphics.DirectWrite.IDWriteRenderingParams) -> Void: ...
    @commethod(37)
    def GetTextRenderingParams(self, textRenderingParams: POINTER(win32more.Windows.Win32.Graphics.DirectWrite.IDWriteRenderingParams)) -> Void: ...
    @commethod(38)
    def SetTags(self, tag1: UInt64, tag2: UInt64) -> Void: ...
    @commethod(39)
    def GetTags(self, tag1: POINTER(UInt64), tag2: POINTER(UInt64)) -> Void: ...
    @commethod(40)
    def PushLayer(self, layerParameters: POINTER(win32more.Windows.Win32.Graphics.Direct2D.D2D1_LAYER_PARAMETERS), layer: win32more.Windows.Win32.Graphics.Direct2D.ID2D1Layer) -> Void: ...
    @commethod(41)
    def PopLayer(self) -> Void: ...
    @commethod(42)
    def Flush(self, tag1: POINTER(UInt64), tag2: POINTER(UInt64)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(43)
    def SaveDrawingState(self, drawingStateBlock: win32more.Windows.Win32.Graphics.Direct2D.ID2D1DrawingStateBlock) -> Void: ...
    @commethod(44)
    def RestoreDrawingState(self, drawingStateBlock: win32more.Windows.Win32.Graphics.Direct2D.ID2D1DrawingStateBlock) -> Void: ...
    @commethod(45)
    def PushAxisAlignedClip(self, clipRect: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_RECT_F), antialiasMode: win32more.Windows.Win32.Graphics.Direct2D.D2D1_ANTIALIAS_MODE) -> Void: ...
    @commethod(46)
    def PopAxisAlignedClip(self) -> Void: ...
    @commethod(47)
    def Clear(self, clearColor: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D1_COLOR_F)) -> Void: ...
    @commethod(48)
    def BeginDraw(self) -> Void: ...
    @commethod(49)
    def EndDraw(self, tag1: POINTER(UInt64), tag2: POINTER(UInt64)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(50)
    def GetPixelFormat(self) -> win32more.Windows.Win32.Graphics.Direct2D.Common.D2D1_PIXEL_FORMAT: ...
    @commethod(51)
    def SetDpi(self, dpiX: Single, dpiY: Single) -> Void: ...
    @commethod(52)
    def GetDpi(self, dpiX: POINTER(Single), dpiY: POINTER(Single)) -> Void: ...
    @commethod(53)
    def GetSize(self) -> win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_SIZE_F: ...
    @commethod(54)
    def GetPixelSize(self) -> win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_SIZE_U: ...
    @commethod(55)
    def GetMaximumBitmapSize(self) -> UInt32: ...
    @commethod(56)
    def IsSupported(self, renderTargetProperties: POINTER(win32more.Windows.Win32.Graphics.Direct2D.D2D1_RENDER_TARGET_PROPERTIES)) -> win32more.Windows.Win32.Foundation.BOOL: ...
class ID2D1Resource(ComPtr):
    extends: win32more.Windows.Win32.System.Com.IUnknown
    _iid_ = Guid('{2cd90691-12e2-11dc-9fed-001143a055f9}')
    @commethod(3)
    def GetFactory(self, factory: POINTER(win32more.Windows.Win32.Graphics.Direct2D.ID2D1Factory)) -> Void: ...
class ID2D1ResourceTexture(ComPtr):
    extends: win32more.Windows.Win32.System.Com.IUnknown
    _iid_ = Guid('{688d15c3-02b0-438d-b13a-d1b44c32c39a}')
    @commethod(3)
    def Update(self, minimumExtents: POINTER(UInt32), maximimumExtents: POINTER(UInt32), strides: POINTER(UInt32), dimensions: UInt32, data: POINTER(Byte), dataCount: UInt32) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class ID2D1RoundedRectangleGeometry(ComPtr):
    extends: win32more.Windows.Win32.Graphics.Direct2D.ID2D1Geometry
    _iid_ = Guid('{2cd906a3-12e2-11dc-9fed-001143a055f9}')
    @commethod(17)
    def GetRoundedRect(self, roundedRect: POINTER(win32more.Windows.Win32.Graphics.Direct2D.D2D1_ROUNDED_RECT)) -> Void: ...
class ID2D1SolidColorBrush(ComPtr):
    extends: win32more.Windows.Win32.Graphics.Direct2D.ID2D1Brush
    _iid_ = Guid('{2cd906a9-12e2-11dc-9fed-001143a055f9}')
    @commethod(8)
    def SetColor(self, color: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D1_COLOR_F)) -> Void: ...
    @commethod(9)
    def GetColor(self) -> win32more.Windows.Win32.Graphics.Direct2D.Common.D2D1_COLOR_F: ...
class ID2D1SourceTransform(ComPtr):
    extends: win32more.Windows.Win32.Graphics.Direct2D.ID2D1Transform
    _iid_ = Guid('{db1800dd-0c34-4cf9-be90-31cc0a5653e1}')
    @commethod(7)
    def SetRenderInfo(self, renderInfo: win32more.Windows.Win32.Graphics.Direct2D.ID2D1RenderInfo) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(8)
    def Draw(self, target: win32more.Windows.Win32.Graphics.Direct2D.ID2D1Bitmap1, drawRect: POINTER(win32more.Windows.Win32.Foundation.RECT), targetOrigin: win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_POINT_2U) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class ID2D1SpriteBatch(ComPtr):
    extends: win32more.Windows.Win32.Graphics.Direct2D.ID2D1Resource
    _iid_ = Guid('{4dc583bf-3a10-438a-8722-e9765224f1f1}')
    @commethod(4)
    def AddSprites(self, spriteCount: UInt32, destinationRectangles: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_RECT_F), sourceRectangles: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_RECT_U), colors: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D1_COLOR_F), transforms: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_MATRIX_3X2_F), destinationRectanglesStride: UInt32, sourceRectanglesStride: UInt32, colorsStride: UInt32, transformsStride: UInt32) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(5)
    def SetSprites(self, startIndex: UInt32, spriteCount: UInt32, destinationRectangles: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_RECT_F), sourceRectangles: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_RECT_U), colors: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D1_COLOR_F), transforms: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_MATRIX_3X2_F), destinationRectanglesStride: UInt32, sourceRectanglesStride: UInt32, colorsStride: UInt32, transformsStride: UInt32) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(6)
    def GetSprites(self, startIndex: UInt32, spriteCount: UInt32, destinationRectangles: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_RECT_F), sourceRectangles: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_RECT_U), colors: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D1_COLOR_F), transforms: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_MATRIX_3X2_F)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(7)
    def GetSpriteCount(self) -> UInt32: ...
    @commethod(8)
    def Clear(self) -> Void: ...
class ID2D1StrokeStyle(ComPtr):
    extends: win32more.Windows.Win32.Graphics.Direct2D.ID2D1Resource
    _iid_ = Guid('{2cd9069d-12e2-11dc-9fed-001143a055f9}')
    @commethod(4)
    def GetStartCap(self) -> win32more.Windows.Win32.Graphics.Direct2D.D2D1_CAP_STYLE: ...
    @commethod(5)
    def GetEndCap(self) -> win32more.Windows.Win32.Graphics.Direct2D.D2D1_CAP_STYLE: ...
    @commethod(6)
    def GetDashCap(self) -> win32more.Windows.Win32.Graphics.Direct2D.D2D1_CAP_STYLE: ...
    @commethod(7)
    def GetMiterLimit(self) -> Single: ...
    @commethod(8)
    def GetLineJoin(self) -> win32more.Windows.Win32.Graphics.Direct2D.D2D1_LINE_JOIN: ...
    @commethod(9)
    def GetDashOffset(self) -> Single: ...
    @commethod(10)
    def GetDashStyle(self) -> win32more.Windows.Win32.Graphics.Direct2D.D2D1_DASH_STYLE: ...
    @commethod(11)
    def GetDashesCount(self) -> UInt32: ...
    @commethod(12)
    def GetDashes(self, dashes: POINTER(Single), dashesCount: UInt32) -> Void: ...
class ID2D1StrokeStyle1(ComPtr):
    extends: win32more.Windows.Win32.Graphics.Direct2D.ID2D1StrokeStyle
    _iid_ = Guid('{10a72a66-e91c-43f4-993f-ddf4b82b0b4a}')
    @commethod(13)
    def GetStrokeTransformType(self) -> win32more.Windows.Win32.Graphics.Direct2D.D2D1_STROKE_TRANSFORM_TYPE: ...
class ID2D1SvgAttribute(ComPtr):
    extends: win32more.Windows.Win32.Graphics.Direct2D.ID2D1Resource
    _iid_ = Guid('{c9cdb0dd-f8c9-4e70-b7c2-301c80292c5e}')
    @commethod(4)
    def GetElement(self, element: POINTER(win32more.Windows.Win32.Graphics.Direct2D.ID2D1SvgElement)) -> Void: ...
    @commethod(5)
    def Clone(self, attribute: POINTER(win32more.Windows.Win32.Graphics.Direct2D.ID2D1SvgAttribute)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class ID2D1SvgDocument(ComPtr):
    extends: win32more.Windows.Win32.Graphics.Direct2D.ID2D1Resource
    _iid_ = Guid('{86b88e4d-afa4-4d7b-88e4-68a51c4a0aec}')
    @commethod(4)
    def SetViewportSize(self, viewportSize: win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_SIZE_F) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(5)
    def GetViewportSize(self) -> win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_SIZE_F: ...
    @commethod(6)
    def SetRoot(self, root: win32more.Windows.Win32.Graphics.Direct2D.ID2D1SvgElement) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(7)
    def GetRoot(self, root: POINTER(win32more.Windows.Win32.Graphics.Direct2D.ID2D1SvgElement)) -> Void: ...
    @commethod(8)
    def FindElementById(self, id: win32more.Windows.Win32.Foundation.PWSTR, svgElement: POINTER(win32more.Windows.Win32.Graphics.Direct2D.ID2D1SvgElement)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(9)
    def Serialize(self, outputXmlStream: win32more.Windows.Win32.System.Com.IStream, subtree: win32more.Windows.Win32.Graphics.Direct2D.ID2D1SvgElement) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(10)
    def Deserialize(self, inputXmlStream: win32more.Windows.Win32.System.Com.IStream, subtree: POINTER(win32more.Windows.Win32.Graphics.Direct2D.ID2D1SvgElement)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(11)
    def CreatePaint(self, paintType: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SVG_PAINT_TYPE, color: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D1_COLOR_F), id: win32more.Windows.Win32.Foundation.PWSTR, paint: POINTER(win32more.Windows.Win32.Graphics.Direct2D.ID2D1SvgPaint)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(12)
    def CreateStrokeDashArray(self, dashes: POINTER(win32more.Windows.Win32.Graphics.Direct2D.D2D1_SVG_LENGTH), dashesCount: UInt32, strokeDashArray: POINTER(win32more.Windows.Win32.Graphics.Direct2D.ID2D1SvgStrokeDashArray)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(13)
    def CreatePointCollection(self, points: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_POINT_2F), pointsCount: UInt32, pointCollection: POINTER(win32more.Windows.Win32.Graphics.Direct2D.ID2D1SvgPointCollection)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(14)
    def CreatePathData(self, segmentData: POINTER(Single), segmentDataCount: UInt32, commands: POINTER(win32more.Windows.Win32.Graphics.Direct2D.D2D1_SVG_PATH_COMMAND), commandsCount: UInt32, pathData: POINTER(win32more.Windows.Win32.Graphics.Direct2D.ID2D1SvgPathData)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class ID2D1SvgElement(ComPtr):
    extends: win32more.Windows.Win32.Graphics.Direct2D.ID2D1Resource
    _iid_ = Guid('{ac7b67a6-183e-49c1-a823-0ebe40b0db29}')
    @commethod(4)
    def GetDocument(self, document: POINTER(win32more.Windows.Win32.Graphics.Direct2D.ID2D1SvgDocument)) -> Void: ...
    @commethod(5)
    def GetTagName(self, name: win32more.Windows.Win32.Foundation.PWSTR, nameCount: UInt32) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(6)
    def GetTagNameLength(self) -> UInt32: ...
    @commethod(7)
    def IsTextContent(self) -> win32more.Windows.Win32.Foundation.BOOL: ...
    @commethod(8)
    def GetParent(self, parent: POINTER(win32more.Windows.Win32.Graphics.Direct2D.ID2D1SvgElement)) -> Void: ...
    @commethod(9)
    def HasChildren(self) -> win32more.Windows.Win32.Foundation.BOOL: ...
    @commethod(10)
    def GetFirstChild(self, child: POINTER(win32more.Windows.Win32.Graphics.Direct2D.ID2D1SvgElement)) -> Void: ...
    @commethod(11)
    def GetLastChild(self, child: POINTER(win32more.Windows.Win32.Graphics.Direct2D.ID2D1SvgElement)) -> Void: ...
    @commethod(12)
    def GetPreviousChild(self, referenceChild: win32more.Windows.Win32.Graphics.Direct2D.ID2D1SvgElement, previousChild: POINTER(win32more.Windows.Win32.Graphics.Direct2D.ID2D1SvgElement)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(13)
    def GetNextChild(self, referenceChild: win32more.Windows.Win32.Graphics.Direct2D.ID2D1SvgElement, nextChild: POINTER(win32more.Windows.Win32.Graphics.Direct2D.ID2D1SvgElement)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(14)
    def InsertChildBefore(self, newChild: win32more.Windows.Win32.Graphics.Direct2D.ID2D1SvgElement, referenceChild: win32more.Windows.Win32.Graphics.Direct2D.ID2D1SvgElement) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(15)
    def AppendChild(self, newChild: win32more.Windows.Win32.Graphics.Direct2D.ID2D1SvgElement) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(16)
    def ReplaceChild(self, newChild: win32more.Windows.Win32.Graphics.Direct2D.ID2D1SvgElement, oldChild: win32more.Windows.Win32.Graphics.Direct2D.ID2D1SvgElement) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(17)
    def RemoveChild(self, oldChild: win32more.Windows.Win32.Graphics.Direct2D.ID2D1SvgElement) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(18)
    def CreateChild(self, tagName: win32more.Windows.Win32.Foundation.PWSTR, newChild: POINTER(win32more.Windows.Win32.Graphics.Direct2D.ID2D1SvgElement)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(19)
    def IsAttributeSpecified(self, name: win32more.Windows.Win32.Foundation.PWSTR, inherited: POINTER(win32more.Windows.Win32.Foundation.BOOL)) -> win32more.Windows.Win32.Foundation.BOOL: ...
    @commethod(20)
    def GetSpecifiedAttributeCount(self) -> UInt32: ...
    @commethod(21)
    def GetSpecifiedAttributeName(self, index: UInt32, name: win32more.Windows.Win32.Foundation.PWSTR, nameCount: UInt32, inherited: POINTER(win32more.Windows.Win32.Foundation.BOOL)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(22)
    def GetSpecifiedAttributeNameLength(self, index: UInt32, nameLength: POINTER(UInt32), inherited: POINTER(win32more.Windows.Win32.Foundation.BOOL)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(23)
    def RemoveAttribute(self, name: win32more.Windows.Win32.Foundation.PWSTR) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(24)
    def SetTextValue(self, name: win32more.Windows.Win32.Foundation.PWSTR, nameCount: UInt32) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(25)
    def GetTextValue(self, name: win32more.Windows.Win32.Foundation.PWSTR, nameCount: UInt32) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(26)
    def GetTextValueLength(self) -> UInt32: ...
    @commethod(27)
    def SetAttributeValue(self, name: win32more.Windows.Win32.Foundation.PWSTR, value: win32more.Windows.Win32.Graphics.Direct2D.ID2D1SvgAttribute) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(28)
    def SetAttributeValue(self, name: win32more.Windows.Win32.Foundation.PWSTR, type: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SVG_ATTRIBUTE_POD_TYPE, value: VoidPtr, valueSizeInBytes: UInt32) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(29)
    def SetAttributeValue(self, name: win32more.Windows.Win32.Foundation.PWSTR, type: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SVG_ATTRIBUTE_STRING_TYPE, value: win32more.Windows.Win32.Foundation.PWSTR) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(30)
    def GetAttributeValue(self, name: win32more.Windows.Win32.Foundation.PWSTR, riid: POINTER(Guid), value: POINTER(VoidPtr)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(31)
    def GetAttributeValue(self, name: win32more.Windows.Win32.Foundation.PWSTR, type: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SVG_ATTRIBUTE_POD_TYPE, value: VoidPtr, valueSizeInBytes: UInt32) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(32)
    def GetAttributeValue(self, name: win32more.Windows.Win32.Foundation.PWSTR, type: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SVG_ATTRIBUTE_STRING_TYPE, value: win32more.Windows.Win32.Foundation.PWSTR, valueCount: UInt32) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(33)
    def GetAttributeValueLength(self, name: win32more.Windows.Win32.Foundation.PWSTR, type: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SVG_ATTRIBUTE_STRING_TYPE, valueLength: POINTER(UInt32)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class ID2D1SvgGlyphStyle(ComPtr):
    extends: win32more.Windows.Win32.Graphics.Direct2D.ID2D1Resource
    _iid_ = Guid('{af671749-d241-4db8-8e41-dcc2e5c1a438}')
    @commethod(4)
    def SetFill(self, brush: win32more.Windows.Win32.Graphics.Direct2D.ID2D1Brush) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(5)
    def GetFill(self, brush: POINTER(win32more.Windows.Win32.Graphics.Direct2D.ID2D1Brush)) -> Void: ...
    @commethod(6)
    def SetStroke(self, brush: win32more.Windows.Win32.Graphics.Direct2D.ID2D1Brush, strokeWidth: Single, dashes: POINTER(Single), dashesCount: UInt32, dashOffset: Single) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(7)
    def GetStrokeDashesCount(self) -> UInt32: ...
    @commethod(8)
    def GetStroke(self, brush: POINTER(win32more.Windows.Win32.Graphics.Direct2D.ID2D1Brush), strokeWidth: POINTER(Single), dashes: POINTER(Single), dashesCount: UInt32, dashOffset: POINTER(Single)) -> Void: ...
class ID2D1SvgPaint(ComPtr):
    extends: win32more.Windows.Win32.Graphics.Direct2D.ID2D1SvgAttribute
    _iid_ = Guid('{d59bab0a-68a2-455b-a5dc-9eb2854e2490}')
    @commethod(6)
    def SetPaintType(self, paintType: win32more.Windows.Win32.Graphics.Direct2D.D2D1_SVG_PAINT_TYPE) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(7)
    def GetPaintType(self) -> win32more.Windows.Win32.Graphics.Direct2D.D2D1_SVG_PAINT_TYPE: ...
    @commethod(8)
    def SetColor(self, color: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D1_COLOR_F)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(9)
    def GetColor(self, color: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D1_COLOR_F)) -> Void: ...
    @commethod(10)
    def SetId(self, id: win32more.Windows.Win32.Foundation.PWSTR) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(11)
    def GetId(self, id: win32more.Windows.Win32.Foundation.PWSTR, idCount: UInt32) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(12)
    def GetIdLength(self) -> UInt32: ...
class ID2D1SvgPathData(ComPtr):
    extends: win32more.Windows.Win32.Graphics.Direct2D.ID2D1SvgAttribute
    _iid_ = Guid('{c095e4f4-bb98-43d6-9745-4d1b84ec9888}')
    @commethod(6)
    def RemoveSegmentDataAtEnd(self, dataCount: UInt32) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(7)
    def UpdateSegmentData(self, data: POINTER(Single), dataCount: UInt32, startIndex: UInt32) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(8)
    def GetSegmentData(self, data: POINTER(Single), dataCount: UInt32, startIndex: UInt32) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(9)
    def GetSegmentDataCount(self) -> UInt32: ...
    @commethod(10)
    def RemoveCommandsAtEnd(self, commandsCount: UInt32) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(11)
    def UpdateCommands(self, commands: POINTER(win32more.Windows.Win32.Graphics.Direct2D.D2D1_SVG_PATH_COMMAND), commandsCount: UInt32, startIndex: UInt32) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(12)
    def GetCommands(self, commands: POINTER(win32more.Windows.Win32.Graphics.Direct2D.D2D1_SVG_PATH_COMMAND), commandsCount: UInt32, startIndex: UInt32) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(13)
    def GetCommandsCount(self) -> UInt32: ...
    @commethod(14)
    def CreatePathGeometry(self, fillMode: win32more.Windows.Win32.Graphics.Direct2D.Common.D2D1_FILL_MODE, pathGeometry: POINTER(win32more.Windows.Win32.Graphics.Direct2D.ID2D1PathGeometry1)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class ID2D1SvgPointCollection(ComPtr):
    extends: win32more.Windows.Win32.Graphics.Direct2D.ID2D1SvgAttribute
    _iid_ = Guid('{9dbe4c0d-3572-4dd9-9825-5530813bb712}')
    @commethod(6)
    def RemovePointsAtEnd(self, pointsCount: UInt32) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(7)
    def UpdatePoints(self, points: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_POINT_2F), pointsCount: UInt32, startIndex: UInt32) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(8)
    def GetPoints(self, points: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_POINT_2F), pointsCount: UInt32, startIndex: UInt32) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(9)
    def GetPointsCount(self) -> UInt32: ...
class ID2D1SvgStrokeDashArray(ComPtr):
    extends: win32more.Windows.Win32.Graphics.Direct2D.ID2D1SvgAttribute
    _iid_ = Guid('{f1c0ca52-92a3-4f00-b4ce-f35691efd9d9}')
    @commethod(6)
    def RemoveDashesAtEnd(self, dashesCount: UInt32) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(7)
    def UpdateDashes(self, dashes: POINTER(win32more.Windows.Win32.Graphics.Direct2D.D2D1_SVG_LENGTH), dashesCount: UInt32, startIndex: UInt32) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(8)
    def UpdateDashes(self, dashes: POINTER(Single), dashesCount: UInt32, startIndex: UInt32) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(9)
    def GetDashes(self, dashes: POINTER(win32more.Windows.Win32.Graphics.Direct2D.D2D1_SVG_LENGTH), dashesCount: UInt32, startIndex: UInt32) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(10)
    def GetDashes(self, dashes: POINTER(Single), dashesCount: UInt32, startIndex: UInt32) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(11)
    def GetDashesCount(self) -> UInt32: ...
class ID2D1TessellationSink(ComPtr):
    extends: win32more.Windows.Win32.System.Com.IUnknown
    _iid_ = Guid('{2cd906c1-12e2-11dc-9fed-001143a055f9}')
    @commethod(3)
    def AddTriangles(self, triangles: POINTER(win32more.Windows.Win32.Graphics.Direct2D.D2D1_TRIANGLE), trianglesCount: UInt32) -> Void: ...
    @commethod(4)
    def Close(self) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class ID2D1Transform(ComPtr):
    extends: win32more.Windows.Win32.Graphics.Direct2D.ID2D1TransformNode
    _iid_ = Guid('{ef1a287d-342a-4f76-8fdb-da0d6ea9f92b}')
    @commethod(4)
    def MapOutputRectToInputRects(self, outputRect: POINTER(win32more.Windows.Win32.Foundation.RECT), inputRects: POINTER(win32more.Windows.Win32.Foundation.RECT), inputRectsCount: UInt32) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(5)
    def MapInputRectsToOutputRect(self, inputRects: POINTER(win32more.Windows.Win32.Foundation.RECT), inputOpaqueSubRects: POINTER(win32more.Windows.Win32.Foundation.RECT), inputRectCount: UInt32, outputRect: POINTER(win32more.Windows.Win32.Foundation.RECT), outputOpaqueSubRect: POINTER(win32more.Windows.Win32.Foundation.RECT)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(6)
    def MapInvalidRect(self, inputIndex: UInt32, invalidInputRect: win32more.Windows.Win32.Foundation.RECT, invalidOutputRect: POINTER(win32more.Windows.Win32.Foundation.RECT)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class ID2D1TransformGraph(ComPtr):
    extends: win32more.Windows.Win32.System.Com.IUnknown
    _iid_ = Guid('{13d29038-c3e6-4034-9081-13b53a417992}')
    @commethod(3)
    def GetInputCount(self) -> UInt32: ...
    @commethod(4)
    def SetSingleTransformNode(self, node: win32more.Windows.Win32.Graphics.Direct2D.ID2D1TransformNode) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(5)
    def AddNode(self, node: win32more.Windows.Win32.Graphics.Direct2D.ID2D1TransformNode) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(6)
    def RemoveNode(self, node: win32more.Windows.Win32.Graphics.Direct2D.ID2D1TransformNode) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(7)
    def SetOutputNode(self, node: win32more.Windows.Win32.Graphics.Direct2D.ID2D1TransformNode) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(8)
    def ConnectNode(self, fromNode: win32more.Windows.Win32.Graphics.Direct2D.ID2D1TransformNode, toNode: win32more.Windows.Win32.Graphics.Direct2D.ID2D1TransformNode, toNodeInputIndex: UInt32) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(9)
    def ConnectToEffectInput(self, toEffectInputIndex: UInt32, node: win32more.Windows.Win32.Graphics.Direct2D.ID2D1TransformNode, toNodeInputIndex: UInt32) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(10)
    def Clear(self) -> Void: ...
    @commethod(11)
    def SetPassthroughGraph(self, effectInputIndex: UInt32) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class ID2D1TransformNode(ComPtr):
    extends: win32more.Windows.Win32.System.Com.IUnknown
    _iid_ = Guid('{b2efe1e7-729f-4102-949f-505fa21bf666}')
    @commethod(3)
    def GetInputCount(self) -> UInt32: ...
class ID2D1TransformedGeometry(ComPtr):
    extends: win32more.Windows.Win32.Graphics.Direct2D.ID2D1Geometry
    _iid_ = Guid('{2cd906bb-12e2-11dc-9fed-001143a055f9}')
    @commethod(17)
    def GetSourceGeometry(self, sourceGeometry: POINTER(win32more.Windows.Win32.Graphics.Direct2D.ID2D1Geometry)) -> Void: ...
    @commethod(18)
    def GetTransform(self, transform: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_MATRIX_3X2_F)) -> Void: ...
class ID2D1TransformedImageSource(ComPtr):
    extends: win32more.Windows.Win32.Graphics.Direct2D.ID2D1Image
    _iid_ = Guid('{7f1f79e5-2796-416c-8f55-700f911445e5}')
    @commethod(4)
    def GetSource(self, imageSource: POINTER(win32more.Windows.Win32.Graphics.Direct2D.ID2D1ImageSource)) -> Void: ...
    @commethod(5)
    def GetProperties(self, properties: POINTER(win32more.Windows.Win32.Graphics.Direct2D.D2D1_TRANSFORMED_IMAGE_SOURCE_PROPERTIES)) -> Void: ...
class ID2D1VertexBuffer(ComPtr):
    extends: win32more.Windows.Win32.System.Com.IUnknown
    _iid_ = Guid('{9b8b1336-00a5-4668-92b7-ced5d8bf9b7b}')
    @commethod(3)
    def Map(self, data: POINTER(POINTER(Byte)), bufferSize: UInt32) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(4)
    def Unmap(self) -> win32more.Windows.Win32.Foundation.HRESULT: ...
@winfunctype_pointer
def PD2D1_EFFECT_FACTORY(effectImpl: POINTER(win32more.Windows.Win32.System.Com.IUnknown)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
@winfunctype_pointer
def PD2D1_PROPERTY_GET_FUNCTION(effect: win32more.Windows.Win32.System.Com.IUnknown, data: POINTER(Byte), dataSize: UInt32, actualSize: POINTER(UInt32)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
@winfunctype_pointer
def PD2D1_PROPERTY_SET_FUNCTION(effect: win32more.Windows.Win32.System.Com.IUnknown, data: POINTER(Byte), dataSize: UInt32) -> win32more.Windows.Win32.Foundation.HRESULT: ...


make_ready(__name__)
