from __future__ import annotations
from win32more.win32.prelude import *
import win32more.Windows.Win32.Foundation
import win32more.Windows.Win32.System.Com
import win32more.Windows.Win32.System.TaskScheduler
import win32more.Windows.Win32.System.Variant
import win32more.Windows.Win32.UI.Controls
TASK_SUNDAY: UInt32 = 1
TASK_MONDAY: UInt32 = 2
TASK_TUESDAY: UInt32 = 4
TASK_WEDNESDAY: UInt32 = 8
TASK_THURSDAY: UInt32 = 16
TASK_FRIDAY: UInt32 = 32
TASK_SATURDAY: UInt32 = 64
TASK_FIRST_WEEK: UInt32 = 1
TASK_SECOND_WEEK: UInt32 = 2
TASK_THIRD_WEEK: UInt32 = 3
TASK_FOURTH_WEEK: UInt32 = 4
TASK_LAST_WEEK: UInt32 = 5
TASK_JANUARY: UInt32 = 1
TASK_FEBRUARY: UInt32 = 2
TASK_MARCH: UInt32 = 4
TASK_APRIL: UInt32 = 8
TASK_MAY: UInt32 = 16
TASK_JUNE: UInt32 = 32
TASK_JULY: UInt32 = 64
TASK_AUGUST: UInt32 = 128
TASK_SEPTEMBER: UInt32 = 256
TASK_OCTOBER: UInt32 = 512
TASK_NOVEMBER: UInt32 = 1024
TASK_DECEMBER: UInt32 = 2048
TASK_FLAG_INTERACTIVE: UInt32 = 1
TASK_FLAG_DELETE_WHEN_DONE: UInt32 = 2
TASK_FLAG_DISABLED: UInt32 = 4
TASK_FLAG_START_ONLY_IF_IDLE: UInt32 = 16
TASK_FLAG_KILL_ON_IDLE_END: UInt32 = 32
TASK_FLAG_DONT_START_IF_ON_BATTERIES: UInt32 = 64
TASK_FLAG_KILL_IF_GOING_ON_BATTERIES: UInt32 = 128
TASK_FLAG_RUN_ONLY_IF_DOCKED: UInt32 = 256
TASK_FLAG_HIDDEN: UInt32 = 512
TASK_FLAG_RUN_IF_CONNECTED_TO_INTERNET: UInt32 = 1024
TASK_FLAG_RESTART_ON_IDLE_RESUME: UInt32 = 2048
TASK_FLAG_SYSTEM_REQUIRED: UInt32 = 4096
TASK_FLAG_RUN_ONLY_IF_LOGGED_ON: UInt32 = 8192
TASK_TRIGGER_FLAG_HAS_END_DATE: UInt32 = 1
TASK_TRIGGER_FLAG_KILL_AT_DURATION_END: UInt32 = 2
TASK_TRIGGER_FLAG_DISABLED: UInt32 = 4
TASK_MAX_RUN_TIMES: UInt32 = 1440
CLSID_CTask: Guid = Guid('{148bd520-a2ab-11ce-b11f-00aa00530503}')
CLSID_CTaskScheduler: Guid = Guid('{148bd52a-a2ab-11ce-b11f-00aa00530503}')
class DAILY(Structure):
    DaysInterval: UInt16
class IAction(ComPtr):
    extends: win32more.Windows.Win32.System.Com.IDispatch
    _iid_ = Guid('{bae54997-48b1-4cbe-9965-d6be263ebea4}')
    @commethod(7)
    def get_Id(self, pId: POINTER(win32more.Windows.Win32.Foundation.BSTR)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(8)
    def put_Id(self, Id: win32more.Windows.Win32.Foundation.BSTR) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(9)
    def get_Type(self, pType: POINTER(win32more.Windows.Win32.System.TaskScheduler.TASK_ACTION_TYPE)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class IActionCollection(ComPtr):
    extends: win32more.Windows.Win32.System.Com.IDispatch
    _iid_ = Guid('{02820e19-7b98-4ed2-b2e8-fdccceff619b}')
    @commethod(7)
    def get_Count(self, pCount: POINTER(Int32)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(8)
    def get_Item(self, index: Int32, ppAction: POINTER(win32more.Windows.Win32.System.TaskScheduler.IAction)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(9)
    def get__NewEnum(self, ppEnum: POINTER(win32more.Windows.Win32.System.Com.IUnknown)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(10)
    def get_XmlText(self, pText: POINTER(win32more.Windows.Win32.Foundation.BSTR)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(11)
    def put_XmlText(self, text: win32more.Windows.Win32.Foundation.BSTR) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(12)
    def Create(self, type: win32more.Windows.Win32.System.TaskScheduler.TASK_ACTION_TYPE, ppAction: POINTER(win32more.Windows.Win32.System.TaskScheduler.IAction)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(13)
    def Remove(self, index: win32more.Windows.Win32.System.Variant.VARIANT) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(14)
    def Clear(self) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(15)
    def get_Context(self, pContext: POINTER(win32more.Windows.Win32.Foundation.BSTR)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(16)
    def put_Context(self, context: win32more.Windows.Win32.Foundation.BSTR) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class IBootTrigger(ComPtr):
    extends: win32more.Windows.Win32.System.TaskScheduler.ITrigger
    _iid_ = Guid('{2a9c35da-d357-41f4-bbc1-207ac1b1f3cb}')
    @commethod(20)
    def get_Delay(self, pDelay: POINTER(win32more.Windows.Win32.Foundation.BSTR)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(21)
    def put_Delay(self, delay: win32more.Windows.Win32.Foundation.BSTR) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class IComHandlerAction(ComPtr):
    extends: win32more.Windows.Win32.System.TaskScheduler.IAction
    _iid_ = Guid('{6d2fd252-75c5-4f66-90ba-2a7d8cc3039f}')
    @commethod(10)
    def get_ClassId(self, pClsid: POINTER(win32more.Windows.Win32.Foundation.BSTR)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(11)
    def put_ClassId(self, clsid: win32more.Windows.Win32.Foundation.BSTR) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(12)
    def get_Data(self, pData: POINTER(win32more.Windows.Win32.Foundation.BSTR)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(13)
    def put_Data(self, data: win32more.Windows.Win32.Foundation.BSTR) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class IDailyTrigger(ComPtr):
    extends: win32more.Windows.Win32.System.TaskScheduler.ITrigger
    _iid_ = Guid('{126c5cd8-b288-41d5-8dbf-e491446adc5c}')
    @commethod(20)
    def get_DaysInterval(self, pDays: POINTER(Int16)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(21)
    def put_DaysInterval(self, days: Int16) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(22)
    def get_RandomDelay(self, pRandomDelay: POINTER(win32more.Windows.Win32.Foundation.BSTR)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(23)
    def put_RandomDelay(self, randomDelay: win32more.Windows.Win32.Foundation.BSTR) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class IEmailAction(ComPtr):
    extends: win32more.Windows.Win32.System.TaskScheduler.IAction
    _iid_ = Guid('{10f62c64-7e16-4314-a0c2-0c3683f99d40}')
    @commethod(10)
    def get_Server(self, pServer: POINTER(win32more.Windows.Win32.Foundation.BSTR)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(11)
    def put_Server(self, server: win32more.Windows.Win32.Foundation.BSTR) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(12)
    def get_Subject(self, pSubject: POINTER(win32more.Windows.Win32.Foundation.BSTR)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(13)
    def put_Subject(self, subject: win32more.Windows.Win32.Foundation.BSTR) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(14)
    def get_To(self, pTo: POINTER(win32more.Windows.Win32.Foundation.BSTR)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(15)
    def put_To(self, to: win32more.Windows.Win32.Foundation.BSTR) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(16)
    def get_Cc(self, pCc: POINTER(win32more.Windows.Win32.Foundation.BSTR)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(17)
    def put_Cc(self, cc: win32more.Windows.Win32.Foundation.BSTR) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(18)
    def get_Bcc(self, pBcc: POINTER(win32more.Windows.Win32.Foundation.BSTR)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(19)
    def put_Bcc(self, bcc: win32more.Windows.Win32.Foundation.BSTR) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(20)
    def get_ReplyTo(self, pReplyTo: POINTER(win32more.Windows.Win32.Foundation.BSTR)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(21)
    def put_ReplyTo(self, replyTo: win32more.Windows.Win32.Foundation.BSTR) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(22)
    def get_From(self, pFrom: POINTER(win32more.Windows.Win32.Foundation.BSTR)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(23)
    def put_From(self, from_: win32more.Windows.Win32.Foundation.BSTR) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(24)
    def get_HeaderFields(self, ppHeaderFields: POINTER(win32more.Windows.Win32.System.TaskScheduler.ITaskNamedValueCollection)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(25)
    def put_HeaderFields(self, pHeaderFields: win32more.Windows.Win32.System.TaskScheduler.ITaskNamedValueCollection) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(26)
    def get_Body(self, pBody: POINTER(win32more.Windows.Win32.Foundation.BSTR)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(27)
    def put_Body(self, body: win32more.Windows.Win32.Foundation.BSTR) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(28)
    def get_Attachments(self, pAttachements: POINTER(POINTER(win32more.Windows.Win32.System.Com.SAFEARRAY))) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(29)
    def put_Attachments(self, pAttachements: POINTER(win32more.Windows.Win32.System.Com.SAFEARRAY)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class IEnumWorkItems(ComPtr):
    extends: win32more.Windows.Win32.System.Com.IUnknown
    _iid_ = Guid('{148bd528-a2ab-11ce-b11f-00aa00530503}')
    @commethod(3)
    def Next(self, celt: UInt32, rgpwszNames: POINTER(POINTER(win32more.Windows.Win32.Foundation.PWSTR)), pceltFetched: POINTER(UInt32)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(4)
    def Skip(self, celt: UInt32) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(5)
    def Reset(self) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(6)
    def Clone(self, ppEnumWorkItems: POINTER(win32more.Windows.Win32.System.TaskScheduler.IEnumWorkItems)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class IEventTrigger(ComPtr):
    extends: win32more.Windows.Win32.System.TaskScheduler.ITrigger
    _iid_ = Guid('{d45b0167-9653-4eef-b94f-0732ca7af251}')
    @commethod(20)
    def get_Subscription(self, pQuery: POINTER(win32more.Windows.Win32.Foundation.BSTR)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(21)
    def put_Subscription(self, query: win32more.Windows.Win32.Foundation.BSTR) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(22)
    def get_Delay(self, pDelay: POINTER(win32more.Windows.Win32.Foundation.BSTR)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(23)
    def put_Delay(self, delay: win32more.Windows.Win32.Foundation.BSTR) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(24)
    def get_ValueQueries(self, ppNamedXPaths: POINTER(win32more.Windows.Win32.System.TaskScheduler.ITaskNamedValueCollection)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(25)
    def put_ValueQueries(self, pNamedXPaths: win32more.Windows.Win32.System.TaskScheduler.ITaskNamedValueCollection) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class IExecAction(ComPtr):
    extends: win32more.Windows.Win32.System.TaskScheduler.IAction
    _iid_ = Guid('{4c3d624d-fd6b-49a3-b9b7-09cb3cd3f047}')
    @commethod(10)
    def get_Path(self, pPath: POINTER(win32more.Windows.Win32.Foundation.BSTR)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(11)
    def put_Path(self, path: win32more.Windows.Win32.Foundation.BSTR) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(12)
    def get_Arguments(self, pArgument: POINTER(win32more.Windows.Win32.Foundation.BSTR)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(13)
    def put_Arguments(self, argument: win32more.Windows.Win32.Foundation.BSTR) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(14)
    def get_WorkingDirectory(self, pWorkingDirectory: POINTER(win32more.Windows.Win32.Foundation.BSTR)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(15)
    def put_WorkingDirectory(self, workingDirectory: win32more.Windows.Win32.Foundation.BSTR) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class IExecAction2(ComPtr):
    extends: win32more.Windows.Win32.System.TaskScheduler.IExecAction
    _iid_ = Guid('{f2a82542-bda5-4e6b-9143-e2bf4f8987b6}')
    @commethod(16)
    def get_HideAppWindow(self, pHideAppWindow: POINTER(win32more.Windows.Win32.Foundation.VARIANT_BOOL)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(17)
    def put_HideAppWindow(self, hideAppWindow: win32more.Windows.Win32.Foundation.VARIANT_BOOL) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class IIdleSettings(ComPtr):
    extends: win32more.Windows.Win32.System.Com.IDispatch
    _iid_ = Guid('{84594461-0053-4342-a8fd-088fabf11f32}')
    @commethod(7)
    def get_IdleDuration(self, pDelay: POINTER(win32more.Windows.Win32.Foundation.BSTR)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(8)
    def put_IdleDuration(self, delay: win32more.Windows.Win32.Foundation.BSTR) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(9)
    def get_WaitTimeout(self, pTimeout: POINTER(win32more.Windows.Win32.Foundation.BSTR)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(10)
    def put_WaitTimeout(self, timeout: win32more.Windows.Win32.Foundation.BSTR) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(11)
    def get_StopOnIdleEnd(self, pStop: POINTER(win32more.Windows.Win32.Foundation.VARIANT_BOOL)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(12)
    def put_StopOnIdleEnd(self, stop: win32more.Windows.Win32.Foundation.VARIANT_BOOL) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(13)
    def get_RestartOnIdle(self, pRestart: POINTER(win32more.Windows.Win32.Foundation.VARIANT_BOOL)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(14)
    def put_RestartOnIdle(self, restart: win32more.Windows.Win32.Foundation.VARIANT_BOOL) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class IIdleTrigger(ComPtr):
    extends: win32more.Windows.Win32.System.TaskScheduler.ITrigger
    _iid_ = Guid('{d537d2b0-9fb3-4d34-9739-1ff5ce7b1ef3}')
class ILogonTrigger(ComPtr):
    extends: win32more.Windows.Win32.System.TaskScheduler.ITrigger
    _iid_ = Guid('{72dade38-fae4-4b3e-baf4-5d009af02b1c}')
    @commethod(20)
    def get_Delay(self, pDelay: POINTER(win32more.Windows.Win32.Foundation.BSTR)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(21)
    def put_Delay(self, delay: win32more.Windows.Win32.Foundation.BSTR) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(22)
    def get_UserId(self, pUser: POINTER(win32more.Windows.Win32.Foundation.BSTR)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(23)
    def put_UserId(self, user: win32more.Windows.Win32.Foundation.BSTR) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class IMaintenanceSettings(ComPtr):
    extends: win32more.Windows.Win32.System.Com.IDispatch
    _iid_ = Guid('{a6024fa8-9652-4adb-a6bf-5cfcd877a7ba}')
    @commethod(7)
    def put_Period(self, value: win32more.Windows.Win32.Foundation.BSTR) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(8)
    def get_Period(self, target: POINTER(win32more.Windows.Win32.Foundation.BSTR)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(9)
    def put_Deadline(self, value: win32more.Windows.Win32.Foundation.BSTR) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(10)
    def get_Deadline(self, target: POINTER(win32more.Windows.Win32.Foundation.BSTR)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(11)
    def put_Exclusive(self, value: win32more.Windows.Win32.Foundation.VARIANT_BOOL) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(12)
    def get_Exclusive(self, target: POINTER(win32more.Windows.Win32.Foundation.VARIANT_BOOL)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class IMonthlyDOWTrigger(ComPtr):
    extends: win32more.Windows.Win32.System.TaskScheduler.ITrigger
    _iid_ = Guid('{77d025a3-90fa-43aa-b52e-cda5499b946a}')
    @commethod(20)
    def get_DaysOfWeek(self, pDays: POINTER(Int16)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(21)
    def put_DaysOfWeek(self, days: Int16) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(22)
    def get_WeeksOfMonth(self, pWeeks: POINTER(Int16)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(23)
    def put_WeeksOfMonth(self, weeks: Int16) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(24)
    def get_MonthsOfYear(self, pMonths: POINTER(Int16)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(25)
    def put_MonthsOfYear(self, months: Int16) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(26)
    def get_RunOnLastWeekOfMonth(self, pLastWeek: POINTER(win32more.Windows.Win32.Foundation.VARIANT_BOOL)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(27)
    def put_RunOnLastWeekOfMonth(self, lastWeek: win32more.Windows.Win32.Foundation.VARIANT_BOOL) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(28)
    def get_RandomDelay(self, pRandomDelay: POINTER(win32more.Windows.Win32.Foundation.BSTR)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(29)
    def put_RandomDelay(self, randomDelay: win32more.Windows.Win32.Foundation.BSTR) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class IMonthlyTrigger(ComPtr):
    extends: win32more.Windows.Win32.System.TaskScheduler.ITrigger
    _iid_ = Guid('{97c45ef1-6b02-4a1a-9c0e-1ebfba1500ac}')
    @commethod(20)
    def get_DaysOfMonth(self, pDays: POINTER(Int32)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(21)
    def put_DaysOfMonth(self, days: Int32) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(22)
    def get_MonthsOfYear(self, pMonths: POINTER(Int16)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(23)
    def put_MonthsOfYear(self, months: Int16) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(24)
    def get_RunOnLastDayOfMonth(self, pLastDay: POINTER(win32more.Windows.Win32.Foundation.VARIANT_BOOL)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(25)
    def put_RunOnLastDayOfMonth(self, lastDay: win32more.Windows.Win32.Foundation.VARIANT_BOOL) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(26)
    def get_RandomDelay(self, pRandomDelay: POINTER(win32more.Windows.Win32.Foundation.BSTR)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(27)
    def put_RandomDelay(self, randomDelay: win32more.Windows.Win32.Foundation.BSTR) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class INetworkSettings(ComPtr):
    extends: win32more.Windows.Win32.System.Com.IDispatch
    _iid_ = Guid('{9f7dea84-c30b-4245-80b6-00e9f646f1b4}')
    @commethod(7)
    def get_Name(self, pName: POINTER(win32more.Windows.Win32.Foundation.BSTR)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(8)
    def put_Name(self, name: win32more.Windows.Win32.Foundation.BSTR) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(9)
    def get_Id(self, pId: POINTER(win32more.Windows.Win32.Foundation.BSTR)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(10)
    def put_Id(self, id: win32more.Windows.Win32.Foundation.BSTR) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class IPrincipal(ComPtr):
    extends: win32more.Windows.Win32.System.Com.IDispatch
    _iid_ = Guid('{d98d51e5-c9b4-496a-a9c1-18980261cf0f}')
    @commethod(7)
    def get_Id(self, pId: POINTER(win32more.Windows.Win32.Foundation.BSTR)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(8)
    def put_Id(self, Id: win32more.Windows.Win32.Foundation.BSTR) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(9)
    def get_DisplayName(self, pName: POINTER(win32more.Windows.Win32.Foundation.BSTR)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(10)
    def put_DisplayName(self, name: win32more.Windows.Win32.Foundation.BSTR) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(11)
    def get_UserId(self, pUser: POINTER(win32more.Windows.Win32.Foundation.BSTR)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(12)
    def put_UserId(self, user: win32more.Windows.Win32.Foundation.BSTR) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(13)
    def get_LogonType(self, pLogon: POINTER(win32more.Windows.Win32.System.TaskScheduler.TASK_LOGON_TYPE)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(14)
    def put_LogonType(self, logon: win32more.Windows.Win32.System.TaskScheduler.TASK_LOGON_TYPE) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(15)
    def get_GroupId(self, pGroup: POINTER(win32more.Windows.Win32.Foundation.BSTR)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(16)
    def put_GroupId(self, group: win32more.Windows.Win32.Foundation.BSTR) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(17)
    def get_RunLevel(self, pRunLevel: POINTER(win32more.Windows.Win32.System.TaskScheduler.TASK_RUNLEVEL_TYPE)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(18)
    def put_RunLevel(self, runLevel: win32more.Windows.Win32.System.TaskScheduler.TASK_RUNLEVEL_TYPE) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class IPrincipal2(ComPtr):
    extends: win32more.Windows.Win32.System.Com.IDispatch
    _iid_ = Guid('{248919ae-e345-4a6d-8aeb-e0d3165c904e}')
    @commethod(7)
    def get_ProcessTokenSidType(self, pProcessTokenSidType: POINTER(win32more.Windows.Win32.System.TaskScheduler.TASK_PROCESSTOKENSID_TYPE)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(8)
    def put_ProcessTokenSidType(self, processTokenSidType: win32more.Windows.Win32.System.TaskScheduler.TASK_PROCESSTOKENSID_TYPE) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(9)
    def get_RequiredPrivilegeCount(self, pCount: POINTER(Int32)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(10)
    def get_RequiredPrivilege(self, index: Int32, pPrivilege: POINTER(win32more.Windows.Win32.Foundation.BSTR)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(11)
    def AddRequiredPrivilege(self, privilege: win32more.Windows.Win32.Foundation.BSTR) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class IProvideTaskPage(ComPtr):
    extends: win32more.Windows.Win32.System.Com.IUnknown
    _iid_ = Guid('{4086658a-cbbb-11cf-b604-00c04fd8d565}')
    @commethod(3)
    def GetPage(self, tpType: win32more.Windows.Win32.System.TaskScheduler.TASKPAGE, fPersistChanges: win32more.Windows.Win32.Foundation.BOOL, phPage: POINTER(win32more.Windows.Win32.UI.Controls.HPROPSHEETPAGE)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class IRegisteredTask(ComPtr):
    extends: win32more.Windows.Win32.System.Com.IDispatch
    _iid_ = Guid('{9c86f320-dee3-4dd1-b972-a303f26b061e}')
    @commethod(7)
    def get_Name(self, pName: POINTER(win32more.Windows.Win32.Foundation.BSTR)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(8)
    def get_Path(self, pPath: POINTER(win32more.Windows.Win32.Foundation.BSTR)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(9)
    def get_State(self, pState: POINTER(win32more.Windows.Win32.System.TaskScheduler.TASK_STATE)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(10)
    def get_Enabled(self, pEnabled: POINTER(win32more.Windows.Win32.Foundation.VARIANT_BOOL)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(11)
    def put_Enabled(self, enabled: win32more.Windows.Win32.Foundation.VARIANT_BOOL) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(12)
    def Run(self, params: win32more.Windows.Win32.System.Variant.VARIANT, ppRunningTask: POINTER(win32more.Windows.Win32.System.TaskScheduler.IRunningTask)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(13)
    def RunEx(self, params: win32more.Windows.Win32.System.Variant.VARIANT, flags: Int32, sessionID: Int32, user: win32more.Windows.Win32.Foundation.BSTR, ppRunningTask: POINTER(win32more.Windows.Win32.System.TaskScheduler.IRunningTask)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(14)
    def GetInstances(self, flags: Int32, ppRunningTasks: POINTER(win32more.Windows.Win32.System.TaskScheduler.IRunningTaskCollection)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(15)
    def get_LastRunTime(self, pLastRunTime: POINTER(Double)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(16)
    def get_LastTaskResult(self, pLastTaskResult: POINTER(Int32)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(17)
    def get_NumberOfMissedRuns(self, pNumberOfMissedRuns: POINTER(Int32)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(18)
    def get_NextRunTime(self, pNextRunTime: POINTER(Double)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(19)
    def get_Definition(self, ppDefinition: POINTER(win32more.Windows.Win32.System.TaskScheduler.ITaskDefinition)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(20)
    def get_Xml(self, pXml: POINTER(win32more.Windows.Win32.Foundation.BSTR)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(21)
    def GetSecurityDescriptor(self, securityInformation: Int32, pSddl: POINTER(win32more.Windows.Win32.Foundation.BSTR)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(22)
    def SetSecurityDescriptor(self, sddl: win32more.Windows.Win32.Foundation.BSTR, flags: Int32) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(23)
    def Stop(self, flags: Int32) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(24)
    def GetRunTimes(self, pstStart: POINTER(win32more.Windows.Win32.Foundation.SYSTEMTIME), pstEnd: POINTER(win32more.Windows.Win32.Foundation.SYSTEMTIME), pCount: POINTER(UInt32), pRunTimes: POINTER(POINTER(win32more.Windows.Win32.Foundation.SYSTEMTIME))) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class IRegisteredTaskCollection(ComPtr):
    extends: win32more.Windows.Win32.System.Com.IDispatch
    _iid_ = Guid('{86627eb4-42a7-41e4-a4d9-ac33a72f2d52}')
    @commethod(7)
    def get_Count(self, pCount: POINTER(Int32)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(8)
    def get_Item(self, index: win32more.Windows.Win32.System.Variant.VARIANT, ppRegisteredTask: POINTER(win32more.Windows.Win32.System.TaskScheduler.IRegisteredTask)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(9)
    def get__NewEnum(self, ppEnum: POINTER(win32more.Windows.Win32.System.Com.IUnknown)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class IRegistrationInfo(ComPtr):
    extends: win32more.Windows.Win32.System.Com.IDispatch
    _iid_ = Guid('{416d8b73-cb41-4ea1-805c-9be9a5ac4a74}')
    @commethod(7)
    def get_Description(self, pDescription: POINTER(win32more.Windows.Win32.Foundation.BSTR)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(8)
    def put_Description(self, description: win32more.Windows.Win32.Foundation.BSTR) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(9)
    def get_Author(self, pAuthor: POINTER(win32more.Windows.Win32.Foundation.BSTR)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(10)
    def put_Author(self, author: win32more.Windows.Win32.Foundation.BSTR) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(11)
    def get_Version(self, pVersion: POINTER(win32more.Windows.Win32.Foundation.BSTR)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(12)
    def put_Version(self, version: win32more.Windows.Win32.Foundation.BSTR) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(13)
    def get_Date(self, pDate: POINTER(win32more.Windows.Win32.Foundation.BSTR)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(14)
    def put_Date(self, date: win32more.Windows.Win32.Foundation.BSTR) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(15)
    def get_Documentation(self, pDocumentation: POINTER(win32more.Windows.Win32.Foundation.BSTR)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(16)
    def put_Documentation(self, documentation: win32more.Windows.Win32.Foundation.BSTR) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(17)
    def get_XmlText(self, pText: POINTER(win32more.Windows.Win32.Foundation.BSTR)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(18)
    def put_XmlText(self, text: win32more.Windows.Win32.Foundation.BSTR) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(19)
    def get_URI(self, pUri: POINTER(win32more.Windows.Win32.Foundation.BSTR)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(20)
    def put_URI(self, uri: win32more.Windows.Win32.Foundation.BSTR) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(21)
    def get_SecurityDescriptor(self, pSddl: POINTER(win32more.Windows.Win32.System.Variant.VARIANT)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(22)
    def put_SecurityDescriptor(self, sddl: win32more.Windows.Win32.System.Variant.VARIANT) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(23)
    def get_Source(self, pSource: POINTER(win32more.Windows.Win32.Foundation.BSTR)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(24)
    def put_Source(self, source: win32more.Windows.Win32.Foundation.BSTR) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class IRegistrationTrigger(ComPtr):
    extends: win32more.Windows.Win32.System.TaskScheduler.ITrigger
    _iid_ = Guid('{4c8fec3a-c218-4e0c-b23d-629024db91a2}')
    @commethod(20)
    def get_Delay(self, pDelay: POINTER(win32more.Windows.Win32.Foundation.BSTR)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(21)
    def put_Delay(self, delay: win32more.Windows.Win32.Foundation.BSTR) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class IRepetitionPattern(ComPtr):
    extends: win32more.Windows.Win32.System.Com.IDispatch
    _iid_ = Guid('{7fb9acf1-26be-400e-85b5-294b9c75dfd6}')
    @commethod(7)
    def get_Interval(self, pInterval: POINTER(win32more.Windows.Win32.Foundation.BSTR)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(8)
    def put_Interval(self, interval: win32more.Windows.Win32.Foundation.BSTR) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(9)
    def get_Duration(self, pDuration: POINTER(win32more.Windows.Win32.Foundation.BSTR)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(10)
    def put_Duration(self, duration: win32more.Windows.Win32.Foundation.BSTR) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(11)
    def get_StopAtDurationEnd(self, pStop: POINTER(win32more.Windows.Win32.Foundation.VARIANT_BOOL)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(12)
    def put_StopAtDurationEnd(self, stop: win32more.Windows.Win32.Foundation.VARIANT_BOOL) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class IRunningTask(ComPtr):
    extends: win32more.Windows.Win32.System.Com.IDispatch
    _iid_ = Guid('{653758fb-7b9a-4f1e-a471-beeb8e9b834e}')
    @commethod(7)
    def get_Name(self, pName: POINTER(win32more.Windows.Win32.Foundation.BSTR)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(8)
    def get_InstanceGuid(self, pGuid: POINTER(win32more.Windows.Win32.Foundation.BSTR)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(9)
    def get_Path(self, pPath: POINTER(win32more.Windows.Win32.Foundation.BSTR)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(10)
    def get_State(self, pState: POINTER(win32more.Windows.Win32.System.TaskScheduler.TASK_STATE)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(11)
    def get_CurrentAction(self, pName: POINTER(win32more.Windows.Win32.Foundation.BSTR)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(12)
    def Stop(self) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(13)
    def Refresh(self) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(14)
    def get_EnginePID(self, pPID: POINTER(UInt32)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class IRunningTaskCollection(ComPtr):
    extends: win32more.Windows.Win32.System.Com.IDispatch
    _iid_ = Guid('{6a67614b-6828-4fec-aa54-6d52e8f1f2db}')
    @commethod(7)
    def get_Count(self, pCount: POINTER(Int32)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(8)
    def get_Item(self, index: win32more.Windows.Win32.System.Variant.VARIANT, ppRunningTask: POINTER(win32more.Windows.Win32.System.TaskScheduler.IRunningTask)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(9)
    def get__NewEnum(self, ppEnum: POINTER(win32more.Windows.Win32.System.Com.IUnknown)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class IScheduledWorkItem(ComPtr):
    extends: win32more.Windows.Win32.System.Com.IUnknown
    _iid_ = Guid('{a6b952f0-a4b1-11d0-997d-00aa006887ec}')
    @commethod(3)
    def CreateTrigger(self, piNewTrigger: POINTER(UInt16), ppTrigger: POINTER(win32more.Windows.Win32.System.TaskScheduler.ITaskTrigger)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(4)
    def DeleteTrigger(self, iTrigger: UInt16) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(5)
    def GetTriggerCount(self, pwCount: POINTER(UInt16)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(6)
    def GetTrigger(self, iTrigger: UInt16, ppTrigger: POINTER(win32more.Windows.Win32.System.TaskScheduler.ITaskTrigger)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(7)
    def GetTriggerString(self, iTrigger: UInt16, ppwszTrigger: POINTER(win32more.Windows.Win32.Foundation.PWSTR)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(8)
    def GetRunTimes(self, pstBegin: POINTER(win32more.Windows.Win32.Foundation.SYSTEMTIME), pstEnd: POINTER(win32more.Windows.Win32.Foundation.SYSTEMTIME), pCount: POINTER(UInt16), rgstTaskTimes: POINTER(POINTER(win32more.Windows.Win32.Foundation.SYSTEMTIME))) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(9)
    def GetNextRunTime(self, pstNextRun: POINTER(win32more.Windows.Win32.Foundation.SYSTEMTIME)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(10)
    def SetIdleWait(self, wIdleMinutes: UInt16, wDeadlineMinutes: UInt16) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(11)
    def GetIdleWait(self, pwIdleMinutes: POINTER(UInt16), pwDeadlineMinutes: POINTER(UInt16)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(12)
    def Run(self) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(13)
    def Terminate(self) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(14)
    def EditWorkItem(self, hParent: win32more.Windows.Win32.Foundation.HWND, dwReserved: UInt32) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(15)
    def GetMostRecentRunTime(self, pstLastRun: POINTER(win32more.Windows.Win32.Foundation.SYSTEMTIME)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(16)
    def GetStatus(self, phrStatus: POINTER(win32more.Windows.Win32.Foundation.HRESULT)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(17)
    def GetExitCode(self, pdwExitCode: POINTER(UInt32)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(18)
    def SetComment(self, pwszComment: win32more.Windows.Win32.Foundation.PWSTR) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(19)
    def GetComment(self, ppwszComment: POINTER(win32more.Windows.Win32.Foundation.PWSTR)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(20)
    def SetCreator(self, pwszCreator: win32more.Windows.Win32.Foundation.PWSTR) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(21)
    def GetCreator(self, ppwszCreator: POINTER(win32more.Windows.Win32.Foundation.PWSTR)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(22)
    def SetWorkItemData(self, cbData: UInt16, rgbData: POINTER(Byte)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(23)
    def GetWorkItemData(self, pcbData: POINTER(UInt16), prgbData: POINTER(POINTER(Byte))) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(24)
    def SetErrorRetryCount(self, wRetryCount: UInt16) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(25)
    def GetErrorRetryCount(self, pwRetryCount: POINTER(UInt16)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(26)
    def SetErrorRetryInterval(self, wRetryInterval: UInt16) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(27)
    def GetErrorRetryInterval(self, pwRetryInterval: POINTER(UInt16)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(28)
    def SetFlags(self, dwFlags: UInt32) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(29)
    def GetFlags(self, pdwFlags: POINTER(UInt32)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(30)
    def SetAccountInformation(self, pwszAccountName: win32more.Windows.Win32.Foundation.PWSTR, pwszPassword: win32more.Windows.Win32.Foundation.PWSTR) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(31)
    def GetAccountInformation(self, ppwszAccountName: POINTER(win32more.Windows.Win32.Foundation.PWSTR)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class ISessionStateChangeTrigger(ComPtr):
    extends: win32more.Windows.Win32.System.TaskScheduler.ITrigger
    _iid_ = Guid('{754da71b-4385-4475-9dd9-598294fa3641}')
    @commethod(20)
    def get_Delay(self, pDelay: POINTER(win32more.Windows.Win32.Foundation.BSTR)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(21)
    def put_Delay(self, delay: win32more.Windows.Win32.Foundation.BSTR) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(22)
    def get_UserId(self, pUser: POINTER(win32more.Windows.Win32.Foundation.BSTR)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(23)
    def put_UserId(self, user: win32more.Windows.Win32.Foundation.BSTR) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(24)
    def get_StateChange(self, pType: POINTER(win32more.Windows.Win32.System.TaskScheduler.TASK_SESSION_STATE_CHANGE_TYPE)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(25)
    def put_StateChange(self, type: win32more.Windows.Win32.System.TaskScheduler.TASK_SESSION_STATE_CHANGE_TYPE) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class IShowMessageAction(ComPtr):
    extends: win32more.Windows.Win32.System.TaskScheduler.IAction
    _iid_ = Guid('{505e9e68-af89-46b8-a30f-56162a83d537}')
    @commethod(10)
    def get_Title(self, pTitle: POINTER(win32more.Windows.Win32.Foundation.BSTR)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(11)
    def put_Title(self, title: win32more.Windows.Win32.Foundation.BSTR) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(12)
    def get_MessageBody(self, pMessageBody: POINTER(win32more.Windows.Win32.Foundation.BSTR)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(13)
    def put_MessageBody(self, messageBody: win32more.Windows.Win32.Foundation.BSTR) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class ITask(ComPtr):
    extends: win32more.Windows.Win32.System.TaskScheduler.IScheduledWorkItem
    _iid_ = Guid('{148bd524-a2ab-11ce-b11f-00aa00530503}')
    @commethod(32)
    def SetApplicationName(self, pwszApplicationName: win32more.Windows.Win32.Foundation.PWSTR) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(33)
    def GetApplicationName(self, ppwszApplicationName: POINTER(win32more.Windows.Win32.Foundation.PWSTR)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(34)
    def SetParameters(self, pwszParameters: win32more.Windows.Win32.Foundation.PWSTR) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(35)
    def GetParameters(self, ppwszParameters: POINTER(win32more.Windows.Win32.Foundation.PWSTR)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(36)
    def SetWorkingDirectory(self, pwszWorkingDirectory: win32more.Windows.Win32.Foundation.PWSTR) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(37)
    def GetWorkingDirectory(self, ppwszWorkingDirectory: POINTER(win32more.Windows.Win32.Foundation.PWSTR)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(38)
    def SetPriority(self, dwPriority: UInt32) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(39)
    def GetPriority(self, pdwPriority: POINTER(UInt32)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(40)
    def SetTaskFlags(self, dwFlags: UInt32) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(41)
    def GetTaskFlags(self, pdwFlags: POINTER(UInt32)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(42)
    def SetMaxRunTime(self, dwMaxRunTimeMS: UInt32) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(43)
    def GetMaxRunTime(self, pdwMaxRunTimeMS: POINTER(UInt32)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class ITaskDefinition(ComPtr):
    extends: win32more.Windows.Win32.System.Com.IDispatch
    _iid_ = Guid('{f5bc8fc5-536d-4f77-b852-fbc1356fdeb6}')
    @commethod(7)
    def get_RegistrationInfo(self, ppRegistrationInfo: POINTER(win32more.Windows.Win32.System.TaskScheduler.IRegistrationInfo)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(8)
    def put_RegistrationInfo(self, pRegistrationInfo: win32more.Windows.Win32.System.TaskScheduler.IRegistrationInfo) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(9)
    def get_Triggers(self, ppTriggers: POINTER(win32more.Windows.Win32.System.TaskScheduler.ITriggerCollection)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(10)
    def put_Triggers(self, pTriggers: win32more.Windows.Win32.System.TaskScheduler.ITriggerCollection) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(11)
    def get_Settings(self, ppSettings: POINTER(win32more.Windows.Win32.System.TaskScheduler.ITaskSettings)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(12)
    def put_Settings(self, pSettings: win32more.Windows.Win32.System.TaskScheduler.ITaskSettings) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(13)
    def get_Data(self, pData: POINTER(win32more.Windows.Win32.Foundation.BSTR)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(14)
    def put_Data(self, data: win32more.Windows.Win32.Foundation.BSTR) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(15)
    def get_Principal(self, ppPrincipal: POINTER(win32more.Windows.Win32.System.TaskScheduler.IPrincipal)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(16)
    def put_Principal(self, pPrincipal: win32more.Windows.Win32.System.TaskScheduler.IPrincipal) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(17)
    def get_Actions(self, ppActions: POINTER(win32more.Windows.Win32.System.TaskScheduler.IActionCollection)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(18)
    def put_Actions(self, pActions: win32more.Windows.Win32.System.TaskScheduler.IActionCollection) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(19)
    def get_XmlText(self, pXml: POINTER(win32more.Windows.Win32.Foundation.BSTR)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(20)
    def put_XmlText(self, xml: win32more.Windows.Win32.Foundation.BSTR) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class ITaskFolder(ComPtr):
    extends: win32more.Windows.Win32.System.Com.IDispatch
    _iid_ = Guid('{8cfac062-a080-4c15-9a88-aa7c2af80dfc}')
    @commethod(7)
    def get_Name(self, pName: POINTER(win32more.Windows.Win32.Foundation.BSTR)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(8)
    def get_Path(self, pPath: POINTER(win32more.Windows.Win32.Foundation.BSTR)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(9)
    def GetFolder(self, path: win32more.Windows.Win32.Foundation.BSTR, ppFolder: POINTER(win32more.Windows.Win32.System.TaskScheduler.ITaskFolder)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(10)
    def GetFolders(self, flags: Int32, ppFolders: POINTER(win32more.Windows.Win32.System.TaskScheduler.ITaskFolderCollection)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(11)
    def CreateFolder(self, subFolderName: win32more.Windows.Win32.Foundation.BSTR, sddl: win32more.Windows.Win32.System.Variant.VARIANT, ppFolder: POINTER(win32more.Windows.Win32.System.TaskScheduler.ITaskFolder)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(12)
    def DeleteFolder(self, subFolderName: win32more.Windows.Win32.Foundation.BSTR, flags: Int32) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(13)
    def GetTask(self, path: win32more.Windows.Win32.Foundation.BSTR, ppTask: POINTER(win32more.Windows.Win32.System.TaskScheduler.IRegisteredTask)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(14)
    def GetTasks(self, flags: Int32, ppTasks: POINTER(win32more.Windows.Win32.System.TaskScheduler.IRegisteredTaskCollection)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(15)
    def DeleteTask(self, name: win32more.Windows.Win32.Foundation.BSTR, flags: Int32) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(16)
    def RegisterTask(self, path: win32more.Windows.Win32.Foundation.BSTR, xmlText: win32more.Windows.Win32.Foundation.BSTR, flags: Int32, userId: win32more.Windows.Win32.System.Variant.VARIANT, password: win32more.Windows.Win32.System.Variant.VARIANT, logonType: win32more.Windows.Win32.System.TaskScheduler.TASK_LOGON_TYPE, sddl: win32more.Windows.Win32.System.Variant.VARIANT, ppTask: POINTER(win32more.Windows.Win32.System.TaskScheduler.IRegisteredTask)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(17)
    def RegisterTaskDefinition(self, path: win32more.Windows.Win32.Foundation.BSTR, pDefinition: win32more.Windows.Win32.System.TaskScheduler.ITaskDefinition, flags: Int32, userId: win32more.Windows.Win32.System.Variant.VARIANT, password: win32more.Windows.Win32.System.Variant.VARIANT, logonType: win32more.Windows.Win32.System.TaskScheduler.TASK_LOGON_TYPE, sddl: win32more.Windows.Win32.System.Variant.VARIANT, ppTask: POINTER(win32more.Windows.Win32.System.TaskScheduler.IRegisteredTask)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(18)
    def GetSecurityDescriptor(self, securityInformation: Int32, pSddl: POINTER(win32more.Windows.Win32.Foundation.BSTR)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(19)
    def SetSecurityDescriptor(self, sddl: win32more.Windows.Win32.Foundation.BSTR, flags: Int32) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class ITaskFolderCollection(ComPtr):
    extends: win32more.Windows.Win32.System.Com.IDispatch
    _iid_ = Guid('{79184a66-8664-423f-97f1-637356a5d812}')
    @commethod(7)
    def get_Count(self, pCount: POINTER(Int32)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(8)
    def get_Item(self, index: win32more.Windows.Win32.System.Variant.VARIANT, ppFolder: POINTER(win32more.Windows.Win32.System.TaskScheduler.ITaskFolder)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(9)
    def get__NewEnum(self, ppEnum: POINTER(win32more.Windows.Win32.System.Com.IUnknown)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class ITaskHandler(ComPtr):
    extends: win32more.Windows.Win32.System.Com.IUnknown
    _iid_ = Guid('{839d7762-5121-4009-9234-4f0d19394f04}')
    @commethod(3)
    def Start(self, pHandlerServices: win32more.Windows.Win32.System.Com.IUnknown, data: win32more.Windows.Win32.Foundation.BSTR) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(4)
    def Stop(self, pRetCode: POINTER(win32more.Windows.Win32.Foundation.HRESULT)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(5)
    def Pause(self) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(6)
    def Resume(self) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class ITaskHandlerStatus(ComPtr):
    extends: win32more.Windows.Win32.System.Com.IUnknown
    _iid_ = Guid('{eaec7a8f-27a0-4ddc-8675-14726a01a38a}')
    @commethod(3)
    def UpdateStatus(self, percentComplete: Int16, statusMessage: win32more.Windows.Win32.Foundation.BSTR) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(4)
    def TaskCompleted(self, taskErrCode: win32more.Windows.Win32.Foundation.HRESULT) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class ITaskNamedValueCollection(ComPtr):
    extends: win32more.Windows.Win32.System.Com.IDispatch
    _iid_ = Guid('{b4ef826b-63c3-46e4-a504-ef69e4f7ea4d}')
    @commethod(7)
    def get_Count(self, pCount: POINTER(Int32)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(8)
    def get_Item(self, index: Int32, ppPair: POINTER(win32more.Windows.Win32.System.TaskScheduler.ITaskNamedValuePair)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(9)
    def get__NewEnum(self, ppEnum: POINTER(win32more.Windows.Win32.System.Com.IUnknown)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(10)
    def Create(self, name: win32more.Windows.Win32.Foundation.BSTR, value: win32more.Windows.Win32.Foundation.BSTR, ppPair: POINTER(win32more.Windows.Win32.System.TaskScheduler.ITaskNamedValuePair)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(11)
    def Remove(self, index: Int32) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(12)
    def Clear(self) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class ITaskNamedValuePair(ComPtr):
    extends: win32more.Windows.Win32.System.Com.IDispatch
    _iid_ = Guid('{39038068-2b46-4afd-8662-7bb6f868d221}')
    @commethod(7)
    def get_Name(self, pName: POINTER(win32more.Windows.Win32.Foundation.BSTR)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(8)
    def put_Name(self, name: win32more.Windows.Win32.Foundation.BSTR) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(9)
    def get_Value(self, pValue: POINTER(win32more.Windows.Win32.Foundation.BSTR)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(10)
    def put_Value(self, value: win32more.Windows.Win32.Foundation.BSTR) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class ITaskScheduler(ComPtr):
    extends: win32more.Windows.Win32.System.Com.IUnknown
    _iid_ = Guid('{148bd527-a2ab-11ce-b11f-00aa00530503}')
    @commethod(3)
    def SetTargetComputer(self, pwszComputer: win32more.Windows.Win32.Foundation.PWSTR) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(4)
    def GetTargetComputer(self, ppwszComputer: POINTER(win32more.Windows.Win32.Foundation.PWSTR)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(5)
    def Enum(self, ppEnumWorkItems: POINTER(win32more.Windows.Win32.System.TaskScheduler.IEnumWorkItems)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(6)
    def Activate(self, pwszName: win32more.Windows.Win32.Foundation.PWSTR, riid: POINTER(Guid), ppUnk: POINTER(win32more.Windows.Win32.System.Com.IUnknown)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(7)
    def Delete(self, pwszName: win32more.Windows.Win32.Foundation.PWSTR) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(8)
    def NewWorkItem(self, pwszTaskName: win32more.Windows.Win32.Foundation.PWSTR, rclsid: POINTER(Guid), riid: POINTER(Guid), ppUnk: POINTER(win32more.Windows.Win32.System.Com.IUnknown)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(9)
    def AddWorkItem(self, pwszTaskName: win32more.Windows.Win32.Foundation.PWSTR, pWorkItem: win32more.Windows.Win32.System.TaskScheduler.IScheduledWorkItem) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(10)
    def IsOfType(self, pwszName: win32more.Windows.Win32.Foundation.PWSTR, riid: POINTER(Guid)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class ITaskService(ComPtr):
    extends: win32more.Windows.Win32.System.Com.IDispatch
    _iid_ = Guid('{2faba4c7-4da9-4013-9697-20cc3fd40f85}')
    @commethod(7)
    def GetFolder(self, path: win32more.Windows.Win32.Foundation.BSTR, ppFolder: POINTER(win32more.Windows.Win32.System.TaskScheduler.ITaskFolder)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(8)
    def GetRunningTasks(self, flags: Int32, ppRunningTasks: POINTER(win32more.Windows.Win32.System.TaskScheduler.IRunningTaskCollection)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(9)
    def NewTask(self, flags: UInt32, ppDefinition: POINTER(win32more.Windows.Win32.System.TaskScheduler.ITaskDefinition)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(10)
    def Connect(self, serverName: win32more.Windows.Win32.System.Variant.VARIANT, user: win32more.Windows.Win32.System.Variant.VARIANT, domain: win32more.Windows.Win32.System.Variant.VARIANT, password: win32more.Windows.Win32.System.Variant.VARIANT) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(11)
    def get_Connected(self, pConnected: POINTER(win32more.Windows.Win32.Foundation.VARIANT_BOOL)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(12)
    def get_TargetServer(self, pServer: POINTER(win32more.Windows.Win32.Foundation.BSTR)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(13)
    def get_ConnectedUser(self, pUser: POINTER(win32more.Windows.Win32.Foundation.BSTR)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(14)
    def get_ConnectedDomain(self, pDomain: POINTER(win32more.Windows.Win32.Foundation.BSTR)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(15)
    def get_HighestVersion(self, pVersion: POINTER(UInt32)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class ITaskSettings(ComPtr):
    extends: win32more.Windows.Win32.System.Com.IDispatch
    _iid_ = Guid('{8fd4711d-2d02-4c8c-87e3-eff699de127e}')
    @commethod(7)
    def get_AllowDemandStart(self, pAllowDemandStart: POINTER(win32more.Windows.Win32.Foundation.VARIANT_BOOL)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(8)
    def put_AllowDemandStart(self, allowDemandStart: win32more.Windows.Win32.Foundation.VARIANT_BOOL) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(9)
    def get_RestartInterval(self, pRestartInterval: POINTER(win32more.Windows.Win32.Foundation.BSTR)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(10)
    def put_RestartInterval(self, restartInterval: win32more.Windows.Win32.Foundation.BSTR) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(11)
    def get_RestartCount(self, pRestartCount: POINTER(Int32)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(12)
    def put_RestartCount(self, restartCount: Int32) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(13)
    def get_MultipleInstances(self, pPolicy: POINTER(win32more.Windows.Win32.System.TaskScheduler.TASK_INSTANCES_POLICY)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(14)
    def put_MultipleInstances(self, policy: win32more.Windows.Win32.System.TaskScheduler.TASK_INSTANCES_POLICY) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(15)
    def get_StopIfGoingOnBatteries(self, pStopIfOnBatteries: POINTER(win32more.Windows.Win32.Foundation.VARIANT_BOOL)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(16)
    def put_StopIfGoingOnBatteries(self, stopIfOnBatteries: win32more.Windows.Win32.Foundation.VARIANT_BOOL) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(17)
    def get_DisallowStartIfOnBatteries(self, pDisallowStart: POINTER(win32more.Windows.Win32.Foundation.VARIANT_BOOL)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(18)
    def put_DisallowStartIfOnBatteries(self, disallowStart: win32more.Windows.Win32.Foundation.VARIANT_BOOL) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(19)
    def get_AllowHardTerminate(self, pAllowHardTerminate: POINTER(win32more.Windows.Win32.Foundation.VARIANT_BOOL)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(20)
    def put_AllowHardTerminate(self, allowHardTerminate: win32more.Windows.Win32.Foundation.VARIANT_BOOL) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(21)
    def get_StartWhenAvailable(self, pStartWhenAvailable: POINTER(win32more.Windows.Win32.Foundation.VARIANT_BOOL)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(22)
    def put_StartWhenAvailable(self, startWhenAvailable: win32more.Windows.Win32.Foundation.VARIANT_BOOL) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(23)
    def get_XmlText(self, pText: POINTER(win32more.Windows.Win32.Foundation.BSTR)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(24)
    def put_XmlText(self, text: win32more.Windows.Win32.Foundation.BSTR) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(25)
    def get_RunOnlyIfNetworkAvailable(self, pRunOnlyIfNetworkAvailable: POINTER(win32more.Windows.Win32.Foundation.VARIANT_BOOL)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(26)
    def put_RunOnlyIfNetworkAvailable(self, runOnlyIfNetworkAvailable: win32more.Windows.Win32.Foundation.VARIANT_BOOL) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(27)
    def get_ExecutionTimeLimit(self, pExecutionTimeLimit: POINTER(win32more.Windows.Win32.Foundation.BSTR)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(28)
    def put_ExecutionTimeLimit(self, executionTimeLimit: win32more.Windows.Win32.Foundation.BSTR) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(29)
    def get_Enabled(self, pEnabled: POINTER(win32more.Windows.Win32.Foundation.VARIANT_BOOL)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(30)
    def put_Enabled(self, enabled: win32more.Windows.Win32.Foundation.VARIANT_BOOL) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(31)
    def get_DeleteExpiredTaskAfter(self, pExpirationDelay: POINTER(win32more.Windows.Win32.Foundation.BSTR)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(32)
    def put_DeleteExpiredTaskAfter(self, expirationDelay: win32more.Windows.Win32.Foundation.BSTR) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(33)
    def get_Priority(self, pPriority: POINTER(Int32)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(34)
    def put_Priority(self, priority: Int32) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(35)
    def get_Compatibility(self, pCompatLevel: POINTER(win32more.Windows.Win32.System.TaskScheduler.TASK_COMPATIBILITY)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(36)
    def put_Compatibility(self, compatLevel: win32more.Windows.Win32.System.TaskScheduler.TASK_COMPATIBILITY) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(37)
    def get_Hidden(self, pHidden: POINTER(win32more.Windows.Win32.Foundation.VARIANT_BOOL)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(38)
    def put_Hidden(self, hidden: win32more.Windows.Win32.Foundation.VARIANT_BOOL) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(39)
    def get_IdleSettings(self, ppIdleSettings: POINTER(win32more.Windows.Win32.System.TaskScheduler.IIdleSettings)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(40)
    def put_IdleSettings(self, pIdleSettings: win32more.Windows.Win32.System.TaskScheduler.IIdleSettings) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(41)
    def get_RunOnlyIfIdle(self, pRunOnlyIfIdle: POINTER(win32more.Windows.Win32.Foundation.VARIANT_BOOL)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(42)
    def put_RunOnlyIfIdle(self, runOnlyIfIdle: win32more.Windows.Win32.Foundation.VARIANT_BOOL) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(43)
    def get_WakeToRun(self, pWake: POINTER(win32more.Windows.Win32.Foundation.VARIANT_BOOL)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(44)
    def put_WakeToRun(self, wake: win32more.Windows.Win32.Foundation.VARIANT_BOOL) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(45)
    def get_NetworkSettings(self, ppNetworkSettings: POINTER(win32more.Windows.Win32.System.TaskScheduler.INetworkSettings)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(46)
    def put_NetworkSettings(self, pNetworkSettings: win32more.Windows.Win32.System.TaskScheduler.INetworkSettings) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class ITaskSettings2(ComPtr):
    extends: win32more.Windows.Win32.System.Com.IDispatch
    _iid_ = Guid('{2c05c3f0-6eed-4c05-a15f-ed7d7a98a369}')
    @commethod(7)
    def get_DisallowStartOnRemoteAppSession(self, pDisallowStart: POINTER(win32more.Windows.Win32.Foundation.VARIANT_BOOL)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(8)
    def put_DisallowStartOnRemoteAppSession(self, disallowStart: win32more.Windows.Win32.Foundation.VARIANT_BOOL) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(9)
    def get_UseUnifiedSchedulingEngine(self, pUseUnifiedEngine: POINTER(win32more.Windows.Win32.Foundation.VARIANT_BOOL)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(10)
    def put_UseUnifiedSchedulingEngine(self, useUnifiedEngine: win32more.Windows.Win32.Foundation.VARIANT_BOOL) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class ITaskSettings3(ComPtr):
    extends: win32more.Windows.Win32.System.TaskScheduler.ITaskSettings
    _iid_ = Guid('{0ad9d0d7-0c7f-4ebb-9a5f-d1c648dca528}')
    @commethod(47)
    def get_DisallowStartOnRemoteAppSession(self, pDisallowStart: POINTER(win32more.Windows.Win32.Foundation.VARIANT_BOOL)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(48)
    def put_DisallowStartOnRemoteAppSession(self, disallowStart: win32more.Windows.Win32.Foundation.VARIANT_BOOL) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(49)
    def get_UseUnifiedSchedulingEngine(self, pUseUnifiedEngine: POINTER(win32more.Windows.Win32.Foundation.VARIANT_BOOL)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(50)
    def put_UseUnifiedSchedulingEngine(self, useUnifiedEngine: win32more.Windows.Win32.Foundation.VARIANT_BOOL) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(51)
    def get_MaintenanceSettings(self, ppMaintenanceSettings: POINTER(win32more.Windows.Win32.System.TaskScheduler.IMaintenanceSettings)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(52)
    def put_MaintenanceSettings(self, pMaintenanceSettings: win32more.Windows.Win32.System.TaskScheduler.IMaintenanceSettings) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(53)
    def CreateMaintenanceSettings(self, ppMaintenanceSettings: POINTER(win32more.Windows.Win32.System.TaskScheduler.IMaintenanceSettings)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(54)
    def get_Volatile(self, pVolatile: POINTER(win32more.Windows.Win32.Foundation.VARIANT_BOOL)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(55)
    def put_Volatile(self, Volatile: win32more.Windows.Win32.Foundation.VARIANT_BOOL) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class ITaskTrigger(ComPtr):
    extends: win32more.Windows.Win32.System.Com.IUnknown
    _iid_ = Guid('{148bd52b-a2ab-11ce-b11f-00aa00530503}')
    @commethod(3)
    def SetTrigger(self, pTrigger: POINTER(win32more.Windows.Win32.System.TaskScheduler.TASK_TRIGGER)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(4)
    def GetTrigger(self, pTrigger: POINTER(win32more.Windows.Win32.System.TaskScheduler.TASK_TRIGGER)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(5)
    def GetTriggerString(self, ppwszTrigger: POINTER(win32more.Windows.Win32.Foundation.PWSTR)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class ITaskVariables(ComPtr):
    extends: win32more.Windows.Win32.System.Com.IUnknown
    _iid_ = Guid('{3e4c9351-d966-4b8b-bb87-ceba68bb0107}')
    @commethod(3)
    def GetInput(self, pInput: POINTER(win32more.Windows.Win32.Foundation.BSTR)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(4)
    def SetOutput(self, input: win32more.Windows.Win32.Foundation.BSTR) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(5)
    def GetContext(self, pContext: POINTER(win32more.Windows.Win32.Foundation.BSTR)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class ITimeTrigger(ComPtr):
    extends: win32more.Windows.Win32.System.TaskScheduler.ITrigger
    _iid_ = Guid('{b45747e0-eba7-4276-9f29-85c5bb300006}')
    @commethod(20)
    def get_RandomDelay(self, pRandomDelay: POINTER(win32more.Windows.Win32.Foundation.BSTR)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(21)
    def put_RandomDelay(self, randomDelay: win32more.Windows.Win32.Foundation.BSTR) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class ITrigger(ComPtr):
    extends: win32more.Windows.Win32.System.Com.IDispatch
    _iid_ = Guid('{09941815-ea89-4b5b-89e0-2a773801fac3}')
    @commethod(7)
    def get_Type(self, pType: POINTER(win32more.Windows.Win32.System.TaskScheduler.TASK_TRIGGER_TYPE2)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(8)
    def get_Id(self, pId: POINTER(win32more.Windows.Win32.Foundation.BSTR)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(9)
    def put_Id(self, id: win32more.Windows.Win32.Foundation.BSTR) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(10)
    def get_Repetition(self, ppRepeat: POINTER(win32more.Windows.Win32.System.TaskScheduler.IRepetitionPattern)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(11)
    def put_Repetition(self, pRepeat: win32more.Windows.Win32.System.TaskScheduler.IRepetitionPattern) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(12)
    def get_ExecutionTimeLimit(self, pTimeLimit: POINTER(win32more.Windows.Win32.Foundation.BSTR)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(13)
    def put_ExecutionTimeLimit(self, timelimit: win32more.Windows.Win32.Foundation.BSTR) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(14)
    def get_StartBoundary(self, pStart: POINTER(win32more.Windows.Win32.Foundation.BSTR)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(15)
    def put_StartBoundary(self, start: win32more.Windows.Win32.Foundation.BSTR) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(16)
    def get_EndBoundary(self, pEnd: POINTER(win32more.Windows.Win32.Foundation.BSTR)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(17)
    def put_EndBoundary(self, end: win32more.Windows.Win32.Foundation.BSTR) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(18)
    def get_Enabled(self, pEnabled: POINTER(win32more.Windows.Win32.Foundation.VARIANT_BOOL)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(19)
    def put_Enabled(self, enabled: win32more.Windows.Win32.Foundation.VARIANT_BOOL) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class ITriggerCollection(ComPtr):
    extends: win32more.Windows.Win32.System.Com.IDispatch
    _iid_ = Guid('{85df5081-1b24-4f32-878a-d9d14df4cb77}')
    @commethod(7)
    def get_Count(self, pCount: POINTER(Int32)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(8)
    def get_Item(self, index: Int32, ppTrigger: POINTER(win32more.Windows.Win32.System.TaskScheduler.ITrigger)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(9)
    def get__NewEnum(self, ppEnum: POINTER(win32more.Windows.Win32.System.Com.IUnknown)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(10)
    def Create(self, type: win32more.Windows.Win32.System.TaskScheduler.TASK_TRIGGER_TYPE2, ppTrigger: POINTER(win32more.Windows.Win32.System.TaskScheduler.ITrigger)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(11)
    def Remove(self, index: win32more.Windows.Win32.System.Variant.VARIANT) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(12)
    def Clear(self) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class IWeeklyTrigger(ComPtr):
    extends: win32more.Windows.Win32.System.TaskScheduler.ITrigger
    _iid_ = Guid('{5038fc98-82ff-436d-8728-a512a57c9dc1}')
    @commethod(20)
    def get_DaysOfWeek(self, pDays: POINTER(Int16)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(21)
    def put_DaysOfWeek(self, days: Int16) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(22)
    def get_WeeksInterval(self, pWeeks: POINTER(Int16)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(23)
    def put_WeeksInterval(self, weeks: Int16) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(24)
    def get_RandomDelay(self, pRandomDelay: POINTER(win32more.Windows.Win32.Foundation.BSTR)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(25)
    def put_RandomDelay(self, randomDelay: win32more.Windows.Win32.Foundation.BSTR) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class MONTHLYDATE(Structure):
    rgfDays: UInt32
    rgfMonths: UInt16
class MONTHLYDOW(Structure):
    wWhichWeek: UInt16
    rgfDaysOfTheWeek: UInt16
    rgfMonths: UInt16
TASKPAGE = Int32
TASKPAGE_TASK: win32more.Windows.Win32.System.TaskScheduler.TASKPAGE = 0
TASKPAGE_SCHEDULE: win32more.Windows.Win32.System.TaskScheduler.TASKPAGE = 1
TASKPAGE_SETTINGS: win32more.Windows.Win32.System.TaskScheduler.TASKPAGE = 2
TASK_ACTION_TYPE = Int32
TASK_ACTION_EXEC: win32more.Windows.Win32.System.TaskScheduler.TASK_ACTION_TYPE = 0
TASK_ACTION_COM_HANDLER: win32more.Windows.Win32.System.TaskScheduler.TASK_ACTION_TYPE = 5
TASK_ACTION_SEND_EMAIL: win32more.Windows.Win32.System.TaskScheduler.TASK_ACTION_TYPE = 6
TASK_ACTION_SHOW_MESSAGE: win32more.Windows.Win32.System.TaskScheduler.TASK_ACTION_TYPE = 7
TASK_COMPATIBILITY = Int32
TASK_COMPATIBILITY_AT: win32more.Windows.Win32.System.TaskScheduler.TASK_COMPATIBILITY = 0
TASK_COMPATIBILITY_V1: win32more.Windows.Win32.System.TaskScheduler.TASK_COMPATIBILITY = 1
TASK_COMPATIBILITY_V2: win32more.Windows.Win32.System.TaskScheduler.TASK_COMPATIBILITY = 2
TASK_COMPATIBILITY_V2_1: win32more.Windows.Win32.System.TaskScheduler.TASK_COMPATIBILITY = 3
TASK_COMPATIBILITY_V2_2: win32more.Windows.Win32.System.TaskScheduler.TASK_COMPATIBILITY = 4
TASK_COMPATIBILITY_V2_3: win32more.Windows.Win32.System.TaskScheduler.TASK_COMPATIBILITY = 5
TASK_COMPATIBILITY_V2_4: win32more.Windows.Win32.System.TaskScheduler.TASK_COMPATIBILITY = 6
TASK_CREATION = Int32
TASK_VALIDATE_ONLY: win32more.Windows.Win32.System.TaskScheduler.TASK_CREATION = 1
TASK_CREATE: win32more.Windows.Win32.System.TaskScheduler.TASK_CREATION = 2
TASK_UPDATE: win32more.Windows.Win32.System.TaskScheduler.TASK_CREATION = 4
TASK_CREATE_OR_UPDATE: win32more.Windows.Win32.System.TaskScheduler.TASK_CREATION = 6
TASK_DISABLE: win32more.Windows.Win32.System.TaskScheduler.TASK_CREATION = 8
TASK_DONT_ADD_PRINCIPAL_ACE: win32more.Windows.Win32.System.TaskScheduler.TASK_CREATION = 16
TASK_IGNORE_REGISTRATION_TRIGGERS: win32more.Windows.Win32.System.TaskScheduler.TASK_CREATION = 32
TASK_ENUM_FLAGS = Int32
TASK_ENUM_HIDDEN: win32more.Windows.Win32.System.TaskScheduler.TASK_ENUM_FLAGS = 1
TASK_INSTANCES_POLICY = Int32
TASK_INSTANCES_PARALLEL: win32more.Windows.Win32.System.TaskScheduler.TASK_INSTANCES_POLICY = 0
TASK_INSTANCES_QUEUE: win32more.Windows.Win32.System.TaskScheduler.TASK_INSTANCES_POLICY = 1
TASK_INSTANCES_IGNORE_NEW: win32more.Windows.Win32.System.TaskScheduler.TASK_INSTANCES_POLICY = 2
TASK_INSTANCES_STOP_EXISTING: win32more.Windows.Win32.System.TaskScheduler.TASK_INSTANCES_POLICY = 3
TASK_LOGON_TYPE = Int32
TASK_LOGON_NONE: win32more.Windows.Win32.System.TaskScheduler.TASK_LOGON_TYPE = 0
TASK_LOGON_PASSWORD: win32more.Windows.Win32.System.TaskScheduler.TASK_LOGON_TYPE = 1
TASK_LOGON_S4U: win32more.Windows.Win32.System.TaskScheduler.TASK_LOGON_TYPE = 2
TASK_LOGON_INTERACTIVE_TOKEN: win32more.Windows.Win32.System.TaskScheduler.TASK_LOGON_TYPE = 3
TASK_LOGON_GROUP: win32more.Windows.Win32.System.TaskScheduler.TASK_LOGON_TYPE = 4
TASK_LOGON_SERVICE_ACCOUNT: win32more.Windows.Win32.System.TaskScheduler.TASK_LOGON_TYPE = 5
TASK_LOGON_INTERACTIVE_TOKEN_OR_PASSWORD: win32more.Windows.Win32.System.TaskScheduler.TASK_LOGON_TYPE = 6
TASK_PROCESSTOKENSID_TYPE = Int32
TASK_PROCESSTOKENSID_NONE: win32more.Windows.Win32.System.TaskScheduler.TASK_PROCESSTOKENSID_TYPE = 0
TASK_PROCESSTOKENSID_UNRESTRICTED: win32more.Windows.Win32.System.TaskScheduler.TASK_PROCESSTOKENSID_TYPE = 1
TASK_PROCESSTOKENSID_DEFAULT: win32more.Windows.Win32.System.TaskScheduler.TASK_PROCESSTOKENSID_TYPE = 2
TASK_RUNLEVEL_TYPE = Int32
TASK_RUNLEVEL_LUA: win32more.Windows.Win32.System.TaskScheduler.TASK_RUNLEVEL_TYPE = 0
TASK_RUNLEVEL_HIGHEST: win32more.Windows.Win32.System.TaskScheduler.TASK_RUNLEVEL_TYPE = 1
TASK_RUN_FLAGS = Int32
TASK_RUN_NO_FLAGS: win32more.Windows.Win32.System.TaskScheduler.TASK_RUN_FLAGS = 0
TASK_RUN_AS_SELF: win32more.Windows.Win32.System.TaskScheduler.TASK_RUN_FLAGS = 1
TASK_RUN_IGNORE_CONSTRAINTS: win32more.Windows.Win32.System.TaskScheduler.TASK_RUN_FLAGS = 2
TASK_RUN_USE_SESSION_ID: win32more.Windows.Win32.System.TaskScheduler.TASK_RUN_FLAGS = 4
TASK_RUN_USER_SID: win32more.Windows.Win32.System.TaskScheduler.TASK_RUN_FLAGS = 8
TASK_SESSION_STATE_CHANGE_TYPE = Int32
TASK_CONSOLE_CONNECT: win32more.Windows.Win32.System.TaskScheduler.TASK_SESSION_STATE_CHANGE_TYPE = 1
TASK_CONSOLE_DISCONNECT: win32more.Windows.Win32.System.TaskScheduler.TASK_SESSION_STATE_CHANGE_TYPE = 2
TASK_REMOTE_CONNECT: win32more.Windows.Win32.System.TaskScheduler.TASK_SESSION_STATE_CHANGE_TYPE = 3
TASK_REMOTE_DISCONNECT: win32more.Windows.Win32.System.TaskScheduler.TASK_SESSION_STATE_CHANGE_TYPE = 4
TASK_SESSION_LOCK: win32more.Windows.Win32.System.TaskScheduler.TASK_SESSION_STATE_CHANGE_TYPE = 7
TASK_SESSION_UNLOCK: win32more.Windows.Win32.System.TaskScheduler.TASK_SESSION_STATE_CHANGE_TYPE = 8
TASK_STATE = Int32
TASK_STATE_UNKNOWN: win32more.Windows.Win32.System.TaskScheduler.TASK_STATE = 0
TASK_STATE_DISABLED: win32more.Windows.Win32.System.TaskScheduler.TASK_STATE = 1
TASK_STATE_QUEUED: win32more.Windows.Win32.System.TaskScheduler.TASK_STATE = 2
TASK_STATE_READY: win32more.Windows.Win32.System.TaskScheduler.TASK_STATE = 3
TASK_STATE_RUNNING: win32more.Windows.Win32.System.TaskScheduler.TASK_STATE = 4
class TASK_TRIGGER(Structure):
    cbTriggerSize: UInt16
    Reserved1: UInt16
    wBeginYear: UInt16
    wBeginMonth: UInt16
    wBeginDay: UInt16
    wEndYear: UInt16
    wEndMonth: UInt16
    wEndDay: UInt16
    wStartHour: UInt16
    wStartMinute: UInt16
    MinutesDuration: UInt32
    MinutesInterval: UInt32
    rgFlags: UInt32
    TriggerType: win32more.Windows.Win32.System.TaskScheduler.TASK_TRIGGER_TYPE
    Type: win32more.Windows.Win32.System.TaskScheduler.TRIGGER_TYPE_UNION
    Reserved2: UInt16
    wRandomMinutesInterval: UInt16
TASK_TRIGGER_TYPE = Int32
TASK_TIME_TRIGGER_ONCE: win32more.Windows.Win32.System.TaskScheduler.TASK_TRIGGER_TYPE = 0
TASK_TIME_TRIGGER_DAILY: win32more.Windows.Win32.System.TaskScheduler.TASK_TRIGGER_TYPE = 1
TASK_TIME_TRIGGER_WEEKLY: win32more.Windows.Win32.System.TaskScheduler.TASK_TRIGGER_TYPE = 2
TASK_TIME_TRIGGER_MONTHLYDATE: win32more.Windows.Win32.System.TaskScheduler.TASK_TRIGGER_TYPE = 3
TASK_TIME_TRIGGER_MONTHLYDOW: win32more.Windows.Win32.System.TaskScheduler.TASK_TRIGGER_TYPE = 4
TASK_EVENT_TRIGGER_ON_IDLE: win32more.Windows.Win32.System.TaskScheduler.TASK_TRIGGER_TYPE = 5
TASK_EVENT_TRIGGER_AT_SYSTEMSTART: win32more.Windows.Win32.System.TaskScheduler.TASK_TRIGGER_TYPE = 6
TASK_EVENT_TRIGGER_AT_LOGON: win32more.Windows.Win32.System.TaskScheduler.TASK_TRIGGER_TYPE = 7
TASK_TRIGGER_TYPE2 = Int32
TASK_TRIGGER_EVENT: win32more.Windows.Win32.System.TaskScheduler.TASK_TRIGGER_TYPE2 = 0
TASK_TRIGGER_TIME: win32more.Windows.Win32.System.TaskScheduler.TASK_TRIGGER_TYPE2 = 1
TASK_TRIGGER_DAILY: win32more.Windows.Win32.System.TaskScheduler.TASK_TRIGGER_TYPE2 = 2
TASK_TRIGGER_WEEKLY: win32more.Windows.Win32.System.TaskScheduler.TASK_TRIGGER_TYPE2 = 3
TASK_TRIGGER_MONTHLY: win32more.Windows.Win32.System.TaskScheduler.TASK_TRIGGER_TYPE2 = 4
TASK_TRIGGER_MONTHLYDOW: win32more.Windows.Win32.System.TaskScheduler.TASK_TRIGGER_TYPE2 = 5
TASK_TRIGGER_IDLE: win32more.Windows.Win32.System.TaskScheduler.TASK_TRIGGER_TYPE2 = 6
TASK_TRIGGER_REGISTRATION: win32more.Windows.Win32.System.TaskScheduler.TASK_TRIGGER_TYPE2 = 7
TASK_TRIGGER_BOOT: win32more.Windows.Win32.System.TaskScheduler.TASK_TRIGGER_TYPE2 = 8
TASK_TRIGGER_LOGON: win32more.Windows.Win32.System.TaskScheduler.TASK_TRIGGER_TYPE2 = 9
TASK_TRIGGER_SESSION_STATE_CHANGE: win32more.Windows.Win32.System.TaskScheduler.TASK_TRIGGER_TYPE2 = 11
TASK_TRIGGER_CUSTOM_TRIGGER_01: win32more.Windows.Win32.System.TaskScheduler.TASK_TRIGGER_TYPE2 = 12
class TRIGGER_TYPE_UNION(Union):
    Daily: win32more.Windows.Win32.System.TaskScheduler.DAILY
    Weekly: win32more.Windows.Win32.System.TaskScheduler.WEEKLY
    MonthlyDate: win32more.Windows.Win32.System.TaskScheduler.MONTHLYDATE
    MonthlyDOW: win32more.Windows.Win32.System.TaskScheduler.MONTHLYDOW
TaskHandlerPS = Guid('{f2a69db7-da2c-4352-9066-86fee6dacac9}')
TaskHandlerStatusPS = Guid('{9f15266d-d7ba-48f0-93c1-e6895f6fe5ac}')
TaskScheduler = Guid('{0f87369f-a4e5-4cfc-bd3e-73e6154572dd}')
class WEEKLY(Structure):
    WeeksInterval: UInt16
    rgfDaysOfTheWeek: UInt16


make_ready(__name__)
