# .NET Core 2.0.3

.NET Core 2.0.3 comprises:

* .NET Core Runtime 2.0.3
* .NET Core SDK 2.0.3

|         | SDK Installer                                         | SDK Binaries                                                         | Runtime Installer                                                  | Runtime Binaries                                                   |
| ------- | :---------------------------------------------------: | :-------------------------------------------------------------------:| :----------------------------------------------------------------: | :----------------------------------------------------------------: |
| Windows | [32-bit](https://download.microsoft.com/download/D/7/2/D725E47F-A4F1-4285-8935-A91AE2FCC06A/dotnet-sdk-2.0.3-win-x86.exe) / [64-bit](https://download.microsoft.com/download/D/7/2/D725E47F-A4F1-4285-8935-A91AE2FCC06A/dotnet-sdk-2.0.3-win-x64.exe)  | [32-bit](https://download.microsoft.com/download/D/7/2/D725E47F-A4F1-4285-8935-A91AE2FCC06A/dotnet-sdk-2.0.3-win-x86.zip) / [64-bit](https://download.microsoft.com/download/D/7/2/D725E47F-A4F1-4285-8935-A91AE2FCC06A/dotnet-sdk-2.0.3-win-x64.zip) | [32-bit](https://download.microsoft.com/download/5/C/1/5C190037-632B-443D-842D-39085F02E1E8/dotnet-runtime-2.0.3-win-x86.exe) / [64-bit](https://download.microsoft.com/download/5/C/1/5C190037-632B-443D-842D-39085F02E1E8/dotnet-runtime-2.0.3-win-x64.exe) | [32-bit](https://download.microsoft.com/download/5/C/1/5C190037-632B-443D-842D-39085F02E1E8/dotnet-runtime-2.0.3-win-x86.zip) / [64-bit](https://download.microsoft.com/download/5/C/1/5C190037-632B-443D-842D-39085F02E1E8/dotnet-runtime-2.0.3-win-x64.zip) |
| macOS   | [64-bit](https://download.microsoft.com/download/D/7/2/D725E47F-A4F1-4285-8935-A91AE2FCC06A/dotnet-sdk-2.0.3-osx-x64.pkg)  | [64-bit](https://download.microsoft.com/download/D/7/2/D725E47F-A4F1-4285-8935-A91AE2FCC06A/dotnet-sdk-2.0.3-osx-x64.tar.gz)| [64-bit](https://download.microsoft.com/download/5/C/1/5C190037-632B-443D-842D-39085F02E1E8/dotnet-runtime-2.0.3-osx-x64.pkg)      | [64-bit](https://download.microsoft.com/download/5/C/1/5C190037-632B-443D-842D-39085F02E1E8/dotnet-runtime-2.0.3-osx-x64.tar.gz)   |
| Linux * | See installations steps below                         | [64-bit](https://download.microsoft.com/download/D/7/2/D725E47F-A4F1-4285-8935-A91AE2FCC06A/dotnet-sdk-2.0.3-linux-x64.tar.gz)     | -                                                                  | [64-bit](https://download.microsoft.com/download/5/C/1/5C190037-632B-443D-842D-39085F02E1E8/dotnet-runtime-2.0.3-linux-x64.tar.gz) |
| RHEL6   | -                                         | -                                                        | -                                                 | [64-bit](http://download.microsoft.com/download/5/C/1/5C190037-632B-443D-842D-39085F02E1E8/dotnet-runtime-2.0.3-rhel.6-x64.tar.gz) |
**Checksum** files to verify downloads are available as follows:
* [Checksums_Runtime](https://dotnetcli.blob.core.windows.net/dotnet/checksums/2.0.3-runtime-sha.txt)
* [Checksums_SDK](https://dotnetcli.blob.core.windows.net/dotnet/checksums/2.0.3-sdk-sha.txt)

**Debug Symbols**
* [Shared Framework](https://download.microsoft.com/download/5/C/1/5C190037-632B-443D-842D-39085F02E1E8/corefx-2.0.3-symbols.zip)
* [Runtime](https://download.microsoft.com/download/5/C/1/5C190037-632B-443D-842D-39085F02E1E8/coreclr-2.0.3-symbols.zip)

## Docker

Images for .NET Core 2.0.3 are available on [Docker](https://hub.docker.com/r/microsoft/dotnet/).
## Installing .NET Core on Linux

### Uninstall any Preview versions

If you have .NET Core Previews installed, it will need to be removed before attempting to install .NET Core 2.0. This can be done by running a command such as the following.

`sudo apt remove dotnet-dev-2.0.0-preview2-006497`

### Ubuntu and Debian based systems

Register the Microsoft key, the product repository for your distro and install required system dependencies with the following scripts.

#### Ubuntu 17.04

```bash
curl https://packages.microsoft.com/keys/microsoft.asc | gpg --dearmor > microsoft.gpg
sudo mv microsoft.gpg /etc/apt/trusted.gpg.d/microsoft.gpg
sudo sh -c 'echo "deb [arch=amd64] https://packages.microsoft.com/repos/microsoft-ubuntu-zesty-prod zesty main" > /etc/apt/sources.list.d/dotnetdev.list'
```

#### Ubuntu 16.04

```bash
curl https://packages.microsoft.com/keys/microsoft.asc | gpg --dearmor > microsoft.gpg
sudo mv microsoft.gpg /etc/apt/trusted.gpg.d/microsoft.gpg
sudo sh -c 'echo "deb [arch=amd64] https://packages.microsoft.com/repos/microsoft-ubuntu-xenial-prod xenial main" > /etc/apt/sources.list.d/dotnetdev.list'
```
#### Ubuntu 14.04

```bash
curl https://packages.microsoft.com/keys/microsoft.asc | gpg --dearmor > microsoft.gpg
sudo mv microsoft.gpg /etc/apt/trusted.gpg.d/microsoft.gpg
sudo sh -c 'echo "deb [arch=amd64] https://packages.microsoft.com/repos/microsoft-ubuntu-trusty-prod trusty main" > /etc/apt/sources.list.d/dotnetdev.list'
```

Then, update the package cache and install .NET Core

```bash
sudo apt-get update
sudo apt-get install dotnet-sdk-2.0.3
```

### RHEL and Fedora based systems

Register the Microsoft key, the product repository for your distro and install required system dependencies with the following scripts.

#### Fedora, CentOS, Oracle Linux

```bash
sudo rpm --import https://packages.microsoft.com/keys/microsoft.asc
sudo sh -c 'echo -e "[packages-microsoft-com-prod]\nname=packages-microsoft-com-prod\nbaseurl=https://packages.microsoft.com/yumrepos/microsoft-rhel7.3-prod\nenabled=1\ngpgcheck=1\ngpgkey=https://packages.microsoft.com/keys/microsoft.asc" > /etc/yum.repos.d/dotnetdev.repo'
```

#### SUSE, SLES

```bash
sudo rpm --import https://packages.microsoft.com/keys/microsoft.asc
sudo sh -c 'echo -e "[packages-microsoft-com-prod]\nname=packages-microsoft-com-prod\nbaseurl=https://packages.microsoft.com/yumrepos/microsoft-rhel7.3-prod\nenabled=1\ngpgcheck=1\ngpgkey=https://packages.microsoft.com/keys/microsoft.asc" > /etc/zypp/repos.d/dotnetdev.repo'
```

Then, update the package cache and install .NET Core

#### Fedora, CentOS and Oracle Linux

```bash
sudo yum update
sudo yum install dotnet-sdk-2.0.3
```

#### SUSE Enterprise Linux and OpenSUSE

```bash
sudo zypper update
sudo zypper install dotnet-sdk-2.0.3
```

**Note:** When installing the SDK, SUSE and OpenSUSE may report that nothing provides libcurl. libcurl should already be installed on supported versions of both distros. Run zypper search libcurl to confirm. The error will present 2 "solutions". Choose "Solution 2" to continue installing .NET Core.

## Installation from a binary archive

Installing from the packages detailed above is recommended and you can also install from binary archive. When using binary archives to install, the contents must be extracted to a user location such as `$HOME/dotnet` and a symbolic link created for `dotnet`.

```bash
mkdir -p $HOME/dotnet && tar zxf dotnet.tar.gz -C $HOME/dotnet
export PATH=$PATH:$HOME/dotnet
```

## Server Hosting

If you are looking to host stand-alone apps on Windows Servers, the ASP.NET Core Module for IIS can be installed separately on servers without installing .NET Core runtime.

## Windows

You can download the Windows (Server Hosting) installer and run the following command from an Administrator command prompt:
[DotNetCore.2.0.3-WindowsHosting.exe](https://download.microsoft.com/download/5/C/1/5C190037-632B-443D-842D-39085F02E1E8/DotNetCore.2.0.3-WindowsHosting.exe)

## Linux

On supported Linux systems, register the Microsoft Product feed as described above and install `dotnet-hosting-2.0.3` using your package manager.

### ASP.NET Runtime Core Package Store

The Runtime Package Store is installed by the .NET Core SDK and the Windows Server Hosting installer. If you need to install the Runtime Package Store separately, the following can be used.

* [AspNetCore.2.0.3.RuntimePackageStore_x64.exe](https://download.microsoft.com/download/5/C/1/5C190037-632B-443D-842D-39085F02E1E8/AspNetCore.2.0.3.RuntimePackageStore_x64.exe)
* [AspNetCore.2.0.3.RuntimePackageStore_x86.exe](https://download.microsoft.com/download/5/C/1/5C190037-632B-443D-842D-39085F02E1E8/AspNetCore.2.0.3.RuntimePackageStore_x86.exe)
