// Copyright 2020 H2O.ai, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

import './index.css';
import React from 'react';
import ReactDOM from 'react-dom';
import { Editor } from './editor';
import { editor } from './model'

ReactDOM.render(
	<React.StrictMode>
		<div>
			<button onClick={editor.loadApp}>Load app</button>
			<button onClick={editor.startApp}>Start app</button>
			<button onClick={editor.stopApp}>Stop app</button>
		</div>
		<Editor />
		<iframe src='/sample_app' width='100%' height='400' />
	</React.StrictMode>,
	document.getElementById('root')
);
