# Plot / Area / Range
# Make an area #plot representing a range (band) of values.
# ---
from h2o_wave import site, data, ui

page = site['/demo']

page.add('example', ui.plot_card(
    box='1 1 4 5',
    title='Area, range',
    data=data('date low high', 31, rows=[
        (1246406400000, 14.3, 27.7),
        (1246492800000, 14.5, 27.8),
        (1246579200000, 15.5, 29.6),
        (1246665600000, 16.7, 30.7),
        (1246752000000, 16.5, 25.0),
        (1246838400000, 17.8, 25.7),
        (1246924800000, 13.5, 24.8),
        (1247011200000, 10.5, 21.4),
        (1247097600000, 9.2, 23.8),
        (1247184000000, 11.6, 21.8),
        (1247270400000, 10.7, 23.7),
        (1247356800000, 11.0, 23.3),
        (1247443200000, 11.6, 23.7),
        (1247529600000, 11.8, 20.7),
        (1247616000000, 12.6, 22.4),
        (1247702400000, 13.6, 19.6),
        (1247788800000, 11.4, 22.6),
        (1247875200000, 13.2, 25.0),
        (1247961600000, 14.2, 21.6),
        (1248048000000, 13.1, 17.1),
        (1248134400000, 12.2, 15.5),
        (1248220800000, 12.0, 20.8),
        (1248307200000, 12.0, 17.1),
        (1248393600000, 12.7, 18.3),
        (1248480000000, 12.4, 19.4),
        (1248566400000, 12.6, 19.9),
        (1248652800000, 11.9, 20.2),
        (1248739200000, 11.0, 19.3),
        (1248825600000, 10.8, 17.8),
        (1248912000000, 11.8, 18.5),
        (1248998400000, 10.8, 16.1),
    ]),
    plot=ui.plot([ui.mark(type='area', x_scale='time', x='=date', y0='=low', y='=high')])
))

page.save()
