// Copyright 2020 H2O.ai, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

import React from 'react'
import { stylesheet } from 'typestyle'
import { clas, margin, padding } from './theme'

const
  css = stylesheet({
    live: {
      backgroundColor: '#ff2938',
      color: '#fff',
      fontSize: 11,
      fontWeight: 700,
      letterSpacing: 4,
      textAlign: 'center',
      margin: margin(5, 0, 10),
      padding: padding(2, 0),
      borderRadius: 2,
    }
  })
export const Logo = () => (
  <div>
    <svg width="35.964439mm" height="9.0737419mm" viewBox="0 0 35.964439 9.0737419">
      <g transform="matrix(0.54446153,0,0,0.54446153,-16.152559,-20.599374)">
        <path d="m 44.823532,48.430372 q 0,0.633406 -0.452432,1.085839 -0.429811,0.429811 -1.063217,0.429811 h -5.564924 l -5.632788,4.230247 q -0.384568,0.294081 -0.837,0.316703 -0.452433,0.04524 -0.859623,-0.203595 -0.339324,-0.203595 -0.542919,-0.54292 -0.203595,-0.339324 -0.203595,-0.769135 v -9.093899 q 0,-0.633406 0.429811,-1.063217 0.452433,-0.452433 1.085839,-0.452433 0.633406,0 1.063217,0.452433 0.452433,0.429811 0.452433,1.063217 v 6.062599 l 3.642084,-2.737218 q 0.407189,-0.294082 0.904865,-0.294082 h 4.54695 v -3.031299 q 0,-0.633406 0.429811,-1.063217 0.452433,-0.452433 1.085839,-0.452433 0.633406,0 1.063217,0.452433 0.452432,0.429811 0.452432,1.063217 z" />
        <path d="m 61.789719,48.430372 q 0,0.633406 -0.452433,1.085839 -0.429811,0.429811 -1.063217,0.429811 -0.633406,0 -1.085839,-0.429811 -0.429811,-0.452433 -0.429811,-1.085839 v -6.062599 l -9.704683,7.261546 q -0.520298,0.384568 -1.153704,0.316703 -0.633405,-0.09049 -1.017973,-0.633406 -0.384568,-0.520298 -0.27146,-1.10846 0.09049,-0.610784 0.588163,-0.995352 l 12.14782,-9.071278 q 0.361946,-0.271459 0.791757,-0.294081 0.429811,-0.04524 0.791758,0.13573 0.384568,0.158351 0.610784,0.520298 0.248838,0.361946 0.248838,0.837 z" />
        <path d="m 78.507067,43.001179 q 0.384568,0.520297 0.27146,1.131082 -0.09049,0.588162 -0.588162,0.97273 l -12.147821,9.071278 q -0.384568,0.271459 -0.814379,0.294081 -0.407189,0.04524 -0.791757,-0.13573 -0.361946,-0.158351 -0.610784,-0.520298 -0.226217,-0.361946 -0.226217,-0.837 v -9.093899 q 0,-0.633406 0.429811,-1.063217 0.452433,-0.452433 1.085839,-0.452433 0.633406,0 1.063217,0.452433 0.452433,0.429811 0.452433,1.063217 v 6.062599 l 9.704683,-7.261546 q 0.520298,-0.384568 1.153704,-0.294081 0.633406,0.06786 1.017973,0.610784 z" />
        <path d="m 95.722092,52.977322 q 0,0.633406 -0.452433,1.063217 -0.429811,0.452433 -1.063217,0.452433 h -6.062599 q -0.633406,0 -1.085839,-0.452433 -0.429811,-0.429811 -0.429811,-1.063217 v -3.0313 h -4.546949 q -0.633406,0 -1.085839,-0.429811 -0.429811,-0.452433 -0.429811,-1.085839 v -4.546949 q 0,-0.633406 0.429811,-1.063217 0.452433,-0.452433 1.085839,-0.452433 h 12.125198 q 0.633406,0 1.063217,0.452433 0.452433,0.429811 0.452433,1.063217 0,0.633406 -0.452433,1.085838 -0.429811,0.429812 -1.063217,0.429812 H 83.596893 v 1.515649 h 4.54695 q 0.633406,0 1.063217,0.452433 0.452433,0.429811 0.452433,1.063217 v 3.0313 h 4.546949 q 0.633406,0 1.063217,0.429811 0.452433,0.452433 0.452433,1.085839 z" />
      </g>
    </svg>
    <div className={clas('wave-pulse', css.live)}>LIVE</div>
  </div>
)