---
slug: release-0.14
title: Wave 0.14 released
author: Prithvi Prabhu
author_title: Chief of Technology @ H2O.ai
author_url: https://github.com/lo5
author_image_url: https://avatars3.githubusercontent.com/u/6334572
image: /img/wave-type-yellow-1100x400.png

tags: [release]
---

[Wave v0.14 is released](https://github.com/h2oai/wave/releases/tag/v0.14.0). This is mainly a security, performance, and bugfix release. The release also includes experimental support for building and controlling Wave dashboards using the R programming language.

<!--truncate-->

## Highlights

The Wave server now ships with a built-in utility to generate, use, and manage API keys conveniently. See [Security](https://wave.h2o.ai/docs/security).

The Wave server also provides additional control over how it handles external requests. See [Configuration](https://wave.h2o.ai/docs/configuration).

Additionally, starting v0.14, Python app servers now only process requests originating from the Wave server. The API key/secret pair for accessing the app server is automatically generated for each launch, and can be overridden using the new `H2O_WAVE_APP_ACCESS_KEY_ID` and `H2O_WAVE_APP_ACCESS_KEY_SECRET` for development and testing, if required. See [Configuration](https://wave.h2o.ai/docs/configuration).

Adding R language support also introduced major changes and simplification in the backend app and communication protocols, which should make it simpler to ship support for interactive R web apps in the near future.

All the work that has gone into this release sets the stage for adding support for many more languages, scripting and command-line control of content and visualizations displayed in Wave.

## Wave ML

[Wave ML](https://github.com/h2oai/wave-ml) API documentation is now [available online](/docs/api/h2o_wave_ml/index).

## Download

Get the release [here](https://github.com/h2oai/wave/releases/tag/v0.14.0). Check out the release notes for more details.

We look forward to continuing our collaboration with the community and hearing your feedback as we further improve and expand the H2O Wave platform.

We'd like to thank the entire Wave team and the community for all of the contributions to this work!


