---
title: Introduction
slug: /guide
---

Welcome to the H2O Wave Guide! If you prefer to learn concepts step by step, you've come to the right place. 

:::info
If you haven't already, it's worthwhile reading the [Getting Started](getting-started.md) page, which offers a 5-minute overview of what H2O Wave is all about.
:::

## Before you start

If you prefer to learn by doing, [start with our tutorials](tutorial-hello.md) - they're short and simple, illustrate the most important concepts in a beginner-friendly way, and are the best way to get hands-on with Wave. Like any unfamiliar technology, Wave has a slight learning curve, but you will get the hang of it with practice and patience. 

## Who is this for?

This documentation assumes that you have some familiarity with the Python programming language. You don't have to be an expert, but it might be harder to learn both Wave and Python at the same time.

If you already know Python, but have no experience authoring web apps, you'll probably find Wave a fun and easy way to get started, without the hassle of learning HTML, CSS, Javascript and client-server programming.

If you have some experience building web apps using Python (or even other languages), you'll find that Wave offers an approach quite different from traditional client-server or request-reply programming. The mental model is much simpler, functional (in the functional programming sense), and lets you reason about your code in terms of a single tier (server-only) as opposed to two tiers (client and server). Additionally, Wave offers straightforward ways to integrate realtime features into your apps using the same programming model.






