---
title: Overview
custom_edit_url: null
---

Wave aims to provide ready-to-use components for every possible usecase our developers might encounter. This section
showcases all the possible combinations of attributes that might come in handy and gives tips on how to achieve the best UX
possible for your users. If you would like to see the components in action and play around with the interactivity, go to `Tour` app.

The basic building block of a Wave application is a card. Our design team works relentlessly to achieve both highly usable
and visually attractive components. It is highly recommended to use these whenever possible. If you, however, feel like there is
a component or attribute that is currently missing and could be helpful for more people, don't hesitate and [start a discussion](https://github.com/h2oai/wave/discussions) where you can discuss your ideas with Wave team directly.

## More control

For people wanting more flexibility we have [ui.form_card](/docs/api/ui#form_card) with a rich set of alignment and sizing options.
For more info visit [forms overview](/docs/widgets/form/overview).

## Custom components

For cases like these you can use [ui.markup_card](/docs/api/ui#markup_card) where you can specify your HTML. Need to add some interactivity? Have a look at our [Javascript](/docs/javascript) section.

:::warning
One of the key advantages of Wave is zero HTML / CSS / JS knowledge. We strongly advise you to use
native Wave components and use custom HTML only as a last resort solution.
:::

## Content

- [header](/docs/widgets/content/header)
- [footer](/docs/widgets/content/footer)
- [navigation](/docs/widgets/content/navigation)
- [breadcrumbs](/docs/widgets/content/breadcrumbs)
- [toolbar](/docs/widgets/content/toolbar)
- [tabs](/docs/widgets/content/tabs)
- [markdown](/docs/widgets/content/markdown)
- [image](/docs/widgets/content/image)
- [article](/docs/widgets/content/article)
- [tall_article_preview](/docs/widgets/content/tall_article_preview)
- [wide_article_preview](/docs/widgets/content/wide_article_preview)
- [preview](/docs/widgets/content/preview)
- [tall_info](/docs/widgets/content/tall_info)
- [wide_info](/docs/widgets/content/wide_info)
- [post](/docs/widgets/content/post)
- [profile](/docs/widgets/content/profile)
- [template](/docs/widgets/content/template)
- [markup](/docs/widgets/content/markup)
- [frame](/docs/widgets/content/frame)

## Stat

- [large_stat](/docs/widgets/stat/large_stat)
- [large_bar_stat](/docs/widgets/stat/large_bar_stat)
- [small_stat](/docs/widgets/stat/small_stat)
- [small_series_stat](/docs/widgets/stat/small_series_stat)
- [tall_stats](/docs/widgets/stat/tall_stats)
- [tall_gauge_stat](/docs/widgets/stat/tall_gauge_stat)
- [tall_series_stat](/docs/widgets/stat/tall_series_stat)
- [wide_pie_stat](/docs/widgets/stat/wide_pie_stat)
- [wide_bar_stat](/docs/widgets/stat/wide_bar_stat)
- [wide_gauge_stat](/docs/widgets/stat/wide_gauge_stat)
- [wide_series_stat](/docs/widgets/stat/wide_series_stat)

## Form

- [button](/docs/widgets/form/button)
- [checkbox](/docs/widgets/form/checkbox)
- [checklist](/docs/widgets/form/checklist)
- [choice_group](/docs/widgets/form/choice_group)
- [color_picker](/docs/widgets/form/color_picker)
- [combobox](/docs/widgets/form/combobox)
- [copyable_text](/docs/widgets/form/copyable_text)
- [date_picker](/docs/widgets/form/date_picker)
- [dropdown](/docs/widgets/form/dropdown)
- [expander](/docs/widgets/form/expander)
- [facepile](/docs/widgets/form/facepile)
- [file_upload](/docs/widgets/form/file_upload)
- [frame](/docs/widgets/form/frame)
- [image](/docs/widgets/form/image)
- [inline](/docs/widgets/form/inline)
- [label](/docs/widgets/form/label)
- [link](/docs/widgets/form/link)
- [links](/docs/widgets/form/links)
- [markup](/docs/widgets/form/markup)
- [menu](/docs/widgets/form/menu)
- [message_bar](/docs/widgets/form/message_bar)
- [persona](/docs/widgets/form/persona)
- [picker](/docs/widgets/form/picker)
- [progress](/docs/widgets/form/progress)
- [range_slider](/docs/widgets/form/range_slider)
- [separator](/docs/widgets/form/separator)
- [slider](/docs/widgets/form/slider)
- [spinbox](/docs/widgets/form/spinbox)
- [stats](/docs/widgets/form/stats)
- [stepper](/docs/widgets/form/stepper)
- [table](/docs/widgets/form/table)
- [tabs](/docs/widgets/form/tabs)
- [template](/docs/widgets/form/template)
- [text](/docs/widgets/form/text)
- [text_annotator](/docs/widgets/form/text_annotator)
- [textbox](/docs/widgets/form/textbox)
- [toggle](/docs/widgets/form/toggle)
- [vega_visualization](/docs/widgets/form/vega_visualization)
- [visualization](/docs/widgets/form/visualization)
