/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	"context"

	cephrookiov1 "github.com/rook/rook/pkg/apis/ceph.rook.io/v1"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	schema "k8s.io/apimachinery/pkg/runtime/schema"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
)

// FakeCephBlockPoolRadosNamespaces implements CephBlockPoolRadosNamespaceInterface
type FakeCephBlockPoolRadosNamespaces struct {
	Fake *FakeCephV1
	ns   string
}

var cephblockpoolradosnamespacesResource = schema.GroupVersionResource{Group: "ceph.rook.io", Version: "v1", Resource: "cephblockpoolradosnamespaces"}

var cephblockpoolradosnamespacesKind = schema.GroupVersionKind{Group: "ceph.rook.io", Version: "v1", Kind: "CephBlockPoolRadosNamespace"}

// Get takes name of the cephBlockPoolRadosNamespace, and returns the corresponding cephBlockPoolRadosNamespace object, and an error if there is any.
func (c *FakeCephBlockPoolRadosNamespaces) Get(ctx context.Context, name string, options v1.GetOptions) (result *cephrookiov1.CephBlockPoolRadosNamespace, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewGetAction(cephblockpoolradosnamespacesResource, c.ns, name), &cephrookiov1.CephBlockPoolRadosNamespace{})

	if obj == nil {
		return nil, err
	}
	return obj.(*cephrookiov1.CephBlockPoolRadosNamespace), err
}

// List takes label and field selectors, and returns the list of CephBlockPoolRadosNamespaces that match those selectors.
func (c *FakeCephBlockPoolRadosNamespaces) List(ctx context.Context, opts v1.ListOptions) (result *cephrookiov1.CephBlockPoolRadosNamespaceList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewListAction(cephblockpoolradosnamespacesResource, cephblockpoolradosnamespacesKind, c.ns, opts), &cephrookiov1.CephBlockPoolRadosNamespaceList{})

	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &cephrookiov1.CephBlockPoolRadosNamespaceList{ListMeta: obj.(*cephrookiov1.CephBlockPoolRadosNamespaceList).ListMeta}
	for _, item := range obj.(*cephrookiov1.CephBlockPoolRadosNamespaceList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested cephBlockPoolRadosNamespaces.
func (c *FakeCephBlockPoolRadosNamespaces) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewWatchAction(cephblockpoolradosnamespacesResource, c.ns, opts))

}

// Create takes the representation of a cephBlockPoolRadosNamespace and creates it.  Returns the server's representation of the cephBlockPoolRadosNamespace, and an error, if there is any.
func (c *FakeCephBlockPoolRadosNamespaces) Create(ctx context.Context, cephBlockPoolRadosNamespace *cephrookiov1.CephBlockPoolRadosNamespace, opts v1.CreateOptions) (result *cephrookiov1.CephBlockPoolRadosNamespace, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewCreateAction(cephblockpoolradosnamespacesResource, c.ns, cephBlockPoolRadosNamespace), &cephrookiov1.CephBlockPoolRadosNamespace{})

	if obj == nil {
		return nil, err
	}
	return obj.(*cephrookiov1.CephBlockPoolRadosNamespace), err
}

// Update takes the representation of a cephBlockPoolRadosNamespace and updates it. Returns the server's representation of the cephBlockPoolRadosNamespace, and an error, if there is any.
func (c *FakeCephBlockPoolRadosNamespaces) Update(ctx context.Context, cephBlockPoolRadosNamespace *cephrookiov1.CephBlockPoolRadosNamespace, opts v1.UpdateOptions) (result *cephrookiov1.CephBlockPoolRadosNamespace, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateAction(cephblockpoolradosnamespacesResource, c.ns, cephBlockPoolRadosNamespace), &cephrookiov1.CephBlockPoolRadosNamespace{})

	if obj == nil {
		return nil, err
	}
	return obj.(*cephrookiov1.CephBlockPoolRadosNamespace), err
}

// Delete takes name of the cephBlockPoolRadosNamespace and deletes it. Returns an error if one occurs.
func (c *FakeCephBlockPoolRadosNamespaces) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewDeleteAction(cephblockpoolradosnamespacesResource, c.ns, name), &cephrookiov1.CephBlockPoolRadosNamespace{})

	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeCephBlockPoolRadosNamespaces) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	action := testing.NewDeleteCollectionAction(cephblockpoolradosnamespacesResource, c.ns, listOpts)

	_, err := c.Fake.Invokes(action, &cephrookiov1.CephBlockPoolRadosNamespaceList{})
	return err
}

// Patch applies the patch and returns the patched cephBlockPoolRadosNamespace.
func (c *FakeCephBlockPoolRadosNamespaces) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *cephrookiov1.CephBlockPoolRadosNamespace, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(cephblockpoolradosnamespacesResource, c.ns, name, pt, data, subresources...), &cephrookiov1.CephBlockPoolRadosNamespace{})

	if obj == nil {
		return nil, err
	}
	return obj.(*cephrookiov1.CephBlockPoolRadosNamespace), err
}
