# Getting Started with the sample

The goal of this doc is to get you setup with a workable WebAssembly SDK and run the sample.  

## Content

&nbsp;&nbsp;&nbsp;&nbsp;[Requirements](#requirements)  
&nbsp;&nbsp;&nbsp;&nbsp;[Create sample](#create-sample)  
&nbsp;&nbsp;&nbsp;&nbsp;[Serving sample](#serving-sample)  
  

## Requirements

- [WebAssembly SDK](./obtain-wasm-sdk.md) - Right now the WebAssembly sdk is packaged in a zip file and can be downloaded and unzipped ready to go from the build server.  We are working on distribution and easier setup in future steps.

## Create sample

The WebAssembly SDK includes the sample code that we can use.

1. Create a directory:

    ```
    mkdir my-app
    cd my-app
    ```

1. Copy the sample code from the SDK. We'll assume that the $WASM_SDK variable points to it.

    ```
    cp $WASM_SDK/sample.html .
    cp $WASM_SDK/sample.cs .
    cp $WASM_SDK/dependency.cs .
    cp $WASM_SDK/server.py .
    ```

1.  Compile sample

    ```
    csc /target:library -out:sample.dll /noconfig /nostdlib /r:$WASM_SDK/wasm-bcl/wasm/mscorlib.dll /r:$WASM_SDK/wasm-bcl/wasm/System.dll /r:$WASM_SDK/wasm-bcl/wasm/System.Core.dll /r:$WASM_SDK/wasm-bcl/wasm/Facades/netstandard.dll /r:$WASM_SDK/wasm-bcl/wasm/System.Net.Http.dll /r:$WASM_SDK/framework/WebAssembly.Bindings.dll /r:$WASM_SDK/framework/WebAssembly.Net.Http.dll dependency.cs sample.cs
    ```

1. Package and publish sample 

    ```
    mono $WASM_SDK/packager.exe --copy=always --out=./publish --asset=./sample.html --asset=server.py sample.dll
    ```

    The `package` command will generate a `runtime.js` file that will properly load the runtime and call `App.Init` after that.
    
    It will copy the required files such as the support libraries and assets.


You should now have the following directory structure

```
.
|--- my-app                           
     |--- publish               // Output from the `packager.exe` application 
        |--- managed            // Where to find the managed assemblies generated by packager.exe
        |--- mono-config.js     // Configuration file referenced in `sample.html` and `runtime.js`
        |--- dotnet.js            // Mono WebAssembly implementations
        |--- dotnet.wasm          // Mono WebAssembly implementations
        |--- runtime.js         // Handles the loading of the Mono WebAssembly modules
        |--- sample.html        // sample html file
        |--- server.py          // python test server
     |--- sample.html           // sample html file
     |--- sample.cs             // sample c-sharp source file
     |--- dependency.cs         // dependency file used by the sample
     |--- server.py             // python test server
```

## Serving sample

The application should now be packaged and published.

To test the application launch the provided webserver:

```

cd publish
python3 server.py

```

After executing you will see the port displayed (default: 8000):

```
publish$ python server.py
('python 3 serving at port', 8000)
```

From a browser got to `http://localhost:8000/sample.html` or `http://127.0.0.1:8000/sample.html` depending on the browser.  

Change the port number to what the server specifies.  



