#!/usr/bin/env bash
#
# System Report Script, Version 1.05
#
# The purpose of this script is to use shell commands to build a set of html files in a
# folder in the user's folder called home/username/SysReport where username is replaced with
# the username of the logged on user. This set of files will load
# via home/username/SysReport/index.html a frame set with navigation in the left frame,
# and individual reports about different parts of the system in the right frame of the document.
#
#

BASE=`pwd`

function startup {
    echo "Creating SysReport Folder"
    if [ -e $BASE/SysReport ] && [ -d $BASE/SysReport ]
        then : # if it exists and is a folder do nothing
        else mkdir $BASE/SysReport
    fi
}

function cleanup {
    cd $BASE
    tar -Pczf /tmp/SysReport.tar.gz  ./SysReport/
    rm -rf  ./SysReport/
}

function Ubuntu {
startup 

#Creat index.html
cat > $BASE/SysReport/index.html << EOF
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 3.2//EN">
<HTML><HEAD>
	<META HTTP-EQUIV="Content-Type" CONTENT="text/html;CHARSET=iso-8859-1">
	<META NAME="Author" Content="Ray Parrish">
	<TITLE>System Report</TITLE>
</HEAD>
<FRAMESET   COLS = "21%,79% "  >
	<FRAME SRC="navigate.html" NAME="Navigate" RESIZE>
	<FRAME SRC="Introduction.html" NAME="Modules" RESIZE>
</FRAMESET>
<NOFRAMES>
<BODY>
<P>
</BODY>
</NOFRAMES>
</HTML>
EOF

##################################################################################
#echo "Creating Introduction.html"
# Here I create the introduction page.
cat > $BASE/SysReport/Introduction.html << EOF
<html>
<head>
<meta content="text/html;charset=ISO-8859-1" http-equiv="Content-Type">
<title>Introduction to System Report</title>
</head>
<body>
<center><p>Welcome, you are logged in as: $USER</center>
<table style="text-align: left; width: 100%;" border="2" cellpadding="2"
cellspacing="2">
<tbody>
<tr>
<td
style="vertical-align: top; background-color: rgb(153, 255, 255);">Welcome
to the script generated
System Report for Ubuntu systems. This
set of web pages is generated from many accessible files and commands
on your
system by the SystemReport.sh file. This set of pages was generated by Version 1.05 of SystemReport.sh<br>
<br>
Each report is listed in the navigation frame on the left and will load
in this frame. Each section includes an explanation of what
command or file was accessed to generate that section of the report.<br>
<br>
As I learn more about Ubuntu and Linux and scripting the
SystemReport.sh file will grow and so will the number of html files it
generates. Look for it at <a href="http://www.rayslinks.com/scripts/SysReport.html" target="blank">System Report Script</a> to see if there are new
versions of it.<br>
<br>
The SystemReport.sh file is open source and so I encourage you to add
to it yourself as long as you don't hold me responsible for any damages
your changes cause. 8-)<br>
<br>
If you do add a section to one of the pages, or even a whole page to the set, please 
<a href="mailto:crp@cmc.net?subject=System Report changes">email me</a>   your changes or additions only. Please don't send me the whole script to look through for your changes.
<p>SystemReport.sh may be ran multiple times so that it may update these
pages when you make changes to your system and so you can replace it
with a newer version of the script and generate a new set of these web
pages.<br>
</td>
</tr>
</tbody>
</table>
<br>
<br>
</body>
</html>
EOF

#########################################################################################################
#Creat navigate.html
cat > $BASE/SysReport/navigate.html << EOF
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN">
<html>
<head><title>Sysytem Report Navigation</title>
<meta http-equiv="Content-Type" content="text/html;CHARSET=iso-8859-1"> 
<meta content="Ray Parrish" name="Author"></head>
<body>
<ul> 
	<li><a href="Introduction.html" target="Modules">Introduction to System Report</a> </li>
	<li><a href="cpuinfo.html" target="Modules">CPU Information</a> </li>
	<li><a href="drive.html" target="Modules">Drive Information</a> </li>
	<li><a href="environment.html" target="Modules">Environment Variables</a> </li>
	<li><a href="software.html" target="Modules">Installed Packages</a> </li>
	<li><a href="logfiles.html" target="Modules">Log Files</a> </li>
	<li><a href="memory.html" target="Modules">Memory</a> </li>
	<li><a href="modules.html" target="Modules">Modules Loaded</a> </li>
	<li><a href="network.html" target="Modules">Network</a> </li>
	<li><a href="opsys.html" target="Modules">Operating Systems</a> </li>
	<li><a href="PCIBus.html" target="Modules">PCI Bus</a> </li>
	<li><a href="usb.html" target="Modules">USB Devices</a> </li>
	<li><a href="varlogmsg.html"  target="Modules">MESSAGES</a> </li>
	<li><a href="dmesg.html" target="Modules">DMESG</a> </li>
	<li><a href="syslog.html" target="Modules">SYSLOG</a> </li>
	<li><a href="kernlog.html" target="Modules">KERN.LOG</a> </li>
</ul>
EOF

#######################################################################################################
# create cpuinfo.html
cat > $BASE/SysReport/cpuinfo.html << EOF
<html>
<head>
<meta content="text/html;charset=ISO-8859-1" http-equiv="Content-Type">
<title>CPU Information</title>
</head>
<bo
dy>
<p>CPU Information.
<table style="text-align: left; width: 100%;" border="2" cellpadding="2"
cellspacing="2">
<tbody>
<tr>
<td style="vertical-align: top; background-color: rgb(153, 153, 255);">
cat /proc/cpuinfo
</td></tr>
<tr>
<td style="vertical-align: top; background-color: rgb(153, 255, 255);"><pre>
EOF
cat /proc/cpuinfo >> $BASE/SysReport/cpuinfo.html
cat >> $BASE/SysReport/cpuinfo.html << EOF
</pre>
</td>
</tr>
</tbody>
</table>
<br>
To get the out put of this command in terminal use the following form:
<br>
<br>cat /proc/cpuinfo
<p>This will output the information to the terminal screen. You can't open the file cpuinfo in Gedit but the cat command gives you access to the contents of it. It is actually a place in memory, not an actual file on your hard drive and that is why you cannot open it in a text editor.
</body>
</html>
EOF

#############################################################################
# create drive.html
cat > $BASE/SysReport/drive.html << EOF
<html>
<head>
<meta content="text/html;charset=ISO-8859-1" http-equiv="Content-Type">
<title>Drive Information</title>
</head>
<body>
<br>
Drive Information.
<br>
<table style="text-align: left; width: 100%;" border="2" cellpadding="2"
cellspacing="2">
<tbody>
<tr>
<td style="vertical-align: top; background-color: rgb(153, 153, 255);">
cat /proc/diskstats
</td></tr>
<tr>
<td style="vertical-align: top; background-color: rgb(153, 255, 255);"><pre>
EOF
cat /proc/diskstats >> $BASE/SysReport/drive.html
cat >> $BASE/SysReport/drive.html << EOF
</pre>
</td>
</tr>
</tbody>
</table>
<br>
To get the out put of this command in terminal use the following form:
<br>
<br>cat /proc/diskstats
<p>This will output the information to the terminal screen. I'm not sure who this information might be useful to, it's greek to me.
<p>The following output is generated with this command:
<p>df -h >> $BASE/SysReport/drive.html
<p> The -h switch makes it generate human readable output grouped in G, M, and K bytes 8-) You can get the out put in bytes only by using the -b switch instead of -h
<table style="text-align: left; width: 100%;" border="2" cellpadding="2"
cellspacing="2">
<tbody>
<tr>
<td style="vertical-align: top; background-color: rgb(153, 153, 255);">
df -h
</td></tr>
<tr>
<td style="vertical-align: top; background-color: rgb(153, 255, 255);"><pre>
EOF
# generate the out put from system file
df -h >> $BASE/SysReport/drive.html
# try to prompt user to hit enter
cat >> $BASE/SysReport/drive.html << EOF
</pre>
</td>
</tr>
</tbody>
</table>
<p>There is another command you can use to get your partition information but this script cannot run it as it doesn't have super user permission. To have your partition information included in this document, run the following command in terminal, then re-run SystemReport.sh to have that information added in here.
<p>sudo fdisk -l > $BASE/SysReport/fdisk.txt
<p>You will be prompted for your password, type it in and hit enter. You won't see any characters echoed by terminal when you type your password, but just keep typing, it's getting them.
<p>This will create a text file of the fdisk command output which when you re-run SystemReport.sh will be detected and added into this file. Don't forget to update fdisk.txt if you change your partitions around.
EOF

# If the user has ran the ""sudo fdisk -l > $BASE/SysReport/fdisk.txt" command, add the content
# of fdisk.txt into drive.html
if [ -e $BASE/SysReport/fdisk.txt ]
	then
		cat >> $BASE/SysReport/drive.html << EOF
<P>  I see you've created fdisk.txt so here is the information from it below.
<table style="text-align: left; width: 100%;" border="2" cellpadding="2"
cellspacing="2">
<tbody>
<tr>
<td style="vertical-align: top; background-color: rgb(153, 153, 255);">
sudo fdisk - l
</td></tr>
<tr>
<td style="vertical-align: top; background-color: rgb(153, 255, 255);"><pre>
EOF
		cat $BASE/SysReport/fdisk.txt >> $BASE/SysReport/drive.html
		cat >> $BASE/SysReport/drive.html << EOF
</pre>
</td>
</tr>
</tbody>
</table>
<p>Of course you can get your partition information at any time by opening a terminal window and running the following command. You will be prompted for your password, then the output will go to the terminal window.
<p>sudo fdisk -l
</body>
</html>
EOF
fi
# Create the PCIBus.html file with the lspci command
# first write the top of the file to disk
#echo "Creating PCIBus.html"
cat > $BASE/SysReport/PCIBus.html << EOF
<html>
<head>
<meta content="text/html;charset=ISO-8859-1" http-equiv="Content-Type">
<title>PCI Bus Information</title>
</head>
<body>
<p> Hardware Listi.
<p> PCI bus Information and the things connected to it. 
<p>lspci -t -vv 
<table style="text-align: left; width: 100%;" border="2" cellpadding="2"
cellspacing="2">
<tbody>
<tr>
<td style="vertical-align: top; background-color: rgb(153, 153, 255);">
lspci -t -vv
</td></tr>
<tr>
<td style="vertical-align: top; background-color: rgb(153, 255, 255);"><pre>
EOF
# generate the out put into the PCIBus.html file
lspci -t -vv >> $BASE/SysReport/PCIBus.html
# Now add the next section of the file
cat >> $BASE/SysReport/PCIBus.html << EOF
</pre>
</td>
</tr>
</tbody>
</table>
<p>Bus centric Information about Hardware.
<p>lspci -b -v 
<table style="text-align: left; width: 100%;" border="2" cellpadding="2"
cellspacing="2">
<tbody>
<tr>
<td style="vertical-align: top; background-color: rgb(153, 153, 255);">
lspci -b -v
</td></tr>
<tr>
<td style="vertical-align: top; background-color: rgb(153, 255, 255);"><pre>
EOF
# out put the next command to disk
lspci -b -v >> $BASE/SysReport/PCIBus.html
# now write then end of the file
cat >> $BASE/SysReport/drive.html << EOF
</pre>
</td>
</tr>
</tbody>
</table>

</body>
</html>
EOF
# generate a memory report file
# first write the top of the file to disk
#echo "Creating memory.html"
cat > $BASE/SysReport/memory.html << EOF
<html>
<head>
<meta content="text/html;charset=ISO-8859-1" http-equiv="Content-Type">
<title>Memory Information</title>
</head>
<body>
<p>free -m 
<table style="text-align: left; width: 100%;" border="2" cellpadding="2"
cellspacing="2">
<tbody>
<tr>
<td style="vertical-align: top; background-color: rgb(153, 153, 255);">
free -m
</td></tr>
<tr>
<td style="vertical-align: top; background-color: rgb(153, 255, 255);"><pre>
EOF
# out put the next command to disk
free -m >> $BASE/SysReport/memory.html
# now write the next part of the file
cat >> $BASE/SysReport/memory.html << EOF
</pre>
</td>
</tr>
</tbody>
</table>
<p>Swappiness is a measure of how aggressively Ubuntu swaps memory out to the swap file or partition. This next command checks the value of swappiness.
<p>cat /proc/sys/vm/swappiness
<p>Swappiness can be set from 0 to 100 with 100 being the most aggressively paged out. A low number like 10 is recommended for desktops, while 60 is the default in Ubuntu. 60 is also recommended for servers.
<table style="text-align: left; width: 100%;" border="2" cellpadding="2"
cellspacing="2">
<tbody>
<tr>
<td style="vertical-align: top; background-color: rgb(153, 153, 255);">
cat /proc/sys/vm/swappiness
</td></tr>
<tr>
<td style="vertical-align: top; background-color: rgb(153, 255, 255);"><pre>
EOF
# 
# out put the next command to disk
cat /proc/sys/vm/swappiness >> $BASE/SysReport/memory.html
# now write the end of the file
cat >> $BASE/SysReport/memory.html << EOF
</pre>
</td>
</tr>
</tbody>
</table>
<p>Here is the <A HREF="https://help.ubuntu.com/community/SwapFaq" Target="blank">Ubuntu Swap Partition FAQ</a> so you can get up to speed on swap files. Among other things it talks about, the article tells how to adjust swappiness.
</body></html>
EOF
# generate a network report file
# first write the top of the file to disk
#echo "Creating network.html"
cat > $BASE/SysReport/network.html << EOF
<html>
<head>
<meta content="text/html;charset=ISO-8859-1" http-equiv="Content-Type">
<title>Network Information</title>
</head>
<body>
<p> Network Information.
<p>ifconfig -a 
<table style="text-align: left; width: 100%;" border="2" cellpadding="2"
cellspacing="2">
<tbody>
<tr>
<td style="vertical-align: top; background-color: rgb(153, 153, 255);">
ifconfig -a
</td></tr>
<tr>
<td style="vertical-align: top; background-color: rgb(153, 255, 255);"><pre>
EOF
# out put the next command to disk
ifconfig -a >> $BASE/SysReport/network.html
# now write then end of the file
cat >> $BASE/SysReport/network.html << EOF
</pre>
</td>
</tr>
</tbody>
</table>
<p>This next command checks to see if you are connected to a network currently.
<p>cat /sys/class/net/eth0/carrier
<p>This location returns a 0 if you are not connected, and a 1 if you are connected to a network.
<table style="text-align: left; width: 100%;" border="2" cellpadding="2"
cellspacing="2">
<tbody>
<tr>
<td style="vertical-align: top; background-color: rgb(153, 153, 255);">
cat /sys/class/net/eth0/carrier
</td></tr>
<tr>
<td style="vertical-align: top; background-color: rgb(153, 255, 255);"><pre>
EOF
# 
# out put the next command to disk
cat /sys/class/net/eth0/carrier >> $BASE/SysReport/network.html
# now write the end of the file
cat >> $BASE/SysReport/network.html << EOF
</pre>
</td>
</tr>
</tbody>
</table>
</body></html>
EOF
#
# create the opsys.html file
# write the head of the file
#echo "Creating opsys.html"
cat > $BASE/SysReport/opsys.html << EOF
<html>
<head>
<meta content="text/html;charset=ISO-8859-1" http-equiv="Content-Type">
<title>Operating System Information</title>
</head>
<body>
<p>OS distro and version.
<table style="text-align: left; width: 100%;" border="2" cellpadding="2"
cellspacing="2">
<tbody>
<tr>
<td style="vertical-align: top; background-color: rgb(153, 153, 255);">
cat /etc/issue
</td></tr>
<tr>
<td style="vertical-align: top; background-color: rgb(153, 255, 255);"><pre>
EOF
cat /etc/issue >> $BASE/SysReport/opsys.html
cat >> $BASE/SysReport/opsys.html << EOF
</pre>
</td>
</tr>
</tbody>
</table>
<p>Contents of your grub.cfg
<p>cat /boot/grub/grub.cfg 
<table style="text-align: left; width: 100%;" border="2" cellpadding="2"
cellspacing="2">
<tbody>
<tr>
<td style="vertical-align: top; background-color: rgb(153, 153, 255);">
cat /boot/grub/grub.conf
</td></tr>
<tr>
<td style="vertical-align: top; background-color: rgb(153, 255, 255);"><pre>
EOF
# test for existence of menu.lst file and do output accordingly
if [ -e /boot/grub/grub.cfg ]
   then cat /boot/grub/grub.cfg >> $BASE/SysReport/opsys.html
else 
   echo "No menu.lst file found" >> $BASE/SysReport/opsys.html
fi
# now write the next part of the file
cat >> $BASE/SysReport/opsys.html << EOF
</pre>
</td>
</tr>
</tbody>
</table>

<p>Linux kernel Version.
<table style="text-align: left; width: 100%;" border="2" cellpadding="2"
cellspacing="2">
<tbody>
<tr>
<td style="vertical-align: top; background-color: rgb(153, 153, 255);">
uname -a
</td></tr>
<tr>
<td style="vertical-align: top; background-color: rgb(153, 255, 255);"><pre>

EOF
uname -a >> $BASE/SysReport/opsys.html
cat >> $BASE/SysReport/opsys.html << EOF
</pre>
</td>
</tr>
</tbody>
</table>
<p>Bit more information about your version of OS.
<table style="text-align: left; width: 100%;" border="2" cellpadding="2"
cellspacing="2">
<tbody>
<tr>
<td style="vertical-align: top; background-color: rgb(153, 153, 255);">
lsb_release -a
</td></tr>
<tr>
<td style="vertical-align: top; background-color: rgb(153, 255, 255);"><pre>
EOF
lsb_release -a 2> /dev/null >> $BASE/SysReport/opsys.html
cat >> $BASE/SysReport/opsys.html << EOF
</pre>
</td>
</tr>
</tbody>
</table>
</body></html>
EOF
# create logfiles.html
# module added 9/22/08 by C Ray Parrish
#echo "Creating logfiles.html"
cat > $BASE/SysReport/logfiles.html << EOF
<html>
<head>
<meta content="text/html;charset=ISO-8859-1" http-equiv="Content-Type">
<title>Log Files</title>
</head>
<body>
<p>This file is the rsyslog.conf file which determines what messages from the system get sent to which log file. You can look up what log files are available for inspection in this file.
<p>cat /etc/syslog.conf 
<table style="text-align: left; width: 100%;" border="2" cellpadding="2"
cellspacing="2">
<tbody>
<tr>
<td style="vertical-align: top; background-color: rgb(153, 153, 255);">
cat /etc/syslog.conf
</td></tr>
<tr>
<td style="vertical-align: top; background-color: rgb(153, 255, 255);"><pre>
EOF
# out put the next command to disk
cat /etc/rsyslog.conf >> $BASE/SysReport/logfiles.html
# now write the next part of the file
cat >> $BASE/SysReport/logfiles.html << EOF
</pre>
</td>
</tr>
</tbody>
</table>
<p>The syslog.conf file can be edited with a text editor but may need to be started with gksu priveleges to write to file any changes you make. Use the following command -
<p>gksu gedit /etc/syslog.conf
<p>You will be prompted for your password when you run the above command.
</body></html>
EOF
# create software.html
# module added 9/22/08 by C Ray Parrish
#echo "Creating software.html"
cat > $BASE/SysReport/software.html << EOF
<html>
<head>
<meta content="text/html;charset=ISO-8859-1" http-equiv="Content-Type">
<title>Log Files</title>
</head>
<body>
<p>Installed packages
<p><a href=#versions>Jump down to Software Version Information</a>
<table style="text-align: left; width: 100%;" border="2" cellpadding="2"
cellspacing="2">
<tbody>
<tr>
<td style="vertical-align: top; background-color: rgb(153, 153, 255);">
cd /usr/share/doc<br>
ls -a --group-directories-first
</td></tr>
<tr>
<td style="vertical-align: top; background-color: rgb(153, 255, 255);"><pre>
EOF
#echo "     inventory of /usr/share/doc"
# out put the next command to disk
# first change to the right folder
cd /usr/share/doc
# and put a list of it's folders into software.html
ls -a --group-directories-first >> $BASE/SysReport/software.html
# now write the next part of the file
cat >> $BASE/SysReport/software.html << EOF
</pre>
</td>
</tr>
</tbody>
</table>
<a name="versions"
<p><a href="#updates">Jump to updateable packages</a>
<p>There is another command which you can install on your system which will give you the current version of all installed software along with whether or not it is up to date. To install this package issue the following command in terminal -
<p> sudo apt-get install apt-show-versions
<p>You will be prompted for your password and then the package will be installed.
<p>Now re-run the SystemReport.sh script to add the software version information into this document below.
<table style="text-align: left; width: 100%;" border="2" cellpadding="2"
cellspacing="2">
<tbody>
<tr>
<td style="vertical-align: top; background-color: rgb(153, 153, 255);">
apt-show-versions
</td></tr>
<tr>
<td style="vertical-align: top; background-color: rgb(153, 255, 255);"><pre>
EOF
if [ -e "/usr/bin/apt-show-versions" ]; then
  echo "     generating version list"
  touch $BASE/SysReport/versions.txt
  chmod 777 $BASE/SysReport/versions.txt
  apt-show-versions > $BASE/SysReport/versions.txt
  echo "     Sorting version list"
  sort $BASE/SysReport/versions.txt >> $BASE/SysReport/software.html
else
  echo "apt-show-versions not found, follow directions above to get this output" >> $BASE/SysReport/software.html
fi
cat >> $BASE/SysReport/software.html << EOF
</pre>
</td>
</tr>
</tbody>
</table>
<A NAME="updates">
<p>In this next output section we are looking to see which packages on our system need updating.
<p>To do this we add a -u switch to the command from the last section as you can see at the top of the table below.
<p>If there is no out put in the following section, all software on your system is up to date.
<table style="text-align: left; width: 100%;" border="2" cellpadding="2"
cellspacing="2">
<tbody>
<tr>
<td style="vertical-align: top; background-color: rgb(153, 153, 255);">
apt-show-versions -u
</td></tr>
<tr>
<td style="vertical-align: top; background-color: rgb(153, 255, 255);"><pre>
EOF
# now we add the output of packages which need updating if any
echo "     generating list of updates"
# first be sure they have the command installed
if [ -e /usr/bin/apt-show-versions ]
	# check to see if output of command is empty
	then texttest=$(apt-show-versions -u 2> /dev/null)
	     if [ "$texttest" == "" ]
		# if it's empty, all software is up to date
		then echo "Your software is all up to date." >> $BASE/SysReport/software.html
		# otherwise add list of packages which need updating
		else apt-show-versions -u 2> /dev/null >> $BASE/SysReport/software.html
		fi
	# if they don't have the command installed tell them
	else echo "you must install apt-show-versions to get this output" >> $BASE/SysReport/software.html
fi
cat >> $BASE/SysReport/software.html << EOF
</pre>
</td>
</tr>
</tbody>
</table>
<p>This next section isn't the result of a command, it is merely a link to a file on your system which keeps a lot of information about installed software in it. It includes the version, what packages it depends on to operate, which packages they conflict with, and a description of the packages function.
<p>Note that even if you are viewing the sample System Report online the following link is to a file on your system and is not part of the sample report.
<p>You can open the following file with your text editor.
<p>The reason I don't cat this file into the web page report is that on my system it is 1.4 megabytes large so it isn't practical to import it.
<table style="text-align: left; width: 100%;" border="2" cellpadding="2"
cellspacing="2">
<tbody>
<tr>
<td style="vertical-align: top; background-color: rgb(153, 153, 255);">
/var/lib/dpkg/status
</td></tr>
<tr>
<td style="vertical-align: top; background-color: rgb(153, 255, 255);">
<a href="file:///var/lib/dpkg/status">Software Information File</a>
</td>
</tr>
</tbody>
</table>
</body></html>
EOF
# create environment.html
# module added 9/22/08 by C Ray Parrish
#echo "Creating environment.html"
cat > $BASE/SysReport/environment.html << EOF
<html>
<head>
<meta content="text/html;charset=ISO-8859-1" http-equiv="Content-Type">
<title>Environment Variables</title>
</head>
<body>
<p>Environment Variables
<table style="text-align: left; width: 100%;" border="2" cellpadding="2"
cellspacing="2">
<tbody>
<tr>
<td style="vertical-align: top; background-color: rgb(153, 153, 255);">
printenv</td></tr>
<tr>
<td style="vertical-align: top; background-color: rgb(153, 255, 255);"><pre>
EOF
# out put the next command to disk
printenv >> $BASE/SysReport/environment.html
# now write the next part of the file
cat >> $BASE/SysReport/environment.html << EOF
</pre>
</td>
</tr>
</tbody>
</table>
<p>To learn more about environment variables and how to set them have a look at <a href="https://help.ubuntu.com/community/EnvironmentVariables" target="blank">Environment Variables - Ubuntu Community documentation</a>
</body></html>
EOF
# create modules.html
# module added 9/29/08 by C Ray Parrish
#echo "Creating modules.html"
cat > $BASE/SysReport/modules.html << EOF
<html>
<head>
<meta content="text/html;charset=ISO-8859-1" http-equiv="Content-Type">
<title>Environment Variables</title>
</head>
<body>
<p>Loaded Modules Information.
<table style="text-align: left; width: 100%;" border="2" cellpadding="2"
cellspacing="2">
<tbody>
<tr>
<td style="vertical-align: top; background-color: rgb(153, 153, 255);">
lsmod</td></tr>
<tr>
<td style="vertical-align: top; background-color: rgb(153, 255, 255);"><pre>
EOF
# out put the next command to disk
lsmod >> $BASE/SysReport/modules.html
# now write the next part of the file
cat >> $BASE/SysReport/modules.html << EOF
</pre></td></tr></tbody></table></body></html>
EOF

#########################################################################
# create usb.html
cat > $BASE/SysReport/usb.html << EOF
<html>
<head>
<meta content="text/html;charset=ISO-8859-1" http-equiv="Content-Type">
<title>USB Devices</title>
</head>
<body>
<p>Lists of USB devices attached system. 
<table style="text-align: left; width: 100%;" border="2" cellpadding="2"
cellspacing="2">
<tbody>
<tr>
<td style="vertical-align: top; background-color: rgb(153, 153, 255);">
lsusb -v</td></tr>
<tr>
<td style="vertical-align: top; background-color: rgb(153, 255, 255);"><pre>
EOF
# out put the next command to disk
lsusb -v 2>/dev/null >> $BASE/SysReport/usb.html
# now write the next part of the file
cat >> $BASE/SysReport/usb.html << EOF
</pre></td></tr></tbody></table></body></html>
EOF


#######################################################
# create varlogmsg.html
cat > $BASE/SysReport/varlogmsg.html << EOF
<html>
<head>
<meta content="text/html;charset=ISO-8859-1" http-equiv="Content-Type">
<title>VAR_LOG_MESSAGES</title>
</head>
<body>
<p>Log messages list from /var/log/messages.
<table style="text-align: left; width: 100%;" border="2" cellpadding="2"
cellspacing="2">
<tbody>
<tr>
<td style="vertical-align: top; background-color: rgb(153, 153, 255);">
cat /var/log/messages</td></tr>
<tr>
<td style="vertical-align: top; background-color: rgb(153, 255, 255);"><pre>
EOF
# out put the next command to disk
cat /var/log/messages 2>/dev/null >> $BASE/SysReport/varlogmsg.html
# now write the next part of the file
cat >> $BASE/SysReport/varlogmsg.html << EOF
</pre></td></tr></tbody></table></body></html>
EOF


#######################################################
# create dmesg.html
cat > $BASE/SysReport/dmesg.html << EOF
<html>
<head>
<meta content="text/html;charset=ISO-8859-1" http-equiv="Content-Type">
<title>DMESG</title>
</head>
<body>
<p>Log messages list from /var/log/dmesg. 
<table style="text-align: left; width: 100%;" border="2" cellpadding="2"
cellspacing="2">
<tbody>
<tr>
<td style="vertical-align: top; background-color: rgb(153, 153, 255);">
cat /var/log/dmesg  </td></tr>
<tr>
<td style="vertical-align: top; background-color: rgb(153, 255, 255);"><pre>
EOF
# out put the next command to disk
cat /var/log/dmesg 2>/dev/null >> $BASE/SysReport/dmesg.html
# now write the next part of the file
cat >> $BASE/SysReport/dmesg.html << EOF
</pre></td></tr></tbody></table></body></html>
EOF
 

#######################################################
# create syslog.html
cat > $BASE/SysReport/syslog.html << EOF
<html>
<head>
<meta content="text/html;charset=ISO-8859-1" http-equiv="Content-Type">
<title>SYSLOG</title>
</head>
<body>
<p>Log message list from /var/log/syslog. 
<table style="text-align: left; width: 100%;" border="2" cellpadding="2"
cellspacing="2">
<tbody>
<tr>
<td style="vertical-align: top; background-color: rgb(153, 153, 255);">
cat /var/log/syslog </td></tr>
<tr>
<td style="vertical-align: top; background-color: rgb(153, 255, 255);"><pre>
EOF
# out put the next command to disk
cat /var/log/syslog 2>/dev/null >> $BASE/SysReport/syslog.html  
# now write the next part of the file
cat >> $BASE/SysReport/syslog.html  << EOF
</pre></td></tr></tbody></table></body></html>
EOF
 
#######################################################
# create kernlog.html
cat > $BASE/SysReport/kernlog.html << EOF
<html>
<head>
<meta content="text/html;charset=ISO-8859-1" http-equiv="Content-Type">
<title>KERN.LOG</title>
</head>
<body>
<p>Log message list from /var/log/kern.log
<table style="text-align: left; width: 100%;" border="2" cellpadding="2"
cellspacing="2">
<tbody>
<tr>
<td style="vertical-align: top; background-color: rgb(153, 153, 255);">
cat /var/log/kern.log</td></tr>
<tr>
<td style="vertical-align: top; background-color: rgb(153, 255, 255);"><pre>
EOF
# out put the next command to disk
cat /var/log/kern.log 2>/dev/null >> $BASE/SysReport/kernlog.html  
# now write the next part of the file
cat >> $BASE/SysReport/kernlog.html  << EOF
</pre></td></tr></tbody></table></body></html>
EOF
 
cleanup
}

function Fedora {
 startup
 sosreport > $BASE/sysreport.log
 cleanup
 return $?
}

function distro_vector {
       for OS in `cat /etc/issue` ; do echo -e "Operating system: " $OS `uname -r` ; break ; done
       case $OS in
        'Fedora')
             Fedora 
             return $?
         ;;
        'Ubuntu')
             Ubuntu 
             return $?
         ;;
        'Red')
             # same sysreport tool for redhat
             Fedora 
             return $?
         ;;
       *)
        echo "failure. unexpected distro found. Resolve dependencies manually."  
         ;;
     esac 
}

function main {
    distro_vector
    return $?
}

main
exit $?
