---
layout: "docs"
page_title: "rsadecrypt - Functions - Configuration Language"
sidebar_current: "configuration-functions-crypto-rsadecrypt"
description: |-
  The rsadecrypt function decrypts an RSA-encrypted message.
---

# `rsadecrypt` Function


`rsadecrypt` decrypts an RSA-encrypted ciphertext, returning the corresponding
cleartext.

```hcl
rsadecrypt(ciphertext, privatekey)
```

`ciphertext` must be a base64-encoded representation of the ciphertext, using
the PKCS #1 v1.5 padding scheme. Packer uses the "standard" Base64 alphabet
as defined in [RFC 4648 section 4](https://tools.ietf.org/html/rfc4648#section-4).

`privatekey` must be a PEM-encoded RSA private key that is not itself
encrypted.

Packer has no corresponding function for _encrypting_ a message. Use this
function to decrypt ciphertexts returned by remote services using a keypair
negotiated out-of-band.

## Examples

```
> rsadecrypt(base64(file("${path.folder}/ciphertext")), file("privatekey.pem"))
Hello, world!
```
