---
layout: "docs"
page_title: "timeadd - Functions - Configuration Language"
sidebar_current: "configuration-functions-datetime-timeadd"
description: |-
  The timeadd function adds a duration to a timestamp, returning a new
  timestamp.
---

# `timeadd` Function


`timeadd` adds a duration to a timestamp, returning a new timestamp.

```hcl
timeadd(timestamp, duration)
```

In the Packer language, timestamps are conventionally represented as
strings using [RFC 3339](https://tools.ietf.org/html/rfc3339)
"Date and Time format" syntax. `timeadd` requires the `timestamp` argument
to be a string conforming to this syntax.

`duration` is a string representation of a time difference, consisting of
sequences of number and unit pairs, like `"1.5h"` or `"1h30m"`. The accepted
units are `"ns"`, `"us"` (or `"µs"`), `"ms"`, `"s"`, `"m"`, and `"h"`. The first
number may be negative to indicate a negative duration, like `"-2h5m"`.

The result is a string, also in RFC 3339 format, representing the result
of adding the given direction to the given timestamp.

-> **Breaking change note:** Packer previously let you decide your own "Date
and Time format" syntax. With HCL2 and for parity with Terraform, Packer will
be using the [RFC 3339](https://tools.ietf.org/html/rfc3339) "Date and Time
format" syntax. As a string. [`formatdate`](./formatdate.html) still allows you
to format a date.

## Examples

```
> timeadd("2017-11-22T00:00:00Z", "10m")
2017-11-22T00:10:00Z
```
