---
layout: "docs"
page_title: "file - Functions - Configuration Language"
sidebar_current: "configuration-functions-file-file-x"
description: |-
  The file function reads the contents of the file at the given path and
  returns them as a string.
---

# `file` Function


`file` reads the contents of a file at the given path and returns them as
a string.

```hcl
file(path)
```

Strings in the Packer language are sequences of Unicode characters, so
this function will interpret the file contents as UTF-8 encoded text and
return the resulting Unicode characters. If the file contains invalid UTF-8
sequences then this function will produce an error.

This function can be used only with files that already exist on disk
at the beginning of a Packer run. Functions do not participate in the
dependency graph, so this function cannot be used with files that are generated
dynamically during a Packer operation. We do not recommend using dynamic
local files in Packer configurations, but in rare situations where this is
necessary you can use
[the `local_file` data source](/docs/providers/local/d/file.html)
to read files while respecting resource dependencies.

## Examples

```
> file("${path.folder}/hello.txt")
Hello World
```

## Related Functions

* [`fileexists`](./fileexists.html) determines whether a file exists
  at a given path.
