#!/usr/bin/env sh

set -ex

# pass test root directory from command line parameter
TEST_DIRECTORY_ROOT=$1
if [ -z "$TEST_DIRECTORY_ROOT" ]; then
  echo "[Error] parameter 1 - TEST_DIRECTORY_ROOT is missing."
  exit 1
fi
DIRECTORY_WITH_ACCESS="directoryWithAccess"
DIRECTORY_WITHOUT_ACCESS="directoryWithoutAccess"


#Create readable directory and populate with children
mkdir $TEST_DIRECTORY_ROOT
chmod 777 $TEST_DIRECTORY_ROOT
mkdir "$TEST_DIRECTORY_ROOT/$DIRECTORY_WITH_ACCESS"
mkdir "$TEST_DIRECTORY_ROOT/$DIRECTORY_WITH_ACCESS/directoryInDirectoryWithAccess"
cat <<EOF >$TEST_DIRECTORY_ROOT/$DIRECTORY_WITH_ACCESS/fileInDirectoryWithAccess
Hello world
EOF
#Create unreadable directory 
mkdir "$TEST_DIRECTORY_ROOT/$DIRECTORY_WITHOUT_ACCESS"
mkdir "$TEST_DIRECTORY_ROOT/$DIRECTORY_WITHOUT_ACCESS/directoryInDirectoryWithAccess"
touch "$TEST_DIRECTORY_ROOT/$DIRECTORY_WITHOUT_ACCESS/fileInDirectoryWithAccess"
chmod 700 "$TEST_DIRECTORY_ROOT/directoryWithoutAccess"

#Delete Test directory
DIRECTORY_DELETE_WITH_ACCESS="deleteTestDirectoryAccess"
DIRECTORY_DELETE_WITHOUT_ACCESS="deleteTestDirectoryWithoutAccess"

mkdir "$TEST_DIRECTORY_ROOT/$DIRECTORY_DELETE_WITH_ACCESS"
touch "$TEST_DIRECTORY_ROOT/$DIRECTORY_DELETE_WITH_ACCESS/deleteFileWithWritePermission"
mkdir "$TEST_DIRECTORY_ROOT/$DIRECTORY_DELETE_WITH_ACCESS/nestedDir"
mkdir "$TEST_DIRECTORY_ROOT/$DIRECTORY_DELETE_WITH_ACCESS/nestedDir/nestedDir2"
touch "$TEST_DIRECTORY_ROOT/$DIRECTORY_DELETE_WITH_ACCESS/nestedDir/nestedFile"
chmod -R 777 "$TEST_DIRECTORY_ROOT/$DIRECTORY_DELETE_WITH_ACCESS"
mkdir "$TEST_DIRECTORY_ROOT/$DIRECTORY_DELETE_WITHOUT_ACCESS"
touch "$TEST_DIRECTORY_ROOT/$DIRECTORY_DELETE_WITHOUT_ACCESS/deleteFileWithoutWritePermission"
chmod -R 555 "$TEST_DIRECTORY_ROOT/$DIRECTORY_DELETE_WITHOUT_ACCESS"

#Create readable file
cat <<EOF >$TEST_DIRECTORY_ROOT/fileWithAccess
Hello world
hello world on new line.
EOF

#Create readable ebcdic file
touch "$TEST_DIRECTORY_ROOT/fileWithAccessEbcdic"
chtag -t -c IBM-1047 "$TEST_DIRECTORY_ROOT/fileWithAccessEbcdic"
cat <<EOF >$TEST_DIRECTORY_ROOT/fileWithAccessEbcdic
Hello world
hello world on new line.
EOF

#Create readable ascii file
iconv -f IBM-1047 -t ISO8859-1 "$TEST_DIRECTORY_ROOT/fileWithAccessEbcdic" > "$TEST_DIRECTORY_ROOT/fileWithAccessAscii"
chtag -t -c ISO8859-1 "$TEST_DIRECTORY_ROOT/fileWithAccessAscii"

#Create unreadable file
cp "$TEST_DIRECTORY_ROOT/fileWithAccess" "$TEST_DIRECTORY_ROOT/fileWithoutAccess"
chmod 600 "$TEST_DIRECTORY_ROOT/fileWithoutAccess"

#Create editable files
touch "$TEST_DIRECTORY_ROOT/editableFile"
chtag -r "$TEST_DIRECTORY_ROOT/editableFile"
chmod a+w "$TEST_DIRECTORY_ROOT/editableFile"

touch "$TEST_DIRECTORY_ROOT/editableAsciiTaggedFile"
chtag -t -c ISO8859-1 "$TEST_DIRECTORY_ROOT/editableAsciiTaggedFile"
chmod a+w "$TEST_DIRECTORY_ROOT/editableAsciiTaggedFile"

touch "$TEST_DIRECTORY_ROOT/editableEbcdicTaggedFile"
chtag -t -c IBM-1047 "$TEST_DIRECTORY_ROOT/editableEbcdicTaggedFile"
chmod a+w "$TEST_DIRECTORY_ROOT/editableEbcdicTaggedFile"

touch "$TEST_DIRECTORY_ROOT/editableEbcdicFileUntaggedFile"
chtag -r "$TEST_DIRECTORY_ROOT/editableEbcdicFileUntaggedFile"
chmod a+w "$TEST_DIRECTORY_ROOT/editableEbcdicFileUntaggedFile"

#Create file and directory for post/create already exists error
touch "$TEST_DIRECTORY_ROOT/fileAlreadyExists"
mkdir "$TEST_DIRECTORY_ROOT/directoryAlreadyExists"

#create binaryExample
# create binaryExample
mkdir $TEST_DIRECTORY_ROOT/binaryExample

#Create binary c program
cat <<EOF >$TEST_DIRECTORY_ROOT/binaryExample/binaryProgram.c
#include <stdio.h>

int main() {
    /* Create the file */
    int x = 255;
    FILE *fh = fopen ("file.bin", "wb");
    if (fh != NULL) {
        fwrite (&x, sizeof (x), 1, fh);
        fclose (fh);
    }

    /* Read the file back in */
    x = 7;
    fh = fopen ("file.bin", "rb");
    if (fh != NULL) {
        fread (&x, sizeof (x), 1, fh);
        fclose (fh);
    }

    /* Check that it worked */
    printf ("Value is: %d\n", x);

    return 0;
}
EOF

#compile and run binary program c
cd $TEST_DIRECTORY_ROOT/binaryExample
cc binaryProgram.c
./a.out
cd $TEST_DIRECTORY_ROOT


ls -alT $TEST_DIRECTORY_ROOT