# KeyUI - Visualize and Customize Your Key Bindings

KeyUI is a powerful tool that allows you to visualize and customize your keyboard, mouse, and controller bindings directly within World of Warcraft. Whether you’re revisiting an old character, starting fresh, or optimizing your gameplay, KeyUI helps you manage and adjust your bindings with ease.

<div style="display: flex; align-items: center; gap: 10px;">
  <img src="https://i.imgur.com/5Fxy5QZ.jpeg" alt="Image 1" style="height: 300px; width: 67%; object-fit: cover;" />
  <img src="https://i.imgur.com/NDP7KZa.jpeg" alt="Image 2" style="height: 300px; width: 31%; object-fit: cover;" />
</div>
<div style="display: flex; justify-content: space-between; gap: 10px;">
  <img src="https://i.imgur.com/wqagq6z.jpeg" alt="Image 1" style="height: 151px; width: 24%; object-fit: cover;" />
  <img src="https://i.imgur.com/SuWPHWA.jpeg" alt="Image 2" style="height: 151px; width: 24%; object-fit: cover;" />
  <img src="https://i.imgur.com/U82rWJ8.jpeg" alt="Image 3" style="height: 151px; width: 24%; object-fit: cover;" />
  <img src="https://i.imgur.com/IMZWFkP.jpeg" alt="Image 4" style="height: 151px; width: 24%; object-fit: cover;" />
</div>

---

## Features at a Glance:

### **1. Multi-Device Support**  
- Display and customize key bindings for **Keyboards**, **Mice**, and **Controllers** (Xbox, PS4, PS5, and Steam Deck).

### **2. Pre-Made Layouts**  
- Access pre-designed layouts for popular keyboards, mice, and controllers.  
  - **Keyboards:** ISO, ANSI, DVORAK, Razer, Azeron.  
  - **Controllers:** Xbox, PS4, PS5, Steam Deck.

### **3. Easy Customization**  
- Edit individual keys and buttons to fit your personal setup.  
- Drag and drop spells directly onto your keys for flexible keybinding management.

### **4. Advanced Key Features**  
- **Highlight Unbound Keys:** Instantly identify keys with no bindings.

  <img src="https://i.imgur.com/teo57n6.jpeg" alt="Highlight Unbound Keys" style="width: 70%; object-fit: cover;" />

- **Show Interface Actions:** Clearly display what each key does.

  <img src="https://i.imgur.com/YqqUxcP.jpeg" alt="Show Interface Actions" style="width: 70%; object-fit: cover;" />

### **5. Context Menu for Easy Binding**  
- Right-click on keys to open a dropdown menu for direct spell and action bindings.

  <img src="https://i.imgur.com/A9QVLyw.jpeg" alt="Context Menu" style="width: 70%; object-fit: cover;" />

---

## Supported Addons:
KeyUI integrates seamlessly with popular addons, including:  
- **ElvUI**  
- **Bartender**  
- **Dominos**  
- **OPie**  
- **BindPad**  

---

## Keyboard and Controller Layouts:

### **Keyboard Pre-Made Layouts**  
- **ISO:** QWERTZ, AZERTY  
- **ANSI:** QWERTY  
- **DVORAK:** Standard, Right Hand, Left Hand  
- **Razer:** Tartarus v1, Tartarus v2  
- **Azeron:** Cyborg, Cyborg II  

### **Mouse Pre-Made Layouts**  
- Popular gaming mice from **Razer**, **Corsair**, **Logitech**, **Steelseries**, **EVGA**, **Redragon**, and **HyperX**.  

### **Controller Layouts**  
- Layouts for **Xbox**, **PS4**, **PS5**, and **Steam Deck** controllers.  

---

## How to Use KeyUI:
- **Open the Interface:** Type `/kui` or `/keyui` in the chat or click the minimap button.  
- **Choose Your Layout:** Select a Keyboard, Mouse, or Controller layout from the main menu.  

---

## FAQ:
**The addon is blank.**  
&nbsp;&nbsp;You need to select a layout first.

**The addon does not recognize my keyboard or mouse.**  
&nbsp;&nbsp;KeyUI cannot detect your specific hardware model.

**The addon layout does not display the keyboard layout for my region.**  
&nbsp;&nbsp;To accurately reflect your regional keyboard layout that isn’t covered by the pre-made layouts, you’ll need to customize it manually.

**The mouse frame displays the wrong mouse model.**  
&nbsp;&nbsp;The mouse frame is a generic image of a gaming mouse and does not adjust to your specific mouse model.

**Does it work with my keyboard or mouse software?**  
&nbsp;&nbsp;KeyUI does not interact with your operating system or any mouse driver software.
