// Code generated by protoc-gen-go-grpc. DO NOT EDIT.

package pb

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

// CoreRPCClient is the client API for CoreRPC service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type CoreRPCClient interface {
	Info(ctx context.Context, in *Empty, opts ...grpc.CallOption) (*CoreInfo, error)
	WatchServiceStatus(ctx context.Context, in *Empty, opts ...grpc.CallOption) (CoreRPC_WatchServiceStatusClient, error)
	ListNetworks(ctx context.Context, in *ListNetworkOptions, opts ...grpc.CallOption) (*Networks, error)
	ConnectNetwork(ctx context.Context, in *ConnectNetworkOptions, opts ...grpc.CallOption) (*Network, error)
	DisconnectNetwork(ctx context.Context, in *DisconnectNetworkOptions, opts ...grpc.CallOption) (*Empty, error)
	AddPod(ctx context.Context, in *AddPodOptions, opts ...grpc.CallOption) (*Pod, error)
	RemovePod(ctx context.Context, in *RemovePodOptions, opts ...grpc.CallOption) (*Empty, error)
	GetPod(ctx context.Context, in *GetPodOptions, opts ...grpc.CallOption) (*Pod, error)
	ListPods(ctx context.Context, in *Empty, opts ...grpc.CallOption) (*Pods, error)
	GetPodResource(ctx context.Context, in *GetPodOptions, opts ...grpc.CallOption) (*PodResource, error)
	AddNode(ctx context.Context, in *AddNodeOptions, opts ...grpc.CallOption) (*Node, error)
	RemoveNode(ctx context.Context, in *RemoveNodeOptions, opts ...grpc.CallOption) (*Empty, error)
	ListPodNodes(ctx context.Context, in *ListNodesOptions, opts ...grpc.CallOption) (*Nodes, error)
	GetNode(ctx context.Context, in *GetNodeOptions, opts ...grpc.CallOption) (*Node, error)
	SetNode(ctx context.Context, in *SetNodeOptions, opts ...grpc.CallOption) (*Node, error)
	SetNodeStatus(ctx context.Context, in *SetNodeStatusOptions, opts ...grpc.CallOption) (*Empty, error)
	GetNodeStatus(ctx context.Context, in *GetNodeStatusOptions, opts ...grpc.CallOption) (*NodeStatusStreamMessage, error)
	NodeStatusStream(ctx context.Context, in *Empty, opts ...grpc.CallOption) (CoreRPC_NodeStatusStreamClient, error)
	GetNodeResource(ctx context.Context, in *GetNodeResourceOptions, opts ...grpc.CallOption) (*NodeResource, error)
	CalculateCapacity(ctx context.Context, in *DeployOptions, opts ...grpc.CallOption) (*CapacityMessage, error)
	GetWorkload(ctx context.Context, in *WorkloadID, opts ...grpc.CallOption) (*Workload, error)
	GetWorkloads(ctx context.Context, in *WorkloadIDs, opts ...grpc.CallOption) (*Workloads, error)
	ListWorkloads(ctx context.Context, in *ListWorkloadsOptions, opts ...grpc.CallOption) (CoreRPC_ListWorkloadsClient, error)
	ListNodeWorkloads(ctx context.Context, in *GetNodeOptions, opts ...grpc.CallOption) (*Workloads, error)
	GetWorkloadsStatus(ctx context.Context, in *WorkloadIDs, opts ...grpc.CallOption) (*WorkloadsStatus, error)
	SetWorkloadsStatus(ctx context.Context, in *SetWorkloadsStatusOptions, opts ...grpc.CallOption) (*WorkloadsStatus, error)
	WorkloadStatusStream(ctx context.Context, in *WorkloadStatusStreamOptions, opts ...grpc.CallOption) (CoreRPC_WorkloadStatusStreamClient, error)
	Copy(ctx context.Context, in *CopyOptions, opts ...grpc.CallOption) (CoreRPC_CopyClient, error)
	Send(ctx context.Context, in *SendOptions, opts ...grpc.CallOption) (CoreRPC_SendClient, error)
	BuildImage(ctx context.Context, in *BuildImageOptions, opts ...grpc.CallOption) (CoreRPC_BuildImageClient, error)
	CacheImage(ctx context.Context, in *CacheImageOptions, opts ...grpc.CallOption) (CoreRPC_CacheImageClient, error)
	RemoveImage(ctx context.Context, in *RemoveImageOptions, opts ...grpc.CallOption) (CoreRPC_RemoveImageClient, error)
	CreateWorkload(ctx context.Context, in *DeployOptions, opts ...grpc.CallOption) (CoreRPC_CreateWorkloadClient, error)
	ReplaceWorkload(ctx context.Context, in *ReplaceOptions, opts ...grpc.CallOption) (CoreRPC_ReplaceWorkloadClient, error)
	RemoveWorkload(ctx context.Context, in *RemoveWorkloadOptions, opts ...grpc.CallOption) (CoreRPC_RemoveWorkloadClient, error)
	DissociateWorkload(ctx context.Context, in *DissociateWorkloadOptions, opts ...grpc.CallOption) (CoreRPC_DissociateWorkloadClient, error)
	ControlWorkload(ctx context.Context, in *ControlWorkloadOptions, opts ...grpc.CallOption) (CoreRPC_ControlWorkloadClient, error)
	ExecuteWorkload(ctx context.Context, opts ...grpc.CallOption) (CoreRPC_ExecuteWorkloadClient, error)
	ReallocResource(ctx context.Context, in *ReallocOptions, opts ...grpc.CallOption) (*ReallocResourceMessage, error)
	LogStream(ctx context.Context, in *LogStreamOptions, opts ...grpc.CallOption) (CoreRPC_LogStreamClient, error)
	RunAndWait(ctx context.Context, opts ...grpc.CallOption) (CoreRPC_RunAndWaitClient, error)
}

type coreRPCClient struct {
	cc grpc.ClientConnInterface
}

func NewCoreRPCClient(cc grpc.ClientConnInterface) CoreRPCClient {
	return &coreRPCClient{cc}
}

func (c *coreRPCClient) Info(ctx context.Context, in *Empty, opts ...grpc.CallOption) (*CoreInfo, error) {
	out := new(CoreInfo)
	err := c.cc.Invoke(ctx, "/pb.CoreRPC/Info", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *coreRPCClient) WatchServiceStatus(ctx context.Context, in *Empty, opts ...grpc.CallOption) (CoreRPC_WatchServiceStatusClient, error) {
	stream, err := c.cc.NewStream(ctx, &CoreRPC_ServiceDesc.Streams[0], "/pb.CoreRPC/WatchServiceStatus", opts...)
	if err != nil {
		return nil, err
	}
	x := &coreRPCWatchServiceStatusClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type CoreRPC_WatchServiceStatusClient interface {
	Recv() (*ServiceStatus, error)
	grpc.ClientStream
}

type coreRPCWatchServiceStatusClient struct {
	grpc.ClientStream
}

func (x *coreRPCWatchServiceStatusClient) Recv() (*ServiceStatus, error) {
	m := new(ServiceStatus)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *coreRPCClient) ListNetworks(ctx context.Context, in *ListNetworkOptions, opts ...grpc.CallOption) (*Networks, error) {
	out := new(Networks)
	err := c.cc.Invoke(ctx, "/pb.CoreRPC/ListNetworks", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *coreRPCClient) ConnectNetwork(ctx context.Context, in *ConnectNetworkOptions, opts ...grpc.CallOption) (*Network, error) {
	out := new(Network)
	err := c.cc.Invoke(ctx, "/pb.CoreRPC/ConnectNetwork", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *coreRPCClient) DisconnectNetwork(ctx context.Context, in *DisconnectNetworkOptions, opts ...grpc.CallOption) (*Empty, error) {
	out := new(Empty)
	err := c.cc.Invoke(ctx, "/pb.CoreRPC/DisconnectNetwork", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *coreRPCClient) AddPod(ctx context.Context, in *AddPodOptions, opts ...grpc.CallOption) (*Pod, error) {
	out := new(Pod)
	err := c.cc.Invoke(ctx, "/pb.CoreRPC/AddPod", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *coreRPCClient) RemovePod(ctx context.Context, in *RemovePodOptions, opts ...grpc.CallOption) (*Empty, error) {
	out := new(Empty)
	err := c.cc.Invoke(ctx, "/pb.CoreRPC/RemovePod", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *coreRPCClient) GetPod(ctx context.Context, in *GetPodOptions, opts ...grpc.CallOption) (*Pod, error) {
	out := new(Pod)
	err := c.cc.Invoke(ctx, "/pb.CoreRPC/GetPod", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *coreRPCClient) ListPods(ctx context.Context, in *Empty, opts ...grpc.CallOption) (*Pods, error) {
	out := new(Pods)
	err := c.cc.Invoke(ctx, "/pb.CoreRPC/ListPods", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *coreRPCClient) GetPodResource(ctx context.Context, in *GetPodOptions, opts ...grpc.CallOption) (*PodResource, error) {
	out := new(PodResource)
	err := c.cc.Invoke(ctx, "/pb.CoreRPC/GetPodResource", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *coreRPCClient) AddNode(ctx context.Context, in *AddNodeOptions, opts ...grpc.CallOption) (*Node, error) {
	out := new(Node)
	err := c.cc.Invoke(ctx, "/pb.CoreRPC/AddNode", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *coreRPCClient) RemoveNode(ctx context.Context, in *RemoveNodeOptions, opts ...grpc.CallOption) (*Empty, error) {
	out := new(Empty)
	err := c.cc.Invoke(ctx, "/pb.CoreRPC/RemoveNode", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *coreRPCClient) ListPodNodes(ctx context.Context, in *ListNodesOptions, opts ...grpc.CallOption) (*Nodes, error) {
	out := new(Nodes)
	err := c.cc.Invoke(ctx, "/pb.CoreRPC/ListPodNodes", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *coreRPCClient) GetNode(ctx context.Context, in *GetNodeOptions, opts ...grpc.CallOption) (*Node, error) {
	out := new(Node)
	err := c.cc.Invoke(ctx, "/pb.CoreRPC/GetNode", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *coreRPCClient) SetNode(ctx context.Context, in *SetNodeOptions, opts ...grpc.CallOption) (*Node, error) {
	out := new(Node)
	err := c.cc.Invoke(ctx, "/pb.CoreRPC/SetNode", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *coreRPCClient) SetNodeStatus(ctx context.Context, in *SetNodeStatusOptions, opts ...grpc.CallOption) (*Empty, error) {
	out := new(Empty)
	err := c.cc.Invoke(ctx, "/pb.CoreRPC/SetNodeStatus", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *coreRPCClient) GetNodeStatus(ctx context.Context, in *GetNodeStatusOptions, opts ...grpc.CallOption) (*NodeStatusStreamMessage, error) {
	out := new(NodeStatusStreamMessage)
	err := c.cc.Invoke(ctx, "/pb.CoreRPC/GetNodeStatus", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *coreRPCClient) NodeStatusStream(ctx context.Context, in *Empty, opts ...grpc.CallOption) (CoreRPC_NodeStatusStreamClient, error) {
	stream, err := c.cc.NewStream(ctx, &CoreRPC_ServiceDesc.Streams[1], "/pb.CoreRPC/NodeStatusStream", opts...)
	if err != nil {
		return nil, err
	}
	x := &coreRPCNodeStatusStreamClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type CoreRPC_NodeStatusStreamClient interface {
	Recv() (*NodeStatusStreamMessage, error)
	grpc.ClientStream
}

type coreRPCNodeStatusStreamClient struct {
	grpc.ClientStream
}

func (x *coreRPCNodeStatusStreamClient) Recv() (*NodeStatusStreamMessage, error) {
	m := new(NodeStatusStreamMessage)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *coreRPCClient) GetNodeResource(ctx context.Context, in *GetNodeResourceOptions, opts ...grpc.CallOption) (*NodeResource, error) {
	out := new(NodeResource)
	err := c.cc.Invoke(ctx, "/pb.CoreRPC/GetNodeResource", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *coreRPCClient) CalculateCapacity(ctx context.Context, in *DeployOptions, opts ...grpc.CallOption) (*CapacityMessage, error) {
	out := new(CapacityMessage)
	err := c.cc.Invoke(ctx, "/pb.CoreRPC/CalculateCapacity", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *coreRPCClient) GetWorkload(ctx context.Context, in *WorkloadID, opts ...grpc.CallOption) (*Workload, error) {
	out := new(Workload)
	err := c.cc.Invoke(ctx, "/pb.CoreRPC/GetWorkload", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *coreRPCClient) GetWorkloads(ctx context.Context, in *WorkloadIDs, opts ...grpc.CallOption) (*Workloads, error) {
	out := new(Workloads)
	err := c.cc.Invoke(ctx, "/pb.CoreRPC/GetWorkloads", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *coreRPCClient) ListWorkloads(ctx context.Context, in *ListWorkloadsOptions, opts ...grpc.CallOption) (CoreRPC_ListWorkloadsClient, error) {
	stream, err := c.cc.NewStream(ctx, &CoreRPC_ServiceDesc.Streams[2], "/pb.CoreRPC/ListWorkloads", opts...)
	if err != nil {
		return nil, err
	}
	x := &coreRPCListWorkloadsClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type CoreRPC_ListWorkloadsClient interface {
	Recv() (*Workload, error)
	grpc.ClientStream
}

type coreRPCListWorkloadsClient struct {
	grpc.ClientStream
}

func (x *coreRPCListWorkloadsClient) Recv() (*Workload, error) {
	m := new(Workload)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *coreRPCClient) ListNodeWorkloads(ctx context.Context, in *GetNodeOptions, opts ...grpc.CallOption) (*Workloads, error) {
	out := new(Workloads)
	err := c.cc.Invoke(ctx, "/pb.CoreRPC/ListNodeWorkloads", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *coreRPCClient) GetWorkloadsStatus(ctx context.Context, in *WorkloadIDs, opts ...grpc.CallOption) (*WorkloadsStatus, error) {
	out := new(WorkloadsStatus)
	err := c.cc.Invoke(ctx, "/pb.CoreRPC/GetWorkloadsStatus", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *coreRPCClient) SetWorkloadsStatus(ctx context.Context, in *SetWorkloadsStatusOptions, opts ...grpc.CallOption) (*WorkloadsStatus, error) {
	out := new(WorkloadsStatus)
	err := c.cc.Invoke(ctx, "/pb.CoreRPC/SetWorkloadsStatus", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *coreRPCClient) WorkloadStatusStream(ctx context.Context, in *WorkloadStatusStreamOptions, opts ...grpc.CallOption) (CoreRPC_WorkloadStatusStreamClient, error) {
	stream, err := c.cc.NewStream(ctx, &CoreRPC_ServiceDesc.Streams[3], "/pb.CoreRPC/WorkloadStatusStream", opts...)
	if err != nil {
		return nil, err
	}
	x := &coreRPCWorkloadStatusStreamClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type CoreRPC_WorkloadStatusStreamClient interface {
	Recv() (*WorkloadStatusStreamMessage, error)
	grpc.ClientStream
}

type coreRPCWorkloadStatusStreamClient struct {
	grpc.ClientStream
}

func (x *coreRPCWorkloadStatusStreamClient) Recv() (*WorkloadStatusStreamMessage, error) {
	m := new(WorkloadStatusStreamMessage)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *coreRPCClient) Copy(ctx context.Context, in *CopyOptions, opts ...grpc.CallOption) (CoreRPC_CopyClient, error) {
	stream, err := c.cc.NewStream(ctx, &CoreRPC_ServiceDesc.Streams[4], "/pb.CoreRPC/Copy", opts...)
	if err != nil {
		return nil, err
	}
	x := &coreRPCCopyClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type CoreRPC_CopyClient interface {
	Recv() (*CopyMessage, error)
	grpc.ClientStream
}

type coreRPCCopyClient struct {
	grpc.ClientStream
}

func (x *coreRPCCopyClient) Recv() (*CopyMessage, error) {
	m := new(CopyMessage)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *coreRPCClient) Send(ctx context.Context, in *SendOptions, opts ...grpc.CallOption) (CoreRPC_SendClient, error) {
	stream, err := c.cc.NewStream(ctx, &CoreRPC_ServiceDesc.Streams[5], "/pb.CoreRPC/Send", opts...)
	if err != nil {
		return nil, err
	}
	x := &coreRPCSendClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type CoreRPC_SendClient interface {
	Recv() (*SendMessage, error)
	grpc.ClientStream
}

type coreRPCSendClient struct {
	grpc.ClientStream
}

func (x *coreRPCSendClient) Recv() (*SendMessage, error) {
	m := new(SendMessage)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *coreRPCClient) BuildImage(ctx context.Context, in *BuildImageOptions, opts ...grpc.CallOption) (CoreRPC_BuildImageClient, error) {
	stream, err := c.cc.NewStream(ctx, &CoreRPC_ServiceDesc.Streams[6], "/pb.CoreRPC/BuildImage", opts...)
	if err != nil {
		return nil, err
	}
	x := &coreRPCBuildImageClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type CoreRPC_BuildImageClient interface {
	Recv() (*BuildImageMessage, error)
	grpc.ClientStream
}

type coreRPCBuildImageClient struct {
	grpc.ClientStream
}

func (x *coreRPCBuildImageClient) Recv() (*BuildImageMessage, error) {
	m := new(BuildImageMessage)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *coreRPCClient) CacheImage(ctx context.Context, in *CacheImageOptions, opts ...grpc.CallOption) (CoreRPC_CacheImageClient, error) {
	stream, err := c.cc.NewStream(ctx, &CoreRPC_ServiceDesc.Streams[7], "/pb.CoreRPC/CacheImage", opts...)
	if err != nil {
		return nil, err
	}
	x := &coreRPCCacheImageClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type CoreRPC_CacheImageClient interface {
	Recv() (*CacheImageMessage, error)
	grpc.ClientStream
}

type coreRPCCacheImageClient struct {
	grpc.ClientStream
}

func (x *coreRPCCacheImageClient) Recv() (*CacheImageMessage, error) {
	m := new(CacheImageMessage)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *coreRPCClient) RemoveImage(ctx context.Context, in *RemoveImageOptions, opts ...grpc.CallOption) (CoreRPC_RemoveImageClient, error) {
	stream, err := c.cc.NewStream(ctx, &CoreRPC_ServiceDesc.Streams[8], "/pb.CoreRPC/RemoveImage", opts...)
	if err != nil {
		return nil, err
	}
	x := &coreRPCRemoveImageClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type CoreRPC_RemoveImageClient interface {
	Recv() (*RemoveImageMessage, error)
	grpc.ClientStream
}

type coreRPCRemoveImageClient struct {
	grpc.ClientStream
}

func (x *coreRPCRemoveImageClient) Recv() (*RemoveImageMessage, error) {
	m := new(RemoveImageMessage)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *coreRPCClient) CreateWorkload(ctx context.Context, in *DeployOptions, opts ...grpc.CallOption) (CoreRPC_CreateWorkloadClient, error) {
	stream, err := c.cc.NewStream(ctx, &CoreRPC_ServiceDesc.Streams[9], "/pb.CoreRPC/CreateWorkload", opts...)
	if err != nil {
		return nil, err
	}
	x := &coreRPCCreateWorkloadClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type CoreRPC_CreateWorkloadClient interface {
	Recv() (*CreateWorkloadMessage, error)
	grpc.ClientStream
}

type coreRPCCreateWorkloadClient struct {
	grpc.ClientStream
}

func (x *coreRPCCreateWorkloadClient) Recv() (*CreateWorkloadMessage, error) {
	m := new(CreateWorkloadMessage)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *coreRPCClient) ReplaceWorkload(ctx context.Context, in *ReplaceOptions, opts ...grpc.CallOption) (CoreRPC_ReplaceWorkloadClient, error) {
	stream, err := c.cc.NewStream(ctx, &CoreRPC_ServiceDesc.Streams[10], "/pb.CoreRPC/ReplaceWorkload", opts...)
	if err != nil {
		return nil, err
	}
	x := &coreRPCReplaceWorkloadClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type CoreRPC_ReplaceWorkloadClient interface {
	Recv() (*ReplaceWorkloadMessage, error)
	grpc.ClientStream
}

type coreRPCReplaceWorkloadClient struct {
	grpc.ClientStream
}

func (x *coreRPCReplaceWorkloadClient) Recv() (*ReplaceWorkloadMessage, error) {
	m := new(ReplaceWorkloadMessage)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *coreRPCClient) RemoveWorkload(ctx context.Context, in *RemoveWorkloadOptions, opts ...grpc.CallOption) (CoreRPC_RemoveWorkloadClient, error) {
	stream, err := c.cc.NewStream(ctx, &CoreRPC_ServiceDesc.Streams[11], "/pb.CoreRPC/RemoveWorkload", opts...)
	if err != nil {
		return nil, err
	}
	x := &coreRPCRemoveWorkloadClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type CoreRPC_RemoveWorkloadClient interface {
	Recv() (*RemoveWorkloadMessage, error)
	grpc.ClientStream
}

type coreRPCRemoveWorkloadClient struct {
	grpc.ClientStream
}

func (x *coreRPCRemoveWorkloadClient) Recv() (*RemoveWorkloadMessage, error) {
	m := new(RemoveWorkloadMessage)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *coreRPCClient) DissociateWorkload(ctx context.Context, in *DissociateWorkloadOptions, opts ...grpc.CallOption) (CoreRPC_DissociateWorkloadClient, error) {
	stream, err := c.cc.NewStream(ctx, &CoreRPC_ServiceDesc.Streams[12], "/pb.CoreRPC/DissociateWorkload", opts...)
	if err != nil {
		return nil, err
	}
	x := &coreRPCDissociateWorkloadClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type CoreRPC_DissociateWorkloadClient interface {
	Recv() (*DissociateWorkloadMessage, error)
	grpc.ClientStream
}

type coreRPCDissociateWorkloadClient struct {
	grpc.ClientStream
}

func (x *coreRPCDissociateWorkloadClient) Recv() (*DissociateWorkloadMessage, error) {
	m := new(DissociateWorkloadMessage)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *coreRPCClient) ControlWorkload(ctx context.Context, in *ControlWorkloadOptions, opts ...grpc.CallOption) (CoreRPC_ControlWorkloadClient, error) {
	stream, err := c.cc.NewStream(ctx, &CoreRPC_ServiceDesc.Streams[13], "/pb.CoreRPC/ControlWorkload", opts...)
	if err != nil {
		return nil, err
	}
	x := &coreRPCControlWorkloadClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type CoreRPC_ControlWorkloadClient interface {
	Recv() (*ControlWorkloadMessage, error)
	grpc.ClientStream
}

type coreRPCControlWorkloadClient struct {
	grpc.ClientStream
}

func (x *coreRPCControlWorkloadClient) Recv() (*ControlWorkloadMessage, error) {
	m := new(ControlWorkloadMessage)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *coreRPCClient) ExecuteWorkload(ctx context.Context, opts ...grpc.CallOption) (CoreRPC_ExecuteWorkloadClient, error) {
	stream, err := c.cc.NewStream(ctx, &CoreRPC_ServiceDesc.Streams[14], "/pb.CoreRPC/ExecuteWorkload", opts...)
	if err != nil {
		return nil, err
	}
	x := &coreRPCExecuteWorkloadClient{stream}
	return x, nil
}

type CoreRPC_ExecuteWorkloadClient interface {
	Send(*ExecuteWorkloadOptions) error
	Recv() (*AttachWorkloadMessage, error)
	grpc.ClientStream
}

type coreRPCExecuteWorkloadClient struct {
	grpc.ClientStream
}

func (x *coreRPCExecuteWorkloadClient) Send(m *ExecuteWorkloadOptions) error {
	return x.ClientStream.SendMsg(m)
}

func (x *coreRPCExecuteWorkloadClient) Recv() (*AttachWorkloadMessage, error) {
	m := new(AttachWorkloadMessage)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *coreRPCClient) ReallocResource(ctx context.Context, in *ReallocOptions, opts ...grpc.CallOption) (*ReallocResourceMessage, error) {
	out := new(ReallocResourceMessage)
	err := c.cc.Invoke(ctx, "/pb.CoreRPC/ReallocResource", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *coreRPCClient) LogStream(ctx context.Context, in *LogStreamOptions, opts ...grpc.CallOption) (CoreRPC_LogStreamClient, error) {
	stream, err := c.cc.NewStream(ctx, &CoreRPC_ServiceDesc.Streams[15], "/pb.CoreRPC/LogStream", opts...)
	if err != nil {
		return nil, err
	}
	x := &coreRPCLogStreamClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type CoreRPC_LogStreamClient interface {
	Recv() (*LogStreamMessage, error)
	grpc.ClientStream
}

type coreRPCLogStreamClient struct {
	grpc.ClientStream
}

func (x *coreRPCLogStreamClient) Recv() (*LogStreamMessage, error) {
	m := new(LogStreamMessage)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *coreRPCClient) RunAndWait(ctx context.Context, opts ...grpc.CallOption) (CoreRPC_RunAndWaitClient, error) {
	stream, err := c.cc.NewStream(ctx, &CoreRPC_ServiceDesc.Streams[16], "/pb.CoreRPC/RunAndWait", opts...)
	if err != nil {
		return nil, err
	}
	x := &coreRPCRunAndWaitClient{stream}
	return x, nil
}

type CoreRPC_RunAndWaitClient interface {
	Send(*RunAndWaitOptions) error
	Recv() (*AttachWorkloadMessage, error)
	grpc.ClientStream
}

type coreRPCRunAndWaitClient struct {
	grpc.ClientStream
}

func (x *coreRPCRunAndWaitClient) Send(m *RunAndWaitOptions) error {
	return x.ClientStream.SendMsg(m)
}

func (x *coreRPCRunAndWaitClient) Recv() (*AttachWorkloadMessage, error) {
	m := new(AttachWorkloadMessage)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// CoreRPCServer is the server API for CoreRPC service.
// All implementations should embed UnimplementedCoreRPCServer
// for forward compatibility
type CoreRPCServer interface {
	Info(context.Context, *Empty) (*CoreInfo, error)
	WatchServiceStatus(*Empty, CoreRPC_WatchServiceStatusServer) error
	ListNetworks(context.Context, *ListNetworkOptions) (*Networks, error)
	ConnectNetwork(context.Context, *ConnectNetworkOptions) (*Network, error)
	DisconnectNetwork(context.Context, *DisconnectNetworkOptions) (*Empty, error)
	AddPod(context.Context, *AddPodOptions) (*Pod, error)
	RemovePod(context.Context, *RemovePodOptions) (*Empty, error)
	GetPod(context.Context, *GetPodOptions) (*Pod, error)
	ListPods(context.Context, *Empty) (*Pods, error)
	GetPodResource(context.Context, *GetPodOptions) (*PodResource, error)
	AddNode(context.Context, *AddNodeOptions) (*Node, error)
	RemoveNode(context.Context, *RemoveNodeOptions) (*Empty, error)
	ListPodNodes(context.Context, *ListNodesOptions) (*Nodes, error)
	GetNode(context.Context, *GetNodeOptions) (*Node, error)
	SetNode(context.Context, *SetNodeOptions) (*Node, error)
	SetNodeStatus(context.Context, *SetNodeStatusOptions) (*Empty, error)
	GetNodeStatus(context.Context, *GetNodeStatusOptions) (*NodeStatusStreamMessage, error)
	NodeStatusStream(*Empty, CoreRPC_NodeStatusStreamServer) error
	GetNodeResource(context.Context, *GetNodeResourceOptions) (*NodeResource, error)
	CalculateCapacity(context.Context, *DeployOptions) (*CapacityMessage, error)
	GetWorkload(context.Context, *WorkloadID) (*Workload, error)
	GetWorkloads(context.Context, *WorkloadIDs) (*Workloads, error)
	ListWorkloads(*ListWorkloadsOptions, CoreRPC_ListWorkloadsServer) error
	ListNodeWorkloads(context.Context, *GetNodeOptions) (*Workloads, error)
	GetWorkloadsStatus(context.Context, *WorkloadIDs) (*WorkloadsStatus, error)
	SetWorkloadsStatus(context.Context, *SetWorkloadsStatusOptions) (*WorkloadsStatus, error)
	WorkloadStatusStream(*WorkloadStatusStreamOptions, CoreRPC_WorkloadStatusStreamServer) error
	Copy(*CopyOptions, CoreRPC_CopyServer) error
	Send(*SendOptions, CoreRPC_SendServer) error
	BuildImage(*BuildImageOptions, CoreRPC_BuildImageServer) error
	CacheImage(*CacheImageOptions, CoreRPC_CacheImageServer) error
	RemoveImage(*RemoveImageOptions, CoreRPC_RemoveImageServer) error
	CreateWorkload(*DeployOptions, CoreRPC_CreateWorkloadServer) error
	ReplaceWorkload(*ReplaceOptions, CoreRPC_ReplaceWorkloadServer) error
	RemoveWorkload(*RemoveWorkloadOptions, CoreRPC_RemoveWorkloadServer) error
	DissociateWorkload(*DissociateWorkloadOptions, CoreRPC_DissociateWorkloadServer) error
	ControlWorkload(*ControlWorkloadOptions, CoreRPC_ControlWorkloadServer) error
	ExecuteWorkload(CoreRPC_ExecuteWorkloadServer) error
	ReallocResource(context.Context, *ReallocOptions) (*ReallocResourceMessage, error)
	LogStream(*LogStreamOptions, CoreRPC_LogStreamServer) error
	RunAndWait(CoreRPC_RunAndWaitServer) error
}

// UnimplementedCoreRPCServer should be embedded to have forward compatible implementations.
type UnimplementedCoreRPCServer struct {
}

func (UnimplementedCoreRPCServer) Info(context.Context, *Empty) (*CoreInfo, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Info not implemented")
}
func (UnimplementedCoreRPCServer) WatchServiceStatus(*Empty, CoreRPC_WatchServiceStatusServer) error {
	return status.Errorf(codes.Unimplemented, "method WatchServiceStatus not implemented")
}
func (UnimplementedCoreRPCServer) ListNetworks(context.Context, *ListNetworkOptions) (*Networks, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListNetworks not implemented")
}
func (UnimplementedCoreRPCServer) ConnectNetwork(context.Context, *ConnectNetworkOptions) (*Network, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ConnectNetwork not implemented")
}
func (UnimplementedCoreRPCServer) DisconnectNetwork(context.Context, *DisconnectNetworkOptions) (*Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DisconnectNetwork not implemented")
}
func (UnimplementedCoreRPCServer) AddPod(context.Context, *AddPodOptions) (*Pod, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AddPod not implemented")
}
func (UnimplementedCoreRPCServer) RemovePod(context.Context, *RemovePodOptions) (*Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RemovePod not implemented")
}
func (UnimplementedCoreRPCServer) GetPod(context.Context, *GetPodOptions) (*Pod, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetPod not implemented")
}
func (UnimplementedCoreRPCServer) ListPods(context.Context, *Empty) (*Pods, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListPods not implemented")
}
func (UnimplementedCoreRPCServer) GetPodResource(context.Context, *GetPodOptions) (*PodResource, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetPodResource not implemented")
}
func (UnimplementedCoreRPCServer) AddNode(context.Context, *AddNodeOptions) (*Node, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AddNode not implemented")
}
func (UnimplementedCoreRPCServer) RemoveNode(context.Context, *RemoveNodeOptions) (*Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RemoveNode not implemented")
}
func (UnimplementedCoreRPCServer) ListPodNodes(context.Context, *ListNodesOptions) (*Nodes, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListPodNodes not implemented")
}
func (UnimplementedCoreRPCServer) GetNode(context.Context, *GetNodeOptions) (*Node, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetNode not implemented")
}
func (UnimplementedCoreRPCServer) SetNode(context.Context, *SetNodeOptions) (*Node, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetNode not implemented")
}
func (UnimplementedCoreRPCServer) SetNodeStatus(context.Context, *SetNodeStatusOptions) (*Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetNodeStatus not implemented")
}
func (UnimplementedCoreRPCServer) GetNodeStatus(context.Context, *GetNodeStatusOptions) (*NodeStatusStreamMessage, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetNodeStatus not implemented")
}
func (UnimplementedCoreRPCServer) NodeStatusStream(*Empty, CoreRPC_NodeStatusStreamServer) error {
	return status.Errorf(codes.Unimplemented, "method NodeStatusStream not implemented")
}
func (UnimplementedCoreRPCServer) GetNodeResource(context.Context, *GetNodeResourceOptions) (*NodeResource, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetNodeResource not implemented")
}
func (UnimplementedCoreRPCServer) CalculateCapacity(context.Context, *DeployOptions) (*CapacityMessage, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CalculateCapacity not implemented")
}
func (UnimplementedCoreRPCServer) GetWorkload(context.Context, *WorkloadID) (*Workload, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetWorkload not implemented")
}
func (UnimplementedCoreRPCServer) GetWorkloads(context.Context, *WorkloadIDs) (*Workloads, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetWorkloads not implemented")
}
func (UnimplementedCoreRPCServer) ListWorkloads(*ListWorkloadsOptions, CoreRPC_ListWorkloadsServer) error {
	return status.Errorf(codes.Unimplemented, "method ListWorkloads not implemented")
}
func (UnimplementedCoreRPCServer) ListNodeWorkloads(context.Context, *GetNodeOptions) (*Workloads, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListNodeWorkloads not implemented")
}
func (UnimplementedCoreRPCServer) GetWorkloadsStatus(context.Context, *WorkloadIDs) (*WorkloadsStatus, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetWorkloadsStatus not implemented")
}
func (UnimplementedCoreRPCServer) SetWorkloadsStatus(context.Context, *SetWorkloadsStatusOptions) (*WorkloadsStatus, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetWorkloadsStatus not implemented")
}
func (UnimplementedCoreRPCServer) WorkloadStatusStream(*WorkloadStatusStreamOptions, CoreRPC_WorkloadStatusStreamServer) error {
	return status.Errorf(codes.Unimplemented, "method WorkloadStatusStream not implemented")
}
func (UnimplementedCoreRPCServer) Copy(*CopyOptions, CoreRPC_CopyServer) error {
	return status.Errorf(codes.Unimplemented, "method Copy not implemented")
}
func (UnimplementedCoreRPCServer) Send(*SendOptions, CoreRPC_SendServer) error {
	return status.Errorf(codes.Unimplemented, "method Send not implemented")
}
func (UnimplementedCoreRPCServer) BuildImage(*BuildImageOptions, CoreRPC_BuildImageServer) error {
	return status.Errorf(codes.Unimplemented, "method BuildImage not implemented")
}
func (UnimplementedCoreRPCServer) CacheImage(*CacheImageOptions, CoreRPC_CacheImageServer) error {
	return status.Errorf(codes.Unimplemented, "method CacheImage not implemented")
}
func (UnimplementedCoreRPCServer) RemoveImage(*RemoveImageOptions, CoreRPC_RemoveImageServer) error {
	return status.Errorf(codes.Unimplemented, "method RemoveImage not implemented")
}
func (UnimplementedCoreRPCServer) CreateWorkload(*DeployOptions, CoreRPC_CreateWorkloadServer) error {
	return status.Errorf(codes.Unimplemented, "method CreateWorkload not implemented")
}
func (UnimplementedCoreRPCServer) ReplaceWorkload(*ReplaceOptions, CoreRPC_ReplaceWorkloadServer) error {
	return status.Errorf(codes.Unimplemented, "method ReplaceWorkload not implemented")
}
func (UnimplementedCoreRPCServer) RemoveWorkload(*RemoveWorkloadOptions, CoreRPC_RemoveWorkloadServer) error {
	return status.Errorf(codes.Unimplemented, "method RemoveWorkload not implemented")
}
func (UnimplementedCoreRPCServer) DissociateWorkload(*DissociateWorkloadOptions, CoreRPC_DissociateWorkloadServer) error {
	return status.Errorf(codes.Unimplemented, "method DissociateWorkload not implemented")
}
func (UnimplementedCoreRPCServer) ControlWorkload(*ControlWorkloadOptions, CoreRPC_ControlWorkloadServer) error {
	return status.Errorf(codes.Unimplemented, "method ControlWorkload not implemented")
}
func (UnimplementedCoreRPCServer) ExecuteWorkload(CoreRPC_ExecuteWorkloadServer) error {
	return status.Errorf(codes.Unimplemented, "method ExecuteWorkload not implemented")
}
func (UnimplementedCoreRPCServer) ReallocResource(context.Context, *ReallocOptions) (*ReallocResourceMessage, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ReallocResource not implemented")
}
func (UnimplementedCoreRPCServer) LogStream(*LogStreamOptions, CoreRPC_LogStreamServer) error {
	return status.Errorf(codes.Unimplemented, "method LogStream not implemented")
}
func (UnimplementedCoreRPCServer) RunAndWait(CoreRPC_RunAndWaitServer) error {
	return status.Errorf(codes.Unimplemented, "method RunAndWait not implemented")
}

// UnsafeCoreRPCServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to CoreRPCServer will
// result in compilation errors.
type UnsafeCoreRPCServer interface {
	mustEmbedUnimplementedCoreRPCServer()
}

func RegisterCoreRPCServer(s grpc.ServiceRegistrar, srv CoreRPCServer) {
	s.RegisterService(&CoreRPC_ServiceDesc, srv)
}

func _CoreRPC_Info_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CoreRPCServer).Info(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/pb.CoreRPC/Info",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CoreRPCServer).Info(ctx, req.(*Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _CoreRPC_WatchServiceStatus_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(Empty)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(CoreRPCServer).WatchServiceStatus(m, &coreRPCWatchServiceStatusServer{stream})
}

type CoreRPC_WatchServiceStatusServer interface {
	Send(*ServiceStatus) error
	grpc.ServerStream
}

type coreRPCWatchServiceStatusServer struct {
	grpc.ServerStream
}

func (x *coreRPCWatchServiceStatusServer) Send(m *ServiceStatus) error {
	return x.ServerStream.SendMsg(m)
}

func _CoreRPC_ListNetworks_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListNetworkOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CoreRPCServer).ListNetworks(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/pb.CoreRPC/ListNetworks",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CoreRPCServer).ListNetworks(ctx, req.(*ListNetworkOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _CoreRPC_ConnectNetwork_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ConnectNetworkOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CoreRPCServer).ConnectNetwork(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/pb.CoreRPC/ConnectNetwork",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CoreRPCServer).ConnectNetwork(ctx, req.(*ConnectNetworkOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _CoreRPC_DisconnectNetwork_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DisconnectNetworkOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CoreRPCServer).DisconnectNetwork(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/pb.CoreRPC/DisconnectNetwork",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CoreRPCServer).DisconnectNetwork(ctx, req.(*DisconnectNetworkOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _CoreRPC_AddPod_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AddPodOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CoreRPCServer).AddPod(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/pb.CoreRPC/AddPod",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CoreRPCServer).AddPod(ctx, req.(*AddPodOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _CoreRPC_RemovePod_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RemovePodOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CoreRPCServer).RemovePod(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/pb.CoreRPC/RemovePod",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CoreRPCServer).RemovePod(ctx, req.(*RemovePodOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _CoreRPC_GetPod_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetPodOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CoreRPCServer).GetPod(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/pb.CoreRPC/GetPod",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CoreRPCServer).GetPod(ctx, req.(*GetPodOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _CoreRPC_ListPods_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CoreRPCServer).ListPods(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/pb.CoreRPC/ListPods",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CoreRPCServer).ListPods(ctx, req.(*Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _CoreRPC_GetPodResource_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetPodOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CoreRPCServer).GetPodResource(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/pb.CoreRPC/GetPodResource",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CoreRPCServer).GetPodResource(ctx, req.(*GetPodOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _CoreRPC_AddNode_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AddNodeOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CoreRPCServer).AddNode(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/pb.CoreRPC/AddNode",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CoreRPCServer).AddNode(ctx, req.(*AddNodeOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _CoreRPC_RemoveNode_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RemoveNodeOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CoreRPCServer).RemoveNode(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/pb.CoreRPC/RemoveNode",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CoreRPCServer).RemoveNode(ctx, req.(*RemoveNodeOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _CoreRPC_ListPodNodes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListNodesOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CoreRPCServer).ListPodNodes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/pb.CoreRPC/ListPodNodes",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CoreRPCServer).ListPodNodes(ctx, req.(*ListNodesOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _CoreRPC_GetNode_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetNodeOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CoreRPCServer).GetNode(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/pb.CoreRPC/GetNode",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CoreRPCServer).GetNode(ctx, req.(*GetNodeOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _CoreRPC_SetNode_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetNodeOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CoreRPCServer).SetNode(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/pb.CoreRPC/SetNode",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CoreRPCServer).SetNode(ctx, req.(*SetNodeOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _CoreRPC_SetNodeStatus_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetNodeStatusOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CoreRPCServer).SetNodeStatus(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/pb.CoreRPC/SetNodeStatus",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CoreRPCServer).SetNodeStatus(ctx, req.(*SetNodeStatusOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _CoreRPC_GetNodeStatus_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetNodeStatusOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CoreRPCServer).GetNodeStatus(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/pb.CoreRPC/GetNodeStatus",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CoreRPCServer).GetNodeStatus(ctx, req.(*GetNodeStatusOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _CoreRPC_NodeStatusStream_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(Empty)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(CoreRPCServer).NodeStatusStream(m, &coreRPCNodeStatusStreamServer{stream})
}

type CoreRPC_NodeStatusStreamServer interface {
	Send(*NodeStatusStreamMessage) error
	grpc.ServerStream
}

type coreRPCNodeStatusStreamServer struct {
	grpc.ServerStream
}

func (x *coreRPCNodeStatusStreamServer) Send(m *NodeStatusStreamMessage) error {
	return x.ServerStream.SendMsg(m)
}

func _CoreRPC_GetNodeResource_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetNodeResourceOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CoreRPCServer).GetNodeResource(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/pb.CoreRPC/GetNodeResource",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CoreRPCServer).GetNodeResource(ctx, req.(*GetNodeResourceOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _CoreRPC_CalculateCapacity_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeployOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CoreRPCServer).CalculateCapacity(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/pb.CoreRPC/CalculateCapacity",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CoreRPCServer).CalculateCapacity(ctx, req.(*DeployOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _CoreRPC_GetWorkload_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(WorkloadID)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CoreRPCServer).GetWorkload(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/pb.CoreRPC/GetWorkload",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CoreRPCServer).GetWorkload(ctx, req.(*WorkloadID))
	}
	return interceptor(ctx, in, info, handler)
}

func _CoreRPC_GetWorkloads_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(WorkloadIDs)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CoreRPCServer).GetWorkloads(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/pb.CoreRPC/GetWorkloads",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CoreRPCServer).GetWorkloads(ctx, req.(*WorkloadIDs))
	}
	return interceptor(ctx, in, info, handler)
}

func _CoreRPC_ListWorkloads_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(ListWorkloadsOptions)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(CoreRPCServer).ListWorkloads(m, &coreRPCListWorkloadsServer{stream})
}

type CoreRPC_ListWorkloadsServer interface {
	Send(*Workload) error
	grpc.ServerStream
}

type coreRPCListWorkloadsServer struct {
	grpc.ServerStream
}

func (x *coreRPCListWorkloadsServer) Send(m *Workload) error {
	return x.ServerStream.SendMsg(m)
}

func _CoreRPC_ListNodeWorkloads_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetNodeOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CoreRPCServer).ListNodeWorkloads(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/pb.CoreRPC/ListNodeWorkloads",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CoreRPCServer).ListNodeWorkloads(ctx, req.(*GetNodeOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _CoreRPC_GetWorkloadsStatus_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(WorkloadIDs)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CoreRPCServer).GetWorkloadsStatus(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/pb.CoreRPC/GetWorkloadsStatus",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CoreRPCServer).GetWorkloadsStatus(ctx, req.(*WorkloadIDs))
	}
	return interceptor(ctx, in, info, handler)
}

func _CoreRPC_SetWorkloadsStatus_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetWorkloadsStatusOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CoreRPCServer).SetWorkloadsStatus(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/pb.CoreRPC/SetWorkloadsStatus",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CoreRPCServer).SetWorkloadsStatus(ctx, req.(*SetWorkloadsStatusOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _CoreRPC_WorkloadStatusStream_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(WorkloadStatusStreamOptions)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(CoreRPCServer).WorkloadStatusStream(m, &coreRPCWorkloadStatusStreamServer{stream})
}

type CoreRPC_WorkloadStatusStreamServer interface {
	Send(*WorkloadStatusStreamMessage) error
	grpc.ServerStream
}

type coreRPCWorkloadStatusStreamServer struct {
	grpc.ServerStream
}

func (x *coreRPCWorkloadStatusStreamServer) Send(m *WorkloadStatusStreamMessage) error {
	return x.ServerStream.SendMsg(m)
}

func _CoreRPC_Copy_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(CopyOptions)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(CoreRPCServer).Copy(m, &coreRPCCopyServer{stream})
}

type CoreRPC_CopyServer interface {
	Send(*CopyMessage) error
	grpc.ServerStream
}

type coreRPCCopyServer struct {
	grpc.ServerStream
}

func (x *coreRPCCopyServer) Send(m *CopyMessage) error {
	return x.ServerStream.SendMsg(m)
}

func _CoreRPC_Send_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(SendOptions)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(CoreRPCServer).Send(m, &coreRPCSendServer{stream})
}

type CoreRPC_SendServer interface {
	Send(*SendMessage) error
	grpc.ServerStream
}

type coreRPCSendServer struct {
	grpc.ServerStream
}

func (x *coreRPCSendServer) Send(m *SendMessage) error {
	return x.ServerStream.SendMsg(m)
}

func _CoreRPC_BuildImage_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(BuildImageOptions)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(CoreRPCServer).BuildImage(m, &coreRPCBuildImageServer{stream})
}

type CoreRPC_BuildImageServer interface {
	Send(*BuildImageMessage) error
	grpc.ServerStream
}

type coreRPCBuildImageServer struct {
	grpc.ServerStream
}

func (x *coreRPCBuildImageServer) Send(m *BuildImageMessage) error {
	return x.ServerStream.SendMsg(m)
}

func _CoreRPC_CacheImage_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(CacheImageOptions)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(CoreRPCServer).CacheImage(m, &coreRPCCacheImageServer{stream})
}

type CoreRPC_CacheImageServer interface {
	Send(*CacheImageMessage) error
	grpc.ServerStream
}

type coreRPCCacheImageServer struct {
	grpc.ServerStream
}

func (x *coreRPCCacheImageServer) Send(m *CacheImageMessage) error {
	return x.ServerStream.SendMsg(m)
}

func _CoreRPC_RemoveImage_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(RemoveImageOptions)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(CoreRPCServer).RemoveImage(m, &coreRPCRemoveImageServer{stream})
}

type CoreRPC_RemoveImageServer interface {
	Send(*RemoveImageMessage) error
	grpc.ServerStream
}

type coreRPCRemoveImageServer struct {
	grpc.ServerStream
}

func (x *coreRPCRemoveImageServer) Send(m *RemoveImageMessage) error {
	return x.ServerStream.SendMsg(m)
}

func _CoreRPC_CreateWorkload_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(DeployOptions)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(CoreRPCServer).CreateWorkload(m, &coreRPCCreateWorkloadServer{stream})
}

type CoreRPC_CreateWorkloadServer interface {
	Send(*CreateWorkloadMessage) error
	grpc.ServerStream
}

type coreRPCCreateWorkloadServer struct {
	grpc.ServerStream
}

func (x *coreRPCCreateWorkloadServer) Send(m *CreateWorkloadMessage) error {
	return x.ServerStream.SendMsg(m)
}

func _CoreRPC_ReplaceWorkload_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(ReplaceOptions)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(CoreRPCServer).ReplaceWorkload(m, &coreRPCReplaceWorkloadServer{stream})
}

type CoreRPC_ReplaceWorkloadServer interface {
	Send(*ReplaceWorkloadMessage) error
	grpc.ServerStream
}

type coreRPCReplaceWorkloadServer struct {
	grpc.ServerStream
}

func (x *coreRPCReplaceWorkloadServer) Send(m *ReplaceWorkloadMessage) error {
	return x.ServerStream.SendMsg(m)
}

func _CoreRPC_RemoveWorkload_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(RemoveWorkloadOptions)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(CoreRPCServer).RemoveWorkload(m, &coreRPCRemoveWorkloadServer{stream})
}

type CoreRPC_RemoveWorkloadServer interface {
	Send(*RemoveWorkloadMessage) error
	grpc.ServerStream
}

type coreRPCRemoveWorkloadServer struct {
	grpc.ServerStream
}

func (x *coreRPCRemoveWorkloadServer) Send(m *RemoveWorkloadMessage) error {
	return x.ServerStream.SendMsg(m)
}

func _CoreRPC_DissociateWorkload_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(DissociateWorkloadOptions)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(CoreRPCServer).DissociateWorkload(m, &coreRPCDissociateWorkloadServer{stream})
}

type CoreRPC_DissociateWorkloadServer interface {
	Send(*DissociateWorkloadMessage) error
	grpc.ServerStream
}

type coreRPCDissociateWorkloadServer struct {
	grpc.ServerStream
}

func (x *coreRPCDissociateWorkloadServer) Send(m *DissociateWorkloadMessage) error {
	return x.ServerStream.SendMsg(m)
}

func _CoreRPC_ControlWorkload_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(ControlWorkloadOptions)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(CoreRPCServer).ControlWorkload(m, &coreRPCControlWorkloadServer{stream})
}

type CoreRPC_ControlWorkloadServer interface {
	Send(*ControlWorkloadMessage) error
	grpc.ServerStream
}

type coreRPCControlWorkloadServer struct {
	grpc.ServerStream
}

func (x *coreRPCControlWorkloadServer) Send(m *ControlWorkloadMessage) error {
	return x.ServerStream.SendMsg(m)
}

func _CoreRPC_ExecuteWorkload_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(CoreRPCServer).ExecuteWorkload(&coreRPCExecuteWorkloadServer{stream})
}

type CoreRPC_ExecuteWorkloadServer interface {
	Send(*AttachWorkloadMessage) error
	Recv() (*ExecuteWorkloadOptions, error)
	grpc.ServerStream
}

type coreRPCExecuteWorkloadServer struct {
	grpc.ServerStream
}

func (x *coreRPCExecuteWorkloadServer) Send(m *AttachWorkloadMessage) error {
	return x.ServerStream.SendMsg(m)
}

func (x *coreRPCExecuteWorkloadServer) Recv() (*ExecuteWorkloadOptions, error) {
	m := new(ExecuteWorkloadOptions)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func _CoreRPC_ReallocResource_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ReallocOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CoreRPCServer).ReallocResource(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/pb.CoreRPC/ReallocResource",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CoreRPCServer).ReallocResource(ctx, req.(*ReallocOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _CoreRPC_LogStream_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(LogStreamOptions)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(CoreRPCServer).LogStream(m, &coreRPCLogStreamServer{stream})
}

type CoreRPC_LogStreamServer interface {
	Send(*LogStreamMessage) error
	grpc.ServerStream
}

type coreRPCLogStreamServer struct {
	grpc.ServerStream
}

func (x *coreRPCLogStreamServer) Send(m *LogStreamMessage) error {
	return x.ServerStream.SendMsg(m)
}

func _CoreRPC_RunAndWait_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(CoreRPCServer).RunAndWait(&coreRPCRunAndWaitServer{stream})
}

type CoreRPC_RunAndWaitServer interface {
	Send(*AttachWorkloadMessage) error
	Recv() (*RunAndWaitOptions, error)
	grpc.ServerStream
}

type coreRPCRunAndWaitServer struct {
	grpc.ServerStream
}

func (x *coreRPCRunAndWaitServer) Send(m *AttachWorkloadMessage) error {
	return x.ServerStream.SendMsg(m)
}

func (x *coreRPCRunAndWaitServer) Recv() (*RunAndWaitOptions, error) {
	m := new(RunAndWaitOptions)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// CoreRPC_ServiceDesc is the grpc.ServiceDesc for CoreRPC service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var CoreRPC_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "pb.CoreRPC",
	HandlerType: (*CoreRPCServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Info",
			Handler:    _CoreRPC_Info_Handler,
		},
		{
			MethodName: "ListNetworks",
			Handler:    _CoreRPC_ListNetworks_Handler,
		},
		{
			MethodName: "ConnectNetwork",
			Handler:    _CoreRPC_ConnectNetwork_Handler,
		},
		{
			MethodName: "DisconnectNetwork",
			Handler:    _CoreRPC_DisconnectNetwork_Handler,
		},
		{
			MethodName: "AddPod",
			Handler:    _CoreRPC_AddPod_Handler,
		},
		{
			MethodName: "RemovePod",
			Handler:    _CoreRPC_RemovePod_Handler,
		},
		{
			MethodName: "GetPod",
			Handler:    _CoreRPC_GetPod_Handler,
		},
		{
			MethodName: "ListPods",
			Handler:    _CoreRPC_ListPods_Handler,
		},
		{
			MethodName: "GetPodResource",
			Handler:    _CoreRPC_GetPodResource_Handler,
		},
		{
			MethodName: "AddNode",
			Handler:    _CoreRPC_AddNode_Handler,
		},
		{
			MethodName: "RemoveNode",
			Handler:    _CoreRPC_RemoveNode_Handler,
		},
		{
			MethodName: "ListPodNodes",
			Handler:    _CoreRPC_ListPodNodes_Handler,
		},
		{
			MethodName: "GetNode",
			Handler:    _CoreRPC_GetNode_Handler,
		},
		{
			MethodName: "SetNode",
			Handler:    _CoreRPC_SetNode_Handler,
		},
		{
			MethodName: "SetNodeStatus",
			Handler:    _CoreRPC_SetNodeStatus_Handler,
		},
		{
			MethodName: "GetNodeStatus",
			Handler:    _CoreRPC_GetNodeStatus_Handler,
		},
		{
			MethodName: "GetNodeResource",
			Handler:    _CoreRPC_GetNodeResource_Handler,
		},
		{
			MethodName: "CalculateCapacity",
			Handler:    _CoreRPC_CalculateCapacity_Handler,
		},
		{
			MethodName: "GetWorkload",
			Handler:    _CoreRPC_GetWorkload_Handler,
		},
		{
			MethodName: "GetWorkloads",
			Handler:    _CoreRPC_GetWorkloads_Handler,
		},
		{
			MethodName: "ListNodeWorkloads",
			Handler:    _CoreRPC_ListNodeWorkloads_Handler,
		},
		{
			MethodName: "GetWorkloadsStatus",
			Handler:    _CoreRPC_GetWorkloadsStatus_Handler,
		},
		{
			MethodName: "SetWorkloadsStatus",
			Handler:    _CoreRPC_SetWorkloadsStatus_Handler,
		},
		{
			MethodName: "ReallocResource",
			Handler:    _CoreRPC_ReallocResource_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "WatchServiceStatus",
			Handler:       _CoreRPC_WatchServiceStatus_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "NodeStatusStream",
			Handler:       _CoreRPC_NodeStatusStream_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "ListWorkloads",
			Handler:       _CoreRPC_ListWorkloads_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "WorkloadStatusStream",
			Handler:       _CoreRPC_WorkloadStatusStream_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "Copy",
			Handler:       _CoreRPC_Copy_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "Send",
			Handler:       _CoreRPC_Send_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "BuildImage",
			Handler:       _CoreRPC_BuildImage_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "CacheImage",
			Handler:       _CoreRPC_CacheImage_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "RemoveImage",
			Handler:       _CoreRPC_RemoveImage_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "CreateWorkload",
			Handler:       _CoreRPC_CreateWorkload_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "ReplaceWorkload",
			Handler:       _CoreRPC_ReplaceWorkload_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "RemoveWorkload",
			Handler:       _CoreRPC_RemoveWorkload_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "DissociateWorkload",
			Handler:       _CoreRPC_DissociateWorkload_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "ControlWorkload",
			Handler:       _CoreRPC_ControlWorkload_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "ExecuteWorkload",
			Handler:       _CoreRPC_ExecuteWorkload_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
		{
			StreamName:    "LogStream",
			Handler:       _CoreRPC_LogStream_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "RunAndWait",
			Handler:       _CoreRPC_RunAndWait_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "rpc/gen/core.proto",
}
