name: System Change Policy
acronym: SCP
satisfies:
  TSC:
    - CC8.1
    - CC3.4
majorRevisions:
  - date: Jun 1 2018
    comment: Initial document
---

# Purpose and Scope

a. This information security policy defines how changes to information systems are planned and implemented 

a. This policy applies to the entire information security program at the organization (i.e. to all information and communications technology, as well as related documentation).

a. All employees, contractors, part-time and temporary workers, service providers, and those employed by others to perform work for the organization, or who have been granted to the organization’s information and communications technology, must comply with this policy.

# Background

a. This policy defines specific requirements to ensure that changes to systems and applications are properly planned, evaluated, reviewed, approved, communicated, implemented, documented, and reviewed, thereby ensuring the greatest probability of success. Where changes are not successful, this document provides mechanisms for conducting post-implementation review such that future mistakes and errors can be prevented.

# Policy

a. Any changes to the security architecture or customer data handling of a system must be formally requested in writing to the organization’s Information Security Manager (ISM), and approved by the ISM and the Chief Information Officer (CIO).

a. All change requests must be documented.

a. All change requests must be prioritized in terms of benefits, urgency, effort required, and potential impacts to the organization’s operations.

a. All implemented changes must be communicated to relevant users. 

a. Change management must be conducted according to the following procedure:
    
    i. *Planning*: plan the change, including the implementation design, scheduling, and implementation of a communications plan, testing plan, and roll-back plan.
    
    i. *Evaluation*: evaluate the change, including priority level of the service and risk that the proposed change introduces to the system; determine the change type and the specific step-by-step process to implement the change.
    
    i. *Review*: review the change plan amongst the CIO, ISM, Engineering Lead, and, if applicable, Business Unit Manager.
    
    i. *Approval*: the CIO must approve the change plan. 
    
    i. *Communication*: communicate the change to all users of the system.
    
    i. *Implementation*: test and implement the change.
    
    i. *Documentation*: record the change and any post-implementation issues.
    
    i. *Post-change review*: conduct a post-implementation review to determine how the change is impacting the organization, either positively or negatively. Discuss and document any lessons learned.

