/*
 ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~
 ~                                                                               ~
 ~ The MIT License (MIT)                                                         ~
 ~                                                                               ~
 ~ Copyright (c) 2015-2025 miaixz.org and other contributors.                    ~
 ~                                                                               ~
 ~ Permission is hereby granted, free of charge, to any person obtaining a copy  ~
 ~ of this software and associated documentation files (the "Software"), to deal ~
 ~ in the Software without restriction, including without limitation the rights  ~
 ~ to use, copy, modify, merge, publish, distribute, sublicense, and/or sell     ~
 ~ copies of the Software, and to permit persons to whom the Software is         ~
 ~ furnished to do so, subject to the following conditions:                      ~
 ~                                                                               ~
 ~ The above copyright notice and this permission notice shall be included in    ~
 ~ all copies or substantial portions of the Software.                           ~
 ~                                                                               ~
 ~ THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR    ~
 ~ IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,      ~
 ~ FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE   ~
 ~ AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER        ~
 ~ LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, ~
 ~ OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN     ~
 ~ THE SOFTWARE.                                                                 ~
 ~                                                                               ~
 ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~
*/
package org.miaixz.bus.core.text.escape;

import java.io.Serial;

import org.miaixz.bus.core.text.replacer.LookupReplacer;

/**
 * Unescapes characters for HTML 4.0. This class provides functionality to convert HTML 4.0 entity references back into
 * their original characters.
 *
 * <p>
 * It extends {@link XmlUnescape} to handle basic XML entities and adds support for ISO-8859-1 and extended HTML 4.0
 * entities.
 *
 * @author Kimi Liu
 * @since Java 17+
 */
public class Html4Unescape extends XmlUnescape {

    /**
     * Lookup table for ISO-8859-1 HTML unescape characters. This array is generated by inverting the
     * {@link Html4Escape#ISO8859_1_ESCAPE} array, mapping HTML entity references back to their original characters.
     */
    protected static final String[][] ISO8859_1_UNESCAPE = invert(Html4Escape.ISO8859_1_ESCAPE);
    /**
     * Lookup table for extended HTML 4.0 unescape characters. This array is generated by inverting the
     * {@link Html4Escape#HTML40_EXTENDED_ESCAPE} array, mapping HTML entity references back to their original
     * characters.
     */
    protected static final String[][] HTML40_EXTENDED_UNESCAPE = invert(Html4Escape.HTML40_EXTENDED_ESCAPE);
    /**
     * The serial version UID for serialization.
     */
    @Serial
    private static final long serialVersionUID = 2852236030759L;

    /**
     * Constructs a new {@code Html4Unescape} instance. Initializes the unescape chain with basic XML unescaping,
     * followed by ISO-8859-1 and extended HTML 4.0 unescape lookup replacers.
     */
    public Html4Unescape() {
        super();
        addChain(new LookupReplacer(ISO8859_1_UNESCAPE));
        addChain(new LookupReplacer(HTML40_EXTENDED_UNESCAPE));
    }

}
