/*
 ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~
 ~                                                                               ~
 ~ The MIT License (MIT)                                                         ~
 ~                                                                               ~
 ~ Copyright (c) 2015-2025 miaixz.org and other contributors.                    ~
 ~                                                                               ~
 ~ Permission is hereby granted, free of charge, to any person obtaining a copy  ~
 ~ of this software and associated documentation files (the "Software"), to deal ~
 ~ in the Software without restriction, including without limitation the rights  ~
 ~ to use, copy, modify, merge, publish, distribute, sublicense, and/or sell     ~
 ~ copies of the Software, and to permit persons to whom the Software is         ~
 ~ furnished to do so, subject to the following conditions:                      ~
 ~                                                                               ~
 ~ The above copyright notice and this permission notice shall be included in    ~
 ~ all copies or substantial portions of the Software.                           ~
 ~                                                                               ~
 ~ THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR    ~
 ~ IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,      ~
 ~ FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE   ~
 ~ AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER        ~
 ~ LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, ~
 ~ OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN     ~
 ~ THE SOFTWARE.                                                                 ~
 ~                                                                               ~
 ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~
*/
/**
 * bus.image
 * 
 * @author Kimi Liu
 * @since Java 17+
 */
module bus.image {

    requires java.desktop;
    requires java.naming;
    requires java.xml;

    requires bus.core;
    requires bus.logger;
    requires bus.health;
    requires bus.setting;

    requires bus.opencv;
    requires lombok;
    requires jakarta.json;

    exports org.miaixz.bus.image;
    exports org.miaixz.bus.image.builtin;
    exports org.miaixz.bus.image.builtin.ldap;
    exports org.miaixz.bus.image.galaxy;
    exports org.miaixz.bus.image.galaxy.data;
    exports org.miaixz.bus.image.galaxy.dict.AMI_Annotations_01;
    exports org.miaixz.bus.image.galaxy.dict.AMI_Annotations_02;
    exports org.miaixz.bus.image.galaxy.dict.AMI_ImageContextExt_01;
    exports org.miaixz.bus.image.galaxy.dict.AMI_ImageContext_01;
    exports org.miaixz.bus.image.galaxy.dict.AMI_ImageTransform_01;
    exports org.miaixz.bus.image.galaxy.dict.AMI_Sequence_AnnotElements_01;
    exports org.miaixz.bus.image.galaxy.dict.AMI_Sequence_Annotations_01;
    exports org.miaixz.bus.image.galaxy.dict.AMI_Sequence_Annotations_02;
    exports org.miaixz.bus.image.galaxy.dict.AMI_StudyExtensions_01;
    exports org.miaixz.bus.image.galaxy.dict.APEX_PRIVATE;
    exports org.miaixz.bus.image.galaxy.dict.Applicare_Centricity_Radiology_Web_Version_1_0;
    exports org.miaixz.bus.image.galaxy.dict.Applicare_Centricity_Radiology_Web_Version_2_0;
    exports org.miaixz.bus.image.galaxy.dict.Applicare_Print_Version_5_1;
    exports org.miaixz.bus.image.galaxy.dict.Applicare_RadStore_Version_1_0;
    exports org.miaixz.bus.image.galaxy.dict.Applicare_RadWorks_Version_5_0;
    exports org.miaixz.bus.image.galaxy.dict.Applicare_RadWorks_Version_6_0;
    exports org.miaixz.bus.image.galaxy.dict.Applicare_RadWorks_Version_6_0_Summary;
    exports org.miaixz.bus.image.galaxy.dict.Applicare_Workflow_Version_1_0;
    exports org.miaixz.bus.image.galaxy.dict.BioPri3D;
    exports org.miaixz.bus.image.galaxy.dict.CARDIO_D_R__1_0;
    exports org.miaixz.bus.image.galaxy.dict.CARDIO_D_R__1_0_siemens;
    exports org.miaixz.bus.image.galaxy.dict.DIDI_TO_PCR_1_1;
    exports org.miaixz.bus.image.galaxy.dict.DIGISCAN_IMAGE;
    exports org.miaixz.bus.image.galaxy.dict.DLX_ANNOT_01;
    exports org.miaixz.bus.image.galaxy.dict.DLX_EXAMS_01;
    exports org.miaixz.bus.image.galaxy.dict.DLX_LKUP_01;
    exports org.miaixz.bus.image.galaxy.dict.DLX_PATNT_01;
    exports org.miaixz.bus.image.galaxy.dict.DLX_SERIE_01;
    exports org.miaixz.bus.image.galaxy.dict.DL_INTERNAL_USE;
    exports org.miaixz.bus.image.galaxy.dict.ESOFT_DICOM_ECAT_OWNERCODE;
    exports org.miaixz.bus.image.galaxy.dict.FFP_DATA;
    exports org.miaixz.bus.image.galaxy.dict.GEHC_CT_ADVAPP_001;
    exports org.miaixz.bus.image.galaxy.dict.GEIIS;
    exports org.miaixz.bus.image.galaxy.dict.GEIIS_IW;
    exports org.miaixz.bus.image.galaxy.dict.GEIIS_PACS;
    exports org.miaixz.bus.image.galaxy.dict.GEIIS_RA1000;
    exports org.miaixz.bus.image.galaxy.dict.GEMS_0039;
    exports org.miaixz.bus.image.galaxy.dict.GEMS_3DSTATE_001;
    exports org.miaixz.bus.image.galaxy.dict.GEMS_3D_INTVL_01;
    exports org.miaixz.bus.image.galaxy.dict.GEMS_ACQU_01;
    exports org.miaixz.bus.image.galaxy.dict.GEMS_ACRQA_1_0_BLOCK1;
    exports org.miaixz.bus.image.galaxy.dict.GEMS_ACRQA_1_0_BLOCK2;
    exports org.miaixz.bus.image.galaxy.dict.GEMS_ACRQA_1_0_BLOCK3;
    exports org.miaixz.bus.image.galaxy.dict.GEMS_ACRQA_2_0_BLOCK1;
    exports org.miaixz.bus.image.galaxy.dict.GEMS_ACRQA_2_0_BLOCK2;
    exports org.miaixz.bus.image.galaxy.dict.GEMS_ACRQA_2_0_BLOCK3;
    exports org.miaixz.bus.image.galaxy.dict.GEMS_ADWSoft_3D1;
    exports org.miaixz.bus.image.galaxy.dict.GEMS_ADWSoft_DPO;
    exports org.miaixz.bus.image.galaxy.dict.GEMS_ADWSoft_DPO1;
    exports org.miaixz.bus.image.galaxy.dict.GEMS_AWSOFT_CD1;
    exports org.miaixz.bus.image.galaxy.dict.GEMS_AWSoft_SB1;
    exports org.miaixz.bus.image.galaxy.dict.GEMS_CTHD_01;
    exports org.miaixz.bus.image.galaxy.dict.GEMS_CT_CARDIAC_001;
    exports org.miaixz.bus.image.galaxy.dict.GEMS_CT_HINO_01;
    exports org.miaixz.bus.image.galaxy.dict.GEMS_CT_VES_01;
    exports org.miaixz.bus.image.galaxy.dict.GEMS_DL_FRAME_01;
    exports org.miaixz.bus.image.galaxy.dict.GEMS_DL_IMG_01;
    exports org.miaixz.bus.image.galaxy.dict.GEMS_DL_PATNT_01;
    exports org.miaixz.bus.image.galaxy.dict.GEMS_DL_SERIES_01;
    exports org.miaixz.bus.image.galaxy.dict.GEMS_DL_STUDY_01;
    exports org.miaixz.bus.image.galaxy.dict.GEMS_DRS_1;
    exports org.miaixz.bus.image.galaxy.dict.GEMS_FALCON_03;
    exports org.miaixz.bus.image.galaxy.dict.GEMS_FUNCTOOL_01;
    exports org.miaixz.bus.image.galaxy.dict.GEMS_GDXE_ATHENAV2_INTERNAL_USE;
    exports org.miaixz.bus.image.galaxy.dict.GEMS_GDXE_FALCON_04;
    exports org.miaixz.bus.image.galaxy.dict.GEMS_GENIE_1;
    exports org.miaixz.bus.image.galaxy.dict.GEMS_GNHD_01;
    exports org.miaixz.bus.image.galaxy.dict.GEMS_HELIOS_01;
    exports org.miaixz.bus.image.galaxy.dict.GEMS_IDEN_01;
    exports org.miaixz.bus.image.galaxy.dict.GEMS_IDI_01;
    exports org.miaixz.bus.image.galaxy.dict.GEMS_IMAG_01;
    exports org.miaixz.bus.image.galaxy.dict.GEMS_IMPS_01;
    exports org.miaixz.bus.image.galaxy.dict.GEMS_IQTB_IDEN_47;
    exports org.miaixz.bus.image.galaxy.dict.GEMS_IT_Centricity_RA600_7_0;
    exports org.miaixz.bus.image.galaxy.dict.GEMS_IT_US_REPORT;
    exports org.miaixz.bus.image.galaxy.dict.GEMS_LUNAR_RAW;
    exports org.miaixz.bus.image.galaxy.dict.GEMS_PARM_01;
    exports org.miaixz.bus.image.galaxy.dict.GEMS_PATI_01;
    exports org.miaixz.bus.image.galaxy.dict.GEMS_PETD_01;
    exports org.miaixz.bus.image.galaxy.dict.GEMS_RELA_01;
    exports org.miaixz.bus.image.galaxy.dict.GEMS_SEND_02;
    exports org.miaixz.bus.image.galaxy.dict.GEMS_SENOCRYSTAL_V1;
    exports org.miaixz.bus.image.galaxy.dict.GEMS_SENO_02;
    exports org.miaixz.bus.image.galaxy.dict.GEMS_SERS_01;
    exports org.miaixz.bus.image.galaxy.dict.GEMS_STDY_01;
    exports org.miaixz.bus.image.galaxy.dict.GEMS_Ultrasound_ExamGroup_001;
    exports org.miaixz.bus.image.galaxy.dict.GEMS_Ultrasound_ImageGroup_001;
    exports org.miaixz.bus.image.galaxy.dict.GEMS_Ultrasound_MovieGroup_001;
    exports org.miaixz.bus.image.galaxy.dict.GEMS_VXTL_USERDATA_01;
    exports org.miaixz.bus.image.galaxy.dict.GEMS_XELPRV_01;
    exports org.miaixz.bus.image.galaxy.dict.GEMS_XR3DCAL_01;
    exports org.miaixz.bus.image.galaxy.dict.GEMS_YMHD_01;
    exports org.miaixz.bus.image.galaxy.dict.GE_1_2_840_113708_794_1_1_2_0;
    exports org.miaixz.bus.image.galaxy.dict.GE_GENESIS_REV3_0;
    exports org.miaixz.bus.image.galaxy.dict.GE_GROUP;
    exports org.miaixz.bus.image.galaxy.dict.GE_Generic_Data;
    exports org.miaixz.bus.image.galaxy.dict.GE_Informatics_Data;
    exports org.miaixz.bus.image.galaxy.dict.GE_LUT_Asymmetry_Parameter;
    exports org.miaixz.bus.image.galaxy.dict.GE_____From_Adantage_Review_CS;
    exports org.miaixz.bus.image.galaxy.dict.ISI;
    exports org.miaixz.bus.image.galaxy.dict.KINETDX;
    exports org.miaixz.bus.image.galaxy.dict.KINETDX_GRAPHICS;
    exports org.miaixz.bus.image.galaxy.dict.KRETZ_US;
    exports org.miaixz.bus.image.galaxy.dict.Mayo_IBM_Archive_Project;
    exports org.miaixz.bus.image.galaxy.dict.PHILIPS_IMAGING_DD_001_1;
    exports org.miaixz.bus.image.galaxy.dict.PHILIPS_MR;
    exports org.miaixz.bus.image.galaxy.dict.PHILIPS_MR_1;
    exports org.miaixz.bus.image.galaxy.dict.PHILIPS_MR_IMAGING_DD_001_1;
    exports org.miaixz.bus.image.galaxy.dict.PHILIPS_MR_LAST;
    exports org.miaixz.bus.image.galaxy.dict.PHILIPS_MR_PART;
    exports org.miaixz.bus.image.galaxy.dict.PHILIPS_MR_PART_12;
    exports org.miaixz.bus.image.galaxy.dict.PHILIPS_MR_PART_6;
    exports org.miaixz.bus.image.galaxy.dict.PHILIPS_MR_PART_7;
    exports org.miaixz.bus.image.galaxy.dict.PHILIPS_MR_R5_5_PART;
    exports org.miaixz.bus.image.galaxy.dict.PHILIPS_MR_R5_6_PART;
    exports org.miaixz.bus.image.galaxy.dict.PHILIPS_MR_SPECTRO_1;
    exports org.miaixz.bus.image.galaxy.dict.PHILIPS_NM__Private;
    exports org.miaixz.bus.image.galaxy.dict.PHILIPS_XCT__Private;
    exports org.miaixz.bus.image.galaxy.dict.PMI_Private_Calibration_Module_Version_2_0;
    exports org.miaixz.bus.image.galaxy.dict.PMS_THORA_5_1;
    exports org.miaixz.bus.image.galaxy.dict.POLYTRON_SMS_2_5;
    exports org.miaixz.bus.image.galaxy.dict.Philips_EV_Imaging_DD_022;
    exports org.miaixz.bus.image.galaxy.dict.Philips_Imaging_DD_001;
    exports org.miaixz.bus.image.galaxy.dict.Philips_Imaging_DD_002;
    exports org.miaixz.bus.image.galaxy.dict.Philips_Imaging_DD_065;
    exports org.miaixz.bus.image.galaxy.dict.Philips_Imaging_DD_067;
    exports org.miaixz.bus.image.galaxy.dict.Philips_Imaging_DD_070;
    exports org.miaixz.bus.image.galaxy.dict.Philips_Imaging_DD_073;
    exports org.miaixz.bus.image.galaxy.dict.Philips_Imaging_DD_124;
    exports org.miaixz.bus.image.galaxy.dict.Philips_Imaging_DD_129;
    exports org.miaixz.bus.image.galaxy.dict.Philips_MR_Imaging_DD_001;
    exports org.miaixz.bus.image.galaxy.dict.Philips_MR_Imaging_DD_002;
    exports org.miaixz.bus.image.galaxy.dict.Philips_MR_Imaging_DD_003;
    exports org.miaixz.bus.image.galaxy.dict.Philips_MR_Imaging_DD_004;
    exports org.miaixz.bus.image.galaxy.dict.Philips_MR_Imaging_DD_005;
    exports org.miaixz.bus.image.galaxy.dict.Philips_MR_Imaging_DD_006;
    exports org.miaixz.bus.image.galaxy.dict.Philips_NM_Private_Group;
    exports org.miaixz.bus.image.galaxy.dict.Philips_PET_Private_Group;
    exports org.miaixz.bus.image.galaxy.dict.Philips_RAD_Imaging_DD_001;
    exports org.miaixz.bus.image.galaxy.dict.Philips_RAD_Imaging_DD_097;
    exports org.miaixz.bus.image.galaxy.dict.Philips_US_Imaging_DD_017;
    exports org.miaixz.bus.image.galaxy.dict.Philips_US_Imaging_DD_021;
    exports org.miaixz.bus.image.galaxy.dict.Philips_US_Imaging_DD_023;
    exports org.miaixz.bus.image.galaxy.dict.Philips_US_Imaging_DD_033;
    exports org.miaixz.bus.image.galaxy.dict.Philips_US_Imaging_DD_034;
    exports org.miaixz.bus.image.galaxy.dict.Philips_US_Imaging_DD_035;
    exports org.miaixz.bus.image.galaxy.dict.Philips_US_Imaging_DD_036;
    exports org.miaixz.bus.image.galaxy.dict.Philips_US_Imaging_DD_037;
    exports org.miaixz.bus.image.galaxy.dict.Philips_US_Imaging_DD_038;
    exports org.miaixz.bus.image.galaxy.dict.Philips_US_Imaging_DD_039;
    exports org.miaixz.bus.image.galaxy.dict.Philips_US_Imaging_DD_040;
    exports org.miaixz.bus.image.galaxy.dict.Philips_US_Imaging_DD_041;
    exports org.miaixz.bus.image.galaxy.dict.Philips_US_Imaging_DD_042;
    exports org.miaixz.bus.image.galaxy.dict.Philips_US_Imaging_DD_043;
    exports org.miaixz.bus.image.galaxy.dict.Philips_US_Imaging_DD_045;
    exports org.miaixz.bus.image.galaxy.dict.Philips_US_Imaging_DD_046;
    exports org.miaixz.bus.image.galaxy.dict.Philips_US_Imaging_DD_048;
    exports org.miaixz.bus.image.galaxy.dict.Philips_US_Imaging_DD_065;
    exports org.miaixz.bus.image.galaxy.dict.Philips_US_Imaging_DD_066;
    exports org.miaixz.bus.image.galaxy.dict.Philips_US_Imaging_DD_109;
    exports org.miaixz.bus.image.galaxy.dict.Philips_US_Imaging_DD_113;
    exports org.miaixz.bus.image.galaxy.dict.Philips_X_ray_Imaging_DD_001;
    exports org.miaixz.bus.image.galaxy.dict.QUASAR_INTERNAL_USE;
    exports org.miaixz.bus.image.galaxy.dict.REPORT_FROM_APP;
    exports org.miaixz.bus.image.galaxy.dict.RadWorksTBR;
    exports org.miaixz.bus.image.galaxy.dict.SHS_MagicView_300;
    exports org.miaixz.bus.image.galaxy.dict.SIEMENS_AX_INSPACE_EP;
    exports org.miaixz.bus.image.galaxy.dict.SIEMENS_CM_VA0__ACQU;
    exports org.miaixz.bus.image.galaxy.dict.SIEMENS_CM_VA0__CMS;
    exports org.miaixz.bus.image.galaxy.dict.SIEMENS_CM_VA0__LAB;
    exports org.miaixz.bus.image.galaxy.dict.SIEMENS_CSA_ENVELOPE;
    exports org.miaixz.bus.image.galaxy.dict.SIEMENS_CSA_HEADER;
    exports org.miaixz.bus.image.galaxy.dict.SIEMENS_CSA_NON_IMAGE;
    exports org.miaixz.bus.image.galaxy.dict.SIEMENS_CSA_REPORT;
    exports org.miaixz.bus.image.galaxy.dict.SIEMENS_CT_APPL_DATASET;
    exports org.miaixz.bus.image.galaxy.dict.SIEMENS_CT_APPL_EVIDENCEDOCUMENT;
    exports org.miaixz.bus.image.galaxy.dict.SIEMENS_CT_APPL_MEASUREMENT;
    exports org.miaixz.bus.image.galaxy.dict.SIEMENS_CT_APPL_PRESENTATION;
    exports org.miaixz.bus.image.galaxy.dict.SIEMENS_CT_APPL_TMP_DATAMODEL;
    exports org.miaixz.bus.image.galaxy.dict.SIEMENS_CT_VA0__COAD;
    exports org.miaixz.bus.image.galaxy.dict.SIEMENS_CT_VA0__GEN;
    exports org.miaixz.bus.image.galaxy.dict.SIEMENS_CT_VA0__IDE;
    exports org.miaixz.bus.image.galaxy.dict.SIEMENS_CT_VA0__ORI;
    exports org.miaixz.bus.image.galaxy.dict.SIEMENS_CT_VA0__OST;
    exports org.miaixz.bus.image.galaxy.dict.SIEMENS_CT_VA0__RAW;
    exports org.miaixz.bus.image.galaxy.dict.SIEMENS_DFR_01_MANIPULATED;
    exports org.miaixz.bus.image.galaxy.dict.SIEMENS_DFR_01_ORIGINAL;
    exports org.miaixz.bus.image.galaxy.dict.SIEMENS_DICOM;
    exports org.miaixz.bus.image.galaxy.dict.SIEMENS_DLR_01;
    exports org.miaixz.bus.image.galaxy.dict.SIEMENS_FLCOMPACT_VA01A_PROC;
    exports org.miaixz.bus.image.galaxy.dict.SIEMENS_IKM_CKS_CXRCAD_FINDINGS;
    exports org.miaixz.bus.image.galaxy.dict.SIEMENS_IKM_CKS_LUNGCAD_BMK;
    exports org.miaixz.bus.image.galaxy.dict.SIEMENS_IMAGE_SHADOW_ATTRIBUTES;
    exports org.miaixz.bus.image.galaxy.dict.SIEMENS_ISI;
    exports org.miaixz.bus.image.galaxy.dict.SIEMENS_MED;
    exports org.miaixz.bus.image.galaxy.dict.SIEMENS_MEDCOM_HEADER;
    exports org.miaixz.bus.image.galaxy.dict.SIEMENS_MEDCOM_HEADER2;
    exports org.miaixz.bus.image.galaxy.dict.SIEMENS_MEDCOM_OOG;
    exports org.miaixz.bus.image.galaxy.dict.SIEMENS_MED_DISPLAY;
    exports org.miaixz.bus.image.galaxy.dict.SIEMENS_MED_DISPLAY_0000;
    exports org.miaixz.bus.image.galaxy.dict.SIEMENS_MED_DISPLAY_0001;
    exports org.miaixz.bus.image.galaxy.dict.SIEMENS_MED_ECAT_FILE_INFO;
    exports org.miaixz.bus.image.galaxy.dict.SIEMENS_MED_HG;
    exports org.miaixz.bus.image.galaxy.dict.SIEMENS_MED_MAMMO;
    exports org.miaixz.bus.image.galaxy.dict.SIEMENS_MED_MG;
    exports org.miaixz.bus.image.galaxy.dict.SIEMENS_MED_NM;
    exports org.miaixz.bus.image.galaxy.dict.SIEMENS_MED_OCS_BEAM_DISPLAY_INFO;
    exports org.miaixz.bus.image.galaxy.dict.SIEMENS_MED_OCS_PUBLIC_RT_PLAN_ATTRIBUTES;
    exports org.miaixz.bus.image.galaxy.dict.SIEMENS_MED_OCS_SS_VERSION_INFO;
    exports org.miaixz.bus.image.galaxy.dict.SIEMENS_MED_PT;
    exports org.miaixz.bus.image.galaxy.dict.SIEMENS_MED_PT_WAVEFORM;
    exports org.miaixz.bus.image.galaxy.dict.SIEMENS_MED_SMS_USG_ANTARES;
    exports org.miaixz.bus.image.galaxy.dict.SIEMENS_MED_SMS_USG_ANTARES_3D_VOLUME;
    exports org.miaixz.bus.image.galaxy.dict.SIEMENS_MED_SMS_USG_S2000;
    exports org.miaixz.bus.image.galaxy.dict.SIEMENS_MED_SMS_USG_S2000_3D_VOLUME;
    exports org.miaixz.bus.image.galaxy.dict.SIEMENS_MED_SP_DXMG_WH_AWS_1;
    exports org.miaixz.bus.image.galaxy.dict.SIEMENS_MED_SYNGO_RT;
    exports org.miaixz.bus.image.galaxy.dict.SIEMENS_MI_RWVM_SUV;
    exports org.miaixz.bus.image.galaxy.dict.SIEMENS_MR_CM_03;
    exports org.miaixz.bus.image.galaxy.dict.SIEMENS_MR_DATAMAPPING_ATTRIBUTES;
    exports org.miaixz.bus.image.galaxy.dict.SIEMENS_MR_EXTRACTED_CSA_HEADER;
    exports org.miaixz.bus.image.galaxy.dict.SIEMENS_MR_FOR_06;
    exports org.miaixz.bus.image.galaxy.dict.SIEMENS_MR_HEADER;
    exports org.miaixz.bus.image.galaxy.dict.SIEMENS_MR_IMA;
    exports org.miaixz.bus.image.galaxy.dict.SIEMENS_MR_MRS_05;
    exports org.miaixz.bus.image.galaxy.dict.SIEMENS_MR_N3D;
    exports org.miaixz.bus.image.galaxy.dict.SIEMENS_MR_PHOENIX_ATTRIBUTES;
    exports org.miaixz.bus.image.galaxy.dict.SIEMENS_MR_PS_04;
    exports org.miaixz.bus.image.galaxy.dict.SIEMENS_MR_SDI_02;
    exports org.miaixz.bus.image.galaxy.dict.SIEMENS_MR_SDS_01;
    exports org.miaixz.bus.image.galaxy.dict.SIEMENS_MR_VA0__COAD;
    exports org.miaixz.bus.image.galaxy.dict.SIEMENS_MR_VA0__GEN;
    exports org.miaixz.bus.image.galaxy.dict.SIEMENS_MR_VA0__RAW;
    exports org.miaixz.bus.image.galaxy.dict.SIEMENS_NUMARIS_II;
    exports org.miaixz.bus.image.galaxy.dict.SIEMENS_RA_GEN;
    exports org.miaixz.bus.image.galaxy.dict.SIEMENS_RA_PLANE_A;
    exports org.miaixz.bus.image.galaxy.dict.SIEMENS_RA_PLANE_B;
    exports org.miaixz.bus.image.galaxy.dict.SIEMENS_RIS;
    exports org.miaixz.bus.image.galaxy.dict.SIEMENS_SERIES_SHADOW_ATTRIBUTES;
    exports org.miaixz.bus.image.galaxy.dict.SIEMENS_SIENET;
    exports org.miaixz.bus.image.galaxy.dict.SIEMENS_SMS_AX__ACQ_1_0;
    exports org.miaixz.bus.image.galaxy.dict.SIEMENS_SMS_AX__ORIGINAL_IMAGE_INFO_1_0;
    exports org.miaixz.bus.image.galaxy.dict.SIEMENS_SMS_AX__QUANT_1_0;
    exports org.miaixz.bus.image.galaxy.dict.SIEMENS_SMS_AX__VIEW_1_0;
    exports org.miaixz.bus.image.galaxy.dict.SIEMENS_SYNGO_3D_FUSION_MATRIX;
    exports org.miaixz.bus.image.galaxy.dict.SIEMENS_SYNGO_ADVANCED_PRESENTATION;
    exports org.miaixz.bus.image.galaxy.dict.SIEMENS_SYNGO_DATA_PADDING;
    exports org.miaixz.bus.image.galaxy.dict.SIEMENS_SYNGO_ENCAPSULATED_DOCUMENT_DATA;
    exports org.miaixz.bus.image.galaxy.dict.SIEMENS_SYNGO_ENHANCED_IDATASET_API;
    exports org.miaixz.bus.image.galaxy.dict.SIEMENS_SYNGO_EVIDENCE_DOCUMENT_DATA;
    exports org.miaixz.bus.image.galaxy.dict.SIEMENS_SYNGO_FRAME_SET;
    exports org.miaixz.bus.image.galaxy.dict.SIEMENS_SYNGO_FUNCTION_ASSIGNMENT;
    exports org.miaixz.bus.image.galaxy.dict.SIEMENS_SYNGO_INDEX_SERVICE;
    exports org.miaixz.bus.image.galaxy.dict.SIEMENS_SYNGO_INSTANCE_MANIFEST;
    exports org.miaixz.bus.image.galaxy.dict.SIEMENS_SYNGO_LAYOUT_PROTOCOL;
    exports org.miaixz.bus.image.galaxy.dict.SIEMENS_SYNGO_OBJECT_GRAPHICS;
    exports org.miaixz.bus.image.galaxy.dict.SIEMENS_SYNGO_PRINT_SERVICE;
    exports org.miaixz.bus.image.galaxy.dict.SIEMENS_SYNGO_REGISTRATION;
    exports org.miaixz.bus.image.galaxy.dict.SIEMENS_SYNGO_SOP_CLASS_PACKING;
    exports org.miaixz.bus.image.galaxy.dict.SIEMENS_SYNGO_TIME_POINT_SERVICE;
    exports org.miaixz.bus.image.galaxy.dict.SIEMENS_SYNGO_ULTRA_SOUND_TOYON_DATA_STREAMING;
    exports org.miaixz.bus.image.galaxy.dict.SIEMENS_SYNGO_VOLUME;
    exports org.miaixz.bus.image.galaxy.dict.SIEMENS_SYNGO_WORKFLOW;
    exports org.miaixz.bus.image.galaxy.dict.SIEMENS_Selma;
    exports org.miaixz.bus.image.galaxy.dict.SIEMENS_Ultrasound_S2000;
    exports org.miaixz.bus.image.galaxy.dict.SIEMENS_Ultrasound_SC2000;
    exports org.miaixz.bus.image.galaxy.dict.SIEMENS_WH_SR_1_0;
    exports org.miaixz.bus.image.galaxy.dict.SIENET;
    exports org.miaixz.bus.image.galaxy.dict.SMIL_PB79;
    exports org.miaixz.bus.image.galaxy.dict.SMIO_PB7B;
    exports org.miaixz.bus.image.galaxy.dict.SMIO_PB7D;
    exports org.miaixz.bus.image.galaxy.dict.SPI;
    exports org.miaixz.bus.image.galaxy.dict.SPI_P_CTBE_Private_Release_1;
    exports org.miaixz.bus.image.galaxy.dict.SPI_P_CTBE_Release_1;
    exports org.miaixz.bus.image.galaxy.dict.SPI_P_GV_CT_Release_1;
    exports org.miaixz.bus.image.galaxy.dict.SPI_P_PCR_Release_2;
    exports org.miaixz.bus.image.galaxy.dict.SPI_P_Private_CDS_Release_1;
    exports org.miaixz.bus.image.galaxy.dict.SPI_P_Private_CWS_Release_1;
    exports org.miaixz.bus.image.galaxy.dict.SPI_P_Private_DCI_Release_1;
    exports org.miaixz.bus.image.galaxy.dict.SPI_P_Private_DiDi_Release_1;
    exports org.miaixz.bus.image.galaxy.dict.SPI_P_Private_ICS_Release_1;
    exports org.miaixz.bus.image.galaxy.dict.SPI_P_Private_ICS_Release_1_1;
    exports org.miaixz.bus.image.galaxy.dict.SPI_P_Private_ICS_Release_1_2;
    exports org.miaixz.bus.image.galaxy.dict.SPI_P_Private_ICS_Release_1_3;
    exports org.miaixz.bus.image.galaxy.dict.SPI_P_Private_ICS_Release_1_4;
    exports org.miaixz.bus.image.galaxy.dict.SPI_P_Private_ICS_Release_1_5;
    exports org.miaixz.bus.image.galaxy.dict.SPI_P_Release_1;
    exports org.miaixz.bus.image.galaxy.dict.SPI_P_Release_1_1;
    exports org.miaixz.bus.image.galaxy.dict.SPI_P_Release_1_2;
    exports org.miaixz.bus.image.galaxy.dict.SPI_P_Release_1_3;
    exports org.miaixz.bus.image.galaxy.dict.SPI_P_Release_2_1;
    exports org.miaixz.bus.image.galaxy.dict.SPI_P_XSB_DCI_Release_1;
    exports org.miaixz.bus.image.galaxy.dict.SPI_P_XSB_VISUB_Release_1;
    exports org.miaixz.bus.image.galaxy.dict.SPI_Release_1;
    exports org.miaixz.bus.image.galaxy.dict.Siemens_Ultrasound_Miscellaneous;
    exports org.miaixz.bus.image.galaxy.dict.Siemens__Thorax_Multix_FD_Image_Stamp;
    exports org.miaixz.bus.image.galaxy.dict.Siemens__Thorax_Multix_FD_Lab_Settings;
    exports org.miaixz.bus.image.galaxy.dict.Siemens__Thorax_Multix_FD_Post_Processing;
    exports org.miaixz.bus.image.galaxy.dict.Siemens__Thorax_Multix_FD_Raw_Image_Settings;
    exports org.miaixz.bus.image.galaxy.dict.Siemens__Thorax_Multix_FD_Version;
    exports org.miaixz.bus.image.galaxy.dict.acuson;
    exports org.miaixz.bus.image.galaxy.dict.acuson_1_2_840_113680_1_0_0910;
    exports org.miaixz.bus.image.galaxy.dict.acuson_1_2_840_113680_1_0_7f10;
    exports org.miaixz.bus.image.galaxy.dict.acuson_1_2_840_113680_1_0_7ffe;
    exports org.miaixz.bus.image.galaxy.dict.agfa;
    exports org.miaixz.bus.image.galaxy.dict.agfa_adc_compact;
    exports org.miaixz.bus.image.galaxy.dict.agfa_adc_nx;
    exports org.miaixz.bus.image.galaxy.dict.agfa_ag_hpstate;
    exports org.miaixz.bus.image.galaxy.dict.agfa_displayable_images;
    exports org.miaixz.bus.image.galaxy.dict.agfa_kosd_1_0;
    exports org.miaixz.bus.image.galaxy.dict.agfa_pacs_archive_mirroring_1_0;
    exports org.miaixz.bus.image.galaxy.dict.agfa_xeroverse;
    exports org.miaixz.bus.image.galaxy.dict.agility_overlay;
    exports org.miaixz.bus.image.galaxy.dict.agility_runtime;
    exports org.miaixz.bus.image.galaxy.dict.archive;
    exports org.miaixz.bus.image.galaxy.dict.elscint;
    exports org.miaixz.bus.image.galaxy.dict.http___www_gemedicalsystems_com_it_solutions_bamwallthickness_1_0;
    exports org.miaixz.bus.image.galaxy.dict.http___www_gemedicalsystems_com_it_solutions_orthoview_2_1;
    exports org.miaixz.bus.image.galaxy.dict.http___www_gemedicalsystems_com_it_solutions_rad_pacs_;
    exports org.miaixz.bus.image.galaxy.dict.mitra_linked_attributes_1_0;
    exports org.miaixz.bus.image.galaxy.dict.mitra_markup_1_0;
    exports org.miaixz.bus.image.galaxy.dict.mitra_object_attributes_1_0;
    exports org.miaixz.bus.image.galaxy.dict.mitra_object_document_1_0;
    exports org.miaixz.bus.image.galaxy.dict.mitra_object_utf8_attributes_1_0;
    exports org.miaixz.bus.image.galaxy.dict.mitra_presentation_1_0;
    exports org.miaixz.bus.image.galaxy.dict.syngoDynamics;
    exports org.miaixz.bus.image.galaxy.dict.syngoDynamics_Reporting;
    exports org.miaixz.bus.image.galaxy.io;
    exports org.miaixz.bus.image.galaxy.media;
    exports org.miaixz.bus.image.metric;
    exports org.miaixz.bus.image.metric.api;
    exports org.miaixz.bus.image.metric.hl7;
    exports org.miaixz.bus.image.metric.hl7.api;
    exports org.miaixz.bus.image.metric.hl7.ldap;
    exports org.miaixz.bus.image.metric.hl7.net;
    exports org.miaixz.bus.image.metric.json;
    exports org.miaixz.bus.image.metric.json.hl7;
    exports org.miaixz.bus.image.metric.json.imageio;
    exports org.miaixz.bus.image.metric.ldap;
    exports org.miaixz.bus.image.metric.net;
    exports org.miaixz.bus.image.metric.pdu;
    exports org.miaixz.bus.image.metric.service;
    exports org.miaixz.bus.image.nimble;
    exports org.miaixz.bus.image.nimble.codec;
    exports org.miaixz.bus.image.nimble.codec.jpeg;
    exports org.miaixz.bus.image.nimble.codec.mp4;
    exports org.miaixz.bus.image.nimble.codec.mpeg;
    exports org.miaixz.bus.image.nimble.extend;
    exports org.miaixz.bus.image.nimble.opencv;
    exports org.miaixz.bus.image.nimble.opencv.lut;
    exports org.miaixz.bus.image.nimble.opencv.op;
    exports org.miaixz.bus.image.nimble.opencv.seg;
    exports org.miaixz.bus.image.nimble.opencv.tile;
    exports org.miaixz.bus.image.nimble.reader;
    exports org.miaixz.bus.image.nimble.stream;
    exports org.miaixz.bus.image.plugin;

}
