/*
 ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~
 ~                                                                               ~
 ~ The MIT License (MIT)                                                         ~
 ~                                                                               ~
 ~ Copyright (c) 2015-2025 miaixz.org and other contributors.                    ~
 ~                                                                               ~
 ~ Permission is hereby granted, free of charge, to any person obtaining a copy  ~
 ~ of this software and associated documentation files (the "Software"), to deal ~
 ~ in the Software without restriction, including without limitation the rights  ~
 ~ to use, copy, modify, merge, publish, distribute, sublicense, and/or sell     ~
 ~ copies of the Software, and to permit persons to whom the Software is         ~
 ~ furnished to do so, subject to the following conditions:                      ~
 ~                                                                               ~
 ~ The above copyright notice and this permission notice shall be included in    ~
 ~ all copies or substantial portions of the Software.                           ~
 ~                                                                               ~
 ~ THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR    ~
 ~ IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,      ~
 ~ FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE   ~
 ~ AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER        ~
 ~ LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, ~
 ~ OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN     ~
 ~ THE SOFTWARE.                                                                 ~
 ~                                                                               ~
 ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~
*/
package org.miaixz.bus.image.galaxy.dict.GEMS_DL_STUDY_01;

/**
 * @author Kimi Liu
 * @since Java 17+
 */
public class PrivateTag {

    public static final String PrivateCreator = "GEMS_DL_STUDY_01";

    /** (0015,xx80) VR=DS VM=1 Study Dose */
    public static final int StudyDose = 0x00150080;

    /** (0015,xx81) VR=DS VM=1 Study Total Dap */
    public static final int StudyTotalDap = 0x00150081;

    /** (0015,xx82) VR=DS VM=1 Fluoro Dose Area Product */
    public static final int FluoroDoseAreaProduct = 0x00150082;

    /** (0015,xx83) VR=IS VM=1 Study Fluoro Time */
    public static final int StudyFluoroTime = 0x00150083;

    /** (0015,xx84) VR=DS VM=1 Cine Dose Area Product */
    public static final int CineDoseAreaProduct = 0x00150084;

    /** (0015,xx85) VR=IS VM=1 Study Record Time */
    public static final int StudyRecordTime = 0x00150085;

    /** (0015,xx86) VR=IS VM=1 Last XA Number */
    public static final int LastXANumber = 0x00150086;

    /** (0015,xx88) VR=PN VM=1-n Def Operator Name */
    public static final int DefOperatorName = 0x00150088;

    /** (0015,xx89) VR=PN VM=1-n Def Performing Physician Name */
    public static final int DefPerformingPhysicianName = 0x00150089;

    /** (0015,xx8A) VR=CS VM=2 Def Patient Orientation */
    public static final int DefPatientOrientation = 0x0015008A;

    /** (0015,xx8B) VR=IS VM=1 Last Sc Number */
    public static final int LastScNumber = 0x0015008B;

    /** (0015,xx8E) VR=UI VM=1 Common Series Instance UID */
    public static final int CommonSeriesInstanceUID = 0x0015008E;

    /** (0015,xx8F) VR=IS VM=1 Study Number */
    public static final int StudyNumber = 0x0015008F;

    /** (0015,xx92) VR=FL VM=1 ? */
    public static final int _0015_xx92_ = 0x00150092;

    /** (0015,xx93) VR=FL VM=1 ? */
    public static final int _0015_xx93_ = 0x00150093;

    /** (0015,xx94) VR=FL VM=1 ? */
    public static final int _0015_xx94_ = 0x00150094;

    /** (0015,xx95) VR=IS VM=1 ? */
    public static final int _0015_xx95_ = 0x00150095;

    /** (0015,xx96) VR=FL VM=1 ? */
    public static final int _0015_xx96_ = 0x00150096;

    /** (0015,xx97) VR=IS VM=1 ? */
    public static final int _0015_xx97_ = 0x00150097;

    /** (0015,xx98) VR=FL VM=1 ? */
    public static final int _0015_xx98_ = 0x00150098;

    /** (0015,xx99) VR=FL VM=1 ? */
    public static final int _0015_xx99_ = 0x00150099;

    /** (0015,xx9A) VR=FL VM=1 ? */
    public static final int _0015_xx9A_ = 0x0015009A;

    /** (0015,xx9B) VR=IS VM=1 ? */
    public static final int _0015_xx9B_ = 0x0015009B;

    /** (0015,xx9C) VR=FL VM=1 ? */
    public static final int _0015_xx9C_ = 0x0015009C;

    /** (0015,xx9D) VR=IS VM=1 ? */
    public static final int _0015_xx9D_ = 0x0015009D;

}
