/*
 ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~
 ~                                                                               ~
 ~ The MIT License (MIT)                                                         ~
 ~                                                                               ~
 ~ Copyright (c) 2015-2025 miaixz.org and other contributors.                    ~
 ~                                                                               ~
 ~ Permission is hereby granted, free of charge, to any person obtaining a copy  ~
 ~ of this software and associated documentation files (the "Software"), to deal ~
 ~ in the Software without restriction, including without limitation the rights  ~
 ~ to use, copy, modify, merge, publish, distribute, sublicense, and/or sell     ~
 ~ copies of the Software, and to permit persons to whom the Software is         ~
 ~ furnished to do so, subject to the following conditions:                      ~
 ~                                                                               ~
 ~ The above copyright notice and this permission notice shall be included in    ~
 ~ all copies or substantial portions of the Software.                           ~
 ~                                                                               ~
 ~ THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR    ~
 ~ IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,      ~
 ~ FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE   ~
 ~ AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER        ~
 ~ LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, ~
 ~ OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN     ~
 ~ THE SOFTWARE.                                                                 ~
 ~                                                                               ~
 ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~
*/
package org.miaixz.bus.image.galaxy.dict.GEMS_GENIE_1;

/**
 * @author Kimi Liu
 * @since Java 17+
 */
public class PrivateTag {

    public static final String PrivateCreator = "GEMS_GENIE_1";

    /** (0009,xx01) VR=SH VM=1 ? */
    public static final int _0009_xx01_ = 0x00090001;

    /** (0009,xx10) VR=LO VM=1 Study Name */
    public static final int StudyName = 0x00090010;

    /** (0009,xx11) VR=SL VM=1 Study Flags */
    public static final int StudyFlags = 0x00090011;

    /** (0009,xx12) VR=SL VM=1 Study Type */
    public static final int StudyType = 0x00090012;

    /** (0009,xx1E) VR=UI VM=1 Dataset UID */
    public static final int DatasetUID = 0x0009001E;

    /** (0009,xx20) VR=LO VM=1 Series Object Name */
    public static final int SeriesObjectName = 0x00090020;

    /** (0009,xx21) VR=SL VM=1 Series Flags */
    public static final int SeriesFlags = 0x00090021;

    /** (0009,xx22) VR=SH VM=1 User Orientation */
    public static final int UserOrientation = 0x00090022;

    /** (0009,xx23) VR=SL VM=1 Initiation Type */
    public static final int InitiationType = 0x00090023;

    /** (0009,xx24) VR=SL VM=1 Initiation Delay */
    public static final int InitiationDelay = 0x00090024;

    /** (0009,xx25) VR=SL VM=1 Initiation Count Rate */
    public static final int InitiationCountRate = 0x00090025;

    /** (0009,xx26) VR=SL VM=1 Number Energy Sets */
    public static final int NumberEnergySets = 0x00090026;

    /** (0009,xx27) VR=SL VM=1 Number Detectors */
    public static final int NumberDetectors = 0x00090027;

    /** (0009,xx28) VR=SL VM=1 Number RR Windows */
    public static final int NumberRRWindows = 0x00090028;

    /** (0009,xx29) VR=SL VM=1 Number MG Time Slots */
    public static final int NumberMGTimeSlots = 0x00090029;

    /** (0009,xx2A) VR=SL VM=1 Number View Sets */
    public static final int NumberViewSets = 0x0009002A;

    /** (0009,xx2B) VR=LO VM=1 Trigger History UID */
    public static final int TriggerHistoryUID = 0x0009002B;

    /** (0009,xx2C) VR=LO VM=1 Series Comments */
    public static final int SeriesComments = 0x0009002C;

    /** (0009,xx2D) VR=SL VM=1 Track Beat Average */
    public static final int TrackBeatAverage = 0x0009002D;

    /** (0009,xx2E) VR=FD VM=1 Distance Prescribed */
    public static final int DistancePrescribed = 0x0009002E;

    /** (0009,xx2F) VR=SL VM=1 Table Direction */
    public static final int TableDirection = 0x0009002F;

    /** (0009,xx30) VR=LO VM=1 ? */
    public static final int _0009_xx30_ = 0x00090030;

    /** (0009,xx33) VR=FD VM=1 Rotational Continuous Speed */
    public static final int RotationalContinuousSpeed = 0x00090033;

    /** (0009,xx34) VR=SL VM=1 Gantry Motion Type (Retired) */
    public static final int GantryMotionTypeRetired = 0x00090034;

    /** (0009,xx35) VR=SL VM=1 Gantry Locus Type */
    public static final int GantryLocusType = 0x00090035;

    /** (0009,xx37) VR=SL VM=1 Starting Heart Rate */
    public static final int StartingHeartRate = 0x00090037;

    /** (0009,xx38) VR=SL VM=1 RR Window Width */
    public static final int RRWindowWidth = 0x00090038;

    /** (0009,xx39) VR=SL VM=1 RR Window Offset */
    public static final int RRWindowOffset = 0x00090039;

    /** (0009,xx3A) VR=SL VM=1 Percent Cycle Imaged */
    public static final int PercentCycleImaged = 0x0009003A;

    /** (0009,xx40) VR=PN VM=1 Patient Object Name */
    public static final int PatientObjectName = 0x00090040;

    /** (0009,xx41) VR=SL VM=1 Patient Flags */
    public static final int PatientFlags = 0x00090041;

    /** (0009,xx42) VR=DA VM=1 Patient Creation Date */
    public static final int PatientCreationDate = 0x00090042;

    /** (0009,xx43) VR=TM VM=1 Patient Creation Time */
    public static final int PatientCreationTime = 0x00090043;

    /** (0009,xx44) VR=SL VM=1 Num Views Acquired (Retired) */
    public static final int NumViewsAcquiredRetired = 0x00090044;

    /** (0009,xx45) VR=LT VM=1 ? */
    public static final int _0009_xx45_ = 0x00090045;

    /** (0009,xx46) VR=UI VM=1 ? */
    public static final int _0009_xx46_ = 0x00090046;

    /** (0011,xx0A) VR=SL VM=1 Series Type */
    public static final int SeriesType = 0x0011000A;

    /** (0011,xx0B) VR=SL VM=1 Effective Series Duration */
    public static final int EffectiveSeriesDuration = 0x0011000B;

    /** (0011,xx0C) VR=SL VM=1 Num Beats */
    public static final int NumBeats = 0x0011000C;

    /** (0011,xx0D) VR=LO VM=1 Radio Nuclide Name */
    public static final int RadioNuclideName = 0x0011000D;

    /** (0011,xx10) VR=LO VM=1 Dataset Object Name */
    public static final int DatasetObjectName = 0x00110010;

    /** (0011,xx11) VR=SL VM=1 Dataset Modified */
    public static final int DatasetModified = 0x00110011;

    /** (0011,xx12) VR=LO VM=1 Dataset Name */
    public static final int DatasetName = 0x00110012;

    /** (0011,xx13) VR=SL VM=1 Dataset Type */
    public static final int DatasetType = 0x00110013;

    /** (0011,xx14) VR=LO VM=1 Completion Time */
    public static final int CompletionTime = 0x00110014;

    /** (0011,xx15) VR=SL VM=1 Detector Number */
    public static final int DetectorNumber = 0x00110015;

    /** (0011,xx16) VR=SL VM=1 Energy Number */
    public static final int EnergyNumber = 0x00110016;

    /** (0011,xx17) VR=SL VM=1 RR Interval Window Number */
    public static final int RRIntervalWindowNumber = 0x00110017;

    /** (0011,xx18) VR=SL VM=1 MG Bin Number */
    public static final int MGBinNumber = 0x00110018;

    /** (0011,xx19) VR=FD VM=1 Radius Of Rotation */
    public static final int RadiusOfRotation = 0x00110019;

    /** (0011,xx1A) VR=SL VM=1 Detector Count Zone */
    public static final int DetectorCountZone = 0x0011001A;

    /** (0011,xx1B) VR=SL VM=1 Num Energy Windows */
    public static final int NumEnergyWindows = 0x0011001B;

    /** (0011,xx1C) VR=SL VM=4 Energy Offset */
    public static final int EnergyOffset = 0x0011001C;

    /** (0011,xx1D) VR=SL VM=1 Energy Range */
    public static final int EnergyRange = 0x0011001D;

    /** (0011,xx1E) VR=SL VM=4 Energy Width (Retired) */
    public static final int EnergyWidthRetired = 0x0011001E;

    /** (0011,xx1F) VR=SL VM=1 Image Orientation */
    public static final int ImageOrientation = 0x0011001F;

    /** (0011,xx21) VR=DS VM=1 Acq Zoom (Retired) */
    public static final int AcqZoomRetired = 0x00110021;

    /** (0011,xx22) VR=DS VM=1 Acq Pan (Retired) */
    public static final int AcqPanRetired = 0x00110022;

    /** (0011,xx23) VR=SL VM=1 Use FOV Mask */
    public static final int UseFOVMask = 0x00110023;

    /** (0011,xx24) VR=SL VM=1 FOV Mask Y Cutoff Angle */
    public static final int FOVMaskYCutoffAngle = 0x00110024;

    /** (0011,xx25) VR=SL VM=1 FOV Mask Cutoff Angle */
    public static final int FOVMaskCutoffAngle = 0x00110025;

    /** (0011,xx26) VR=SL VM=1 Table Orientation */
    public static final int TableOrientation = 0x00110026;

    /** (0011,xx27) VR=SL VM=2 ROI Top Left */
    public static final int ROITopLeft = 0x00110027;

    /** (0011,xx28) VR=SL VM=2 ROI Bottom Right */
    public static final int ROIBottomRight = 0x00110028;

    /** (0011,xx29) VR=SL VM=1 Uniformity Mean */
    public static final int UniformityMean = 0x00110029;

    /** (0011,xx2A) VR=FD VM=1 Phase Duration (Retired) */
    public static final int PhaseDurationRetired = 0x0011002A;

    /** (0011,xx2C) VR=FD VM=1 View X Adjustment */
    public static final int ViewXAdjustment = 0x0011002C;

    /** (0011,xx2D) VR=FD VM=1 View Y Adjustment */
    public static final int ViewYAdjustment = 0x0011002D;

    /** (0011,xx2E) VR=SL VM=1 Pixel Overflow Flag */
    public static final int PixelOverflowFlag = 0x0011002E;

    /** (0011,xx2F) VR=SL VM=1 Overflow Level */
    public static final int OverflowLevel = 0x0011002F;

    /** (0011,xx30) VR=LO VM=1 Picture Object Name */
    public static final int PictureObjectName = 0x00110030;

    /** (0011,xx31) VR=LO VM=1 Acquisition Parent UID */
    public static final int AcquisitionParentUID = 0x00110031;

    /** (0011,xx32) VR=LO VM=1 Processing Parent UID */
    public static final int ProcessingParentUID = 0x00110032;

    /** (0011,xx33) VR=LO VM=1 Energy Correct Name */
    public static final int EnergyCorrectName = 0x00110033;

    /** (0011,xx34) VR=LO VM=1 Spatial Correct Name */
    public static final int SpatialCorrectName = 0x00110034;

    /** (0011,xx35) VR=LO VM=1 Tuning Calib Name */
    public static final int TuningCalibName = 0x00110035;

    /** (0011,xx36) VR=LO VM=1 Uniformity Correct Name */
    public static final int UniformityCorrectName = 0x00110036;

    /** (0011,xx37) VR=LT VM=1 Acquisition Specific Correct Name */
    public static final int AcquisitionSpecificCorrectName = 0x00110037;

    /** (0011,xx38) VR=SL VM=1 Byte Order */
    public static final int ByteOrder = 0x00110038;

    /** (0011,xx39) VR=SL VM=1 Compression Type */
    public static final int CompressionType = 0x00110039;

    /** (0011,xx3A) VR=SL VM=1 Picture Format */
    public static final int PictureFormat = 0x0011003A;

    /** (0011,xx3B) VR=FD VM=1 Pixel Scale */
    public static final int PixelScale = 0x0011003B;

    /** (0011,xx3C) VR=FD VM=1 Pixel Offset */
    public static final int PixelOffset = 0x0011003C;

    /** (0011,xx3D) VR=SL VM=4 Energy Peak (Retired) */
    public static final int EnergyPeakRetired = 0x0011003D;

    /** (0011,xx3E) VR=SL VM=1 FOV Shape */
    public static final int FOVShape = 0x0011003E;

    /** (0011,xx3F) VR=SL VM=1 Dataset Flags */
    public static final int DatasetFlags = 0x0011003F;

    /** (0011,xx40) VR=LO VM=1 Viewing Object Name */
    public static final int ViewingObjectName = 0x00110040;

    /** (0011,xx41) VR=SL VM=1 Orientation Angle */
    public static final int OrientationAngle = 0x00110041;

    /** (0011,xx42) VR=FD VM=1 Rotation Angle */
    public static final int RotationAngle = 0x00110042;

    /** (0011,xx43) VR=SL VM=1 Window Inverse Flag */
    public static final int WindowInverseFlag = 0x00110043;

    /** (0011,xx44) VR=FD VM=1 Threshold Center */
    public static final int ThresholdCenter = 0x00110044;

    /** (0011,xx45) VR=FD VM=1 Threshold Width */
    public static final int ThresholdWidth = 0x00110045;

    /** (0011,xx46) VR=SL VM=1 Interpolation Type */
    public static final int InterpolationType = 0x00110046;

    /** (0011,xx50) VR=LO VM=1 Where Object Name */
    public static final int WhereObjectName = 0x00110050;

    /** (0011,xx55) VR=FD VM=1 Period */
    public static final int Period = 0x00110055;

    /** (0011,xx56) VR=FD VM=1 ElapsedTime */
    public static final int ElapsedTime = 0x00110056;

    /** (0011,xx57) VR=FD VM=2 FOV */
    public static final int FOV = 0x00110057;

    /** (0011,xx61) VR=SL VM=1 Image Size */
    public static final int ImageSize = 0x00110061;

    /** (0011,xx62) VR=FD VM=1 Linear FOV */
    public static final int LinearFOV = 0x00110062;

    /** (0011,xx63) VR=FD VM=1 Spatial Offset */
    public static final int SpatialOffset = 0x00110063;

    /** (0011,xx64) VR=FD VM=1 Spatial Orientation */
    public static final int SpatialOrientation = 0x00110064;

    /** (0011,xx65) VR=LO VM=1 Reference Dataset UID */
    public static final int ReferenceDatasetUID = 0x00110065;

    /** (0011,xx66) VR=SH VM=1 Starcam Reference Dataset */
    public static final int StarcamReferenceDataset = 0x00110066;

    /** (0011,xx67) VR=SL VM=1 Reference Frame Number */
    public static final int ReferenceFrameNumber = 0x00110067;

    /** (0011,xx68) VR=SL VM=1 Cursor Length */
    public static final int CursorLength = 0x00110068;

    /** (0011,xx69) VR=SL VM=1 Number of Cursors */
    public static final int NumberOfCursors = 0x00110069;

    /** (0011,xx6A) VR=SL VM=1 Cursor Coordinates */
    public static final int CursorCoordinates = 0x0011006A;

    /** (0011,xx6B) VR=SL VM=1 Recon Options Flag */
    public static final int ReconOptionsFlag = 0x0011006B;

    /** (0011,xx6C) VR=FD VM=1 Motion Threshold */
    public static final int MotionThreshold = 0x0011006C;

    /** (0011,xx6D) VR=UI VM=1 Motion Curve UID */
    public static final int MotionCurveUID = 0x0011006D;

    /** (0011,xx6E) VR=SL VM=1 Recon Type */
    public static final int ReconType = 0x0011006E;

    /** (0011,xx6F) VR=SL VM=1 Pre Filter Type */
    public static final int PreFilterType = 0x0011006F;

    /** (0011,xx71) VR=SL VM=1 Back Proj Filter Type */
    public static final int BackProjFilterType = 0x00110071;

    /** (0011,xx72) VR=SL VM=1 Recon Arc */
    public static final int ReconArc = 0x00110072;

    /** (0011,xx73) VR=FD VM=1 Recon Pan AP Offset */
    public static final int ReconPanAPOffset = 0x00110073;

    /** (0011,xx74) VR=FD VM=1 Recon Pan LR Offset */
    public static final int ReconPanLROffset = 0x00110074;

    /** (0011,xx75) VR=FD VM=1 Recon Area */
    public static final int ReconArea = 0x00110075;

    /** (0011,xx76) VR=SL VM=1 Start View */
    public static final int StartView = 0x00110076;

    /** (0011,xx77) VR=SL VM=1 Attenuation Type */
    public static final int AttenuationType = 0x00110077;

    /** (0011,xx78) VR=SL VM=1 Dua lEnergy Processing */
    public static final int DualEnergyProcessing = 0x00110078;

    /** (0011,xx79) VR=SH VM=1 Pre Filter Param */
    public static final int PreFilterParam = 0x00110079;

    /** (0011,xx7A) VR=SH VM=1 Pre Filter Param 2 */
    public static final int PreFilterParam2 = 0x0011007A;

    /** (0011,xx7B) VR=SH VM=1 Back Proj Filter Param */
    public static final int BackProjFilterParam = 0x0011007B;

    /** (0011,xx7C) VR=SH VM=1 Back Proj Filter Param 2 */
    public static final int BackProjFilterParam2 = 0x0011007C;

    /** (0011,xx7D) VR=SH VM=1 Attenuation Coef */
    public static final int AttenuationCoef = 0x0011007D;

    /** (0011,xx7E) VR=SL VM=1 Ref Slice Width */
    public static final int RefSliceWidth = 0x0011007E;

    /** (0011,xx7F) VR=FD VM=1 Ref Trans Pixel Volume */
    public static final int RefTransPixelVolume = 0x0011007F;

    /** (0011,xx81) VR=SH VM=1 Attenuation Threshold */
    public static final int AttenuationThreshold = 0x00110081;

    /** (0011,xx82) VR=FD VM=1 Interpolation Distance */
    public static final int InterpolationDistance = 0x00110082;

    /** (0011,xx83) VR=FD VM=1 Interpolation Center X */
    public static final int InterpolationCenterX = 0x00110083;

    /** (0011,xx84) VR=FD VM=1 Interpolation Center Y */
    public static final int InterpolationCenterY = 0x00110084;

    /** (0011,xx85) VR=SL VM=1 Quant Filter Flag */
    public static final int QuantFilterFlag = 0x00110085;

    /** (0011,xx86) VR=SL VM=1 Head Conversion */
    public static final int HeadConversion = 0x00110086;

    /** (0011,xx87) VR=SL VM=1 Slice Width Pixels */
    public static final int SliceWidthPixels = 0x00110087;

    /** (0011,xx88) VR=SL VM=1 Rfmtr Trans Ref */
    public static final int RfmtrTransRef = 0x00110088;

    /** (0011,xx89) VR=FD VM=1 Rfmtr Trans Ref mm */
    public static final int RfmtrTransRefmm = 0x00110089;

    /** (0011,xx8A) VR=SL VM=1 Two Line Trans Ref */
    public static final int TwoLineTransRef = 0x0011008A;

    /** (0011,xx8B) VR=SL VM=1 Three-D Zero */
    public static final int ThreeDZero = 0x0011008B;

    /** (0011,xx8C) VR=SL VM=1 Three-D Zero Length */
    public static final int ThreeDZeroLength = 0x0011008C;

    /** (0011,xx8D) VR=SL VM=1 Three-D Zero In */
    public static final int ThreeDZeroIn = 0x0011008D;

    /** (0013,xx10) VR=FD VM=2 Digital FOV */
    public static final int DigitalFOV = 0x00130010;

    /** (0013,xx11) VR=SL VM=1 Source Translator */
    public static final int SourceTranslator = 0x00130011;

    /** (0013,xx12) VR=SL VM=1 RAL Flags */
    public static final int RALFlags = 0x00130012;

    /** (0013,xx13) VR=SQ VM=1 eNTEGRA Frame Sequence */
    public static final int eNTEGRAFrameSequence = 0x00130013;

    /** (0013,xx14) VR=SL VM=1 Original Image Number */
    public static final int OriginalImageNumber = 0x00130014;

    /** (0013,xx15) VR=FD VM=1 Fscalar */
    public static final int Fscalar = 0x00130015;

    /** (0013,xx16) VR=SL VM=1 AutoTrack Peak */
    public static final int AutoTrackPeak = 0x00130016;

    /** (0013,xx17) VR=SL VM=1 AutoTrack Width */
    public static final int AutoTrackWidth = 0x00130017;

    /** (0013,xx18) VR=FD VM=1 Transmission Scan Time */
    public static final int TransmissionScanTime = 0x00130018;

    /** (0013,xx19) VR=FD VM=1 Transmission Mask Width */
    public static final int TransmissionMaskWidth = 0x00130019;

    /** (0013,xx1A) VR=FD VM=1 Copper Attenuator Thickness */
    public static final int CopperAttenuatorThickness = 0x0013001A;

    /** (0013,xx1B) VR=FD VM=1 Det Ang Separation */
    public static final int DetAngSeparation = 0x0013001B;

    /** (0013,xx1C) VR=SL VM=1 Axial Acceptance Angle */
    public static final int AxialAcceptanceAngle = 0x0013001C;

    /** (0013,xx1D) VR=SL VM=1 Theta Acceptance Value */
    public static final int ThetaAcceptanceValue = 0x0013001D;

    /** (0013,xx1E) VR=FD VM=1-n Tomo View Offset */
    public static final int TomoViewOffset = 0x0013001E;

    /** (0013,xx20) VR=FD VM=1 Accepted Beats Time */
    public static final int AcceptedBeatsTime = 0x00130020;

    /** (0013,xx21) VR=FD VM=2 Threshold */
    public static final int Threshold = 0x00130021;

    /** (0013,xx22) VR=FD VM=2 Linear Depth */
    public static final int LinearDepth = 0x00130022;

    /** (0013,xx23) VR=LO VM=1 Unif Date Time */
    public static final int UnifDateTime = 0x00130023;

    /** (0013,xx24) VR=SL VM=1 Series Accepted Beats */
    public static final int SeriesAcceptedBeats = 0x00130024;

    /** (0013,xx25) VR=SL VM=1 Series Rejected Beats */
    public static final int SeriesRejectedBeats = 0x00130025;

    /** (0013,xx26) VR=LT VM=1 Study Comments */
    public static final int StudyComments = 0x00130026;

    /** (0015,xx10) VR=SL VM=1 Frame Termination Condition */
    public static final int FrameTerminationCondition = 0x00150010;

    /** (0015,xx11) VR=SL VM=1 Frame Termination Value */
    public static final int FrameTerminationValue = 0x00150011;

    /** (0015,xx12) VR=SL VM=1 Num ECT Phases */
    public static final int NumECTPhases = 0x00150012;

    /** (0015,xx13) VR=SL VM=1 Num WB Scans */
    public static final int NumWBScans = 0x00150013;

    /** (0015,xx14) VR=SL VM=1 ECT Phase Num */
    public static final int ECTPhaseNum = 0x00150014;

    /** (0015,xx15) VR=SL VM=1 WB Scan Num */
    public static final int WBScanNum = 0x00150015;

    /** (0015,xx16) VR=SL VM=1 Comb Head Number */
    public static final int CombHeadNumber = 0x00150016;

    /** (0015,xx17) VR=UL VM=1 Preceding Beat */
    public static final int PrecedingBeat = 0x00150017;

    /** (0019,xx5F) VR=SQ VM=1 ? */
    public static final int _0019_xx5F_ = 0x0019005F;

    /** (0033,xx07) VR=LO VM=1-n Original SOP Instance UID */
    public static final int OriginalSOPInstanceUID = 0x00330007;

    /** (0033,xx08) VR=CS VM=1 eNTEGRA Data Object Type */
    public static final int eNTEGRADataObjectType = 0x00330008;

    /** (0033,xx10) VR=SL VM=1 Modified */
    public static final int Modified = 0x00330010;

    /** (0033,xx11) VR=LO VM=1 Name */
    public static final int Name = 0x00330011;

    /** (0033,xx16) VR=LO VM=1 Protocol Data UID */
    public static final int ProtocolDataUID = 0x00330016;

    /** (0033,xx17) VR=SH VM=1 Date */
    public static final int Date = 0x00330017;

    /** (0033,xx18) VR=SH VM=1 Time */
    public static final int Time = 0x00330018;

    /** (0033,xx19) VR=UL VM=1 Protocol Data Flags */
    public static final int ProtocolDataFlags = 0x00330019;

    /** (0033,xx1A) VR=UL VM=1 Protocol Name */
    public static final int ProtocolName = 0x0033001A;

    /** (0033,xx1B) VR=LO VM=1 Relevant Data UID */
    public static final int RelevantDataUID = 0x0033001B;

    /** (0033,xx1C) VR=LO VM=1 Bulk Data */
    public static final int BulkData = 0x0033001C;

    /** (0033,xx1D) VR=SL VM=1-n Int Data */
    public static final int IntData = 0x0033001D;

    /** (0033,xx1E) VR=FD VM=1-n Double Data */
    public static final int DoubleData = 0x0033001E;

    /** (0033,xx1F) VR=OB VM=1 String Data */
    public static final int StringData = 0x0033001F;

    /** (0033,xx20) VR=LT VM=1-n Bulk Data Format */
    public static final int BulkDataFormat = 0x00330020;

    /** (0033,xx21) VR=LT VM=1-n Int Data Format */
    public static final int IntDataFormat = 0x00330021;

    /** (0033,xx22) VR=LT VM=1-n Double Data Format */
    public static final int DoubleDataFormat = 0x00330022;

    /** (0033,xx23) VR=LT VM=1-n String Data Format */
    public static final int StringDataFormat = 0x00330023;

    /** (0033,xx24) VR=LT VM=1 Description */
    public static final int Description = 0x00330024;

    /** (0033,xx30) VR=UL VM=1 Allocate Trigger Buffer */
    public static final int AllocateTriggerBuffer = 0x00330030;

    /** (0033,xx33) VR=UL VM=1 Number of Triggers */
    public static final int NumberOfTriggers = 0x00330033;

    /** (0033,xx34) VR=UL VM=1 Trigger Size */
    public static final int TriggerSize = 0x00330034;

    /** (0033,xx35) VR=UL VM=1 Trigger Data Size */
    public static final int TriggerDataSize = 0x00330035;

    /** (0033,xx36) VR=OB VM=1 Trigger Data */
    public static final int TriggerData = 0x00330036;

    /** (0035,xx01) VR=FD VM=1-n Start Angle */
    public static final int StartAngle = 0x00350001;

    /**
     * (0055,xx12) VR=SQ VM=1 eNTEGRA Energy Window Information Sequence
     */
    public static final int eNTEGRAEnergyWindowInformationSequence = 0x00550012;

    /**
     * (0055,xx13) VR=SQ VM=1 eNTEGRA Energy Window Range Sequence
     */
    public static final int eNTEGRAEnergyWindowRangeSequence = 0x00550013;

    /**
     * (0055,xx22) VR=SQ VM=1 eNTEGRA Detector Information Sequence
     */
    public static final int eNTEGRADetectorInformationSequence = 0x00550022;

    /**
     * (0055,xx52) VR=SQ VM=1 eNTEGRA Rotation Information Sequence
     */
    public static final int eNTEGRARotationInformationSequence = 0x00550052;

    /** (0055,xx62) VR=SQ VM=1 eNTEGRA Gated Information Sequence */
    public static final int eNTEGRAGatedInformationSequence = 0x00550062;

    /** (0055,xx63) VR=SQ VM=1 eNTEGRA Data Information Sequence */
    public static final int eNTEGRADataInformationSequence = 0x00550063;

    /** (0055,xx64) VR=SQ VM=1 SDO Double Data Sequence */
    public static final int SDODoubleDataSequence = 0x00550064;

    /** (0055,xx65) VR=SQ VM=1 ? */
    public static final int _0055_xx65_ = 0x00550065;

    /** (5001,xx03) VR=SL VM=1 Cid */
    public static final int Cid = 0x50010003;

    /** (5001,xx04) VR=SL VM=1 Srid */
    public static final int Srid = 0x50010004;

    /** (5001,xx05) VR=LO VM=1 SOP Class UID */
    public static final int SOPClassUID = 0x50010005;

    /** (5001,xx06) VR=LO VM=1 SOP Instance UID */
    public static final int SOPInstanceUID = 0x50010006;

    /** (5001,xx07) VR=SL VM=1 Curve Type */
    public static final int CurveType = 0x50010007;

    /** (5001,xx08) VR=SL VM=1 Graph Type */
    public static final int GraphType = 0x50010008;

    /** (5001,xx09) VR=LO VM=1 Legend */
    public static final int Legend = 0x50010009;

    /** (5001,xx0A) VR=LO VM=1 X Units */
    public static final int XUnits = 0x5001000A;

    /** (5001,xx0B) VR=LO VM=1 Y Units */
    public static final int YUnits = 0x5001000B;

    /** (5001,xx0C) VR=SL VM=1 Edit */
    public static final int Edit = 0x5001000C;

    /** (5001,xx0D) VR=SL VM=1 Suspend */
    public static final int Suspend = 0x5001000D;

    /** (5001,xx0E) VR=SL VM=1 Style Line */
    public static final int StyleLine = 0x5001000E;

    /** (5001,xx0F) VR=SL VM=1 Style Fill */
    public static final int StyleFill = 0x5001000F;

    /** (5001,xx10) VR=LO VM=1 Style Colour */
    public static final int StyleColour = 0x50010010;

    /** (5001,xx11) VR=SL VM=1 Style Width */
    public static final int StyleWidth = 0x50010011;

    /** (5001,xx12) VR=SL VM=1 Style Point */
    public static final int StylePoint = 0x50010012;

    /** (5001,xx13) VR=LO VM=1 Style P Colour */
    public static final int StylePColour = 0x50010013;

    /** (5001,xx14) VR=SL VM=1 Style P Size */
    public static final int StylePSize = 0x50010014;

    /** (5001,xx15) VR=SL VM=1 Segments */
    public static final int Segments = 0x50010015;

    /** (5001,xx16) VR=SL VM=1 Seg Type */
    public static final int SegType = 0x50010016;

    /** (5001,xx17) VR=FD VM=1-n Seg Start */
    public static final int SegStart = 0x50010017;

    /** (5001,xx18) VR=FD VM=1-n Seg End */
    public static final int SegEnd = 0x50010018;

    /** (5001,xx19) VR=SL VM=1-n Seg Style Line */
    public static final int SegStyleLine = 0x50010019;

    /** (5001,xx1A) VR=SL VM=1-n SegStyleFill */
    public static final int SegStyleFill = 0x5001001A;

    /** (5001,xx1B) VR=LO VM=1 Seg Style Colour */
    public static final int SegStyleColour = 0x5001001B;

    /** (5001,xx1C) VR=SL VM=1-n Seg Style Width */
    public static final int SegStyleWidth = 0x5001001C;

    /** (5001,xx1D) VR=SL VM=1-n Seg Style Point */
    public static final int SegStylePoint = 0x5001001D;

    /** (5001,xx1E) VR=SL VM=1 Seg Style P Colour */
    public static final int SegStylePColour = 0x5001001E;

    /** (5001,xx1F) VR=SL VM=1 Seg Style P Size */
    public static final int SegStylePSize = 0x5001001F;

    /** (5001,xx20) VR=LO VM=1 Seg Name */
    public static final int SegName = 0x50010020;

    /** (5001,xx21) VR=SL VM=1-n Seg Allow Dir Int */
    public static final int SegAllowDirInt = 0x50010021;

    /** (5001,xx22) VR=SL VM=1 Text Annots */
    public static final int TextAnnots = 0x50010022;

    /** (5001,xx23) VR=FD VM=1-n Txt X */
    public static final int TxtX = 0x50010023;

    /** (5001,xx24) VR=FD VM=1-n Txt Y */
    public static final int TxtY = 0x50010024;

    /** (5001,xx25) VR=LO VM=1 Txt Text */
    public static final int TxtText = 0x50010025;

    /** (5001,xx26) VR=LO VM=1 Txt Name */
    public static final int TxtName = 0x50010026;

    /** (5001,xx30) VR=LO VM=1 ROI Name */
    public static final int ROIName = 0x50010030;

    /** (5001,xx31) VR=LO VM=1 Derived From Image UID */
    public static final int DerivedFromImageUID = 0x50010031;

    /** (5001,xx32) VR=SL VM=1-n Derived From Images */
    public static final int DerivedFromImages = 0x50010032;

    /** (5001,xx33) VR=UL VM=1 Curve Flags */
    public static final int CurveFlags = 0x50010033;

    /** (5001,xx34) VR=LO VM=1 Curve Name */
    public static final int CurveName = 0x50010034;

    /** (5001,xx36) VR=LO VM=1 Curve UID */
    public static final int CurveUID = 0x50010036;

    /** (5001,xx37) VR=FD VM=1 ROI Area */
    public static final int ROIArea = 0x50010037;

    /** (5001,xx3A) VR=LO VM=1 Software Version */
    public static final int SoftwareVersion = 0x5001003A;

    /** (5001,xx3B) VR=SH VM=1 Start Date */
    public static final int StartDate = 0x5001003B;

    /** (5001,xx3C) VR=SH VM=1 Completion Date */
    public static final int CompletionDate = 0x5001003C;

    /** (5001,xx3D) VR=LO VM=1 Detector Name */
    public static final int DetectorName = 0x5001003D;

    /** (5001,xx47) VR=LO VM=1 Normal Color */
    public static final int NormalColor = 0x50010047;

    /** (5001,xx48) VR=LT VM=1 Name Font */
    public static final int NameFont = 0x50010048;

    /** (5001,xx49) VR=SL VM=1 Fill Pattern */
    public static final int FillPattern = 0x50010049;

    /** (5001,xx4A) VR=SL VM=1 Line Style */
    public static final int LineStyle = 0x5001004A;

    /** (5001,xx4B) VR=SL VM=1 Line Dash Length */
    public static final int LineDashLength = 0x5001004B;

    /** (5001,xx4C) VR=SL VM=1 Line Thickness */
    public static final int LineThickness = 0x5001004C;

    /** (5001,xx4D) VR=SL VM=1 Interactivity */
    public static final int Interactivity = 0x5001004D;

    /** (5001,xx4E) VR=SL VM=1 Name Pos */
    public static final int NamePos = 0x5001004E;

    /** (5001,xx4F) VR=SL VM=1 Name Display */
    public static final int NameDisplay = 0x5001004F;

    /** (5001,xx50) VR=LO VM=1 Label */
    public static final int Label = 0x50010050;

    /** (5001,xx51) VR=SL VM=1-n Bp Seg */
    public static final int BpSeg = 0x50010051;

    /** (5001,xx52) VR=US VM=1-n Bp Seg Pairs */
    public static final int BpSegPairs = 0x50010052;

    /** (5001,xx53) VR=SL VM=1 Seed Space */
    public static final int SeedSpace = 0x50010053;

    /** (5001,xx54) VR=FD VM=1-n Seeds */
    public static final int Seeds = 0x50010054;

    /** (5001,xx55) VR=SL VM=1-n Shape */
    public static final int Shape = 0x50010055;

    /** (5001,xx56) VR=FD VM=1-n Shape Tilt */
    public static final int ShapeTilt = 0x50010056;

    /** (5001,xx59) VR=SL VM=1-n Shape Pts Space */
    public static final int ShapePtsSpace = 0x50010059;

    /** (5001,xx5A) VR=SL VM=1-n Shape Ctrl Pts Counts */
    public static final int ShapeCtrlPtsCounts = 0x5001005A;

    /** (5001,xx5B) VR=FD VM=1-n Shape Ctrl Pts */
    public static final int ShapeCtrlPts = 0x5001005B;

    /** (5001,xx5C) VR=SL VM=1 Shape Ctrl P Space */
    public static final int ShapeCtrlPSpace = 0x5001005C;

    /** (5001,xx5D) VR=SL VM=1 ROI Flags */
    public static final int ROIFlags = 0x5001005D;

    /** (5001,xx5E) VR=SL VM=1 Frame Number */
    public static final int FrameNumber = 0x5001005E;

    /** (5001,xx5F) VR=SL VM=1 ID */
    public static final int ID = 0x5001005F;

    /** (5001,xx60) VR=LO VM=1-n Dataset ROI Mapping */
    public static final int DatasetROIMapping = 0x50010060;

}
