/*
 ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~
 ~                                                                               ~
 ~ The MIT License (MIT)                                                         ~
 ~                                                                               ~
 ~ Copyright (c) 2015-2025 miaixz.org and other contributors.                    ~
 ~                                                                               ~
 ~ Permission is hereby granted, free of charge, to any person obtaining a copy  ~
 ~ of this software and associated documentation files (the "Software"), to deal ~
 ~ in the Software without restriction, including without limitation the rights  ~
 ~ to use, copy, modify, merge, publish, distribute, sublicense, and/or sell     ~
 ~ copies of the Software, and to permit persons to whom the Software is         ~
 ~ furnished to do so, subject to the following conditions:                      ~
 ~                                                                               ~
 ~ The above copyright notice and this permission notice shall be included in    ~
 ~ all copies or substantial portions of the Software.                           ~
 ~                                                                               ~
 ~ THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR    ~
 ~ IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,      ~
 ~ FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE   ~
 ~ AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER        ~
 ~ LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, ~
 ~ OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN     ~
 ~ THE SOFTWARE.                                                                 ~
 ~                                                                               ~
 ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~
*/
package org.miaixz.bus.image.galaxy.dict.Philips_MR_Imaging_DD_006;

/**
 * @author Kimi Liu
 * @since Java 17+
 */
public class PrivateTag {

    public static final String PrivateCreator = "Philips MR Imaging DD 006";

    /** (2005,xx53) VR=FL VM=1 MRE Frequency */
    public static final int MREFrequency = 0x20050053;

    /** (2005,xx54) VR=FL VM=1 MRE Amplitude */
    public static final int MREAmplitude = 0x20050054;

    /** (2005,xx55) VR=FL VM=1 MREMEG Frequency */
    public static final int MREMEGFrequency = 0x20050055;

    /** (2005,xx56) VR=FL VM=1 MREMEG Pairs */
    public static final int MREMEGPairs = 0x20050056;

    /** (2005,xx57) VR=CS VM=1 MREMEG Direction */
    public static final int MREMEGDirection = 0x20050057;

    /** (2005,xx58) VR=FL VM=1 MREMEG Amplitude */
    public static final int MREMEGAmplitude = 0x20050058;

    /** (2005,xx59) VR=FL VM=1 MRE Number of Phase Delays */
    public static final int MRENumberOfPhaseDelays = 0x20050059;

    /** (2005,xx60) VR=IS VM=1 MRE Number of Motion Cycles */
    public static final int MRENumberOfMotionCycles = 0x20050060;

    /** (2005,xx61) VR=FL VM=1 MRE Motion MEG Phase Delay */
    public static final int MREMotionMEGPhaseDelay = 0x20050061;

    /** (2005,xx62) VR=LT VM=1 MRE Inversion Algorithm Version */
    public static final int MREInversionAlgorithmVersion = 0x20050062;

    /** (2005,xx63) VR=CS VM=1 Sagittal Slice Order */
    public static final int SagittalSliceOrder = 0x20050063;

    /** (2005,xx64) VR=CS VM=1 Coronal Slice Order */
    public static final int CoronalSliceOrder = 0x20050064;

    /** (2005,xx65) VR=CS VM=1 Transversal Slice Order */
    public static final int TransversalSliceOrder = 0x20050065;

    /** (2005,xx66) VR=CS VM=1 Series Orientation */
    public static final int SeriesOrientation = 0x20050066;

    /** (2005,xx67) VR=IS VM=1 MR Stack Reverse */
    public static final int MRStackReverse = 0x20050067;

    /** (2005,xx68) VR=IS VM=1 MRE Phase Delay Number */
    public static final int MREPhaseDelayNumber = 0x20050068;

    /** (2005,xx71) VR=IS VM=1 Number of Inversion Delays */
    public static final int NumberOfInversionDelays = 0x20050071;

    /** (2005,xx72) VR=FL VM=1 Inversion Delay Time */
    public static final int InversionDelayTime = 0x20050072;

    /** (2005,xx73) VR=IS VM=1 Inversion Delay Number */
    public static final int InversionDelayNumber = 0x20050073;

    /** (2005,xx74) VR=DS VM=1 Max DB DT */
    public static final int MaxDBDT = 0x20050074;

    /** (2005,xx75) VR=DS VM=1 Max SAR */
    public static final int MaxSAR = 0x20050075;

    /** (2005,xx76) VR=LT VM=1 SAR Type */
    public static final int SARType = 0x20050076;

    /** (2005,xx78) VR=CS VM=1 Metal Implant Status */
    public static final int MetalImplantStatus = 0x20050078;

    /** (2005,xx79) VR=CS VM=1-n Orientation Mirror Flip */
    public static final int OrientationMirrorFlip = 0x20050079;

    /** (2005,xx81) VR=CS VM=1 SAR Operation Mode */
    public static final int SAROperationMode = 0x20050081;

    /** (2005,xx82) VR=IS VM=1 Spatial Gradient */
    public static final int SpatialGradient = 0x20050082;

    /** (2005,xx83) VR=LT VM=1 Additional Constraints */
    public static final int AdditionalConstraints = 0x20050083;

    /** (2005,xx85) VR=DS VM=1 Gradient Slew Rate */
    public static final int GradientSlewRate = 0x20050085;

    /** (2005,xx86) VR=LT VM=1 ? */
    public static final int _2005_xx86_ = 0x20050086;

    /** (2005,xx87) VR=DS VM=1 B1 RMS */
    public static final int B1RMS = 0x20050087;

    /** (2005,xx92) VR=SQ VM=1 Contrast Information Sequence */
    public static final int ContrastInformationSequence = 0x20050092;

}
