/*
 ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~
 ~                                                                               ~
 ~ The MIT License (MIT)                                                         ~
 ~                                                                               ~
 ~ Copyright (c) 2015-2025 miaixz.org and other contributors.                    ~
 ~                                                                               ~
 ~ Permission is hereby granted, free of charge, to any person obtaining a copy  ~
 ~ of this software and associated documentation files (the "Software"), to deal ~
 ~ in the Software without restriction, including without limitation the rights  ~
 ~ to use, copy, modify, merge, publish, distribute, sublicense, and/or sell     ~
 ~ copies of the Software, and to permit persons to whom the Software is         ~
 ~ furnished to do so, subject to the following conditions:                      ~
 ~                                                                               ~
 ~ The above copyright notice and this permission notice shall be included in    ~
 ~ all copies or substantial portions of the Software.                           ~
 ~                                                                               ~
 ~ THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR    ~
 ~ IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,      ~
 ~ FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE   ~
 ~ AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER        ~
 ~ LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, ~
 ~ OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN     ~
 ~ THE SOFTWARE.                                                                 ~
 ~                                                                               ~
 ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~
*/
package org.miaixz.bus.image.galaxy.dict.SIEMENS_CT_VA0__COAD;

/**
 * @author Kimi Liu
 * @since Java 17+
 */
public class PrivateTag {

    public static final String PrivateCreator = "SIEMENS CT VA0 COAD";

    /**
     * (0019,xx10) VR=IS VM=1 Distance Source To Source Side Collimator
     */
    public static final int DistanceSourceToSourceSideCollimator = 0x00190010;

    /**
     * (0019,xx11) VR=IS VM=1 Distance Source To Detector Side Collimator
     */
    public static final int DistanceSourceToDetectorSideCollimator = 0x00190011;

    /** (0019,xx20) VR=IS VM=1 Number of Possible Channels */
    public static final int NumberOfPossibleChannels = 0x00190020;

    /** (0019,xx21) VR=IS VM=1 Mean Channel Number */
    public static final int MeanChannelNumber = 0x00190021;

    /** (0019,xx22) VR=DS VM=1 Detector Spacing */
    public static final int DetectorSpacing = 0x00190022;

    /** (0019,xx23) VR=DS VM=1 Detector Center */
    public static final int DetectorCenter = 0x00190023;

    /** (0019,xx24) VR=DS VM=1 Reading Integration Time */
    public static final int ReadingIntegrationTime = 0x00190024;

    /** (0019,xx50) VR=DS VM=1 Detector Alignment */
    public static final int DetectorAlignment = 0x00190050;

    /** (0019,xx52) VR=DS VM=1 ? */
    public static final int _0019_xx52_ = 0x00190052;

    /** (0019,xx54) VR=DS VM=1 ? */
    public static final int _0019_xx54_ = 0x00190054;

    /** (0019,xx60) VR=DS VM=1 Focus Alignment */
    public static final int FocusAlignment = 0x00190060;

    /** (0019,xx65) VR=UL VM=1 Focal Spot Deflection Amplitude */
    public static final int FocalSpotDeflectionAmplitude = 0x00190065;

    /** (0019,xx66) VR=UL VM=1 Focal Spot Deflection Phase */
    public static final int FocalSpotDeflectionPhase = 0x00190066;

    /** (0019,xx67) VR=UL VM=1 Focal Spot Deflection Offset */
    public static final int FocalSpotDeflectionOffset = 0x00190067;

    /** (0019,xx70) VR=DS VM=1 Water Scaling Factor */
    public static final int WaterScalingFactor = 0x00190070;

    /** (0019,xx71) VR=DS VM=1 Interpolation Factor */
    public static final int InterpolationFactor = 0x00190071;

    /** (0019,xx80) VR=CS VM=1 Patient Region */
    public static final int PatientRegion = 0x00190080;

    /** (0019,xx82) VR=CS VM=1 Patient Phase of Life */
    public static final int PatientPhaseOfLife = 0x00190082;

    /** (0019,xx90) VR=DS VM=1 Osteo Offset */
    public static final int OsteoOffset = 0x00190090;

    /** (0019,xx92) VR=DS VM=1 Osteo Regression Line Slope */
    public static final int OsteoRegressionLineSlope = 0x00190092;

    /** (0019,xx93) VR=DS VM=1 Osteo Regression Line Intercept */
    public static final int OsteoRegressionLineIntercept = 0x00190093;

    /** (0019,xx94) VR=IS VM=1 Osteo Standardization Code */
    public static final int OsteoStandardizationCode = 0x00190094;

    /** (0019,xx96) VR=IS VM=1 Osteo Phantom Number */
    public static final int OsteoPhantomNumber = 0x00190096;

    /** (0019,xxA0) VR=DS VM=1 ? */
    public static final int _0019_xxA0_ = 0x001900A0;

    /** (0019,xxA1) VR=DS VM=1 ? */
    public static final int _0019_xxA1_ = 0x001900A1;

    /** (0019,xxA2) VR=CS VM=1 ? */
    public static final int _0019_xxA2_ = 0x001900A2;

    /** (0019,xxA3) VR=CS VM=1 ? */
    public static final int _0019_xxA3_ = 0x001900A3;

    /** (0019,xxA4) VR=DS VM=1 ? */
    public static final int _0019_xxA4_ = 0x001900A4;

    /** (0019,xxA5) VR=DS VM=1 ? */
    public static final int _0019_xxA5_ = 0x001900A5;

    /** (0019,xxA6) VR=UL VM=1-n ? */
    public static final int _0019_xxA6_ = 0x001900A6;

    /** (0019,xxA7) VR=UL VM=1-n ? */
    public static final int _0019_xxA7_ = 0x001900A7;

    /** (0019,xxA8) VR=UL VM=1-n ? */
    public static final int _0019_xxA8_ = 0x001900A8;

    /** (0019,xxA9) VR=IS VM=1 ? */
    public static final int _0019_xxA9_ = 0x001900A9;

    /** (0019,xxAA) VR=CS VM=1 ? */
    public static final int _0019_xxAA_ = 0x001900AA;

    /** (0019,xxAB) VR=IS VM=1 ? */
    public static final int _0019_xxAB_ = 0x001900AB;

    /** (0019,xxAC) VR=IS VM=1 ? */
    public static final int _0019_xxAC_ = 0x001900AC;

    /** (0019,xxAD) VR=IS VM=1 ? */
    public static final int _0019_xxAD_ = 0x001900AD;

    /** (0019,xxAE) VR=IS VM=1 ? */
    public static final int _0019_xxAE_ = 0x001900AE;

    /** (0019,xxAF) VR=DS VM=1 ? */
    public static final int _0019_xxAF_ = 0x001900AF;

    /** (0019,xxB0) VR=DS VM=1 Feed per Rotation */
    public static final int FeedPerRotation = 0x001900B0;

    /** (0019,xxB1) VR=LO VM=1 ? */
    public static final int _0019_xxB1_ = 0x001900B1;

    /** (0019,xxBD) VR=IS VM=1 Pulmo Trigger Level */
    public static final int PulmoTriggerLevel = 0x001900BD;

    /** (0019,xxBE) VR=DS VM=1 Expiratoric Reserve Volume */
    public static final int ExpiratoricReserveVolume = 0x001900BE;

    /** (0019,xxBF) VR=DS VM=1 Vital Capacity */
    public static final int VitalCapacity = 0x001900BF;

    /** (0019,xxC0) VR=DS VM=1 Pulmo Water */
    public static final int PulmoWater = 0x001900C0;

    /** (0019,xxC1) VR=DS VM=1 Pulmo Air */
    public static final int PulmoAir = 0x001900C1;

    /** (0019,xxC2) VR=DA VM=1 Pulmo Date */
    public static final int PulmoDate = 0x001900C2;

    /** (0019,xxC3) VR=TM VM=1 Pulmo Time */
    public static final int PulmoTime = 0x001900C3;

    /** (0019,xxC4) VR=UL VM=1 ? */
    public static final int _0019_xxC4_ = 0x001900C4;

    /** (0019,xxC5) VR=IS VM=1 ? */
    public static final int _0019_xxC5_ = 0x001900C5;

}
