/*
 ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~
 ~                                                                               ~
 ~ The MIT License (MIT)                                                         ~
 ~                                                                               ~
 ~ Copyright (c) 2015-2025 miaixz.org and other contributors.                    ~
 ~                                                                               ~
 ~ Permission is hereby granted, free of charge, to any person obtaining a copy  ~
 ~ of this software and associated documentation files (the "Software"), to deal ~
 ~ in the Software without restriction, including without limitation the rights  ~
 ~ to use, copy, modify, merge, publish, distribute, sublicense, and/or sell     ~
 ~ copies of the Software, and to permit persons to whom the Software is         ~
 ~ furnished to do so, subject to the following conditions:                      ~
 ~                                                                               ~
 ~ The above copyright notice and this permission notice shall be included in    ~
 ~ all copies or substantial portions of the Software.                           ~
 ~                                                                               ~
 ~ THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR    ~
 ~ IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,      ~
 ~ FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE   ~
 ~ AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER        ~
 ~ LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, ~
 ~ OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN     ~
 ~ THE SOFTWARE.                                                                 ~
 ~                                                                               ~
 ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~
*/
package org.miaixz.bus.image.galaxy.dict.SIEMENS_DFR_01_MANIPULATED;

/**
 * @author Kimi Liu
 * @since Java 17+
 */
public class PrivateTag {

    public static final String PrivateCreator = "SIEMENS DFR.01 MANIPULATED";

    /** (0017,xx11) VR=US VM=1 ? */
    public static final int _0017_xx11_ = 0x00170011;

    /** (0017,xx12) VR=US VM=1 ? */
    public static final int _0017_xx12_ = 0x00170012;

    /** (0017,xx14) VR=US VM=1 ? */
    public static final int _0017_xx14_ = 0x00170014;

    /** (0017,xx15) VR=US VM=1 ? */
    public static final int _0017_xx15_ = 0x00170015;

    /** (0017,xx25) VR=IS VM=1 ? */
    public static final int _0017_xx25_ = 0x00170025;

    /** (0017,xx27) VR=IS VM=1 ? */
    public static final int _0017_xx27_ = 0x00170027;

    /** (0017,xx29) VR=IS VM=1 Edge Enhancement */
    public static final int EdgeEnhancement = 0x00170029;

    /** (0017,xx30) VR=IS VM=1 Harmonization % */
    public static final int Harmonization = 0x00170030;

    /** (0017,xx31) VR=US VM=1 ? */
    public static final int _0017_xx31_ = 0x00170031;

    /** (0017,xx32) VR=US VM=1 ? */
    public static final int _0017_xx32_ = 0x00170032;

    /** (0017,xx33) VR=US VM=1 ? */
    public static final int _0017_xx33_ = 0x00170033;

    /** (0017,xx35) VR=US VM=1 ? */
    public static final int _0017_xx35_ = 0x00170035;

    /** (0017,xx37) VR=US VM=1 ? */
    public static final int _0017_xx37_ = 0x00170037;

    /** (0017,xx38) VR=US VM=1 ? */
    public static final int _0017_xx38_ = 0x00170038;

    /** (0017,xx71) VR=IS VM=1 Landmark */
    public static final int Landmark = 0x00170071;

    /** (0017,xx72) VR=US VM=1 ? */
    public static final int _0017_xx72_ = 0x00170072;

    /** (0017,xx73) VR=US VM=1 ? */
    public static final int _0017_xx73_ = 0x00170073;

    /** (0017,xx74) VR=US VM=1 ? */
    public static final int _0017_xx74_ = 0x00170074;

    /** (0017,xx77) VR=DS VM=1 Pixel Shift horizonta */
    public static final int PixelShiftHorizontal = 0x00170077;

    /** (0017,xx78) VR=DS VM=1 Pixel Shift vertical */
    public static final int PixelShiftVertical = 0x00170078;

    /** (0017,xx79) VR=US VM=1 ? */
    public static final int _0017_xx79_ = 0x00170079;

    /** (0017,xx7A) VR=US VM=1 ? */
    public static final int _0017_xx7A_ = 0x0017007A;

    /** (0017,xx80) VR=US VM=1 ? */
    public static final int _0017_xx80_ = 0x00170080;

    /** (0017,xx83) VR=LO VM=1 Left Marker */
    public static final int LeftMarker = 0x00170083;

    /** (0017,xx84) VR=LO VM=1 Right Marker */
    public static final int RightMarker = 0x00170084;

    /** (0017,xxA1) VR=SH VM=1 ? */
    public static final int _0017_xxA1_ = 0x001700A1;

    /** (0017,xxA2) VR=SH VM=1 Image Name Extension 1 */
    public static final int ImageNameExtension1 = 0x001700A2;

    /** (0017,xxA3) VR=SH VM=1 Image Name Extension 2 */
    public static final int ImageNameExtension2 = 0x001700A3;

}
