/*
 ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~
 ~                                                                               ~
 ~ The MIT License (MIT)                                                         ~
 ~                                                                               ~
 ~ Copyright (c) 2015-2025 miaixz.org and other contributors.                    ~
 ~                                                                               ~
 ~ Permission is hereby granted, free of charge, to any person obtaining a copy  ~
 ~ of this software and associated documentation files (the "Software"), to deal ~
 ~ in the Software without restriction, including without limitation the rights  ~
 ~ to use, copy, modify, merge, publish, distribute, sublicense, and/or sell     ~
 ~ copies of the Software, and to permit persons to whom the Software is         ~
 ~ furnished to do so, subject to the following conditions:                      ~
 ~                                                                               ~
 ~ The above copyright notice and this permission notice shall be included in    ~
 ~ all copies or substantial portions of the Software.                           ~
 ~                                                                               ~
 ~ THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR    ~
 ~ IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,      ~
 ~ FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE   ~
 ~ AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER        ~
 ~ LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, ~
 ~ OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN     ~
 ~ THE SOFTWARE.                                                                 ~
 ~                                                                               ~
 ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~
*/
package org.miaixz.bus.image.galaxy.dict.SIEMENS_DLR_01;

/**
 * @author Kimi Liu
 * @since Java 17+
 */
public class PrivateTag {

    public static final String PrivateCreator = "SIEMENS DLR.01";

    /** (0019,xx10) VR=LO VM=1 Measurement Mode */
    public static final int MeasurementMode = 0x00190010;

    /** (0019,xx11) VR=LO VM=1 Image Type */
    public static final int ImageType = 0x00190011;

    /** (0019,xx15) VR=LO VM=1 Software Version */
    public static final int SoftwareVersion = 0x00190015;

    /** (0019,xx20) VR=LO VM=1 MPM Code */
    public static final int MPMCode = 0x00190020;

    /** (0019,xx21) VR=LO VM=1 Latitude */
    public static final int Latitude = 0x00190021;

    /** (0019,xx22) VR=LO VM=1 Sensitivity */
    public static final int Sensitivity = 0x00190022;

    /** (0019,xx23) VR=LO VM=1 EDR */
    public static final int EDR = 0x00190023;

    /** (0019,xx24) VR=LO VM=1 L Fix */
    public static final int LFix = 0x00190024;

    /** (0019,xx25) VR=LO VM=1 S Fix */
    public static final int SFix = 0x00190025;

    /** (0019,xx26) VR=LO VM=1 Preset Mode */
    public static final int PresetMode = 0x00190026;

    /** (0019,xx27) VR=LO VM=1 Region */
    public static final int Region = 0x00190027;

    /** (0019,xx28) VR=LO VM=1 Subregion */
    public static final int Subregion = 0x00190028;

    /** (0019,xx30) VR=LO VM=1 Orientation */
    public static final int Orientation = 0x00190030;

    /** (0019,xx31) VR=LO VM=1 Mark On Film */
    public static final int MarkOnFilm = 0x00190031;

    /** (0019,xx32) VR=LO VM=1 Rotation On DRC */
    public static final int RotationOnDRC = 0x00190032;

    /** (0019,xx40) VR=LO VM=1 Reader Type */
    public static final int ReaderType = 0x00190040;

    /** (0019,xx41) VR=LO VM=1 Sub Modality */
    public static final int SubModality = 0x00190041;

    /** (0019,xx42) VR=LO VM=1 Reader Serial Number */
    public static final int ReaderSerialNumber = 0x00190042;

    /** (0019,xx50) VR=LO VM=1 Cassette Scale */
    public static final int CassetteScale = 0x00190050;

    /** (0019,xx51) VR=LO VM=1 Cassette Matrix */
    public static final int CassetteMatrix = 0x00190051;

    /** (0019,xx52) VR=LO VM=1 Cassette Submatrix */
    public static final int CassetteSubmatrix = 0x00190052;

    /** (0019,xx53) VR=LO VM=1 Barcode */
    public static final int Barcode = 0x00190053;

    /** (0019,xx60) VR=LO VM=1 GT - Contrast Type */
    public static final int ContrastType = 0x00190060;

    /** (0019,xx61) VR=LO VM=1 GA - Rotation Amount */
    public static final int RotationAmount = 0x00190061;

    /** (0019,xx62) VR=LO VM=1 GC - Rotation Center */
    public static final int RotationCenter = 0x00190062;

    /** (0019,xx63) VR=LO VM=1 GS - Density Shift */
    public static final int DensityShift = 0x00190063;

    /** (0019,xx64) VR=US VM=1 RN - Frequency Rank */
    public static final int FrequencyRank = 0x00190064;

    /** (0019,xx65) VR=LO VM=1 RE - Frequency Enhancement */
    public static final int FrequencyEnhancement = 0x00190065;

    /** (0019,xx66) VR=LO VM=1 RT - Frequency Type */
    public static final int FrequencyType = 0x00190066;

    /** (0019,xx67) VR=LO VM=1 Kernel Length */
    public static final int KernelLength = 0x00190067;

    /** (0019,xx68) VR=UL VM=1 Kernel Mode */
    public static final int KernelMode = 0x00190068;

    /** (0019,xx69) VR=UL VM=1 Convolution Mode */
    public static final int ConvolutionMode = 0x00190069;

    /** (0019,xx70) VR=LO VM=1 PLA Source */
    public static final int PLASource = 0x00190070;

    /** (0019,xx71) VR=LO VM=1 PLA Destination */
    public static final int PLADestination = 0x00190071;

    /** (0019,xx75) VR=LO VM=1 UID Original Image */
    public static final int UIDOriginalImage = 0x00190075;

    /** (0019,xx76) VR=LO VM=1 ? */
    public static final int _0019_xx76_ = 0x00190076;

    /** (0019,xx80) VR=LT VM=1 Reader Header */
    public static final int ReaderHeader = 0x00190080;

    /** (0019,xx90) VR=LO VM=1 PLA of Secondary Destination */
    public static final int PLAOfSecondaryDestination = 0x00190090;

    /** (0019,xxA0) VR=DS VM=1 ? */
    public static final int _0019_xxA0_ = 0x001900A0;

    /** (0019,xxA1) VR=DS VM=1 ? */
    public static final int _0019_xxA1_ = 0x001900A1;

    /** (0041,xx10) VR=US VM=1 Number of Hardcopies */
    public static final int NumberOfHardcopies = 0x00410010;

    /** (0041,xx20) VR=LO VM=1 Film Format */
    public static final int FilmFormat = 0x00410020;

    /** (0041,xx30) VR=LO VM=1 Film Size */
    public static final int FilmSize = 0x00410030;

    /** (0041,xx31) VR=LO VM=1 Full Film Format */
    public static final int FullFilmFormat = 0x00410031;

}
