/*
 ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~
 ~                                                                               ~
 ~ The MIT License (MIT)                                                         ~
 ~                                                                               ~
 ~ Copyright (c) 2015-2025 miaixz.org and other contributors.                    ~
 ~                                                                               ~
 ~ Permission is hereby granted, free of charge, to any person obtaining a copy  ~
 ~ of this software and associated documentation files (the "Software"), to deal ~
 ~ in the Software without restriction, including without limitation the rights  ~
 ~ to use, copy, modify, merge, publish, distribute, sublicense, and/or sell     ~
 ~ copies of the Software, and to permit persons to whom the Software is         ~
 ~ furnished to do so, subject to the following conditions:                      ~
 ~                                                                               ~
 ~ The above copyright notice and this permission notice shall be included in    ~
 ~ all copies or substantial portions of the Software.                           ~
 ~                                                                               ~
 ~ THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR    ~
 ~ IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,      ~
 ~ FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE   ~
 ~ AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER        ~
 ~ LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, ~
 ~ OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN     ~
 ~ THE SOFTWARE.                                                                 ~
 ~                                                                               ~
 ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~
*/
package org.miaixz.bus.image.galaxy.dict.SIEMENS_MED_SMS_USG_ANTARES_3D_VOLUME;

/**
 * @author Kimi Liu
 * @since Java 17+
 */
public class PrivateTag {

    public static final String PrivateCreator = "SIEMENS MED SMS USG ANTARES 3D VOLUME";

    /** (0039,xx00) VR=UN VM=1 Release Version */
    public static final int ReleaseVersion = 0x00390000;

    /** (0039,xx03) VR=UN VM=1 Volume Acquisition Duration */
    public static final int VolumeAcquisitionDuration = 0x00390003;

    /** (0039,xx04) VR=UN VM=1 Volume Raw Data Type */
    public static final int VolumeRawDataType = 0x00390004;

    /** (0039,xx05) VR=UN VM=1 Scan Type */
    public static final int ScanType = 0x00390005;

    /** (0039,xx06) VR=UN VM=1 Z Lateral Min */
    public static final int ZlateralMin = 0x00390006;

    /** (0039,xx07) VR=UN VM=1 Z Lateral Span */
    public static final int ZlateralSpan = 0x00390007;

    /** (0039,xx08) VR=UN VM=1 Z Radius of Curvature */
    public static final int ZRadiusOfCurvature = 0x00390008;

    /** (0039,xx09) VR=UN VM=1 Wobble Correction */
    public static final int WobbleCorrection = 0x00390009;

    /** (0039,xx10) VR=UN VM=1 Scale Along Width */
    public static final int ScaleAlongWidth = 0x00390010;

    /** (0039,xx11) VR=UN VM=1 Scale Along Height */
    public static final int ScaleAlongHeight = 0x00390011;

    /** (0039,xx12) VR=UN VM=1 Scale Along Depth */
    public static final int ScaleAlongDepth = 0x00390012;

    /** (0039,xx13) VR=UN VM=1 Buffer Size */
    public static final int BufferSize = 0x00390013;

    /** (0039,xx14) VR=UN VM=1 Acquisition Rate */
    public static final int AcquisitionRate = 0x00390014;

    /** (0039,xx15) VR=UN VM=1 Depth Min cm */
    public static final int DepthMinCm = 0x00390015;

    /** (0039,xx16) VR=UN VM=1 Is Left Right Flipped Enabled */
    public static final int IsLeftRightFlippedEn = 0x00390016;

    /** (0039,xx17) VR=UN VM=1 Is Up Down Flipped Enabled */
    public static final int IsUpDownFlippedEn = 0x00390017;

    /** (0039,xx18) VR=UN VM=1 Is Volume Geom Accurate */
    public static final int IsVolumeGeomAccurate = 0x00390018;

    /** (0039,xx19) VR=UN VM=1 BByte Mask Offset */
    public static final int BByteMaskOffset = 0x00390019;

    /** (0039,xx20) VR=UN VM=1 BByte Mask Size */
    public static final int BByteMaskSize = 0x00390020;

    /** (0039,xx22) VR=UN VM=1 Acq Plane Rotation Deg */
    public static final int AcqPlaneRotationDeg = 0x00390022;

    /** (0039,xx23) VR=UN VM=1 Beam Axial Span */
    public static final int BeamAxialSpan = 0x00390023;

    /** (0039,xx24) VR=UN VM=1 Beam Lateral Min */
    public static final int BeamLateralMin = 0x00390024;

    /** (0039,xx25) VR=UN VM=1 Beam Lateral Span */
    public static final int BeamLateralSpan = 0x00390025;

    /** (0039,xx26) VR=UN VM=1 Beam Axial Min */
    public static final int BeamAxialMin = 0x00390026;

    /** (0039,xx27) VR=UN VM=1 Num Display Samples */
    public static final int NumDisplaySamples = 0x00390027;

    /** (0039,xx28) VR=UN VM=1 DVolume Width */
    public static final int DVolumeWidth = 0x00390028;

    /** (0039,xx29) VR=UN VM=1 DVolume Depth */
    public static final int DVolumeDepth = 0x00390029;

    /** (0039,xx30) VR=UN VM=1 DVolume Height */
    public static final int DVolumeHeight = 0x00390030;

    /** (0039,xx31) VR=UN VM=1 DVolume Pos X */
    public static final int DVolumePosX = 0x00390031;

    /** (0039,xx32) VR=UN VM=1 DVolume Pos Y */
    public static final int DVolumePosY = 0x00390032;

    /** (0039,xx33) VR=UN VM=1 DVolume Pos Z */
    public static final int DVolumePosZ = 0x00390033;

    /** (0039,xx34) VR=UN VM=1 DBeam Axial Min */
    public static final int DBeamAxialMin = 0x00390034;

    /** (0039,xx35) VR=UN VM=1 DBeam Axial Span */
    public static final int DBeamAxialSpan = 0x00390035;

    /** (0039,xx37) VR=UN VM=1 DBeam Lateral Span */
    public static final int DBeamLateralSpan = 0x00390037;

    /** (0039,xx38) VR=UN VM=1 Number of Volumes in Sequence */
    public static final int NumOfVolumesInSequence = 0x00390038;

    /** (0039,xx39) VR=UN VM=1 DByte Mask Offset */
    public static final int DByteMaskOffset = 0x00390039;

    /** (0039,xx40) VR=UN VM=1 DByte Mask Size */
    public static final int DByteMaskSize = 0x00390040;

    /** (0039,xx50) VR=LO VM=1 Private Creator Version of Bookmark */
    public static final int PrivateCreatorVersionOfBookmark = 0x00390050;

    /** (0039,xx51) VR=US VM=1 BCut Plane Enable */
    public static final int BCutPlaneEnable = 0x00390051;

    /** (0039,xx52) VR=US VM=1 BMpr Color Map Index */
    public static final int BMprColorMapIndex = 0x00390052;

    /** (0039,xx53) VR=US VM=1 BMpr Dynamic Range Db */
    public static final int BMprDynamicRangeDb = 0x00390053;

    /** (0039,xx54) VR=US VM=1 BMpr Gray Map Index */
    public static final int BMprGrayMapIndex = 0x00390054;

    /** (0039,xx55) VR=US VM=1 BVolume Render Mode */
    public static final int BVolumeRenderMode = 0x00390055;

    /** (0039,xx56) VR=US VM=1 BVr Brightness */
    public static final int BVrBrightness = 0x00390056;

    /** (0039,xx57) VR=US VM=1 BVr Contrast */
    public static final int BVrContrast = 0x00390057;

    /** (0039,xx58) VR=US VM=1 BVr Color Map Index */
    public static final int BVrColorMapIndex = 0x00390058;

    /** (0039,xx59) VR=US VM=1 BVr Dynamic Range Db */
    public static final int BVrDynamicRangeDb = 0x00390059;

    /** (0039,xx5A) VR=US VM=1 BVr Gray Map Index */
    public static final int BVrGrayMapIndex = 0x0039005A;

    /** (0039,xx5C) VR=US VM=1 BVr Threshold High */
    public static final int BVrThresholdHigh = 0x0039005C;

    /** (0039,xx5D) VR=US VM=1 BVr Threshold Low */
    public static final int BVrThresholdLow = 0x0039005D;

    /** (0039,xx5E) VR=US VM=1 BPre Process Filter Mix */
    public static final int BPreProcessFilterMix = 0x0039005E;

    /** (0039,xx5F) VR=US VM=1 CCut Plane Enable */
    public static final int CCutPlaneEnable = 0x0039005F;

    /** (0039,xx60) VR=US VM=1 CFront Clip Mode */
    public static final int CFrontClipMode = 0x00390060;

    /** (0039,xx61) VR=US VM=1 CMpr Color Map Index */
    public static final int CMprColorMapIndex = 0x00390061;

    /** (0039,xx62) VR=US VM=1 CMpr Color Flow Priority Index */
    public static final int CMprColorFlowPriorityIndex = 0x00390062;

    /** (0039,xx63) VR=US VM=1 CVolume Render Mode */
    public static final int CVolumeRenderMode = 0x00390063;

    /** (0039,xx64) VR=US VM=1 CVr Color Map Index */
    public static final int CVrColorMapIndex = 0x00390064;

    /** (0039,xx65) VR=US VM=1 CVr Color Flow Priority Index */
    public static final int CVrColorFlowPriorityIndex = 0x00390065;

    /** (0039,xx66) VR=US VM=1 CVr Opacity */
    public static final int CVrOpacity = 0x00390066;

    /** (0039,xx67) VR=US VM=1 CVr Threshold High */
    public static final int CVrThresholdHigh = 0x00390067;

    /** (0039,xx68) VR=US VM=1 CVr Threshold Low */
    public static final int CVrThresholdLow = 0x00390068;

    /** (0039,xx69) VR=US VM=1 Voi Mode */
    public static final int VoiMode = 0x00390069;

    /** (0039,xx6A) VR=US VM=1 Voi Rotation Offset Deg */
    public static final int VoiRotationOffsetDeg = 0x0039006A;

    /** (0039,xx6B) VR=FD VM=1 Voi Size Ratio X */
    public static final int VoiSizeRatioX = 0x0039006B;

    /** (0039,xx6C) VR=FD VM=1 Voi Size Ratio Y */
    public static final int VoiSizeRatioY = 0x0039006C;

    /** (0039,xx6D) VR=FD VM=1 Voi Size Ratio Z */
    public static final int VoiSizeRatioZ = 0x0039006D;

    /** (0039,xx6E) VR=US VM=1 Voi Sync Plane */
    public static final int VoiSyncPlane = 0x0039006E;

    /** (0039,xx6F) VR=US VM=1 Voi View Mode */
    public static final int VoiViewMode = 0x0039006F;

    /** (0039,xx70) VR=FD VM=1-n Vr Orientation A */
    public static final int VrOrientationA = 0x00390070;

    /** (0039,xx71) VR=FD VM=1-n Mpr Orientation A */
    public static final int MprOrientationA = 0x00390071;

    /** (0039,xx72) VR=FD VM=1 Vr Offset Vector */
    public static final int VrOffsetVector = 0x00390072;

    /** (0039,xx73) VR=FD VM=1 Blending Ratio */
    public static final int BlendingRatio = 0x00390073;

    /** (0039,xx74) VR=US VM=1 Fusion Blend Mode */
    public static final int FusionBlendMode = 0x00390074;

    /** (0039,xx75) VR=FD VM=1 Quality Factor */
    public static final int QualityFactor = 0x00390075;

    /** (0039,xx76) VR=US VM=1 Renderer Type */
    public static final int RendererType = 0x00390076;

    /** (0039,xx77) VR=US VM=1 Slice Mode */
    public static final int SliceMode = 0x00390077;

    /** (0039,xx78) VR=US VM=1 Active Quad */
    public static final int ActiveQuad = 0x00390078;

    /** (0039,xx79) VR=US VM=1 Screen Mode */
    public static final int ScreenMode = 0x00390079;

    /** (0039,xx7A) VR=US VM=1 Cut Plane Side */
    public static final int CutPlaneSide = 0x0039007A;

    /** (0039,xx7B) VR=US VM=1 Wireframe Mode */
    public static final int WireframeMode = 0x0039007B;

    /** (0039,xx7C) VR=US VM=1 Crossmark Mode */
    public static final int CrossmarkMode = 0x0039007C;

    /** (0039,xx7D) VR=US VM=1 Mpr Display Type */
    public static final int MprDisplayType = 0x0039007D;

    /** (0039,xx7E) VR=US VM=1 Volume Display Type */
    public static final int VolumeDisplayType = 0x0039007E;

    /** (0039,xx7F) VR=US VM=1 Last Reset */
    public static final int LastReset = 0x0039007F;

    /** (0039,xx80) VR=US VM=1 Last Non Full Screen Mode */
    public static final int LastNonFullScreenMode = 0x00390080;

    /** (0039,xx81) VR=US VM=1 Mpr Tool Index */
    public static final int MprToolIndex = 0x00390081;

    /** (0039,xx82) VR=US VM=1 Voi Tool Index */
    public static final int VoiToolIndex = 0x00390082;

    /** (0039,xx83) VR=US VM=1 Tool Loop Mode */
    public static final int ToolLoopMode = 0x00390083;

    /** (0039,xx84) VR=US VM=1 Volume Arb Mode */
    public static final int VolumeArbMode = 0x00390084;

    /** (0039,xx85) VR=US VM=1 Mpr Zoom Enabled */
    public static final int MprZoomEn = 0x00390085;

    /** (0039,xx86) VR=US VM=1 Is Volume Zoom Enabled */
    public static final int IsVolumeZoomEn = 0x00390086;

    /** (0039,xx87) VR=SS VM=1 Zoom Level Mpr */
    public static final int ZoomLevelMpr = 0x00390087;

    /** (0039,xx88) VR=SS VM=1 Zoom Level Volume */
    public static final int ZoomLevelVolume = 0x00390088;

    /** (0039,xx89) VR=US VM=1 Is Auto Rotate Enabled */
    public static final int IsAutoRotateEn = 0x00390089;

    /** (0039,xx8A) VR=US VM=1 Auto Rotate Axis */
    public static final int AutoRotateAxis = 0x0039008A;

    /** (0039,xx8B) VR=US VM=1 Auto Rotate Range Index */
    public static final int AutoRotateRangeIndex = 0x0039008B;

    /** (0039,xx8C) VR=US VM=1 Auto Rotate Speed Index */
    public static final int AutoRotateSpeedIndex = 0x0039008C;

    /** (0039,xx8D) VR=US VM=1 CVr Brightness */
    public static final int CVrBrightness = 0x0039008D;

    /** (0039,xx8E) VR=US VM=1 CFlow State Index */
    public static final int CFlowStateIndex = 0x0039008E;

    /** (0039,xx8F) VR=US VM=1 BSubmode Index */
    public static final int BSubmodeIndex = 0x0039008F;

    /** (0039,xx90) VR=US VM=1 CSubmode Index */
    public static final int CSubmodeIndex = 0x00390090;

    /** (0039,xx91) VR=US VM=1 Cut Plane */
    public static final int CutPlane = 0x00390091;

    /** (0039,xx92) VR=US VM=1 Bookmark Chunk Id */
    public static final int BookmarkChunkId = 0x00390092;

    /** (0039,xx93) VR=US VM=1 Sequence Min Chunk Id */
    public static final int SequenceMinChunkId = 0x00390093;

    /** (0039,xx94) VR=US VM=1 Sequence Max Chunk Id */
    public static final int SequenceMaxChunkId = 0x00390094;

    /** (0039,xx95) VR=FD VM=1 Volume Rate Hz */
    public static final int VolumeRateHz = 0x00390095;

    /** (0039,xx9A) VR=FD VM=1 Voi Position Offset X */
    public static final int VoiPositionOffsetX = 0x0039009A;

    /** (0039,xx9B) VR=FD VM=1 Voi Position Offset Y */
    public static final int VoiPositionOffsetY = 0x0039009B;

    /** (0039,xx9C) VR=FD VM=1 Voi Position Offset Z */
    public static final int VoiPositionOffsetZ = 0x0039009C;

    /** (0039,xx9D) VR=US VM=1 Vr Tool Index */
    public static final int VrToolIndex = 0x0039009D;

    /** (0039,xx9E) VR=US VM=1 Shading Percent */
    public static final int ShadingPercent = 0x0039009E;

    /** (0039,xx9F) VR=US VM=1 Volume Type */
    public static final int VolumeType = 0x0039009F;

    /** (0039,xxA0) VR=US VM=1 Vr Quad Display Type */
    public static final int VrQuadDisplayType = 0x003900A0;

    /** (0039,xxA1) VR=FD VM=1-n Mpr Center Location */
    public static final int MprCenterLocation = 0x003900A1;

    /** (0039,xxE0) VR=US VM=1 Slice Range Type */
    public static final int SliceRangeType = 0x003900E0;

    /** (0039,xxE1) VR=US VM=1 Slice MPR Plane */
    public static final int SliceMPRPlane = 0x003900E1;

    /** (0039,xxE2) VR=US VM=1 Slice Layout */
    public static final int SliceLayout = 0x003900E2;

    /** (0039,xxE3) VR=FD VM=1 Slice Spacing */
    public static final int SliceSpacing = 0x003900E3;

    /** (0039,xxE4) VR=US VM=1 Thin Vr Mode */
    public static final int ThinVrMode = 0x003900E4;

    /** (0039,xxE5) VR=US VM=1 Thin Vr Thickness */
    public static final int ThinVrThickness = 0x003900E5;

    /** (0039,xxE6) VR=FD VM=1 Curved TOP VOI Pivot X */
    public static final int VoiPivotX = 0x003900E6;

    /** (0039,xxE7) VR=FD VM=1 Curved TOP VOI Pivot Y */
    public static final int VoiPivotY = 0x003900E7;

    /** (0039,xxE8) VR=FD VM=1 Curved TOP VOI Pivot Z */
    public static final int VoiPivotZ = 0x003900E8;

    /** (0039,xxE9) VR=US VM=1 Curved TOP VOI Quadrant */
    public static final int CTopVoiQuad = 0x003900E9;

    /** (0039,xxEA) VR=US VM=1 ? */
    public static final int _0039_xxEA_ = 0x003900EA;

    /** (0039,xxED) VR=US VM=1 ? */
    public static final int _0039_xxED_ = 0x003900ED;

    /** (0039,xxEE) VR=US VM=1 ? */
    public static final int _0039_xxEE_ = 0x003900EE;

    /** (0039,xxEF) VR=US VM=1 ? */
    public static final int _0039_xxEF_ = 0x003900EF;

    /** (0039,xxF0) VR=US VM=1-n ? */
    public static final int _0039_xxF0_ = 0x003900F0;

    /** (0039,xxF1) VR=US VM=1 ? */
    public static final int _0039_xxF1_ = 0x003900F1;

    /** (0039,xxF2) VR=US VM=1 ? */
    public static final int _0039_xxF2_ = 0x003900F2;

    /** (0039,xxF3) VR=US VM=1 ? */
    public static final int _0039_xxF3_ = 0x003900F3;

    /** (0039,xxF4) VR=FD VM=1 ? */
    public static final int _0039_xxF4_ = 0x003900F4;

    /** (0039,xxF5) VR=LO VM=1 ? */
    public static final int _0039_xxF5_ = 0x003900F5;

    /** (0039,xxF6) VR=LT VM=1 ? */
    public static final int _0039_xxF6_ = 0x003900F6;

}
