/*
 ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~
 ~                                                                               ~
 ~ The MIT License (MIT)                                                         ~
 ~                                                                               ~
 ~ Copyright (c) 2015-2025 miaixz.org and other contributors.                    ~
 ~                                                                               ~
 ~ Permission is hereby granted, free of charge, to any person obtaining a copy  ~
 ~ of this software and associated documentation files (the "Software"), to deal ~
 ~ in the Software without restriction, including without limitation the rights  ~
 ~ to use, copy, modify, merge, publish, distribute, sublicense, and/or sell     ~
 ~ copies of the Software, and to permit persons to whom the Software is         ~
 ~ furnished to do so, subject to the following conditions:                      ~
 ~                                                                               ~
 ~ The above copyright notice and this permission notice shall be included in    ~
 ~ all copies or substantial portions of the Software.                           ~
 ~                                                                               ~
 ~ THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR    ~
 ~ IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,      ~
 ~ FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE   ~
 ~ AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER        ~
 ~ LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, ~
 ~ OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN     ~
 ~ THE SOFTWARE.                                                                 ~
 ~                                                                               ~
 ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~
*/
package org.miaixz.bus.image.galaxy.dict.SIEMENS_SMS_AX__VIEW_1_0;

/**
 * @author Kimi Liu
 * @since Java 17+
 */
public class PrivateKeyword {

    public static final String PrivateCreator = "";

    public static String valueOf(int tag) {

        switch (tag & 0xFFFF00FF) {
            case PrivateTag.ReviewMode:
                return "ReviewMode";

            case PrivateTag.AnatomicalBackgroundPercent:
                return "AnatomicalBackgroundPercent";

            case PrivateTag.NumberOfPhases:
                return "NumberOfPhases";

            case PrivateTag.ApplyAnatomicalBackground:
                return "ApplyAnatomicalBackground";

            case PrivateTag.PixelShiftArray:
                return "PixelShiftArray";

            case PrivateTag.Brightness:
                return "Brightness";

            case PrivateTag.Contrast:
                return "Contrast";

            case PrivateTag.EnabledShutters:
                return "EnabledShutters";

            case PrivateTag.NativeEdgeEnhancementPercentGain:
                return "NativeEdgeEnhancementPercentGain";

            case PrivateTag.NativeEdgeEnhancementLUTIndex:
                return "NativeEdgeEnhancementLUTIndex";

            case PrivateTag.NativeEdgeEnhancementKernelSize:
                return "NativeEdgeEnhancementKernelSize";

            case PrivateTag.SubtractedEdgeEnhancementPercentGain:
                return "SubtractedEdgeEnhancementPercentGain";

            case PrivateTag.SubtractedEdgeEnhancementLUTIndex:
                return "SubtractedEdgeEnhancementLUTIndex";

            case PrivateTag.SubtractedEdgeEnhancementKernelSize:
                return "SubtractedEdgeEnhancementKernelSize";

            case PrivateTag.FadePercent:
                return "FadePercent";

            case PrivateTag.FlippedBeforeLateralityApplied:
                return "FlippedBeforeLateralityApplied";

            case PrivateTag.ApplyFade:
                return "ApplyFade";

            case PrivateTag.ReferenceImagesTakenFlag:
                return "ReferenceImagesTakenFlag";

            case PrivateTag.Zoom:
                return "Zoom";

            case PrivateTag.PanX:
                return "PanX";

            case PrivateTag.PanY:
                return "PanY";

            case PrivateTag.NativeEdgeEnhancementAdvPercentGain:
                return "NativeEdgeEnhancementAdvPercentGain";

            case PrivateTag.SubtractedEdgeEnhancementAdvPercentGain:
                return "SubtractedEdgeEnhancementAdvPercentGain";

            case PrivateTag.InvertFlag:
                return "InvertFlag";

            case PrivateTag.Quant1KOverlay:
                return "Quant1KOverlay";

            case PrivateTag.OriginalResolution:
                return "OriginalResolution";

            case PrivateTag.AutoWindowCenter:
                return "AutoWindowCenter";

            case PrivateTag.AutoWindowWidth:
                return "AutoWindowWidth";

            case PrivateTag.AutoWindowCorrectValue:
                return "AutoWindowCorrectValue";

            case PrivateTag.SigmoidWindowParameter:
                return "SigmoidWindowParameter";

            case PrivateTag.DispayedAreaTopLeftHandCorner:
                return "DispayedAreaTopLeftHandCorner";

            case PrivateTag.DispayedAreaBottomRightHandCorner:
                return "DispayedAreaBottomRightHandCorner";
        }
        return "";
    }

}
