/*
 ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~
 ~                                                                               ~
 ~ The MIT License (MIT)                                                         ~
 ~                                                                               ~
 ~ Copyright (c) 2015-2025 miaixz.org and other contributors.                    ~
 ~                                                                               ~
 ~ Permission is hereby granted, free of charge, to any person obtaining a copy  ~
 ~ of this software and associated documentation files (the "Software"), to deal ~
 ~ in the Software without restriction, including without limitation the rights  ~
 ~ to use, copy, modify, merge, publish, distribute, sublicense, and/or sell     ~
 ~ copies of the Software, and to permit persons to whom the Software is         ~
 ~ furnished to do so, subject to the following conditions:                      ~
 ~                                                                               ~
 ~ The above copyright notice and this permission notice shall be included in    ~
 ~ all copies or substantial portions of the Software.                           ~
 ~                                                                               ~
 ~ THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR    ~
 ~ IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,      ~
 ~ FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE   ~
 ~ AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER        ~
 ~ LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, ~
 ~ OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN     ~
 ~ THE SOFTWARE.                                                                 ~
 ~                                                                               ~
 ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~
*/
package org.miaixz.bus.image.galaxy.dict.SIEMENS_SYNGO_ADVANCED_PRESENTATION;

/**
 * @author Kimi Liu
 * @since Java 17+
 */
public class PrivateKeyword {

    public static final String PrivateCreator = "";

    public static String valueOf(int tag) {

        switch (tag & 0xFFFF00FF) {
            case PrivateTag.PresentationName:
                return "PresentationName";

            case PrivateTag.PresentationType:
                return "PresentationType";

            case PrivateTag.AdvancedPresentationSequence:
                return "AdvancedPresentationSequence";

            case PrivateTag.TimePointSequence:
                return "TimePointSequence";

            case PrivateTag.BaseImageSequence:
                return "BaseImageSequence";

            case PrivateTag.OverlayImageSequence:
                return "OverlayImageSequence";

            case PrivateTag.RegistrationInstanceSequence:
                return "RegistrationInstanceSequence";

            case PrivateTag.RealWorldValueMappingInstanceSequence:
                return "RealWorldValueMappingInstanceSequence";

            case PrivateTag.MeasurementSequence:
                return "MeasurementSequence";

            case PrivateTag.MeasurementUID:
                return "MeasurementUID";

            case PrivateTag.SegmentationSequence:
                return "SegmentationSequence";

            case PrivateTag.SegmentationUID:
                return "SegmentationUID";

            case PrivateTag.NavigationSequence:
                return "NavigationSequence";

            case PrivateTag.NavigationName:
                return "NavigationName";

            case PrivateTag.AutoNavigationDirection:
                return "AutoNavigationDirection";

            case PrivateTag.AutoNavigationFrameRate:
                return "AutoNavigationFrameRate";

            case PrivateTag.AutoNavigationMode:
                return "AutoNavigationMode";

            case PrivateTag.AutoNavigationRealtimeSpeed:
                return "AutoNavigationRealtimeSpeed";

            case PrivateTag.AutoNavigationStrategy:
                return "AutoNavigationStrategy";

            case PrivateTag.AutoNavigationRealtimeFlag:
                return "AutoNavigationRealtimeFlag";

            case PrivateTag.IndexNavigationCurrentIndex:
                return "IndexNavigationCurrentIndex";

            case PrivateTag.IndexAutoNavigationSkippingDegree:
                return "IndexAutoNavigationSkippingDegree";

            case PrivateTag.VolumeNavigationMinimumPixelSpacing:
                return "VolumeNavigationMinimumPixelSpacing";

            case PrivateTag.VolumeNavigationScrollUnit:
                return "VolumeNavigationScrollUnit";

            case PrivateTag.VolumeNavigationStepSize:
                return "VolumeNavigationStepSize";

            case PrivateTag.VolumeNavigationJumpSize:
                return "VolumeNavigationJumpSize";

            case PrivateTag.ReferencedRegistrationNumber:
                return "ReferencedRegistrationNumber";

            case PrivateTag.RealWorldValueMappingUID:
                return "RealWorldValueMappingUID";

            case PrivateTag.ChannelAlphaValue:
                return "ChannelAlphaValue";

            case PrivateTag.MeasurementApplicationName:
                return "MeasurementApplicationName";

            case PrivateTag.MeasurementDataSequence:
                return "MeasurementDataSequence";

            case PrivateTag.MeasurementType:
                return "MeasurementType";

            case PrivateTag.MeasurementFrameOfReferenceUID:
                return "MeasurementFrameOfReferenceUID";

            case PrivateTag.MeasurementUid:
                return "MeasurementUid";

            case PrivateTag.MeasurementApplicationNumber:
                return "MeasurementApplicationNumber";

            case PrivateTag.MeasurementApplicationNumberPrefixText:
                return "MeasurementApplicationNumberPrefixText";

            case PrivateTag.MeasurementGraphicIsVisibleFlag:
                return "MeasurementGraphicIsVisibleFlag";

            case PrivateTag.ReferencedSyngoUID:
                return "ReferencedSyngoUID";

            case PrivateTag.ClinicalFindingUID:
                return "ClinicalFindingUID";

            case PrivateTag.MeasurementEvaluationStringValue:
                return "MeasurementEvaluationStringValue";

            case PrivateTag.MeasurementEvaluationIntegerValue:
                return "MeasurementEvaluationIntegerValue";

            case PrivateTag.MeasurementEvaluationDecimalValue:
                return "MeasurementEvaluationDecimalValue";

            case PrivateTag.MeasurementLineShowCenterFlag:
                return "MeasurementLineShowCenterFlag";

            case PrivateTag.MeasurementAngleShowArrowTipFlag:
                return "MeasurementAngleShowArrowTipFlag";

            case PrivateTag.CameraHomeSettingsSequence:
                return "CameraHomeSettingsSequence";

            case PrivateTag.CameraZoom:
                return "CameraZoom";

            case PrivateTag.CameraPosition:
                return "CameraPosition";

            case PrivateTag.CameraOrientation:
                return "CameraOrientation";

            case PrivateTag.CameraFarClipPlane:
                return "CameraFarClipPlane";

            case PrivateTag.CameraNearClipPlane:
                return "CameraNearClipPlane";

            case PrivateTag.CameraThickness:
                return "CameraThickness";

            case PrivateTag.CameraViewPortSize:
                return "CameraViewPortSize";

            case PrivateTag.CameraAspectRatio:
                return "CameraAspectRatio";

            case PrivateTag.CameraProjectionType:
                return "CameraProjectionType";

            case PrivateTag.CameraFieldOfView:
                return "CameraFieldOfView";

            case PrivateTag.CameraImagePlaneDistance:
                return "CameraImagePlaneDistance";

            case PrivateTag.CameraImageMaximumHeight:
                return "CameraImageMaximumHeight";

            case PrivateTag.CameraImageMinimumHeight:
                return "CameraImageMinimumHeight";

            case PrivateTag.ParallelShiftIntervalMM:
                return "ParallelShiftIntervalMM";

            case PrivateTag.ParallelShiftBoundingBoxMinimum:
                return "ParallelShiftBoundingBoxMinimum";

            case PrivateTag.ParallelShiftBoundingBoxMaximum:
                return "ParallelShiftBoundingBoxMaximum";

            case PrivateTag.RendererVertexIsCharacteristicFlag:
                return "RendererVertexIsCharacteristicFlag";

            case PrivateTag.RendererThicknessUsageFlag:
                return "RendererThicknessUsageFlag";

            case PrivateTag.RendererThreshold:
                return "RendererThreshold";

            case PrivateTag.RendererMaterial:
                return "RendererMaterial";

            case PrivateTag.RendererDirectionalLightColor:
                return "RendererDirectionalLightColor";

            case PrivateTag.RendererDirectionalLightDirection:
                return "RendererDirectionalLightDirection";

            case PrivateTag.RendererDirectionalLightTwoSideUsageFlag:
                return "RendererDirectionalLightTwoSideUsageFlag";

            case PrivateTag.RendererPWLTransferFunctionSequence:
                return "RendererPWLTransferFunctionSequence";

            case PrivateTag.RendererPWLVertexIndex:
                return "RendererPWLVertexIndex";

            case PrivateTag.RendererPWLVertexColor:
                return "RendererPWLVertexColor";

            case PrivateTag.RendererIsCameraRequiredFlag:
                return "RendererIsCameraRequiredFlag";

            case PrivateTag.RendererDoDepthTestFlag:
                return "RendererDoDepthTestFlag";

            case PrivateTag.RendererDirectionalLightUsageFlag:
                return "RendererDirectionalLightUsageFlag";

            case PrivateTag.RendererThicknessSequence:
                return "RendererThicknessSequence";

            case PrivateTag.RendererSliceSpacingSequence:
                return "RendererSliceSpacingSequence";

            case PrivateTag.RendererSamplingDistance:
                return "RendererSamplingDistance";

            case PrivateTag.RendererInitialSamplingDistance:
                return "RendererInitialSamplingDistance";

            case PrivateTag.SegmentationDisplayDataSequence:
                return "SegmentationDisplayDataSequence";

            case PrivateTag.SegmentationDisplayDataUID:
                return "SegmentationDisplayDataUID";

            case PrivateTag.SegmentationDisplayParameterSequence:
                return "SegmentationDisplayParameterSequence";

            case PrivateTag.SegmentationDisplayParameterType:
                return "SegmentationDisplayParameterType";

            case PrivateTag.SegmentationDisplayVisibility:
                return "SegmentationDisplayVisibility";

            case PrivateTag.SegmentationDisplayColor:
                return "SegmentationDisplayColor";

            case PrivateTag.SegmentationDisplayIsSelectedFlag:
                return "SegmentationDisplayIsSelectedFlag";

            case PrivateTag.SegmentationAdditionalInformationBlob:
                return "SegmentationAdditionalInformationBlob";

            case PrivateTag.HashCodeValue:
                return "HashCodeValue";

            case PrivateTag.SegmentationVersionIdentifier:
                return "SegmentationVersionIdentifier";

            case PrivateTag.SegmentationVolumeSize:
                return "SegmentationVolumeSize";

            case PrivateTag.RegistrationReferencedFrames:
                return "RegistrationReferencedFrames";

            case PrivateTag.RegistrationReferencedRegistrations:
                return "RegistrationReferencedRegistrations";

            case PrivateTag.RegistrationCreationAlgorithmName:
                return "RegistrationCreationAlgorithmName";

            case PrivateTag.ECGGraphicType:
                return "ECGGraphicType";

            case PrivateTag.SegmentationVolumeStorageDataType:
                return "SegmentationVolumeStorageDataType";

            case PrivateTag.SegmentationVolumeModelMatrix:
                return "SegmentationVolumeModelMatrix";

            case PrivateTag.CameraRotationAxis:
                return "CameraRotationAxis";

            case PrivateTag.OverlayHiddenDisplayAttributes:
                return "OverlayHiddenDisplayAttributes";

            case PrivateTag.PresentationStateGroupIdentifier:
                return "PresentationStateGroupIdentifier";

            case PrivateTag.TemporarySmallestImagePixelValue:
                return "TemporarySmallestImagePixelValue";

            case PrivateTag.CameraRotationCenter:
                return "CameraRotationCenter";

            case PrivateTag.CameraRotationCenterUsageFlag:
                return "CameraRotationCenterUsageFlag";

            case PrivateTag.CameraParallelEpiped:
                return "CameraParallelEpiped";

            case PrivateTag.CameraMaxZoomInFactor:
                return "CameraMaxZoomInFactor";

            case PrivateTag.CameraMinZoomInFactor:
                return "CameraMinZoomInFactor";

            case PrivateTag.TemporaryLargestImagePixelValue:
                return "TemporaryLargestImagePixelValue";

            case PrivateTag.CameraRotationAxisUsageFlag:
                return "CameraRotationAxisUsageFlag";

            case PrivateTag.MeasurementSurfaceNormal:
                return "MeasurementSurfaceNormal";

            case PrivateTag.MeasurementEllipsoidModelMatrix:
                return "MeasurementEllipsoidModelMatrix";

            case PrivateTag.MeasurementEvaluationDataRoleID:
                return "MeasurementEvaluationDataRoleID";

            case PrivateTag.MeasurementAlgorithmType:
                return "MeasurementAlgorithmType";

            case PrivateTag.MeasurementEvaluationDataRoleSequence:
                return "MeasurementEvaluationDataRoleSequence";

            case PrivateTag.MeasurementEvaluationDataRoleItem:
                return "MeasurementEvaluationDataRoleItem";

            case PrivateTag.MeasurementEvaluationSequence:
                return "MeasurementEvaluationSequence";

            case PrivateTag.MeasurementEvaluationValue:
                return "MeasurementEvaluationValue";

            case PrivateTag.MeasurementEvaluationID:
                return "MeasurementEvaluationID";

            case PrivateTag.MeasurementDataPoints:
                return "MeasurementDataPoints";

            case PrivateTag.MeasurementDataAngles:
                return "MeasurementDataAngles";

            case PrivateTag.MeasurementDataSlice:
                return "MeasurementDataSlice";

            case PrivateTag.MeasurementDataSliceThickness:
                return "MeasurementDataSliceThickness";

            case PrivateTag.MeasurementReferencedFramesSequence:
                return "MeasurementReferencedFramesSequence";

            case PrivateTag.MeasurementEvaluationLongestDistance:
                return "MeasurementEvaluationLongestDistance";

            case PrivateTag.MeasurementEvaluationCentroid:
                return "MeasurementEvaluationCentroid";

            case PrivateTag.MeasurementDataBoundingBox:
                return "MeasurementDataBoundingBox";

            case PrivateTag.MeasurementText:
                return "MeasurementText";

            case PrivateTag.MeasurementDiameter:
                return "MeasurementDiameter";

            case PrivateTag.ImageRotationFractional:
                return "ImageRotationFractional";

            case PrivateTag.PresetName:
                return "PresetName";

            case PrivateTag.FusionLUTSequence:
                return "FusionLUTSequence";

            case PrivateTag.FusionLUTIsActiveFlag:
                return "FusionLUTIsActiveFlag";

            case PrivateTag.SyngoUID:
                return "SyngoUID";

            case PrivateTag.PresentationVersionIdentifier:
                return "PresentationVersionIdentifier";

            case PrivateTag.PresentationModuleSequence:
                return "PresentationModuleSequence";

            case PrivateTag.PresentationModuleType:
                return "PresentationModuleType";

            case PrivateTag.PresentationStateSequence:
                return "PresentationStateSequence";

            case PrivateTag.LUTInvertedFlag:
                return "LUTInvertedFlag";

            case PrivateTag.SoftcopyVOILUTViewingIndex:
                return "SoftcopyVOILUTViewingIndex";

            case PrivateTag.DisplayedAreaBottomRightHandCornerFractional:
                return "DisplayedAreaBottomRightHandCornerFractional";

            case PrivateTag.DisplayedAreaTopLeftHandCornerFractional:
                return "DisplayedAreaTopLeftHandCornerFractional";

            case PrivateTag.MeasurementAlpha:
                return "MeasurementAlpha";

            case PrivateTag.MeasurementBitmap:
                return "MeasurementBitmap";

            case PrivateTag.CurrentFrameNumber:
                return "CurrentFrameNumber";

            case PrivateTag.ImageTextViewName:
                return "ImageTextViewName";

            case PrivateTag.ImageTextViewContentSequence:
                return "ImageTextViewContentSequence";

            case PrivateTag.ImageTextLineNames:
                return "ImageTextLineNames";

            case PrivateTag.ImageTextLineValues:
                return "ImageTextLineValues";

            case PrivateTag._0029_xxB5_:
                return "_0029_xxB5_";

            case PrivateTag.MeasurementLinkEvaluationTextFlag:
                return "MeasurementLinkEvaluationTextFlag";

            case PrivateTag.MeasurementEvaluationTextPositionVector:
                return "MeasurementEvaluationTextPositionVector";

            case PrivateTag.ImageTextAlphaBlendingLineValue:
                return "ImageTextAlphaBlendingLineValue";

            case PrivateTag.TaskDataSequence:
                return "TaskDataSequence";

            case PrivateTag.TaskDataType:
                return "TaskDataType";

            case PrivateTag.TaskDataVersion:
                return "TaskDataVersion";

            case PrivateTag.TaskDataDescription:
                return "TaskDataDescription";

            case PrivateTag.TaskData:
                return "TaskData";

            case PrivateTag.TaskDataSize:
                return "TaskDataSize";

            case PrivateTag.ClipPlaneSequence:
                return "ClipPlaneSequence";

            case PrivateTag.ClipPlaneCenter:
                return "ClipPlaneCenter";

            case PrivateTag.ClipPlaneNormal:
                return "ClipPlaneNormal";

            case PrivateTag.ClipPlaneScale:
                return "ClipPlaneScale";

            case PrivateTag.ClipPlaneUseThicknessFlag:
                return "ClipPlaneUseThicknessFlag";

            case PrivateTag.ClipPlaneThickness:
                return "ClipPlaneThickness";

            case PrivateTag.ImageSequence:
                return "ImageSequence";

            case PrivateTag.ClipPlaneEnableClip:
                return "ClipPlaneEnableClip";

            case PrivateTag.ClipPlaneHandleRatio:
                return "ClipPlaneHandleRatio";

            case PrivateTag.ClipPlaneBoundingPoints:
                return "ClipPlaneBoundingPoints";

            case PrivateTag.ClipPlaneMotionMatrix:
                return "ClipPlaneMotionMatrix";

            case PrivateTag.ClipPlaneShiftVelocity:
                return "ClipPlaneShiftVelocity";

            case PrivateTag.ClipPlaneEnabledFlag:
                return "ClipPlaneEnabledFlag";

            case PrivateTag.ClipPlaneRotateVelocity:
                return "ClipPlaneRotateVelocity";

            case PrivateTag.ClipPlaneShowGraphicsFlag:
                return "ClipPlaneShowGraphicsFlag";

            case PrivateTag.CropBoxSize:
                return "CropBoxSize";

            case PrivateTag.CropBoxEnabledFlag:
                return "CropBoxEnabledFlag";

            case PrivateTag.CropBoxAbsoluteOrigin:
                return "CropBoxAbsoluteOrigin";

            case PrivateTag.CropBoxShowGraphicsFlag:
                return "CropBoxShowGraphicsFlag";

            case PrivateTag.CurvedCameraCoordinates:
                return "CurvedCameraCoordinates";

            case PrivateTag.CurvedCameraPointOfInterest:
                return "CurvedCameraPointOfInterest";

            case PrivateTag.CurvedCameraPointOfInterestUsageFlag:
                return "CurvedCameraPointOfInterestUsageFlag";

            case PrivateTag.CurvedCameraThickness:
                return "CurvedCameraThickness";

            case PrivateTag.CurvedCameraExtrusionLength:
                return "CurvedCameraExtrusionLength";

            case PrivateTag.CurvedCameraRotationAxisMode:
                return "CurvedCameraRotationAxisMode";

            case PrivateTag.CurvedCameraRollRotationAxis:
                return "CurvedCameraRollRotationAxis";

            case PrivateTag.CurvedCameraViewPortHeight:
                return "CurvedCameraViewPortHeight";

            case PrivateTag.CurvedCameraCutDirection:
                return "CurvedCameraCutDirection";

            case PrivateTag.CurvedCameraPanVector:
                return "CurvedCameraPanVector";

            case PrivateTag.ClinicalFindingID:
                return "ClinicalFindingID";

            case PrivateTag.MeasurementIsCircleFlag:
                return "MeasurementIsCircleFlag";

            case PrivateTag.MeasurementApplicationTypeID:
                return "MeasurementApplicationTypeID";
        }
        return "";
    }

}
