/*
 ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~
 ~                                                                               ~
 ~ The MIT License (MIT)                                                         ~
 ~                                                                               ~
 ~ Copyright (c) 2015-2025 miaixz.org and other contributors.                    ~
 ~                                                                               ~
 ~ Permission is hereby granted, free of charge, to any person obtaining a copy  ~
 ~ of this software and associated documentation files (the "Software"), to deal ~
 ~ in the Software without restriction, including without limitation the rights  ~
 ~ to use, copy, modify, merge, publish, distribute, sublicense, and/or sell     ~
 ~ copies of the Software, and to permit persons to whom the Software is         ~
 ~ furnished to do so, subject to the following conditions:                      ~
 ~                                                                               ~
 ~ The above copyright notice and this permission notice shall be included in    ~
 ~ all copies or substantial portions of the Software.                           ~
 ~                                                                               ~
 ~ THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR    ~
 ~ IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,      ~
 ~ FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE   ~
 ~ AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER        ~
 ~ LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, ~
 ~ OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN     ~
 ~ THE SOFTWARE.                                                                 ~
 ~                                                                               ~
 ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~
*/
package org.miaixz.bus.image.galaxy.dict.agfa_adc_nx;

/**
 * @author Kimi Liu
 * @since Java 17+
 */
public class PrivateTag {

    public static final String PrivateCreator = "Agfa ADC NX";

    /** (0019,xx07) VR=CS VM=1 ? */
    public static final int _0019_xx07_ = 0x00190007;

    /** (0019,xx09) VR=SQ VM=1 ? */
    public static final int _0019_xx09_ = 0x00190009;

    /** (0019,xx21) VR=FL VM=1 ? */
    public static final int _0019_xx21_ = 0x00190021;

    /** (0019,xx28) VR=CS VM=1 ? */
    public static final int _0019_xx28_ = 0x00190028;

    /** (0019,xxF0) VR=LO VM=1 User Defined field 1 */
    public static final int UserDefinedField1 = 0x001900F0;

    /** (0019,xxF1) VR=LO VM=1 User Defined field 2 */
    public static final int UserDefinedField2 = 0x001900F1;

    /** (0019,xxF2) VR=LO VM=1 User Defined field 3 */
    public static final int UserDefinedField3 = 0x001900F2;

    /** (0019,xxF3) VR=LO VM=1 User Defined field 4 */
    public static final int UserDefinedField4 = 0x001900F3;

    /** (0019,xxF4) VR=LO VM=1 User Defined field 5 */
    public static final int UserDefinedField5 = 0x001900F4;

    /** (0019,xxF5) VR=CS VM=1 Cassette Orientation */
    public static final int CassetteOrientation = 0x001900F5;

    /** (0019,xxF6) VR=DS VM=1 Plate Sensitivity */
    public static final int PlateSensitivity = 0x001900F6;

    /** (0019,xxF7) VR=DS VM=1 Plate Erasability */
    public static final int PlateErasability = 0x001900F7;

    /** (0019,xxF8) VR=IS VM=1 ? */
    public static final int _0019_xxF8_ = 0x001900F8;

    /** (0019,xxFA) VR=IS VM=1 ? */
    public static final int _0019_xxFA_ = 0x001900FA;

    /** (0019,xxFC) VR=IS VM=1 ? */
    public static final int _0019_xxFC_ = 0x001900FC;

    /** (0019,xxFD) VR=CS VM=1 ? */
    public static final int _0019_xxFD_ = 0x001900FD;

    /** (0019,xxFE) VR=CS VM=1 ? */
    public static final int _0019_xxFE_ = 0x001900FE;

}
