/*
 ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~
 ~                                                                               ~
 ~ The MIT License (MIT)                                                         ~
 ~                                                                               ~
 ~ Copyright (c) 2015-2025 miaixz.org and other contributors.                    ~
 ~                                                                               ~
 ~ Permission is hereby granted, free of charge, to any person obtaining a copy  ~
 ~ of this software and associated documentation files (the "Software"), to deal ~
 ~ in the Software without restriction, including without limitation the rights  ~
 ~ to use, copy, modify, merge, publish, distribute, sublicense, and/or sell     ~
 ~ copies of the Software, and to permit persons to whom the Software is         ~
 ~ furnished to do so, subject to the following conditions:                      ~
 ~                                                                               ~
 ~ The above copyright notice and this permission notice shall be included in    ~
 ~ all copies or substantial portions of the Software.                           ~
 ~                                                                               ~
 ~ THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR    ~
 ~ IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,      ~
 ~ FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE   ~
 ~ AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER        ~
 ~ LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, ~
 ~ OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN     ~
 ~ THE SOFTWARE.                                                                 ~
 ~                                                                               ~
 ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~
*/
package org.miaixz.bus.image.galaxy.dict.elscint;

/**
 * @author Kimi Liu
 * @since Java 17+
 */
public class PrivateKeyword {

    public static final String PrivateCreator = "";

    public static String valueOf(int tag) {

        switch (tag & 0xFFFF00FF) {
            case PrivateTag.OffsetListStructure:
                return "OffsetListStructure";

            case PrivateTag.DataDictionaryVersion:
                return "DataDictionaryVersion";

            case PrivateTag._00E1_xx05_:
                return "_00E1_xx05_";

            case PrivateTag._00E1_xx06_:
                return "_00E1_xx06_";

            case PrivateTag._00E1_xx07_:
                return "_00E1_xx07_";

            case PrivateTag._00E1_xx14_:
                return "_00E1_xx14_";

            case PrivateTag._00E1_xx18_:
                return "_00E1_xx18_";

            case PrivateTag.DLPTotal:
                return "DLPTotal";

            case PrivateTag.PresentationRelativeCenter:
                return "PresentationRelativeCenter";

            case PrivateTag.PresentationRelativePart:
                return "PresentationRelativePart";

            case PrivateTag.PresentationHorizontalInvert:
                return "PresentationHorizontalInvert";

            case PrivateTag.PresentationVerticalInvert:
                return "PresentationVerticalInvert";

            case PrivateTag._00E1_xx2A_:
                return "_00E1_xx2A_";

            case PrivateTag._00E1_xx30_:
                return "_00E1_xx30_";

            case PrivateTag._00E1_xx31_:
                return "_00E1_xx31_";

            case PrivateTag._00E1_xx32_:
                return "_00E1_xx32_";

            case PrivateTag.TotalDoseSavings:
                return "TotalDoseSavings";

            case PrivateTag._00E1_xx39_:
                return "_00E1_xx39_";

            case PrivateTag._00E1_xx3E_:
                return "_00E1_xx3E_";

            case PrivateTag._00E1_xx3F_:
                return "_00E1_xx3F_";

            case PrivateTag.ImageLabel:
                return "ImageLabel";

            case PrivateTag._00E1_xx41_:
                return "_00E1_xx41_";

            case PrivateTag._00E1_xx42_:
                return "_00E1_xx42_";

            case PrivateTag._00E1_xx43_:
                return "_00E1_xx43_";

            case PrivateTag.AcquisitionDuration:
                return "AcquisitionDuration";

            case PrivateTag.SeriesLabel:
                return "SeriesLabel";

            case PrivateTag._00E1_xx60_:
                return "_00E1_xx60_";

            case PrivateTag.ProtocolFileName:
                return "ProtocolFileName";

            case PrivateTag._00E1_xx62_:
                return "_00E1_xx62_";

            case PrivateTag.PatientLanguage:
                return "PatientLanguage";

            case PrivateTag.PatientDataModificationDate:
                return "PatientDataModificationDate";

            case PrivateTag._00E1_xx6A_:
                return "_00E1_xx6A_";

            case PrivateTag._00E1_xx6B_:
                return "_00E1_xx6B_";

            case PrivateTag._00E1_xxA0_:
                return "_00E1_xxA0_";

            case PrivateTag._00E1_xxC2_:
                return "_00E1_xxC2_";

            case PrivateTag._00E1_xxC4_:
                return "_00E1_xxC4_";

            case PrivateTag._00E1_xxCF_:
                return "_00E1_xxCF_";

            case PrivateTag._00E1_xxEB_:
                return "_00E1_xxEB_";

            case PrivateTag._00E1_xxEC_:
                return "_00E1_xxEC_";

            case PrivateTag._00E3_xx00_:
                return "_00E3_xx00_";

            case PrivateTag._00E3_xx18_:
                return "_00E3_xx18_";

            case PrivateTag._00E3_xx1F_:
                return "_00E3_xx1F_";

            case PrivateTag._01E1_xx18_:
                return "_01E1_xx18_";

            case PrivateTag._01E1_xx21_:
                return "_01E1_xx21_";

            case PrivateTag.PhantomType:
                return "PhantomType";

            case PrivateTag._01E1_xx34_:
                return "_01E1_xx34_";

            case PrivateTag._01E1_xx40_:
                return "_01E1_xx40_";

            case PrivateTag._01E1_xx41_:
                return "_01E1_xx41_";

            case PrivateTag.ReferenceSequence:
                return "ReferenceSequence";

            case PrivateTag.ReferenceType:
                return "ReferenceType";

            case PrivateTag.ReferenceLevel:
                return "ReferenceLevel";

            case PrivateTag.AcquisitionType:
                return "AcquisitionType";

            case PrivateTag.FocalSpotResolution:
                return "FocalSpotResolution";

            case PrivateTag.ConcurrentSlicesGeneration:
                return "ConcurrentSlicesGeneration";

            case PrivateTag.AngularSamplingDensity:
                return "AngularSamplingDensity";

            case PrivateTag.ReconstructionArc:
                return "ReconstructionArc";

            case PrivateTag._01F1_xx06_:
                return "_01F1_xx06_";

            case PrivateTag.TableVelocity:
                return "TableVelocity";

            case PrivateTag.AcquisitionLength:
                return "AcquisitionLength";

            case PrivateTag.EdgeEnhancementWeight:
                return "EdgeEnhancementWeight";

            case PrivateTag._01F1_xx0B_:
                return "_01F1_xx0B_";

            case PrivateTag.ScannerRelativeCenter:
                return "ScannerRelativeCenter";

            case PrivateTag.RotationAngle:
                return "RotationAngle";

            case PrivateTag._01F1_xx0E_:
                return "_01F1_xx0E_";

            case PrivateTag.Pitch:
                return "Pitch";

            case PrivateTag.RotationTime:
                return "RotationTime";

            case PrivateTag.TableIncrement:
                return "TableIncrement";

            case PrivateTag._01F1_xx30_:
                return "_01F1_xx30_";

            case PrivateTag.ImageViewConvention:
                return "ImageViewConvention";

            case PrivateTag.CycleTime:
                return "CycleTime";

            case PrivateTag._01F1_xx36_:
                return "_01F1_xx36_";

            case PrivateTag._01F1_xx37_:
                return "_01F1_xx37_";

            case PrivateTag._01F1_xx38_:
                return "_01F1_xx38_";

            case PrivateTag._01F1_xx39_:
                return "_01F1_xx39_";

            case PrivateTag._01F1_xx40_:
                return "_01F1_xx40_";

            case PrivateTag._01F1_xx42_:
                return "_01F1_xx42_";

            case PrivateTag._01F1_xx43_:
                return "_01F1_xx43_";

            case PrivateTag._01F1_xx44_:
                return "_01F1_xx44_";

            case PrivateTag._01F1_xx45_:
                return "_01F1_xx45_";

            case PrivateTag._01F1_xx46_:
                return "_01F1_xx46_";

            case PrivateTag._01F1_xx47_:
                return "_01F1_xx47_";

            case PrivateTag._01F1_xx49_:
                return "_01F1_xx49_";

            case PrivateTag._01F1_xx4A_:
                return "_01F1_xx4A_";

            case PrivateTag._01F1_xx4B_:
                return "_01F1_xx4B_";

            case PrivateTag._01F1_xx4C_:
                return "_01F1_xx4C_";

            case PrivateTag._01F1_xx4D_:
                return "_01F1_xx4D_";

            case PrivateTag._01F1_xx4E_:
                return "_01F1_xx4E_";

            case PrivateTag.DetectorsLayers:
                return "DetectorsLayers";

            case PrivateTag._01F1_xx53_:
                return "_01F1_xx53_";

            case PrivateTag._01F3_xx01_:
                return "_01F3_xx01_";

            case PrivateTag._01F3_xx02_:
                return "_01F3_xx02_";

            case PrivateTag._01F3_xx03_:
                return "_01F3_xx03_";

            case PrivateTag._01F3_xx04_:
                return "_01F3_xx04_";

            case PrivateTag.PSSequence:
                return "PSSequence";

            case PrivateTag._01F3_xx12_:
                return "_01F3_xx12_";

            case PrivateTag._01F3_xx13_:
                return "_01F3_xx13_";

            case PrivateTag._01F3_xx14_:
                return "_01F3_xx14_";

            case PrivateTag._01F3_xx15_:
                return "_01F3_xx15_";

            case PrivateTag._01F3_xx16_:
                return "_01F3_xx16_";

            case PrivateTag._01F3_xx17_:
                return "_01F3_xx17_";

            case PrivateTag._01F3_xx18_:
                return "_01F3_xx18_";

            case PrivateTag._01F3_xx19_:
                return "_01F3_xx19_";

            case PrivateTag._01F3_xx23_:
                return "_01F3_xx23_";

            case PrivateTag._01F3_xx24_:
                return "_01F3_xx24_";

            case PrivateTag._01F7_xx10_:
                return "_01F7_xx10_";

            case PrivateTag._01F7_xx11_:
                return "_01F7_xx11_";

            case PrivateTag._01F7_xx13_:
                return "_01F7_xx13_";

            case PrivateTag._01F7_xx14_:
                return "_01F7_xx14_";

            case PrivateTag._01F7_xx15_:
                return "_01F7_xx15_";

            case PrivateTag._01F7_xx16_:
                return "_01F7_xx16_";

            case PrivateTag._01F7_xx17_:
                return "_01F7_xx17_";

            case PrivateTag._01F7_xx18_:
                return "_01F7_xx18_";

            case PrivateTag._01F7_xx19_:
                return "_01F7_xx19_";

            case PrivateTag._01F7_xx1A_:
                return "_01F7_xx1A_";

            case PrivateTag._01F7_xx1B_:
                return "_01F7_xx1B_";

            case PrivateTag._01F7_xx1C_:
                return "_01F7_xx1C_";

            case PrivateTag._01F7_xx1E_:
                return "_01F7_xx1E_";

            case PrivateTag._01F7_xx1F_:
                return "_01F7_xx1F_";

            case PrivateTag._01F7_xx22_:
                return "_01F7_xx22_";

            case PrivateTag._01F7_xx23_:
                return "_01F7_xx23_";

            case PrivateTag._01F7_xx25_:
                return "_01F7_xx25_";

            case PrivateTag._01F7_xx26_:
                return "_01F7_xx26_";

            case PrivateTag._01F7_xx27_:
                return "_01F7_xx27_";

            case PrivateTag._01F7_xx28_:
                return "_01F7_xx28_";

            case PrivateTag._01F7_xx29_:
                return "_01F7_xx29_";

            case PrivateTag._01F7_xx2B_:
                return "_01F7_xx2B_";

            case PrivateTag._01F7_xx2C_:
                return "_01F7_xx2C_";

            case PrivateTag._01F7_xx2D_:
                return "_01F7_xx2D_";

            case PrivateTag._01F7_xx2E_:
                return "_01F7_xx2E_";

            case PrivateTag._01F7_xx30_:
                return "_01F7_xx30_";

            case PrivateTag._01F7_xx31_:
                return "_01F7_xx31_";

            case PrivateTag._01F7_xx5C_:
                return "_01F7_xx5C_";

            case PrivateTag._01F7_xx70_:
                return "_01F7_xx70_";

            case PrivateTag._01F7_xx73_:
                return "_01F7_xx73_";

            case PrivateTag._01F7_xx74_:
                return "_01F7_xx74_";

            case PrivateTag._01F7_xx75_:
                return "_01F7_xx75_";

            case PrivateTag._01F7_xx7F_:
                return "_01F7_xx7F_";

            case PrivateTag.iDoseLevel:
                return "iDoseLevel";

            case PrivateTag.keV:
                return "keV";

            case PrivateTag.SBIVersion:
                return "SBIVersion";

            case PrivateTag.SCCTEquivalent:
                return "SCCTEquivalent";

            case PrivateTag.ReferenceSBIType:
                return "ReferenceSBIType";

            case PrivateTag.BurnedSpectralAnnotations:
                return "BurnedSpectralAnnotations";

            case PrivateTag.HeadBody:
                return "HeadBody";

            case PrivateTag.SpectralLevel:
                return "SpectralLevel";

            case PrivateTag.SPFilter:
                return "SPFilter";

            case PrivateTag.AdaptiveFilter:
                return "AdaptiveFilter";

            case PrivateTag.ReconIncrement:
                return "ReconIncrement";

            case PrivateTag._01F9_xx08_:
                return "_01F9_xx08_";

            case PrivateTag._01F9_xx09_:
                return "_01F9_xx09_";

            case PrivateTag.ImplementationVersion:
                return "ImplementationVersion";

            case PrivateTag.RelativeTablePosition:
                return "RelativeTablePosition";

            case PrivateTag.RelativeTableHeight:
                return "RelativeTableHeight";

            case PrivateTag.SurviewDirection:
                return "SurviewDirection";

            case PrivateTag.SurviewLength:
                return "SurviewLength";

            case PrivateTag.ImageViewType:
                return "ImageViewType";

            case PrivateTag.BatchNumber:
                return "BatchNumber";

            case PrivateTag.BatchSize:
                return "BatchSize";

            case PrivateTag.BatchSliceNumber:
                return "BatchSliceNumber";

            case PrivateTag.NumberOfSeriesInStudy:
                return "NumberOfSeriesInStudy";

            case PrivateTag.NumberOfImagesInStudy:
                return "NumberOfImagesInStudy";

            case PrivateTag.LastUpdateTime:
                return "LastUpdateTime";

            case PrivateTag.LastUpdateDate:
                return "LastUpdateDate";

            case PrivateTag._07A1_xx07_:
                return "_07A1_xx07_";

            case PrivateTag._07A1_xx08_:
                return "_07A1_xx08_";

            case PrivateTag._07A1_xx09_:
                return "_07A1_xx09_";

            case PrivateTag.TamarCompressedPixelData:
                return "TamarCompressedPixelData";

            case PrivateTag._07A1_xx0C_:
                return "_07A1_xx0C_";

            case PrivateTag.TamarSoftwareVersion:
                return "TamarSoftwareVersion";

            case PrivateTag.TamarCompressionType:
                return "TamarCompressionType";

            case PrivateTag._07A1_xx12_:
                return "_07A1_xx12_";

            case PrivateTag._07A1_xx13_:
                return "_07A1_xx13_";

            case PrivateTag.ProtectionFlag:
                return "ProtectionFlag";

            case PrivateTag._07A1_xx16_:
                return "_07A1_xx16_";

            case PrivateTag._07A1_xx18_:
                return "_07A1_xx18_";

            case PrivateTag._07A1_xx19_:
                return "_07A1_xx19_";

            case PrivateTag._07A1_xx1C_:
                return "_07A1_xx1C_";

            case PrivateTag.TamarStudyStatus:
                return "TamarStudyStatus";

            case PrivateTag._07A1_xx2B_:
                return "_07A1_xx2B_";

            case PrivateTag.TamarSourceAE:
                return "TamarSourceAE";

            case PrivateTag._07A1_xx3D_:
                return "_07A1_xx3D_";

            case PrivateTag.TamarStudyBodyPart:
                return "TamarStudyBodyPart";

            case PrivateTag._07A1_xx42_:
                return "_07A1_xx42_";

            case PrivateTag.TamarStudyPriority:
                return "TamarStudyPriority";

            case PrivateTag._07A1_xx45_:
                return "_07A1_xx45_";

            case PrivateTag._07A1_xx47_:
                return "_07A1_xx47_";

            case PrivateTag._07A1_xx4A_:
                return "_07A1_xx4A_";

            case PrivateTag.TamarExcludeTagsList:
                return "TamarExcludeTagsList";

            case PrivateTag.TamarSiteID:
                return "TamarSiteID";

            case PrivateTag._07A1_xx56_:
                return "_07A1_xx56_";

            case PrivateTag.TamarStudyPublished:
                return "TamarStudyPublished";

            case PrivateTag.TamarStudyCreationDate:
                return "TamarStudyCreationDate";

            case PrivateTag.TamarStudyHasBookmark:
                return "TamarStudyHasBookmark";

            case PrivateTag._07A1_xx70_:
                return "_07A1_xx70_";

            case PrivateTag._07A1_xx71_:
                return "_07A1_xx71_";

            case PrivateTag.TamarSourceImageType:
                return "TamarSourceImageType";

            case PrivateTag._07A1_xx76_:
                return "_07A1_xx76_";

            case PrivateTag.TamarTranslateFlags:
                return "TamarTranslateFlags";

            case PrivateTag._07A1_xx87_:
                return "_07A1_xx87_";

            case PrivateTag._07A1_xx88_:
                return "_07A1_xx88_";

            case PrivateTag._07A1_xx8C_:
                return "_07A1_xx8C_";

            case PrivateTag._07A1_xx94_:
                return "_07A1_xx94_";

            case PrivateTag._07A1_xx96_:
                return "_07A1_xx96_";

            case PrivateTag._07A1_xx97_:
                return "_07A1_xx97_";

            case PrivateTag._07A1_xx98_:
                return "_07A1_xx98_";

            case PrivateTag._07A1_xx9F_:
                return "_07A1_xx9F_";

            case PrivateTag._07A1_xxC3_:
                return "_07A1_xxC3_";

            case PrivateTag.TamarExcludeTagsSize:
                return "TamarExcludeTagsSize";

            case PrivateTag.TamarExcludeTagsTotalSize:
                return "TamarExcludeTagsTotalSize";

            case PrivateTag.TamarIsHcffHeader:
                return "TamarIsHcffHeader";

            case PrivateTag._07A1_xxD0_:
                return "_07A1_xxD0_";

            case PrivateTag.TamarExeSoftwareVersion:
                return "TamarExeSoftwareVersion";

            case PrivateTag.TamarStudyHasStickyNote:
                return "TamarStudyHasStickyNote";

            case PrivateTag.TamarMpSavePr:
                return "TamarMpSavePr";

            case PrivateTag.TamarOriginalPrModality:
                return "TamarOriginalPrModality";

            case PrivateTag._07A3_xx09_:
                return "_07A3_xx09_";

            case PrivateTag.TamarOriginalCurveType:
                return "TamarOriginalCurveType";

            case PrivateTag.TamarOriginalCurveDesc:
                return "TamarOriginalCurveDesc";

            case PrivateTag._07A3_xx13_:
                return "_07A3_xx13_";

            case PrivateTag.TamarProcedureCode:
                return "TamarProcedureCode";

            case PrivateTag.TamarPatientLocation:
                return "TamarPatientLocation";

            case PrivateTag.TamarOrderStatus:
                return "TamarOrderStatus";

            case PrivateTag.TamarReadingPhysicianLastName:
                return "TamarReadingPhysicianLastName";

            case PrivateTag.TamarReadingPhysicianFirstName:
                return "TamarReadingPhysicianFirstName";

            case PrivateTag._07A3_xx1B_:
                return "_07A3_xx1B_";

            case PrivateTag.TamarSigningPhysicianLastName:
                return "TamarSigningPhysicianLastName";

            case PrivateTag.TamarSigningPhysicianFirstName:
                return "TamarSigningPhysicianFirstName";

            case PrivateTag.TamarSigningPhysicianID:
                return "TamarSigningPhysicianID";

            case PrivateTag._07A3_xx1F_:
                return "_07A3_xx1F_";

            case PrivateTag._07A3_xx22_:
                return "_07A3_xx22_";

            case PrivateTag.TamarMiscString5:
                return "TamarMiscString5";

            case PrivateTag._07A3_xx31_:
                return "_07A3_xx31_";

            case PrivateTag.TamarStudyAge:
                return "TamarStudyAge";

            case PrivateTag.TamarPanSideDetails:
                return "TamarPanSideDetails";

            case PrivateTag._07A3_xx53_:
                return "_07A3_xx53_";

            case PrivateTag._07A3_xx54_:
                return "_07A3_xx54_";

            case PrivateTag.TamarStudyHasMammoCad:
                return "TamarStudyHasMammoCad";

            case PrivateTag._07A3xx5C_:
                return "_07A3xx5C_";

            case PrivateTag.TamarNondicomAnnotations:
                return "TamarNondicomAnnotations";

            case PrivateTag.TamarNondicomAnnotationsSequence:
                return "TamarNondicomAnnotationsSequence";

            case PrivateTag._07A3_xx63_:
                return "_07A3_xx63_";

            case PrivateTag._07A3_xx64_:
                return "_07A3_xx64_";

            case PrivateTag._07A3_xx65_:
                return "_07A3_xx65_";

            case PrivateTag._07A3_xx66_:
                return "_07A3_xx66_";

            case PrivateTag._07A3_xx80_:
                return "_07A3_xx80_";

            case PrivateTag._07A3_xx8F_:
                return "_07A3_xx8F_";

            case PrivateTag._07A3_xx92_:
                return "_07A3_xx92_";

            case PrivateTag._07A3_xx93_:
                return "_07A3_xx93_";

            case PrivateTag.TamarIsDocType:
                return "TamarIsDocType";

            case PrivateTag.TamarStudyHasKeyImage:
                return "TamarStudyHasKeyImage";

            case PrivateTag._07A3_xx9F_:
                return "_07A3_xx9F_";

            case PrivateTag._07A3_xxB4_:
                return "_07A3_xxB4_";

            case PrivateTag.TamarKeySeriesIndication:
                return "TamarKeySeriesIndication";

            case PrivateTag.TamarStudyHasKeySeries:
                return "TamarStudyHasKeySeries";

            case PrivateTag.TamarGridTokenLoadSequence:
                return "TamarGridTokenLoadSequence";

            case PrivateTag.TamarGridTokenTargetGridName:
                return "TamarGridTokenTargetGridName";

            case PrivateTag.TamarGridTokenSpeed:
                return "TamarGridTokenSpeed";

            case PrivateTag.TamarGridTokenSecurity:
                return "TamarGridTokenSecurity";

            case PrivateTag.TamarGridTokenNextHost:
                return "TamarGridTokenNextHost";

            case PrivateTag.TamarGridTokenNextHostPort:
                return "TamarGridTokenNextHostPort";

            case PrivateTag.TamarGridTokenQuerySequence:
                return "TamarGridTokenQuerySequence";

            case PrivateTag.TamarGridTokenAE:
                return "TamarGridTokenAE";

            case PrivateTag.TamarGridTokenTunneled:
                return "TamarGridTokenTunneled";

            case PrivateTag.TamarGridTokenArchiveSequence:
                return "TamarGridTokenArchiveSequence";

            case PrivateTag.TamarGridTokenLocationSequence:
                return "TamarGridTokenLocationSequence";

            case PrivateTag.TamarGridTokenVersion:
                return "TamarGridTokenVersion";

            case PrivateTag.TamarOriginalNestedElementsSequence:
                return "TamarOriginalNestedElementsSequence";

            case PrivateTag.TamarNestedElementNumber:
                return "TamarNestedElementNumber";

            case PrivateTag.TamarNestedTextLineVisibility:
                return "TamarNestedTextLineVisibility";

            case PrivateTag.TamarNestedTextDefaultLocation:
                return "TamarNestedTextDefaultLocation";

            case PrivateTag.TamarNestedTextLocationX:
                return "TamarNestedTextLocationX";

            case PrivateTag.TamarNestedTextLocationY:
                return "TamarNestedTextLocationY";

            case PrivateTag.TamarNestedTypeOfData:
                return "TamarNestedTypeOfData";

            case PrivateTag._07A3_xxE3_:
                return "_07A3_xxE3_";

            case PrivateTag._07A3_xxF2_:
                return "_07A3_xxF2_";

            case PrivateTag._07A3_xxF5_:
                return "_07A3_xxF5_";

            case PrivateTag._07A3_xxFA_:
                return "_07A3_xxFA_";

            case PrivateTag._07A3_xxFB_:
                return "_07A3_xxFB_";

            case PrivateTag._07A5_xx00_:
                return "_07A5_xx00_";

            case PrivateTag.TamarReportsUpdateDate:
                return "TamarReportsUpdateDate";

            case PrivateTag.TamarReferringPhysiciansStudyRead:
                return "TamarReferringPhysiciansStudyRead";

            case PrivateTag._07A5_xx59_:
                return "_07A5_xx59_";

            case PrivateTag.TamarStudyInstitutionName:
                return "TamarStudyInstitutionName";

            case PrivateTag._07A5_xx63_:
                return "_07A5_xx63_";

            case PrivateTag.TamarOriginalStoringAE:
                return "TamarOriginalStoringAE";

            case PrivateTag._07A5_xxAE_:
                return "_07A5_xxAE_";

            case PrivateTag._07A5_xxC8_:
                return "_07A5_xxC8_";

            case PrivateTag._5001_xx19_:
                return "_5001_xx19_";

            case PrivateTag._5001_xx70_:
                return "_5001_xx70_";

            case PrivateTag._5001_xx71_:
                return "_5001_xx71_";

            case PrivateTag._5003_xx19_:
                return "_5003_xx19_";

            case PrivateTag._5005_xx10_:
                return "_5005_xx10_";

            case PrivateTag._5005_xx19_:
                return "_5005_xx19_";

            case PrivateTag.TextOverlayFlag:
                return "TextOverlayFlag";

            case PrivateTag._6001_xx30_:
                return "_6001_xx30_";

            case PrivateTag._6001_xx90_:
                return "_6001_xx90_";

            case PrivateTag._7FDF_xxF0_:
                return "_7FDF_xxF0_";

            case PrivateTag._7FDF_xxFF_:
                return "_7FDF_xxFF_";
        }
        return "";
    }

}
