/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v1beta1

import (
	v1beta1 "github.com/rook/rook/pkg/apis/ceph.rook.io/v1beta1"
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
)

// FilesystemLister helps list Filesystems.
type FilesystemLister interface {
	// List lists all Filesystems in the indexer.
	List(selector labels.Selector) (ret []*v1beta1.Filesystem, err error)
	// Filesystems returns an object that can list and get Filesystems.
	Filesystems(namespace string) FilesystemNamespaceLister
	FilesystemListerExpansion
}

// filesystemLister implements the FilesystemLister interface.
type filesystemLister struct {
	indexer cache.Indexer
}

// NewFilesystemLister returns a new FilesystemLister.
func NewFilesystemLister(indexer cache.Indexer) FilesystemLister {
	return &filesystemLister{indexer: indexer}
}

// List lists all Filesystems in the indexer.
func (s *filesystemLister) List(selector labels.Selector) (ret []*v1beta1.Filesystem, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v1beta1.Filesystem))
	})
	return ret, err
}

// Filesystems returns an object that can list and get Filesystems.
func (s *filesystemLister) Filesystems(namespace string) FilesystemNamespaceLister {
	return filesystemNamespaceLister{indexer: s.indexer, namespace: namespace}
}

// FilesystemNamespaceLister helps list and get Filesystems.
type FilesystemNamespaceLister interface {
	// List lists all Filesystems in the indexer for a given namespace.
	List(selector labels.Selector) (ret []*v1beta1.Filesystem, err error)
	// Get retrieves the Filesystem from the indexer for a given namespace and name.
	Get(name string) (*v1beta1.Filesystem, error)
	FilesystemNamespaceListerExpansion
}

// filesystemNamespaceLister implements the FilesystemNamespaceLister
// interface.
type filesystemNamespaceLister struct {
	indexer   cache.Indexer
	namespace string
}

// List lists all Filesystems in the indexer for a given namespace.
func (s filesystemNamespaceLister) List(selector labels.Selector) (ret []*v1beta1.Filesystem, err error) {
	err = cache.ListAllByNamespace(s.indexer, s.namespace, selector, func(m interface{}) {
		ret = append(ret, m.(*v1beta1.Filesystem))
	})
	return ret, err
}

// Get retrieves the Filesystem from the indexer for a given namespace and name.
func (s filesystemNamespaceLister) Get(name string) (*v1beta1.Filesystem, error) {
	obj, exists, err := s.indexer.GetByKey(s.namespace + "/" + name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v1beta1.Resource("filesystem"), name)
	}
	return obj.(*v1beta1.Filesystem), nil
}
