/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v1beta1

import (
	v1beta1 "github.com/rook/rook/pkg/apis/ceph.rook.io/v1beta1"
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
)

// ObjectStoreUserLister helps list ObjectStoreUsers.
type ObjectStoreUserLister interface {
	// List lists all ObjectStoreUsers in the indexer.
	List(selector labels.Selector) (ret []*v1beta1.ObjectStoreUser, err error)
	// ObjectStoreUsers returns an object that can list and get ObjectStoreUsers.
	ObjectStoreUsers(namespace string) ObjectStoreUserNamespaceLister
	ObjectStoreUserListerExpansion
}

// objectStoreUserLister implements the ObjectStoreUserLister interface.
type objectStoreUserLister struct {
	indexer cache.Indexer
}

// NewObjectStoreUserLister returns a new ObjectStoreUserLister.
func NewObjectStoreUserLister(indexer cache.Indexer) ObjectStoreUserLister {
	return &objectStoreUserLister{indexer: indexer}
}

// List lists all ObjectStoreUsers in the indexer.
func (s *objectStoreUserLister) List(selector labels.Selector) (ret []*v1beta1.ObjectStoreUser, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v1beta1.ObjectStoreUser))
	})
	return ret, err
}

// ObjectStoreUsers returns an object that can list and get ObjectStoreUsers.
func (s *objectStoreUserLister) ObjectStoreUsers(namespace string) ObjectStoreUserNamespaceLister {
	return objectStoreUserNamespaceLister{indexer: s.indexer, namespace: namespace}
}

// ObjectStoreUserNamespaceLister helps list and get ObjectStoreUsers.
type ObjectStoreUserNamespaceLister interface {
	// List lists all ObjectStoreUsers in the indexer for a given namespace.
	List(selector labels.Selector) (ret []*v1beta1.ObjectStoreUser, err error)
	// Get retrieves the ObjectStoreUser from the indexer for a given namespace and name.
	Get(name string) (*v1beta1.ObjectStoreUser, error)
	ObjectStoreUserNamespaceListerExpansion
}

// objectStoreUserNamespaceLister implements the ObjectStoreUserNamespaceLister
// interface.
type objectStoreUserNamespaceLister struct {
	indexer   cache.Indexer
	namespace string
}

// List lists all ObjectStoreUsers in the indexer for a given namespace.
func (s objectStoreUserNamespaceLister) List(selector labels.Selector) (ret []*v1beta1.ObjectStoreUser, err error) {
	err = cache.ListAllByNamespace(s.indexer, s.namespace, selector, func(m interface{}) {
		ret = append(ret, m.(*v1beta1.ObjectStoreUser))
	})
	return ret, err
}

// Get retrieves the ObjectStoreUser from the indexer for a given namespace and name.
func (s objectStoreUserNamespaceLister) Get(name string) (*v1beta1.ObjectStoreUser, error) {
	obj, exists, err := s.indexer.GetByKey(s.namespace + "/" + name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v1beta1.Resource("objectstoreuser"), name)
	}
	return obj.(*v1beta1.ObjectStoreUser), nil
}
