/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v1beta1

import (
	v1beta1 "github.com/rook/rook/pkg/apis/edgefs.rook.io/v1beta1"
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
)

// ISCSILister helps list ISCSIs.
type ISCSILister interface {
	// List lists all ISCSIs in the indexer.
	List(selector labels.Selector) (ret []*v1beta1.ISCSI, err error)
	// ISCSIs returns an object that can list and get ISCSIs.
	ISCSIs(namespace string) ISCSINamespaceLister
	ISCSIListerExpansion
}

// iSCSILister implements the ISCSILister interface.
type iSCSILister struct {
	indexer cache.Indexer
}

// NewISCSILister returns a new ISCSILister.
func NewISCSILister(indexer cache.Indexer) ISCSILister {
	return &iSCSILister{indexer: indexer}
}

// List lists all ISCSIs in the indexer.
func (s *iSCSILister) List(selector labels.Selector) (ret []*v1beta1.ISCSI, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v1beta1.ISCSI))
	})
	return ret, err
}

// ISCSIs returns an object that can list and get ISCSIs.
func (s *iSCSILister) ISCSIs(namespace string) ISCSINamespaceLister {
	return iSCSINamespaceLister{indexer: s.indexer, namespace: namespace}
}

// ISCSINamespaceLister helps list and get ISCSIs.
type ISCSINamespaceLister interface {
	// List lists all ISCSIs in the indexer for a given namespace.
	List(selector labels.Selector) (ret []*v1beta1.ISCSI, err error)
	// Get retrieves the ISCSI from the indexer for a given namespace and name.
	Get(name string) (*v1beta1.ISCSI, error)
	ISCSINamespaceListerExpansion
}

// iSCSINamespaceLister implements the ISCSINamespaceLister
// interface.
type iSCSINamespaceLister struct {
	indexer   cache.Indexer
	namespace string
}

// List lists all ISCSIs in the indexer for a given namespace.
func (s iSCSINamespaceLister) List(selector labels.Selector) (ret []*v1beta1.ISCSI, err error) {
	err = cache.ListAllByNamespace(s.indexer, s.namespace, selector, func(m interface{}) {
		ret = append(ret, m.(*v1beta1.ISCSI))
	})
	return ret, err
}

// Get retrieves the ISCSI from the indexer for a given namespace and name.
func (s iSCSINamespaceLister) Get(name string) (*v1beta1.ISCSI, error) {
	obj, exists, err := s.indexer.GetByKey(s.namespace + "/" + name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v1beta1.Resource("iscsi"), name)
	}
	return obj.(*v1beta1.ISCSI), nil
}
