/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.Buffer;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBufferImpl;
import java.nio.IntBufferImpl;

public abstract class IntBuffer
extends Buffer
implements Comparable {
    ByteBufferImpl parent;
    int[] array;
    int arrayOffset;
    boolean isDirect;
    boolean disposed = false;

    IntBuffer() {
    }

    public static IntBuffer wrap(int[] array, int offset, int length) {
        if (offset < 0 || offset > array.length || length < 0 || length > array.length - offset) {
            throw new IndexOutOfBoundsException();
        }
        IntBufferImpl ibi = new IntBufferImpl(null, array.length, array, 0, false);
        ibi.position(offset);
        ibi.limit(offset + length);
        return ibi;
    }

    public static IntBuffer wrap(int[] array) {
        return IntBuffer.wrap(array, 0, array.length);
    }

    public abstract IntBuffer slice();

    public abstract int get();

    public abstract IntBuffer put(int var1);

    public abstract int get(int var1);

    public abstract IntBuffer put(int var1, int var2);

    public IntBuffer get(int[] dst, int offset, int length) {
        if (offset < 0 || offset > dst.length || length < 0 || length > dst.length - offset) {
            throw new IndexOutOfBoundsException();
        }
        if (this.limit - this.position < length) {
            throw new BufferUnderflowException();
        }
        int bytePtr = this.arrayOffset + (this.position << 2);
        if (this.isDirect) {
            ByteBufferImpl._getInts((int)bytePtr, (int[])dst, (int)offset, (int)length);
        } else if (this.array != null) {
            System.arraycopy(this.array, this.arrayOffset + this.position, dst, offset, length);
        } else {
            for (int i = 0; i < length; ++i) {
                dst[offset++] = this.parent.getInt(bytePtr);
                bytePtr += 4;
            }
        }
        this.position += length;
        return this;
    }

    public IntBuffer get(int[] dst) {
        return this.get(dst, 0, dst.length);
    }

    public IntBuffer put(IntBuffer src) {
        if (src == this) {
            throw new IllegalArgumentException();
        }
        IntBufferImpl srci = (IntBufferImpl)src;
        int length = srci.limit - srci.position;
        if (length > this.limit - this.position) {
            throw new BufferOverflowException();
        }
        if (this.isDirect && srci.isDirect) {
            ByteBufferImpl._copyBytes((int)(srci.arrayOffset + (srci.position << 2)), (int)(this.arrayOffset + (this.position << 2)), (int)(length << 2));
        } else if (this.isDirect && !srci.isDirect) {
            if (srci.array != null) {
                ByteBufferImpl._putInts((int)(this.arrayOffset + (this.position << 2)), (int[])srci.array, (int)(srci.arrayOffset + srci.position), (int)length);
            } else {
                byte[] srcArray = srci.parent.array;
                int srciArrayOffset = srci.parent.arrayOffset + srci.arrayOffset + (srci.position << 2);
                ByteBufferImpl._putBytes((int)(this.arrayOffset + (this.position << 2)), (byte[])srcArray, (int)srciArrayOffset, (int)(4 * length));
            }
        } else if (!this.isDirect && srci.isDirect) {
            if (this.array != null) {
                ByteBufferImpl._getInts((int)(srci.arrayOffset + (srci.position << 2)), (int[])this.array, (int)(this.arrayOffset + this.position), (int)length);
            } else {
                byte[] dstArray = this.parent.array;
                int dstArrayOffset = this.parent.arrayOffset + this.arrayOffset + (this.position << 2);
                ByteBufferImpl._getBytes((int)(srci.arrayOffset + (srci.position << 2)), (byte[])dstArray, (int)dstArrayOffset, (int)(4 * length));
            }
        } else if (!this.isDirect && !srci.isDirect) {
            if (this.array != null && srci.array != null) {
                System.arraycopy(srci.array, srci.arrayOffset + srci.position, this.array, this.arrayOffset + this.position, length);
            } else {
                for (int i = 0; i < length; ++i) {
                    this.put(i + this.position, srci.get(i + srci.position));
                }
            }
        }
        srci.position += length;
        this.position += length;
        return this;
    }

    public IntBuffer put(int[] src, int offset, int length) {
        if (offset < 0 || offset > src.length || length < 0 || length > src.length - offset) {
            throw new IndexOutOfBoundsException();
        }
        if (length > this.limit - this.position) {
            throw new BufferOverflowException();
        }
        int bytePtr = this.arrayOffset + (this.position << 2);
        if (this.isDirect) {
            ByteBufferImpl._putInts((int)bytePtr, (int[])src, (int)offset, (int)length);
        } else if (this.array != null) {
            System.arraycopy(src, offset, this.array, this.arrayOffset + this.position, length);
        } else {
            for (int i = 0; i < length; ++i) {
                this.parent.putInt(bytePtr, src[offset++]);
                bytePtr += 4;
            }
        }
        this.position += length;
        return this;
    }

    public final IntBuffer put(int[] src) {
        return this.put(src, 0, src.length);
    }

    public final boolean hasArray() {
        return this.array != null;
    }

    public final int[] array() {
        if (this.array == null) {
            throw new UnsupportedOperationException();
        }
        return this.array;
    }

    public final int arrayOffset() {
        if (this.array == null) {
            throw new UnsupportedOperationException();
        }
        return this.arrayOffset;
    }

    public abstract boolean isDirect();

    public String toString() {
        return "java.nio.IntBuffer[pos=" + this.position() + "lim=" + this.limit() + "cap=" + this.capacity() + "]";
    }

    public int hashCode() {
        int h = 1;
        int p = this.position();
        for (int i = this.limit() - 1; i >= p; --i) {
            h = 31 * h + this.get(i);
        }
        return h;
    }

    public boolean equals(Object ob) {
        if (!(ob instanceof IntBuffer)) {
            return false;
        }
        IntBuffer that = (IntBuffer)ob;
        if (this.remaining() != that.remaining()) {
            return false;
        }
        int p = this.position();
        int i = this.limit() - 1;
        int j = that.limit() - 1;
        while (i >= p) {
            int v2;
            int v1 = this.get(i);
            if (v1 != (v2 = that.get(j)) && (v1 == v1 || v2 == v2)) {
                return false;
            }
            --i;
            --j;
        }
        return true;
    }

    public int compareTo(Object ob) {
        IntBuffer that = (IntBuffer)ob;
        int n = this.position() + Math.min(this.remaining(), that.remaining());
        int i = this.position();
        int j = that.position();
        while (i < n) {
            int v2;
            int v1 = this.get(i);
            if (v1 != (v2 = that.get(j)) && (v1 == v1 || v2 == v2)) {
                if (v1 < v2) {
                    return -1;
                }
                return 1;
            }
            ++i;
            ++j;
        }
        return this.remaining() - that.remaining();
    }
}

