/*
 * Decompiled with CFR 0.152.
 */
package org.openintents.tools.sensorsimulator;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import org.openintents.tools.sensorsimulator.ISensorSimulator;
import org.openintents.tools.sensorsimulator.SensorServerThread;

public class SensorServer
implements Runnable {
    public ISensorSimulator mSensorSimulator;
    public Thread mThread;
    public SensorServerThread firstThread;
    public SensorServerThread lastThread;
    private ServerSocket serverSocket;
    public int port;
    public boolean listening;

    public SensorServer(ISensorSimulator newSensorSimulator) {
        this.mSensorSimulator = newSensorSimulator;
        this.firstThread = null;
        this.lastThread = null;
        this.listening = true;
        this.mThread = new Thread(this);
        this.mThread.start();
    }

    public void run() {
        this.listenServer();
    }

    public void listenServer() {
        block9: {
            this.port = this.mSensorSimulator.getPort();
            if (this.port == 0) {
                return;
            }
            this.serverSocket = null;
            try {
                this.serverSocket = new ServerSocket(this.port);
            }
            catch (IOException e) {
                this.mSensorSimulator.addMessage("Could not listen on port: " + this.port);
                return;
            }
            Socket clientSocket = null;
            try {
                this.mSensorSimulator.addMessage("Listening on port " + this.port + "...");
                while (this.listening) {
                    clientSocket = this.serverSocket.accept();
                    this.mSensorSimulator.newClient();
                    SensorServerThread newThread = new SensorServerThread(this.mSensorSimulator, clientSocket);
                    if (this.firstThread == null) {
                        this.firstThread = newThread;
                        this.lastThread = newThread;
                        continue;
                    }
                    this.lastThread.nextThread = newThread;
                    newThread.previousThread = this.lastThread;
                    this.lastThread = newThread;
                }
            }
            catch (IOException e) {
                if (!this.listening) break block9;
                System.err.println("Accept failed.");
            }
        }
        try {
            this.serverSocket.close();
        }
        catch (IOException e) {
            System.err.println("Close failed.");
            System.exit(1);
        }
    }

    public void stop() {
        SensorServerThread sst = this.firstThread;
        while (sst != null) {
            SensorServerThread ssthelp = sst.nextThread;
            sst.stop();
            sst = ssthelp;
        }
        this.listening = false;
        try {
            if (this.serverSocket != null) {
                this.mSensorSimulator.addMessage("Closing listening server...");
                this.serverSocket.close();
            }
        }
        catch (IOException e) {
            System.err.println("Close failed.");
            System.exit(1);
        }
    }
}

