/*
 * Decompiled with CFR 0.152.
 */
package org.openintents.tools.sensorsimulator;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import org.openintents.tools.sensorsimulator.FileRunnable;
import org.openintents.tools.sensorsimulator.ISensorSimulator;

public class TelnetServer {
    public ISensorSimulator mSensorSimulator;
    private Socket serverSocket;
    public Thread mThread;
    public boolean working;
    PrintStream out;
    public FileRunnable runnable;
    public int port;
    ArrayList<String> dateAndTime;
    ArrayList<String> simulationType;
    ArrayList<String> time;
    ArrayList<String> values;
    int counter;
    ArrayList<Integer> breakingPlaces;

    public TelnetServer(ISensorSimulator sensorSimulator) {
        this.mSensorSimulator = sensorSimulator;
        this.port = this.mSensorSimulator.getTelnetPort();
    }

    public void connect() {
        try {
            this.serverSocket = new Socket("localhost", this.port);
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            this.out = new PrintStream(this.serverSocket.getOutputStream());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.mSensorSimulator.addMessage("Telnet connection opened ");
    }

    public boolean disconnect() {
        try {
            this.serverSocket.close();
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void changePower(int value) {
        this.out.println("power capacity " + Integer.toString(value));
    }

    public void changePresence(boolean presence) {
        if (presence) {
            this.out.println("power present true");
        } else {
            this.out.println("power present false");
        }
    }

    public void changeAC(boolean ac) {
        if (ac) {
            this.out.println("power ac on");
        } else {
            this.out.println("power ac off");
        }
    }

    public void changeHealth(Object selectedItem) {
        this.out.println("power health " + selectedItem.toString());
    }

    public void changeStatus(Object selectedItem) {
        this.out.println("power status " + selectedItem.toString());
    }

    public void sendGPS() {
        float longitude = this.mSensorSimulator.getLongitude();
        float latitude = this.mSensorSimulator.getLatitude();
        float altitude = this.mSensorSimulator.getAltitude();
        if (this.out != null) {
            this.out.println("geo fix " + longitude + " " + latitude + " " + altitude);
        }
    }

    public void openFile(File file) {
        int j = 0;
        this.counter = 0;
        this.breakingPlaces = new ArrayList();
        this.dateAndTime = new ArrayList();
        this.simulationType = new ArrayList();
        this.time = new ArrayList();
        this.values = new ArrayList();
        try {
            String strLine;
            FileInputStream fstream = new FileInputStream(file);
            DataInputStream in = new DataInputStream(fstream);
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            while ((strLine = br.readLine()) != null) {
                if (strLine.length() > 14) {
                    this.dateAndTime.add(strLine);
                    this.breakingPlaces.add(this.counter);
                } else if (strLine.equalsIgnoreCase("BATTERY")) {
                    this.simulationType.add(strLine);
                } else if (strLine.length() > 4 && j > 2) {
                    ++this.counter;
                    this.time.add(strLine);
                } else if (!strLine.equals("") && j > 2) {
                    this.values.add(strLine);
                }
                ++j;
            }
            in.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void slowEmulation() {
        long[] time2 = null;
        time2 = new long[this.time.size()];
        for (int i = 0; i < this.time.size(); ++i) {
            time2[i] = TelnetServer.getLongMsFromTimeString(this.time.get(i));
        }
        this.runnable = new FileRunnable(this.dateAndTime, this.simulationType, this.time, this.values, time2, this, this.breakingPlaces);
        this.runnable.run();
    }

    public void nextTimeEvent() {
        if (this.runnable != null) {
            this.runnable.thread.interrupt();
        }
    }

    public static long getLongMsFromTimeString(String timeInString) {
        long time = 0L;
        String[] array = timeInString.split(":");
        if (array.length == 4) {
            time = Integer.parseInt(array[0]) * 1000 * 60 * 60 + Integer.parseInt(array[1]) * 1000 * 60 + Integer.parseInt(array[2]) * 1000 + Integer.parseInt(array[3]);
        }
        return time;
    }
}

