/*
 * Decompiled with CFR 0.152.
 */
package org.openintents.tools.sensorsimulator.swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Line2D;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Random;
import javax.swing.JPanel;
import org.openintents.tools.sensorsimulator.IMobilePanel;
import org.openintents.tools.sensorsimulator.ISensorSimulator;
import org.openintents.tools.sensorsimulator.Vector;

public class MobilePanel
extends JPanel
implements IMobilePanel {
    private static final long serialVersionUID = -112203026209081563L;
    private ISensorSimulator mSensorSimulator;
    private double read_accelx;
    private double read_accely;
    private double read_accelz;
    private double read_compassx;
    private double read_compassy;
    private double read_compassz;
    private double read_yaw;
    private double read_pitch;
    private double read_roll;
    private double read_temperature;
    private String barcode_reader;
    private float read_light;
    private float read_proximity;
    private long accel_update_duration;
    private long accel_next_update;
    private long compass_update_duration;
    private long compass_next_update;
    private long orientation_update_duration;
    private long orientation_next_update;
    private long temperature_update_duration;
    private long temperature_next_update;
    private long light_update_duration;
    private long light_next_update;
    private long proximity_update_duration;
    private long proximity_next_update;
    private long user_settings_duration;
    private long user_settings_next_update;
    private double partial_accelx;
    private double partial_accely;
    private double partial_accelz;
    private int partial_accel_n;
    private boolean average_accel;
    private double partial_compassx;
    private double partial_compassy;
    private double partial_compassz;
    private int partial_compass_n;
    private boolean average_compass;
    private double partial_yaw;
    private double partial_pitch;
    private double partial_roll;
    private int partial_orientation_n;
    private boolean average_orientation;
    private double partial_temperature;
    private int partial_temperature_n;
    private boolean average_temperature;
    private float partial_light;
    private int partial_light_n;
    private boolean average_light;
    private float partial_proximity;
    private int partial_proximity_n;
    private boolean average_proximity;
    private double accelx;
    private double accely;
    private double accelz;
    private double compassx;
    private double compassy;
    private double compassz;
    private double yaw;
    private double pitch;
    private double roll;
    private double temperature;
    private String barcode;
    private float light;
    private float proximity;
    private double yawDegree;
    private double pitchDegree;
    private double rollDegree;
    private int movex;
    private int movez;
    private int oldx;
    private int oldz;
    private double vx;
    private double vz;
    private double oldvx;
    private double oldvz;
    private double ax;
    private double az;
    private double Fx;
    private double Fz;
    private double accx;
    private double accz;
    private double k;
    private double m;
    private double gamma;
    private double dt;
    private double meterperpixel;
    private double g;
    private double ginverse;
    private int mousedownx;
    private int mousedowny;
    private int mousedownyaw;
    private int mousedownpitch;
    private int mousedownroll;
    private int mousedownmovex;
    private int mousedownmovez;
    private Random r;
    private final double sx = 15.0;
    private final double sy = 40.0;
    private final double sz = 5.0;
    private final double dx = 12.0;
    private final double dy1 = 33.0;
    private final double dy2 = -15.0;
    private double[][] phone = new double[][]{{15.0, 40.0, -5.0}, {-15.0, 40.0, -5.0}, {-15.0, 40.0, -5.0}, {-15.0, -40.0, -5.0}, {-15.0, -40.0, -5.0}, {15.0, -40.0, -5.0}, {15.0, -40.0, -5.0}, {15.0, 40.0, -5.0}, {15.0, 40.0, 5.0}, {-15.0, 40.0, 5.0}, {-15.0, 40.0, 5.0}, {-15.0, -40.0, 5.0}, {-15.0, -40.0, 5.0}, {15.0, -40.0, 5.0}, {15.0, -40.0, 5.0}, {15.0, 40.0, 5.0}, {15.0, 40.0, -5.0}, {15.0, 40.0, 5.0}, {-15.0, 40.0, -5.0}, {-15.0, 40.0, 5.0}, {-15.0, -40.0, -5.0}, {-15.0, -40.0, 5.0}, {15.0, -40.0, -5.0}, {15.0, -40.0, 5.0}, {12.0, 33.0, 5.0}, {-12.0, 33.0, 5.0}, {-12.0, 33.0, 5.0}, {-12.0, -15.0, 5.0}, {-12.0, -15.0, 5.0}, {12.0, -15.0, 5.0}, {12.0, -15.0, 5.0}, {12.0, 33.0, 5.0}};

    public MobilePanel(ISensorSimulator newSensorSimulator) {
        this.mSensorSimulator = newSensorSimulator;
        this.yawDegree = 0.0;
        this.pitchDegree = 0.0;
        this.rollDegree = 0.0;
        this.movex = 0;
        this.movez = 0;
        this.oldx = 0;
        this.oldz = 0;
        this.oldvx = 0.0;
        this.oldvz = 0.0;
        this.Fx = 0.0;
        this.Fz = 0.0;
        this.accx = 0.0;
        this.accz = 0.0;
        this.k = 500.0;
        this.m = 1.0;
        this.gamma = 50.0;
        this.dt = 0.1;
        this.meterperpixel = 3.333333333333333E-4;
        this.g = 9.80665;
        this.ginverse = 1.0 / this.g;
        this.user_settings_duration = 500L;
        this.user_settings_next_update = System.currentTimeMillis();
        this.r = new Random();
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                MobilePanel.this.mousedownx = e.getX();
                MobilePanel.this.mousedowny = e.getY();
                MobilePanel.this.mousedownyaw = MobilePanel.this.mSensorSimulator.getYaw();
                MobilePanel.this.mousedownpitch = MobilePanel.this.mSensorSimulator.getPitch();
                MobilePanel.this.mousedownroll = MobilePanel.this.mSensorSimulator.getRoll();
                MobilePanel.this.mousedownmovex = MobilePanel.this.movex;
                MobilePanel.this.mousedownmovez = MobilePanel.this.movez;
            }
        });
        this.addMouseMotionListener(new MouseMotionListener(){

            public void mouseDragged(MouseEvent e) {
                if (MobilePanel.this.mSensorSimulator.getMouseMode() == 1) {
                    int newpitch;
                    int newyaw;
                    for (newyaw = MobilePanel.this.mousedownyaw - (e.getX() - MobilePanel.this.mousedownx); newyaw > 180; newyaw -= 360) {
                    }
                    while (newyaw < -180) {
                        newyaw += 360;
                    }
                    MobilePanel.this.mSensorSimulator.setYaw(newyaw);
                    MobilePanel.this.yawDegree = newyaw;
                    for (newpitch = MobilePanel.this.mousedownpitch - (e.getY() - MobilePanel.this.mousedowny); newpitch > 180; newpitch -= 360) {
                    }
                    while (newpitch < -180) {
                        newpitch += 360;
                    }
                    MobilePanel.this.mSensorSimulator.setPitch(newpitch);
                    MobilePanel.this.pitchDegree = newpitch;
                } else if (MobilePanel.this.mSensorSimulator.getMouseMode() == 2) {
                    int newpitch;
                    int newroll;
                    for (newroll = MobilePanel.this.mousedownroll + (e.getX() - MobilePanel.this.mousedownx); newroll > 180; newroll -= 360) {
                    }
                    while (newroll < -180) {
                        newroll += 360;
                    }
                    MobilePanel.this.mSensorSimulator.setRoll(newroll);
                    MobilePanel.this.rollDegree = newroll;
                    for (newpitch = MobilePanel.this.mousedownpitch - (e.getY() - MobilePanel.this.mousedowny); newpitch > 180; newpitch -= 360) {
                    }
                    while (newpitch < -180) {
                        newpitch += 360;
                    }
                    MobilePanel.this.mSensorSimulator.setPitch(newpitch);
                    MobilePanel.this.pitchDegree = newpitch;
                } else if (MobilePanel.this.mSensorSimulator.getMouseMode() == 3) {
                    int newmovex = MobilePanel.this.mousedownmovex + (e.getX() - MobilePanel.this.mousedownx);
                    MobilePanel.this.movex = newmovex;
                    int newmovez = MobilePanel.this.mousedownmovez - (e.getY() - MobilePanel.this.mousedowny);
                    MobilePanel.this.movez = newmovez;
                }
                MobilePanel.this.repaint();
            }

            public void mouseMoved(MouseEvent evt) {
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSensorPhysics() {
        double random;
        double newdelay = this.mSensorSimulator.getUpdateSensors();
        if (newdelay > 0.0) {
            this.mSensorSimulator.setDelay((int)newdelay);
        }
        this.dt = 0.001 * (double)this.mSensorSimulator.getDelay();
        this.g = this.mSensorSimulator.getGravityConstant();
        if (this.g != 0.0) {
            this.ginverse = 1.0 / this.g;
        }
        this.meterperpixel = 1.0 / this.mSensorSimulator.getPixelsPerMeter();
        this.k = this.mSensorSimulator.getSpringConstant();
        this.gamma = this.mSensorSimulator.getDampingConstant();
        this.Fx = this.k * ((double)this.movex - this.accx);
        this.Fz = this.k * ((double)this.movez - this.accz);
        this.ax = this.Fx / this.m;
        this.az = this.Fz / this.m;
        this.vx += this.ax * this.dt;
        this.vz += this.az * this.dt;
        this.accx += this.vx * this.dt;
        this.accz += this.vz * this.dt;
        this.accx += this.gamma * ((double)this.movex - this.accx) * this.dt;
        this.accz += this.gamma * ((double)this.movez - this.accz) * this.dt;
        double gravityax = this.mSensorSimulator.getGravityX();
        double gravityay = this.mSensorSimulator.getGravityY();
        double gravityaz = this.mSensorSimulator.getGravityZ();
        Vector vec = new Vector(-this.ax * this.meterperpixel + gravityax, gravityay, -this.az * this.meterperpixel + gravityaz);
        vec.reverserollpitchyaw(this.rollDegree, this.pitchDegree, this.yawDegree);
        if (this.mSensorSimulator.isEnabledAccelerometer()) {
            if (this.mSensorSimulator.useRealDeviceWiimtoe()) {
                this.accelx = this.mSensorSimulator.getWiiMoteData().getX() * this.g;
                this.accely = this.mSensorSimulator.getWiiMoteData().getY() * this.g;
                this.accelz = this.mSensorSimulator.getWiiMoteData().getZ() * this.g;
            } else {
                double limit;
                this.accelx = vec.x;
                this.accely = vec.y;
                this.accelz = vec.z;
                if (this.mSensorSimulator.useRealDeviceThinkpad()) {
                    String line = "";
                    try {
                        BufferedReader input = new BufferedReader(new FileReader(this.mSensorSimulator.getRealDevicePath()));
                        try {
                            line = input.readLine();
                        }
                        finally {
                            input.close();
                        }
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                        line = "Error reading file!";
                    }
                    this.mSensorSimulator.setRealDeviceOutput(line);
                }
                if ((random = this.mSensorSimulator.getRandomAccelerometer()) > 0.0) {
                    this.accelx += this.getRandom(random);
                    this.accely += this.getRandom(random);
                    this.accelz += this.getRandom(random);
                }
                if ((limit = this.g * this.mSensorSimulator.getAccelerometerLimit()) > 0.0) {
                    if (this.accelx > limit) {
                        this.accelx = limit;
                    }
                    if (this.accelx < -limit) {
                        this.accelx = -limit;
                    }
                    if (this.accely > limit) {
                        this.accely = limit;
                    }
                    if (this.accely < -limit) {
                        this.accely = -limit;
                    }
                    if (this.accelz > limit) {
                        this.accelz = limit;
                    }
                    if (this.accelz < -limit) {
                        this.accelz = -limit;
                    }
                }
            }
        } else {
            this.accelx = 0.0;
            this.accely = 0.0;
            this.accelz = 0.0;
        }
        if (this.mSensorSimulator.isEnabledMagneticField()) {
            double magneticnorth = this.mSensorSimulator.getMagneticFieldNorth();
            double magneticeast = this.mSensorSimulator.getMagneticFieldEast();
            double magneticvertical = this.mSensorSimulator.getMagneticFieldVertical();
            random = this.mSensorSimulator.getRandomMagneticField();
            if (random > 0.0) {
                magneticnorth += this.getRandom(random);
                magneticeast += this.getRandom(random);
                magneticvertical += this.getRandom(random);
            }
            vec = new Vector(magneticeast, magneticnorth, -magneticvertical);
            vec.scale(0.001);
            vec.reverserollpitchyaw(this.rollDegree, this.pitchDegree, this.yawDegree);
            this.compassx = vec.x;
            this.compassy = vec.y;
            this.compassz = vec.z;
        } else {
            this.compassx = 0.0;
            this.compassy = 0.0;
            this.compassz = 0.0;
        }
        if (this.mSensorSimulator.isEnabledOrientation()) {
            this.yaw = this.yawDegree;
            this.pitch = this.pitchDegree;
            this.roll = this.rollDegree;
            random = this.mSensorSimulator.getRandomOrientation();
            if (random > 0.0) {
                this.yaw += this.getRandom(random);
                this.pitch += this.getRandom(random);
                this.roll += this.getRandom(random);
            }
        } else {
            this.yaw = 0.0;
            this.pitch = 0.0;
            this.roll = 0.0;
        }
        if (this.mSensorSimulator.isEnabledTemperature()) {
            this.temperature = this.mSensorSimulator.getTemperature();
            random = this.mSensorSimulator.getRandomTemperature();
            if (random > 0.0) {
                this.temperature += this.getRandom(random);
            }
        } else {
            this.temperature = 0.0;
        }
        if (this.mSensorSimulator.isEnabledBarcodeReader()) {
            this.barcode = this.mSensorSimulator.getBarcode();
        }
        if (this.mSensorSimulator.isShowAcceleration()) {
            this.repaint();
        }
        if (this.mSensorSimulator.isEnabledLight()) {
            this.light = this.mSensorSimulator.getLight();
            random = this.mSensorSimulator.getRandomLight();
            if (random > 0.0) {
                this.light = (float)((double)this.light + this.getRandom(random));
            }
        } else {
            this.light = 0.0f;
        }
        if (this.mSensorSimulator.isEnabledProximity()) {
            this.proximity = this.mSensorSimulator.getProximity();
            random = this.mSensorSimulator.getRandomProximity();
            if (random > 0.0) {
                this.proximity = (float)((double)this.proximity + this.getRandom(random));
            }
        } else {
            this.proximity = 0.0f;
        }
    }

    public void updateSensorReadoutValues() {
        long currentTime = System.currentTimeMillis();
        if (this.average_accel) {
            this.partial_accelx += this.accelx;
            this.partial_accely += this.accely;
            this.partial_accelz += this.accelz;
            ++this.partial_accel_n;
        }
        if (this.average_compass) {
            this.partial_compassx += this.compassx;
            this.partial_compassy += this.compassy;
            this.partial_compassz += this.compassz;
            ++this.partial_compass_n;
        }
        if (this.average_orientation) {
            this.partial_yaw += this.yaw;
            this.partial_pitch += this.pitch;
            this.partial_roll += this.roll;
            ++this.partial_orientation_n;
        }
        if (this.average_temperature) {
            this.partial_temperature += this.temperature;
            ++this.partial_temperature_n;
        }
        if (this.average_light) {
            this.partial_light += this.light;
            ++this.partial_light_n;
        }
        if (this.average_proximity) {
            this.partial_proximity += this.proximity;
            ++this.partial_proximity_n;
        }
        if (currentTime >= this.accel_next_update) {
            this.accel_next_update += this.accel_update_duration;
            if (this.accel_next_update < currentTime) {
                this.accel_next_update = currentTime;
            }
            if (this.average_accel) {
                this.read_accelx = this.partial_accelx / (double)this.partial_accel_n;
                this.read_accely = this.partial_accely / (double)this.partial_accel_n;
                this.read_accelz = this.partial_accelz / (double)this.partial_accel_n;
                this.partial_accelx = 0.0;
                this.partial_accely = 0.0;
                this.partial_accelz = 0.0;
                this.partial_accel_n = 0;
            } else {
                this.read_accelx = this.accelx;
                this.read_accely = this.accely;
                this.read_accelz = this.accelz;
            }
        }
        if (currentTime >= this.compass_next_update) {
            this.compass_next_update += this.compass_update_duration;
            if (this.compass_next_update < currentTime) {
                this.compass_next_update = currentTime;
            }
            if (this.average_compass) {
                this.read_compassx = this.partial_compassx / (double)this.partial_compass_n;
                this.read_compassy = this.partial_compassy / (double)this.partial_compass_n;
                this.read_compassz = this.partial_compassz / (double)this.partial_compass_n;
                this.partial_compassx = 0.0;
                this.partial_compassy = 0.0;
                this.partial_compassz = 0.0;
                this.partial_compass_n = 0;
            } else {
                this.read_compassx = this.compassx;
                this.read_compassy = this.compassy;
                this.read_compassz = this.compassz;
            }
        }
        if (currentTime >= this.orientation_next_update) {
            this.orientation_next_update += this.orientation_update_duration;
            if (this.orientation_next_update < currentTime) {
                this.orientation_next_update = currentTime;
            }
            if (this.average_orientation) {
                this.read_yaw = this.partial_yaw / (double)this.partial_orientation_n;
                this.read_pitch = this.partial_pitch / (double)this.partial_orientation_n;
                this.read_roll = this.partial_roll / (double)this.partial_orientation_n;
                this.partial_yaw = 0.0;
                this.partial_pitch = 0.0;
                this.partial_roll = 0.0;
                this.partial_orientation_n = 0;
            } else {
                this.read_yaw = this.yaw;
                this.read_pitch = this.pitch;
                this.read_roll = this.roll;
            }
            if (this.read_pitch < -90.0) {
                this.read_pitch = -180.0 - this.read_pitch;
                this.read_yaw += 180.0;
                this.read_roll += 180.0;
            } else if (this.read_pitch > 90.0) {
                this.read_pitch = 180.0 - this.read_pitch;
                this.read_yaw += 180.0;
                this.read_roll += 180.0;
            }
            if (this.read_yaw < 0.0) {
                this.read_yaw += 360.0;
            }
            if (this.read_yaw >= 360.0) {
                this.read_yaw -= 360.0;
            }
            if (this.read_roll >= 180.0) {
                this.read_roll -= 360.0;
            }
        }
        if (currentTime >= this.temperature_next_update) {
            this.temperature_next_update += this.temperature_update_duration;
            if (this.temperature_next_update < currentTime) {
                this.temperature_next_update = currentTime;
            }
            if (this.average_temperature) {
                this.read_temperature = this.partial_temperature / (double)this.partial_temperature_n;
                this.partial_temperature = 0.0;
                this.partial_temperature_n = 0;
            } else {
                this.read_temperature = this.temperature;
            }
        }
        if (currentTime >= this.light_next_update) {
            this.light_next_update += this.light_update_duration;
            if (this.light_next_update < currentTime) {
                this.light_next_update = currentTime;
            }
            if (this.average_light) {
                this.read_light = this.partial_light / (float)this.partial_light_n;
                this.partial_light = 0.0f;
                this.partial_light_n = 0;
            } else {
                this.read_light = this.light;
            }
        }
        if (currentTime >= this.proximity_next_update) {
            this.proximity_next_update += this.proximity_update_duration;
            if (this.proximity_next_update < currentTime) {
                this.proximity_next_update = currentTime;
            }
            if (this.average_proximity) {
                this.read_proximity = this.partial_proximity / (float)this.partial_proximity_n;
                this.partial_proximity = 0.0f;
                this.partial_proximity_n = 0;
            } else {
                this.read_proximity = this.proximity;
            }
        }
    }

    public void updateUserSettings() {
        long currentTime = System.currentTimeMillis();
        if (currentTime >= this.user_settings_next_update) {
            this.user_settings_next_update += this.user_settings_duration;
            if (this.user_settings_next_update < currentTime) {
                this.user_settings_next_update = System.currentTimeMillis();
            }
            this.average_accel = this.mSensorSimulator.updateAverageAccelerometer();
            double rate = this.mSensorSimulator.getCurrentUpdateRateAccelerometer();
            this.accel_update_duration = rate != 0.0 ? (long)(1000.0 / rate) : 0L;
            this.average_compass = this.mSensorSimulator.updateAverageCompass();
            rate = this.mSensorSimulator.getCurrentUpdateRateCompass();
            this.compass_update_duration = rate != 0.0 ? (long)(1000.0 / rate) : 0L;
            this.average_orientation = this.mSensorSimulator.updateAverageOrientation();
            rate = this.mSensorSimulator.getCurrentUpdateRateOrientation();
            this.orientation_update_duration = rate != 0.0 ? (long)(1000.0 / rate) : 0L;
            this.average_temperature = this.mSensorSimulator.updateAverageThermometer();
            rate = this.mSensorSimulator.getCurrentUpdateRateThermometer();
            this.temperature_update_duration = rate != 0.0 ? (long)(1000.0 / rate) : 0L;
            this.average_light = this.mSensorSimulator.updateAverageLight();
            rate = this.mSensorSimulator.getCurrentUpdateRateLight();
            this.light_update_duration = rate != 0.0 ? (long)(1000.0 / rate) : 0L;
            this.average_proximity = this.mSensorSimulator.updateAverageProximity();
            rate = this.mSensorSimulator.getCurrentUpdateRateProximity();
            this.proximity_update_duration = rate != 0.0 ? (long)(1000.0 / rate) : 0L;
        }
    }

    private double getRandom(double random) {
        double val = this.r.nextDouble();
        return (2.0 * val - 1.0) * random;
    }

    public Dimension getPreferredSize() {
        return new Dimension(250, 200);
    }

    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics2D g2 = (Graphics2D)graphics;
        double centerx = 100.0;
        double centery = 100.0;
        double centerz = -150.0;
        for (int i = 0; i < this.phone.length; i += 2) {
            if (i == 0) {
                g2.setColor(Color.RED);
            }
            if (i == 24) {
                g2.setColor(Color.BLUE);
            }
            Vector v1 = new Vector(this.phone[i]);
            Vector v2 = new Vector(this.phone[i + 1]);
            v1.rollpitchyaw(this.rollDegree, this.pitchDegree, this.yawDegree);
            v2.rollpitchyaw(this.rollDegree, this.pitchDegree, this.yawDegree);
            g2.draw(new Line2D.Double(centerx + (v1.x + (double)this.movex) * centerz / (centerz - v1.y), centery - (v1.z + (double)this.movez) * centerz / (centerz - v1.y), centerx + (v2.x + (double)this.movex) * centerz / (centerz - v2.y), centery - (v2.z + (double)this.movez) * centerz / (centerz - v2.y)));
        }
        if (this.mSensorSimulator.isShowAcceleration()) {
            g2.setColor(Color.GREEN);
            Vector v1 = new Vector(0.0, 0.0, 0.0);
            Vector v2 = new Vector(this.accelx, this.accely, this.accelz);
            v2.scale(20.0 * this.ginverse);
            v1.rollpitchyaw(this.rollDegree, this.pitchDegree, this.yawDegree);
            v2.rollpitchyaw(this.rollDegree, this.pitchDegree, this.yawDegree);
            g2.draw(new Line2D.Double(centerx + (v1.x + (double)this.movex) * centerz / (centerz - v1.y), centery - (v1.z + (double)this.movez) * centerz / (centerz - v1.y), centerx + (v2.x + (double)this.movex) * centerz / (centerz - v2.y), centery - (v2.z + (double)this.movez) * centerz / (centerz - v2.y)));
        }
    }

    public void doRepaint() {
        this.repaint();
    }

    public double getReadAccelerometerX() {
        return this.read_accelx;
    }

    public double getReadAccelerometerY() {
        return this.read_accely;
    }

    public double getReadAccelerometerZ() {
        return this.read_accelz;
    }

    public double getReadCompassX() {
        return this.read_compassx;
    }

    public double getReadCompassY() {
        return this.read_compassy;
    }

    public double getReadCompassZ() {
        return this.read_compassz;
    }

    public double getReadYaw() {
        return this.read_yaw;
    }

    public double getReadPitch() {
        return this.read_pitch;
    }

    public double getReadRoll() {
        return this.read_roll;
    }

    public double getReadTemperature() {
        return this.read_temperature;
    }

    public String getBarcode() {
        return this.barcode;
    }

    public float getReadLight() {
        return this.read_light;
    }

    public float getReadProximity() {
        return this.read_proximity;
    }

    public void setYawDegree(double yawDegree) {
        this.yawDegree = yawDegree;
    }

    public void setPitchDegree(double pitchDegree) {
        this.pitchDegree = pitchDegree;
    }

    public void setRollDegree(double rollDegree) {
        this.rollDegree = rollDegree;
    }
}

