/*
 * Decompiled with CFR 0.152.
 */
package com.github.sarxos.webcam;

import com.github.sarxos.webcam.WebcamDriver;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebcamDriverUtils {
    private static final Logger LOG = LoggerFactory.getLogger(WebcamDriverUtils.class);

    private WebcamDriverUtils() {
    }

    protected static WebcamDriver findDriver(List list2, List list3) {
        for (String string : list2) {
            LOG.info("Searching driver {}", string);
            Class clazz = null;
            for (Class clazz2 : list3) {
                if (!clazz2.getCanonicalName().equals(string)) continue;
                clazz = clazz2;
                break;
            }
            if (clazz == null) {
                try {
                    clazz = Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    LOG.trace("Class not found {}, fall thru", (Object)string);
                }
            }
            if (clazz == null) {
                LOG.debug("Driver {} not found", string);
                continue;
            }
            LOG.info("Webcam driver {} has been found", string);
            try {
                return (WebcamDriver)clazz.newInstance();
            }
            catch (InstantiationException instantiationException) {
                throw new RuntimeException(instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException(illegalAccessException);
            }
        }
        return null;
    }
}

