/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.mp.game;

import com.siemens.mp.game.ExtendedImage;
import com.siemens.mp.game.GraphicObject;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class TiledBackground
extends GraphicObject {
    private Image[] pixels;
    private byte[] map;
    private int widthInTiles;
    private int heightInTiles;
    private int posx;
    private int posy;

    public TiledBackground(byte[] byArray, byte[] byArray2, byte[] byArray3, int n2, int n3) {
        this(com.siemens.mp.ui.Image.createImageFromBitmap(byArray, 8, byArray.length), byArray2 == null ? null : com.siemens.mp.ui.Image.createImageFromBitmap(byArray2, 8, byArray.length), byArray3, n2, n3);
    }

    public TiledBackground(ExtendedImage extendedImage, ExtendedImage extendedImage2, byte[] byArray, int n2, int n3) {
        this(extendedImage.getImage(), extendedImage2 == null ? null : extendedImage2.getImage(), byArray, n2, n3);
    }

    public TiledBackground(Image image, Image image2, byte[] byArray, int n2, int n3) {
        if (image.getWidth() != 8 || image2 != null && image2.getWidth() != 8) {
            throw new IllegalArgumentException("Tile image width must be 8.");
        }
        if (this.containsTransparentColor(image) || image2 != null && this.containsTransparentColor(image2)) {
            throw new IllegalArgumentException("Images must not contain transparent colors.");
        }
        for (byte by2 : byArray) {
            if ((by2 & 0xFF) < image.getHeight() / 8) continue;
            throw new IllegalArgumentException("Invalid tile number in the map.");
        }
        this.map = byArray;
        this.heightInTiles = n3;
        this.widthInTiles = n2;
        this.pixels = new Image[image.getHeight() / 8 + 3];
        this.pixels[0] = Image.createImage(8, 8, 0);
        this.pixels[1] = Image.createImage(8, 8);
        this.pixels[2] = Image.createImage(8, 8);
        this.pixels[2].getGraphics().fillRect(0, 0, 8, 8);
        if (image2 != null) {
            image = com.siemens.mp.lcdui.Image.createTransparentImageFromMask(image, image2);
        }
        for (int i2 = 0; i2 < this.pixels.length - 3; ++i2) {
            Image image3 = Image.createImage(8, 8, 0);
            image3.getGraphics().drawImage(image, 0, -i2 * 8, 0);
            this.pixels[i2 + 3] = image3;
        }
    }

    public void setPositionInMap(int n2, int n3) {
        this.posx = n2;
        this.posy = n3;
    }

    @Override
    protected void paint(Graphics graphics, int n2, int n3) {
        graphics.translate(n2, n3);
        int n4 = graphics.getClipX();
        int n5 = graphics.getClipY();
        int n6 = graphics.getClipWidth();
        int n7 = graphics.getClipHeight();
        int n8 = (n4 + this.posx) / 8;
        int n9 = (n5 + this.posy) / 8;
        int n10 = (n4 + n6 + this.posx) / 8;
        int n11 = (n5 + n7 + this.posy) / 8;
        if (n4 + this.posx < 0) {
            --n8;
        }
        if (n5 + this.posy < 0) {
            --n9;
        }
        for (int i2 = n9; i2 <= n11; ++i2) {
            for (int i3 = n8; i3 <= n10; ++i3) {
                int n12 = TiledBackground.wrap(i3, this.widthInTiles);
                int n13 = TiledBackground.wrap(i2, this.heightInTiles);
                int n14 = this.map[n13 * this.widthInTiles + n12] & 0xFF;
                if (n14 == 0) continue;
                graphics.drawImage(this.pixels[n14], i3 * 8 - this.posx, i2 * 8 - this.posy, 0);
            }
        }
        graphics.translate(-n2, -n3);
    }

    private static int wrap(int n2, int n3) {
        int n4 = n2 % n3;
        return n4 < 0 ? n4 + n3 : n4;
    }
}

