/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.platform.win32.COM;

import com.sun.jna.platform.win32.COM.COMUtils;
import com.sun.jna.platform.win32.COM.ITypeInfo;
import com.sun.jna.platform.win32.COM.IUnknown;
import com.sun.jna.platform.win32.COM.TypeComp;
import com.sun.jna.platform.win32.COM.TypeInfo;
import com.sun.jna.platform.win32.COM.TypeInfoUtil$ContainingTypeLib;
import com.sun.jna.platform.win32.COM.TypeInfoUtil$DllEntry;
import com.sun.jna.platform.win32.COM.TypeInfoUtil$Invoke;
import com.sun.jna.platform.win32.COM.TypeInfoUtil$TypeInfoDoc;
import com.sun.jna.platform.win32.COM.TypeLib;
import com.sun.jna.platform.win32.Guid$REFIID;
import com.sun.jna.platform.win32.OaIdl$EXCEPINFO$ByReference;
import com.sun.jna.platform.win32.OaIdl$FUNCDESC;
import com.sun.jna.platform.win32.OaIdl$HREFTYPE;
import com.sun.jna.platform.win32.OaIdl$HREFTYPEByReference;
import com.sun.jna.platform.win32.OaIdl$INVOKEKIND;
import com.sun.jna.platform.win32.OaIdl$MEMBERID;
import com.sun.jna.platform.win32.OaIdl$TYPEATTR;
import com.sun.jna.platform.win32.OaIdl$VARDESC;
import com.sun.jna.platform.win32.OleAuto;
import com.sun.jna.platform.win32.OleAuto$DISPPARAMS$ByReference;
import com.sun.jna.platform.win32.Variant$VARIANT$ByReference;
import com.sun.jna.platform.win32.WTypes$BSTR;
import com.sun.jna.platform.win32.WTypes$BSTRByReference;
import com.sun.jna.platform.win32.WTypes$LPOLESTR;
import com.sun.jna.platform.win32.WinDef$DWORDByReference;
import com.sun.jna.platform.win32.WinDef$PVOID;
import com.sun.jna.platform.win32.WinDef$UINT;
import com.sun.jna.platform.win32.WinDef$UINTByReference;
import com.sun.jna.platform.win32.WinDef$WORD;
import com.sun.jna.platform.win32.WinDef$WORDByReference;
import com.sun.jna.platform.win32.WinNT$HRESULT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;

public class TypeInfoUtil {
    public static final OleAuto OLEAUTO = OleAuto.INSTANCE;
    private ITypeInfo typeInfo;

    public TypeInfoUtil(ITypeInfo iTypeInfo) {
        this.typeInfo = iTypeInfo;
    }

    public OaIdl$TYPEATTR getTypeAttr() {
        PointerByReference pointerByReference = new PointerByReference();
        WinNT$HRESULT winNT$HRESULT = this.typeInfo.GetTypeAttr(pointerByReference);
        COMUtils.checkRC(winNT$HRESULT);
        return new OaIdl$TYPEATTR(pointerByReference.getValue());
    }

    public TypeComp getTypeComp() {
        PointerByReference pointerByReference = new PointerByReference();
        WinNT$HRESULT winNT$HRESULT = this.typeInfo.GetTypeComp(pointerByReference);
        COMUtils.checkRC(winNT$HRESULT);
        return new TypeComp(pointerByReference.getValue());
    }

    public OaIdl$FUNCDESC getFuncDesc(int n2) {
        PointerByReference pointerByReference = new PointerByReference();
        WinNT$HRESULT winNT$HRESULT = this.typeInfo.GetFuncDesc(new WinDef$UINT((long)n2), pointerByReference);
        COMUtils.checkRC(winNT$HRESULT);
        return new OaIdl$FUNCDESC(pointerByReference.getValue());
    }

    public OaIdl$VARDESC getVarDesc(int n2) {
        PointerByReference pointerByReference = new PointerByReference();
        WinNT$HRESULT winNT$HRESULT = this.typeInfo.GetVarDesc(new WinDef$UINT((long)n2), pointerByReference);
        COMUtils.checkRC(winNT$HRESULT);
        return new OaIdl$VARDESC(pointerByReference.getValue());
    }

    public String[] getNames(OaIdl$MEMBERID oaIdl$MEMBERID, int n2) {
        WTypes$BSTR[] wTypes$BSTRArray = new WTypes$BSTR[n2];
        WinDef$UINTByReference winDef$UINTByReference = new WinDef$UINTByReference();
        WinNT$HRESULT winNT$HRESULT = this.typeInfo.GetNames(oaIdl$MEMBERID, wTypes$BSTRArray, new WinDef$UINT((long)n2), winDef$UINTByReference);
        COMUtils.checkRC(winNT$HRESULT);
        int n3 = winDef$UINTByReference.getValue().intValue();
        String[] stringArray = new String[n3];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            stringArray[i2] = wTypes$BSTRArray[i2].getValue();
            OLEAUTO.SysFreeString(wTypes$BSTRArray[i2]);
        }
        return stringArray;
    }

    public OaIdl$HREFTYPE getRefTypeOfImplType(int n2) {
        OaIdl$HREFTYPEByReference oaIdl$HREFTYPEByReference = new OaIdl$HREFTYPEByReference();
        WinNT$HRESULT winNT$HRESULT = this.typeInfo.GetRefTypeOfImplType(new WinDef$UINT((long)n2), oaIdl$HREFTYPEByReference);
        COMUtils.checkRC(winNT$HRESULT);
        return oaIdl$HREFTYPEByReference.getValue();
    }

    public int getImplTypeFlags(int n2) {
        IntByReference intByReference = new IntByReference();
        WinNT$HRESULT winNT$HRESULT = this.typeInfo.GetImplTypeFlags(new WinDef$UINT((long)n2), intByReference);
        COMUtils.checkRC(winNT$HRESULT);
        return intByReference.getValue();
    }

    public OaIdl$MEMBERID[] getIDsOfNames(WTypes$LPOLESTR[] wTypes$LPOLESTRArray, int n2) {
        OaIdl$MEMBERID[] oaIdl$MEMBERIDArray = new OaIdl$MEMBERID[n2];
        WinNT$HRESULT winNT$HRESULT = this.typeInfo.GetIDsOfNames(wTypes$LPOLESTRArray, new WinDef$UINT((long)n2), oaIdl$MEMBERIDArray);
        COMUtils.checkRC(winNT$HRESULT);
        return oaIdl$MEMBERIDArray;
    }

    public TypeInfoUtil$Invoke Invoke(WinDef$PVOID winDef$PVOID, OaIdl$MEMBERID oaIdl$MEMBERID, WinDef$WORD winDef$WORD, OleAuto$DISPPARAMS$ByReference oleAuto$DISPPARAMS$ByReference) {
        Variant$VARIANT$ByReference variant$VARIANT$ByReference = new Variant$VARIANT$ByReference();
        OaIdl$EXCEPINFO$ByReference oaIdl$EXCEPINFO$ByReference = new OaIdl$EXCEPINFO$ByReference();
        WinDef$UINTByReference winDef$UINTByReference = new WinDef$UINTByReference();
        WinNT$HRESULT winNT$HRESULT = this.typeInfo.Invoke(winDef$PVOID, oaIdl$MEMBERID, winDef$WORD, oleAuto$DISPPARAMS$ByReference, variant$VARIANT$ByReference, oaIdl$EXCEPINFO$ByReference, winDef$UINTByReference);
        COMUtils.checkRC(winNT$HRESULT);
        return new TypeInfoUtil$Invoke(variant$VARIANT$ByReference, oaIdl$EXCEPINFO$ByReference, winDef$UINTByReference.getValue().intValue());
    }

    public TypeInfoUtil$TypeInfoDoc getDocumentation(OaIdl$MEMBERID oaIdl$MEMBERID) {
        WTypes$BSTRByReference wTypes$BSTRByReference = new WTypes$BSTRByReference();
        WTypes$BSTRByReference wTypes$BSTRByReference2 = new WTypes$BSTRByReference();
        WinDef$DWORDByReference winDef$DWORDByReference = new WinDef$DWORDByReference();
        WTypes$BSTRByReference wTypes$BSTRByReference3 = new WTypes$BSTRByReference();
        WinNT$HRESULT winNT$HRESULT = this.typeInfo.GetDocumentation(oaIdl$MEMBERID, wTypes$BSTRByReference, wTypes$BSTRByReference2, winDef$DWORDByReference, wTypes$BSTRByReference3);
        COMUtils.checkRC(winNT$HRESULT);
        TypeInfoUtil$TypeInfoDoc typeInfoUtil$TypeInfoDoc = new TypeInfoUtil$TypeInfoDoc(wTypes$BSTRByReference.getString(), wTypes$BSTRByReference2.getString(), winDef$DWORDByReference.getValue().intValue(), wTypes$BSTRByReference3.getString());
        OLEAUTO.SysFreeString(wTypes$BSTRByReference.getValue());
        OLEAUTO.SysFreeString(wTypes$BSTRByReference2.getValue());
        OLEAUTO.SysFreeString(wTypes$BSTRByReference3.getValue());
        return typeInfoUtil$TypeInfoDoc;
    }

    public TypeInfoUtil$DllEntry GetDllEntry(OaIdl$MEMBERID oaIdl$MEMBERID, OaIdl$INVOKEKIND oaIdl$INVOKEKIND) {
        WTypes$BSTRByReference wTypes$BSTRByReference = new WTypes$BSTRByReference();
        WTypes$BSTRByReference wTypes$BSTRByReference2 = new WTypes$BSTRByReference();
        WinDef$WORDByReference winDef$WORDByReference = new WinDef$WORDByReference();
        WinNT$HRESULT winNT$HRESULT = this.typeInfo.GetDllEntry(oaIdl$MEMBERID, oaIdl$INVOKEKIND, wTypes$BSTRByReference, wTypes$BSTRByReference2, winDef$WORDByReference);
        COMUtils.checkRC(winNT$HRESULT);
        OLEAUTO.SysFreeString(wTypes$BSTRByReference.getValue());
        OLEAUTO.SysFreeString(wTypes$BSTRByReference2.getValue());
        return new TypeInfoUtil$DllEntry(wTypes$BSTRByReference.getString(), wTypes$BSTRByReference2.getString(), winDef$WORDByReference.getValue().intValue());
    }

    public ITypeInfo getRefTypeInfo(OaIdl$HREFTYPE oaIdl$HREFTYPE) {
        PointerByReference pointerByReference = new PointerByReference();
        WinNT$HRESULT winNT$HRESULT = this.typeInfo.GetRefTypeInfo(oaIdl$HREFTYPE, pointerByReference);
        COMUtils.checkRC(winNT$HRESULT);
        return new TypeInfo(pointerByReference.getValue());
    }

    public PointerByReference AddressOfMember(OaIdl$MEMBERID oaIdl$MEMBERID, OaIdl$INVOKEKIND oaIdl$INVOKEKIND) {
        PointerByReference pointerByReference = new PointerByReference();
        WinNT$HRESULT winNT$HRESULT = this.typeInfo.AddressOfMember(oaIdl$MEMBERID, oaIdl$INVOKEKIND, pointerByReference);
        COMUtils.checkRC(winNT$HRESULT);
        return pointerByReference;
    }

    public PointerByReference CreateInstance(IUnknown iUnknown, Guid$REFIID guid$REFIID) {
        PointerByReference pointerByReference = new PointerByReference();
        WinNT$HRESULT winNT$HRESULT = this.typeInfo.CreateInstance(iUnknown, guid$REFIID, pointerByReference);
        COMUtils.checkRC(winNT$HRESULT);
        return pointerByReference;
    }

    public String GetMops(OaIdl$MEMBERID oaIdl$MEMBERID) {
        WTypes$BSTRByReference wTypes$BSTRByReference = new WTypes$BSTRByReference();
        WinNT$HRESULT winNT$HRESULT = this.typeInfo.GetMops(oaIdl$MEMBERID, wTypes$BSTRByReference);
        COMUtils.checkRC(winNT$HRESULT);
        return wTypes$BSTRByReference.getString();
    }

    public TypeInfoUtil$ContainingTypeLib GetContainingTypeLib() {
        PointerByReference pointerByReference = new PointerByReference();
        WinDef$UINTByReference winDef$UINTByReference = new WinDef$UINTByReference();
        WinNT$HRESULT winNT$HRESULT = this.typeInfo.GetContainingTypeLib(pointerByReference, winDef$UINTByReference);
        COMUtils.checkRC(winNT$HRESULT);
        return new TypeInfoUtil$ContainingTypeLib(new TypeLib(pointerByReference.getValue()), winDef$UINTByReference.getValue().intValue());
    }

    public void ReleaseTypeAttr(OaIdl$TYPEATTR oaIdl$TYPEATTR) {
        this.typeInfo.ReleaseTypeAttr(oaIdl$TYPEATTR);
    }

    public void ReleaseFuncDesc(OaIdl$FUNCDESC oaIdl$FUNCDESC) {
        this.typeInfo.ReleaseFuncDesc(oaIdl$FUNCDESC);
    }

    public void ReleaseVarDesc(OaIdl$VARDESC oaIdl$VARDESC) {
        this.typeInfo.ReleaseVarDesc(oaIdl$VARDESC);
    }
}

