/*
 * Decompiled with CFR 0.152.
 */
package emulator.graphics3D;

import emulator.graphics3D.Vector4f;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class Quaternion {
    public float x;
    public float y;
    public float z;
    public float w;

    public Quaternion() {
    }

    public Quaternion(float f2, float f3, float f4, float f5) {
        this.x = f2;
        this.y = f3;
        this.z = f4;
        this.w = f5;
    }

    public Quaternion(float[] fArray) {
        this.set(fArray);
    }

    public Quaternion(Quaternion quaternion) {
        this.set(quaternion);
    }

    public final void set(float[] fArray) {
        if (fArray.length != 4) {
            throw new Error("Invalid number of components for quaternion");
        }
        this.x = fArray[0];
        this.y = fArray[1];
        this.z = fArray[2];
        this.w = fArray[3];
    }

    public final void set(Quaternion quaternion) {
        this.x = quaternion.x;
        this.y = quaternion.y;
        this.z = quaternion.z;
        this.w = quaternion.w;
    }

    private void a() {
        this.z = 0.0f;
        this.y = 0.0f;
        this.x = 0.0f;
        this.w = 1.0f;
    }

    public final void normalize() {
        float f2;
        Quaternion quaternion;
        float f3;
        float f4 = this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w;
        if (f3 > 1.0E-5f) {
            float f5 = 1.0f / (float)Math.sqrt(f4);
            this.x *= f5;
            this.y *= f5;
            this.z *= f5;
            quaternion = this;
            f2 = this.w * f5;
        } else {
            this.z = 0.0f;
            this.y = 0.0f;
            this.x = 0.0f;
            quaternion = this;
            f2 = 1.0f;
        }
        quaternion.w = f2;
    }

    public final void setAngleAxis(float f2, float f3, float f4, float f5) {
        Vector4f vector4f = new Vector4f(f3, f4, f5, 0.0f);
        if (vector4f.normalize()) {
            float f6 = (float)Math.toRadians(0.5f * f2);
            float f7 = (float)Math.sin(f6);
            this.x = f7 * vector4f.x;
            this.y = f7 * vector4f.y;
            this.z = f7 * vector4f.z;
            this.w = (float)Math.cos(f6);
        } else {
            this.a();
        }
    }

    public final void getAngleAxis(float[] fArray) {
        this.normalize();
        float f2 = 1.0f - this.w * this.w;
        if (f2 > 1.0E-5f) {
            float f3 = (float)Math.sqrt(f2);
            fArray[1] = this.x / f3;
            fArray[2] = this.y / f3;
            fArray[3] = this.z / f3;
        } else {
            fArray[2] = 0.0f;
            fArray[1] = 0.0f;
            fArray[3] = 1.0f;
        }
        fArray[0] = (float)Math.toDegrees(Math.acos(this.w) * 2.0);
    }

    public final void mul(Quaternion quaternion) {
        Quaternion quaternion2 = new Quaternion(this);
        this.w = quaternion2.w * quaternion.w - quaternion2.x * quaternion.x - quaternion2.y * quaternion.y - quaternion2.z * quaternion.z;
        this.x = quaternion2.w * quaternion.x + quaternion2.x * quaternion.w + quaternion2.y * quaternion.z - quaternion2.z * quaternion.y;
        this.y = quaternion2.w * quaternion.y - quaternion2.x * quaternion.z + quaternion2.y * quaternion.w + quaternion2.z * quaternion.x;
        this.z = quaternion2.w * quaternion.z + quaternion2.x * quaternion.y - quaternion2.y * quaternion.x + quaternion2.z * quaternion.w;
    }

    public final void mul(float f2) {
        this.x *= f2;
        this.y *= f2;
        this.z *= f2;
        this.w *= f2;
    }

    public final void add(Quaternion quaternion) {
        this.x += quaternion.x;
        this.y += quaternion.y;
        this.z += quaternion.z;
        this.w += quaternion.w;
    }

    public final void sub(Quaternion quaternion) {
        this.x -= quaternion.x;
        this.y -= quaternion.y;
        this.z -= quaternion.z;
        this.w -= quaternion.w;
    }

    private void a(Quaternion quaternion) {
        this.x = -quaternion.x;
        this.y = -quaternion.y;
        this.z = -quaternion.z;
        this.w = quaternion.w;
    }

    private float a(Quaternion quaternion) {
        return this.x * quaternion.x + this.y * quaternion.y + this.z * quaternion.z + this.w * quaternion.w;
    }

    private void b(Quaternion quaternion) {
        float f2;
        float f3 = (float)Math.sqrt(quaternion.x * quaternion.x + quaternion.y * quaternion.y + quaternion.z * quaternion.z);
        if (f2 > 1.0E-5f) {
            float f4 = (float)(Math.atan2(f3, this.w) / (double)f3);
            this.x = f4 * quaternion.x;
            this.y = f4 * quaternion.y;
            this.z = f4 * quaternion.z;
        } else {
            this.z = 0.0f;
            this.y = 0.0f;
            this.x = 0.0f;
        }
        this.w = 0.0f;
    }

    public final void exp(Quaternion quaternion) {
        float f2;
        Quaternion quaternion2;
        float f3;
        float f4 = (float)Math.sqrt(quaternion.x * quaternion.x + quaternion.y * quaternion.y + quaternion.z * quaternion.z);
        if (f3 > 1.0E-5f) {
            float f5 = (float)Math.sin(f4) / f4;
            this.x = f5 * quaternion.x;
            this.y = f5 * quaternion.y;
            this.z = f5 * quaternion.z;
            quaternion2 = this;
            f2 = (float)Math.cos(f4);
        } else {
            this.z = 0.0f;
            this.y = 0.0f;
            this.x = 0.0f;
            quaternion2 = this;
            f2 = 1.0f;
        }
        quaternion2.w = f2;
    }

    public final void logDiff(Quaternion quaternion, Quaternion quaternion2) {
        this.set(quaternion);
        this.a(this);
        this.mul(quaternion2);
        this.b(this);
    }

    public final void slerp(float f2, Quaternion quaternion, Quaternion quaternion2) {
        float f3;
        float f4 = quaternion.a(quaternion2);
        if (f3 + 1.0f > 1.0E-5f) {
            float f5;
            float f6;
            if (1.0f - f4 > 1.0E-5f) {
                float f7 = (float)Math.acos(f4);
                float f8 = (float)Math.sin(f7);
                f6 = (float)Math.sin((1.0f - f2) * f7) / f8;
                f5 = (float)Math.sin(f2 * f7) / f8;
            } else {
                f6 = 1.0f - f2;
                f5 = f2;
            }
            float f9 = f5;
            this.x = f6 * quaternion.x + f9 * quaternion2.x;
            this.y = f6 * quaternion.y + f9 * quaternion2.y;
            this.z = f6 * quaternion.z + f9 * quaternion2.z;
            this.w = f6 * quaternion.w + f9 * quaternion2.w;
        } else {
            this.x = -quaternion.y;
            this.y = quaternion.x;
            this.z = -quaternion.w;
            this.w = quaternion.z;
            float f10 = (float)Math.sin((double)(1.0f - f2) * Math.PI / 2.0);
            float f11 = (float)Math.sin((double)f2 * Math.PI / 2.0);
            this.x = f10 * quaternion.x + f11 * this.x;
            this.y = f10 * quaternion.y + f11 * this.y;
            this.z = f10 * quaternion.z + f11 * this.z;
        }
    }

    public final void squad(float f2, Quaternion quaternion, Quaternion quaternion2, Quaternion quaternion3, Quaternion quaternion4) {
        Quaternion quaternion5 = new Quaternion();
        Quaternion quaternion6 = new Quaternion();
        quaternion5.slerp(f2, quaternion, quaternion4);
        quaternion6.slerp(f2, quaternion2, quaternion3);
        this.slerp(2.0f * f2 * (1.0f - f2), quaternion5, quaternion6);
    }

    public final void setRotation(Vector4f vector4f, Vector4f vector4f2, Vector4f vector4f3) {
        if (vector4f.w == 0.0f && vector4f2.w == 0.0f) {
            float f2;
            Vector4f vector4f4 = new Vector4f(vector4f);
            Vector4f vector4f5 = new Vector4f(vector4f2);
            if (vector4f3 != null) {
                Vector4f vector4f6 = new Vector4f(vector4f3);
                vector4f6.normalize();
                vector4f4.normalize();
                f2 = vector4f4.dot(vector4f6);
                vector4f6.mul(f2);
                vector4f4.sub(vector4f6);
                vector4f6.set(vector4f3);
                vector4f6.normalize();
                vector4f5.normalize();
                f2 = vector4f5.dot(vector4f6);
                vector4f6.mul(f2);
                vector4f5.sub(vector4f6);
            }
            if (vector4f4.normalize() && vector4f5.normalize()) {
                float f3;
                float f4 = vector4f4.dot(vector4f5);
                if (f3 > 0.99999f) {
                    this.a();
                } else {
                    Quaternion quaternion;
                    float f5;
                    if (f4 < -0.99999f) {
                        if (vector4f3 == null) {
                            float f6;
                            float f7;
                            Vector4f vector4f7;
                            vector4f3 = new Vector4f();
                            f2 = Math.abs(vector4f4.x);
                            float f8 = Math.abs(vector4f4.y);
                            float f9 = Math.abs(vector4f4.z);
                            if (f2 <= f8 && f2 <= f9) {
                                vector4f7 = vector4f3;
                                f5 = 1.0f;
                                f7 = 0.0f;
                                f6 = 0.0f;
                            } else if (f8 <= f2 && f8 <= f9) {
                                vector4f7 = vector4f3;
                                f5 = 0.0f;
                                f7 = 1.0f;
                                f6 = 0.0f;
                            } else {
                                vector4f7 = vector4f3;
                                f5 = 0.0f;
                                f7 = 0.0f;
                                f6 = 1.0f;
                            }
                            vector4f7.set(f5, f7, f6, 0.0f);
                            float f10 = vector4f3.dot(vector4f4);
                            vector4f4.mul(f10);
                            vector4f3.sub(vector4f4);
                        }
                        quaternion = this;
                        f5 = 180.0f;
                    } else {
                        vector4f3 = new Vector4f();
                        vector4f3.cross(vector4f4, vector4f5);
                        quaternion = this;
                        f5 = (float)Math.toDegrees(Math.acos(f4));
                    }
                    quaternion.setAngleAxis(f5, vector4f3.x, vector4f3.y, vector4f3.z);
                }
            } else {
                this.a();
            }
        } else {
            throw new Error();
        }
    }
}

