/*
 * Decompiled with CFR 0.152.
 */
package emulator.ui.swt.devutils;

import emulator.Utils;
import emulator.ui.swt.devutils.ClasspathEntryType;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ClasspathEntry {
    public final String path;
    public final ClasspathEntryType type;
    public final boolean isLocalPath;

    public ClasspathEntry(String string, ClasspathEntryType classpathEntryType, boolean bl2) {
        this.path = string;
        this.type = classpathEntryType;
        this.isLocalPath = bl2;
    }

    public ClasspathEntry(String string, ClasspathEntryType classpathEntryType) {
        this.path = string;
        this.type = classpathEntryType;
        this.isLocalPath = !Utils.isPathAbsolute(string);
    }

    public boolean isSourceCode() {
        return this.type == ClasspathEntryType.Source || this.type == ClasspathEntryType.LibrarySource;
    }

    public boolean isJar() {
        return this.type == ClasspathEntryType.HeaderLibrary || this.type == ClasspathEntryType.ExportedLibrary;
    }

    public Path getAbsolutePath(Path path) {
        if (this.isLocalPath) {
            return path.resolve(this.path).normalize();
        }
        return Paths.get(this.path, new String[0]);
    }

    public static ClasspathEntry[] readAnything(Path path) throws ParserConfigurationException, IOException, SAXException {
        Path path2 = path.resolve(".classpath");
        if (Files.exists(path2, new LinkOption[0])) {
            System.out.println("Found eclipse classpath, parsing...");
            return ClasspathEntry.readFromEclipse(path2);
        }
        Path path3 = ClasspathEntry.findImlAt(path);
        if (path3 != null) {
            System.out.println("Found IDEA module, parsing...");
            return ClasspathEntry.readFromIml(path3);
        }
        System.out.println("Found no configurations, thinking up project structure from files...");
        return ClasspathEntry.readFromConfigless(path);
    }

    public static ClasspathEntry[] readFromEclipse(Path path) throws ParserConfigurationException, IOException, SAXException {
        DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        ArrayList<ClasspathEntry> arrayList = new ArrayList<ClasspathEntry>();
        Document document = documentBuilder.parse(path.toFile());
        NodeList nodeList = document.getElementsByTagName("classpathentry");
        for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
            Element element = (Element)nodeList.item(i2);
            String string = element.getAttribute("kind");
            String string2 = element.getAttribute("path");
            if ("src".equals(string)) {
                if (string2.endsWith("res")) {
                    arrayList.add(new ClasspathEntry(string2, ClasspathEntryType.Resource));
                    continue;
                }
                if (string2.startsWith("lib")) {
                    arrayList.add(new ClasspathEntry(string2, ClasspathEntryType.LibrarySource));
                    continue;
                }
                arrayList.add(new ClasspathEntry(string2, ClasspathEntryType.Source));
                continue;
            }
            if (!"lib".equals(string)) continue;
            if ("true".equals(element.getAttribute("exported"))) {
                arrayList.add(new ClasspathEntry(string2, ClasspathEntryType.ExportedLibrary));
                continue;
            }
            arrayList.add(new ClasspathEntry(string2, ClasspathEntryType.HeaderLibrary));
        }
        return arrayList.toArray(new ClasspathEntry[0]);
    }

    public static ClasspathEntry[] readFromIml(Path path) throws ParserConfigurationException, IOException, SAXException {
        Object object;
        Object object2;
        Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(path.toFile());
        ArrayList<ClasspathEntry> arrayList = new ArrayList<ClasspathEntry>();
        NodeList nodeList = document.getElementsByTagName("orderEntry");
        for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
            Element element = (Element)nodeList.item(i2);
            if (!"module-library".equals(element.getAttribute("type"))) continue;
            object2 = element.hasAttribute("exported") && element.getAttribute("exported").isEmpty() ? ClasspathEntryType.ExportedLibrary : ClasspathEntryType.HeaderLibrary;
            object = (Element)element.getElementsByTagName("library").item(0);
            Element element2 = (Element)object.getElementsByTagName("CLASSES").item(0);
            NodeList nodeList2 = element2.getElementsByTagName("root");
            for (int i3 = 0; i3 < nodeList2.getLength(); ++i3) {
                String string;
                Element element3 = (Element)nodeList2.item(i3);
                String string2 = element3.getAttribute("url");
                if (string2.startsWith("jar://$MODULE_DIR$/")) {
                    string = string2.substring("jar://$MODULE_DIR$/".length(), string2.length() - 2);
                    arrayList.add(new ClasspathEntry(string, (ClasspathEntryType)((Object)object2), true));
                    continue;
                }
                if (string2.startsWith("jar://")) {
                    string = string2.substring("jar://".length(), string2.length() - 2);
                    arrayList.add(new ClasspathEntry(string, (ClasspathEntryType)((Object)object2), false));
                    continue;
                }
                throw new RuntimeException("Unknown library entry: " + string2);
            }
        }
        NodeList nodeList3 = document.getElementsByTagName("sourceFolder");
        for (int i4 = 0; i4 < nodeList3.getLength(); ++i4) {
            object2 = (Element)nodeList3.item(i4);
            object = object2.getAttribute("url");
            if (((String)object).startsWith("file://$MODULE_DIR$/")) {
                object = ((String)object).substring("file://$MODULE_DIR$/".length());
            } else if (((String)object).startsWith("file://")) {
                object = ((String)object).substring("file://".length());
            } else {
                throw new IllegalArgumentException("Unknown source folder entry: " + (String)object);
            }
            if (object2.getAttribute("type").equals("java-resource")) {
                arrayList.add(new ClasspathEntry((String)object, ClasspathEntryType.Resource));
                continue;
            }
            if (((String)object).startsWith("lib")) {
                arrayList.add(new ClasspathEntry((String)object, ClasspathEntryType.LibrarySource));
                continue;
            }
            arrayList.add(new ClasspathEntry((String)object, ClasspathEntryType.Source));
        }
        return arrayList.toArray(new ClasspathEntry[0]);
    }

    public static ClasspathEntry[] readFromConfigless(Path path) {
        Path path2;
        File[] fileArray;
        ArrayList<ClasspathEntry> arrayList = new ArrayList<ClasspathEntry>();
        arrayList.add(new ClasspathEntry("src", ClasspathEntryType.Source, true));
        if (Files.exists(path.resolve("res"), new LinkOption[0])) {
            arrayList.add(new ClasspathEntry("res", ClasspathEntryType.Resource, true));
        }
        if ((fileArray = (path2 = path.resolve("lib")).toFile().listFiles()) != null) {
            for (File file : fileArray) {
                if (file.isFile() && file.getName().endsWith(".jar")) {
                    arrayList.add(new ClasspathEntry("lib/" + file.getName(), ClasspathEntryType.ExportedLibrary, true));
                }
                if (!file.isDirectory()) continue;
                if (Files.exists(path.resolve("lib").resolve(file.getName()).resolve("src"), new LinkOption[0])) {
                    arrayList.add(new ClasspathEntry("lib/" + file.getName() + "/src", ClasspathEntryType.LibrarySource, true));
                }
                if (!Files.exists(path.resolve("lib").resolve(file.getName()).resolve("res"), new LinkOption[0])) continue;
                arrayList.add(new ClasspathEntry("lib/" + file.getName() + "/res", ClasspathEntryType.Resource, true));
            }
        }
        return arrayList.toArray(new ClasspathEntry[0]);
    }

    public static Path findImlAt(Path path) {
        Path path2 = null;
        for (File file : path.toFile().listFiles()) {
            if (!file.getName().endsWith(".iml")) continue;
            if (path2 != null) {
                throw new IllegalArgumentException("KEmulator-based IDEA projects are expected to have single IML file, two found.");
            }
            path2 = Paths.get(file.getAbsolutePath(), new String[0]);
        }
        return path2;
    }
}

